# include "ShowDefs.h"
# include "yyShowDefs.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 23 "ShowDefs.puma"


# include "Idents.h"
# include "StringMem.h"

# include "StrUnparse.h"
# include "Unparse.h"
# include "Rank.h"

# define MODULE "ShowDefs"

FILE *SemFile;



static void yyExit () { Exit (1); }

void (* ShowDefs_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ShowDefs, routine %s failed\n", yyFunction);
 ShowDefs_Exit ();
}

void ShowDeclarations ARGS((tDefinitions d));
static void ShowDynamic ARGS((int kind));
static void ShowType ARGS((tTree t));
void ShowDistribution ARGS((tDefinitions distribution));
static void ShowTop ARGS((tDefinitions top_obj));
static void ShowDimList ARGS((tDefinitions dim));
static void ShowUse ARGS((tDefinitions t));

void ShowDeclarations
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d)
# else
(d)
 register tDefinitions d;
# endif
{
# line 46 "ShowDefs.puma"

char string[256]; 
int varrank;

# line 51 "ShowDefs.puma"
  {
# line 53 "ShowDefs.puma"
   if (! ((d == NoDefinitions))) goto yyL1;
  }
   return;
yyL1:;

  if (d->Kind == kSCOPE_LIST) {
# line 56 "ShowDefs.puma"
  {
# line 58 "ShowDefs.puma"
   ShowDeclarations (d->SCOPE_LIST.Table);
# line 59 "ShowDefs.puma"
   ShowDeclarations (d->SCOPE_LIST.Hidden);
  }
   return;

  }
  if (d->Kind == kSCOPE_EMPTY) {
# line 62 "ShowDefs.puma"
   return;

  }
  if (d->Kind == kENTRY_LIST) {
# line 65 "ShowDefs.puma"
  {
# line 67 "ShowDefs.puma"
   ShowDeclarations (d->ENTRY_LIST.Next);
# line 68 "ShowDefs.puma"
   ShowDeclarations (d->ENTRY_LIST.Elem);
  }
   return;

  }
  if (d->Kind == kENTRY_EMPTY) {
# line 71 "ShowDefs.puma"
   return;

  }
  if (Definitions_IsType (d, kObject)) {
# line 74 "ShowDefs.puma"
  {
# line 76 "ShowDefs.puma"
   if (! ((d->Object.Ident == DefaultId ()))) goto yyL6;
  {
# line 77 "ShowDefs.puma"
   fprintf (SemFile, "default", string);
  }
  }
   return;
yyL6:;

# line 80 "ShowDefs.puma"
  {
# line 82 "ShowDefs.puma"
   GetString (d->Object.Ident, string);
# line 83 "ShowDefs.puma"
   fprintf (SemFile, "%s", string);
# line 85 "ShowDefs.puma"
 if (d->Object.in != NoObject)
       { GetString (d->Object.in->Object.Ident, string);
         fprintf (SemFile, " (in %s)", string);
       }
      else
         fprintf (SemFile, "(-)");
   
# line 93 "ShowDefs.puma"
   fprintf (SemFile, " : ");
# line 94 "ShowDefs.puma"
   goto yyL7;
  }
yyL7:;

  }
  if (d->Kind == kProcObject) {
  if (d->ProcObject.decl->Kind == kPROC_DECL) {
# line 97 "ShowDefs.puma"
  {
# line 99 "ShowDefs.puma"
   if (! ((d->ProcObject.Kind == UserRoutine))) goto yyL8;
  {
# line 100 "ShowDefs.puma"
   fprintf (SemFile, "user/external subroutine\n");
  }
  }
   return;
yyL8:;

# line 103 "ShowDefs.puma"
  {
# line 104 "ShowDefs.puma"
   if (! ((d->ProcObject.Kind == DummyRoutine))) goto yyL9;
  {
# line 105 "ShowDefs.puma"
   fprintf (SemFile, "dummy subroutine\n");
  }
  }
   return;
yyL9:;

# line 108 "ShowDefs.puma"
  {
# line 110 "ShowDefs.puma"
   if (! ((d->ProcObject.Kind == ModuleRoutine))) goto yyL10;
  {
# line 111 "ShowDefs.puma"
   fprintf (SemFile, "module subroutine\n");
  }
  }
   return;
yyL10:;

  }
  if (d->ProcObject.decl->Kind == kINTRINSIC_DECL) {
# line 114 "ShowDefs.puma"
  {
# line 116 "ShowDefs.puma"
   fprintf (SemFile, "intrinsic subroutine\n");
  }
   return;

  }
# line 119 "ShowDefs.puma"
  {
# line 121 "ShowDefs.puma"
   fprintf (SemFile, "unknown proc object\n", string);
# line 122 "ShowDefs.puma"
   FileUnparse (SemFile, d->ProcObject.decl);
# line 123 "ShowDefs.puma"
   WriteTree (SemFile, d->ProcObject.decl);
  }
   return;

  }
  if (d->Kind == kFuncObject) {
  if (d->FuncObject.decl->Kind == kFUNC_DECL) {
# line 126 "ShowDefs.puma"
  {
# line 128 "ShowDefs.puma"
   if (! ((d->FuncObject.Kind == UserRoutine))) goto yyL13;
  {
# line 129 "ShowDefs.puma"
   fprintf (SemFile, "user/external function\n");
  }
  }
   return;
yyL13:;

# line 132 "ShowDefs.puma"
  {
# line 134 "ShowDefs.puma"
   if (! ((d->FuncObject.Kind == DummyRoutine))) goto yyL14;
  {
# line 135 "ShowDefs.puma"
   fprintf (SemFile, "dummy function\n");
  }
  }
   return;
yyL14:;

# line 138 "ShowDefs.puma"
  {
# line 140 "ShowDefs.puma"
   if (! ((d->FuncObject.Kind == ModuleRoutine))) goto yyL15;
  {
# line 141 "ShowDefs.puma"
   fprintf (SemFile, "module function\n");
  }
  }
   return;
yyL15:;

  }
  if (d->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 144 "ShowDefs.puma"
  {
# line 146 "ShowDefs.puma"
   fprintf (SemFile, "statement function\n");
  }
   return;

  }
  if (d->FuncObject.decl->Kind == kINTRINSIC_DECL) {
# line 149 "ShowDefs.puma"
  {
# line 151 "ShowDefs.puma"
   fprintf (SemFile, "Intrinsic Function ");
# line 153 "ShowDefs.puma"
 switch (d->FuncObject.decl->INTRINSIC_DECL.class) {
       case kELEMENTAL        : fprintf (SemFile, "(elemental,"); break;
       case kTRANSFORMATIONAL : fprintf (SemFile, "(transformational,"); break;
       case kPURE             : fprintf (SemFile, "(pure,"); break;
       case kINQUIRY          : fprintf (SemFile, "(inquiry,"); break;
       default                : fprintf (SemFile, "(-,"); break;
       } 

       switch (d->FuncObject.decl->INTRINSIC_DECL.kind) {
       case kNUMERIC        : fprintf (SemFile, "numeric),"); break;
       case kMATHEMATICAL   : fprintf (SemFile, "mathematical),"); break;
       case kCHARACTER      : fprintf (SemFile, "character),"); break;
       case kKIND           : fprintf (SemFile, "kind),"); break;
       case kFLOATING       : fprintf (SemFile, "floating),"); break;
       case kREDUCTION      : fprintf (SemFile, "reduction),"); break;
       case kLOCREDUCTION   : fprintf (SemFile, "loc reduction),"); break;
       default              : fprintf (SemFile, "-)"); break;
       } 
     
  }
   return;

  }
  }
  if (d->Kind == kExternalObject) {
  if (d->ExternalObject.decl->Kind == kEXTERNAL_DECL) {
# line 174 "ShowDefs.puma"
  {
# line 176 "ShowDefs.puma"
   if (! ((d->ExternalObject.Kind == UserRoutine))) goto yyL18;
  {
# line 177 "ShowDefs.puma"
   fprintf (SemFile, "EXTERNAL (subroutine or function)\n");
  }
  }
   return;
yyL18:;

# line 180 "ShowDefs.puma"
  {
# line 182 "ShowDefs.puma"
   if (! ((d->ExternalObject.Kind == DummyRoutine))) goto yyL19;
  {
# line 183 "ShowDefs.puma"
   fprintf (SemFile, "EXTERNAL dummy (subroutine or function)\n");
  }
  }
   return;
yyL19:;

  }
  }
  if (d->Kind == kBlockObject) {
# line 186 "ShowDefs.puma"
  {
# line 188 "ShowDefs.puma"
   fprintf (SemFile, "Block Data\n");
  }
   return;

  }
  if (d->Kind == kVarObject) {
  if (d->VarObject.Kind->Kind == kVarDummy) {
# line 191 "ShowDefs.puma"
  {
# line 195 "ShowDefs.puma"
 if (d->VarObject.Kind->VarDummy.function == NoTree)
         fprintf (SemFile, "dummy, type = ");
        else
         fprintf (SemFile, "func result, type = ");
     
# line 200 "ShowDefs.puma"
   ShowType (d->VarObject.decl);
# line 201 "ShowDefs.puma"
   ShowDynamic (d->VarObject.Kind->VarDummy.dynamic);
# line 202 "ShowDefs.puma"
   varrank = VarRank (d);
# line 203 "ShowDefs.puma"
   fprintf (SemFile, ", rank = %d\n    ", varrank);
# line 204 "ShowDefs.puma"
   ShowUse (d);
# line 205 "ShowDefs.puma"
 if (d->VarObject.Kind->VarDummy.optional)
          fprintf (SemFile, " optional ", d->VarObject.Kind->VarDummy.optional);
         else
          fprintf (SemFile, " mandatory  ", d->VarObject.Kind->VarDummy.optional);
     
# line 210 "ShowDefs.puma"
   fprintf (SemFile, " intent = %d ", d->VarObject.Kind->VarDummy.Intent);
# line 211 "ShowDefs.puma"
   ShowDistribution (d->VarObject.Dist);
# line 212 "ShowDefs.puma"
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->VarObject.Kind->Kind == kVarParameter) {
# line 215 "ShowDefs.puma"
  {
# line 220 "ShowDefs.puma"
   fprintf (SemFile, "parameter, val = ");
# line 221 "ShowDefs.puma"
   FileUnparse (SemFile, d->VarObject.Kind->VarParameter.Val);
# line 222 "ShowDefs.puma"
   fprintf (SemFile, " type = ");
# line 223 "ShowDefs.puma"
   ShowType (d->VarObject.decl);
# line 224 "ShowDefs.puma"
   varrank = VarRank (d);
# line 225 "ShowDefs.puma"
   fprintf (SemFile, " rank = %d", varrank);
# line 226 "ShowDefs.puma"
   fprintf (SemFile, " uses = %d/%d/%d ", d->VarObject.uses->VarUse.ArrayUse, d->VarObject.uses->VarUse.ReadUse, d->VarObject.uses->VarUse.WriteUse);
# line 227 "ShowDefs.puma"
   ShowDistribution (d->VarObject.Dist);
# line 228 "ShowDefs.puma"
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->VarObject.Kind->Kind == kVarLocal) {
# line 231 "ShowDefs.puma"
  {
# line 235 "ShowDefs.puma"
   fprintf (SemFile, "local variable, type = ");
# line 236 "ShowDefs.puma"
   ShowType (d->VarObject.decl);
# line 237 "ShowDefs.puma"
   ShowDynamic (d->VarObject.Kind->VarLocal.dynamic);
# line 238 "ShowDefs.puma"
   varrank = VarRank (d);
# line 239 "ShowDefs.puma"
   fprintf (SemFile, ", rank = %d", varrank);
# line 240 "ShowDefs.puma"
   ShowUse (d);
# line 241 "ShowDefs.puma"
   ShowDistribution (d->VarObject.Dist);
# line 242 "ShowDefs.puma"
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->VarObject.Kind->Kind == kVarCommon) {
# line 245 "ShowDefs.puma"
  {
# line 249 "ShowDefs.puma"
   fprintf (SemFile, "common variable (in ");
# line 250 "ShowDefs.puma"
   GetString (d->VarObject.Kind->VarCommon.Block, string);
# line 251 "ShowDefs.puma"
   fprintf (SemFile, "/%s/), type = ", string);
# line 252 "ShowDefs.puma"
   ShowType (d->VarObject.decl);
# line 253 "ShowDefs.puma"
   varrank = VarRank (d);
# line 254 "ShowDefs.puma"
   fprintf (SemFile, " rank = %d", varrank);
# line 255 "ShowDefs.puma"
   ShowUse (d);
# line 256 "ShowDefs.puma"
   ShowDistribution (d->VarObject.Dist);
# line 257 "ShowDefs.puma"
   fprintf (SemFile, "\n");
  }
   return;

  }
  }
  if (d->Kind == kTypeObject) {
# line 260 "ShowDefs.puma"
  {
# line 261 "ShowDefs.puma"
   GetString (d->TypeObject.Ident, string);
# line 262 "ShowDefs.puma"
   fprintf (SemFile, "Type %s (derived)\n", string);
  }
   return;

  }
  if (d->Kind == kTemplateObject) {
# line 265 "ShowDefs.puma"
  {
# line 267 "ShowDefs.puma"
   fprintf (SemFile, "template, dim = (");
# line 268 "ShowDefs.puma"
   ShowType (d->TemplateObject.decl);
# line 269 "ShowDefs.puma"
   fprintf (SemFile, ") ");
# line 270 "ShowDefs.puma"
   ShowDistribution (d->TemplateObject.Dist);
# line 271 "ShowDefs.puma"
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->Kind == kTopologyObject) {
# line 274 "ShowDefs.puma"
  {
# line 276 "ShowDefs.puma"
   if (! ((d->TopologyObject.Ident == DefaultId ()))) goto yyL27;
  {
# line 277 "ShowDefs.puma"
   fprintf (SemFile, "default topology (rank=%d)", d->TopologyObject.rank);
  }
  }
   return;
yyL27:;

# line 280 "ShowDefs.puma"
  {
# line 282 "ShowDefs.puma"
   fprintf (SemFile, "processors, dim = (");
# line 283 "ShowDefs.puma"
   ShowType (d->TopologyObject.decl);
# line 284 "ShowDefs.puma"
   fprintf (SemFile, ")");
# line 285 "ShowDefs.puma"
 if (d->TopologyObject.target != NoTree)
         { fprintf (SemFile, " mapped to ");
           FileUnparse (SemFile, d->TopologyObject.target);
         }
     
# line 290 "ShowDefs.puma"
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->Kind == kNameListObject) {
# line 293 "ShowDefs.puma"
  {
# line 295 "ShowDefs.puma"
   fprintf (SemFile, "namelist\n");
  }
   return;

  }
  if (d->Kind == kGenericObject) {
# line 298 "ShowDefs.puma"
  {
# line 300 "ShowDefs.puma"
   fprintf (SemFile, "generic interface");
  }
   return;

  }
  if (Definitions_IsType (d, kObject)) {
# line 303 "ShowDefs.puma"
  {
# line 305 "ShowDefs.puma"
   GetString (d->Object.Ident, string);
# line 306 "ShowDefs.puma"
   fprintf (SemFile, "something\n");
  }
   return;

  }
;
}

static void ShowDynamic
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
# line 317 "ShowDefs.puma"
  {
# line 318 "ShowDefs.puma"
 if (kind == arr_fixed_size)        fprintf (SemFile, ", fixed size"); 
     else if (kind == arr_automatic )   fprintf (SemFile, ", automatic"); 
     else if (kind == arr_allocatable)  fprintf (SemFile, ", allocatable"); 
     else if (kind == arr_assumed_size) fprintf (SemFile, ", assumed size"); 
     else fprintf (SemFile, ", illegal"); 
   
  }
   return;

;
}

static void ShowType
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
# line 334 "ShowDefs.puma"
  {
# line 334 "ShowDefs.puma"
   ShowType (t->VAR_DECL.VAL);
  }
   return;

  }
  if (t->Kind == kVAR_PARAM_DECL) {
# line 335 "ShowDefs.puma"
  {
# line 335 "ShowDefs.puma"
   ShowType (t->VAR_PARAM_DECL.VAL);
  }
   return;

  }
  if (t->Kind == kTEMPLATE_DECL) {
# line 336 "ShowDefs.puma"
  {
# line 336 "ShowDefs.puma"
   ShowType (t->TEMPLATE_DECL.DIMENSIONS);
  }
   return;

  }
  if (t->Kind == kPROCESSORS_DECL) {
# line 337 "ShowDefs.puma"
  {
# line 337 "ShowDefs.puma"
   ShowType (t->PROCESSORS_DECL.DIMENSIONS);
  }
   return;

  }
# line 339 "ShowDefs.puma"
  {
# line 340 "ShowDefs.puma"
   FileUnparse (SemFile, t);
  }
   return;

;
}

void ShowDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions distribution)
# else
(distribution)
 register tDefinitions distribution;
# endif
{
# line 345 "ShowDefs.puma"

char string[256]; 

  if (distribution->Kind == kDefaultDistribution) {
# line 349 "ShowDefs.puma"
  {
# line 350 "ShowDefs.puma"
   fprintf (SemFile, "default");
  }
   return;

  }
  if (distribution->Kind == kReplicatedDistribution) {
# line 353 "ShowDefs.puma"
  {
# line 354 "ShowDefs.puma"
   fprintf (SemFile, "replicated");
  }
   return;

  }
  if (distribution->Kind == kDeclDistribution) {
# line 357 "ShowDefs.puma"
  {
# line 358 "ShowDefs.puma"
   fprintf (SemFile, "is not evaluated");
  }
   return;

  }
  if (distribution->Kind == kNodeDistribution) {
# line 361 "ShowDefs.puma"
  {
# line 364 "ShowDefs.puma"
   fprintf (SemFile, "onto ");
# line 365 "ShowDefs.puma"
   ShowTop (distribution->NodeDistribution.top_obj);
# line 366 "ShowDefs.puma"
   fprintf (SemFile, ", al = <");
# line 367 "ShowDefs.puma"
   ShowDimList (distribution->NodeDistribution.ArrayList);
# line 368 "ShowDefs.puma"
   fprintf (SemFile, ">)");
  }
   return;

  }
  if (distribution->Kind == kRangeDistribution) {
# line 371 "ShowDefs.puma"
  {
# line 373 "ShowDefs.puma"
   fprintf (SemFile, ", range al = <");
# line 374 "ShowDefs.puma"
   ShowDimList (distribution->RangeDistribution.ArrayList);
# line 375 "ShowDefs.puma"
   fprintf (SemFile, ">)");
  }
   return;

  }
  if (distribution->Kind == kAlignDistribution) {
# line 378 "ShowDefs.puma"
  {
# line 381 "ShowDefs.puma"
   GetString (distribution->AlignDistribution.template_obj->Object.Ident, string);
# line 382 "ShowDefs.puma"
   fprintf (SemFile, "aligned to %s, al = <", string);
# line 383 "ShowDefs.puma"
   ShowDimList (distribution->AlignDistribution.SourceList);
# line 384 "ShowDefs.puma"
   fprintf (SemFile, ">, tl = <");
# line 385 "ShowDefs.puma"
   ShowDimList (distribution->AlignDistribution.TargetList);
# line 386 "ShowDefs.puma"
   fprintf (SemFile, ">)");
  }
   return;

  }
;
}

static void ShowTop
# if defined __STDC__ | defined __cplusplus
(register tDefinitions top_obj)
# else
(top_obj)
 register tDefinitions top_obj;
# endif
{
# line 391 "ShowDefs.puma"

char string[256];

# line 395 "ShowDefs.puma"
  {
# line 397 "ShowDefs.puma"
   if (! ((top_obj == NoObject))) goto yyL1;
  {
# line 398 "ShowDefs.puma"
   fprintf (SemFile, "*");
  }
  }
   return;
yyL1:;

  if (top_obj->Kind == kTopologyObject) {
# line 401 "ShowDefs.puma"
  {
# line 403 "ShowDefs.puma"
   if (! ((top_obj->TopologyObject.Ident == DefaultId ()))) goto yyL2;
  {
# line 404 "ShowDefs.puma"
   fprintf (SemFile, "#%d", top_obj->TopologyObject.rank);
  }
  }
   return;
yyL2:;

# line 407 "ShowDefs.puma"
  {
# line 409 "ShowDefs.puma"
   GetString (top_obj->TopologyObject.Ident, string);
# line 410 "ShowDefs.puma"
   fprintf (SemFile, "%s(%d)", string, top_obj->TopologyObject.rank);
  }
   return;

  }
;
}

static void ShowDimList
# if defined __STDC__ | defined __cplusplus
(register tDefinitions dim)
# else
(dim)
 register tDefinitions dim;
# endif
{

  switch (dim->Kind) {
  case kDIM_EMPTY:
# line 421 "ShowDefs.puma"
   return;

  case kDIM_LIST:
  if (dim->DIM_LIST.Next->Kind == kDIM_EMPTY) {
# line 424 "ShowDefs.puma"
  {
# line 425 "ShowDefs.puma"
   ShowDimList (dim->DIM_LIST.Elem);
  }
   return;

  }
# line 428 "ShowDefs.puma"
  {
# line 429 "ShowDefs.puma"
   ShowDimList (dim->DIM_LIST.Elem);
# line 430 "ShowDefs.puma"
   fprintf (SemFile, ",");
# line 431 "ShowDefs.puma"
   ShowDimList (dim->DIM_LIST.Next);
  }
   return;

  case kSerialDimension:
# line 434 "ShowDefs.puma"
  {
# line 435 "ShowDefs.puma"
   fprintf (SemFile, "*");
  }
   return;

  case kReplicatedDimension:
# line 438 "ShowDefs.puma"
  {
# line 439 "ShowDefs.puma"
   fprintf (SemFile, "+");
  }
   return;

  case kEmbeddedDimension:
# line 442 "ShowDefs.puma"
  {
# line 444 "ShowDefs.puma"
 char str[20];
     StrUnparse (str, 20, dim->EmbeddedDimension.val);
     fprintf (SemFile,"%d->%s", dim->EmbeddedDimension.dimension, str);
   
  }
   return;

  case kAlignedDimension:
# line 450 "ShowDefs.puma"
  {
# line 452 "ShowDefs.puma"
 char add_str[20], mult_str[20];

     StrUnparse (add_str, 20, dim->AlignedDimension.add);
     StrUnparse (mult_str, 20, dim->AlignedDimension.mult);

     fprintf (SemFile,"%d->%d(%s*I+%s)", dim->AlignedDimension.dimension, dim->AlignedDimension.template_dim, 
                                         mult_str, add_str);
   
  }
   return;

  case kDistributedDimension:
# line 462 "ShowDefs.puma"
  {
# line 464 "ShowDefs.puma"
 char val[20];

     switch (dim->DistributedDimension.kind) {

      case kBLOCK_DIM      : StrUnparse (val, 20, dim->DistributedDimension.size);
                             fprintf (SemFile,"block(%s)", val); break;
      case kCYCLIC_DIM     : StrUnparse (val, 20, dim->DistributedDimension.size);
                             fprintf (SemFile,"cyclic(%s)", val); break;
      case kGEN_BLOCK_DIM  : fprintf (SemFile,"gen_block", dim->DistributedDimension.size); break;

      default              : fprintf (SemFile,"?");

     } 

   
  }
   return;

  }

;
}

static void ShowUse
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
# line 489 "ShowDefs.puma"
  {
# line 491 "ShowDefs.puma"
   fprintf (SemFile, " uses = %d/%d/%d ", t->VarObject.uses->VarUse.ArrayUse, t->VarObject.uses->VarUse.ReadUse, t->VarObject.uses->VarUse.WriteUse);
  }
   return;

;
}

void BeginShowDefs ()
{
}

void CloseShowDefs ()
{
}
