# include "Shapes.h"
# include "yyShapes.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 83 "Shapes.puma"


# include "Tree.h"
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Definitions.h"
# include "Transform.h"     /* VarParamToExp */

# include "Expressions.h"   /* MakeConstant, ResolveExpression */

# include "Types.h"       /* ArrayFormals */
# include "Unparse.h"
# include "Rank.h" 
# include "Objects.h" 
# include "Intrinsics.h"    /* GetIntrinsicClass */

# define MODULE "Shapes"



static void yyExit () { Exit (1); }

void (* Shapes_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Shapes, routine %s failed\n", yyFunction);
 Shapes_Exit ();
}

void GetFormalShape ARGS((tTree t, shape s));
static void GetFormalShapeObj ARGS((tDefinitions t, tTree reach_info, shape s));
static void GetFormalShapeList ARGS((tTree t, shape s, int n));
void PrintShape ARGS((shape s));
tTree MakeShapedVar ARGS((tTree var, shape shp));
tTree MakeFullShape ARGS((tTree t));
static void MakeFullIndexShape ARGS((tTree t, shape s, int n));
static tTree GetShapeExp ARGS((shape s, int dim, int kind));
static tTree TranslateVar ARGS((tTree var));
bool IsWholeVar ARGS((tTree t));
static bool FullIndexSlices ARGS((tTree t, shape s, int n));
static bool FullIndexSlice ARGS((tTree t, shape s, int n));
static bool IsBoundExp ARGS((tTree actual, tTree formal, tTree var, int dim, int kind));
tTree NormalizeShape ARGS((tTree t));
bool IsContiguousSection ARGS((tTree t));
static bool IsContiguousShape ARGS((tTree t, shape s, int n));
static bool SingleIndexes ARGS((tTree indexes));
void GetActualShape ARGS((tTree t, shape s));
static void GetArrayExpressionRange ARGS((tTree elem, tTree * yyP3, tTree * yyP2, tTree * yyP1));
static void UpdateActualShape ARGS((tTree indexes, shape s, int n));
static void NormalActualSlice ARGS((tTree exp, tTree * yyP6, tTree * yyP5, tTree * yyP4));
static bool IsMultiply ARGS((tTree exp, int c, int * yyP7));
static shape MakeBestShape ARGS((shape s1, shape s2));
static bool IsItAStride1 ARGS((tTree t));

void GetFormalShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
# line 116 "Shapes.puma"
  {
# line 118 "Shapes.puma"
   GetFormalShape (t->INDEXED_VAR.IND_VAR, s);
  }
   return;

  }
  if (t->Kind == kSELECTED_VAR) {
# line 121 "Shapes.puma"
  {
# line 123 "Shapes.puma"
   GetFormalShapeObj (t->SELECTED_VAR.SELECTOR->REC_COMP.Object, NoTree, s);
# line 125 "Shapes.puma"
 s->var = t; 
  }
   return;

  }
  if (t->Kind == kUSED_VAR) {
# line 128 "Shapes.puma"
  {
# line 130 "Shapes.puma"
   GetFormalShape (t->USED_VAR.VARNAME, s);
# line 132 "Shapes.puma"
 s->var = t; 
  }
   return;

  }
  if (t->Kind == kVAR_OBJ) {
# line 135 "Shapes.puma"
  {
# line 137 "Shapes.puma"
   GetFormalShapeObj (t->VAR_OBJ.Object, t->VAR_OBJ.Reaching, s);
# line 139 "Shapes.puma"
 s->var = NoTree; 
  }
   return;

  }
# line 142 "Shapes.puma"
  {
# line 144 "Shapes.puma"
   failure_protocol (MODULE, "GetFormalShape", t);
  }
   return;

;
}

static void GetFormalShapeObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t, register tTree reach_info, shape s)
# else
(t, reach_info, s)
 register tDefinitions t;
 register tTree reach_info;
 shape s;
# endif
{
# line 157 "Shapes.puma"
  {
# line 159 "Shapes.puma"
   if (! ((VarRank (t) == 0))) goto yyL1;
  {
# line 161 "Shapes.puma"
 s->rank = 0; 
  }
  }
   return;
yyL1:;

# line 164 "Shapes.puma"
  {
# line 166 "Shapes.puma"
   if (! ((reach_info == NoTree))) goto yyL2;
  {
# line 168 "Shapes.puma"
   GetFormalShapeList (ArrayFormals (t), s, 1);
  }
  }
   return;
yyL2:;

  if (reach_info->Kind == kREACHING_INFO) {
# line 171 "Shapes.puma"
  {
# line 173 "Shapes.puma"
   if (! ((reach_info->REACHING_INFO.var_allocate == NoTree))) goto yyL3;
  {
# line 175 "Shapes.puma"
   GetFormalShapeList (ArrayFormals (t), s, 1);
  }
  }
   return;
yyL3:;

# line 178 "Shapes.puma"
  {
# line 180 "Shapes.puma"
   GetFormalShapeList (reach_info->REACHING_INFO.var_allocate, s, 1);
  }
   return;

  }
# line 183 "Shapes.puma"
  {
# line 185 "Shapes.puma"
   failure_protocol (MODULE, "GetFormalShapeObj", reach_info);
  }
   return;

;
}

static void GetFormalShapeList
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{

  switch (t->Kind) {
  case kBTE_LIST:
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 190 "Shapes.puma"
  {
# line 192 "Shapes.puma"
   GetFormalShapeList (t->BTE_LIST.Elem, s, n);
  }
   return;

  }
# line 200 "Shapes.puma"
  {
# line 202 "Shapes.puma"
   GetFormalShapeList (t->BTE_LIST.Elem, s, n);
# line 203 "Shapes.puma"
   GetFormalShapeList (t->BTE_LIST.Next, s, n + 1);
  }
   return;

  case kSHAPE_LIST:
  if (t->SHAPE_LIST.Next->Kind == kSHAPE_EMPTY) {
# line 195 "Shapes.puma"
  {
# line 197 "Shapes.puma"
   GetFormalShapeList (t->SHAPE_LIST.Elem, s, n);
  }
   return;

  }
# line 206 "Shapes.puma"
  {
# line 208 "Shapes.puma"
   GetFormalShapeList (t->SHAPE_LIST.Elem, s, n);
# line 209 "Shapes.puma"
   GetFormalShapeList (t->SHAPE_LIST.Next, s, n + 1);
  }
   return;

  case kEXPLICIT_SHAPE:
# line 212 "Shapes.puma"
  {
# line 214 "Shapes.puma"
 s->rank = n;
      s->bounds[n-1][0] = t->EXPLICIT_SHAPE.LOWER;
      s->bounds[n-1][1] = t->EXPLICIT_SHAPE.UPPER;
      s->bounds[n-1][2] = NoTree;
    
  }
   return;

  case kASSUMED_SIZE:
# line 221 "Shapes.puma"
  {
# line 223 "Shapes.puma"
 s->rank = n;
      s->bounds[n-1][0] = t->ASSUMED_SIZE.LOWER;        
      s->bounds[n-1][1] = (tTree) 1;  
      s->bounds[n-1][2] = NoTree;     
    
  }
   return;

  case kASSUMED_SHAPE:
# line 230 "Shapes.puma"
  {
# line 232 "Shapes.puma"
 s->rank = n;
      s->bounds[n-1][0] = t->ASSUMED_SHAPE.LOWER;        
      s->bounds[n-1][1] = NoTree;     
      s->bounds[n-1][2] = NoTree;     
    
  }
   return;

  case kSHAPE_SPEC:
  case kDEFERRED_SHAPE:
# line 239 "Shapes.puma"
  {
# line 241 "Shapes.puma"
 s->rank = n;
      s->bounds[n-1][0] = NoTree;    
      s->bounds[n-1][1] = NoTree;    
      s->bounds[n-1][2] = NoTree;    
    
  }
   return;

  case kSLICE_EXP:
# line 248 "Shapes.puma"
  {
# line 250 "Shapes.puma"
 s->rank = n;
      s->bounds[n-1][0] = t->SLICE_EXP.START;
      s->bounds[n-1][1] = t->SLICE_EXP.STOP;
      s->bounds[n-1][2] = NoTree;
    
  }
   return;

  }

# line 257 "Shapes.puma"
  {
# line 258 "Shapes.puma"
   failure_protocol ("Shapes", "GetFormalShapeList", t);
  }
   return;

;
}

void PrintShape
# if defined __STDC__ | defined __cplusplus
(shape s)
# else
(s)
 shape s;
# endif
{
# line 269 "Shapes.puma"
  {
# line 271 "Shapes.puma"
 int i;

    printf ("Shape is : \n");

    for (i=0;i<s->rank;i++)
     { FileUnparse (stdout, s->bounds[i][0]);
       printf (" - ");
       FileUnparse (stdout, s->bounds[i][1]);
       if (s->bounds[i][2] != NoTree)
         { printf (" step ");
           FileUnparse (stdout, s->bounds[i][2]);
         }
       printf ("\n");
     }
  
  }
   return;

;
}

tTree MakeShapedVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, shape shp)
# else
(var, shp)
 register tTree var;
 shape shp;
# endif
{
# line 298 "Shapes.puma"

int i;
tTree ind, slice;

# line 303 "Shapes.puma"
  {
# line 305 "Shapes.puma"
 ind = mBTE_EMPTY ();
     for (i=shp->rank; i>0; i--)
       { slice = mSLICE_EXP (GetShapeExp (shp, i, 0), 
                             GetShapeExp (shp, i, 1),
                             mDUMMY_EXP());
         ind = mBTE_LIST (slice, ind);
       }
   
  }
   return mINDEXED_VAR (var, ind);

}

tTree MakeFullShape
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 334 "Shapes.puma"

struct_shape shp;

  if (t->Kind == kLOOP_VAR) {
# line 338 "Shapes.puma"
   return t;

  }
  if (t->Kind == kUSED_VAR) {
# line 343 "Shapes.puma"
  {
# line 344 "Shapes.puma"
   if (! ((VarRank (t->USED_VAR.VARNAME->VAR_OBJ.Object) == 0))) goto yyL2;
  }
   return t;
yyL2:;

# line 348 "Shapes.puma"
  {
# line 350 "Shapes.puma"
   GetFormalShape (t, & shp);
  }
   return MakeShapedVar (t, & shp);

  }
  if (t->Kind == kSELECTED_VAR) {
# line 354 "Shapes.puma"
  {
# line 355 "Shapes.puma"
   if (! ((VarRank (t->SELECTED_VAR.SELECTOR->REC_COMP.Object) == 0))) goto yyL4;
  }
   return t;
yyL4:;

# line 359 "Shapes.puma"
  {
# line 360 "Shapes.puma"
   GetFormalShape (t, & shp);
  }
   return MakeShapedVar (t, & shp);

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 364 "Shapes.puma"
  {
# line 366 "Shapes.puma"
   GetFormalShape (t, & shp);
# line 367 "Shapes.puma"
   MakeFullIndexShape (t->INDEXED_VAR.IND_EXPS, & shp, 1);
  }
   return t;

  }
  if (t->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
# line 371 "Shapes.puma"
  {
# line 373 "Shapes.puma"
   GetFormalShape (t, & shp);
# line 374 "Shapes.puma"
   MakeFullIndexShape (t->INDEXED_VAR.IND_EXPS, & shp, 1);
  }
   return t;

  }
  }
# line 378 "Shapes.puma"
  {
# line 379 "Shapes.puma"
   failure_protocol (MODULE, "MakeFullShape", t);
  }
   return t;

}

static void MakeFullIndexShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 391 "Shapes.puma"
  {
# line 393 "Shapes.puma"
 if (t->BTE_LIST.Elem->SLICE_EXP.START->Kind == kDUMMY_EXP)
        t->BTE_LIST.Elem->SLICE_EXP.START = GetShapeExp (s, n, 0);
     if (t->BTE_LIST.Elem->SLICE_EXP.STOP->Kind == kDUMMY_EXP)
        t->BTE_LIST.Elem->SLICE_EXP.STOP  = GetShapeExp (s, n, 1);
   
# line 398 "Shapes.puma"
   MakeFullIndexShape (t->BTE_LIST.Next, s, n + 1);
  }
   return;

  }
# line 401 "Shapes.puma"
  {
# line 403 "Shapes.puma"
   MakeFullIndexShape (t->BTE_LIST.Next, s, n + 1);
  }
   return;

  }
  if (t->Kind == kBTE_EMPTY) {
# line 406 "Shapes.puma"
   return;

  }
;
}

static tTree GetShapeExp
# if defined __STDC__ | defined __cplusplus
(shape s, register int dim, register int kind)
# else
(s, dim, kind)
 shape s;
 register int dim;
 register int kind;
# endif
{
# line 417 "Shapes.puma"
 {
  tTree exp;
  {
# line 419 "Shapes.puma"

# line 421 "Shapes.puma"
 exp = s->bounds[dim-1][kind];

     if (exp == (tTree) 1 )  

       { exp = mBOUND_EXP (TranslateVar (s->var), dim, kind, 0); 
                
         error_protocol ("illegal array access on assumed-size array");
       }

      else if (exp == NoTree)
       exp = mBOUND_EXP (TranslateVar (s->var), dim, kind, 0);
   
  }
  {
   return exp;
  }
 }

}

static tTree TranslateVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 439 "Shapes.puma"
   return var;

}

bool IsWholeVar
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 480 "Shapes.puma"

struct_shape shp;
bool is;

  if (t->Kind == kUSED_VAR) {
# line 485 "Shapes.puma"
   return true;

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 488 "Shapes.puma"
  {
# line 490 "Shapes.puma"
 GetFormalShape (t, &shp);
     is = FullIndexSlices (t->INDEXED_VAR.IND_EXPS, &shp, 0);
   
# line 493 "Shapes.puma"
   if (! ((is))) goto yyL2;
  }
   return true;
yyL2:;

  }
# line 496 "Shapes.puma"
  {
# line 497 "Shapes.puma"
   return false;
  }

  }
  if (t->Kind == kSELECTED_VAR) {
# line 500 "Shapes.puma"
  {
# line 501 "Shapes.puma"
   return false;
  }

  }
# line 504 "Shapes.puma"
  {
# line 505 "Shapes.puma"
   failure_protocol ("Shapes", "IsWholeVar", t);
  }
   return true;

}

static bool FullIndexSlices
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
# line 516 "Shapes.puma"

bool is;
int val;

  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 521 "Shapes.puma"
  {
# line 526 "Shapes.puma"
   if (! (FullIndexSlice (t->BTE_LIST.Elem, s, n))) goto yyL1;
  {
# line 527 "Shapes.puma"
   if (! (FullIndexSlices (t->BTE_LIST.Next, s, n + 1))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  }
  if (t->Kind == kBTE_EMPTY) {
# line 530 "Shapes.puma"
   return true;

  }
  return false;
}

static bool FullIndexSlice
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
# line 535 "Shapes.puma"

bool is;
int val;

  if (t->Kind == kSLICE_EXP) {
# line 540 "Shapes.puma"
  {
# line 544 "Shapes.puma"
 is = IsBoundExp (t->SLICE_EXP.START, s->bounds[n][0], s->var, n+1, 0);
     if (is)
       is = IsBoundExp (t->SLICE_EXP.STOP, s->bounds[n][1], s->var, n+1, 1);
     if (is)
        { SliceIncrement (t, &is, &val);
          if (is) is = (val == 1);
        }
   
# line 552 "Shapes.puma"
   if (! ((is))) goto yyL1;
  }
   return true;
yyL1:;

  }
  return false;
}

static bool IsBoundExp
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree formal, register tTree var, register int dim, register int kind)
# else
(actual, formal, var, dim, kind)
 register tTree actual;
 register tTree formal;
 register tTree var;
 register int dim;
 register int kind;
# endif
{
  if (actual->Kind == kDUMMY_EXP) {
# line 564 "Shapes.puma"
   return true;

  }
  if (actual->Kind == kBOUND_EXP) {
# line 567 "Shapes.puma"
  {
# line 569 "Shapes.puma"
   if (! ((formal == NoTree))) goto yyL2;
  {
# line 570 "Shapes.puma"
   if (! ((kind == actual->BOUND_EXP.kind))) goto yyL2;
  {
# line 571 "Shapes.puma"
   if (! ((dim == actual->BOUND_EXP.dim))) goto yyL2;
  {
# line 572 "Shapes.puma"
   if (! ((actual->BOUND_EXP.local == 0))) goto yyL2;
  {
# line 574 "Shapes.puma"
   if (! ((EqualExpression (var, actual->BOUND_EXP.VAR)))) goto yyL2;
  }
  }
  }
  }
  }
   return true;
yyL2:;

  }
# line 577 "Shapes.puma"
  {
# line 579 "Shapes.puma"
   if (! ((formal == NoTree))) goto yyL3;
  {
# line 580 "Shapes.puma"
   return false;
  }
  }
yyL3:;

# line 583 "Shapes.puma"
  {
# line 585 "Shapes.puma"
   if (! ((EqualExpression (actual, formal)))) goto yyL4;
  }
   return true;
yyL4:;

  return false;
}

tTree NormalizeShape
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 599 "Shapes.puma"

tTree newvar;

  if (t->Kind == kUSED_VAR) {
# line 603 "Shapes.puma"
   return t;

  }
  if (t->Kind == kINDEXED_VAR) {
# line 607 "Shapes.puma"
  {
# line 608 "Shapes.puma"
 if (IsWholeVar(t))
       newvar = t->INDEXED_VAR.IND_VAR;
      else
       newvar = MakeFullShape (t);
   
  }
   return newvar;

  }
  if (t->Kind == kVAR_EXP) {
# line 616 "Shapes.puma"
  {
# line 617 "Shapes.puma"
 t->VAR_EXP.V = NormalizeShape (t->VAR_EXP.V); 
  }
   return t;

  }
# line 621 "Shapes.puma"
   return t;

}

bool IsContiguousSection
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 641 "Shapes.puma"

struct_shape s;

  if (t->Kind == kUSED_VAR) {
# line 645 "Shapes.puma"
   return true;

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 648 "Shapes.puma"
  {
# line 650 "Shapes.puma"
 GetFormalShape (t, &s); 
# line 651 "Shapes.puma"
   if (! (IsContiguousShape (t->INDEXED_VAR.IND_EXPS, & s, 0))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  return false;
}

static bool IsContiguousShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
# line 656 "Shapes.puma"

bool is;
int val;

  if (t->Kind == kBTE_EMPTY) {
# line 661 "Shapes.puma"
   return true;

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 664 "Shapes.puma"
  {
# line 666 "Shapes.puma"
   if (! (FullIndexSlice (t->BTE_LIST.Elem, s, n))) goto yyL2;
  {
# line 667 "Shapes.puma"
   if (! (IsContiguousShape (t->BTE_LIST.Next, s, n + 1))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 670 "Shapes.puma"
  {
# line 672 "Shapes.puma"
   if (! (SingleIndexes (t->BTE_LIST.Next))) goto yyL3;
  {
# line 673 "Shapes.puma"
 SliceIncrement (t->BTE_LIST.Elem, &is, &val); 
# line 674 "Shapes.puma"
   if (! (is)) goto yyL3;
  {
# line 675 "Shapes.puma"
   if (! (val == 1)) goto yyL3;
  }
  }
  }
   return true;
yyL3:;

  }
# line 678 "Shapes.puma"
  {
# line 679 "Shapes.puma"
   if (! (SingleIndexes (t->BTE_LIST.Next))) goto yyL4;
  }
   return true;
yyL4:;

  }
  return false;
}

static bool SingleIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes)
# else
(indexes)
 register tTree indexes;
# endif
{
  if (indexes->Kind == kBTE_EMPTY) {
# line 692 "Shapes.puma"
   return true;

  }
  if (indexes->Kind == kBTE_LIST) {
# line 695 "Shapes.puma"
  {
# line 696 "Shapes.puma"
   if (! ((TreeRank (indexes->BTE_LIST.Elem) == 0))) goto yyL2;
  {
# line 697 "Shapes.puma"
   if (! (SingleIndexes (indexes->BTE_LIST.Next))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  return false;
}

void GetActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
# line 722 "Shapes.puma"

int i;
struct_shape s2;


  switch (t->Kind) {
  case kACF_WHERE:
# line 731 "Shapes.puma"
  {
# line 733 "Shapes.puma"
   GetActualShape (t->ACF_WHERE.WHERE_EXP, s);
# line 734 "Shapes.puma"
   GetActualShape (t->ACF_WHERE.TRUE_PART, & s2);
# line 735 "Shapes.puma"
   s = MakeBestShape (s, & s2);
# line 736 "Shapes.puma"
   GetActualShape (t->ACF_WHERE.FALSE_PART, & s2);
# line 737 "Shapes.puma"
   s = MakeBestShape (s, & s2);
  }
   return;

  case kACF_LIST:
# line 740 "Shapes.puma"
  {
# line 742 "Shapes.puma"
   GetActualShape (t->ACF_LIST.Elem, s);
# line 743 "Shapes.puma"
   GetActualShape (t->ACF_LIST.Next, & s2);
# line 744 "Shapes.puma"
   s = MakeBestShape (s, & s2);
  }
   return;

  case kACF_EMPTY:
# line 747 "Shapes.puma"
  {
# line 748 "Shapes.puma"
 s->rank = 0; 
  }
   return;

  case kACF_BASIC:
# line 751 "Shapes.puma"
  {
# line 753 "Shapes.puma"
   GetActualShape (t->ACF_BASIC.BASIC_STMT, s);
  }
   return;

  case kASSIGN_STMT:
# line 756 "Shapes.puma"
  {
# line 758 "Shapes.puma"
   GetActualShape (t->ASSIGN_STMT.ASSIGN_VAR, s);
# line 759 "Shapes.puma"
   GetActualShape (t->ASSIGN_STMT.ASSIGN_EXP, & s2);
# line 760 "Shapes.puma"
   s = MakeBestShape (s, & s2);
  }
   return;

  case kOP_EXP:
# line 767 "Shapes.puma"
  {
# line 769 "Shapes.puma"
   GetActualShape (t->OP_EXP.OPND1, s);
# line 770 "Shapes.puma"
   GetActualShape (t->OP_EXP.OPND2, & s2);
# line 771 "Shapes.puma"
   s = MakeBestShape (s, & s2);
  }
   return;

  case kOP1_EXP:
# line 774 "Shapes.puma"
  {
# line 776 "Shapes.puma"
   GetActualShape (t->OP1_EXP.OPND, s);
  }
   return;

  case kCONST_EXP:
# line 779 "Shapes.puma"
  {
# line 780 "Shapes.puma"
 s->rank = 0; 
  }
   return;

  case kADDR:
# line 783 "Shapes.puma"
  {
# line 784 "Shapes.puma"
   GetActualShape (t->ADDR.E, s);
  }
   return;

  case kARRAY_EXP:
  if (t->ARRAY_EXP.ELEMENTS->Kind == kBTE_LIST) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 793 "Shapes.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 795 "Shapes.puma"
   GetArrayExpressionRange (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem, & yyV1, & yyV2, & yyV3);
# line 797 "Shapes.puma"
 
     s->rank = 1;
     s->bounds[0][0] = yyV1;
     s->bounds[0][1] = yyV2;
     s->bounds[0][2] = yyV3;
     s->perm[0] = 1; 
   
  }
   return;
 }

  }
  }
# line 806 "Shapes.puma"
  {
# line 808 "Shapes.puma"
   error_protocol ("array expression cannot become a loop");
# line 809 "Shapes.puma"
   tree_error_protocol ("illegal array expression", t);
# line 813 "Shapes.puma"
 s->rank = 0; 
  }
   return;

  case kFUNC_CALL_EXP:
# line 816 "Shapes.puma"
  {
# line 818 "Shapes.puma"
   if (! ((IsIntrCall (t)))) goto yyL12;
  {
# line 819 "Shapes.puma"
   if (! ((GetIntrinsicClass (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object) == kELEMENTAL))) goto yyL12;
  {
# line 823 "Shapes.puma"
   GetActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS, s);
  }
  }
  }
   return;
yyL12:;

  if (t->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
# line 830 "Shapes.puma"
  {
# line 833 "Shapes.puma"
   if (! ((IsIntrCall (t)))) goto yyL13;
  {
# line 834 "Shapes.puma"
   if (! ((IsIdent ("TRANSPOSE") == t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))) goto yyL13;
  {
# line 836 "Shapes.puma"
   GetActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, s);
# line 840 "Shapes.puma"
 for (i=0; i<2; i++)

      { tTree help;

        help = s->bounds[0][i]; 
        s->bounds[0][i] = s->bounds[1][i];
        s->bounds[1][i] = help;
      }
   
  }
  }
  }
   return;
yyL13:;

  }
  if (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 855 "Shapes.puma"
 {
  bool found;
  int val;
  {
# line 858 "Shapes.puma"
   if (! ((IsIntrCall (t)))) goto yyL14;
  {
# line 859 "Shapes.puma"
   if (! ((IsIdent ("SPREAD") == t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))) goto yyL14;
  {
# line 863 "Shapes.puma"

# line 864 "Shapes.puma"

# line 866 "Shapes.puma"
   GetIntConstValue (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, & found, & val);
# line 867 "Shapes.puma"
   if (! ((found))) goto yyL14;
  {
# line 869 "Shapes.puma"
   GetActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, s);
# line 871 "Shapes.puma"
 

     for (i=s->rank; i >= val; i--)         

       { int j; 

         for (j=0; j<3; j++) s->bounds[i][j] = s->bounds[i-1][j];

         s->perm[i] = i+1;
       }

      

      s->perm[val-1] = val;
      s->bounds[val-1][0] = MakeConstant (1);
      s->bounds[val-1][1] = VarParamToExp (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
      s->bounds[val-1][2] = NoTree;
      s->rank = s->rank + 1;
   
  }
  }
  }
  }
   return;
 }
yyL14:;

  }
  }
  }
  }
# line 892 "Shapes.puma"
  {
# line 894 "Shapes.puma"
 
     s->rank = 0;
   
  }
   return;

  case kBTP_EMPTY:
# line 906 "Shapes.puma"
  {
# line 908 "Shapes.puma"
 s->rank = 0; 
  }
   return;

  case kBTP_LIST:
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 911 "Shapes.puma"
  {
# line 913 "Shapes.puma"
   GetActualShape (t->BTP_LIST.Elem->VAR_PARAM.V, s);
# line 914 "Shapes.puma"
   GetActualShape (t->BTP_LIST.Next, & s2);
# line 915 "Shapes.puma"
   s = MakeBestShape (s, & s2);
  }
   return;

  }
# line 918 "Shapes.puma"
  {
# line 920 "Shapes.puma"
   GetActualShape (t->BTP_LIST.Next, s);
  }
   return;

  case kVAR_EXP:
# line 923 "Shapes.puma"
  {
# line 925 "Shapes.puma"
   GetActualShape (t->VAR_EXP.V, s);
  }
   return;

  }

# line 934 "Shapes.puma"
  {
# line 936 "Shapes.puma"
   if (! ((TreeRank (t) == 0))) goto yyL21;
  {
# line 937 "Shapes.puma"
 s->rank = 0; 
  }
  }
   return;
yyL21:;

  if (t->Kind == kUSED_VAR) {
# line 940 "Shapes.puma"
  {
# line 942 "Shapes.puma"
 GetFormalShape (t, s);
      
      for (i=0;i<s->rank;i++)
         s->perm[i] = i+1;
    
  }
   return;

  }
  if (t->Kind == kSELECTED_VAR) {
# line 951 "Shapes.puma"
  {
# line 953 "Shapes.puma"
   if (! ((TreeRank (t->SELECTED_VAR.SELEC_VAR) > 0))) goto yyL23;
  {
# line 955 "Shapes.puma"
   GetActualShape (t->SELECTED_VAR.SELEC_VAR, s);
  }
  }
   return;
yyL23:;

# line 958 "Shapes.puma"
  {
# line 960 "Shapes.puma"
 GetFormalShape (t, s);

      

      for (i=0;i<s->rank;i++) s->perm[i] = i+1;
    
  }
   return;

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
# line 968 "Shapes.puma"
  {
# line 970 "Shapes.puma"
   if (! ((TreeRank (t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR) != 0))) goto yyL25;
  {
# line 972 "Shapes.puma"
   GetActualShape (t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR, s);
  }
  }
   return;
yyL25:;

  }
# line 975 "Shapes.puma"
  {
# line 977 "Shapes.puma"
 GetFormalShape (t->INDEXED_VAR.IND_VAR, s);  

     s->rank = 0;
     UpdateActualShape (t->INDEXED_VAR.IND_EXPS, s, 0);  

   
  }
   return;

  }
# line 985 "Shapes.puma"
  {
# line 987 "Shapes.puma"
   failure_protocol (MODULE, "GetActualShape", t);
  }
   return;

;
}

static void GetArrayExpressionRange
# if defined __STDC__ | defined __cplusplus
(register tTree elem, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(elem, yyP3, yyP2, yyP1)
 register tTree elem;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (elem->Kind == kSLICE_EXP) {
# line 992 "Shapes.puma"
   * yyP3 = elem->SLICE_EXP.START;
   * yyP2 = elem->SLICE_EXP.STOP;
   * yyP1 = elem->SLICE_EXP.INC;
   return;

  }
  if (elem->Kind == kDO_EXP) {
# line 995 "Shapes.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 997 "Shapes.puma"
   GetArrayExpressionRange (elem->DO_EXP.RANGE, & yyV1, & yyV2, & yyV3);
  }
   * yyP3 = yyV1;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  }
# line 1000 "Shapes.puma"
  {
# line 1002 "Shapes.puma"
   error_protocol ("could not get shape of array expression");
# line 1003 "Shapes.puma"
   tree_protocol ("val is : ", elem);
  }
   * yyP3 = NoTree;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static void UpdateActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, shape s, register int n)
# else
(indexes, s, n)
 register tTree indexes;
 shape s;
 register int n;
# endif
{
# line 1020 "Shapes.puma"

int r, m;
struct_shape h_shp;

  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 1025 "Shapes.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 1029 "Shapes.puma"
   NormalActualSlice (indexes->BTE_LIST.Elem, & yyV1, & yyV2, & yyV3);
# line 1031 "Shapes.puma"
 m = s->rank;
     s->bounds[m][0] = yyV1;
     s->bounds[m][1] = yyV2;
     s->bounds[m][2] = yyV3;
     s->perm[m] = m + 1; 
     s->rank = m + 1;
   
# line 1039 "Shapes.puma"
   UpdateActualShape (indexes->BTE_LIST.Next, s, n + 1);
  }
   return;
 }

  }
# line 1042 "Shapes.puma"
  {
# line 1044 "Shapes.puma"
 r = TreeRank(indexes->BTE_LIST.Elem);
     if (r > 0)
        { 
          if (r == 1)
            { GetActualShape (indexes->BTE_LIST.Elem, &h_shp);
              if (h_shp.rank != 1)
                 error_protocol ("unknown fatal error");
              m = s->rank;
              s->bounds[m][0] = h_shp.bounds[0][0];
              s->bounds[m][1] = h_shp.bounds[0][1];
              s->bounds[m][2] = h_shp.bounds[0][2];
              s->perm[m] = m+1;  
              s->rank = m+1;
            }
           else
             error_protocol ("illegal rank in indirect addressing");
         }
   
# line 1062 "Shapes.puma"
   UpdateActualShape (indexes->BTE_LIST.Next, s, n + 1);
  }
   return;

  }
  if (indexes->Kind == kBTE_EMPTY) {
# line 1065 "Shapes.puma"
   return;

  }
# line 1068 "Shapes.puma"
  {
# line 1070 "Shapes.puma"
   failure_protocol (MODULE, "UpdateActualShape", indexes);
  }
   return;

;
}

static void NormalActualSlice
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(exp, yyP6, yyP5, yyP4)
 register tTree exp;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
  if (exp->Kind == kSLICE_EXP) {
# line 1080 "Shapes.puma"
 {
  tTree new_lb;
  tTree new_ub;
  bool found;
  int val;
  int yyV1;
  int yyV2;
  {
# line 1082 "Shapes.puma"

# line 1083 "Shapes.puma"

# line 1087 "Shapes.puma"

# line 1088 "Shapes.puma"

# line 1090 "Shapes.puma"
   SliceIncrement (exp, & found, & val);
# line 1091 "Shapes.puma"
   if (! ((found))) goto yyL1;
  {
# line 1092 "Shapes.puma"
   if (! (((val != 1) && (val != - 1)))) goto yyL1;
  {
# line 1094 "Shapes.puma"
   if (! ((IsMultiply (exp->SLICE_EXP.START, val, & yyV1)))) goto yyL1;
  {
# line 1095 "Shapes.puma"
   if (! ((IsMultiply (exp->SLICE_EXP.STOP, val, & yyV2)))) goto yyL1;
  {
# line 1096 "Shapes.puma"
   if (! ((yyV1 == yyV2))) goto yyL1;
  {
# line 1098 "Shapes.puma"
   new_lb = DivConstant (AddConstant (CopyTree (exp->SLICE_EXP.START), - yyV1), val);
# line 1099 "Shapes.puma"
   new_ub = DivConstant (AddConstant (CopyTree (exp->SLICE_EXP.STOP), - yyV1), val);
  }
  }
  }
  }
  }
  }
   * yyP6 = new_lb;
   * yyP5 = new_ub;
   * yyP4 = DivConstant (CopyTree (exp->SLICE_EXP.INC), val);
   return;
 }
yyL1:;

# line 1102 "Shapes.puma"
   * yyP6 = exp->SLICE_EXP.START;
   * yyP5 = exp->SLICE_EXP.STOP;
   * yyP4 = exp->SLICE_EXP.INC;
   return;

  }
# line 1107 "Shapes.puma"
  {
# line 1109 "Shapes.puma"
   failure_protocol (MODULE, "NomarliceSlice", exp);
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;

;
}

static bool IsMultiply
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int c, register int * yyP7)
# else
(exp, c, yyP7)
 register tTree exp;
 register int c;
 register int * yyP7;
# endif
{
# line 1115 "Shapes.puma"
 {
  int a;
  int b;
  int m;
  bool found;
  tTree var;
  {
# line 1117 "Shapes.puma"

# line 1118 "Shapes.puma"

# line 1119 "Shapes.puma"

# line 1120 "Shapes.puma"

# line 1121 "Shapes.puma"

# line 1123 "Shapes.puma"
   ResolveExpression (exp, & found, & a, & b, & var);
# line 1124 "Shapes.puma"
   if (! ((found))) goto yyL1;
  {
# line 1125 "Shapes.puma"
   if (! ((a % c == 0))) goto yyL1;
  {
# line 1127 "Shapes.puma"
 if (b >= 0) 
        m = b%c;
      else
        m = c + (b%c);
   
  }
  }
  }
   * yyP7 = m;
   return true;
 }
yyL1:;

  return false;
}

static shape MakeBestShape
# if defined __STDC__ | defined __cplusplus
(shape s1, shape s2)
# else
(s1, s2)
 shape s1;
 shape s2;
# endif
{
# line 1148 "Shapes.puma"
  {
# line 1149 "Shapes.puma"
   if (! ((s1 -> rank == 0))) goto yyL1;
  {
# line 1150 "Shapes.puma"
 *s1 = *s2; 
  }
  }
   return s1;
yyL1:;

# line 1154 "Shapes.puma"
  {
# line 1155 "Shapes.puma"
   if (! ((s2 -> rank == 0))) goto yyL2;
  }
   return s1;
yyL2:;

# line 1159 "Shapes.puma"
  {
# line 1161 "Shapes.puma"
   if (! ((s1 -> rank != s2 -> rank))) goto yyL3;
  {
# line 1162 "Shapes.puma"
   error_protocol ("illegal array statemet");
  }
  }
   return s1;
yyL3:;

# line 1166 "Shapes.puma"
  {
# line 1168 "Shapes.puma"
 int i, rank;

     rank = s1->rank;

     for (i=0; i<rank; i++)
       { if (IsItAStride1 (s1->bounds[i][2]))
            { 
            }
          else if (IsItAStride1 (s2->bounds[i][2]))
            { 
              s1->bounds[i][0] = s2->bounds[i][0];
              s1->bounds[i][1] = s2->bounds[i][1];
              s1->bounds[i][2] = s2->bounds[i][2];
            }
       }
   
  }
   return s1;

}

static bool IsItAStride1
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1195 "Shapes.puma"
  {
# line 1196 "Shapes.puma"
   if (! ((t == NoTree))) goto yyL1;
  }
   return true;
yyL1:;

  if (t->Kind == kDUMMY_EXP) {
# line 1199 "Shapes.puma"
   return true;

  }
# line 1202 "Shapes.puma"
 {
  bool found;
  int val;
  {
# line 1204 "Shapes.puma"

# line 1205 "Shapes.puma"

# line 1207 "Shapes.puma"
   GetIntConstValue (t, & found, & val);
# line 1208 "Shapes.puma"
   if (! ((found))) goto yyL3;
  {
# line 1209 "Shapes.puma"
   if (! ((val == 1))) goto yyL3;
  }
  }
   return true;
 }
yyL3:;

  return false;
}

void BeginShapes ()
{
}

void CloseShapes ()
{
}
