# include "SetDefs.h"
# include "yySetDefs.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 31 "SetDefs.puma"


# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "DefTable.h"

# include "Transform.h"     /* ExpToVarParam, ... */
# include "Types.h"         /* GetVariableType, ... */
# include "Rank.h"     
# include "Intrinsics.h"

# include "Objects.h"       /* MakeNewObject        */
# include "ChangeDefs.h"    /* MakeExternalxxxxCall */
# include "MapDefs.h"       
# include "Nesting.h"       /* GetCurrentUnitObject */ 

# define MODULE "SetDefs"

static int SubTopCounter = 0;



static void yyExit () { Exit (1); }

void (* SetDefs_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SetDefs, routine %s failed\n", yyFunction);
 SetDefs_Exit ();
}

void MakeACFDefs ARGS((tTree t));
static void MakeStmtDefs ARGS((tTree t));
static tTree MakeFuncCall ARGS((tIdent id, tTree expressions));
static tTree MakeFuncParams ARGS((tTree t));
static void MakeParamDefs ARGS((tTree t));
static tTree DefExpToParameter ARGS((tTree exp));
static void MakeProcParam ARGS((tDefinitions Obj, tTree * result));
static tTree MakeProcObj ARGS((tDefinitions Obj));
void MakeIndexDefs ARGS((tTree t));
void MakeVarDefs ARGS((tTree t));
static void MakeOnClauseDefs ARGS((tTree t));
static void MakeHomeDefs ARGS((tTree t));
static void SetSelectedCompObj ARGS((tTree sv, tTree type));
static void MakeSubstring ARGS((tTree t));
static void MySetVarObject ARGS((tTree t, tDefinitions obj));
static void SetHomeObject ARGS((tTree t, tDefinitions obj));
static void SetObjUse ARGS((tDefinitions v));
tTree CheckExp ARGS((tTree exp));
static tTree ObjTypePtr ARGS((tDefinitions v));
static tTree VarSelect ARGS((tTree var, tTree stype));
static tTree MakeTypeExp ARGS((tIdent id, tTree exps));
void MakeTopologyDef ARGS((tTree spec));
static void SetTopologyObject ARGS((tTree t, tDefinitions obj));
static void MakeSubTopology ARGS((tTree spec));

void MakeACFDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 68 "SetDefs.puma"
  {
# line 70 "SetDefs.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 71 "SetDefs.puma"
   MakeACFDefs (t->ACF_LIST.Elem);
# line 72 "SetDefs.puma"
   MakeACFDefs (t->ACF_LIST.Next);
  }
   return;

  case kACF_DUMMY:
# line 75 "SetDefs.puma"
   return;

  case kACF_EMPTY:
# line 78 "SetDefs.puma"
   return;

  case kACF_BASIC:
# line 81 "SetDefs.puma"
  {
# line 83 "SetDefs.puma"
   MakeStmtDefs (t->ACF_BASIC.BASIC_STMT);
  }
   return;

  case kACF_IF:
# line 86 "SetDefs.puma"
  {
# line 88 "SetDefs.puma"
 t->ACF_IF.IF_EXP = CheckExp (t->ACF_IF.IF_EXP); 
# line 90 "SetDefs.puma"
   MakeACFDefs (t->ACF_IF.THEN_PART);
# line 91 "SetDefs.puma"
   MakeACFDefs (t->ACF_IF.ELSE_PART);
  }
   return;

  case kACF_WHERE:
# line 94 "SetDefs.puma"
  {
# line 96 "SetDefs.puma"
 t->ACF_WHERE.WHERE_EXP = CheckExp (t->ACF_WHERE.WHERE_EXP); 
# line 98 "SetDefs.puma"
   MakeACFDefs (t->ACF_WHERE.TRUE_PART);
# line 99 "SetDefs.puma"
   MakeACFDefs (t->ACF_WHERE.FALSE_PART);
  }
   return;

  case kACF_CASE:
# line 102 "SetDefs.puma"
  {
# line 103 "SetDefs.puma"
 t->ACF_CASE.CASE_EXP = CheckExp (t->ACF_CASE.CASE_EXP); 
# line 104 "SetDefs.puma"
   MakeACFDefs (t->ACF_CASE.CASE_ALTS);
  }
   return;

  case kSELECTED_ACF_LIST:
# line 107 "SetDefs.puma"
  {
# line 108 "SetDefs.puma"
   MakeACFDefs (t->SELECTED_ACF_LIST.Elem);
# line 109 "SetDefs.puma"
   MakeACFDefs (t->SELECTED_ACF_LIST.Next);
  }
   return;

  case kSELECTED_ACF_EMPTY:
# line 112 "SetDefs.puma"
   return;

  case kSELECTED_ACF_NODE:
# line 115 "SetDefs.puma"
  {
# line 116 "SetDefs.puma"
   MakeIndexDefs (t->SELECTED_ACF_NODE.SELECT_LIST);
# line 117 "SetDefs.puma"
   MakeACFDefs (t->SELECTED_ACF_NODE.SELECT_ACFS);
  }
   return;

  case kACF_WHILE:
# line 120 "SetDefs.puma"
  {
# line 121 "SetDefs.puma"
 t->ACF_WHILE.WHILE_EXP = CheckExp (t->ACF_WHILE.WHILE_EXP); 
# line 123 "SetDefs.puma"
   MakeACFDefs (t->ACF_WHILE.WHILE_BODY);
  }
   return;

  case kACF_LOOP:
# line 126 "SetDefs.puma"
  {
# line 127 "SetDefs.puma"
   MakeACFDefs (t->ACF_LOOP.LOOP_BODY);
  }
   return;

  case kACF_DO:
# line 130 "SetDefs.puma"
  {
# line 132 "SetDefs.puma"
   MakeVarDefs (t->ACF_DO.DO_ID);
# line 133 "SetDefs.puma"
 t->ACF_DO.DO_RANGE = CheckExp (t->ACF_DO.DO_RANGE);  
# line 134 "SetDefs.puma"
   MakeACFDefs (t->ACF_DO.DO_BODY);
  }
   return;

  case kACF_FORALL:
# line 137 "SetDefs.puma"
  {
# line 139 "SetDefs.puma"
   MakeVarDefs (t->ACF_FORALL.FORALL_ID);
# line 140 "SetDefs.puma"
 t->ACF_FORALL.FORALL_RANGE = CheckExp (t->ACF_FORALL.FORALL_RANGE);  
# line 141 "SetDefs.puma"
   MakeACFDefs (t->ACF_FORALL.FORALL_BODY);
  }
   return;

  case kACF_ENTRY:
# line 144 "SetDefs.puma"
  {
# line 146 "SetDefs.puma"
   tree_error_protocol ("entry statement not supported", t);
  }
   return;

  case kACF_HOME:
# line 149 "SetDefs.puma"
  {
# line 151 "SetDefs.puma"
   MakeOnClauseDefs (t->ACF_HOME.HOME_VAR);
# line 152 "SetDefs.puma"
   MakeACFDefs (t->ACF_HOME.HOME_BODY);
  }
   return;

  case kACF_RESIDENT:
# line 155 "SetDefs.puma"
  {
# line 157 "SetDefs.puma"
   MakeVarDefs (t->ACF_RESIDENT.RESIDENT_VAR);
# line 158 "SetDefs.puma"
   MakeACFDefs (t->ACF_RESIDENT.RESIDENT_BODY);
  }
   return;

  case kACF_NEW:
# line 161 "SetDefs.puma"
  {
# line 163 "SetDefs.puma"
   MakeVarDefs (t->ACF_NEW.NEW_VAR);
# line 164 "SetDefs.puma"
   MakeACFDefs (t->ACF_NEW.NEW_BODY);
  }
   return;

  case kACF_REDUCTION:
# line 167 "SetDefs.puma"
  {
# line 169 "SetDefs.puma"
   MakeVarDefs (t->ACF_REDUCTION.REDUCTION_VAR);
# line 170 "SetDefs.puma"
   MakeACFDefs (t->ACF_REDUCTION.REDUCTION_BODY);
  }
   return;

  case kACF_TASK_REGION:
# line 173 "SetDefs.puma"
  {
# line 175 "SetDefs.puma"
   MakeACFDefs (t->ACF_TASK_REGION.TASK_BODY);
  }
   return;

  }

# line 178 "SetDefs.puma"
  {
# line 179 "SetDefs.puma"
   failure_protocol (MODULE, "MakeACFDefs", t);
  }
   return;

;
}

static void MakeStmtDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kASSIGN_STMT:
# line 190 "SetDefs.puma"
  {
# line 191 "SetDefs.puma"
   MakeVarDefs (t->ASSIGN_STMT.ASSIGN_VAR);
# line 192 "SetDefs.puma"
 t->ASSIGN_STMT.ASSIGN_EXP = CheckExp (t->ASSIGN_STMT.ASSIGN_EXP); 
  }
   return;

  case kCALL_STMT:
# line 195 "SetDefs.puma"
  {
# line 197 "SetDefs.puma"
 t->CALL_STMT.CALL_ID->PROC_OBJ.Object = GetProcObject (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, GetCurrentUnitObject ()); 
# line 199 "SetDefs.puma"
   MakeParamDefs (t->CALL_STMT.CALL_PARAMS);
  }
   return;

  case kIO_STMT:
# line 202 "SetDefs.puma"
  {
# line 204 "SetDefs.puma"
   MakeParamDefs (t->IO_STMT.IO_SPECS);
# line 205 "SetDefs.puma"
   MakeParamDefs (t->IO_STMT.IO_ITEMS);
  }
   return;

  case kGOTO_STMT:
# line 208 "SetDefs.puma"
   return;

  case kLABEL_ASSIGN_STMT:
# line 211 "SetDefs.puma"
  {
# line 212 "SetDefs.puma"
   MakeVarDefs (t->LABEL_ASSIGN_STMT.LABEL_VAR);
  }
   return;

  case kPTR_ASSIGN_STMT:
# line 215 "SetDefs.puma"
  {
# line 217 "SetDefs.puma"
   MakeVarDefs (t->PTR_ASSIGN_STMT.ASSIGN_VAR);
# line 218 "SetDefs.puma"
 t->PTR_ASSIGN_STMT.ASSIGN_EXP = CheckExp (t->PTR_ASSIGN_STMT.ASSIGN_EXP); 
  }
   return;

  case kASS_GOTO_STMT:
# line 221 "SetDefs.puma"
  {
# line 222 "SetDefs.puma"
   MakeVarDefs (t->ASS_GOTO_STMT.GOTO_VAR);
  }
   return;

  case kCOMP_GOTO_STMT:
# line 225 "SetDefs.puma"
  {
# line 226 "SetDefs.puma"
 t->COMP_GOTO_STMT.GOTO_EXP = CheckExp (t->COMP_GOTO_STMT.GOTO_EXP); 
  }
   return;

  case kCOMP_IF_STMT:
# line 229 "SetDefs.puma"
  {
# line 230 "SetDefs.puma"
 t->COMP_IF_STMT.IF_EXP = CheckExp (t->COMP_IF_STMT.IF_EXP); 
  }
   return;

  case kRETURN_STMT:
# line 233 "SetDefs.puma"
  {
# line 234 "SetDefs.puma"
 t->RETURN_STMT.RETURN_EXP = CheckExp (t->RETURN_STMT.RETURN_EXP); 
  }
   return;

  case kFORMAT_STMT:
# line 237 "SetDefs.puma"
   return;

  case kSTOP_STMT:
# line 240 "SetDefs.puma"
  {
# line 241 "SetDefs.puma"
 t->STOP_STMT.STOP_CONST = CheckExp (t->STOP_STMT.STOP_CONST); 
  }
   return;

  case kEXIT_STMT:
# line 244 "SetDefs.puma"
   return;

  case kCYCLE_STMT:
# line 247 "SetDefs.puma"
   return;

  case kALLOCATE_STMT:
# line 250 "SetDefs.puma"
  {
# line 252 "SetDefs.puma"
   MakeParamDefs (t->ALLOCATE_STMT.PARAMS);
# line 253 "SetDefs.puma"
   MakeVarDefs (t->ALLOCATE_STMT.STATUS);
  }
   return;

  case kDEALLOCATE_STMT:
# line 256 "SetDefs.puma"
  {
# line 258 "SetDefs.puma"
   MakeParamDefs (t->DEALLOCATE_STMT.PARAMS);
# line 259 "SetDefs.puma"
   MakeVarDefs (t->DEALLOCATE_STMT.STATUS);
  }
   return;

  case kREDUCE_STMT:
# line 262 "SetDefs.puma"
  {
# line 264 "SetDefs.puma"
 t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Object = GetIntrinsicObject (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident);
     if (!IntrFuncRed (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident))
        error_protocol ("reduce function no reduction");
     if (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Object == NoObject)
        error_protocol ("reduce function not intrinsic");
   
# line 271 "SetDefs.puma"
   MakeParamDefs (t->REDUCE_STMT.RED_PARAMS);
  }
   return;

  case kREALIGN_STMT:
# line 274 "SetDefs.puma"
  {
# line 276 "SetDefs.puma"
   MakeVarDefs (t->REALIGN_STMT.ALIGNEE);
# line 277 "SetDefs.puma"
   MakeRealignDefs (t);
  }
   return;

  case kREDISTRIBUTE_STMT:
# line 280 "SetDefs.puma"
  {
# line 282 "SetDefs.puma"
   MakeRedistributeDefs (t);
  }
   return;

  case kNULLIFY_STMT:
# line 285 "SetDefs.puma"
  {
# line 286 "SetDefs.puma"
   MakeParamDefs (t->NULLIFY_STMT.PARAMS);
  }
   return;

  }

# line 289 "SetDefs.puma"
  {
# line 290 "SetDefs.puma"
   failure_protocol (MODULE, "MakeStmtDefs", t);
  }
   return;

;
}

static tTree MakeFuncCall
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree expressions)
# else
(id, expressions)
 register tIdent id;
 register tTree expressions;
# endif
{
# line 303 "SetDefs.puma"
   return mFUNC_CALL_EXP (mPROC_OBJ (id), MakeFuncParams (expressions));

}

static tTree MakeFuncParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_LIST) {
# line 320 "SetDefs.puma"
  {
# line 322 "SetDefs.puma"
 t->BTE_LIST.Elem  = MakeFuncParams (t->BTE_LIST.Elem);
     t->BTE_LIST.Next = MakeFuncParams (t->BTE_LIST.Next);

     t->Kind = kBTP_LIST;
   
  }
   return t;

  }
  if (t->Kind == kBTE_EMPTY) {
# line 330 "SetDefs.puma"
  {
# line 332 "SetDefs.puma"
 t->Kind = kBTP_EMPTY; 
  }
   return t;

  }
  if (t->Kind == kNAMED_EXP) {
# line 337 "SetDefs.puma"
  {
# line 339 "SetDefs.puma"
 t->NAMED_EXP.VAL = MakeFuncParams (t->NAMED_EXP.VAL); 

     t->Kind = kNAMED_PARAM;
   
  }
   return t;

  }
# line 347 "SetDefs.puma"
   return mVALUE_PARAM (t);

}

static void MakeParamDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {

  switch (t->BTP_LIST.Elem->Kind) {
  case kVALUE_PARAM:
# line 375 "SetDefs.puma"
  {
# line 377 "SetDefs.puma"
 t->BTP_LIST.Elem = DefExpToParameter (t->BTP_LIST.Elem->VALUE_PARAM.E); 
# line 378 "SetDefs.puma"
   MakeParamDefs (t->BTP_LIST.Next);
  }
   return;

  case kNAMED_PARAM:
  if (t->BTP_LIST.Elem->NAMED_PARAM.VAL->Kind == kVALUE_PARAM) {
# line 381 "SetDefs.puma"
  {
# line 383 "SetDefs.puma"
 t->BTP_LIST.Elem->NAMED_PARAM.VAL = DefExpToParameter (t->BTP_LIST.Elem->NAMED_PARAM.VAL->VALUE_PARAM.E); 
# line 385 "SetDefs.puma"
   MakeParamDefs (t->BTP_LIST.Next);
  }
   return;

  }
  break;
  case kVAR_PARAM:
# line 388 "SetDefs.puma"
  {
# line 390 "SetDefs.puma"
   MakeVarDefs (t->BTP_LIST.Elem->VAR_PARAM.V);
# line 391 "SetDefs.puma"
   MakeParamDefs (t->BTP_LIST.Next);
  }
   return;

  case kNO_PARAM:
# line 394 "SetDefs.puma"
  {
# line 396 "SetDefs.puma"
   MakeParamDefs (t->BTP_LIST.Next);
  }
   return;

  case kPROC_PARAM:
# line 399 "SetDefs.puma"
  {
# line 401 "SetDefs.puma"
 t->BTP_LIST.Elem->PROC_PARAM.P->PROC_OBJ.Object = GetProcObject (t->BTP_LIST.Elem->PROC_PARAM.P->PROC_OBJ.Ident, GetCurrentUnitObject ()); 
  }
   return;

  case kFUNC_PARAM:
# line 404 "SetDefs.puma"
  {
# line 406 "SetDefs.puma"
 t->BTP_LIST.Elem->FUNC_PARAM.F->PROC_OBJ.Object = GetFuncObject (t->BTP_LIST.Elem->FUNC_PARAM.F->PROC_OBJ.Ident, GetCurrentUnitObject ()); 
  }
   return;

  case kRETURN_PARAM:
# line 409 "SetDefs.puma"
  {
# line 411 "SetDefs.puma"
   error_protocol ("actual return parameter not handled");
  }
   return;

  }

  }
  if (t->Kind == kBTP_EMPTY) {
# line 414 "SetDefs.puma"
   return;

  }
# line 417 "SetDefs.puma"
  {
# line 418 "SetDefs.puma"
   failure_protocol (MODULE, "MakeParamDefs", t);
  }
   return;

;
}

static tTree DefExpToParameter
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kNAMED_EXP) {
# line 437 "SetDefs.puma"
  {
# line 439 "SetDefs.puma"
 exp->NAMED_EXP.VAL = DefExpToParameter (exp->NAMED_EXP.VAL);
       exp->Kind = kNAMED_PARAM;
     
  }
   return exp;

  }
  if (exp->Kind == kVAR_EXP) {
  if (exp->VAR_EXP.V->Kind == kUSED_VAR) {
# line 452 "SetDefs.puma"
 {
  tTree yyV1;
  {
# line 454 "SetDefs.puma"
   MakeProcParam (GetGlobalObject (exp->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident), & yyV1);
# line 456 "SetDefs.puma"
   if (! ((yyV1 != NoTree))) goto yyL2;
  }
  {
   return yyV1;
  }
 }
yyL2:;

  }
  }
# line 469 "SetDefs.puma"
   return ExpToVarParam (CheckExp (exp));

}

static void MakeProcParam
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj, register tTree * result)
# else
(Obj, result)
 register tDefinitions Obj;
 register tTree * result;
# endif
{
# line 482 "SetDefs.puma"
  {
# line 483 "SetDefs.puma"
   if (! ((Obj == NoObject))) goto yyL1;
  }
   * result = NoTree;
   return;
yyL1:;

  if (Obj->Kind == kFuncObject) {
# line 486 "SetDefs.puma"
   * result = mFUNC_PARAM (MakeProcObj (Obj));
   return;

  }
  if (Obj->Kind == kProcObject) {
# line 489 "SetDefs.puma"
   * result = mPROC_PARAM (MakeProcObj (Obj));
   return;

  }
  if (Obj->Kind == kExternalObject) {
# line 492 "SetDefs.puma"
   * result = mPROC_PARAM (MakeProcObj (Obj));
   return;

  }
# line 495 "SetDefs.puma"
   * result = NoTree;
   return;

;
}

static tTree MakeProcObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj)
# else
(Obj)
 register tDefinitions Obj;
# endif
{
# line 500 "SetDefs.puma"
 {
  tTree p;
  {
# line 502 "SetDefs.puma"

# line 504 "SetDefs.puma"
 p = mPROC_OBJ (Obj->Object.Ident);
     p->PROC_OBJ.Object = Obj;
   
  }
  {
   return p;
  }
 }

}

void MakeIndexDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_LIST) {
# line 521 "SetDefs.puma"
  {
# line 522 "SetDefs.puma"
   if (! (t->BTE_LIST.Elem = CheckExp (t->BTE_LIST.Elem))) goto yyL1;
  {
# line 523 "SetDefs.puma"
   MakeIndexDefs (t->BTE_LIST.Next);
  }
  }
   return;
yyL1:;

  }
  if (t->Kind == kBTE_EMPTY) {
# line 526 "SetDefs.puma"
   return;

  }
# line 529 "SetDefs.puma"
  {
# line 530 "SetDefs.puma"
   failure_protocol (MODULE, "MakeIndexDefs", t);
  }
   return;

;
}

void MakeVarDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kBTV_LIST:
# line 547 "SetDefs.puma"
  {
# line 548 "SetDefs.puma"
   MakeVarDefs (t->BTV_LIST.Elem);
# line 549 "SetDefs.puma"
   MakeVarDefs (t->BTV_LIST.Next);
  }
   return;

  case kBTV_EMPTY:
# line 552 "SetDefs.puma"
   return;

  case kDUMMY_VAR:
# line 555 "SetDefs.puma"
   return;

  case kUSED_VAR:
# line 558 "SetDefs.puma"
  {
# line 559 "SetDefs.puma"
   MakeVarDefs (t->USED_VAR.VARNAME);
  }
   return;

  case kLOOP_VAR:
# line 562 "SetDefs.puma"
  {
# line 563 "SetDefs.puma"
   MakeVarDefs (t->LOOP_VAR.LOOP_VARNAME);
  }
   return;

  case kDO_VAR:
# line 566 "SetDefs.puma"
  {
# line 567 "SetDefs.puma"
   MakeVarDefs (t->DO_VAR.DO_ID);
# line 568 "SetDefs.puma"
 t->DO_VAR.RANGE = CheckExp (t->DO_VAR.RANGE); 
# line 569 "SetDefs.puma"
   MakeVarDefs (t->DO_VAR.BODY);
  }
   return;

  case kVAR_OBJ:
# line 578 "SetDefs.puma"
  {
# line 582 "SetDefs.puma"
   MySetVarObject (t, GetGlobalObject (t->VAR_OBJ.Ident));
  }
   return;

  case kINDEXED_VAR:
# line 591 "SetDefs.puma"
 {
  tTree tp;
  tDefinitions Obj;
  {
# line 593 "SetDefs.puma"
   MakeVarDefs (t->INDEXED_VAR.IND_VAR);
# line 594 "SetDefs.puma"
   MakeIndexDefs (t->INDEXED_VAR.IND_EXPS);
# line 598 "SetDefs.puma"

# line 599 "SetDefs.puma"

# line 601 "SetDefs.puma"
 tp = GetVariableType (t->INDEXED_VAR.IND_VAR);
     if (tp == NoTree)
        { error_protocol ("type of indexed var unknown, illegal array");
          tree_protocol ("variable is ", t);
        }
      else if (IsStringType (tp))
        MakeSubstring (t);
      else if (!IsArrayType (tp))
        { error_protocol ("illegal array access (not an array)");
          tree_protocol ("variable is ", t);
          tree_protocol ("type is     ", tp);
        }
   
  }
   return;
 }

  case kSELECTED_VAR:
# line 616 "SetDefs.puma"
  {
# line 618 "SetDefs.puma"
   MakeVarDefs (t->SELECTED_VAR.SELEC_VAR);
# line 619 "SetDefs.puma"
   SetSelectedCompObj (t, GetVariableType (t->SELECTED_VAR.SELEC_VAR));
  }
   return;

  case kADDR:
# line 622 "SetDefs.puma"
  {
# line 624 "SetDefs.puma"
 t->ADDR.E = CheckExp (t->ADDR.E); 
  }
   return;

  }

# line 627 "SetDefs.puma"
  {
# line 628 "SetDefs.puma"
   failure_protocol (MODULE, "MakeVarDefs", t);
  }
   return;

;
}

static void MakeOnClauseDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kON_PROC_CLAUSE) {
# line 639 "SetDefs.puma"
  {
# line 641 "SetDefs.puma"
   MakeTopologyDef (t->ON_PROC_CLAUSE.ON_PROC);
  }
   return;

  }
  if (t->Kind == kON_VAR_CLAUSE) {
# line 644 "SetDefs.puma"
  {
# line 646 "SetDefs.puma"
   MakeHomeDefs (t->ON_VAR_CLAUSE.ON_VAR);
  }
   return;

  }
# line 649 "SetDefs.puma"
  {
# line 650 "SetDefs.puma"
   failure_protocol (MODULE, "MakeOnClauseDefs", t);
  }
   return;

;
}

static void MakeHomeDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
# line 661 "SetDefs.puma"
  {
# line 662 "SetDefs.puma"
   MakeHomeDefs (t->USED_VAR.VARNAME);
  }
   return;

  }
  if (t->Kind == kDUMMY_VAR) {
# line 665 "SetDefs.puma"
   return;

  }
  if (t->Kind == kVAR_OBJ) {
# line 668 "SetDefs.puma"
  {
# line 672 "SetDefs.puma"
   SetHomeObject (t, GetGlobalObject (t->VAR_OBJ.Ident));
  }
   return;

  }
  if (t->Kind == kINDEXED_VAR) {
# line 675 "SetDefs.puma"
  {
# line 677 "SetDefs.puma"
   MakeHomeDefs (t->INDEXED_VAR.IND_VAR);
# line 678 "SetDefs.puma"
   MakeIndexDefs (t->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
# line 681 "SetDefs.puma"
  {
# line 682 "SetDefs.puma"
   error_protocol ("illegal home variable");
# line 683 "SetDefs.puma"
   tree_protocol ("home : ", t);
  }
   return;

;
}

static void SetSelectedCompObj
# if defined __STDC__ | defined __cplusplus
(register tTree sv, register tTree type)
# else
(sv, type)
 register tTree sv;
 register tTree type;
# endif
{
  if (sv->Kind == kSELECTED_VAR) {
# line 694 "SetDefs.puma"
  {
# line 696 "SetDefs.puma"
   if (! ((type == NoTree))) goto yyL1;
  {
# line 697 "SetDefs.puma"
   error_protocol ("type of selected var unknown");
# line 698 "SetDefs.puma"
   tree_protocol ("selected var is : ", sv);
  }
  }
   return;
yyL1:;

  if (type->Kind == kTYPE_ID) {
# line 701 "SetDefs.puma"
  {
# line 703 "SetDefs.puma"
   if (! ((type->TYPE_ID.ID->TYPE_OBJ.Object == NoObject))) goto yyL2;
  {
# line 704 "SetDefs.puma"
   error_protocol ("no scope for type components found");
# line 705 "SetDefs.puma"
   tree_protocol ("record type is ", type);
  }
  }
   return;
yyL2:;

  if (type->TYPE_ID.ID->TYPE_OBJ.Object->Kind == kTypeObject) {
# line 708 "SetDefs.puma"
  {
# line 711 "SetDefs.puma"
   if (! ((type->TYPE_ID.ID->TYPE_OBJ.Object->TypeObject.Components == NoEntries))) goto yyL3;
  {
# line 712 "SetDefs.puma"
   error_protocol ("use of undefined type");
# line 713 "SetDefs.puma"
   tree_protocol ("variable is : ", sv);
# line 714 "SetDefs.puma"
   tree_protocol ("type is : ", type);
  }
  }
   return;
yyL3:;

# line 717 "SetDefs.puma"
 {
  tDefinitions Obj;
  {
# line 720 "SetDefs.puma"

# line 722 "SetDefs.puma"
   Obj = GetDeclEntry (sv->SELECTED_VAR.SELECTOR->REC_COMP.Ident, type->TYPE_ID.ID->TYPE_OBJ.Object->TypeObject.Components);
# line 724 "SetDefs.puma"
 if (Obj == NoObject)
       tree_error_protocol ("component does not exist in derived type", sv);
   
# line 728 "SetDefs.puma"
   sv->SELECTED_VAR.SELECTOR->REC_COMP.Object = Obj;
  }
   return;
 }

  }
# line 731 "SetDefs.puma"
  {
# line 733 "SetDefs.puma"
   tree_error_protocol ("no type object found", sv);
# line 734 "SetDefs.puma"
   tree_protocol ("type of the var is ", type);
  }
   return;

  }
  if (type->Kind == kARRAY_TYPE) {
# line 737 "SetDefs.puma"
  {
# line 741 "SetDefs.puma"
   SetSelectedCompObj (sv, type->ARRAY_TYPE.ARRAY_COMP_TYPE);
  }
   return;

  }
  if (type->Kind == kPOINTER_TYPE) {
# line 744 "SetDefs.puma"
  {
# line 748 "SetDefs.puma"
   SetSelectedCompObj (sv, type->POINTER_TYPE.PTR_COMP);
  }
   return;

  }
# line 751 "SetDefs.puma"
  {
# line 753 "SetDefs.puma"
   error_protocol ("illegal type for selected variable");
# line 754 "SetDefs.puma"
   tree_protocol ("selected var = ", sv);
# line 755 "SetDefs.puma"
   tree_protocol ("type         = ", type);
  }
   return;

  }
;
}

static void MakeSubstring
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_EXPS->Kind == kBTE_LIST) {
  if (t->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->INDEXED_VAR.IND_EXPS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 767 "SetDefs.puma"
  {
# line 768 "SetDefs.puma"
 t->INDEXED_VAR.IND_EXPS = t->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem;
    t->Kind = kSUBSTRING_VAR;
  
  }
   return;

  }
  }
  }
  }
# line 773 "SetDefs.puma"
  {
# line 774 "SetDefs.puma"
   tree_error_protocol ("indexed access to string illegal", t);
  }
   return;

;
}

static void MySetVarObject
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions obj)
# else
(t, obj)
 register tTree t;
 register tDefinitions obj;
# endif
{
  if (t->Kind == kVAR_OBJ) {
# line 785 "SetDefs.puma"
 {
  tTree type;
  {
# line 787 "SetDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 789 "SetDefs.puma"

# line 793 "SetDefs.puma"
   type = mDUMMY_TYPE ();
# line 795 "SetDefs.puma"
 t->VAR_OBJ.Object = GetLocalVarEntity (t->VAR_OBJ.Ident, t->VAR_OBJ.Pos, GetCurrentUnitObject ()); 
  }
  }
   return;
 }
yyL1:;

  if (obj->Kind == kVarObject) {
# line 798 "SetDefs.puma"
  {
# line 800 "SetDefs.puma"
 t->VAR_OBJ.Object = obj;
     SetObjUse (obj);
   
  }
   return;

  }
  if (obj->Kind == kNameListObject) {
# line 805 "SetDefs.puma"
  {
# line 807 "SetDefs.puma"
 t->VAR_OBJ.Object = obj; 
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
# line 810 "SetDefs.puma"
  {
# line 812 "SetDefs.puma"
   error_protocol ("template cannot be used as a variable");
# line 813 "SetDefs.puma"
   tree_protocol ("the template is : ", t);
  }
   return;

  }
  if (obj->Kind == kProcObject) {
# line 816 "SetDefs.puma"
  {
# line 818 "SetDefs.puma"
   error_protocol ("variable and not subroutine expected");
# line 819 "SetDefs.puma"
   tree_protocol ("the element is : ", t);
  }
   return;

  }
  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
# line 822 "SetDefs.puma"
  {
# line 827 "SetDefs.puma"
   if (! ((obj->FuncObject.decl->FUNC_DECL.RESULT_ID != DefaultId ()))) goto yyL6;
  {
# line 829 "SetDefs.puma"
   if (! ((GetLocalObject (obj->FuncObject.decl->FUNC_DECL.RESULT_ID) == GetDeclEntry (obj->FuncObject.decl->FUNC_DECL.RESULT_ID, obj->FuncObject.Declarations)))) goto yyL6;
  {
# line 831 "SetDefs.puma"
 t->VAR_OBJ.Ident  = obj->FuncObject.decl->FUNC_DECL.RESULT_ID;
     t->VAR_OBJ.Object = GetLocalObject (obj->FuncObject.decl->FUNC_DECL.RESULT_ID);
   
  }
  }
  }
   return;
yyL6:;

# line 836 "SetDefs.puma"
  {
# line 839 "SetDefs.puma"
   error_protocol ("assignment to function name only in the function");
# line 840 "SetDefs.puma"
   obj_error_protocol ("function object : ", obj);
  }
   return;

  }
  }
# line 843 "SetDefs.puma"
  {
# line 844 "SetDefs.puma"
   error_protocol ("variable expected");
# line 845 "SetDefs.puma"
   obj_protocol ("set object is : ", obj);
  }
   return;

  }
;
}

static void SetHomeObject
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions obj)
# else
(t, obj)
 register tTree t;
 register tDefinitions obj;
# endif
{
  if (t->Kind == kVAR_OBJ) {
# line 856 "SetDefs.puma"
  {
# line 858 "SetDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 859 "SetDefs.puma"
   error_protocol ("unknown home");
# line 860 "SetDefs.puma"
   tree_protocol ("home var : ", t);
  }
  }
   return;
yyL1:;

  if (obj->Kind == kVarObject) {
# line 863 "SetDefs.puma"
  {
# line 865 "SetDefs.puma"
 t->VAR_OBJ.Object = obj;
     SetObjUse (obj);
   
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
# line 870 "SetDefs.puma"
  {
# line 872 "SetDefs.puma"
 t->VAR_OBJ.Object = obj; 
  }
   return;

  }
# line 875 "SetDefs.puma"
  {
# line 876 "SetDefs.puma"
   error_protocol ("variable/template expected");
# line 877 "SetDefs.puma"
   obj_protocol ("set object is : ", obj);
  }
   return;

  }
;
}

static void SetObjUse
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 894 "SetDefs.puma"
  {
# line 896 "SetDefs.puma"
 v->VarObject.uses->VarUse.ReadUse += 1; 
  }
   return;

;
}

tTree CheckExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kDUMMY_EXP:
# line 909 "SetDefs.puma"
   return exp;

  case kCONST_EXP:
# line 913 "SetDefs.puma"
   return exp;

  case kARRAY_EXP:
# line 917 "SetDefs.puma"
  {
# line 918 "SetDefs.puma"
   MakeIndexDefs (exp->ARRAY_EXP.ELEMENTS);
  }
   return exp;

  case kSLICE_EXP:
# line 922 "SetDefs.puma"
  {
# line 923 "SetDefs.puma"
 exp->SLICE_EXP.START = CheckExp (exp->SLICE_EXP.START);
     exp->SLICE_EXP.STOP  = CheckExp (exp->SLICE_EXP.STOP);
     exp->SLICE_EXP.INC   = CheckExp (exp->SLICE_EXP.INC);
   
  }
   return exp;

  case kOP_EXP:
# line 930 "SetDefs.puma"
  {
# line 931 "SetDefs.puma"
 exp->OP_EXP.OPND1 = CheckExp (exp->OP_EXP.OPND1);
     exp->OP_EXP.OPND2 = CheckExp (exp->OP_EXP.OPND2);
   
  }
   return exp;

  case kOP1_EXP:
# line 937 "SetDefs.puma"
  {
# line 938 "SetDefs.puma"
 exp->OP1_EXP.OPND = CheckExp (exp->OP1_EXP.OPND); 
  }
   return exp;

  case kNAMED_EXP:
# line 942 "SetDefs.puma"
  {
# line 943 "SetDefs.puma"
 exp->NAMED_EXP.VAL = CheckExp (exp->NAMED_EXP.VAL); 
  }
   return exp;

  case kVAR_EXP:
  if (exp->VAR_EXP.V->Kind == kINDEXED_VAR) {
  if (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS->Kind == kBTE_LIST) {
  if (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 954 "SetDefs.puma"
  {
# line 958 "SetDefs.puma"
   MakeVarDefs (exp->VAR_EXP.V);
  }
   return exp;

  }
  }
  }
  if (exp->VAR_EXP.V->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 968 "SetDefs.puma"
 {
  tDefinitions Obj;
  {
# line 973 "SetDefs.puma"

# line 975 "SetDefs.puma"
   Obj = GetGlobalObject (exp->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
# line 976 "SetDefs.puma"
   if (! (Obj != NoObject)) goto yyL9;
  {
# line 977 "SetDefs.puma"
   if (! (Obj -> Kind == kVarObject)) goto yyL9;
  {
# line 978 "SetDefs.puma"
   if (! (VarRank (Obj) > 0)) goto yyL9;
  {
# line 982 "SetDefs.puma"
   MakeIndexDefs (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS);
# line 983 "SetDefs.puma"
   exp->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object = Obj;
  }
  }
  }
  }
  {
   return exp;
  }
 }
yyL9:;

# line 993 "SetDefs.puma"
 {
  tDefinitions Obj;
  tTree e;
  {
# line 997 "SetDefs.puma"

# line 999 "SetDefs.puma"
   Obj = GetGlobalObject (exp->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
# line 1001 "SetDefs.puma"
   if (! ((Obj != NoObject))) goto yyL10;
  {
# line 1002 "SetDefs.puma"
   if (! ((Obj -> Kind == kTypeObject))) goto yyL10;
  {
# line 1006 "SetDefs.puma"
   MakeIndexDefs (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS);
# line 1008 "SetDefs.puma"

# line 1010 "SetDefs.puma"
  e = mTYPE_OBJ (exp->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
      e->TYPE_OBJ.Object = Obj;
      e = mTYPE_EXP (e, exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS);
   
  }
  }
  }
  {
   return e;
  }
 }
yyL10:;

# line 1024 "SetDefs.puma"
   return CheckExp (MakeFuncCall (exp->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS));

  }
  }
# line 1033 "SetDefs.puma"
  {
# line 1037 "SetDefs.puma"
   MakeVarDefs (exp->VAR_EXP.V);
  }
   return exp;

  case kFUNC_CALL_EXP:
# line 1041 "SetDefs.puma"
  {
# line 1043 "SetDefs.puma"
 exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object = GetFuncObject (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, GetCurrentUnitObject()); 
# line 1045 "SetDefs.puma"
   MakeParamDefs (exp->FUNC_CALL_EXP.FUNC_PARAMS);
  }
   return exp;

  case kDO_EXP:
# line 1050 "SetDefs.puma"
  {
# line 1051 "SetDefs.puma"
   MakeVarDefs (exp->DO_EXP.DO_ID);
# line 1052 "SetDefs.puma"
 exp->DO_EXP.RANGE = CheckExp (exp->DO_EXP.RANGE); 
# line 1053 "SetDefs.puma"
   MakeIndexDefs (exp->DO_EXP.BODY);
  }
   return exp;

  }

# line 1057 "SetDefs.puma"
  {
# line 1058 "SetDefs.puma"
   failure_protocol (MODULE, "CheckExp", exp);
  }
   return exp;

}

static tTree ObjTypePtr
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.decl->Kind == kVAR_DECL) {
# line 1076 "SetDefs.puma"
   return v->VarObject.decl->VAR_DECL.VAL;

  }
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 1080 "SetDefs.puma"
   return v->VarObject.decl->VAR_PARAM_DECL.VAL;

  }
# line 1090 "SetDefs.puma"
  {
# line 1091 "SetDefs.puma"
   failure_protocol ("SetDefs", "ObjTypePtr (VarObject)", v->VarObject.decl);
  }
   return NoTree;

  }
  if (v->Kind == kFuncObject) {
# line 1086 "SetDefs.puma"
   return NoTree;

  }
# line 1095 "SetDefs.puma"
  {
# line 1096 "SetDefs.puma"
   failure_protocol ("SetDefs", "ObjTypePtr", v->Object.decl);
  }
   return NoTree;

}

static tTree VarSelect
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stype)
# else
(var, stype)
 register tTree var;
 register tTree stype;
# endif
{
# line 1110 "SetDefs.puma"
  {
# line 1111 "SetDefs.puma"
   if (! ((stype == NoTree))) goto yyL1;
  }
   return NoTree;
yyL1:;

  if (var->Kind == kINDEXED_VAR) {
  if (stype->Kind == kARRAY_TYPE) {
# line 1115 "SetDefs.puma"
   return stype->ARRAY_TYPE.ARRAY_COMP_TYPE;

  }
# line 1119 "SetDefs.puma"
   return NoTree;

  }
# line 1123 "SetDefs.puma"
  {
# line 1124 "SetDefs.puma"
   failure2_protocol (MODULE, "VarSelect", var, stype);
  }
   return stype;

}

static tTree MakeTypeExp
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree exps)
# else
(id, exps)
 register tIdent id;
 register tTree exps;
# endif
{
# line 1136 "SetDefs.puma"

tTree v;

# line 1140 "SetDefs.puma"
  {
# line 1141 "SetDefs.puma"
 v = mTYPE_OBJ (id);
      v->TYPE_OBJ.Object = GetGlobalObject (id);
      v = mTYPE_EXP (v, exps); 
  }
   return v;

}

void MakeTopologyDef
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
  if (spec->Kind == kPROCESSOR_ARRAY) {
# line 1158 "SetDefs.puma"
  {
# line 1160 "SetDefs.puma"
   SetTopologyObject (spec->PROCESSOR_ARRAY.TOPNAME, GetGlobalObject (spec->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Ident));
  }
   return;

  }
  if (spec->Kind == kPROCESSOR_SUBSET) {
# line 1163 "SetDefs.puma"
  {
# line 1165 "SetDefs.puma"
 char top_str [50];
     char sub_top_str [55];

     

     GetString (spec->PROCESSOR_SUBSET.FULLTOP->TOP_OBJ.Ident, top_str);
     sprintf (sub_top_str, "%s_%d", top_str, SubTopCounter++);
     spec->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Ident = IsIdent (sub_top_str);
   
# line 1175 "SetDefs.puma"
   SetTopologyObject (spec->PROCESSOR_SUBSET.FULLTOP, GetGlobalObject (spec->PROCESSOR_SUBSET.FULLTOP->TOP_OBJ.Ident));
# line 1176 "SetDefs.puma"
   MakeSubTopology (spec);
# line 1178 "SetDefs.puma"
   MakeIndexDefs (spec->PROCESSOR_SUBSET.SUBSCRIPTS);
  }
   return;

  }
# line 1181 "SetDefs.puma"
  {
# line 1183 "SetDefs.puma"
   failure_protocol (MODULE, "MakeTopologyDef", spec);
  }
   return;

;
}

static void SetTopologyObject
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions obj)
# else
(t, obj)
 register tTree t;
 register tDefinitions obj;
# endif
{
  if (t->Kind == kTOP_OBJ) {
# line 1194 "SetDefs.puma"
  {
# line 1196 "SetDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 1198 "SetDefs.puma"
   error_protocol ("unknown processor arrangement");
  }
  }
   return;
yyL1:;

  if (obj->Kind == kTopologyObject) {
# line 1201 "SetDefs.puma"
  {
# line 1205 "SetDefs.puma"
 t->TOP_OBJ.Object = obj; 
  }
   return;

  }
# line 1208 "SetDefs.puma"
  {
# line 1210 "SetDefs.puma"
   error_protocol ("processor arrangement expected");
# line 1211 "SetDefs.puma"
   obj_protocol ("illegal object is : ", obj);
  }
   return;

  }
# line 1214 "SetDefs.puma"
  {
# line 1216 "SetDefs.puma"
   failure_protocol (MODULE, "SetTopologyObject", t);
  }
   return;

;
}

static void MakeSubTopology
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
  if (spec->Kind == kPROCESSOR_SUBSET) {
# line 1221 "SetDefs.puma"
  {
# line 1223 "SetDefs.puma"
 spec->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Object = MakeNewObject (spec, GetCurrentUnitObject ()); 
     InsertEntry (spec->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Object);
   
  }
   return;

  }
;
}

void BeginSetDefs ()
{
}

void CloseSetDefs ()
{
}
