# include "Semantic.h"
# include "yySemantic.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 44 "Semantic.puma"

# include "Idents.h"
# include "StringMem.h"
# include "Types.h"
# include "protocol.h"

# include "Transform.h"  /* CombineACF */
# include "Rank.h"
# include "TreeOps.h"

# include "Objects.h"
# include "DefTable.h"

# include "SemDecls.h"  /* SemDefinitions, SemDeclarations */
# include "SemExp.h"    /* SemExp, SemExpList              */
# include "SemCalling.h"
# include "SemIntr.h"
# include "SemMap.h"
# include "SemParallel.h"
# include "SemPreds.h"

# include "Nesting.h"   /* Inc/DecLoopNesting       */

# include "Loops.h"     /* ForallVarCheck, HasOuterParallelLoop */

# define MODULE "Semantic"

/*********************************************************************
*                                                                    * 
*  Global Data for Semantic Analysis                                 * 
*                                                                    * 
*********************************************************************/

static tTree current_unit;

   /*  current_unit needed to check:

       - no return statement in main program 
       - common is defined in main unit

   */



static void yyExit () { Exit (1); }

void (* Semantic_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Semantic, routine %s failed\n", yyFunction);
 Semantic_Exit ();
}

void Semantic ARGS((tTree t));
static void BodyCheck ARGS((tTree body, tTree unit));
static void SemanticWhere ARGS((tTree t, int whererank));
static void SemanticElseWhere ARGS((tTree t, int whererank));
static void SemanticIO ARGS((tTree t));
static void SemIOParams ARGS((tTree items, int intent));
static tTree MakeDoVar ARGS((tTree DoExp));
static void CheckReduceParams ARGS((tTree t));
static void FindStatusParameter ARGS((tTree params, tTree * yyP2, tTree * yyP1));
static void CheckStatusParameter ARGS((tTree status));
static void CheckNullifyParams ARGS((tTree t));
static void CheckNullifyParam ARGS((tTree t));
static void CheckAllocParam ARGS((tTree var));
static void CheckAllocateParams ARGS((tTree t));
static void NormalAllocateParams ARGS((tTree t));
static void CheckDeallocParameter ARGS((tTree var));
static void CheckDeallocateParams ARGS((tTree t));
static bool IsVarArgument ARGS((tTree t));
static void SemCaseAlternatives ARGS((tTree alts, tTree case_exp));
static void SemCaseValueRanges ARGS((tTree explist, tTree case_exp));
static void SemCaseValueRange ARGS((tTree case_value, tTree case_exp));
static void SemCaseValue ARGS((tTree case_value, tTree case_exp));
static void SemDoRange ARGS((tTree range));

void Semantic
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kCOMP_UNIT:
# line 96 "Semantic.puma"
  {
# line 98 "Semantic.puma"
   open_protocol ("adaptor.sem");
# line 99 "Semantic.puma"
   Semantic (t->COMP_UNIT.USED_ELEMENTS);
# line 100 "Semantic.puma"
   Semantic (t->COMP_UNIT.COMP_ELEMENTS);
# line 101 "Semantic.puma"
   close_protocol ();
  }
   return;

  case kUNIT_EMPTY:
# line 104 "Semantic.puma"
   return;

  case kUNIT_LIST:
# line 107 "Semantic.puma"
  {
# line 109 "Semantic.puma"
   set_protocol_unit (t->UNIT_LIST.Elem);
# line 110 "Semantic.puma"
   current_unit = t->UNIT_LIST.Elem;
# line 111 "Semantic.puma"
   Semantic (t->UNIT_LIST.Elem);
# line 112 "Semantic.puma"
   Semantic (t->UNIT_LIST.Next);
  }
   return;

  case kPROGRAM_DECL:
# line 124 "Semantic.puma"
  {
# line 126 "Semantic.puma"
   NestOpenUnit (t);
# line 127 "Semantic.puma"
   SemDefinitions (GetCurrentScope ());
# line 128 "Semantic.puma"
   Semantic (t->PROGRAM_DECL.PROGRAM_BODY);
# line 129 "Semantic.puma"
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
# line 132 "Semantic.puma"
  {
# line 134 "Semantic.puma"
   NestOpenUnit (t);
# line 135 "Semantic.puma"
   SemDefinitions (GetCurrentScope ());
# line 136 "Semantic.puma"
   Semantic (t->PROC_DECL.PROC_BODY);
# line 137 "Semantic.puma"
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
# line 140 "Semantic.puma"
  {
# line 142 "Semantic.puma"
   NestOpenUnit (t);
# line 143 "Semantic.puma"
   SemDefinitions (GetCurrentScope ());
# line 144 "Semantic.puma"
   Semantic (t->FUNC_DECL.FUNC_BODY);
# line 145 "Semantic.puma"
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
# line 148 "Semantic.puma"
  {
# line 150 "Semantic.puma"
   NestOpenUnit (t);
# line 151 "Semantic.puma"
   SemDefinitions (GetCurrentScope ());
# line 152 "Semantic.puma"
   Semantic (t->MODULE_DECL.MODULE_BODY);
# line 153 "Semantic.puma"
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 156 "Semantic.puma"
  {
# line 158 "Semantic.puma"
   NestOpenUnit (t);
# line 159 "Semantic.puma"
   SemDefinitions (GetCurrentScope ());
# line 160 "Semantic.puma"
   Semantic (t->BLOCK_DATA_DECL.DATA_BODY);
# line 161 "Semantic.puma"
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
# line 174 "Semantic.puma"
  {
# line 176 "Semantic.puma"
   BodyCheck (t, current_unit);
# line 177 "Semantic.puma"
   SemDeclarations (t->BODY_NODE.DECLS, current_unit);
# line 178 "Semantic.puma"
   Semantic (t->BODY_NODE.STATS);
# line 179 "Semantic.puma"
   Semantic (t->BODY_NODE.INTERNALS);
  }
   return;

  case kACF_LIST:
# line 188 "Semantic.puma"
  {
# line 190 "Semantic.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 191 "Semantic.puma"
   Semantic (t->ACF_LIST.Elem);
# line 192 "Semantic.puma"
   Semantic (t->ACF_LIST.Next);
  }
   return;

  case kACF_EMPTY:
# line 195 "Semantic.puma"
   return;

  case kACF_DUMMY:
# line 198 "Semantic.puma"
   return;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 201 "Semantic.puma"
  {
# line 205 "Semantic.puma"
 t->ACF_BASIC.BASIC_STMT = SemAssignment (t->ACF_BASIC.BASIC_STMT); 
  }
   return;

  }
# line 208 "Semantic.puma"
  {
# line 210 "Semantic.puma"
   Semantic (t->ACF_BASIC.BASIC_STMT);
  }
   return;

  case kACF_IF:
# line 213 "Semantic.puma"
  {
# line 215 "Semantic.puma"
 t->ACF_IF.IF_EXP = SemExpression (t->ACF_IF.IF_EXP);

     if (!ScalarLogicalExpr (t->ACF_IF.IF_EXP))
        error_protocol ("no scalar bool expression in if statement");
   
# line 221 "Semantic.puma"
   Semantic (t->ACF_IF.THEN_PART);
# line 222 "Semantic.puma"
   Semantic (t->ACF_IF.ELSE_PART);
  }
   return;

  case kACF_WHERE:
# line 225 "Semantic.puma"
 {
  int whererank;
  {
# line 227 "Semantic.puma"

# line 229 "Semantic.puma"
 t->ACF_WHERE.WHERE_EXP = SemExpression (t->ACF_WHERE.WHERE_EXP);

     if (!LogicalExpr (t->ACF_WHERE.WHERE_EXP))
        error_protocol ("expression in WHERE must be logical");

     whererank = TreeRank (t->ACF_WHERE.WHERE_EXP);

     if (whererank > 0)

         { SemanticWhere     (t->ACF_WHERE.TRUE_PART, whererank);
           SemanticElseWhere (t->ACF_WHERE.FALSE_PART, whererank);
         }
        else
         error_protocol ("Illegal Rank of Expression in WHERE");
    
  }
   return;
 }

  case kACF_CASE:
# line 246 "Semantic.puma"
  {
# line 248 "Semantic.puma"
 t->ACF_CASE.CASE_EXP = SemExpression (t->ACF_CASE.CASE_EXP);

     if (!ScalarCaseExpr (t->ACF_CASE.CASE_EXP))
        error_protocol ("scalar numeric expression in CASE required");
   
# line 254 "Semantic.puma"
   SemCaseAlternatives (t->ACF_CASE.CASE_ALTS, t->ACF_CASE.CASE_EXP);
  }
   return;

  case kACF_LOOP:
# line 257 "Semantic.puma"
  {
# line 259 "Semantic.puma"
   Semantic (t->ACF_LOOP.LOOP_BODY);
  }
   return;

  case kACF_WHILE:
# line 262 "Semantic.puma"
  {
# line 264 "Semantic.puma"
 t->ACF_WHILE.WHILE_EXP = SemExpression (t->ACF_WHILE.WHILE_EXP);

     if (!ScalarLogicalExpr (t->ACF_WHILE.WHILE_EXP))
        error_protocol ("no scalar bool expression in do while statement");
   
# line 270 "Semantic.puma"
   Semantic (t->ACF_WHILE.WHILE_BODY);
  }
   return;

  case kACF_FORALL:
# line 273 "Semantic.puma"
  {
# line 275 "Semantic.puma"
   IncLoopNesting (t);
# line 277 "Semantic.puma"
   SemVariable (t->ACF_FORALL.FORALL_ID);
# line 279 "Semantic.puma"
 if (!ScalarIntVariable (t->ACF_FORALL.FORALL_ID))
        error_protocol ("id in FORALL must be scalar integer variable");
   
# line 283 "Semantic.puma"
 t->ACF_FORALL.FORALL_RANGE = SemExpression (t->ACF_FORALL.FORALL_RANGE);   
# line 285 "Semantic.puma"
   Semantic (t->ACF_FORALL.FORALL_BODY);
# line 287 "Semantic.puma"
   SemParallel (t);
# line 289 "Semantic.puma"
   DecLoopNesting (t);
  }
   return;

  case kACF_DO:
# line 292 "Semantic.puma"
  {
# line 294 "Semantic.puma"
   IncLoopNesting (t);
# line 296 "Semantic.puma"
   SemVariable (t->ACF_DO.DO_ID);
# line 298 "Semantic.puma"
 if (!DoVariable (t->ACF_DO.DO_ID))
        error_protocol ("id in DO must be scalar int/real/double variable");
   
# line 302 "Semantic.puma"
   SemDoRange (t->ACF_DO.DO_RANGE);
# line 303 "Semantic.puma"
   Semantic (t->ACF_DO.DO_BODY);
# line 304 "Semantic.puma"
   SemParallel (t);
# line 306 "Semantic.puma"
   DecLoopNesting (t);
  }
   return;

  case kACF_ENTRY:
# line 309 "Semantic.puma"
  {
# line 311 "Semantic.puma"
   error_protocol ("ENTRY not supported");
  }
   return;

  case kACF_HOME:
# line 314 "Semantic.puma"
  {
# line 316 "Semantic.puma"
   Semantic (t->ACF_HOME.HOME_BODY);
# line 318 "Semantic.puma"
   SemParallel (t);
  }
   return;

  case kACF_RESIDENT:
# line 321 "Semantic.puma"
  {
# line 323 "Semantic.puma"
   Semantic (t->ACF_RESIDENT.RESIDENT_BODY);
# line 325 "Semantic.puma"
   SemParallel (t);
  }
   return;

  case kACF_NEW:
# line 328 "Semantic.puma"
  {
# line 330 "Semantic.puma"
   Semantic (t->ACF_NEW.NEW_BODY);
# line 332 "Semantic.puma"
   SemParallel (t);
  }
   return;

  case kACF_REDUCTION:
# line 335 "Semantic.puma"
  {
# line 337 "Semantic.puma"
   Semantic (t->ACF_REDUCTION.REDUCTION_BODY);
# line 339 "Semantic.puma"
   SemParallel (t);
  }
   return;

  case kACF_TASK_REGION:
# line 342 "Semantic.puma"
  {
# line 344 "Semantic.puma"
   Semantic (t->ACF_TASK_REGION.TASK_BODY);
# line 346 "Semantic.puma"
   SemParallel (t);
  }
   return;

  case kASSIGN_STMT:
# line 349 "Semantic.puma"
  {
# line 351 "Semantic.puma"
   failure_protocol (MODULE, "Semantic", t);
  }
   return;

  case kPTR_ASSIGN_STMT:
  if (t->PTR_ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
# line 354 "Semantic.puma"
   return;

  }
  if (t->PTR_ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 360 "Semantic.puma"
   return;

  }
# line 366 "Semantic.puma"
  {
# line 368 "Semantic.puma"
   error_protocol ("illegal pointer assignment");
  }
   return;

  case kLABEL_ASSIGN_STMT:
# line 371 "Semantic.puma"
  {
# line 373 "Semantic.puma"
   SemVariable (t->LABEL_ASSIGN_STMT.LABEL_VAR);
# line 375 "Semantic.puma"
 if (!ScalarIntVariable (t->LABEL_ASSIGN_STMT.LABEL_VAR))
        error_protocol ("not scalar integer variable in assign statement");
   
  }
   return;

  case kFORMAT_STMT:
# line 380 "Semantic.puma"
   return;

  case kIO_STMT:
# line 383 "Semantic.puma"
  {
# line 385 "Semantic.puma"
   SemanticIO (t);
  }
   return;

  case kCALL_STMT:
# line 388 "Semantic.puma"
  {
# line 390 "Semantic.puma"
   if (! ((t->CALL_STMT.CALL_ID->PROC_OBJ.Object == GetIntrinsicObject (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident)))) goto yyL35;
  {
# line 394 "Semantic.puma"
   SemParamList (t->CALL_STMT.CALL_PARAMS);
# line 395 "Semantic.puma"
   SemCalling (t);
# line 397 "Semantic.puma"
   SemIntrinsicSubroutine (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, t->CALL_STMT.CALL_PARAMS);
  }
  }
   return;
yyL35:;

# line 400 "Semantic.puma"
  {
# line 404 "Semantic.puma"
   SemParamList (t->CALL_STMT.CALL_PARAMS);
# line 406 "Semantic.puma"
 t->CALL_STMT.CALL_ID->PROC_OBJ.Object = IdentifyGenericRoutine (t, t->CALL_STMT.CALL_ID->PROC_OBJ.Object); 
# line 408 "Semantic.puma"
   SemParamList (t->CALL_STMT.CALL_PARAMS);
# line 409 "Semantic.puma"
   SemCalling (t);
  }
   return;

  case kGOTO_STMT:
# line 412 "Semantic.puma"
   return;

  case kASS_GOTO_STMT:
# line 415 "Semantic.puma"
  {
# line 417 "Semantic.puma"
   SemVariable (t->ASS_GOTO_STMT.GOTO_VAR);
# line 419 "Semantic.puma"
 if (!ScalarIntVariable (t->ASS_GOTO_STMT.GOTO_VAR))
        error_protocol ("not scalar integer variable in assigned goto stmt");
   
  }
   return;

  case kCOMP_GOTO_STMT:
# line 424 "Semantic.puma"
  {
# line 426 "Semantic.puma"
 t->COMP_GOTO_STMT.GOTO_EXP = SemExpression (t->COMP_GOTO_STMT.GOTO_EXP);

     if (!ScalarExpr (t->COMP_GOTO_STMT.GOTO_EXP))
        error_protocol ("not scalar expression in computed-goto-stmt");
   
  }
   return;

  case kCOMP_IF_STMT:
# line 433 "Semantic.puma"
  {
# line 435 "Semantic.puma"
 t->COMP_IF_STMT.IF_EXP = SemExpression (t->COMP_IF_STMT.IF_EXP);

     if (!ScalarNumExpr (t->COMP_IF_STMT.IF_EXP))
        error_protocol ("not scalar num expression in arithmetic if stmt");
   
  }
   return;

  case kSTOP_STMT:
# line 442 "Semantic.puma"
   return;

  case kPAUSE_STMT:
# line 445 "Semantic.puma"
   return;

  case kEXIT_STMT:
# line 448 "Semantic.puma"
   return;

  case kCYCLE_STMT:
# line 451 "Semantic.puma"
   return;

  case kRETURN_STMT:
# line 454 "Semantic.puma"
  {
# line 456 "Semantic.puma"
 t->RETURN_STMT.RETURN_EXP = SemExpression (t->RETURN_STMT.RETURN_EXP);

     if (!ScalarIntExpr (t->RETURN_STMT.RETURN_EXP))
        error_protocol ("not scalar integer expression in RETURN");

     if (current_unit->Kind == kPROGRAM_DECL)
        error_protocol ("RETURN not permitted in main program");
   
  }
   return;

  case kREDUCE_STMT:
# line 466 "Semantic.puma"
  {
# line 468 "Semantic.puma"
 

       if (!HasOuterParallelLoop ())
         error_protocol ("REDUCE only in parallel loops allowed");
       else
       { 
         if (    (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident != IsIdent("MINVAL"))
              && (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident != IsIdent("MAXVAL"))  
              && (TreeListLength (t->REDUCE_STMT.RED_PARAMS) > 2  )   )
           error_protocol ("REDUCE with too many parameters");
         CheckReduceParams (t->REDUCE_STMT.RED_PARAMS);
       }
    
  }
   return;

  case kALLOCATE_STMT:
# line 483 "Semantic.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 485 "Semantic.puma"
   FindStatusParameter (t->ALLOCATE_STMT.PARAMS, & yyV1, & yyV2);
# line 486 "Semantic.puma"
 t->ALLOCATE_STMT.STATUS = yyV2; 
      t->ALLOCATE_STMT.PARAMS = yyV1;
    
# line 489 "Semantic.puma"
   CheckAllocateParams (t->ALLOCATE_STMT.PARAMS);
# line 490 "Semantic.puma"
   CheckStatusParameter (t->ALLOCATE_STMT.STATUS);
  }
   return;
 }

  case kDEALLOCATE_STMT:
# line 493 "Semantic.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 495 "Semantic.puma"
   FindStatusParameter (t->DEALLOCATE_STMT.PARAMS, & yyV1, & yyV2);
# line 496 "Semantic.puma"
 t->DEALLOCATE_STMT.STATUS = yyV2; 
      t->DEALLOCATE_STMT.PARAMS = yyV1;
    
# line 499 "Semantic.puma"
   CheckDeallocateParams (t->DEALLOCATE_STMT.PARAMS);
# line 500 "Semantic.puma"
   CheckStatusParameter (t->DEALLOCATE_STMT.STATUS);
  }
   return;
 }

  case kNULLIFY_STMT:
# line 503 "Semantic.puma"
  {
# line 504 "Semantic.puma"
   CheckNullifyParams (t->NULLIFY_STMT.PARAMS);
  }
   return;

  case kREALIGN_STMT:
# line 507 "Semantic.puma"
  {
# line 509 "Semantic.puma"
 t->REALIGN_STMT.distribution = EvalAlignmentStmt (t); 
  }
   return;

  case kREDISTRIBUTE_STMT:
# line 512 "Semantic.puma"
  {
# line 514 "Semantic.puma"
 t->REDISTRIBUTE_STMT.distribution = EvalDistributionStmt (t); 
  }
   return;

  }

# line 517 "Semantic.puma"
  {
# line 518 "Semantic.puma"
   failure_protocol (MODULE, "Semantic", t);
  }
   return;

;
}

static void BodyCheck
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree unit)
# else
(body, unit)
 register tTree body;
 register tTree unit;
# endif
{
  if (body->Kind == kBODY_NODE) {
  if (body->BODY_NODE.STATS->Kind == kACF_EMPTY) {
  if (unit->Kind == kMODULE_DECL) {
# line 534 "Semantic.puma"
   return;

  }
  if (body->BODY_NODE.INTERNALS->Kind == kUNIT_EMPTY) {
  if (unit->Kind == kBLOCK_DATA_DECL) {
# line 541 "Semantic.puma"
   return;

  }
  }
  }
  if (unit->Kind == kMODULE_DECL) {
# line 537 "Semantic.puma"
  {
# line 538 "Semantic.puma"
   simple_error_protocol ("statements in MODULE not allowed");
  }
   return;

  }
  if (body->BODY_NODE.INTERNALS->Kind == kUNIT_EMPTY) {
  if (unit->Kind == kBLOCK_DATA_DECL) {
# line 544 "Semantic.puma"
  {
# line 545 "Semantic.puma"
   simple_error_protocol ("statements in BLOCK_DATA not allowed");
  }
   return;

  }
  }
  if (unit->Kind == kBLOCK_DATA_DECL) {
# line 548 "Semantic.puma"
  {
# line 549 "Semantic.puma"
   simple_error_protocol ("internal subroutines in BLOCK_DATA not allowed");
  }
   return;

  }
  }
;
}

static void SemanticWhere
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int whererank)
# else
(t, whererank)
 register tTree t;
 register int whererank;
# endif
{
# line 563 "Semantic.puma"

char string[50];

  if (t->Kind == kACF_LIST) {
# line 567 "Semantic.puma"
  {
# line 568 "Semantic.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 569 "Semantic.puma"
   SemanticWhere (t->ACF_LIST.Elem, whererank);
# line 570 "Semantic.puma"
   SemanticWhere (t->ACF_LIST.Next, whererank);
  }
   return;

  }
  if (t->Kind == kACF_EMPTY) {
# line 573 "Semantic.puma"
   return;

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 576 "Semantic.puma"
 {
  int rank_lhs;
  int rank_rhs;
  {
# line 578 "Semantic.puma"

# line 579 "Semantic.puma"

# line 581 "Semantic.puma"
   SemVariable (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
# line 583 "Semantic.puma"
 t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = SemExpression (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

     rank_lhs = TreeRank (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
     rank_rhs = TreeRank (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

     if (rank_lhs != whererank)
      { error_protocol ("Assignment in WHERE has wrong rank");
        sprintf (string, "Rank of LHS = %d : " , rank_lhs);
        tree_protocol (string, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
        sprintf (string, "Rank of WHERE exp = %d : " , whererank);
        tree_protocol (string, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
      }
     if (rank_rhs > 0)
      { if (rank_lhs != rank_rhs)
         { error_protocol ("LHS and RHS have different rank");
           sprintf (string, "Rank of LHS = %d : " , rank_lhs);
           tree_protocol (string, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
           sprintf (string, "Rank of RHS = %d : " , rank_rhs);
           tree_protocol (string, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
         }
      }
   
  }
   return;
 }

  }
  }
  if (t->Kind == kACF_WHERE) {
# line 607 "Semantic.puma"
  {
# line 608 "Semantic.puma"
   error_protocol ("Nesting of WHERE not allowed until now");
  }
   return;

  }
# line 611 "Semantic.puma"
  {
# line 612 "Semantic.puma"
   error_protocol ("Illegal Statement in WHERE");
  }
   return;

;
}

static void SemanticElseWhere
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int whererank)
# else
(t, whererank)
 register tTree t;
 register int whererank;
# endif
{
  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Elem->Kind == kACF_WHERE) {
  if (t->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 626 "Semantic.puma"
   return;

  }
  }
  }
# line 629 "Semantic.puma"
  {
# line 631 "Semantic.puma"
   SemanticWhere (t, whererank);
  }
   return;

;
}

static void SemanticIO
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kIO_STMT) {
# line 642 "Semantic.puma"
  {
# line 644 "Semantic.puma"
   if (! (((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("PRINT")) || (t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("WRITE"))))) goto yyL1;
  {
# line 646 "Semantic.puma"
   SemParamList (t->IO_STMT.IO_ITEMS);
# line 647 "Semantic.puma"
   SemIOParams (t->IO_STMT.IO_ITEMS, IntentIn);
  }
  }
   return;
yyL1:;

# line 650 "Semantic.puma"
  {
# line 652 "Semantic.puma"
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("READ")))) goto yyL2;
  {
# line 654 "Semantic.puma"
   SemParamList (t->IO_STMT.IO_ITEMS);
# line 655 "Semantic.puma"
   SemIOParams (t->IO_STMT.IO_ITEMS, IntentOut);
  }
  }
   return;
yyL2:;

# line 658 "Semantic.puma"
  {
# line 660 "Semantic.puma"
   if (! (((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("OPEN")) || (t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("CLOSE")) || (t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("REWIND")) || (t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("BACKSPACE")) || (t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("INQUIRE")) || (t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("ENDFILE"))))) goto yyL3;
  {
# line 668 "Semantic.puma"
   SemIOParams (t->IO_STMT.IO_ITEMS, IntentIn);
  }
  }
   return;
yyL3:;

# line 671 "Semantic.puma"
  {
# line 673 "Semantic.puma"
   error_protocol ("unknown I/O operation");
  }
   return;

  }
# line 676 "Semantic.puma"
  {
# line 677 "Semantic.puma"
   failure_protocol (MODULE, "SemanticIO", t);
  }
   return;

;
}

static void SemIOParams
# if defined __STDC__ | defined __cplusplus
(register tTree items, register int intent)
# else
(items, intent)
 register tTree items;
 register int intent;
# endif
{
  if (items->Kind == kBTP_LIST) {
# line 692 "Semantic.puma"
  {
# line 694 "Semantic.puma"
   SemIOParams (items->BTP_LIST.Elem, intent);
# line 695 "Semantic.puma"
   SemIOParams (items->BTP_LIST.Next, intent);
  }
   return;

  }
  if (items->Kind == kBTP_EMPTY) {
# line 698 "Semantic.puma"
   return;

  }
  if (items->Kind == kVAR_PARAM) {
  if (items->VAR_PARAM.V->Kind == kADDR) {
  if (items->VAR_PARAM.V->ADDR.E->Kind == kDO_EXP) {
# line 701 "Semantic.puma"
  {
# line 703 "Semantic.puma"
   if (! ((intent == IntentOut))) goto yyL3;
  {
# line 707 "Semantic.puma"
 items->VAR_PARAM.V = MakeDoVar (items->VAR_PARAM.V->ADDR.E); 
# line 709 "Semantic.puma"
   CheckIntention (items, intent);
  }
  }
   return;
yyL3:;

  }
  }
# line 712 "Semantic.puma"
  {
# line 714 "Semantic.puma"
   CheckIntention (items, intent);
  }
   return;

  }
# line 717 "Semantic.puma"
  {
# line 719 "Semantic.puma"
   error_protocol ("Cannot handle this READ parameter");
# line 720 "Semantic.puma"
   tree_protocol ("Parameter is ", items);
  }
   return;

;
}

static tTree MakeDoVar
# if defined __STDC__ | defined __cplusplus
(register tTree DoExp)
# else
(DoExp)
 register tTree DoExp;
# endif
{
  if (DoExp->Kind == kDO_EXP) {
# line 731 "Semantic.puma"
   return mDO_VAR (DoExp->DO_EXP.DO_ID, DoExp->DO_EXP.RANGE, MakeDoVar (DoExp->DO_EXP.BODY));

  }
  if (DoExp->Kind == kBTE_LIST) {
  if (DoExp->BTE_LIST.Elem->Kind == kVAR_EXP) {
# line 735 "Semantic.puma"
   return mBTV_LIST (DoExp->BTE_LIST.Elem->VAR_EXP.V, MakeDoVar (DoExp->BTE_LIST.Next));

  }
  if (DoExp->BTE_LIST.Elem->Kind == kDO_EXP) {
# line 740 "Semantic.puma"
   return mBTV_LIST (MakeDoVar (DoExp->BTE_LIST.Elem), MakeDoVar (DoExp->BTE_LIST.Next));

  }
# line 744 "Semantic.puma"
  {
# line 746 "Semantic.puma"
   error_protocol ("Illegal READ parameter in implied DO loop");
# line 747 "Semantic.puma"
   tree_protocol ("Expression is : ", DoExp->BTE_LIST.Elem);
  }
   return mBTV_LIST (mADDR (DoExp->BTE_LIST.Elem), MakeDoVar (DoExp->BTE_LIST.Next));

  }
  if (DoExp->Kind == kBTE_EMPTY) {
# line 751 "Semantic.puma"
   return mBTV_EMPTY ();

  }
 yyAbort ("MakeDoVar");
}

static void CheckReduceParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_EMPTY) {
# line 765 "Semantic.puma"
   return;

  }
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 768 "Semantic.puma"
  {
# line 770 "Semantic.puma"
 if (!IsVarArgument (t->BTP_LIST.Elem))
       { error_protocol ("Variable required for reduce");
         tree_protocol ("This parameter is not a variable : ", t->BTP_LIST.Elem);
       }
   
# line 776 "Semantic.puma"
   SemParameter (t->BTP_LIST.Elem);
# line 777 "Semantic.puma"
   SemParameter (t->BTP_LIST.Next->BTP_LIST.Elem);
# line 779 "Semantic.puma"
 if (TreeRank (t->BTP_LIST.Elem) != 0)
       { error_protocol ("only scalar variable in reduce");
         tree_protocol ("this variable is not scalar : ", t->BTP_LIST.Elem);
       }

     if (TreeRank (t->BTP_LIST.Next->BTP_LIST.Elem) != 0)
       { error_protocol ("only scalar expression in reduce");
         tree_protocol ("this expression is not scalar : ", t->BTP_LIST.Next->BTP_LIST.Elem);
       }
   
# line 789 "Semantic.puma"
   CheckReduceParams (t->BTP_LIST.Next->BTP_LIST.Next);
  }
   return;

  }
  }
# line 792 "Semantic.puma"
  {
# line 793 "Semantic.puma"
   error_protocol ("Illegal parameter list for REDUCE");
# line 794 "Semantic.puma"
   print_protocol ("REDUCE (f, var, exp, var, exp, ..., var, exp)");
  }
   return;

;
}

static void FindStatusParameter
# if defined __STDC__ | defined __cplusplus
(register tTree params, register tTree * yyP2, register tTree * yyP1)
# else
(params, yyP2, yyP1)
 register tTree params;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (params->Kind == kBTP_EMPTY) {
# line 805 "Semantic.puma"
   * yyP2 = params;
   * yyP1 = mDUMMY_VAR ();
   return;

  }
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
  if (params->BTP_LIST.Elem->NAMED_PARAM.VAL->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 808 "Semantic.puma"
  {
# line 809 "Semantic.puma"
   if (! ((params->BTP_LIST.Elem->NAMED_PARAM.Name == IsIdent ("STAT", 4)))) goto yyL2;
  }
   * yyP2 = params->BTP_LIST.Next;
   * yyP1 = params->BTP_LIST.Elem->NAMED_PARAM.VAL->VAR_PARAM.V;
   return;
yyL2:;

  }
  }
  }
# line 812 "Semantic.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 813 "Semantic.puma"
   FindStatusParameter (params->BTP_LIST.Next, & yyV1, & yyV2);
# line 814 "Semantic.puma"
 params->BTP_LIST.Next = yyV1; 
  }
   * yyP2 = params;
   * yyP1 = yyV2;
   return;
 }

  }
# line 817 "Semantic.puma"
  {
# line 818 "Semantic.puma"
   failure_protocol (MODULE, "FindStatusParameter", params);
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static void CheckStatusParameter
# if defined __STDC__ | defined __cplusplus
(register tTree status)
# else
(status)
 register tTree status;
# endif
{
  if (status->Kind == kDUMMY_VAR) {
# line 823 "Semantic.puma"
   return;

  }
# line 828 "Semantic.puma"
  {
# line 830 "Semantic.puma"
 if (!ScalarIntVariable (status))
        error_protocol ("status in ALLOCATE/DEALLOCATE must be scalar integer");
   
  }
   return;

;
}

static void CheckNullifyParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
# line 843 "Semantic.puma"
  {
# line 845 "Semantic.puma"
   SemParameter (t->BTP_LIST.Elem);
# line 846 "Semantic.puma"
   CheckNullifyParam (t->BTP_LIST.Elem);
# line 847 "Semantic.puma"
   CheckNullifyParams (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->Kind == kBTP_EMPTY) {
# line 850 "Semantic.puma"
   return;

  }
;
}

static void CheckNullifyParam
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
# line 855 "Semantic.puma"
  {
# line 856 "Semantic.puma"
   error_protocol ("illegal parameter for nullify");
  }
   return;

  }
# line 859 "Semantic.puma"
  {
# line 861 "Semantic.puma"
 if (!PointerObject (t->VAR_PARAM.V))
       error_protocol ("NULLIFY can only be appled to pointer variables");
  
  }
   return;

  }
# line 866 "Semantic.puma"
  {
# line 867 "Semantic.puma"
   error_protocol ("illegal parameter for nullify");
  }
   return;

;
}

static void CheckAllocParam
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kADDR) {
# line 878 "Semantic.puma"
  {
# line 879 "Semantic.puma"
   error_protocol ("expressions not allowed in ALLOCATE");
# line 880 "Semantic.puma"
   tree_protocol ("wrong parameter is ", var);
  }
   return;

  }
# line 883 "Semantic.puma"
  {
# line 885 "Semantic.puma"
   if (! ((IsPointerType (GetVariableType (var))))) goto yyL2;
  }
   return;
yyL2:;

  if (var->Kind == kINDEXED_VAR) {
# line 888 "Semantic.puma"
  {
# line 890 "Semantic.puma"
   if (! ((TreeRank (var->INDEXED_VAR.IND_VAR) != TreeListLength (var->INDEXED_VAR.IND_EXPS)))) goto yyL3;
  {
# line 891 "Semantic.puma"
   error_protocol ("illegal number of dimensions in ALLOCATE");
# line 892 "Semantic.puma"
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL3:;

  if (var->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
# line 895 "Semantic.puma"
  {
# line 897 "Semantic.puma"
   if (! ((TreeRank (var->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR) != 0))) goto yyL4;
  {
# line 898 "Semantic.puma"
   error_protocol ("only one component of type can be ALLOCATEd");
# line 899 "Semantic.puma"
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL4:;

# line 902 "Semantic.puma"
  {
# line 904 "Semantic.puma"
   if (! ((! IsVarAllocatable (var->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELECTOR->REC_COMP.Object)))) goto yyL5;
  {
# line 905 "Semantic.puma"
   error_protocol ("ALLOCATE : record component cannot be allocated");
# line 906 "Semantic.puma"
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL5:;

# line 909 "Semantic.puma"
  {
# line 913 "Semantic.puma"
   NormalAllocateParams (var->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
  if (var->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 916 "Semantic.puma"
  {
# line 918 "Semantic.puma"
   if (! ((! IsVarAllocatable (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL7;
  {
# line 919 "Semantic.puma"
   error_protocol ("Not allocatable array in ALLOCATE");
# line 920 "Semantic.puma"
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL7:;

# line 923 "Semantic.puma"
  {
# line 925 "Semantic.puma"
   NormalAllocateParams (var->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
  }
  if (var->Kind == kUSED_VAR) {
# line 928 "Semantic.puma"
  {
# line 930 "Semantic.puma"
   if (! ((IsTreeObject (var->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL9;
  }
   return;
yyL9:;

  }
# line 933 "Semantic.puma"
  {
# line 935 "Semantic.puma"
   error_protocol ("Illegal Parameter in ALLOCATE");
# line 936 "Semantic.puma"
   tree_protocol ("wrong parameter is ", var);
  }
   return;

;
}

static void CheckAllocateParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 949 "Semantic.puma"
  {
# line 951 "Semantic.puma"
   CheckAllocParam (t->BTP_LIST.Elem->VAR_PARAM.V);
# line 952 "Semantic.puma"
   CheckAllocateParams (t->BTP_LIST.Next);
  }
   return;

  }
  }
  if (t->Kind == kBTP_EMPTY) {
# line 955 "Semantic.puma"
   return;

  }
;
}

static void NormalAllocateParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_EMPTY) {
# line 968 "Semantic.puma"
   return;

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 971 "Semantic.puma"
  {
# line 973 "Semantic.puma"
 if (!ScalarIntExpr (t->BTE_LIST.Elem->SLICE_EXP.START))
        { error_protocol ("exp in ALLOCATE must be scalar integer expression");
          tree_protocol ("illegal expression is : ", t->BTE_LIST.Elem->SLICE_EXP.START);
        }
     if (!ScalarIntExpr (t->BTE_LIST.Elem->SLICE_EXP.STOP))
        { error_protocol ("exp in ALLOCATE must be scalar integer expression");
          tree_protocol ("illegal expression is : ", t->BTE_LIST.Elem->SLICE_EXP.STOP);
        }
   
# line 983 "Semantic.puma"
   NormalAllocateParams (t->BTE_LIST.Next);
  }
   return;

  }
# line 986 "Semantic.puma"
  {
# line 988 "Semantic.puma"
 if (!ScalarIntExpr (t->BTE_LIST.Elem))
        { error_protocol ("exp in ALLOCATE must be scalar integer expression");
          tree_protocol ("illegal expression is : ", t->BTE_LIST.Elem);
        }

     t->BTE_LIST.Elem = mSLICE_EXP (mCONST_EXP(mINT_CONSTANT (1)), t->BTE_LIST.Elem, mDUMMY_EXP());

   
# line 997 "Semantic.puma"
   NormalAllocateParams (t->BTE_LIST.Next);
  }
   return;

  }
;
}

static void CheckDeallocParameter
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 1008 "Semantic.puma"
  {
# line 1010 "Semantic.puma"
   if (! ((IsPointerType (GetVariableType (var))))) goto yyL1;
  }
   return;
yyL1:;

  if (var->Kind == kUSED_VAR) {
# line 1013 "Semantic.puma"
  {
# line 1015 "Semantic.puma"
   if (! ((! IsVarAllocatable (var->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL2;
  {
# line 1017 "Semantic.puma"
   error_protocol ("Not allocatable array in DEALLOCATE");
# line 1018 "Semantic.puma"
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL2:;

# line 1021 "Semantic.puma"
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
# line 1024 "Semantic.puma"
  {
# line 1026 "Semantic.puma"
   if (! ((TreeRank (var->SELECTED_VAR.SELEC_VAR) != 0))) goto yyL4;
  {
# line 1028 "Semantic.puma"
   error_protocol ("only one component of type can be DEALLOCATEd");
# line 1029 "Semantic.puma"
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL4:;

# line 1032 "Semantic.puma"
  {
# line 1034 "Semantic.puma"
   if (! ((! IsVarAllocatable (var->SELECTED_VAR.SELECTOR->REC_COMP.Object)))) goto yyL5;
  {
# line 1036 "Semantic.puma"
   error_protocol ("DEALLOCATE : record component cannot be deallocated");
# line 1037 "Semantic.puma"
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL5:;

# line 1040 "Semantic.puma"
   return;

  }
# line 1045 "Semantic.puma"
  {
# line 1047 "Semantic.puma"
   error_protocol ("Illegal Parameter in DEALLOCATE");
# line 1048 "Semantic.puma"
   tree_protocol ("wrong parameter is ", var);
  }
   return;

;
}

static void CheckDeallocateParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 1059 "Semantic.puma"
  {
# line 1061 "Semantic.puma"
   CheckDeallocParameter (t->BTP_LIST.Elem->VAR_PARAM.V);
# line 1062 "Semantic.puma"
   CheckDeallocateParams (t->BTP_LIST.Next);
  }
   return;

  }
  }
  if (t->Kind == kBTP_EMPTY) {
# line 1065 "Semantic.puma"
   return;

  }
;
}

static bool IsVarArgument
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
# line 1076 "Semantic.puma"
  {
# line 1078 "Semantic.puma"
   return false;
  }

  }
# line 1081 "Semantic.puma"
   return true;

  }
  return false;
}

static void SemCaseAlternatives
# if defined __STDC__ | defined __cplusplus
(register tTree alts, register tTree case_exp)
# else
(alts, case_exp)
 register tTree alts;
 register tTree case_exp;
# endif
{
  if (alts->Kind == kSELECTED_ACF_LIST) {
# line 1092 "Semantic.puma"
  {
# line 1094 "Semantic.puma"
   SemCaseAlternatives (alts->SELECTED_ACF_LIST.Elem, case_exp);
# line 1095 "Semantic.puma"
   SemCaseAlternatives (alts->SELECTED_ACF_LIST.Next, case_exp);
  }
   return;

  }
  if (alts->Kind == kSELECTED_ACF_EMPTY) {
# line 1098 "Semantic.puma"
   return;

  }
  if (alts->Kind == kSELECTED_ACF_NODE) {
# line 1101 "Semantic.puma"
  {
# line 1103 "Semantic.puma"
   SemCaseValueRanges (alts->SELECTED_ACF_NODE.SELECT_LIST, case_exp);
# line 1104 "Semantic.puma"
   Semantic (alts->SELECTED_ACF_NODE.SELECT_ACFS);
  }
   return;

  }
;
}

static void SemCaseValueRanges
# if defined __STDC__ | defined __cplusplus
(register tTree explist, register tTree case_exp)
# else
(explist, case_exp)
 register tTree explist;
 register tTree case_exp;
# endif
{
  if (explist->Kind == kBTE_LIST) {
# line 1115 "Semantic.puma"
  {
# line 1117 "Semantic.puma"
   SemCaseValueRanges (explist->BTE_LIST.Next, case_exp);
# line 1118 "Semantic.puma"
   SemCaseValueRange (explist->BTE_LIST.Elem, case_exp);
  }
   return;

  }
  if (explist->Kind == kBTE_EMPTY) {
# line 1121 "Semantic.puma"
   return;

  }
# line 1124 "Semantic.puma"
  {
# line 1125 "Semantic.puma"
   failure_protocol (MODULE, "SemCaseValueRanges", explist);
  }
   return;

;
}

static void SemCaseValueRange
# if defined __STDC__ | defined __cplusplus
(register tTree case_value, register tTree case_exp)
# else
(case_value, case_exp)
 register tTree case_value;
 register tTree case_exp;
# endif
{
  if (case_value->Kind == kSLICE_EXP) {
  if (case_value->SLICE_EXP.START->Kind == kDUMMY_EXP) {
# line 1136 "Semantic.puma"
  {
# line 1140 "Semantic.puma"
   SemCaseValue (case_value->SLICE_EXP.STOP, case_exp);
  }
   return;

  }
  if (case_value->SLICE_EXP.STOP->Kind == kDUMMY_EXP) {
# line 1143 "Semantic.puma"
  {
# line 1147 "Semantic.puma"
   SemCaseValue (case_value->SLICE_EXP.START, case_exp);
  }
   return;

  }
# line 1150 "Semantic.puma"
  {
# line 1154 "Semantic.puma"
   SemCaseValue (case_value->SLICE_EXP.START, case_exp);
# line 1155 "Semantic.puma"
   SemCaseValue (case_value->SLICE_EXP.STOP, case_exp);
  }
   return;

  }
# line 1158 "Semantic.puma"
  {
# line 1159 "Semantic.puma"
   SemCaseValue (case_value, case_exp);
  }
   return;

;
}

static void SemCaseValue
# if defined __STDC__ | defined __cplusplus
(register tTree case_value, register tTree case_exp)
# else
(case_value, case_exp)
 register tTree case_value;
 register tTree case_exp;
# endif
{
# line 1170 "Semantic.puma"
  {
# line 1172 "Semantic.puma"
 if (!ScalarCaseExpr (case_value))
        error_protocol ("scalar numeric expression in CASE required");
   
  }
   return;

;
}

static void SemDoRange
# if defined __STDC__ | defined __cplusplus
(register tTree range)
# else
(range)
 register tTree range;
# endif
{
  if (range->Kind == kSLICE_EXP) {
  if (range->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
# line 1185 "Semantic.puma"
  {
# line 1187 "Semantic.puma"
 range->SLICE_EXP.START  = SemExpression (range->SLICE_EXP.START);
     range->SLICE_EXP.STOP  = SemExpression (range->SLICE_EXP.STOP);

     if (!ScalarNumExpr (range->SLICE_EXP.START))
        error_protocol ("start value in DO no scalar numerical expression");
     if (!ScalarNumExpr (range->SLICE_EXP.STOP))
        error_protocol ("stop value in DO no scalar numerical expression");
   
  }
   return;

  }
# line 1197 "Semantic.puma"
  {
# line 1199 "Semantic.puma"
 range->SLICE_EXP.START  = SemExpression (range->SLICE_EXP.START);
     range->SLICE_EXP.STOP  = SemExpression (range->SLICE_EXP.STOP);
     range->SLICE_EXP.INC = SemExpression (range->SLICE_EXP.INC);

     if (!ScalarNumExpr (range->SLICE_EXP.START))
        error_protocol ("start value in DO no scalar numerical expression");
     if (!ScalarNumExpr (range->SLICE_EXP.STOP))
        error_protocol ("stop value in DO no scalar numerical expression");
     if (!ScalarNumExpr (range->SLICE_EXP.INC))
        error_protocol ("stride value in DO no scalar numerical expression");
   
  }
   return;

  }
# line 1212 "Semantic.puma"
  {
# line 1213 "Semantic.puma"
   failure_protocol (MODULE, "SemDoRange", range);
  }
   return;

;
}

void BeginSemantic ()
{
}

void CloseSemantic ()
{
}
