# include "SemPreds.h"
# include "yySemPreds.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 58 "SemPreds.puma"


# define MODULE "SemPreds"

# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "Types.h"
# include "Objects.h"

# include "Expressions.h"  /* GetIntConstValue */
# include "Rank.h"         /* TreeRank, ...    */

char type_error_msg[100];



static void yyExit () { Exit (1); }

void (* SemPreds_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemPreds, routine %s failed\n", yyFunction);
 SemPreds_Exit ();
}

bool ScalarExpr ARGS((tTree exp));
static bool DummyExpr ARGS((tTree exp));
bool IntExpr ARGS((tTree exp));
bool LogicalExpr ARGS((tTree exp));
bool NormalRealExpr ARGS((tTree exp));
bool DoubleRealExpr ARGS((tTree exp));
bool ComplexExpr ARGS((tTree exp));
bool StringExpr ARGS((tTree exp));
bool RealExpr ARGS((tTree exp));
bool NumExpr ARGS((tTree exp));
bool CaseExpr ARGS((tTree exp));
bool SortExpr ARGS((tTree exp));
bool ScalarLogicalExpr ARGS((tTree exp));
bool ScalarIntExpr ARGS((tTree exp));
bool ScalarNumExpr ARGS((tTree exp));
bool ScalarCaseExpr ARGS((tTree exp));
bool ScalarVariable ARGS((tTree var));
bool DoVariable ARGS((tTree var));
bool ScalarIntVariable ARGS((tTree var));
bool PointerObject ARGS((tTree var));
bool AllocateObject ARGS((tTree var));
bool InitializationExpr ARGS((tTree exp));
bool Expr ARGS((tTree exp));
bool InitIntExpr ARGS((tTree exp));
bool ArrayExpr ARGS((tTree exp));
bool DummyHPFArray ARGS((tTree exp));
bool IsLegalOutVar ARGS((tTree var));
bool IsDefinableParam ARGS((tTree t));
static bool IsParameterVariable ARGS((tTree var));
static bool IsVectorVariable ARGS((tTree var));
static bool HasVectorIndex ARGS((tTree exp_list));

bool ScalarExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 84 "SemPreds.puma"
  {
# line 85 "SemPreds.puma"
   if (! ((TreeRank (exp) == 0))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

static bool DummyExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 104 "SemPreds.puma"
 {
  type_rec t;
  {
# line 106 "SemPreds.puma"

# line 108 "SemPreds.puma"
   GetExpType (exp, & t);
# line 109 "SemPreds.puma"
   if (! ((t . type_kind == kDUMMY_TYPE))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

bool IntExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 118 "SemPreds.puma"
 {
  type_rec t;
  {
# line 120 "SemPreds.puma"

# line 122 "SemPreds.puma"
   GetExpType (exp, & t);
# line 123 "SemPreds.puma"
   if (! (((t . type_kind == kINTEGER_TYPE) || (t . type_kind == kDUMMY_TYPE)))) goto yyL1;
  }
   return true;
 }
yyL1:;

# line 126 "SemPreds.puma"
  {
# line 127 "SemPreds.puma"
   sprintf (type_error_msg, "is not integer");
# line 128 "SemPreds.puma"
   return false;
  }

}

bool LogicalExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 137 "SemPreds.puma"
 {
  type_rec t;
  {
# line 139 "SemPreds.puma"

# line 141 "SemPreds.puma"
   GetExpType (exp, & t);
# line 142 "SemPreds.puma"
   if (! (((t . type_kind == kDUMMY_TYPE) || (t . type_kind == kBOOLEAN_TYPE)))) goto yyL1;
  }
   return true;
 }
yyL1:;

# line 145 "SemPreds.puma"
  {
# line 146 "SemPreds.puma"
   sprintf (type_error_msg, "is not logical");
# line 147 "SemPreds.puma"
   return false;
  }

}

bool NormalRealExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 156 "SemPreds.puma"
  {
# line 157 "SemPreds.puma"
   if (! ((DummyExpr (exp)))) goto yyL1;
  }
   return true;
yyL1:;

# line 160 "SemPreds.puma"
 {
  type_rec t;
  {
# line 162 "SemPreds.puma"

# line 164 "SemPreds.puma"
   GetExpType (exp, & t);
# line 165 "SemPreds.puma"
   if (! ((t . type_kind == kREAL_TYPE))) goto yyL2;
  {
# line 166 "SemPreds.puma"
   if (! ((t . type_size == default_real_size))) goto yyL2;
  }
  }
   return true;
 }
yyL2:;

# line 169 "SemPreds.puma"
  {
# line 170 "SemPreds.puma"
   sprintf (type_error_msg, "is not default real");
# line 171 "SemPreds.puma"
   return false;
  }

}

bool DoubleRealExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 180 "SemPreds.puma"
  {
# line 181 "SemPreds.puma"
   if (! ((DummyExpr (exp)))) goto yyL1;
  }
   return true;
yyL1:;

# line 184 "SemPreds.puma"
 {
  type_rec t;
  {
# line 186 "SemPreds.puma"

# line 188 "SemPreds.puma"
   GetExpType (exp, & t);
# line 189 "SemPreds.puma"
   if (! ((t . type_kind == kREAL_TYPE))) goto yyL2;
  {
# line 190 "SemPreds.puma"
   if (! ((t . type_size == 2 * default_real_size))) goto yyL2;
  }
  }
   return true;
 }
yyL2:;

# line 193 "SemPreds.puma"
  {
# line 194 "SemPreds.puma"
   sprintf (type_error_msg, "is not double real");
# line 195 "SemPreds.puma"
   return false;
  }

}

bool ComplexExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 204 "SemPreds.puma"
  {
# line 205 "SemPreds.puma"
   if (! ((DummyExpr (exp)))) goto yyL1;
  }
   return true;
yyL1:;

# line 208 "SemPreds.puma"
 {
  type_rec t;
  {
# line 210 "SemPreds.puma"

# line 212 "SemPreds.puma"
   GetExpType (exp, & t);
# line 213 "SemPreds.puma"
   if (! ((t . type_kind == kCOMPLEX_TYPE))) goto yyL2;
  }
   return true;
 }
yyL2:;

# line 216 "SemPreds.puma"
  {
# line 217 "SemPreds.puma"
   sprintf (type_error_msg, "is not complex");
# line 218 "SemPreds.puma"
   return false;
  }

}

bool StringExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 227 "SemPreds.puma"
  {
# line 228 "SemPreds.puma"
   if (! ((DummyExpr (exp)))) goto yyL1;
  }
   return true;
yyL1:;

# line 231 "SemPreds.puma"
 {
  type_rec t;
  {
# line 233 "SemPreds.puma"

# line 235 "SemPreds.puma"
   GetExpType (exp, & t);
# line 236 "SemPreds.puma"
   if (! ((t . type_kind == kSTRING_TYPE))) goto yyL2;
  }
   return true;
 }
yyL2:;

# line 239 "SemPreds.puma"
  {
# line 240 "SemPreds.puma"
   sprintf (type_error_msg, "is not string");
# line 241 "SemPreds.puma"
   return false;
  }

}

bool RealExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 250 "SemPreds.puma"
 {
  type_rec t;
  {
# line 252 "SemPreds.puma"

# line 254 "SemPreds.puma"
   GetExpType (exp, & t);
# line 255 "SemPreds.puma"
   if (! (((t . type_kind == kDUMMY_TYPE) || (t . type_kind == kREAL_TYPE)))) goto yyL1;
  }
   return true;
 }
yyL1:;

# line 258 "SemPreds.puma"
  {
# line 259 "SemPreds.puma"
   sprintf (type_error_msg, "is not real");
# line 260 "SemPreds.puma"
   return false;
  }

}

bool NumExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 269 "SemPreds.puma"
 {
  type_rec t;
  {
# line 271 "SemPreds.puma"

# line 273 "SemPreds.puma"
   GetExpType (exp, & t);
# line 275 "SemPreds.puma"
   if (! (((t . type_kind == kDUMMY_TYPE) || (t . type_kind == kINTEGER_TYPE) || (t . type_kind == kREAL_TYPE) || (t . type_kind == kCOMPLEX_TYPE)))) goto yyL1;
  }
   return true;
 }
yyL1:;

# line 281 "SemPreds.puma"
  {
# line 282 "SemPreds.puma"
   sprintf (type_error_msg, "is not numerical (int/real/complex)");
# line 283 "SemPreds.puma"
   return false;
  }

}

bool CaseExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 292 "SemPreds.puma"
 {
  type_rec t;
  {
# line 294 "SemPreds.puma"

# line 296 "SemPreds.puma"
   GetExpType (exp, & t);
# line 298 "SemPreds.puma"
   if (! (((t . type_kind == kDUMMY_TYPE) || (t . type_kind == kINTEGER_TYPE) || (t . type_kind == kBOOLEAN_TYPE) || (t . type_kind == kSTRING_TYPE)))) goto yyL1;
  }
   return true;
 }
yyL1:;

# line 305 "SemPreds.puma"
  {
# line 306 "SemPreds.puma"
   sprintf (type_error_msg, "is not base type");
# line 307 "SemPreds.puma"
   return false;
  }

}

bool SortExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 316 "SemPreds.puma"
 {
  type_rec t;
  {
# line 318 "SemPreds.puma"

# line 320 "SemPreds.puma"
   GetExpType (exp, & t);
# line 322 "SemPreds.puma"
   if (! (((t . type_kind == kDUMMY_TYPE) || (t . type_kind == kINTEGER_TYPE) || (t . type_kind == kREAL_TYPE) || (t . type_kind == kSTRING_TYPE)))) goto yyL1;
  }
   return true;
 }
yyL1:;

# line 328 "SemPreds.puma"
  {
# line 329 "SemPreds.puma"
   sprintf (type_error_msg, "is not sortable (int/real/character)");
# line 330 "SemPreds.puma"
   return false;
  }

}

bool ScalarLogicalExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 350 "SemPreds.puma"
  {
# line 351 "SemPreds.puma"
   if (! ((LogicalExpr (exp)))) goto yyL1;
  {
# line 352 "SemPreds.puma"
   if (! ((ScalarExpr (exp)))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 355 "SemPreds.puma"
  {
# line 356 "SemPreds.puma"
   sprintf (type_error_msg, "is not scalar logical");
# line 357 "SemPreds.puma"
   return false;
  }

}

bool ScalarIntExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kDUMMY_EXP) {
# line 366 "SemPreds.puma"
   return true;

  }
# line 369 "SemPreds.puma"
  {
# line 370 "SemPreds.puma"
   if (! ((IntExpr (exp)))) goto yyL2;
  {
# line 371 "SemPreds.puma"
   if (! ((ScalarExpr (exp)))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 374 "SemPreds.puma"
  {
# line 375 "SemPreds.puma"
   sprintf (type_error_msg, "is not scalar integer");
# line 376 "SemPreds.puma"
   return false;
  }

}

bool ScalarNumExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 385 "SemPreds.puma"
  {
# line 386 "SemPreds.puma"
   if (! (NumExpr (exp))) goto yyL1;
  {
# line 387 "SemPreds.puma"
   if (! (ScalarExpr (exp))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 390 "SemPreds.puma"
  {
# line 391 "SemPreds.puma"
   sprintf (type_error_msg, "is not scalar numerical");
# line 392 "SemPreds.puma"
   return false;
  }

}

bool ScalarCaseExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 401 "SemPreds.puma"
  {
# line 402 "SemPreds.puma"
   if (! ((CaseExpr (exp)))) goto yyL1;
  {
# line 403 "SemPreds.puma"
   if (! ((ScalarExpr (exp)))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 406 "SemPreds.puma"
  {
# line 407 "SemPreds.puma"
   sprintf (type_error_msg, "is not scalar case expr");
# line 408 "SemPreds.puma"
   return false;
  }

}

bool ScalarVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 421 "SemPreds.puma"
  {
# line 422 "SemPreds.puma"
   if (! ((TreeRank (var) == 0))) goto yyL1;
  }
   return true;
yyL1:;

# line 425 "SemPreds.puma"
  {
# line 426 "SemPreds.puma"
   sprintf (type_error_msg, "is not scalar variable");
# line 427 "SemPreds.puma"
   return false;
  }

}

bool DoVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 438 "SemPreds.puma"
  {
# line 439 "SemPreds.puma"
   if (! ((ScalarVariable (var)))) goto yyL1;
  {
# line 440 "SemPreds.puma"
   if (! ((IntExpr (var)))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 443 "SemPreds.puma"
  {
# line 444 "SemPreds.puma"
   if (! ((ScalarVariable (var)))) goto yyL2;
  {
# line 445 "SemPreds.puma"
   if (! ((RealExpr (var)))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 448 "SemPreds.puma"
  {
# line 449 "SemPreds.puma"
   sprintf (type_error_msg, "is illegal do variable");
# line 450 "SemPreds.puma"
   return false;
  }

}

bool ScalarIntVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 461 "SemPreds.puma"
  {
# line 462 "SemPreds.puma"
   if (! ((ScalarVariable (var)))) goto yyL1;
  {
# line 463 "SemPreds.puma"
   if (! ((IntExpr (var)))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 466 "SemPreds.puma"
  {
# line 467 "SemPreds.puma"
   sprintf (type_error_msg, "is not scalar integer variable");
# line 468 "SemPreds.puma"
   return false;
  }

}

bool PointerObject
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kVAR_PARAM) {
# line 480 "SemPreds.puma"
  {
# line 482 "SemPreds.puma"
   if (! ((PointerObject (var->VAR_PARAM.V)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (var->Kind == kUSED_VAR) {
# line 485 "SemPreds.puma"
  {
# line 487 "SemPreds.puma"
   if (! ((IsPointerType (GetObjectType (var->USED_VAR.VARNAME->VAR_OBJ.Object))))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (var->Kind == kSELECTED_VAR) {
# line 490 "SemPreds.puma"
  {
# line 492 "SemPreds.puma"
   if (! ((IsPointerType (GetObjectType (var->SELECTED_VAR.SELECTOR->REC_COMP.Object))))) goto yyL3;
  }
   return true;
yyL3:;

  }
# line 495 "SemPreds.puma"
  {
# line 496 "SemPreds.puma"
   sprintf (type_error_msg, "is not pointer object");
# line 497 "SemPreds.puma"
   return false;
  }

}

bool AllocateObject
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kVAR_PARAM) {
# line 511 "SemPreds.puma"
  {
# line 513 "SemPreds.puma"
   if (! ((AllocateObject (var->VAR_PARAM.V)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (var->Kind == kUSED_VAR) {
# line 516 "SemPreds.puma"
   return true;

  }
  if (var->Kind == kSELECTED_VAR) {
# line 519 "SemPreds.puma"
   return true;

  }
# line 522 "SemPreds.puma"
  {
# line 523 "SemPreds.puma"
   sprintf (type_error_msg, "is not allocatable object");
# line 524 "SemPreds.puma"
   return false;
  }

}

bool InitializationExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 529 "SemPreds.puma"
   return true;

}

bool Expr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 539 "SemPreds.puma"
   return true;

}

bool InitIntExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 544 "SemPreds.puma"
  {
# line 545 "SemPreds.puma"
   if (! ((InitializationExpr (exp)))) goto yyL1;
  {
# line 546 "SemPreds.puma"
   if (! ((IntExpr (exp)))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 549 "SemPreds.puma"
  {
# line 550 "SemPreds.puma"
   sprintf (type_error_msg, "not integer initialization expr");
# line 551 "SemPreds.puma"
   return false;
  }

}

bool ArrayExpr
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 556 "SemPreds.puma"
  {
# line 557 "SemPreds.puma"
   if (! ((TreeRank (exp) > 0))) goto yyL1;
  }
   return true;
yyL1:;

# line 560 "SemPreds.puma"
  {
# line 561 "SemPreds.puma"
   sprintf (type_error_msg, "is scalar");
# line 562 "SemPreds.puma"
   return false;
  }

}

bool DummyHPFArray
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 567 "SemPreds.puma"
   return true;

}

bool IsLegalOutVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 585 "SemPreds.puma"
  {
# line 587 "SemPreds.puma"
   if (! ((IsLegalOutVar (var->INDEXED_VAR.IND_VAR)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (var->Kind == kSELECTED_VAR) {
# line 590 "SemPreds.puma"
  {
# line 592 "SemPreds.puma"
   if (! ((IsLegalOutVar (var->SELECTED_VAR.SELEC_VAR)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (var->Kind == kSUBSTRING_VAR) {
# line 595 "SemPreds.puma"
  {
# line 597 "SemPreds.puma"
   if (! ((IsLegalOutVar (var->SUBSTRING_VAR.IND_VAR)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  if (var->Kind == kUSED_VAR) {
  if (var->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kVarObject) {
  if (var->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.Kind->Kind == kVarParameter) {
# line 600 "SemPreds.puma"
  {
# line 602 "SemPreds.puma"
   sprintf (type_error_msg, "left hand side of assignment must not be parameter");
# line 604 "SemPreds.puma"
   return false;
  }

  }
# line 607 "SemPreds.puma"
   return true;

  }
  }
  if (var->Kind == kLOOP_VAR) {
# line 610 "SemPreds.puma"
  {
# line 612 "SemPreds.puma"
   sprintf (type_error_msg, "loop variable cannot appear as lhs of assignment");
  }
   return true;

  }
# line 616 "SemPreds.puma"
  {
# line 617 "SemPreds.puma"
   sprintf (type_error_msg, "illegal lhs in assignment");
# line 618 "SemPreds.puma"
   return false;
  }

}

bool IsDefinableParam
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
# line 629 "SemPreds.puma"
  {
# line 631 "SemPreds.puma"
   return false;
  }

  }
# line 634 "SemPreds.puma"
  {
# line 636 "SemPreds.puma"
   if (! ((IsParameterVariable (t->VAR_PARAM.V)))) goto yyL2;
  {
# line 638 "SemPreds.puma"
   return false;
  }
  }
yyL2:;

# line 641 "SemPreds.puma"
  {
# line 643 "SemPreds.puma"
   if (! ((IsVectorVariable (t->VAR_PARAM.V)))) goto yyL3;
  {
# line 645 "SemPreds.puma"
   return false;
  }
  }
yyL3:;

# line 648 "SemPreds.puma"
   return true;

  }
  return false;
}

static bool IsParameterVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kVAR_OBJ) {
# line 661 "SemPreds.puma"
  {
# line 663 "SemPreds.puma"
   if (! ((IsVarParameter (var->VAR_OBJ.Object)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (var->Kind == kUSED_VAR) {
# line 666 "SemPreds.puma"
  {
# line 668 "SemPreds.puma"
   if (! ((IsParameterVariable (var->USED_VAR.VARNAME)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (var->Kind == kINDEXED_VAR) {
# line 671 "SemPreds.puma"
  {
# line 673 "SemPreds.puma"
   if (! ((IsParameterVariable (var->INDEXED_VAR.IND_VAR)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

static bool IsVectorVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 679 "SemPreds.puma"
  {
# line 681 "SemPreds.puma"
   if (! ((HasVectorIndex (var->INDEXED_VAR.IND_EXPS)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  return false;
}

static bool HasVectorIndex
# if defined __STDC__ | defined __cplusplus
(register tTree exp_list)
# else
(exp_list)
 register tTree exp_list;
# endif
{
  if (exp_list->Kind == kBTE_LIST) {
# line 686 "SemPreds.puma"
  {
# line 688 "SemPreds.puma"
   if (! ((HasVectorIndex (exp_list->BTE_LIST.Next)))) goto yyL1;
  }
   return true;
yyL1:;

  if (exp_list->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 691 "SemPreds.puma"
  {
# line 693 "SemPreds.puma"
   if (! ((HasVectorIndex (exp_list->BTE_LIST.Next)))) goto yyL2;
  }
   return true;
yyL2:;

# line 696 "SemPreds.puma"
  {
# line 698 "SemPreds.puma"
   return false;
  }

  }
# line 701 "SemPreds.puma"
  {
# line 703 "SemPreds.puma"
   if (! ((TreeRank (exp_list->BTE_LIST.Elem) > 0))) goto yyL4;
  }
   return true;
yyL4:;

  }
  return false;
}

void BeginSemPreds ()
{
}

void CloseSemPreds ()
{
}
