# include "SemParallel.h"
# include "yySemParallel.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 22 "SemParallel.puma"


# include "Idents.h"
# include "StringMem.h"
# include "Types.h"
# include "protocol.h"
 
# include "Transform.h"    /* CombineACF */
 
# include "Rank.h"
# include "Objects.h"
# include "TreeOps.h"
# include "Nesting.h"      /* Inc/DecNesting       */
 
# include "Loops.h"        /* ForallVarCheck, HasOuterParallelLoop */
# include "Expressions.h"  /* MinusExpression */
 
# include "SemExp.h"       /* SemVariable, SemIndexList */

# define MODULE "SemParallel"

static tTree red_fn = NoTree;  /* used to check that not two different
                                  kinds of reductions are applied      */



static void yyExit () { Exit (1); }

void (* SemParallel_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemParallel, routine %s failed\n", yyFunction);
 SemParallel_Exit ();
}

void SemParallel ARGS((tTree par_construct));
static tTree RemoveDoLabel ARGS((tTree body));
static void SemanticOnClause ARGS((tTree on_clause));
static void SemanticResident ARGS((tTree resident_vars));
static void SemanticNewVars ARGS((tTree v));
static void CheckNewVarObject ARGS((tDefinitions obj));
static void SemanticRedVars ARGS((tTree v));
static void CheckRedVarObject ARGS((tDefinitions obj));
static void SemanticForallLoop ARGS((tTree t, tTree loop));
static void SemanticParConstruct ARGS((tTree t, tTree par_constrcut));
static void MakeParConstructSerial ARGS((tTree loop, tTree stmt));
static void IdentifyReduction ARGS((tTree stmts, tTree red_var, bool allowed));
static void SetReductionFunction ARGS((tTree fn));
static bool EqualReduction ARGS((tTree red1, tTree red2));
void CheckReduction ARGS((tTree var, tTree exp, tTree red_var, tTree * yyP2, tTree * yyP1));
static tTree MakeRedFn ARGS((tTree op));
static bool RedVarUse ARGS((tTree exp, tTree red_var));
static bool IsReductionVariable ARGS((tTree var, tTree red_var));
static bool EqualVariable ARGS((tTree var1, tTree var2));
static void CheckTaskBody ARGS((tTree body, int indep_flag));
static bool IsResident ARGS((tTree body));

void SemParallel
# if defined __STDC__ | defined __cplusplus
(register tTree par_construct)
# else
(par_construct)
 register tTree par_construct;
# endif
{
# line 59 "SemParallel.puma"
  {
# line 61 "SemParallel.puma"
   set_protocol_stmt (par_construct);
# line 62 "SemParallel.puma"
   goto yyL1;
  }
yyL1:;


  switch (par_construct->Kind) {
  case kACF_FORALL:
# line 65 "SemParallel.puma"
  {
# line 69 "SemParallel.puma"
   SemanticForallLoop (par_construct->ACF_FORALL.FORALL_BODY, par_construct);
  }
   return;

  case kACF_DO:
  if (par_construct->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 72 "SemParallel.puma"
  {
# line 74 "SemParallel.puma"
 par_construct->ACF_DO.DO_BODY = RemoveDoLabel (par_construct->ACF_DO.DO_BODY); 
# line 76 "SemParallel.puma"
   SemanticParConstruct (par_construct->ACF_DO.DO_BODY, par_construct);
  }
   return;

  }
  if (par_construct->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
# line 79 "SemParallel.puma"
   return;

  }
  break;
  case kACF_HOME:
# line 84 "SemParallel.puma"
  {
# line 86 "SemParallel.puma"
   SemanticOnClause (par_construct->ACF_HOME.HOME_VAR);
# line 87 "SemParallel.puma"
   SemanticParConstruct (par_construct->ACF_HOME.HOME_BODY, par_construct);
  }
   return;

  case kACF_RESIDENT:
# line 90 "SemParallel.puma"
  {
# line 92 "SemParallel.puma"
   SemanticResident (par_construct->ACF_RESIDENT.RESIDENT_VAR);
  }
   return;

  case kACF_NEW:
# line 95 "SemParallel.puma"
  {
# line 97 "SemParallel.puma"
   SemanticNewVars (par_construct->ACF_NEW.NEW_VAR);
  }
   return;

  case kACF_REDUCTION:
  if (par_construct->ACF_REDUCTION.REDUCTION_VAR->Kind == kBTV_LIST) {
  if (par_construct->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next->Kind == kBTV_EMPTY) {
# line 100 "SemParallel.puma"
  {
# line 104 "SemParallel.puma"
   SemanticRedVars (par_construct->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem);
# line 106 "SemParallel.puma"
   red_fn = NoTree;
# line 108 "SemParallel.puma"
   IdentifyReduction (par_construct->ACF_REDUCTION.REDUCTION_BODY, par_construct->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem, true);
# line 110 "SemParallel.puma"
 if (red_fn == NoTree)

       { set_protocol_stmt (par_construct);
         warning_protocol ("reduction variable not used in any reduction");
         tree_protocol ("reduction variable : ", par_construct->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem);
       }

     else

       par_construct->ACF_REDUCTION.REDUCTION_FUNC = red_fn;

   
  }
   return;

  }
  }
  break;
  case kACF_TASK_REGION:
# line 124 "SemParallel.puma"
  {
# line 126 "SemParallel.puma"
   CheckTaskBody (par_construct->ACF_TASK_REGION.TASK_BODY, par_construct->ACF_TASK_REGION.task_flag);
  }
   return;

  }

# line 129 "SemParallel.puma"
  {
# line 131 "SemParallel.puma"
   failure_protocol (MODULE, "SemParallel", par_construct);
  }
   return;

;
}

static tTree RemoveDoLabel
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Elem->Kind == kACF_DUMMY) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 142 "SemParallel.puma"
   return body->ACF_LIST.Next;

  }
  }
# line 146 "SemParallel.puma"
  {
# line 147 "SemParallel.puma"
 body->ACF_LIST.Next = RemoveDoLabel (body->ACF_LIST.Next); 
  }
   return body;

  }
  if (body->Kind == kACF_EMPTY) {
# line 151 "SemParallel.puma"
   return body;

  }
# line 155 "SemParallel.puma"
  {
# line 156 "SemParallel.puma"
   failure_protocol (MODULE, "RemoveDoLabel", body);
  }
   return body;

}

static void SemanticOnClause
# if defined __STDC__ | defined __cplusplus
(register tTree on_clause)
# else
(on_clause)
 register tTree on_clause;
# endif
{
  if (on_clause->Kind == kON_PROC_CLAUSE) {
  if (on_clause->ON_PROC_CLAUSE.ON_PROC->Kind == kPROCESSOR_ARRAY) {
# line 168 "SemParallel.puma"
   return;

  }
  if (on_clause->ON_PROC_CLAUSE.ON_PROC->Kind == kPROCESSOR_SUBSET) {
# line 171 "SemParallel.puma"
  {
# line 173 "SemParallel.puma"
   SemIndexList (on_clause->ON_PROC_CLAUSE.ON_PROC->PROCESSOR_SUBSET.SUBSCRIPTS);
  }
   return;

  }
  }
  if (on_clause->Kind == kON_VAR_CLAUSE) {
# line 176 "SemParallel.puma"
  {
# line 178 "SemParallel.puma"
   SemVariable (on_clause->ON_VAR_CLAUSE.ON_VAR);
  }
   return;

  }
# line 181 "SemParallel.puma"
  {
# line 182 "SemParallel.puma"
   failure_protocol (MODULE, "SemanticOnClause", on_clause);
  }
   return;

;
}

static void SemanticResident
# if defined __STDC__ | defined __cplusplus
(register tTree resident_vars)
# else
(resident_vars)
 register tTree resident_vars;
# endif
{
  if (resident_vars->Kind == kBTV_EMPTY) {
# line 193 "SemParallel.puma"
   return;

  }
  if (resident_vars->Kind == kBTV_LIST) {
  if (resident_vars->BTV_LIST.Elem->Kind == kDUMMY_VAR) {
  if (resident_vars->BTV_LIST.Next->Kind == kBTV_EMPTY) {
# line 196 "SemParallel.puma"
   return;

  }
  }
# line 199 "SemParallel.puma"
  {
# line 201 "SemParallel.puma"
   SemVariable (resident_vars->BTV_LIST.Elem);
# line 202 "SemParallel.puma"
   SemanticResident (resident_vars->BTV_LIST.Next);
  }
   return;

  }
# line 205 "SemParallel.puma"
  {
# line 206 "SemParallel.puma"
   failure_protocol (MODULE, "SemanticResident", resident_vars);
  }
   return;

;
}

static void SemanticNewVars
# if defined __STDC__ | defined __cplusplus
(register tTree v)
# else
(v)
 register tTree v;
# endif
{
# line 217 "SemParallel.puma"
  {
# line 218 "SemParallel.puma"
   if (! ((v == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (v->Kind == kBTV_LIST) {
# line 221 "SemParallel.puma"
  {
# line 222 "SemParallel.puma"
   SemanticNewVars (v->BTV_LIST.Elem);
# line 223 "SemParallel.puma"
   SemanticNewVars (v->BTV_LIST.Next);
  }
   return;

  }
  if (v->Kind == kBTV_EMPTY) {
# line 226 "SemParallel.puma"
   return;

  }
  if (v->Kind == kUSED_VAR) {
# line 229 "SemParallel.puma"
  {
# line 231 "SemParallel.puma"
   CheckNewVarObject (v->USED_VAR.VARNAME->VAR_OBJ.Object);
  }
   return;

  }
# line 237 "SemParallel.puma"
  {
# line 238 "SemParallel.puma"
   error_protocol ("illegal variable in NEW directive");
# line 239 "SemParallel.puma"
   tree_protocol ("illegal var : ", v);
  }
   return;

;
}

static void CheckNewVarObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 244 "SemParallel.puma"
  {
# line 245 "SemParallel.puma"
   if (! ((IsPointerType (GetObjectType (obj))))) goto yyL1;
  {
# line 246 "SemParallel.puma"
   error_protocol ("variable in NEW must not be a POINTER");
  }
  }
   return;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
# line 249 "SemParallel.puma"
  {
# line 251 "SemParallel.puma"
 if (obj->VarObject.Kind->VarLocal.save)
       error_protocol ("variable in NEW must not have the SAVE attribute");
     if (obj->VarObject.Kind->VarLocal.target)
       error_protocol ("variable in NEW must not have the TARGET attribute");
   
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 258 "SemParallel.puma"
  {
# line 260 "SemParallel.puma"
   error_protocol ("variable in NEW must not be a dummy argument");
# line 261 "SemParallel.puma"
   obj_protocol ("object is : ", obj);
  }
   return;

  }
  }
# line 264 "SemParallel.puma"
  {
# line 266 "SemParallel.puma"
   error_protocol ("illegal variable in NEW option");
# line 267 "SemParallel.puma"
   obj_protocol ("object is : ", obj);
  }
   return;

;
}

static void SemanticRedVars
# if defined __STDC__ | defined __cplusplus
(register tTree v)
# else
(v)
 register tTree v;
# endif
{
# line 278 "SemParallel.puma"
  {
# line 279 "SemParallel.puma"
   if (! ((v == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (v->Kind == kBTV_LIST) {
# line 282 "SemParallel.puma"
  {
# line 283 "SemParallel.puma"
   SemanticRedVars (v->BTV_LIST.Elem);
# line 284 "SemParallel.puma"
   SemanticRedVars (v->BTV_LIST.Next);
  }
   return;

  }
  if (v->Kind == kBTV_EMPTY) {
# line 287 "SemParallel.puma"
   return;

  }
  if (v->Kind == kUSED_VAR) {
# line 290 "SemParallel.puma"
  {
# line 292 "SemParallel.puma"
   CheckRedVarObject (v->USED_VAR.VARNAME->VAR_OBJ.Object);
  }
   return;

  }
# line 298 "SemParallel.puma"
  {
# line 299 "SemParallel.puma"
   error_protocol ("illegal variable in NEW directive");
# line 300 "SemParallel.puma"
   tree_protocol ("illegal var : ", v);
  }
   return;

;
}

static void CheckRedVarObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 305 "SemParallel.puma"
  {
# line 306 "SemParallel.puma"
   if (! ((IsPointerType (GetObjectType (obj))))) goto yyL1;
  {
# line 307 "SemParallel.puma"
   error_protocol ("variable in REDUCTION must not be a POINTER");
  }
  }
   return;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
# line 310 "SemParallel.puma"
  {
# line 312 "SemParallel.puma"
 if (obj->VarObject.Kind->VarLocal.save)
       error_protocol ("var in REDUCTION must not have the SAVE attribute");
     if (obj->VarObject.Kind->VarLocal.target)
       error_protocol ("var in REDUCTION must not have the TARGET attribute");
   
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 319 "SemParallel.puma"
  {
# line 321 "SemParallel.puma"
   warning_protocol ("variable in REDUCTION must not be a dummy argument");
# line 322 "SemParallel.puma"
   obj_protocol ("object is : ", obj);
  }
   return;

  }
  }
# line 325 "SemParallel.puma"
  {
# line 327 "SemParallel.puma"
   error_protocol ("illegal variable in NEW option");
# line 328 "SemParallel.puma"
   obj_protocol ("object is : ", obj);
  }
   return;

;
}

static void SemanticForallLoop
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree loop)
# else
(t, loop)
 register tTree t;
 register tTree loop;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 342 "SemParallel.puma"
  {
# line 344 "SemParallel.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 345 "SemParallel.puma"
   SemanticForallLoop (t->ACF_LIST.Elem, loop);
# line 346 "SemParallel.puma"
   SemanticForallLoop (t->ACF_LIST.Next, loop);
  }
   return;

  case kACF_EMPTY:
# line 349 "SemParallel.puma"
   return;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 352 "SemParallel.puma"
  {
# line 356 "SemParallel.puma"
   ForallVarCheck (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
  }
   return;

  }
  break;
  case kACF_WHERE:
# line 359 "SemParallel.puma"
  {
# line 363 "SemParallel.puma"
   SemanticForallLoop (t->ACF_WHERE.TRUE_PART, loop);
# line 364 "SemParallel.puma"
   SemanticForallLoop (t->ACF_WHERE.FALSE_PART, loop);
  }
   return;

  case kACF_FORALL:
# line 367 "SemParallel.puma"
   return;

  case kACF_HOME:
# line 372 "SemParallel.puma"
  {
# line 374 "SemParallel.puma"
   SemanticForallLoop (t->ACF_HOME.HOME_BODY, loop);
  }
   return;

  case kACF_IF:
# line 379 "SemParallel.puma"
  {
# line 381 "SemParallel.puma"
   SemanticForallLoop (t->ACF_IF.THEN_PART, loop);
# line 382 "SemParallel.puma"
   SemanticForallLoop (t->ACF_IF.ELSE_PART, loop);
  }
   return;

  }

# line 385 "SemParallel.puma"
  {
# line 387 "SemParallel.puma"
   error_protocol ("this statement is not allowed in FORALL");
  }
   return;

;
}

static void SemanticParConstruct
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree par_constrcut)
# else
(t, par_constrcut)
 register tTree t;
 register tTree par_constrcut;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 400 "SemParallel.puma"
  {
# line 402 "SemParallel.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 403 "SemParallel.puma"
   SemanticParConstruct (t->ACF_LIST.Elem, par_constrcut);
# line 404 "SemParallel.puma"
   SemanticParConstruct (t->ACF_LIST.Next, par_constrcut);
  }
   return;

  case kACF_EMPTY:
# line 407 "SemParallel.puma"
   return;

  case kACF_BASIC:

  switch (t->ACF_BASIC.BASIC_STMT->Kind) {
  case kASSIGN_STMT:
# line 410 "SemParallel.puma"
   return;

  case kCALL_STMT:
# line 415 "SemParallel.puma"
   return;

  case kREDUCE_STMT:
# line 420 "SemParallel.puma"
   return;

  case kALLOCATE_STMT:
# line 425 "SemParallel.puma"
   return;

  case kDEALLOCATE_STMT:
# line 426 "SemParallel.puma"
   return;

  case kCREATE_DSP_STMT:
# line 427 "SemParallel.puma"
   return;

  case kFREE_DSP_STMT:
# line 428 "SemParallel.puma"
   return;

  }

  break;
  case kACF_HOME:
# line 430 "SemParallel.puma"
  {
# line 432 "SemParallel.puma"
   SemanticParConstruct (t->ACF_HOME.HOME_BODY, par_constrcut);
  }
   return;

  case kACF_TASK_REGION:
# line 435 "SemParallel.puma"
  {
# line 437 "SemParallel.puma"
   SemanticParConstruct (t->ACF_TASK_REGION.TASK_BODY, par_constrcut);
  }
   return;

  case kACF_FORALL:
# line 440 "SemParallel.puma"
   return;

  case kACF_DO:
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 445 "SemParallel.puma"
   return;

  }
# line 450 "SemParallel.puma"
  {
# line 454 "SemParallel.puma"
   SemanticParConstruct (t->ACF_DO.DO_BODY, par_constrcut);
  }
   return;

  case kACF_WHILE:
# line 457 "SemParallel.puma"
  {
# line 461 "SemParallel.puma"
   SemanticParConstruct (t->ACF_WHILE.WHILE_BODY, par_constrcut);
  }
   return;

  case kACF_IF:
# line 464 "SemParallel.puma"
  {
# line 466 "SemParallel.puma"
   SemanticParConstruct (t->ACF_IF.THEN_PART, par_constrcut);
# line 467 "SemParallel.puma"
   SemanticParConstruct (t->ACF_IF.ELSE_PART, par_constrcut);
  }
   return;

  case kACF_NEW:
# line 470 "SemParallel.puma"
  {
# line 472 "SemParallel.puma"
   SemanticParConstruct (t->ACF_NEW.NEW_BODY, par_constrcut);
  }
   return;

  case kACF_RESIDENT:
# line 475 "SemParallel.puma"
  {
# line 477 "SemParallel.puma"
   SemanticParConstruct (t->ACF_RESIDENT.RESIDENT_BODY, par_constrcut);
  }
   return;

  case kACF_REDUCTION:
# line 480 "SemParallel.puma"
  {
# line 482 "SemParallel.puma"
   SemanticParConstruct (t->ACF_REDUCTION.REDUCTION_BODY, par_constrcut);
  }
   return;

  }

# line 485 "SemParallel.puma"
  {
# line 487 "SemParallel.puma"
   MakeParConstructSerial (par_constrcut, t);
  }
   return;

;
}

static void MakeParConstructSerial
# if defined __STDC__ | defined __cplusplus
(register tTree loop, register tTree stmt)
# else
(loop, stmt)
 register tTree loop;
 register tTree stmt;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 498 "SemParallel.puma"
  {
# line 500 "SemParallel.puma"
   set_protocol_stmt (stmt);
# line 502 "SemParallel.puma"
   serious_warning_protocol ("not handled in INDEPENDENT loop");
  }
   return;

  }
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
# line 516 "SemParallel.puma"
   return;

  }
  }
  if (loop->Kind == kACF_HOME) {
  if (loop->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
# line 507 "SemParallel.puma"
  {
# line 509 "SemParallel.puma"
   set_protocol_stmt (stmt);
# line 511 "SemParallel.puma"
   serious_warning_protocol ("not handled in ON HOME directive");
  }
   return;

  }
  if (loop->ACF_HOME.HOME_VAR->Kind == kON_ALL_CLAUSE) {
# line 519 "SemParallel.puma"
   return;

  }
  }
# line 522 "SemParallel.puma"
  {
# line 524 "SemParallel.puma"
   failure_protocol (MODULE, "MakeParConstructSerial", loop);
  }
   return;

;
}

static void IdentifyReduction
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, register tTree red_var, register bool allowed)
# else
(stmts, red_var, allowed)
 register tTree stmts;
 register tTree red_var;
 register bool allowed;
# endif
{

  switch (stmts->Kind) {
  case kACF_LIST:
# line 544 "SemParallel.puma"
  {
# line 546 "SemParallel.puma"
   set_protocol_stmt (stmts->ACF_LIST.Elem);
# line 548 "SemParallel.puma"
   IdentifyReduction (stmts->ACF_LIST.Elem, red_var, allowed);
# line 549 "SemParallel.puma"
   IdentifyReduction (stmts->ACF_LIST.Next, red_var, allowed);
  }
   return;

  case kACF_EMPTY:
# line 552 "SemParallel.puma"
   return;

  case kACF_BASIC:
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 555 "SemParallel.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree param1;
  tTree param2;
  {
# line 557 "SemParallel.puma"
   CheckReduction (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, red_var, & yyV1, & yyV2);
# line 559 "SemParallel.puma"
   if (! ((yyV1 != NoTree))) goto yyL3;
  {
# line 561 "SemParallel.puma"
 if (!allowed)
        error_protocol ("reductions within FORALL not allowed");
     if (TreeRank (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR) > 0)
        error_protocol ("reductions on array variables not allowed");
   
# line 567 "SemParallel.puma"
   SetReductionFunction (yyV1);
# line 569 "SemParallel.puma"

# line 570 "SemParallel.puma"

# line 572 "SemParallel.puma"
 param1 = mVAR_PARAM (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
     SetVarParamAttributes (param1, IntentInOut);
     param2 = ExpToVarParam (yyV2);
     SetVarParamAttributes (param2, IntentIn);
     stmts->ACF_BASIC.BASIC_STMT = mREDUCE_STMT (yyV1, mBTP_LIST (param1, mBTP_LIST (param2, mBTP_EMPTY())));
   
  }
  }
   return;
 }
yyL3:;

# line 580 "SemParallel.puma"
  {
# line 582 "SemParallel.puma"
 if (RedVarUse (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, red_var) || RedVarUse (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, red_var))
       { error_protocol ("illegal use of reduction variable");
         tree_protocol ("reduction variable: ", red_var);
       }
   
  }
   return;

  }
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 589 "SemParallel.puma"
   return;

  }
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 594 "SemParallel.puma"
   return;

  }
# line 599 "SemParallel.puma"
   return;

  case kACF_IF:
# line 602 "SemParallel.puma"
  {
# line 604 "SemParallel.puma"
 if (RedVarUse (stmts->ACF_IF.IF_EXP, red_var))
       { error_protocol ("illegal use of reduction variable in IF");
         tree_protocol ("if expression", stmts->ACF_IF.IF_EXP);
         tree_protocol ("reduction variable: ", red_var);
       }
   
# line 611 "SemParallel.puma"
   IdentifyReduction (stmts->ACF_IF.THEN_PART, red_var, allowed);
# line 612 "SemParallel.puma"
   IdentifyReduction (stmts->ACF_IF.ELSE_PART, red_var, allowed);
  }
   return;

  case kACF_FORALL:
# line 615 "SemParallel.puma"
  {
# line 617 "SemParallel.puma"
   IdentifyReduction (stmts->ACF_FORALL.FORALL_BODY, red_var, false);
  }
   return;

  case kACF_DO:
# line 620 "SemParallel.puma"
  {
# line 622 "SemParallel.puma"
   IdentifyReduction (stmts->ACF_DO.DO_BODY, red_var, allowed);
  }
   return;

  case kACF_WHILE:
# line 625 "SemParallel.puma"
  {
# line 627 "SemParallel.puma"
   IdentifyReduction (stmts->ACF_WHILE.WHILE_BODY, red_var, allowed);
  }
   return;

  case kACF_HOME:
# line 630 "SemParallel.puma"
  {
# line 632 "SemParallel.puma"
   IdentifyReduction (stmts->ACF_HOME.HOME_BODY, red_var, allowed);
  }
   return;

  case kACF_RESIDENT:
# line 635 "SemParallel.puma"
  {
# line 637 "SemParallel.puma"
   IdentifyReduction (stmts->ACF_RESIDENT.RESIDENT_BODY, red_var, allowed);
  }
   return;

  case kACF_NEW:
# line 640 "SemParallel.puma"
  {
# line 642 "SemParallel.puma"
   IdentifyReduction (stmts->ACF_NEW.NEW_BODY, red_var, allowed);
  }
   return;

  case kACF_REDUCTION:
# line 645 "SemParallel.puma"
  {
# line 647 "SemParallel.puma"
   IdentifyReduction (stmts->ACF_REDUCTION.REDUCTION_BODY, red_var, allowed);
  }
   return;

  }

# line 650 "SemParallel.puma"
  {
# line 652 "SemParallel.puma"
   failure_protocol (MODULE, "IdentifyReduction", stmts);
  }
   return;

;
}

static void SetReductionFunction
# if defined __STDC__ | defined __cplusplus
(register tTree fn)
# else
(fn)
 register tTree fn;
# endif
{
# line 665 "SemParallel.puma"
  {
# line 667 "SemParallel.puma"
   if (! ((red_fn == NoTree))) goto yyL1;
  {
# line 668 "SemParallel.puma"
   red_fn = fn;
  }
  }
   return;
yyL1:;

# line 671 "SemParallel.puma"
  {
# line 673 "SemParallel.puma"
   if (! ((EqualReduction (fn, red_fn)))) goto yyL2;
  }
   return;
yyL2:;

# line 676 "SemParallel.puma"
  {
# line 678 "SemParallel.puma"
   error_protocol ("different use of reduction");
# line 679 "SemParallel.puma"
   tree_protocol ("reduction here   : ", fn);
# line 680 "SemParallel.puma"
   tree_protocol ("reduction before : ", red_fn);
  }
   return;

;
}

static bool EqualReduction
# if defined __STDC__ | defined __cplusplus
(register tTree red1, register tTree red2)
# else
(red1, red2)
 register tTree red1;
 register tTree red2;
# endif
{
  if (red1->Kind == kPROC_OBJ) {
  if (red2->Kind == kPROC_OBJ) {
# line 685 "SemParallel.puma"
  {
# line 687 "SemParallel.puma"
   if (! ((red1->PROC_OBJ.Ident == red2->PROC_OBJ.Ident))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  return false;
}

void CheckReduction
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp, register tTree red_var, register tTree * yyP2, register tTree * yyP1)
# else
(var, exp, red_var, yyP2, yyP1)
 register tTree var;
 register tTree exp;
 register tTree red_var;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
# line 699 "SemParallel.puma"
  {
# line 701 "SemParallel.puma"
   if (! ((! IsReductionVariable (var, red_var)))) goto yyL1;
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;
yyL1:;

  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
  if (exp->OP_EXP.OPND1->Kind == kVAR_EXP) {
# line 706 "SemParallel.puma"
  {
# line 709 "SemParallel.puma"
   if (! ((IsReductionVariable (exp->OP_EXP.OPND1->VAR_EXP.V, red_var)))) goto yyL2;
  {
# line 710 "SemParallel.puma"
   if (! ((EqualVariable (var, exp->OP_EXP.OPND1->VAR_EXP.V)))) goto yyL2;
  {
# line 711 "SemParallel.puma"
   if (! ((! RedVarUse (exp->OP_EXP.OPND2, red_var)))) goto yyL2;
  }
  }
  }
   * yyP2 = mPROC_OBJ (IsIdent ("SUM"));
   * yyP1 = MinusExpression (exp->OP_EXP.OPND2);
   return;
yyL2:;

  }
  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_DIVIDE) {
  if (exp->OP_EXP.OPND1->Kind == kVAR_EXP) {
# line 716 "SemParallel.puma"
  {
# line 719 "SemParallel.puma"
   if (! ((IsReductionVariable (exp->OP_EXP.OPND1->VAR_EXP.V, red_var)))) goto yyL3;
  {
# line 720 "SemParallel.puma"
   if (! ((EqualVariable (var, exp->OP_EXP.OPND1->VAR_EXP.V)))) goto yyL3;
  {
# line 721 "SemParallel.puma"
   if (! ((! RedVarUse (exp->OP_EXP.OPND2, red_var)))) goto yyL3;
  }
  }
  }
   * yyP2 = mPROC_OBJ (IsIdent ("PRODUCT"));
   * yyP1 = InverseExpression (exp->OP_EXP.OPND2);
   return;
yyL3:;

  }
  }
  if (exp->OP_EXP.OPND1->Kind == kVAR_EXP) {
# line 724 "SemParallel.puma"
  {
# line 726 "SemParallel.puma"
   if (! ((IsReductionVariable (exp->OP_EXP.OPND1->VAR_EXP.V, red_var)))) goto yyL4;
  {
# line 727 "SemParallel.puma"
   if (! ((EqualVariable (var, exp->OP_EXP.OPND1->VAR_EXP.V)))) goto yyL4;
  {
# line 728 "SemParallel.puma"
   if (! ((! RedVarUse (exp->OP_EXP.OPND2, red_var)))) goto yyL4;
  }
  }
  }
   * yyP2 = MakeRedFn (exp->OP_EXP.EXP_OP);
   * yyP1 = exp->OP_EXP.OPND2;
   return;
yyL4:;

  }
  if (exp->OP_EXP.OPND2->Kind == kVAR_EXP) {
# line 731 "SemParallel.puma"
  {
# line 733 "SemParallel.puma"
   if (! ((IsReductionVariable (exp->OP_EXP.OPND2->VAR_EXP.V, red_var)))) goto yyL5;
  {
# line 734 "SemParallel.puma"
   if (! ((EqualVariable (var, exp->OP_EXP.OPND2->VAR_EXP.V)))) goto yyL5;
  {
# line 735 "SemParallel.puma"
   if (! ((! RedVarUse (exp->OP_EXP.OPND1, red_var)))) goto yyL5;
  }
  }
  }
   * yyP2 = MakeRedFn (exp->OP_EXP.EXP_OP);
   * yyP1 = exp->OP_EXP.OPND1;
   return;
yyL5:;

  }
  }
  if (exp->Kind == kFUNC_CALL_EXP) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 738 "SemParallel.puma"
  {
# line 743 "SemParallel.puma"
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL6;
  {
# line 744 "SemParallel.puma"
   if (! ((IsReductionVariable (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V, red_var)))) goto yyL6;
  {
# line 745 "SemParallel.puma"
   if (! ((EqualVariable (var, exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL6;
  {
# line 746 "SemParallel.puma"
   if (! ((! RedVarUse (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, red_var)))) goto yyL6;
  }
  }
  }
  }
   * yyP2 = MakeRedFn (exp->FUNC_CALL_EXP.FUNC_ID);
   * yyP1 = VarParamToExp (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem);
   return;
yyL6:;

  }
  }
  }
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 749 "SemParallel.puma"
  {
# line 754 "SemParallel.puma"
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL7;
  {
# line 755 "SemParallel.puma"
   if (! ((IsReductionVariable (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, red_var)))) goto yyL7;
  {
# line 756 "SemParallel.puma"
   if (! ((EqualVariable (var, exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL7;
  {
# line 757 "SemParallel.puma"
   if (! ((! RedVarUse (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, red_var)))) goto yyL7;
  }
  }
  }
  }
   * yyP2 = MakeRedFn (exp->FUNC_CALL_EXP.FUNC_ID);
   * yyP1 = VarParamToExp (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
   return;
yyL7:;

  }
  }
  }
  }
  }
# line 760 "SemParallel.puma"
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static tTree MakeRedFn
# if defined __STDC__ | defined __cplusplus
(register tTree op)
# else
(op)
 register tTree op;
# endif
{
  if (op->Kind == kOP_PLUS) {
# line 773 "SemParallel.puma"
   return mPROC_OBJ (MakeIdent ("SUM", 3));

  }
  if (op->Kind == kOP_TIMES) {
# line 778 "SemParallel.puma"
   return mPROC_OBJ (MakeIdent ("PRODUCT", 7));

  }
  if (op->Kind == kOP_OR) {
# line 783 "SemParallel.puma"
   return mPROC_OBJ (MakeIdent ("ANY", 3));

  }
  if (op->Kind == kOP_AND) {
# line 788 "SemParallel.puma"
   return mPROC_OBJ (MakeIdent ("ALL", 3));

  }
  if (op->Kind == kOP_NEQV) {
# line 793 "SemParallel.puma"
   return mPROC_OBJ (MakeIdent ("PARITY", 6));

  }
  if (op->Kind == kPROC_OBJ) {
# line 798 "SemParallel.puma"
  {
# line 800 "SemParallel.puma"
   if (! ((op->PROC_OBJ.Ident == MakeIdent ("MIN", 3)))) goto yyL6;
  }
   return mPROC_OBJ (MakeIdent ("MINVAL", 6));
yyL6:;

# line 804 "SemParallel.puma"
  {
# line 806 "SemParallel.puma"
   if (! ((op->PROC_OBJ.Ident == MakeIdent ("MAX", 3)))) goto yyL7;
  }
   return mPROC_OBJ (MakeIdent ("MAXVAL", 6));
yyL7:;

# line 810 "SemParallel.puma"
  {
# line 812 "SemParallel.puma"
   if (! ((op->PROC_OBJ.Ident == MakeIdent ("IAND", 4)))) goto yyL8;
  }
   return mPROC_OBJ (MakeIdent ("IALL", 4));
yyL8:;

# line 816 "SemParallel.puma"
  {
# line 818 "SemParallel.puma"
   if (! ((op->PROC_OBJ.Ident == MakeIdent ("IOR", 3)))) goto yyL9;
  }
   return mPROC_OBJ (MakeIdent ("IANY", 4));
yyL9:;

# line 822 "SemParallel.puma"
  {
# line 824 "SemParallel.puma"
   if (! ((op->PROC_OBJ.Ident == MakeIdent ("IEOR", 4)))) goto yyL10;
  }
   return mPROC_OBJ (MakeIdent ("IPARITY", 6));
yyL10:;

  }
# line 828 "SemParallel.puma"
   return NoTree;

}

static bool RedVarUse
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree red_var)
# else
(exp, red_var)
 register tTree exp;
 register tTree red_var;
# endif
{
# line 840 "SemParallel.puma"
  {
# line 842 "SemParallel.puma"
   if (! ((IsVarInExp (TreeVarName (red_var), exp)))) goto yyL1;
  }
   return true;
yyL1:;

  if (exp->Kind == kVAR_EXP) {
# line 845 "SemParallel.puma"
  {
# line 847 "SemParallel.puma"
   if (! ((IsReductionVariable (exp->VAR_EXP.V, red_var)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (exp->Kind == kOP_EXP) {
# line 850 "SemParallel.puma"
  {
# line 852 "SemParallel.puma"
   if (! ((RedVarUse (exp->OP_EXP.OPND1, red_var) || RedVarUse (exp->OP_EXP.OPND2, red_var)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  if (exp->Kind == kOP1_EXP) {
# line 855 "SemParallel.puma"
  {
# line 857 "SemParallel.puma"
   if (! ((RedVarUse (exp->OP1_EXP.OPND, red_var)))) goto yyL4;
  }
   return true;
yyL4:;

  }
  return false;
}

static bool IsReductionVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree red_var)
# else
(var, red_var)
 register tTree var;
 register tTree red_var;
# endif
{
  if (var->Kind == kUSED_VAR) {
  if (red_var->Kind == kUSED_VAR) {
# line 868 "SemParallel.puma"
  {
# line 870 "SemParallel.puma"
   if (! ((var->USED_VAR.VARNAME->VAR_OBJ.Object == red_var->USED_VAR.VARNAME->VAR_OBJ.Object))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  if (var->Kind == kINDEXED_VAR) {
  if (red_var->Kind == kUSED_VAR) {
# line 873 "SemParallel.puma"
  {
# line 875 "SemParallel.puma"
   if (! ((IsReductionVariable (var->INDEXED_VAR.IND_VAR, red_var)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  if (var->Kind == kREMOTE_VAR) {
  if (red_var->Kind == kUSED_VAR) {
# line 878 "SemParallel.puma"
  {
# line 880 "SemParallel.puma"
   if (! ((IsReductionVariable (var->REMOTE_VAR.VAR, red_var)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  }
  return false;
}

static bool EqualVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register tTree var2)
# else
(var1, var2)
 register tTree var1;
 register tTree var2;
# endif
{
  if (var1->Kind == kUSED_VAR) {
  if (var2->Kind == kUSED_VAR) {
# line 894 "SemParallel.puma"
  {
# line 896 "SemParallel.puma"
   if (! ((var1->USED_VAR.VARNAME->VAR_OBJ.Object == var2->USED_VAR.VARNAME->VAR_OBJ.Object))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  if (var1->Kind == kINDEXED_VAR) {
  if (var2->Kind == kINDEXED_VAR) {
# line 899 "SemParallel.puma"
  {
# line 901 "SemParallel.puma"
   if (! ((EqualVariable (var1->INDEXED_VAR.IND_VAR, var2->INDEXED_VAR.IND_VAR)))) goto yyL2;
  {
# line 902 "SemParallel.puma"
   if (! ((EqualIndexes (var1->INDEXED_VAR.IND_EXPS, var2->INDEXED_VAR.IND_EXPS)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  }
  if (var1->Kind == kREMOTE_VAR) {
# line 905 "SemParallel.puma"
  {
# line 907 "SemParallel.puma"
   if (! ((EqualVariable (var1->REMOTE_VAR.VAR, var2)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  if (var2->Kind == kREMOTE_VAR) {
# line 910 "SemParallel.puma"
  {
# line 912 "SemParallel.puma"
   if (! ((EqualVariable (var1, var2->REMOTE_VAR.VAR)))) goto yyL4;
  }
   return true;
yyL4:;

  }
  return false;
}

static void CheckTaskBody
# if defined __STDC__ | defined __cplusplus
(register tTree body, register int indep_flag)
# else
(body, indep_flag)
 register tTree body;
 register int indep_flag;
# endif
{
  if (body->Kind == kACF_LIST) {
# line 923 "SemParallel.puma"
  {
# line 925 "SemParallel.puma"
   CheckTaskBody (body->ACF_LIST.Elem, indep_flag);
# line 926 "SemParallel.puma"
   CheckTaskBody (body->ACF_LIST.Next, indep_flag);
  }
   return;

  }
  if (body->Kind == kACF_EMPTY) {
# line 929 "SemParallel.puma"
   return;

  }
  if (body->Kind == kACF_HOME) {
# line 932 "SemParallel.puma"
  {
# line 934 "SemParallel.puma"
 if (!IsResident (body->ACF_HOME.HOME_BODY))
        serious_warning_protocol ("ON clause in TASK_REGION not resident");
   
  }
   return;

  }
  if (body->Kind == kACF_TASK_REGION) {
# line 939 "SemParallel.puma"
   return;

  }
# line 942 "SemParallel.puma"
  {
# line 944 "SemParallel.puma"
   if (! ((indep_flag))) goto yyL5;
  {
# line 946 "SemParallel.puma"
   error_protocol ("illegal stmt in INDEPENDENT task_region");
# line 947 "SemParallel.puma"
   tree_protocol ("this statement is not allowed :\n", body);
  }
  }
   return;
yyL5:;

;
}

static bool IsResident
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Elem->Kind == kACF_RESIDENT) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 952 "SemParallel.puma"
   return true;

  }
  }
  }
  return false;
}

void BeginSemParallel ()
{
}

void CloseSemParallel ()
{
}
