# include "SemMap.h"
# include "yySemMap.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 40 "SemMap.puma"


# include "Idents.h"
# include "StringMem.h"
# include "Types.h"

# include "DefTable.h"

# include "Expressions.h"    /* ResolveExpression   */
# include "Invariant.h"      /* IsVarInExp          */
# include "TreeOps.h"

# include "protocol.h"
# include "Rank.h"
# include "MapDefs.h"        /* AnalTargetSpec      */

# include "Mapping.h"        /* ReplaceDefaultDistributions */

# include "Distributions.h"  /* IsAlignedObj                */

# define MODULE "SemMap"



static void yyExit () { Exit (1); }

void (* SemMap_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemMap, routine %s failed\n", yyFunction);
 SemMap_Exit ();
}

void EvalObjDistribution ARGS((tDefinitions t));
static tDefinitions EvalDistribution ARGS((tDefinitions o, tDefinitions d));
static tDefinitions EvalDistributionDecl ARGS((tTree layout_decl));
tDefinitions EvalDistributionStmt ARGS((tTree layout_stmt));
static tDefinitions EvalRangeDecl ARGS((tTree layout_decl));
static void GetObjectInfo ARGS((tTree var, tIdent * yyP2, tDefinitions * yyP1));
static tDefinitions EvalDistributionSpec ARGS((tTree d_spec, tTree p_spec));
static tDefinitions EvalRangeSpec ARGS((tIdent tid, tTree d_spec));
static bool IsReplicatedDistribution ARGS((tTree t));
static tDefinitions ComputeNodeDistribution ARGS((tTree mapping, tDefinitions p_obj));
static tDefinitions ComputeRangeDistribution ARGS((tTree mapping));
static tDefinitions MakeDistributionList ARGS((tTree mapping, int top_dim, int temp_dim));
static void CodeDistribution ARGS((tTree distribution, int * yyP6, tTree * yyP5, tTree * yyP4, tTree * yyP3));
static bool IsLegalIntArray ARGS((tTree int_array));
static int NoDistributedDims ARGS((tDefinitions dlist));
static tDefinitions EvalAlignmentDecl ARGS((tTree align_decl));
tDefinitions EvalAlignmentStmt ARGS((tTree align_stmt));
static tDefinitions GetObjProcDistribution ARGS((tDefinitions obj));
static tDefinitions ComputeAlignDistribution ARGS((tTree source, tTree target, tDefinitions temp_obj));
static tDefinitions MakeAlignTargetDimList ARGS((int temp_dim, tTree source, tTree target));
static tDefinitions MakeAlignSourceDimList ARGS((int i, int n, tDefinitions target_list));
static void FindEntry ARGS((tDefinitions target_list, int index, tDefinitions * yyP7));
void MakeObjReplicated ARGS((tDefinitions t));
static tDefinitions MakeReplicatedDistribution ARGS((tDefinitions d));

void EvalObjDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kTemplateObject) {
# line 76 "SemMap.puma"
  {
# line 78 "SemMap.puma"
   t->TemplateObject.Dist = EvalDistribution (t, t->TemplateObject.Dist);
  }
   return;

  }
  if (t->Kind == kVarObject) {
# line 81 "SemMap.puma"
  {
# line 83 "SemMap.puma"
   t->VarObject.Dist = EvalDistribution (t, t->VarObject.Dist);
  }
   return;

  }
# line 86 "SemMap.puma"
  {
# line 87 "SemMap.puma"
   obj_error_protocol ("EvalObjDistribution illegal", t);
  }
   return;

;
}

static tDefinitions EvalDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions o, register tDefinitions d)
# else
(o, d)
 register tDefinitions o;
 register tDefinitions d;
# endif
{
  if (d->Kind == kDeclDistribution) {
  if (d->DeclDistribution.decl->Kind == kDISTRIBUTE_DECL) {
# line 100 "SemMap.puma"
 {
  tDefinitions d1;
  {
# line 102 "SemMap.puma"
   set_protocol_stmt (d->DeclDistribution.decl);
# line 104 "SemMap.puma"
   ReplaceDefaultDistributions (o, d->DeclDistribution.decl);
# line 105 "SemMap.puma"
   ControlDistributeDecl (o, d->DeclDistribution.decl);
# line 107 "SemMap.puma"

# line 109 "SemMap.puma"
   d1 = EvalDistributionDecl (d->DeclDistribution.decl);
# line 111 "SemMap.puma"
   d1->Distribution.shared = d->Distribution.shared;
# line 112 "SemMap.puma"
   d1->Distribution.dynamic = d->Distribution.dynamic;
# line 113 "SemMap.puma"
   d1->Distribution.inherited = d->Distribution.inherited;
  }
  {
   return d1;
  }
 }

  }
  if (d->DeclDistribution.decl->Kind == kRANGE_DECL) {
# line 118 "SemMap.puma"
 {
  tDefinitions d1;
  {
# line 120 "SemMap.puma"
   set_protocol_stmt (d->DeclDistribution.decl);
# line 122 "SemMap.puma"

# line 124 "SemMap.puma"
   d1 = EvalRangeDecl (d->DeclDistribution.decl);
# line 126 "SemMap.puma"
   d1->Distribution.shared = d->Distribution.shared;
# line 127 "SemMap.puma"
   d1->Distribution.dynamic = d->Distribution.dynamic;
# line 128 "SemMap.puma"
   d1->Distribution.inherited = d->Distribution.inherited;
  }
  {
   return d1;
  }
 }

  }
  if (d->DeclDistribution.decl->Kind == kALIGN_DECL) {
# line 133 "SemMap.puma"
 {
  tDefinitions d1;
  {
# line 135 "SemMap.puma"
   set_protocol_stmt (d->DeclDistribution.decl);
# line 137 "SemMap.puma"

# line 139 "SemMap.puma"
   d1 = EvalAlignmentDecl (d->DeclDistribution.decl);
# line 141 "SemMap.puma"
   d1->Distribution.shared = d->Distribution.shared;
# line 142 "SemMap.puma"
   d1->Distribution.dynamic = d->Distribution.dynamic;
# line 143 "SemMap.puma"
   d1->Distribution.inherited = d->Distribution.inherited;
  }
  {
   return d1;
  }
 }

  }
# line 148 "SemMap.puma"
  {
# line 150 "SemMap.puma"
   set_protocol_stmt (d->DeclDistribution.decl);
# line 152 "SemMap.puma"
   failure_protocol (MODULE, "EvalDistribution", d->DeclDistribution.decl);
  }
   return d;

  }
# line 157 "SemMap.puma"
   return d;

}

static tDefinitions EvalDistributionDecl
# if defined __STDC__ | defined __cplusplus
(register tTree layout_decl)
# else
(layout_decl)
 register tTree layout_decl;
# endif
{
  if (layout_decl->Kind == kDISTRIBUTE_DECL) {
# line 173 "SemMap.puma"
   return EvalDistributionSpec (layout_decl->DISTRIBUTE_DECL.DISTRIBUTION, layout_decl->DISTRIBUTE_DECL.TARGET);

  }
# line 178 "SemMap.puma"
  {
# line 179 "SemMap.puma"
   failure_protocol (MODULE, "EvalDistributionDecl", layout_decl);
  }
   return mReplicatedDistribution (0, 0, 0);

}

tDefinitions EvalDistributionStmt
# if defined __STDC__ | defined __cplusplus
(register tTree layout_stmt)
# else
(layout_stmt)
 register tTree layout_stmt;
# endif
{
  if (layout_stmt->Kind == kREDISTRIBUTE_STMT) {
  if (layout_stmt->REDISTRIBUTE_STMT.DISTRIBUTEE->Kind == kBTV_LIST) {
# line 188 "SemMap.puma"
 {
  tIdent yyV1;
  tDefinitions yyV2;
  {
# line 191 "SemMap.puma"
   GetObjectInfo (layout_stmt->REDISTRIBUTE_STMT.DISTRIBUTEE->BTV_LIST.Elem, & yyV1, & yyV2);
# line 193 "SemMap.puma"
   ReplaceDefaultDistributions (yyV2, layout_stmt);
# line 195 "SemMap.puma"
   ControlRedistributeStmt (layout_stmt);
  }
  {
   return EvalDistributionSpec (layout_stmt->REDISTRIBUTE_STMT.DISTRIBUTION, layout_stmt->REDISTRIBUTE_STMT.TARGET);
  }
 }

  }
  }
# line 200 "SemMap.puma"
  {
# line 201 "SemMap.puma"
   failure_protocol (MODULE, "EvalDistributionStmt", layout_stmt);
  }
   return mReplicatedDistribution (0, 0, 0);

}

static tDefinitions EvalRangeDecl
# if defined __STDC__ | defined __cplusplus
(register tTree layout_decl)
# else
(layout_decl)
 register tTree layout_decl;
# endif
{
  if (layout_decl->Kind == kRANGE_DECL) {
  if (layout_decl->RANGE_DECL.RANGES->Kind == kRANGE_LIST) {
  if (layout_decl->RANGE_DECL.RANGES->RANGE_LIST.Next->Kind == kRANGE_EMPTY) {
# line 217 "SemMap.puma"
   return EvalRangeSpec (layout_decl->RANGE_DECL.Ident, layout_decl->RANGE_DECL.RANGES->RANGE_LIST.Elem);

  }
  }
  }
# line 222 "SemMap.puma"
  {
# line 223 "SemMap.puma"
   failure_protocol (MODULE, "EvalRangeDecl", layout_decl);
  }
   return mReplicatedDistribution (0, 0, 0);

}

static void GetObjectInfo
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent * yyP2, register tDefinitions * yyP1)
# else
(var, yyP2, yyP1)
 register tTree var;
 register tIdent * yyP2;
 register tDefinitions * yyP1;
# endif
{
  if (var->Kind == kVAR_OBJ) {
# line 236 "SemMap.puma"
   * yyP2 = var->VAR_OBJ.Ident;
   * yyP1 = var->VAR_OBJ.Object;
   return;

  }
  if (var->Kind == kUSED_VAR) {
# line 239 "SemMap.puma"
 {
  tIdent yyV1;
  tDefinitions yyV2;
  {
# line 241 "SemMap.puma"
   GetObjectInfo (var->USED_VAR.VARNAME, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (var->Kind == kSELECTED_VAR) {
# line 244 "SemMap.puma"
   * yyP2 = var->SELECTED_VAR.SELECTOR->REC_COMP.Ident;
   * yyP1 = var->SELECTED_VAR.SELECTOR->REC_COMP.Object;
   return;

  }
# line 247 "SemMap.puma"
  {
# line 249 "SemMap.puma"
   failure_protocol (MODULE, "GetObjectInfo", var);
  }
   * yyP2 = DefaultId ();
   * yyP1 = NoObject;
   return;

;
}

static tDefinitions EvalDistributionSpec
# if defined __STDC__ | defined __cplusplus
(register tTree d_spec, register tTree p_spec)
# else
(d_spec, p_spec)
 register tTree d_spec;
 register tTree p_spec;
# endif
{
  if (d_spec->Kind == kANY_DISTRIBUTION) {
# line 260 "SemMap.puma"
   return mReplicatedDistribution (0, 0, 0);

  }
  if (d_spec->Kind == kREPL_DISTRIBUTION) {
# line 265 "SemMap.puma"
   return mReplicatedDistribution (0, 0, 0);

  }
  if (d_spec->Kind == kNODE_DISTRIBUTION) {
# line 270 "SemMap.puma"
  {
# line 272 "SemMap.puma"
   if (! ((IsReplicatedDistribution (d_spec->NODE_DISTRIBUTION.MAPPING)))) goto yyL3;
  }
   return mReplicatedDistribution (0, 0, 0);
yyL3:;

  if (p_spec->Kind == kPROCESSOR_ARRAY) {
# line 276 "SemMap.puma"
   return ComputeNodeDistribution (d_spec->NODE_DISTRIBUTION.MAPPING, p_spec->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object);

  }
  if (p_spec->Kind == kPROCESSOR_SUBSET) {
# line 281 "SemMap.puma"
   return ComputeNodeDistribution (d_spec->NODE_DISTRIBUTION.MAPPING, p_spec->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Object);

  }
  if (p_spec->Kind == kANY_PROCESSOR_ARRAY) {
# line 286 "SemMap.puma"
   return ComputeNodeDistribution (d_spec->NODE_DISTRIBUTION.MAPPING, NoObject);

  }
  }
# line 293 "SemMap.puma"
  {
# line 295 "SemMap.puma"
   failure_protocol (MODULE, "EvalDistributionSpec", d_spec);
  }
   return mReplicatedDistribution (0, 0, 0);

}

static tDefinitions EvalRangeSpec
# if defined __STDC__ | defined __cplusplus
(register tIdent tid, register tTree d_spec)
# else
(tid, d_spec)
 register tIdent tid;
 register tTree d_spec;
# endif
{
  if (d_spec->Kind == kNODE_DISTRIBUTION) {
# line 307 "SemMap.puma"
  {
# line 309 "SemMap.puma"
   if (! ((IsReplicatedDistribution (d_spec->NODE_DISTRIBUTION.MAPPING)))) goto yyL1;
  }
   return mReplicatedDistribution (0, 0, 0);
yyL1:;

# line 313 "SemMap.puma"
   return ComputeRangeDistribution (d_spec->NODE_DISTRIBUTION.MAPPING);

  }
# line 318 "SemMap.puma"
  {
# line 319 "SemMap.puma"
   failure_protocol (MODULE, "EvalRangeSpec", d_spec);
  }
   return mReplicatedDistribution (0, 0, 0);

}

static bool IsReplicatedDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDIST_EMPTY) {
# line 334 "SemMap.puma"
   return true;

  }
  if (t->Kind == kDIST_LIST) {
  if (t->DIST_LIST.Elem->Kind == kSERIAL_DISTRIBUTION) {
# line 337 "SemMap.puma"
  {
# line 338 "SemMap.puma"
   if (! (IsReplicatedDistribution (t->DIST_LIST.Next))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  return false;
}

static tDefinitions ComputeNodeDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree mapping, register tDefinitions p_obj)
# else
(mapping, p_obj)
 register tTree mapping;
 register tDefinitions p_obj;
# endif
{
# line 357 "SemMap.puma"
 {
  tDefinitions array_list;
  {
# line 359 "SemMap.puma"

# line 361 "SemMap.puma"
   array_list = MakeDistributionList (mapping, 1, 1);
  }
  {
   return mNodeDistribution (0, 0, 0, p_obj, array_list);
  }
 }

}

static tDefinitions ComputeRangeDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree mapping)
# else
(mapping)
 register tTree mapping;
# endif
{
# line 368 "SemMap.puma"
 {
  tDefinitions array_list;
  {
# line 370 "SemMap.puma"

# line 372 "SemMap.puma"
   array_list = MakeDistributionList (mapping, 1, 1);
  }
  {
   return mRangeDistribution (0, 0, 0, array_list);
  }
 }

}

static tDefinitions MakeDistributionList
# if defined __STDC__ | defined __cplusplus
(register tTree mapping, register int top_dim, register int temp_dim)
# else
(mapping, top_dim, temp_dim)
 register tTree mapping;
 register int top_dim;
 register int temp_dim;
# endif
{
  if (mapping->Kind == kDIST_EMPTY) {
# line 395 "SemMap.puma"
   return mDIM_EMPTY ();

  }
  if (mapping->Kind == kDIST_LIST) {
  if (mapping->DIST_LIST.Elem->Kind == kSERIAL_DISTRIBUTION) {
# line 400 "SemMap.puma"
   return mDIM_LIST (mSerialDimension (temp_dim), MakeDistributionList (mapping->DIST_LIST.Next, top_dim, temp_dim + 1));

  }
# line 408 "SemMap.puma"
 {
  int yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 412 "SemMap.puma"
   CodeDistribution (mapping->DIST_LIST.Elem, & yyV1, & yyV2, & yyV3, & yyV4);
  }
  {
   return mDIM_LIST (mDistributedDimension (temp_dim, top_dim, yyV1, yyV2, yyV3, yyV4), MakeDistributionList (mapping->DIST_LIST.Next, top_dim + 1, temp_dim + 1));
  }
 }

  }
# line 419 "SemMap.puma"
  {
# line 421 "SemMap.puma"
   failure_protocol (MODULE, "MakeDistributionList", mapping);
  }
   return mDIM_EMPTY ();

}

static void CodeDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree distribution, register int * yyP6, register tTree * yyP5, register tTree * yyP4, register tTree * yyP3)
# else
(distribution, yyP6, yyP5, yyP4, yyP3)
 register tTree distribution;
 register int * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{

  switch (distribution->Kind) {
  case kBLOCK_DISTRIBUTION:
  if (distribution->BLOCK_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
# line 435 "SemMap.puma"
   * yyP6 = kBLOCK_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  }
# line 438 "SemMap.puma"
  {
# line 440 "SemMap.puma"
 if (TreeRank (distribution->BLOCK_DISTRIBUTION.SIZE) != 0)
       { error_protocol ("size of BLOCK must be scalar");
         tree_protocol ("illegal size expression is : ", distribution->BLOCK_DISTRIBUTION.SIZE);
       }
   
  }
   * yyP6 = kBLOCK_DIM;
   * yyP5 = distribution->BLOCK_DISTRIBUTION.SIZE;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kCYCLIC_DISTRIBUTION:
  if (distribution->CYCLIC_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
# line 447 "SemMap.puma"
   * yyP6 = kCYCLIC_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  }
# line 450 "SemMap.puma"
  {
# line 452 "SemMap.puma"
 if (TreeRank (distribution->CYCLIC_DISTRIBUTION.SIZE) != 0)
       { error_protocol ("size of CYCLIC must be scalar");
         tree_protocol ("illegal size expression is : ", distribution->CYCLIC_DISTRIBUTION.SIZE);
       }
   
  }
   * yyP6 = kCYCLIC_DIM;
   * yyP5 = distribution->CYCLIC_DISTRIBUTION.SIZE;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kGEN_BLOCK_DISTRIBUTION:
# line 459 "SemMap.puma"
  {
# line 462 "SemMap.puma"
 if (!IsLegalIntArray (distribution->GEN_BLOCK_DISTRIBUTION.ARRAY))

       { error_protocol ("size array in GEN_BLOCK must have rank 1");
         tree_protocol ("illegal array is : ", distribution->GEN_BLOCK_DISTRIBUTION.ARRAY);
       }
   
  }
   * yyP6 = kGEN_BLOCK_DIM;
   * yyP5 = distribution->GEN_BLOCK_DISTRIBUTION.ARRAY;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kINDIRECT_DISTRIBUTION:
# line 470 "SemMap.puma"
  {
# line 473 "SemMap.puma"
 if (!IsLegalIntArray (distribution->INDIRECT_DISTRIBUTION.ARRAY))

       { error_protocol ("map array in INDIRECT must have rank 1");
         tree_protocol ("illegal array is : ", distribution->INDIRECT_DISTRIBUTION.ARRAY);
       }
   
  }
   * yyP6 = kINDIRECT_DIM;
   * yyP5 = distribution->INDIRECT_DISTRIBUTION.ARRAY;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kARBITRARY_DISTRIBUTION:
# line 481 "SemMap.puma"
  {
# line 484 "SemMap.puma"
 if (TreeRank (distribution->ARBITRARY_DISTRIBUTION.SIZE) != 0)
       { error_protocol ("size of ARBITRARY must be scalar");
         tree_protocol ("illegal size expression is : ", distribution->ARBITRARY_DISTRIBUTION.SIZE);
       }

     if (!IsLegalIntArray (distribution->ARBITRARY_DISTRIBUTION.LENGTH))

       { error_protocol ("length array in ARBITRARY must have rank 1");
         tree_protocol ("illegal array is : ", distribution->ARBITRARY_DISTRIBUTION.LENGTH);
       }

     if (!IsLegalIntArray (distribution->ARBITRARY_DISTRIBUTION.MAP))

       { error_protocol ("map array in ARBITRARY must have rank 1");
         tree_protocol ("illegal array is : ", distribution->ARBITRARY_DISTRIBUTION.LENGTH);
       }
   
  }
   * yyP6 = kARBITRARY_DIM;
   * yyP5 = distribution->ARBITRARY_DISTRIBUTION.SIZE;
   * yyP4 = distribution->ARBITRARY_DISTRIBUTION.LENGTH;
   * yyP3 = distribution->ARBITRARY_DISTRIBUTION.MAP;
   return;

  case kANY_BLOCK_DISTRIBUTION:
# line 503 "SemMap.puma"
   * yyP6 = kANY_BLOCK_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kANY_CYCLIC_DISTRIBUTION:
# line 506 "SemMap.puma"
   * yyP6 = kANY_CYCLIC_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kANY_GEN_BLOCK_DISTRIBUTION:
# line 509 "SemMap.puma"
   * yyP6 = kANY_GEN_BLOCK_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kANY_INDIRECT_DISTRIBUTION:
# line 512 "SemMap.puma"
   * yyP6 = kANY_INDIRECT_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kANY_ARBITRARY_DISTRIBUTION:
# line 515 "SemMap.puma"
   * yyP6 = kANY_ARBITRARY_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  case kANY_DIM_DISTRIBUTION:
# line 518 "SemMap.puma"
   * yyP6 = kANY_DISTRIBUTED_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  }

# line 521 "SemMap.puma"
  {
# line 523 "SemMap.puma"
   error_protocol ("illegal distribution format");
# line 524 "SemMap.puma"
   tree_protocol ("illegal distribution is ", distribution);
  }
   * yyP6 = kANY_DISTRIBUTED_DIM;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

;
}

static bool IsLegalIntArray
# if defined __STDC__ | defined __cplusplus
(register tTree int_array)
# else
(int_array)
 register tTree int_array;
# endif
{
  if (int_array->Kind == kUSED_VAR) {
# line 535 "SemMap.puma"
  {
# line 537 "SemMap.puma"
   if (! ((VarRank (int_array->USED_VAR.VARNAME->VAR_OBJ.Object) == 1))) goto yyL1;
  }
   return true;
yyL1:;

  }
  return false;
}

static int NoDistributedDims
# if defined __STDC__ | defined __cplusplus
(register tDefinitions dlist)
# else
(dlist)
 register tDefinitions dlist;
# endif
{
  if (dlist->Kind == kDIM_EMPTY) {
# line 548 "SemMap.puma"
   return 0;

  }
  if (dlist->Kind == kDIM_LIST) {
  if (dlist->DIM_LIST.Elem->Kind == kDistributedDimension) {
# line 553 "SemMap.puma"
   return NoDistributedDims (dlist->DIM_LIST.Next) + 1;

  }
# line 558 "SemMap.puma"
   return NoDistributedDims (dlist->DIM_LIST.Next);

  }
 yyAbort ("NoDistributedDims");
}

static tDefinitions EvalAlignmentDecl
# if defined __STDC__ | defined __cplusplus
(register tTree align_decl)
# else
(align_decl)
 register tTree align_decl;
# endif
{
  if (align_decl->Kind == kALIGN_DECL) {
# line 574 "SemMap.puma"
   return ComputeAlignDistribution (align_decl->ALIGN_DECL.ALIGN_SOURCE, align_decl->ALIGN_DECL.ALIGN_TARGET->ALIGN_SPEC.SUBSCRIPTS, align_decl->ALIGN_DECL.ALIGN_TARGET->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Object);

  }
# line 580 "SemMap.puma"
  {
# line 582 "SemMap.puma"
   failure_protocol ("Distributions", "EvalAlignmentDecl", align_decl);
  }
   return NoObject;

}

tDefinitions EvalAlignmentStmt
# if defined __STDC__ | defined __cplusplus
(register tTree align_stmt)
# else
(align_stmt)
 register tTree align_stmt;
# endif
{
  if (align_stmt->Kind == kREALIGN_STMT) {
# line 597 "SemMap.puma"
   return ComputeAlignDistribution (align_stmt->REALIGN_STMT.ALIGN_SOURCE, align_stmt->REALIGN_STMT.ALIGN_TARGET->ALIGN_SPEC.SUBSCRIPTS, align_stmt->REALIGN_STMT.ALIGN_TARGET->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Object);

  }
# line 603 "SemMap.puma"
  {
# line 605 "SemMap.puma"
   failure_protocol (MODULE, "EvalAlignmentStmt", align_stmt);
  }
   return NoObject;

}

static tDefinitions GetObjProcDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kTemplateObject) {
  if (obj->TemplateObject.Dist->Kind == kDeclDistribution) {
# line 617 "SemMap.puma"
  {
# line 619 "SemMap.puma"
   EvalObjDistribution (obj);
  }
   return obj->TemplateObject.Dist;

  }
# line 636 "SemMap.puma"
   return obj->TemplateObject.Dist;

  }
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Kind == kDeclDistribution) {
  if (obj->VarObject.Dist->DeclDistribution.decl->Kind == kALIGN_DECL) {
# line 623 "SemMap.puma"
  {
# line 625 "SemMap.puma"
   obj_error_protocol ("Alignment to aligned object not possible (indirect alignment)", obj);
  }
   return mReplicatedDistribution (0, 0, 0);

  }
# line 630 "SemMap.puma"
  {
# line 632 "SemMap.puma"
   EvalObjDistribution (obj);
  }
   return obj->VarObject.Dist;

  }
# line 640 "SemMap.puma"
   return obj->VarObject.Dist;

  }
# line 644 "SemMap.puma"
  {
# line 645 "SemMap.puma"
   obj_error_protocol ("GetObjProcDistribution illegal\n", obj);
# line 646 "SemMap.puma"
   kill_in_protocol ();
  }
   return NoObject;

}

static tDefinitions ComputeAlignDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree source, register tTree target, register tDefinitions temp_obj)
# else
(source, target, temp_obj)
 register tTree source;
 register tTree target;
 register tDefinitions temp_obj;
# endif
{
# line 673 "SemMap.puma"
 {
  tDefinitions target_list;
  tDefinitions source_list;
  tDefinitions newtop_list;
  {
# line 675 "SemMap.puma"

# line 676 "SemMap.puma"

# line 677 "SemMap.puma"

# line 681 "SemMap.puma"
 if (IsAlignedObj (temp_obj))
         error_protocol ("aligned target in ALIGN not allowed");
    
# line 685 "SemMap.puma"
   target_list = MakeAlignTargetDimList (1, source, target);
# line 690 "SemMap.puma"
   source_list = MakeAlignSourceDimList (1, TreeListLength (source), target_list);
  }
  {
   return mAlignDistribution (0, 0, 0, temp_obj, target_list, source_list);
  }
 }

}

static tDefinitions MakeAlignTargetDimList
# if defined __STDC__ | defined __cplusplus
(register int temp_dim, register tTree source, register tTree target)
# else
(temp_dim, source, target)
 register int temp_dim;
 register tTree source;
 register tTree target;
# endif
{
  if (target->Kind == kBTE_LIST) {
  if (target->BTE_LIST.Elem->Kind == kDUMMY_EXP) {
# line 723 "SemMap.puma"
   return mDIM_LIST (mReplicatedDimension (temp_dim), MakeAlignTargetDimList (temp_dim + 1, source, target->BTE_LIST.Next));

  }
# line 729 "SemMap.puma"
 {
  tDefinitions dim;
  int index_dim;
  tTree mult_tree;
  int mult_val;
  tTree add_tree;
  int add_val;
  bool done;
  {
# line 731 "SemMap.puma"

# line 733 "SemMap.puma"

# line 734 "SemMap.puma"

# line 735 "SemMap.puma"

# line 736 "SemMap.puma"

# line 737 "SemMap.puma"

# line 738 "SemMap.puma"

# line 740 "SemMap.puma"
   AnalTargetExp (target->BTE_LIST.Elem, source, & index_dim, & done, & mult_tree, & mult_val, & add_tree, & add_val);
# line 743 "SemMap.puma"
   if (! ((index_dim > 0))) goto yyL2;
  {
# line 751 "SemMap.puma"
 if (mult_tree == NoTree)
        mult_tree = MakeConstant (mult_val);
      else
        mult_tree = MultConstant (mult_tree, mult_val);
     if (add_tree == NoTree)
        add_tree = MakeConstant (add_val);
      else
        add_tree = MultConstant (add_tree, add_val);
   
  }
  }
  {
   return mDIM_LIST (mAlignedDimension (index_dim, temp_dim, mult_tree, add_tree), MakeAlignTargetDimList (temp_dim + 1, source, target->BTE_LIST.Next));
  }
 }
yyL2:;

# line 766 "SemMap.puma"
   return mDIM_LIST (mEmbeddedDimension (temp_dim, target->BTE_LIST.Elem), MakeAlignTargetDimList (temp_dim + 1, source, target->BTE_LIST.Next));

  }
  if (target->Kind == kBTE_EMPTY) {
# line 772 "SemMap.puma"
   return mDIM_EMPTY ();

  }
# line 777 "SemMap.puma"
  {
# line 779 "SemMap.puma"
   failure_protocol (MODULE, "MakeAlignTargetDimList", target);
  }
   return mDIM_EMPTY ();

}

static tDefinitions MakeAlignSourceDimList
# if defined __STDC__ | defined __cplusplus
(register int i, register int n, register tDefinitions target_list)
# else
(i, n, target_list)
 register int i;
 register int n;
 register tDefinitions target_list;
# endif
{
# line 803 "SemMap.puma"
  {
# line 805 "SemMap.puma"
   if (! ((i > n))) goto yyL1;
  }
   return mDIM_EMPTY ();
yyL1:;

# line 809 "SemMap.puma"
 {
  tDefinitions yyV1;
  {
# line 811 "SemMap.puma"
   FindEntry (target_list, i, & yyV1);
  }
  {
   return mDIM_LIST (yyV1, MakeAlignSourceDimList (i + 1, n, target_list));
  }
 }

}

static void FindEntry
# if defined __STDC__ | defined __cplusplus
(register tDefinitions target_list, register int index, register tDefinitions * yyP7)
# else
(target_list, index, yyP7)
 register tDefinitions target_list;
 register int index;
 register tDefinitions * yyP7;
# endif
{
  if (target_list->Kind == kDIM_EMPTY) {
# line 824 "SemMap.puma"
 {
  tDefinitions dim;
  {
# line 826 "SemMap.puma"

# line 828 "SemMap.puma"
   dim = mSerialDimension (index);
  }
   * yyP7 = dim;
   return;
 }

  }
  if (target_list->Kind == kDIM_LIST) {
  if (target_list->DIM_LIST.Elem->Kind == kAlignedDimension) {
# line 831 "SemMap.puma"
  {
# line 833 "SemMap.puma"
   if (! ((target_list->DIM_LIST.Elem->AlignedDimension.dimension == index))) goto yyL2;
  }
   * yyP7 = target_list->DIM_LIST.Elem;
   return;
yyL2:;

  }
# line 836 "SemMap.puma"
 {
  tDefinitions yyV1;
  {
# line 838 "SemMap.puma"
   FindEntry (target_list->DIM_LIST.Next, index, & yyV1);
  }
   * yyP7 = yyV1;
   return;
 }

  }
;
}

void MakeObjReplicated
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kVarObject) {
# line 851 "SemMap.puma"
  {
# line 853 "SemMap.puma"
 t->VarObject.Dist = MakeReplicatedDistribution (t->VarObject.Dist); 
  }
   return;

  }
  if (t->Kind == kTemplateObject) {
# line 856 "SemMap.puma"
  {
# line 858 "SemMap.puma"
 t->TemplateObject.Dist = MakeReplicatedDistribution (t->TemplateObject.Dist); 
  }
   return;

  }
# line 861 "SemMap.puma"
  {
# line 862 "SemMap.puma"
   failure_protocol (MODULE, "MakeObjReplicated", t->Object.decl);
  }
   return;

;
}

static tDefinitions MakeReplicatedDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d)
# else
(d)
 register tDefinitions d;
# endif
{
# line 873 "SemMap.puma"
   return mReplicatedDistribution (d->Distribution.dynamic, d->Distribution.shared, d->Distribution.inherited);

}

void BeginSemMap ()
{
}

void CloseSemMap ()
{
}
