# include "SemIntr.h"
# include "yySemIntr.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 29 "SemIntr.puma"


# define MODULE "SemIntr"

# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "DefTable.h"
# include "Transform.h"   /* ExpToVarParam */
# include "SemExp.h"      /* MergeRank, ScalarVariable, ... */
# include "SemPreds.h"    /* IntExpr, ...                   */
# include "Types.h"       /* GetTypeZero                    */
# include "Expressions.h" /* MakeConstant */
# include "Intrinsics.h"
# include "Rank.h"
# include "Objects.h"





static void yyExit () { Exit (1); }

void (* SemIntr_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemIntr, routine %s failed\n", yyFunction);
 SemIntr_Exit ();
}

void SemIntrinsicFunction ARGS((tTree exp, tIdent name, tTree params));
void SemIntrinsicSubroutine ARGS((tIdent name, tTree params));
static void NoScalarArgument ARGS((tIdent routine_id, tIdent arg, tTree arg_tree));
static void SameShape ARGS((tIdent routine_id, tIdent arg1, tTree arg_tree1, tIdent arg2, tTree arg_tree2));
static void Conformable ARGS((tIdent routine_id, tIdent arg1, tTree arg_tree1, tIdent arg2, tTree arg_tree2));
static void LegalDimArgument ARGS((tIdent routine_id, tIdent arg, tTree arg_tree, tTree dim_tree));
static tTree MakeOmittedDim ARGS((tTree dim));
static void CheckElementalIntrinsic ARGS((tTree exp, tIdent name, tTree params));
static void CheckMerge ARGS((tTree params));
static void CheckPack ARGS((tTree params));
static void CheckUnpack ARGS((tTree params));
static void CheckReshape ARGS((tTree params));
static void CheckCShift ARGS((tTree params));
static void CheckSpread ARGS((tTree params));
static void CheckEOShift ARGS((tTree params));
static void CheckSort ARGS((tIdent name, tTree params));
static void CheckMatMul ARGS((tTree params));
static void CheckDotProd ARGS((tTree params));
static tTree GetBoundary ARGS((tTree boundary, tTree array));
static void CheckTranspose ARGS((tTree params));
static void CheckRed ARGS((tIdent name, tTree params));
static void CheckLocRed ARGS((tIdent name, tTree params));
static void CheckScan ARGS((tIdent name, tTree params));
static void CheckScatter ARGS((tIdent name, tTree params));
static void CheckSizeParams ARGS((tIdent name, tTree params));
static void CheckBoundParams ARGS((tIdent name, tTree params));
static void CheckIndexParams ARGS((tTree params));
static void CheckPresentParams ARGS((tTree params));
static void CheckConformRanks ARGS((tTree call, tTree params, int rank));
void SetIntrinsicInfo ARGS((tIdent name, int base_rank, routine set_parameter));
static void SetMinMaxParams ARGS((int len, routine set_parameter, check_pred pred));
static void SetReductionParams ARGS((int dimrank, routine set_parameter, check_pred pred));
static void SetScanParams ARGS((tIdent name, routine set_parameter));
static void SetScatterParams ARGS((int base_rank, routine set_parameter, check_pred pred));

void SemIntrinsicFunction
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tIdent name, register tTree params)
# else
(exp, name, params)
 register tTree exp;
 register tIdent name;
 register tTree params;
# endif
{
# line 61 "SemIntr.puma"
  {
# line 63 "SemIntr.puma"
   if (! ((GetIntrinsicClass (GetIntrinsicObject (name)) == kELEMENTAL))) goto yyL1;
  {
# line 65 "SemIntr.puma"
   CheckElementalIntrinsic (exp, name, params);
  }
  }
   return;
yyL1:;

# line 68 "SemIntr.puma"
  {
# line 70 "SemIntr.puma"
   if (! ((GetIntrinsicClass (GetIntrinsicObject (name)) == kINQUIRY))) goto yyL2;
  }
   return;
yyL2:;

# line 73 "SemIntr.puma"
  {
# line 75 "SemIntr.puma"
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kREDUCTION))) goto yyL3;
  {
# line 76 "SemIntr.puma"
   CheckRed (name, params);
  }
  }
   return;
yyL3:;

# line 79 "SemIntr.puma"
  {
# line 81 "SemIntr.puma"
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kLOCREDUCTION))) goto yyL4;
  {
# line 82 "SemIntr.puma"
   CheckLocRed (name, params);
  }
  }
   return;
yyL4:;

# line 85 "SemIntr.puma"
  {
# line 87 "SemIntr.puma"
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kSCAN))) goto yyL5;
  {
# line 88 "SemIntr.puma"
   CheckScan (name, params);
  }
  }
   return;
yyL5:;

  if (equaltIdent (name, IsIdent ("SPREAD"))) {
# line 91 "SemIntr.puma"
  {
# line 93 "SemIntr.puma"
   CheckSpread (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CSHIFT"))) {
# line 100 "SemIntr.puma"
  {
# line 102 "SemIntr.puma"
   CheckCShift (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("EOSHIFT"))) {
# line 105 "SemIntr.puma"
  {
# line 107 "SemIntr.puma"
   CheckEOShift (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TRANSPOSE"))) {
# line 114 "SemIntr.puma"
  {
# line 116 "SemIntr.puma"
   CheckTranspose (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("GRADE_UP"))) {
# line 123 "SemIntr.puma"
  {
# line 125 "SemIntr.puma"
   CheckSort (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("GRADE_DOWN"))) {
# line 128 "SemIntr.puma"
  {
# line 130 "SemIntr.puma"
   CheckSort (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SORT_UP"))) {
# line 137 "SemIntr.puma"
  {
# line 139 "SemIntr.puma"
   CheckSort (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SORT_DOWN"))) {
# line 142 "SemIntr.puma"
  {
# line 144 "SemIntr.puma"
   CheckSort (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DOT_PRODUCT"))) {
# line 151 "SemIntr.puma"
  {
# line 153 "SemIntr.puma"
   CheckDotProd (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MATMUL"))) {
# line 160 "SemIntr.puma"
  {
# line 162 "SemIntr.puma"
   CheckMatMul (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MERGE", 5))) {
# line 169 "SemIntr.puma"
  {
# line 171 "SemIntr.puma"
   CheckMerge (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PACK"))) {
# line 178 "SemIntr.puma"
  {
# line 180 "SemIntr.puma"
   CheckPack (params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("UNPACK"))) {
# line 183 "SemIntr.puma"
  {
# line 185 "SemIntr.puma"
   warning_protocol ("UNPACK ist not checked until now");
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RESHAPE"))) {
# line 192 "SemIntr.puma"
  {
# line 194 "SemIntr.puma"
   warning_protocol ("RESHAPE ist not checked until now");
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SIZE"))) {
# line 201 "SemIntr.puma"
  {
# line 203 "SemIntr.puma"
   CheckSizeParams (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LBOUND"))) {
# line 206 "SemIntr.puma"
  {
# line 208 "SemIntr.puma"
   CheckBoundParams (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("UBOUND"))) {
# line 211 "SemIntr.puma"
  {
# line 213 "SemIntr.puma"
   CheckBoundParams (name, params);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SHAPE"))) {
# line 216 "SemIntr.puma"
  {
# line 218 "SemIntr.puma"
   warning_protocol ("SHAPE ist not checked until now");
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PRESENT"))) {
# line 221 "SemIntr.puma"
  {
# line 223 "SemIntr.puma"
   CheckPresentParams (params);
  }
   return;

  }
# line 230 "SemIntr.puma"
  {
# line 232 "SemIntr.puma"
   if (! ((IntrFuncScatter (name)))) goto yyL25;
  {
# line 233 "SemIntr.puma"
   CheckScatter (name, params);
  }
  }
   return;
yyL25:;

# line 240 "SemIntr.puma"
  {
# line 242 "SemIntr.puma"
   if (! (((name == IsIdent ("SELECTED_INT_KIND")) || (name == IsIdent ("SELECTED_REAL_KIND"))))) goto yyL26;
  }
   return;
yyL26:;

# line 246 "SemIntr.puma"
  {
# line 248 "SemIntr.puma"
   error_protocol ("unknown intrinsic function in Semantic Analysis");
# line 249 "SemIntr.puma"
   tree_protocol ("intrinsic call : ", mPROC_OBJ (name));
  }
   return;

;
}

void SemIntrinsicSubroutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (equaltIdent (name, IsIdent ("DATE_AND_TIME"))) {
# line 260 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("RANDOM_NUMBER"))) {
# line 263 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("RANDOM_SEED"))) {
# line 266 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("CPU_TIME"))) {
# line 269 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("MVBITS"))) {
# line 272 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("SYSTEM_CLOCK"))) {
# line 275 "SemIntr.puma"
   return;

  }
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 278 "SemIntr.puma"
  {
# line 282 "SemIntr.puma"
   if (! (((name == IsIdent ("HPF_ALIGNMENT")) || (name == IsIdent ("GLOBAL_ALIGNMENT"))))) goto yyL7;
  }
   return;
yyL7:;

  }
  }
  }
  }
  }
# line 294 "SemIntr.puma"
  {
# line 296 "SemIntr.puma"
   if (! (((name == IsIdent ("ABSTRACT_TO_PHYSICAL")) || (name == IsIdent ("PHYSICAL_TO_ABSTRACT"))))) goto yyL13;
  }
   return;
yyL13:;

  }
  }
  }
  if (equaltIdent (name, IsIdent ("HPF_DISTRIBUTION"))) {
# line 286 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_DISTRIBUTION"))) {
# line 287 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("HPF_TEMPLATE"))) {
# line 289 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_TEMPLATE"))) {
# line 290 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("HPF_SUBGRID_INFO"))) {
# line 292 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("LOCAL_TO_GLOBAL"))) {
# line 300 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_TO_LOCAL"))) {
# line 301 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("HPF_SEND"))) {
# line 303 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("HPF_RECV"))) {
# line 304 "SemIntr.puma"
   return;

  }
# line 306 "SemIntr.puma"
  {
# line 307 "SemIntr.puma"
   error_protocol ("unknown/illegal intrinsic subroutine (not supported)");
  }
   return;

;
}

static void NoScalarArgument
# if defined __STDC__ | defined __cplusplus
(register tIdent routine_id, register tIdent arg, register tTree arg_tree)
# else
(routine_id, arg, arg_tree)
 register tIdent routine_id;
 register tIdent arg;
 register tTree arg_tree;
# endif
{
# line 324 "SemIntr.puma"

char routine_name [MAXID_LENGTH];
char arg_name     [MAXID_LENGTH];
char msg          [MAX_LINE_LENGTH];

# line 330 "SemIntr.puma"
  {
# line 332 "SemIntr.puma"
   if (! ((TreeRank (arg_tree) > 0))) goto yyL1;
  }
   return;
yyL1:;

# line 335 "SemIntr.puma"
  {
# line 337 "SemIntr.puma"
   GetString (routine_id, routine_name);
# line 338 "SemIntr.puma"
   GetString (arg, arg_name);
# line 339 "SemIntr.puma"
   sprintf (msg, "argument for %s in %s must not be scalar", arg_name, routine_name);
# line 341 "SemIntr.puma"
   error_protocol (msg);
  }
   return;

;
}

static void SameShape
# if defined __STDC__ | defined __cplusplus
(register tIdent routine_id, register tIdent arg1, register tTree arg_tree1, register tIdent arg2, register tTree arg_tree2)
# else
(routine_id, arg1, arg_tree1, arg2, arg_tree2)
 register tIdent routine_id;
 register tIdent arg1;
 register tTree arg_tree1;
 register tIdent arg2;
 register tTree arg_tree2;
# endif
{
# line 353 "SemIntr.puma"

char routine_name [MAXID_LENGTH];
char arg_name1    [MAXID_LENGTH];
char arg_name2    [MAXID_LENGTH];
char msg          [MAX_LINE_LENGTH];

  if (arg_tree2->Kind == kNO_PARAM) {
# line 360 "SemIntr.puma"
   return;

  }
# line 363 "SemIntr.puma"
  {
# line 365 "SemIntr.puma"
   if (! ((TreeRank (arg_tree1) == TreeRank (arg_tree2)))) goto yyL2;
  }
   return;
yyL2:;

# line 368 "SemIntr.puma"
  {
# line 370 "SemIntr.puma"
   GetString (routine_id, routine_name);
# line 371 "SemIntr.puma"
   GetString (arg1, arg_name1);
# line 372 "SemIntr.puma"
   GetString (arg2, arg_name2);
# line 373 "SemIntr.puma"
   sprintf (msg, "arguments %s and %s in %s must have the same shape", arg_name1, arg_name2, routine_name);
# line 375 "SemIntr.puma"
   error_protocol (msg);
  }
   return;

;
}

static void Conformable
# if defined __STDC__ | defined __cplusplus
(register tIdent routine_id, register tIdent arg1, register tTree arg_tree1, register tIdent arg2, register tTree arg_tree2)
# else
(routine_id, arg1, arg_tree1, arg2, arg_tree2)
 register tIdent routine_id;
 register tIdent arg1;
 register tTree arg_tree1;
 register tIdent arg2;
 register tTree arg_tree2;
# endif
{
# line 387 "SemIntr.puma"

char routine_name [MAXID_LENGTH];
char arg_name1    [MAXID_LENGTH];
char arg_name2    [MAXID_LENGTH];
char msg          [MAX_LINE_LENGTH];

  if (arg_tree2->Kind == kNO_PARAM) {
# line 394 "SemIntr.puma"
   return;

  }
# line 397 "SemIntr.puma"
  {
# line 399 "SemIntr.puma"
   if (! ((TreeRank (arg_tree1) == TreeRank (arg_tree2)))) goto yyL2;
  }
   return;
yyL2:;

# line 402 "SemIntr.puma"
  {
# line 404 "SemIntr.puma"
   if (! ((TreeRank (arg_tree2) == 0))) goto yyL3;
  }
   return;
yyL3:;

# line 407 "SemIntr.puma"
  {
# line 409 "SemIntr.puma"
   GetString (routine_id, routine_name);
# line 410 "SemIntr.puma"
   GetString (arg1, arg_name1);
# line 411 "SemIntr.puma"
   GetString (arg2, arg_name2);
# line 412 "SemIntr.puma"
   sprintf (msg, "arguments %s and %s in %s must be conformable", arg_name1, arg_name2, routine_name);
# line 414 "SemIntr.puma"
   error_protocol (msg);
  }
   return;

;
}

static void LegalDimArgument
# if defined __STDC__ | defined __cplusplus
(register tIdent routine_id, register tIdent arg, register tTree arg_tree, register tTree dim_tree)
# else
(routine_id, arg, arg_tree, dim_tree)
 register tIdent routine_id;
 register tIdent arg;
 register tTree arg_tree;
 register tTree dim_tree;
# endif
{
# line 426 "SemIntr.puma"

int  dim, rank;
bool found;
char routine_name [MAXID_LENGTH];
char arg_name     [MAXID_LENGTH];
char msg          [MAX_LINE_LENGTH];

  if (dim_tree->Kind == kNO_PARAM) {
# line 434 "SemIntr.puma"
   return;

  }
# line 437 "SemIntr.puma"
  {
# line 439 "SemIntr.puma"
   if (! ((! ScalarIntExpr (dim_tree)))) goto yyL2;
  {
# line 441 "SemIntr.puma"
   GetString (routine_id, routine_name);
# line 442 "SemIntr.puma"
   sprintf (msg, "DIM argument in %s is not scalar integer", routine_name);
# line 443 "SemIntr.puma"
   error_protocol (msg);
  }
  }
   return;
yyL2:;

# line 446 "SemIntr.puma"
  {
# line 448 "SemIntr.puma"
   rank = TreeRank (arg_tree);
# line 449 "SemIntr.puma"
   GetIntConstValue (dim_tree, & found, & dim);
# line 450 "SemIntr.puma"
   if (! ((found))) goto yyL3;
  {
# line 452 "SemIntr.puma"
 if (dim < 1)
 
     { GetString (routine_id, routine_name);
       sprintf (msg, "DIM argument in %s must be positive", routine_name);
       error_protocol (msg);
     }

     if (dim > rank)

     { GetString (routine_id, routine_name);
       GetString (arg, arg_name);
       sprintf (msg, "DIM argument (=%d) in %s must be <= %d (rank of %s)",
                      dim, routine_name, rank, arg_name);
       error_protocol (msg);
     }
   
  }
  }
   return;
yyL3:;

# line 470 "SemIntr.puma"
  {
# line 472 "SemIntr.puma"
   GetString (routine_id, routine_name);
# line 473 "SemIntr.puma"
   sprintf (msg, "value of DIM argument in %s unknown at compile time", routine_name);
# line 475 "SemIntr.puma"
   warning_protocol (msg);
  }
   return;

;
}

static tTree MakeOmittedDim
# if defined __STDC__ | defined __cplusplus
(register tTree dim)
# else
(dim)
 register tTree dim;
# endif
{
  if (dim->Kind == kNO_PARAM) {
# line 486 "SemIntr.puma"
   return ExpToVarParam (MakeConstant (1));

  }
# line 491 "SemIntr.puma"
   return dim;

}

static void CheckElementalIntrinsic
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tIdent name, register tTree params)
# else
(exp, name, params)
 register tTree exp;
 register tIdent name;
 register tTree params;
# endif
{
  if (equaltIdent (name, IsIdent ("INDEX"))) {
# line 504 "SemIntr.puma"
  {
# line 506 "SemIntr.puma"
   CheckIndexParams (params);
# line 507 "SemIntr.puma"
   CheckConformRanks (exp, params, 0);
  }
   return;

  }
# line 510 "SemIntr.puma"
  {
# line 512 "SemIntr.puma"
   CheckConformRanks (exp, params, 0);
  }
   return;

;
}

static void CheckMerge
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 523 "SemIntr.puma"
  {
# line 525 "SemIntr.puma"
 if (MergeRank (TreeRank (params->BTP_LIST.Elem), TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem)) == -1)
       error_protocol ("sources in MERGE have different rank");
     if (MergeRank (TreeRank (params->BTP_LIST.Elem), TreeRank (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem)) == -1)
       error_protocol ("rank of mask in MERGE is not conform");
   
  }
   return;

  }
  }
  }
  }
# line 532 "SemIntr.puma"
  {
# line 533 "SemIntr.puma"
   error_protocol ("MERGE has not three Parameters");
  }
   return;

;
}

static void CheckPack
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 544 "SemIntr.puma"
  {
# line 546 "SemIntr.puma"
 
   
  }
   return;

  }
  }
  }
  }
# line 550 "SemIntr.puma"
  {
# line 551 "SemIntr.puma"
   error_protocol ("PACK has not three Parameters");
  }
   return;

;
}

static void CheckUnpack
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 562 "SemIntr.puma"
  {
# line 564 "SemIntr.puma"
 
   
  }
   return;

  }
  }
  }
  }
# line 568 "SemIntr.puma"
  {
# line 569 "SemIntr.puma"
   error_protocol ("UNPACK has not three Parameters");
  }
   return;

;
}

static void CheckReshape
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 580 "SemIntr.puma"
  {
# line 583 "SemIntr.puma"
 
   
  }
   return;

  }
  }
  }
  }
  }
# line 587 "SemIntr.puma"
  {
# line 588 "SemIntr.puma"
   error_protocol ("RESHAPE has not three Parameters");
  }
   return;

;
}

static void CheckCShift
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 598 "SemIntr.puma"
  {
# line 600 "SemIntr.puma"
   NoScalarArgument (IsIdent ("CSHIFT"), IsIdent ("ARRAY"), params->BTP_LIST.Elem);
# line 604 "SemIntr.puma"
 params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem = MakeOmittedDim (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem); 
# line 606 "SemIntr.puma"
   LegalDimArgument (IsIdent ("CSHIFT"), IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
# line 610 "SemIntr.puma"
 if (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) == 0)
        {  }
       else if (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) != TreeRank (params->BTP_LIST.Elem) - 1)
        error_protocol ("shift-rank must have rank array-rank - 1");
   
  }
   return;

  }
  }
  }
  }
# line 617 "SemIntr.puma"
  {
# line 618 "SemIntr.puma"
   error_protocol ("CSHIFT has illegal parameter list");
  }
   return;

;
}

static void CheckSpread
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 629 "SemIntr.puma"
   return;

  }
  }
  }
  }
# line 635 "SemIntr.puma"
  {
# line 636 "SemIntr.puma"
   error_protocol ("SPREAD has not three parameters");
  }
   return;

;
}

static void CheckEOShift
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 647 "SemIntr.puma"
  {
# line 650 "SemIntr.puma"
   NoScalarArgument (IsIdent ("EOSHIFT"), IsIdent ("ARRAY"), params->BTP_LIST.Elem);
# line 654 "SemIntr.puma"
 params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem = MakeOmittedDim (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem); 
# line 656 "SemIntr.puma"
   LegalDimArgument (IsIdent ("EOSHIFT"), IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
# line 658 "SemIntr.puma"
 if (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) == 0)
        {  }
       else if (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) != TreeRank (params->BTP_LIST.Elem) - 1)
        error_protocol ("shift-rank must have rank array-rank - 1");

     
 
     params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem = GetBoundary (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, params->BTP_LIST.Elem); 
   
  }
   return;

  }
  }
  }
  }
  }
;
}

static void CheckSort
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 678 "SemIntr.puma"
  {
# line 680 "SemIntr.puma"
   NoScalarArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem);
# line 681 "SemIntr.puma"
   LegalDimArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
# line 684 "SemIntr.puma"
  {
# line 686 "SemIntr.puma"
   error_protocol ("illegal argument list in GRADE/SORT_DOWN/UP");
  }
   return;

;
}

static void CheckMatMul
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 697 "SemIntr.puma"
 {
  int rank_a;
  int rank_b;
  {
# line 699 "SemIntr.puma"

# line 700 "SemIntr.puma"

# line 702 "SemIntr.puma"
   rank_a = TreeRank (params->BTP_LIST.Elem);
# line 703 "SemIntr.puma"
   rank_b = TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem);
# line 705 "SemIntr.puma"
 if ((rank_a < 1) || (rank_a > 2))
       error_protocol ("MATRIX_A in MATMUL must have rank one or two");
     if ((rank_b < 1) || (rank_b > 2))
       error_protocol ("MATRIX_B in MATMUL must have rank one or two");
     if ((rank_a == 1) && (rank_b == 1))
       error_protocol ("MATRIX_A or MATRIX_B in MATMUL must have rank two");
   
  }
   return;
 }

  }
  }
  }
;
}

static void CheckDotProd
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 722 "SemIntr.puma"
  {
# line 724 "SemIntr.puma"
 if (TreeRank (params->BTP_LIST.Elem) != 1)
       error_protocol ("VECTOR_A in DOT_PRODUCT must have rank one");
     if (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) != 1)
       error_protocol ("VECTOR_B in DOT_PRODUCT must have rank one");

     
   
  }
   return;

  }
  }
  }
;
}

static tTree GetBoundary
# if defined __STDC__ | defined __cplusplus
(register tTree boundary, register tTree array)
# else
(boundary, array)
 register tTree boundary;
 register tTree array;
# endif
{
  if (boundary->Kind == kNO_PARAM) {
  if (array->Kind == kVAR_PARAM) {
# line 741 "SemIntr.puma"
   return ExpToVarParam (GetTypeZero (array->VAR_PARAM.V));

  }
  }
# line 746 "SemIntr.puma"
   return boundary;

}

static void CheckTranspose
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 758 "SemIntr.puma"
  {
# line 760 "SemIntr.puma"
 if (TreeRank (params->BTP_LIST.Elem) != 2)
       error_protocol ("Array in transpose must be two-dimensional");
   
  }
   return;

  }
  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 765 "SemIntr.puma"
   return;

  }
  }
  }
# line 768 "SemIntr.puma"
  {
# line 770 "SemIntr.puma"
   error_protocol ("illegal arguments for TRANSPOSE");
  }
   return;

;
}

static void CheckRed
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 784 "SemIntr.puma"
  {
# line 786 "SemIntr.puma"
   NoScalarArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem);
# line 787 "SemIntr.puma"
   Conformable (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, IsIdent ("MASK"), params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
# line 788 "SemIntr.puma"
   LegalDimArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
  }
# line 791 "SemIntr.puma"
  {
# line 793 "SemIntr.puma"
   error_protocol ("reduction intrinsic has not three parameters");
  }
   return;

;
}

static void CheckLocRed
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
# line 806 "SemIntr.puma"
  {
# line 808 "SemIntr.puma"
   CheckRed (name, params);
  }
   return;

;
}

static void CheckScan
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 829 "SemIntr.puma"
  {
# line 833 "SemIntr.puma"
   NoScalarArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem);
# line 834 "SemIntr.puma"
   SameShape (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, IsIdent ("SEGMENT"), params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
# line 835 "SemIntr.puma"
   LegalDimArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 840 "SemIntr.puma"
  {
# line 845 "SemIntr.puma"
   NoScalarArgument (name, IsIdent ("MASK"), params->BTP_LIST.Elem);
# line 846 "SemIntr.puma"
   SameShape (name, IsIdent ("MASK"), params->BTP_LIST.Elem, IsIdent ("SEGMENT"), params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
# line 847 "SemIntr.puma"
   LegalDimArgument (name, IsIdent ("MASK"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 852 "SemIntr.puma"
  {
# line 858 "SemIntr.puma"
   NoScalarArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem);
# line 859 "SemIntr.puma"
   LegalDimArgument (name, IsIdent ("MASK"), params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
# line 860 "SemIntr.puma"
   SameShape (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, IsIdent ("SEGMENT"), params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
# line 861 "SemIntr.puma"
   Conformable (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, IsIdent ("MASK"), params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
  }
  }
  }
;
}

static void CheckScatter
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 872 "SemIntr.puma"
  {
# line 874 "SemIntr.puma"
 if (TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) < 1)
     { error_protocol ("BASE in xxx_SCATTER must not be scalar");
       tree_protocol ("BASE argument is ", params->BTP_LIST.Next->BTP_LIST.Elem);
     }
  
  }
   return;

  }
  }
;
}

static void CheckSizeParams
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 889 "SemIntr.puma"
  {
# line 891 "SemIntr.puma"
   NoScalarArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem);
# line 892 "SemIntr.puma"
   LegalDimArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
# line 895 "SemIntr.puma"
  {
# line 897 "SemIntr.puma"
   error_protocol ("illegal argument list for intrinsic SIZE");
  }
   return;

;
}

static void CheckBoundParams
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 902 "SemIntr.puma"
  {
# line 904 "SemIntr.puma"
   NoScalarArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem);
# line 905 "SemIntr.puma"
   LegalDimArgument (name, IsIdent ("ARRAY"), params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
# line 908 "SemIntr.puma"
  {
# line 910 "SemIntr.puma"
   error_protocol ("illegal argument list for intrinsic LBOUND/UBOUND");
  }
   return;

;
}

static void CheckIndexParams
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 915 "SemIntr.puma"
 {
  tTree f_val;
  {
# line 917 "SemIntr.puma"

# line 919 "SemIntr.puma"
 f_val = mCONST_EXP (mBOOL_CONSTANT (0));
    params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem = ExpToVarParam (f_val);
  
  }
   return;
 }

  }
  }
  }
  }
  }
;
}

static void CheckPresentParams
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
  if (params->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 932 "SemIntr.puma"
  {
# line 937 "SemIntr.puma"
   if (! ((IsVarDummy (params->BTP_LIST.Elem->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL1;
  }
   return;
yyL1:;

  }
  }
  if (params->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 940 "SemIntr.puma"
  {
# line 942 "SemIntr.puma"
   error_protocol ("argument of present must be a dummy argument");
  }
   return;

  }
  }
  }
# line 945 "SemIntr.puma"
  {
# line 946 "SemIntr.puma"
   error_protocol ("illegal parameter list for present");
  }
   return;

;
}

static void CheckConformRanks
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree params, register int rank)
# else
(call, params, rank)
 register tTree call;
 register tTree params;
 register int rank;
# endif
{
  if (params->Kind == kBTP_LIST) {
# line 959 "SemIntr.puma"
 {
  int rank1;
  int prank;
  {
# line 961 "SemIntr.puma"

# line 962 "SemIntr.puma"

# line 964 "SemIntr.puma"
   rank1 = TreeRank (params->BTP_LIST.Elem);
# line 965 "SemIntr.puma"
   prank = rank;
# line 967 "SemIntr.puma"
 prank = rank;

     if (rank1 < 0)

        {  }

      else if (rank1 == 0)

        {   }

      else if (rank == 0)

        { prank = rank1;     }

      else if (rank1 != rank)

        { error_protocol ("rank mismatch in elemental call");
          tree_protocol ("call is : ", call);
          tree_protocol ("illegal rank for ", params->BTP_LIST.Elem);
        }
   
# line 989 "SemIntr.puma"
   CheckConformRanks (call, params->BTP_LIST.Next, prank);
  }
   return;
 }

  }
;
}

void SetIntrinsicInfo
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int base_rank, routine set_parameter)
# else
(name, base_rank, set_parameter)
 register tIdent name;
 register int base_rank;
 routine set_parameter;
# endif
{
  if (equaltIdent (name, IsIdent ("ABS"))) {
# line 1006 "SemIntr.puma"
  {
# line 1008 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ACHAR"))) {
# line 1011 "SemIntr.puma"
  {
# line 1013 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ACOS"))) {
# line 1016 "SemIntr.puma"
  {
# line 1018 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ACTIVE_NUM_PROCS"))) {
# line 1021 "SemIntr.puma"
  {
# line 1023 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ACTIVE_PROCS_SHAPE"))) {
# line 1026 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("ADJUSTL"))) {
# line 1029 "SemIntr.puma"
  {
# line 1031 "SemIntr.puma"
   set_parameter ("STRING", true, IntentIn, StringExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ADJUSTR"))) {
# line 1034 "SemIntr.puma"
  {
# line 1036 "SemIntr.puma"
   set_parameter ("STRING", true, IntentIn, StringExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("AIMAG"))) {
# line 1039 "SemIntr.puma"
  {
# line 1041 "SemIntr.puma"
   set_parameter ("Z", true, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("AINT"))) {
# line 1051 "SemIntr.puma"
  {
# line 1053 "SemIntr.puma"
   if (! (((name == IsIdent ("AINT")) || (name == IsIdent ("ANINT"))))) goto yyL9;
  {
# line 1055 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, NumExpr, - 1);
# line 1056 "SemIntr.puma"
   set_parameter ("KIND", false, IntentIn, InitIntExpr, 0);
  }
  }
   return;
yyL9:;

  }
  if (equaltIdent (name, IsIdent ("ALL"))) {
# line 1059 "SemIntr.puma"
  {
# line 1061 "SemIntr.puma"
   set_parameter ("MASK", true, IntentIn, LogicalExpr, - 1);
# line 1062 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ALLOCATED"))) {
# line 1065 "SemIntr.puma"
  {
# line 1067 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, AllocateObject, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ALOG"))) {
# line 1070 "SemIntr.puma"
  {
# line 1072 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ALOG10"))) {
# line 1075 "SemIntr.puma"
  {
# line 1077 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
# line 1080 "SemIntr.puma"
  {
# line 1082 "SemIntr.puma"
   if (! (((name == IsIdent ("AMAX0")) || (name == IsIdent ("AMAX1")) || (name == IsIdent ("DMAX1")) || (name == IsIdent ("DMIN1")) || (name == IsIdent ("AMIN0")) || (name == IsIdent ("AMIN1"))))) goto yyL14;
  {
# line 1086 "SemIntr.puma"
   SetMinMaxParams (base_rank, set_parameter, NumExpr);
  }
  }
   return;
yyL14:;

  if (equaltIdent (name, IsIdent ("AMOD"))) {
# line 1089 "SemIntr.puma"
  {
# line 1091 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, RealExpr, - 1);
# line 1092 "SemIntr.puma"
   set_parameter ("P", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ANINT"))) {
# line 1102 "SemIntr.puma"
  {
# line 1104 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, NumExpr, - 1);
# line 1105 "SemIntr.puma"
   set_parameter ("KIND", false, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ANY"))) {
# line 1108 "SemIntr.puma"
  {
# line 1110 "SemIntr.puma"
   set_parameter ("MASK", true, IntentIn, LogicalExpr, - 1);
# line 1111 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ASIN"))) {
# line 1114 "SemIntr.puma"
  {
# line 1116 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ASSOCIATED"))) {
# line 1119 "SemIntr.puma"
  {
# line 1121 "SemIntr.puma"
   set_parameter ("POINTER", true, IntentIn, PointerObject, - 1);
# line 1122 "SemIntr.puma"
   set_parameter ("TARGET", false, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ATAN"))) {
# line 1125 "SemIntr.puma"
  {
# line 1127 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ATAN2"))) {
# line 1130 "SemIntr.puma"
  {
# line 1132 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
# line 1133 "SemIntr.puma"
   set_parameter ("Y", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("BIT_SIZE"))) {
# line 1136 "SemIntr.puma"
  {
# line 1138 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("BTEST"))) {
# line 1141 "SemIntr.puma"
  {
# line 1143 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
# line 1144 "SemIntr.puma"
   set_parameter ("POS", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CABS"))) {
# line 1147 "SemIntr.puma"
  {
# line 1149 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CCOS"))) {
# line 1152 "SemIntr.puma"
  {
# line 1154 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CEILING"))) {
# line 1157 "SemIntr.puma"
  {
# line 1159 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CEXP"))) {
# line 1162 "SemIntr.puma"
  {
# line 1164 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CHAR"))) {
# line 1167 "SemIntr.puma"
  {
# line 1169 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, IntExpr, - 1);
# line 1170 "SemIntr.puma"
   set_parameter ("KIND", false, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CLOG"))) {
# line 1173 "SemIntr.puma"
  {
# line 1175 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CMPLX"))) {
# line 1184 "SemIntr.puma"
  {
# line 1186 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
# line 1187 "SemIntr.puma"
   set_parameter ("Y", true, IntentIn, NumExpr, - 1);
# line 1188 "SemIntr.puma"
   set_parameter ("KIND", false, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CONJG"))) {
# line 1191 "SemIntr.puma"
  {
# line 1193 "SemIntr.puma"
   set_parameter ("Z", true, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("COS"))) {
# line 1196 "SemIntr.puma"
  {
# line 1198 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("COSH"))) {
# line 1201 "SemIntr.puma"
  {
# line 1203 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("COUNT"))) {
# line 1206 "SemIntr.puma"
  {
# line 1208 "SemIntr.puma"
   set_parameter ("MASK", true, IntentIn, LogicalExpr, - 1);
# line 1209 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CPU_TIME"))) {
# line 1218 "SemIntr.puma"
  {
# line 1220 "SemIntr.puma"
   set_parameter ("TIME", true, IntentOut, RealExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CSHIFT"))) {
# line 1230 "SemIntr.puma"
  {
# line 1232 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, Expr, - 1);
# line 1233 "SemIntr.puma"
   set_parameter ("SHIFT", true, IntentIn, IntExpr, - 1);
# line 1234 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CSIN"))) {
# line 1237 "SemIntr.puma"
  {
# line 1239 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("CSQRT"))) {
# line 1242 "SemIntr.puma"
  {
# line 1244 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, ComplexExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DABS"))) {
# line 1247 "SemIntr.puma"
  {
# line 1249 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DACOS"))) {
# line 1252 "SemIntr.puma"
  {
# line 1254 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DASIN"))) {
# line 1257 "SemIntr.puma"
  {
# line 1259 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DATAN"))) {
# line 1262 "SemIntr.puma"
  {
# line 1264 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DATAN2"))) {
# line 1267 "SemIntr.puma"
  {
# line 1269 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
# line 1270 "SemIntr.puma"
   set_parameter ("Y", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DATE_AND_TIME"))) {
# line 1279 "SemIntr.puma"
  {
# line 1281 "SemIntr.puma"
   set_parameter ("DATE", false, IntentOut, StringExpr, 0);
# line 1282 "SemIntr.puma"
   set_parameter ("TIME", false, IntentOut, StringExpr, 0);
# line 1283 "SemIntr.puma"
   set_parameter ("ZONE", false, IntentOut, StringExpr, 0);
# line 1284 "SemIntr.puma"
   set_parameter ("VALUES", false, IntentOut, IntExpr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DBLE"))) {
# line 1287 "SemIntr.puma"
  {
# line 1289 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DCOS"))) {
# line 1292 "SemIntr.puma"
  {
# line 1294 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DCOSH"))) {
# line 1297 "SemIntr.puma"
  {
# line 1299 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DDIM"))) {
# line 1302 "SemIntr.puma"
  {
# line 1304 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
# line 1305 "SemIntr.puma"
   set_parameter ("Y", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DEXP"))) {
# line 1308 "SemIntr.puma"
  {
# line 1310 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DIGITS"))) {
# line 1313 "SemIntr.puma"
  {
# line 1315 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DIM"))) {
# line 1318 "SemIntr.puma"
  {
# line 1320 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
# line 1321 "SemIntr.puma"
   set_parameter ("Y", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DINT"))) {
# line 1324 "SemIntr.puma"
  {
# line 1326 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DLOG"))) {
# line 1329 "SemIntr.puma"
  {
# line 1331 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DLOG10"))) {
# line 1334 "SemIntr.puma"
  {
# line 1336 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DMOD"))) {
# line 1339 "SemIntr.puma"
  {
# line 1341 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, DoubleRealExpr, - 1);
# line 1342 "SemIntr.puma"
   set_parameter ("P", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DNINT"))) {
# line 1345 "SemIntr.puma"
  {
# line 1347 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DOT_PRODUCT"))) {
# line 1358 "SemIntr.puma"
  {
# line 1360 "SemIntr.puma"
   set_parameter ("VECTOR_A", true, IntentIn, Expr, 1);
# line 1361 "SemIntr.puma"
   set_parameter ("VECTOR_B", true, IntentIn, Expr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DPROD"))) {
# line 1364 "SemIntr.puma"
  {
# line 1366 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
# line 1367 "SemIntr.puma"
   set_parameter ("Y", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DSIGN"))) {
# line 1370 "SemIntr.puma"
  {
# line 1372 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, DoubleRealExpr, - 1);
# line 1373 "SemIntr.puma"
   set_parameter ("B", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DSIN"))) {
# line 1376 "SemIntr.puma"
  {
# line 1378 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DSINH"))) {
# line 1381 "SemIntr.puma"
  {
# line 1383 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DSQRT"))) {
# line 1386 "SemIntr.puma"
  {
# line 1388 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DTAN"))) {
# line 1391 "SemIntr.puma"
  {
# line 1393 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("DTANH"))) {
# line 1396 "SemIntr.puma"
  {
# line 1398 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("EOSHIFT"))) {
# line 1408 "SemIntr.puma"
  {
# line 1410 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, Expr, - 1);
# line 1411 "SemIntr.puma"
   set_parameter ("SHIFT", true, IntentIn, IntExpr, 0);
# line 1412 "SemIntr.puma"
   set_parameter ("BOUNDARY", false, IntentIn, Expr, 0);
# line 1413 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("EPSILON"))) {
# line 1416 "SemIntr.puma"
  {
# line 1418 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("EXP"))) {
# line 1421 "SemIntr.puma"
  {
# line 1423 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("EXPONENT"))) {
# line 1426 "SemIntr.puma"
  {
# line 1428 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("FLOAT"))) {
# line 1431 "SemIntr.puma"
  {
# line 1433 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("FLOOR"))) {
# line 1436 "SemIntr.puma"
  {
# line 1438 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("FRACTION"))) {
# line 1441 "SemIntr.puma"
  {
# line 1443 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
# line 1453 "SemIntr.puma"
  {
# line 1455 "SemIntr.puma"
   if (! (((name == IsIdent ("GRADE_DOWN")) || (name == IsIdent ("GRADE_UP"))))) goto yyL72;
  {
# line 1457 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, SortExpr, - 1);
# line 1458 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL72:;

# line 1468 "SemIntr.puma"
  {
# line 1470 "SemIntr.puma"
   if (! (((name == IsIdent ("SORT_DOWN")) || (name == IsIdent ("SORT_UP"))))) goto yyL73;
  {
# line 1472 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, SortExpr, - 1);
# line 1473 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL73:;

  if (equaltIdent (name, IsIdent ("HUGE"))) {
# line 1482 "SemIntr.puma"
  {
# line 1484 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IABS"))) {
# line 1487 "SemIntr.puma"
  {
# line 1489 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IACHAR"))) {
# line 1492 "SemIntr.puma"
  {
# line 1494 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, StringExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IALL"))) {
# line 1497 "SemIntr.puma"
  {
# line 1499 "SemIntr.puma"
   SetReductionParams (base_rank, set_parameter, IntExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IANY"))) {
# line 1502 "SemIntr.puma"
  {
# line 1504 "SemIntr.puma"
   SetReductionParams (base_rank, set_parameter, IntExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IAND"))) {
# line 1507 "SemIntr.puma"
  {
# line 1509 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
# line 1510 "SemIntr.puma"
   set_parameter ("J", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IBCLR"))) {
# line 1513 "SemIntr.puma"
  {
# line 1515 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
# line 1516 "SemIntr.puma"
   set_parameter ("POS", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IBITS"))) {
# line 1519 "SemIntr.puma"
  {
# line 1521 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
# line 1522 "SemIntr.puma"
   set_parameter ("POS", true, IntentIn, IntExpr, - 1);
# line 1523 "SemIntr.puma"
   set_parameter ("LEN", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IBSET"))) {
# line 1526 "SemIntr.puma"
  {
# line 1528 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
# line 1529 "SemIntr.puma"
   set_parameter ("POS", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ICHAR"))) {
# line 1532 "SemIntr.puma"
  {
# line 1534 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, StringExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IDIM"))) {
# line 1537 "SemIntr.puma"
  {
# line 1539 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, IntExpr, - 1);
# line 1540 "SemIntr.puma"
   set_parameter ("Y", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IDINT"))) {
# line 1543 "SemIntr.puma"
  {
# line 1545 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IDNINT"))) {
# line 1548 "SemIntr.puma"
  {
# line 1550 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IEOR"))) {
# line 1553 "SemIntr.puma"
  {
# line 1555 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
# line 1556 "SemIntr.puma"
   set_parameter ("J", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IFIX"))) {
# line 1559 "SemIntr.puma"
  {
# line 1561 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ILEN"))) {
# line 1564 "SemIntr.puma"
  {
# line 1566 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("INDEX"))) {
# line 1569 "SemIntr.puma"
  {
# line 1571 "SemIntr.puma"
   set_parameter ("STRING", true, IntentIn, StringExpr, - 1);
# line 1572 "SemIntr.puma"
   set_parameter ("SUBSTRING", true, IntentIn, StringExpr, - 1);
# line 1573 "SemIntr.puma"
   set_parameter ("BACK", false, IntentIn, LogicalExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("INT"))) {
# line 1583 "SemIntr.puma"
  {
# line 1585 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, NumExpr, - 1);
# line 1586 "SemIntr.puma"
   set_parameter ("KIND", false, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IOR"))) {
# line 1589 "SemIntr.puma"
  {
# line 1591 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
# line 1592 "SemIntr.puma"
   set_parameter ("J", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IPARITY"))) {
# line 1595 "SemIntr.puma"
  {
# line 1597 "SemIntr.puma"
   SetReductionParams (base_rank, set_parameter, IntExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ISHFT"))) {
# line 1600 "SemIntr.puma"
  {
# line 1602 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
# line 1603 "SemIntr.puma"
   set_parameter ("SHIFT", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ISHFTC"))) {
# line 1606 "SemIntr.puma"
  {
# line 1608 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
# line 1609 "SemIntr.puma"
   set_parameter ("SHIFT", true, IntentIn, IntExpr, - 1);
# line 1610 "SemIntr.puma"
   set_parameter ("SSIZE", false, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ISIGN"))) {
# line 1613 "SemIntr.puma"
  {
# line 1615 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, IntExpr, - 1);
# line 1616 "SemIntr.puma"
   set_parameter ("B", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("KIND"))) {
# line 1619 "SemIntr.puma"
  {
# line 1621 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LBOUND"))) {
# line 1624 "SemIntr.puma"
  {
# line 1626 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, ArrayExpr, - 1);
# line 1627 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LEADZ"))) {
# line 1630 "SemIntr.puma"
  {
# line 1632 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LEN"))) {
# line 1635 "SemIntr.puma"
  {
# line 1637 "SemIntr.puma"
   set_parameter ("STRING", true, IntentIn, StringExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LEN_TRIM"))) {
# line 1640 "SemIntr.puma"
  {
# line 1642 "SemIntr.puma"
   set_parameter ("STRING", true, IntentIn, StringExpr, - 1);
  }
   return;

  }
# line 1654 "SemIntr.puma"
  {
# line 1656 "SemIntr.puma"
   if (! (((name == IsIdent ("LGE")) || (name == IsIdent ("LGT")) || (name == IsIdent ("LLE")) || (name == IsIdent ("LLT"))))) goto yyL102;
  {
# line 1659 "SemIntr.puma"
   set_parameter ("STRING_A", true, IntentIn, StringExpr, - 1);
# line 1660 "SemIntr.puma"
   set_parameter ("STRING_B", true, IntentIn, StringExpr, - 1);
  }
  }
   return;
yyL102:;

  if (equaltIdent (name, IsIdent ("LOG"))) {
# line 1663 "SemIntr.puma"
  {
# line 1665 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LOGICAL"))) {
# line 1668 "SemIntr.puma"
  {
# line 1670 "SemIntr.puma"
   set_parameter ("L", true, IntentIn, NumExpr, - 1);
# line 1671 "SemIntr.puma"
   set_parameter ("KIND", false, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LOG10"))) {
# line 1674 "SemIntr.puma"
  {
# line 1676 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MATMUL"))) {
# line 1685 "SemIntr.puma"
  {
# line 1687 "SemIntr.puma"
   set_parameter ("MATRIX_A", true, IntentIn, Expr, - 1);
# line 1688 "SemIntr.puma"
   set_parameter ("MATRIX_B", true, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAX"))) {
# line 1691 "SemIntr.puma"
  {
# line 1693 "SemIntr.puma"
   SetMinMaxParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAXEXPONENT"))) {
# line 1696 "SemIntr.puma"
  {
# line 1698 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAXLOC"))) {
# line 1701 "SemIntr.puma"
  {
# line 1703 "SemIntr.puma"
   SetReductionParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAXVAL"))) {
# line 1706 "SemIntr.puma"
  {
# line 1708 "SemIntr.puma"
   SetReductionParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAX0"))) {
# line 1711 "SemIntr.puma"
  {
# line 1713 "SemIntr.puma"
   SetMinMaxParams (base_rank, set_parameter, IntExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAX1"))) {
# line 1716 "SemIntr.puma"
  {
# line 1718 "SemIntr.puma"
   SetMinMaxParams (base_rank, set_parameter, NormalRealExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MERGE"))) {
# line 1727 "SemIntr.puma"
  {
# line 1729 "SemIntr.puma"
   set_parameter ("TSOURCE", true, IntentIn, Expr, - 1);
# line 1730 "SemIntr.puma"
   set_parameter ("FSOURCE", true, IntentIn, Expr, - 1);
# line 1731 "SemIntr.puma"
   set_parameter ("MASK", true, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MIN"))) {
# line 1734 "SemIntr.puma"
  {
# line 1736 "SemIntr.puma"
   SetMinMaxParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MINEXPONENT"))) {
# line 1739 "SemIntr.puma"
  {
# line 1741 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MINLOC"))) {
# line 1744 "SemIntr.puma"
  {
# line 1746 "SemIntr.puma"
   SetReductionParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MINVAL"))) {
# line 1749 "SemIntr.puma"
  {
# line 1751 "SemIntr.puma"
   SetReductionParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MIN0"))) {
# line 1754 "SemIntr.puma"
  {
# line 1756 "SemIntr.puma"
   SetMinMaxParams (base_rank, set_parameter, IntExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MIN1"))) {
# line 1759 "SemIntr.puma"
  {
# line 1761 "SemIntr.puma"
   SetMinMaxParams (base_rank, set_parameter, NormalRealExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MOD"))) {
# line 1764 "SemIntr.puma"
  {
# line 1766 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, NumExpr, - 1);
# line 1767 "SemIntr.puma"
   set_parameter ("P", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MODULO"))) {
# line 1770 "SemIntr.puma"
  {
# line 1772 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, NumExpr, - 1);
# line 1773 "SemIntr.puma"
   set_parameter ("P", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MVBITS"))) {
# line 1776 "SemIntr.puma"
  {
# line 1778 "SemIntr.puma"
   set_parameter ("FROM", true, IntentIn, IntExpr, - 1);
# line 1779 "SemIntr.puma"
   set_parameter ("FROMPOS", true, IntentIn, IntExpr, - 1);
# line 1780 "SemIntr.puma"
   set_parameter ("LEN", true, IntentIn, IntExpr, - 1);
# line 1781 "SemIntr.puma"
   set_parameter ("TO", true, IntentInOut, IntExpr, - 1);
# line 1782 "SemIntr.puma"
   set_parameter ("TOPOS", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("NEAREST"))) {
# line 1791 "SemIntr.puma"
  {
# line 1793 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
# line 1794 "SemIntr.puma"
   set_parameter ("S", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("NINT"))) {
# line 1797 "SemIntr.puma"
  {
# line 1799 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, RealExpr, - 1);
# line 1800 "SemIntr.puma"
   set_parameter ("KIND", false, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("NOT"))) {
# line 1803 "SemIntr.puma"
  {
# line 1805 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("NUMBER_OF_PROCESSORS"))) {
# line 1814 "SemIntr.puma"
  {
# line 1816 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PACK"))) {
# line 1825 "SemIntr.puma"
  {
# line 1827 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, ArrayExpr, - 1);
# line 1828 "SemIntr.puma"
   set_parameter ("MASK", true, IntentIn, LogicalExpr, - 1);
# line 1829 "SemIntr.puma"
   set_parameter ("VECTOR", false, IntentIn, Expr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PARITY"))) {
# line 1832 "SemIntr.puma"
  {
# line 1834 "SemIntr.puma"
   SetReductionParams (base_rank, set_parameter, LogicalExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("POPCNT"))) {
# line 1837 "SemIntr.puma"
  {
# line 1839 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("POPPAR"))) {
# line 1842 "SemIntr.puma"
  {
# line 1844 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PRECISION"))) {
# line 1847 "SemIntr.puma"
  {
# line 1849 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PRESENT"))) {
# line 1852 "SemIntr.puma"
  {
# line 1854 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PROCESSORS_SHAPE"))) {
# line 1857 "SemIntr.puma"
   return;

  }
  if (equaltIdent (name, IsIdent ("PRODUCT"))) {
# line 1860 "SemIntr.puma"
  {
# line 1862 "SemIntr.puma"
   SetReductionParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RADIX"))) {
# line 1865 "SemIntr.puma"
  {
# line 1867 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RANDOM_NUMBER"))) {
# line 1870 "SemIntr.puma"
  {
# line 1872 "SemIntr.puma"
   set_parameter ("HARVEST", true, IntentOut, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RANDOM_SEED"))) {
# line 1875 "SemIntr.puma"
  {
# line 1877 "SemIntr.puma"
   set_parameter ("SIZE", false, IntentOut, Expr, - 1);
# line 1878 "SemIntr.puma"
   set_parameter ("PUT", false, IntentOut, Expr, - 1);
# line 1879 "SemIntr.puma"
   set_parameter ("GET", false, IntentOut, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RANGE"))) {
# line 1882 "SemIntr.puma"
  {
# line 1884 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("REAL"))) {
# line 1893 "SemIntr.puma"
  {
# line 1895 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, NumExpr, - 1);
# line 1896 "SemIntr.puma"
   set_parameter ("KIND", false, IntentIn, InitIntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("REPEAT"))) {
# line 1899 "SemIntr.puma"
  {
# line 1901 "SemIntr.puma"
   set_parameter ("STRING", true, IntentIn, StringExpr, 0);
# line 1902 "SemIntr.puma"
   set_parameter ("NCOPIES", true, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RESHAPE"))) {
# line 1911 "SemIntr.puma"
  {
# line 1913 "SemIntr.puma"
   set_parameter ("SOURCE", true, IntentIn, ArrayExpr, - 1);
# line 1914 "SemIntr.puma"
   set_parameter ("SHAPE", true, IntentIn, IntExpr, 1);
# line 1915 "SemIntr.puma"
   set_parameter ("PAD", false, IntentIn, Expr, - 1);
# line 1916 "SemIntr.puma"
   set_parameter ("ORDER", false, IntentIn, IntExpr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("RRSPACING"))) {
# line 1919 "SemIntr.puma"
  {
# line 1921 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SCALE"))) {
# line 1924 "SemIntr.puma"
  {
# line 1926 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
# line 1927 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SCAN"))) {
# line 1930 "SemIntr.puma"
  {
# line 1932 "SemIntr.puma"
   set_parameter ("STRING", true, IntentIn, StringExpr, - 1);
# line 1933 "SemIntr.puma"
   set_parameter ("SET", true, IntentIn, StringExpr, - 1);
# line 1934 "SemIntr.puma"
   set_parameter ("BACK", false, IntentIn, LogicalExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SELECTED_INT_KIND"))) {
# line 1944 "SemIntr.puma"
  {
# line 1946 "SemIntr.puma"
   set_parameter ("R", true, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SELECTED_REAL_KIND"))) {
# line 1949 "SemIntr.puma"
  {
# line 1951 "SemIntr.puma"
   set_parameter ("P", false, IntentIn, IntExpr, 0);
# line 1952 "SemIntr.puma"
   set_parameter ("R", false, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SET_EXPONENT"))) {
# line 1955 "SemIntr.puma"
  {
# line 1957 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
# line 1958 "SemIntr.puma"
   set_parameter ("I", true, IntentIn, IntExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SHAPE"))) {
# line 1961 "SemIntr.puma"
  {
# line 1963 "SemIntr.puma"
   set_parameter ("SOURCE", true, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SIGN"))) {
# line 1966 "SemIntr.puma"
  {
# line 1968 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, NumExpr, - 1);
# line 1969 "SemIntr.puma"
   set_parameter ("B", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SIN"))) {
# line 1972 "SemIntr.puma"
  {
# line 1974 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SINH"))) {
# line 1977 "SemIntr.puma"
  {
# line 1979 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SIZE"))) {
# line 1982 "SemIntr.puma"
  {
# line 1984 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, ArrayExpr, - 1);
# line 1985 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SNGL"))) {
# line 1988 "SemIntr.puma"
  {
# line 1990 "SemIntr.puma"
   set_parameter ("A", true, IntentIn, DoubleRealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SPACING"))) {
# line 1993 "SemIntr.puma"
  {
# line 1995 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SPREAD"))) {
# line 2004 "SemIntr.puma"
  {
# line 2006 "SemIntr.puma"
   set_parameter ("SOURCE", true, IntentIn, Expr, - 1);
# line 2007 "SemIntr.puma"
   set_parameter ("DIM", true, IntentIn, IntExpr, 0);
# line 2008 "SemIntr.puma"
   set_parameter ("NCOPIES", true, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SQRT"))) {
# line 2011 "SemIntr.puma"
  {
# line 2013 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, NumExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SUM"))) {
# line 2016 "SemIntr.puma"
  {
# line 2018 "SemIntr.puma"
   SetReductionParams (base_rank, set_parameter, NumExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SYSTEM_CLOCK"))) {
# line 2021 "SemIntr.puma"
  {
# line 2023 "SemIntr.puma"
   set_parameter ("COUNT", false, IntentOut, IntExpr, 0);
# line 2024 "SemIntr.puma"
   set_parameter ("COUNT_RATE", false, IntentOut, IntExpr, 0);
# line 2025 "SemIntr.puma"
   set_parameter ("COUNT_MAX", false, IntentOut, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TAN"))) {
# line 2028 "SemIntr.puma"
  {
# line 2030 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TANH"))) {
# line 2033 "SemIntr.puma"
  {
# line 2035 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TINY"))) {
# line 2038 "SemIntr.puma"
  {
# line 2040 "SemIntr.puma"
   set_parameter ("X", true, IntentIn, RealExpr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TRANSFER"))) {
# line 2043 "SemIntr.puma"
  {
# line 2045 "SemIntr.puma"
   set_parameter ("SOURCE", true, IntentIn, Expr, - 1);
# line 2046 "SemIntr.puma"
   set_parameter ("MOLD", true, IntentIn, Expr, - 1);
# line 2047 "SemIntr.puma"
   set_parameter ("SIZE", false, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TRANSPOSE"))) {
# line 2058 "SemIntr.puma"
  {
# line 2060 "SemIntr.puma"
   set_parameter ("MATRIX", true, IntentIn, Expr, - 1);
# line 2061 "SemIntr.puma"
   set_parameter ("ORDER", false, IntentIn, IntExpr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("TRIM", 4))) {
# line 2070 "SemIntr.puma"
  {
# line 2072 "SemIntr.puma"
   set_parameter ("STRING", true, IntentIn, StringExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("UBOUND"))) {
# line 2075 "SemIntr.puma"
  {
# line 2077 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, ArrayExpr, - 1);
# line 2078 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("UNPACK"))) {
# line 2087 "SemIntr.puma"
  {
# line 2089 "SemIntr.puma"
   set_parameter ("VECTOR", true, IntentIn, Expr, 1);
# line 2090 "SemIntr.puma"
   set_parameter ("MASK", true, IntentIn, LogicalExpr, - 1);
# line 2091 "SemIntr.puma"
   set_parameter ("FIELD", true, IntentIn, Expr, - 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("VERIFY"))) {
# line 2100 "SemIntr.puma"
  {
# line 2102 "SemIntr.puma"
   set_parameter ("STRING", true, IntentIn, StringExpr, - 1);
# line 2103 "SemIntr.puma"
   set_parameter ("SET", true, IntentIn, StringExpr, - 1);
# line 2104 "SemIntr.puma"
   set_parameter ("BACK", false, IntentIn, LogicalExpr, 0);
  }
   return;

  }
# line 2113 "SemIntr.puma"
  {
# line 2115 "SemIntr.puma"
   if (! ((IntrFuncScan (name)))) goto yyL168;
  {
# line 2116 "SemIntr.puma"
   SetScanParams (name, set_parameter);
  }
  }
   return;
yyL168:;

  if (equaltIdent (name, IsIdent ("ALL_SCATTER"))) {
# line 2125 "SemIntr.puma"
  {
# line 2127 "SemIntr.puma"
   SetScatterParams (base_rank, set_parameter, LogicalExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("ANY_SCATTER"))) {
# line 2130 "SemIntr.puma"
  {
# line 2132 "SemIntr.puma"
   SetScatterParams (base_rank, set_parameter, LogicalExpr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("COPY_SCATTER"))) {
# line 2134 "SemIntr.puma"
  {
# line 2136 "SemIntr.puma"
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("COUNT_SCATTER"))) {
# line 2139 "SemIntr.puma"
  {
# line 2141 "SemIntr.puma"
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IALL_SCATTER"))) {
# line 2144 "SemIntr.puma"
  {
# line 2146 "SemIntr.puma"
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IANY_SCATTER"))) {
# line 2149 "SemIntr.puma"
  {
# line 2151 "SemIntr.puma"
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("IPARITY_SCATTER"))) {
# line 2154 "SemIntr.puma"
  {
# line 2156 "SemIntr.puma"
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MAXVAL_SCATTER"))) {
# line 2159 "SemIntr.puma"
  {
# line 2161 "SemIntr.puma"
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MINVAL_SCATTER"))) {
# line 2164 "SemIntr.puma"
  {
# line 2166 "SemIntr.puma"
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PARITY_SCATTER"))) {
# line 2169 "SemIntr.puma"
  {
# line 2171 "SemIntr.puma"
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PRODUCT_SCATTER"))) {
# line 2174 "SemIntr.puma"
  {
# line 2176 "SemIntr.puma"
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("SUM_SCATTER"))) {
# line 2179 "SemIntr.puma"
  {
# line 2181 "SemIntr.puma"
   SetScatterParams (base_rank, set_parameter, Expr);
  }
   return;

  }
# line 2194 "SemIntr.puma"
  {
# line 2196 "SemIntr.puma"
   if (! (((name == IsIdent ("HPF_ALIGNMENT")) || (name == IsIdent ("GLOBAL_ALIGNMENT"))))) goto yyL181;
  {
# line 2199 "SemIntr.puma"
   set_parameter ("ALIGNEE", true, IntentIn, Expr, - 1);
# line 2200 "SemIntr.puma"
   set_parameter ("LB", false, IntentOut, IntExpr, 1);
# line 2201 "SemIntr.puma"
   set_parameter ("UB", false, IntentOut, IntExpr, 1);
# line 2202 "SemIntr.puma"
   set_parameter ("STRIDE", false, IntentOut, IntExpr, 1);
# line 2203 "SemIntr.puma"
   set_parameter ("AXIS_MAP", false, IntentOut, IntExpr, 1);
# line 2204 "SemIntr.puma"
   set_parameter ("IDENTITY_MAP", false, IntentOut, LogicalExpr, 0);
# line 2205 "SemIntr.puma"
   set_parameter ("DYNAMIC", false, IntentOut, LogicalExpr, 0);
# line 2206 "SemIntr.puma"
   set_parameter ("NCOPIES", false, IntentOut, IntExpr, 0);
  }
  }
   return;
yyL181:;

# line 2209 "SemIntr.puma"
  {
# line 2211 "SemIntr.puma"
   if (! (((name == IsIdent ("HPF_DISTRIBUTION")) || (name == IsIdent ("GLOBAL_DISTRIBUTION"))))) goto yyL182;
  {
# line 2214 "SemIntr.puma"
   set_parameter ("DISTRIBUTEE", true, IntentIn, Expr, - 1);
# line 2215 "SemIntr.puma"
   set_parameter ("AXIS_TYPE", false, IntentOut, StringExpr, 1);
# line 2216 "SemIntr.puma"
   set_parameter ("AXIS_INFO", false, IntentOut, IntExpr, 1);
# line 2217 "SemIntr.puma"
   set_parameter ("PROCESSORS_RANK", false, IntentOut, IntExpr, 0);
# line 2218 "SemIntr.puma"
   set_parameter ("PROCESSORS_SHAPE", false, IntentOut, IntExpr, 1);
# line 2219 "SemIntr.puma"
   set_parameter ("PLB", false, IntentOut, IntExpr, 1);
# line 2220 "SemIntr.puma"
   set_parameter ("PUB", false, IntentOut, IntExpr, 1);
# line 2221 "SemIntr.puma"
   set_parameter ("PSTRIDE", false, IntentOut, IntExpr, 1);
# line 2222 "SemIntr.puma"
   set_parameter ("LOW_SHADOW", false, IntentOut, IntExpr, 1);
# line 2223 "SemIntr.puma"
   set_parameter ("HIGH_SHADOW", false, IntentOut, IntExpr, 1);
  }
  }
   return;
yyL182:;

# line 2226 "SemIntr.puma"
  {
# line 2228 "SemIntr.puma"
   if (! (((name == IsIdent ("HPF_TEMPLATE")) || (name == IsIdent ("GLOBAL_TEMPLATE"))))) goto yyL183;
  {
# line 2231 "SemIntr.puma"
   set_parameter ("ALIGNEE", true, IntentIn, Expr, - 1);
# line 2232 "SemIntr.puma"
   set_parameter ("TEMPLATE_RANK", false, IntentOut, IntExpr, 0);
# line 2233 "SemIntr.puma"
   set_parameter ("LB", false, IntentOut, IntExpr, 1);
# line 2234 "SemIntr.puma"
   set_parameter ("UB", false, IntentOut, IntExpr, 1);
# line 2235 "SemIntr.puma"
   set_parameter ("AXIS_TYPE", false, IntentOut, StringExpr, 1);
# line 2236 "SemIntr.puma"
   set_parameter ("AXIS_INFO", false, IntentOut, IntExpr, 1);
# line 2237 "SemIntr.puma"
   set_parameter ("NUMBER_ALIGNED", false, IntentOut, IntExpr, 0);
# line 2238 "SemIntr.puma"
   set_parameter ("DYNAMIC", false, IntentOut, LogicalExpr, 0);
  }
  }
   return;
yyL183:;

# line 2247 "SemIntr.puma"
  {
# line 2249 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_MAP_ARRAY")))) goto yyL184;
  {
# line 2251 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, Expr, - 1);
# line 2252 "SemIntr.puma"
   set_parameter ("TEMPLATE_DIM", true, IntentIn, IntExpr, 0);
# line 2253 "SemIntr.puma"
   set_parameter ("MAP_ARAY", true, IntentOut, IntExpr, 1);
  }
  }
   return;
yyL184:;

# line 2262 "SemIntr.puma"
  {
# line 2264 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_NUMBER_MAPPED")))) goto yyL185;
  {
# line 2266 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, Expr, - 1);
# line 2267 "SemIntr.puma"
   set_parameter ("PROCESSORS_DIM", true, IntentIn, IntExpr, 0);
# line 2268 "SemIntr.puma"
   set_parameter ("NUMBER_MAPPED", true, IntentOut, IntExpr, 1);
  }
  }
   return;
yyL185:;

# line 2277 "SemIntr.puma"
  {
# line 2279 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_SUBGRID_INFO")))) goto yyL186;
  {
# line 2281 "SemIntr.puma"
   if (! ((base_rank == 0))) goto yyL186;
  {
# line 2283 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, Expr, - 1);
# line 2284 "SemIntr.puma"
   set_parameter ("IERR", false, IntentOut, IntExpr, 0);
# line 2285 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
# line 2286 "SemIntr.puma"
   set_parameter ("LB", false, IntentOut, IntExpr, - 1);
# line 2287 "SemIntr.puma"
   set_parameter ("UB", false, IntentOut, IntExpr, - 1);
# line 2288 "SemIntr.puma"
   set_parameter ("STRIDE", false, IntentOut, IntExpr, - 1);
# line 2289 "SemIntr.puma"
   set_parameter ("LB_EMBED", false, IntentOut, IntExpr, - 1);
# line 2290 "SemIntr.puma"
   set_parameter ("UB_EMBED", false, IntentOut, IntExpr, - 1);
# line 2291 "SemIntr.puma"
   set_parameter ("AXIS_MAP", false, IntentOut, IntExpr, - 1);
  }
  }
  }
   return;
yyL186:;

# line 2294 "SemIntr.puma"
  {
# line 2296 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_SUBGRID_INFO")))) goto yyL187;
  {
# line 2298 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, Expr, - 1);
# line 2299 "SemIntr.puma"
   set_parameter ("IERR", false, IntentOut, IntExpr, 0);
# line 2300 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
# line 2301 "SemIntr.puma"
   set_parameter ("LB", false, IntentOut, IntExpr, 1);
# line 2302 "SemIntr.puma"
   set_parameter ("UB", false, IntentOut, IntExpr, 1);
# line 2303 "SemIntr.puma"
   set_parameter ("STRIDE", false, IntentOut, IntExpr, 1);
  }
  }
   return;
yyL187:;

# line 2312 "SemIntr.puma"
  {
# line 2314 "SemIntr.puma"
   if (! ((name == IsIdent ("GLOBAL_SHAPE")))) goto yyL188;
  {
# line 2316 "SemIntr.puma"
   set_parameter ("SOURCE", true, IntentIn, Expr, - 1);
  }
  }
   return;
yyL188:;

# line 2325 "SemIntr.puma"
  {
# line 2327 "SemIntr.puma"
   if (! ((name == IsIdent ("GLOBAL_SIZE")))) goto yyL189;
  {
# line 2329 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, Expr, - 1);
# line 2330 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL189:;

  if (equaltIdent (name, IsIdent ("ABSTRACT_TO_PHYSICAL"))) {
# line 2340 "SemIntr.puma"
  {
# line 2342 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, DummyHPFArray, - 1);
# line 2343 "SemIntr.puma"
   set_parameter ("INDEX", true, IntentIn, IntExpr, 1);
# line 2344 "SemIntr.puma"
   set_parameter ("PROC", true, IntentOut, IntExpr, 0);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("PHYSICAL_TO_ABSTRACT"))) {
# line 2347 "SemIntr.puma"
  {
# line 2349 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, DummyHPFArray, - 1);
# line 2350 "SemIntr.puma"
   set_parameter ("PROC", true, IntentIn, IntExpr, 0);
# line 2351 "SemIntr.puma"
   set_parameter ("INDEX", true, IntentOut, IntExpr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("LOCAL_TO_GLOBAL"))) {
# line 2361 "SemIntr.puma"
  {
# line 2363 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, DummyHPFArray, - 1);
# line 2364 "SemIntr.puma"
   set_parameter ("L_INDEX", true, IntentIn, IntExpr, 1);
# line 2365 "SemIntr.puma"
   set_parameter ("G_INDEX", true, IntentOut, IntExpr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("GLOBAL_TO_LOCAL"))) {
# line 2368 "SemIntr.puma"
  {
# line 2370 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, DummyHPFArray, - 1);
# line 2371 "SemIntr.puma"
   set_parameter ("G_INDEX", true, IntentIn, IntExpr, 1);
# line 2372 "SemIntr.puma"
   set_parameter ("L_INDEX", true, IntentOut, IntExpr, 1);
# line 2373 "SemIntr.puma"
   set_parameter ("LOCAL", true, IntentOut, LogicalExpr, 0);
# line 2374 "SemIntr.puma"
   set_parameter ("NCOPIES", true, IntentOut, IntExpr, 0);
# line 2375 "SemIntr.puma"
   set_parameter ("PROCS", true, IntentOut, IntExpr, 1);
  }
   return;

  }
  if (equaltIdent (name, IsIdent ("MY_PROCESSOR"))) {
# line 2384 "SemIntr.puma"
   return;

  }
# line 2395 "SemIntr.puma"
  {
# line 2397 "SemIntr.puma"
   if (! ((name == IsIdent ("LOCAL_BLKCNT")))) goto yyL195;
  {
# line 2399 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, DummyHPFArray, - 1);
# line 2400 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
# line 2401 "SemIntr.puma"
   set_parameter ("PROC", false, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL195:;

# line 2404 "SemIntr.puma"
  {
# line 2406 "SemIntr.puma"
   if (! (((name == IsIdent ("LOCAL_LINDEX")) || (name == IsIdent ("LOCAL_UINDEX"))))) goto yyL196;
  {
# line 2409 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, DummyHPFArray, - 1);
# line 2410 "SemIntr.puma"
   set_parameter ("DIM", true, IntentIn, IntExpr, 0);
# line 2411 "SemIntr.puma"
   set_parameter ("PROC", false, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL196:;

# line 2428 "SemIntr.puma"
  {
# line 2430 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_TASK_INIT")))) goto yyL197;
  }
   return;
yyL197:;

# line 2433 "SemIntr.puma"
  {
# line 2435 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_TASK_EXIT")))) goto yyL198;
  }
   return;
yyL198:;

# line 2438 "SemIntr.puma"
  {
# line 2440 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_TASK_RANK")))) goto yyL199;
  {
# line 2442 "SemIntr.puma"
   set_parameter ("RANK", true, IntentOut, IntExpr, 0);
  }
  }
   return;
yyL199:;

# line 2445 "SemIntr.puma"
  {
# line 2447 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_TASK_SIZE")))) goto yyL200;
  {
# line 2449 "SemIntr.puma"
   set_parameter ("SIZE", true, IntentOut, IntExpr, 0);
  }
  }
   return;
yyL200:;

# line 2452 "SemIntr.puma"
  {
# line 2454 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_SEND")))) goto yyL201;
  {
# line 2456 "SemIntr.puma"
   set_parameter ("DATA", true, IntentIn, DummyHPFArray, - 1);
# line 2457 "SemIntr.puma"
   set_parameter ("DEST", true, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL201:;

# line 2460 "SemIntr.puma"
  {
# line 2462 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_RECV")))) goto yyL202;
  {
# line 2464 "SemIntr.puma"
   set_parameter ("DATA", true, IntentOut, DummyHPFArray, - 1);
# line 2465 "SemIntr.puma"
   set_parameter ("SOURCE", false, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL202:;

# line 2468 "SemIntr.puma"
  {
# line 2470 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_SEND_INIT")))) goto yyL203;
  {
# line 2472 "SemIntr.puma"
   set_parameter ("DATA", true, IntentIn, DummyHPFArray, - 1);
# line 2473 "SemIntr.puma"
   set_parameter ("DEST", true, IntentIn, IntExpr, 0);
# line 2474 "SemIntr.puma"
   set_parameter ("REQUEST", true, IntentOut, IntExpr, 0);
  }
  }
   return;
yyL203:;

# line 2477 "SemIntr.puma"
  {
# line 2479 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_RECV_INIT")))) goto yyL204;
  {
# line 2481 "SemIntr.puma"
   set_parameter ("DATA", true, IntentIn, DummyHPFArray, - 1);
# line 2482 "SemIntr.puma"
   set_parameter ("SOURCE", true, IntentIn, IntExpr, 0);
# line 2483 "SemIntr.puma"
   set_parameter ("REQUEST", true, IntentOut, IntExpr, 0);
  }
  }
   return;
yyL204:;

# line 2486 "SemIntr.puma"
  {
# line 2488 "SemIntr.puma"
   if (! ((name == IsIdent ("HPF_TASK_COMM")))) goto yyL205;
  {
# line 2490 "SemIntr.puma"
   set_parameter ("REQUEST", true, IntentIn, IntExpr, 0);
  }
  }
   return;
yyL205:;

# line 2493 "SemIntr.puma"
   return;

;
}

static void SetMinMaxParams
# if defined __STDC__ | defined __cplusplus
(register int len, routine set_parameter, check_pred pred)
# else
(len, set_parameter, pred)
 register int len;
 routine set_parameter;
 check_pred pred;
# endif
{
# line 2506 "SemIntr.puma"
 {
  int i;
  {
# line 2508 "SemIntr.puma"
   set_parameter ("A1", true, IntentIn, pred, - 1);
# line 2509 "SemIntr.puma"
   set_parameter ("A2", true, IntentIn, pred, - 1);
# line 2511 "SemIntr.puma"

# line 2513 "SemIntr.puma"
 for (i=3; i <= len; i++)
         { char id[10];
           sprintf (id, "A%d", i);
           set_parameter (id, false, IntentIn, pred, -1);
         }
     
  }
   return;
 }

;
}

static void SetReductionParams
# if defined __STDC__ | defined __cplusplus
(register int dimrank, routine set_parameter, check_pred pred)
# else
(dimrank, set_parameter, pred)
 register int dimrank;
 routine set_parameter;
 check_pred pred;
# endif
{
  if (equalint (dimrank, 0)) {
# line 2531 "SemIntr.puma"
  {
# line 2533 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, pred, - 1);
# line 2534 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
# line 2535 "SemIntr.puma"
   set_parameter ("MASK", false, IntentIn, LogicalExpr, - 1);
  }
   return;

  }
# line 2538 "SemIntr.puma"
  {
# line 2540 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, pred, - 1);
# line 2541 "SemIntr.puma"
   set_parameter ("MASK", false, IntentIn, LogicalExpr, - 1);
# line 2542 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
  }
   return;

;
}

static void SetScanParams
# if defined __STDC__ | defined __cplusplus
(register tIdent name, routine set_parameter)
# else
(name, set_parameter)
 register tIdent name;
 routine set_parameter;
# endif
{
# line 2553 "SemIntr.puma"
  {
# line 2555 "SemIntr.puma"
   if (! (((name == IsIdent ("COPY_PREFIX")) || (name == IsIdent ("COPY_SUFFIX"))))) goto yyL1;
  {
# line 2559 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, Expr, - 1);
# line 2560 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
# line 2561 "SemIntr.puma"
   set_parameter ("SEGMENT", false, IntentIn, LogicalExpr, - 1);
  }
  }
   return;
yyL1:;

# line 2564 "SemIntr.puma"
  {
# line 2566 "SemIntr.puma"
   if (! (((name == IsIdent ("ALL_PREFIX")) || (name == IsIdent ("ALL_SUFFIX")) || (name == IsIdent ("ANY_PREFIX")) || (name == IsIdent ("ANY_SUFFIX")) || (name == IsIdent ("COUNT_PREFIX")) || (name == IsIdent ("COUNT_SUFFIX")) || (name == IsIdent ("PARITY_PREFIX")) || (name == IsIdent ("PARITY_SUFFIX"))))) goto yyL2;
  {
# line 2576 "SemIntr.puma"
   set_parameter ("MASK", true, IntentIn, LogicalExpr, - 1);
# line 2577 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
# line 2578 "SemIntr.puma"
   set_parameter ("SEGMENT", false, IntentIn, LogicalExpr, - 1);
# line 2579 "SemIntr.puma"
   set_parameter ("EXCLUSIVE", false, IntentIn, LogicalExpr, 0);
  }
  }
   return;
yyL2:;

# line 2582 "SemIntr.puma"
  {
# line 2584 "SemIntr.puma"
   if (! (((name == IsIdent ("IALL_PREFIX")) || (name == IsIdent ("IALL_SUFFIX")) || (name == IsIdent ("IANY_PREFIX")) || (name == IsIdent ("IANY_SUFFIX")) || (name == IsIdent ("IPARITY_PREFIX")) || (name == IsIdent ("IPARITY_SUFFIX"))))) goto yyL3;
  {
# line 2591 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, IntExpr, - 1);
# line 2592 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
# line 2593 "SemIntr.puma"
   set_parameter ("MASK", false, IntentIn, LogicalExpr, - 1);
# line 2594 "SemIntr.puma"
   set_parameter ("SEGMENT", false, IntentIn, LogicalExpr, - 1);
# line 2595 "SemIntr.puma"
   set_parameter ("EXCLUSIVE", false, IntentIn, LogicalExpr, 0);
  }
  }
   return;
yyL3:;

# line 2598 "SemIntr.puma"
  {
# line 2600 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, NumExpr, - 1);
# line 2601 "SemIntr.puma"
   set_parameter ("DIM", false, IntentIn, IntExpr, 0);
# line 2602 "SemIntr.puma"
   set_parameter ("MASK", false, IntentIn, LogicalExpr, - 1);
# line 2603 "SemIntr.puma"
   set_parameter ("SEGMENT", false, IntentIn, LogicalExpr, - 1);
# line 2604 "SemIntr.puma"
   set_parameter ("EXCLUSIVE", false, IntentIn, LogicalExpr, 0);
  }
   return;

;
}

static void SetScatterParams
# if defined __STDC__ | defined __cplusplus
(register int base_rank, routine set_parameter, check_pred pred)
# else
(base_rank, set_parameter, pred)
 register int base_rank;
 routine set_parameter;
 check_pred pred;
# endif
{
# line 2616 "SemIntr.puma"
 {
  int i;
  {
# line 2618 "SemIntr.puma"
   set_parameter ("ARRAY", true, IntentIn, pred, - 1);
# line 2619 "SemIntr.puma"
   set_parameter ("BASE", true, IntentIn, pred, - 1);
# line 2621 "SemIntr.puma"

# line 2623 "SemIntr.puma"
 for (i=1; i <= base_rank; i++)
         { char id[10];
           sprintf (id, "INDX%d", i);
           set_parameter (id, true, IntentIn, IntExpr, -1);
         }
     
# line 2629 "SemIntr.puma"
   set_parameter ("MASK", false, IntentIn, LogicalExpr, - 1);
  }
   return;
 }

;
}

void BeginSemIntr ()
{
}

void CloseSemIntr ()
{
}
