# include "SemExp.h"
# include "yySemExp.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 34 "SemExp.puma"


# define MODULE "SemExp"

# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "DefTable.h"

# include "Transform.h"
# include "ShowDefs.h"
# include "Expressions.h"    /* MakeConstant */

# include "SemCalling.h"    /*                  */
# include "SemPreds.h"      /*                  */
# include "SemIntr.h"      /*                  */
# include "Intrinsics.h"    /* NormalIntrinsicParams */
# include "Nesting.h"
# include "Rank.h"
# include "TreeOps.h"
# include "Objects.h"

# include "Types.h"     /* GetTypeZero      */



static void yyExit () { Exit (1); }

void (* SemExp_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemExp, routine %s failed\n", yyFunction);
 SemExp_Exit ();
}

void SemVariable ARGS((tTree var));
static void SemParentArray ARGS((tTree v, int * yyP1));
tTree SemExpression ARGS((tTree exp));
static void NormalIntrinsicParams ARGS((tIdent name, tTree params));
static void CheckRank ARGS((tTree exp));
static void CheckTypeExpression ARGS((tDefinitions complist, tTree explist));
tTree SemAssignment ARGS((tTree assign));
static tTree ClassifyBinExp ARGS((tTree exp, type_rec type, type_rec type1, type_rec type2));
static tTree ClassifyUnExp ARGS((tTree exp, type_rec type, type_rec type1));
static tTree ClassifyAssign ARGS((tTree assign, type_rec type_var, type_rec type_exp));
static tTree ClassifyTypeExp ARGS((tTree exp, type_rec type_var, type_rec type_exp));
static void CheckRankAssign ARGS((int rank1, int rank2));
static void CheckRankTypeAssign ARGS((int rank1, int rank2, tTree exp));
static void CheckRankBinExp ARGS((tTree exp, int rank1, int rank2));
static tTree ExpConvert ARGS((tTree exp, int kind, int size));
static tTree MakeCall ARGS((tIdent id, tTree exp, int size));
static void SetIntentInCall ARGS((tTree params));
static void SemConstant ARGS((tTree t));
static int EvalParameter ARGS((tIdent id, tDefinitions obj, int default_size));
void SemParameter ARGS((tTree param));
void SemIndexList ARGS((tTree t));
static void SemExpList ARGS((tTree t));
void SemParamList ARGS((tTree t));

void SemVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 76 "SemExp.puma"
  {
# line 77 "SemExp.puma"
   if (! ((var == NoTree))) goto yyL1;
  {
# line 78 "SemExp.puma"
   failure_protocol (MODULE, "SemVariable : no tree", var);
  }
  }
   return;
yyL1:;


  switch (var->Kind) {
  case kUSED_VAR:
# line 87 "SemExp.puma"
  {
# line 89 "SemExp.puma"
   SemVariable (var->USED_VAR.VARNAME);
# line 91 "SemExp.puma"
 if (IsCurrentLoopVar (var))
         var->Kind = kLOOP_VAR;
    
  }
   return;

  case kLOOP_VAR:
# line 96 "SemExp.puma"
  {
# line 98 "SemExp.puma"
   SemVariable (var->LOOP_VAR.LOOP_VARNAME);
  }
   return;

  case kDUMMY_VAR:
# line 101 "SemExp.puma"
   return;

  case kSELECTED_VAR:
# line 104 "SemExp.puma"
  {
# line 106 "SemExp.puma"
   SemVariable (var->SELECTED_VAR.SELEC_VAR);
# line 108 "SemExp.puma"
 

      if ((TreeRank(var->SELECTED_VAR.SELEC_VAR) > 0) && (VarRank (var->SELECTED_VAR.SELECTOR->REC_COMP.Object) > 0))
        { error_protocol ("more than one component has non-zero rank");
          tree_protocol ("indexed selected variable is ", var);
        }
    
  }
   return;

  case kSUBSTRING_VAR:
# line 117 "SemExp.puma"
  {
# line 119 "SemExp.puma"
   SemVariable (var->SUBSTRING_VAR.IND_VAR);
# line 121 "SemExp.puma"
 if (TreeRank(var->SUBSTRING_VAR.IND_VAR) != 0)
        { error_protocol ("rank of string variable > 0");
          tree_protocol ("string variable is ", var);
        }
    
# line 127 "SemExp.puma"
 var->SUBSTRING_VAR.IND_EXP = SemExpression (var->SUBSTRING_VAR.IND_EXP) ; 
  }
   return;

  case kINDEXED_VAR:
# line 132 "SemExp.puma"
 {
  int yyV1;
  {
# line 134 "SemExp.puma"
   SemVariable (var->INDEXED_VAR.IND_VAR);
# line 135 "SemExp.puma"
   SemIndexList (var->INDEXED_VAR.IND_EXPS);
# line 137 "SemExp.puma"
   SemParentArray (var->INDEXED_VAR.IND_VAR, & yyV1);
# line 139 "SemExp.puma"
 if (yyV1 != TreeListLength (var->INDEXED_VAR.IND_EXPS))

       { char msg[100];
         sprintf (msg, "illegal number of indexes : %d used, but rank = %d",
                        TreeListLength (var->INDEXED_VAR.IND_EXPS), yyV1);
         error_protocol (msg);
         tree_protocol ("indexed variable is ", var);
       }
    
  }
   return;
 }

  case kVAR_OBJ:
# line 150 "SemExp.puma"
  {
# line 152 "SemExp.puma"
   if (! ((var->VAR_OBJ.Object == NoObject))) goto yyL8;
  {
# line 154 "SemExp.puma"
   error_protocol ("No object for use of variable found");
# line 155 "SemExp.puma"
   tree_protocol ("Variable is ", var);
  }
  }
   return;
yyL8:;

# line 158 "SemExp.puma"
   return;

  }

# line 162 "SemExp.puma"
  {
# line 164 "SemExp.puma"
   failure_protocol (MODULE, "SemVariable", var);
  }
   return;

;
}

static void SemParentArray
# if defined __STDC__ | defined __cplusplus
(register tTree v, register int * yyP1)
# else
(v, yyP1)
 register tTree v;
 register int * yyP1;
# endif
{
  if (v->Kind == kUSED_VAR) {
# line 175 "SemExp.puma"
 {
  int rank;
  {
# line 177 "SemExp.puma"

# line 178 "SemExp.puma"
   rank = VarRank (v->USED_VAR.VARNAME->VAR_OBJ.Object);
  }
   * yyP1 = rank;
   return;
 }

  }
  if (v->Kind == kSELECTED_VAR) {
# line 181 "SemExp.puma"
 {
  int rank;
  {
# line 183 "SemExp.puma"
 if (TreeRank (v->SELECTED_VAR.SELEC_VAR) != 0)
        error_protocol ("array of indexed structure_components not allowed");
    
# line 187 "SemExp.puma"

# line 188 "SemExp.puma"
   rank = VarRank (v->SELECTED_VAR.SELECTOR->REC_COMP.Object);
  }
   * yyP1 = rank;
   return;
 }

  }
# line 191 "SemExp.puma"
  {
# line 193 "SemExp.puma"
   error_protocol ("variable cannot be indexed");
# line 194 "SemExp.puma"
   tree_protocol ("illegal variable is : ", v);
  }
   * yyP1 = 0;
   return;

;
}

tTree SemExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
# line 205 "SemExp.puma"
  {
# line 211 "SemExp.puma"
   if (! ((exp == NoTree))) goto yyL1;
  {
# line 212 "SemExp.puma"
   failure_protocol (MODULE, "SemExpression : no tree", exp);
  }
  }
   return mDUMMY_EXP ();
yyL1:;


  switch (exp->Kind) {
  case kDUMMY_EXP:
# line 216 "SemExp.puma"
   return exp;

  case kCONST_EXP:
# line 220 "SemExp.puma"
  {
# line 222 "SemExp.puma"
   SemConstant (exp->CONST_EXP.C);
  }
   return exp;

  case kARRAY_EXP:
# line 226 "SemExp.puma"
  {
# line 228 "SemExp.puma"
   SemExpList (exp->ARRAY_EXP.ELEMENTS);
  }
   return exp;

  case kSLICE_EXP:
# line 232 "SemExp.puma"
  {
# line 234 "SemExp.puma"
 exp->SLICE_EXP.START = SemExpression (exp->SLICE_EXP.START);
     exp->SLICE_EXP.STOP  = SemExpression (exp->SLICE_EXP.STOP);
     exp->SLICE_EXP.INC   = SemExpression (exp->SLICE_EXP.INC);

     if (!ScalarIntExpr (exp->SLICE_EXP.START))
        { error_protocol ("scalar integer expression for _:_ expected");
          tree_protocol ("illegal expression is : ", exp->SLICE_EXP.START);
        }
     if (!ScalarIntExpr (exp->SLICE_EXP.STOP))
        { error_protocol ("scalar integer expression for _:_ expected");
          tree_protocol ("illegal expression is : ", exp->SLICE_EXP.STOP);
        }
     if (!ScalarIntExpr (exp->SLICE_EXP.INC))
        { error_protocol ("scalar integer expression for _:_ expected");
          tree_protocol ("illegal expression is : ", exp->SLICE_EXP.INC);
        }
   
  }
   return exp;

  case kOP_EXP:
# line 254 "SemExp.puma"
 {
  type_rec type1;
  type_rec type2;
  type_rec type;
  {
# line 256 "SemExp.puma"
 exp->OP_EXP.OPND1 = SemExpression (exp->OP_EXP.OPND1);
     exp->OP_EXP.OPND2 = SemExpression (exp->OP_EXP.OPND2);
   
# line 260 "SemExp.puma"
   CheckRankBinExp (exp, TreeRank (exp->OP_EXP.OPND1), TreeRank (exp->OP_EXP.OPND2));
# line 262 "SemExp.puma"

# line 263 "SemExp.puma"

# line 264 "SemExp.puma"

# line 266 "SemExp.puma"
   GetExpType (exp->OP_EXP.OPND1, & type1);
# line 267 "SemExp.puma"
   GetExpType (exp->OP_EXP.OPND2, & type2);
# line 268 "SemExp.puma"
   GetOp2Type (exp->OP_EXP.EXP_OP, type1, type2, & type);
  }
  {
   return ClassifyBinExp (exp, type, type1, type2);
  }
 }

  case kOP1_EXP:
# line 273 "SemExp.puma"
 {
  type_rec type1;
  type_rec type;
  {
# line 275 "SemExp.puma"
 exp->OP1_EXP.OPND = SemExpression (exp->OP1_EXP.OPND); 
# line 277 "SemExp.puma"

# line 278 "SemExp.puma"

# line 280 "SemExp.puma"
   GetExpType (exp->OP1_EXP.OPND, & type1);
# line 281 "SemExp.puma"
   GetOp1Type (exp->OP1_EXP.EXP_OP1, type1, & type);
  }
  {
   return ClassifyUnExp (exp, type, type1);
  }
 }

  case kTYPE_EXP:
  if (exp->TYPE_EXP.ID->TYPE_OBJ.Object->Kind == kTypeObject) {
# line 286 "SemExp.puma"
  {
# line 288 "SemExp.puma"
   SemExpList (exp->TYPE_EXP.ELEMENTS);
# line 292 "SemExp.puma"
   CheckTypeExpression (exp->TYPE_EXP.ID->TYPE_OBJ.Object->TypeObject.Components, exp->TYPE_EXP.ELEMENTS);
  }
   return exp;

  }
  break;
  case kVAR_EXP:
# line 297 "SemExp.puma"
  {
# line 299 "SemExp.puma"
   SemVariable (exp->VAR_EXP.V);
  }
   return exp;

  case kDO_EXP:
# line 303 "SemExp.puma"
  {
# line 305 "SemExp.puma"
   IncLoopNesting (exp);
# line 307 "SemExp.puma"
   SemVariable (exp->DO_EXP.DO_ID);
# line 309 "SemExp.puma"
 if (!ScalarIntVariable (exp->DO_EXP.DO_ID))
        error_protocol ("not scalar integer variable in implied do");

     exp->DO_EXP.RANGE = SemExpression (exp->DO_EXP.RANGE);   
   
# line 315 "SemExp.puma"
   SemExpList (exp->DO_EXP.BODY);
# line 316 "SemExp.puma"
   DecLoopNesting (exp);
  }
   return exp;

  case kFUNC_CALL_EXP:
# line 321 "SemExp.puma"
  {
# line 323 "SemExp.puma"
   if (! ((IsIntrCall (exp)))) goto yyL11;
  {
# line 325 "SemExp.puma"
   SemParamList (exp->FUNC_CALL_EXP.FUNC_PARAMS);
# line 329 "SemExp.puma"
   SemCalling (exp);
# line 331 "SemExp.puma"
   NormalIntrinsicParams (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, exp->FUNC_CALL_EXP.FUNC_PARAMS);
# line 333 "SemExp.puma"
   SemIntrinsicFunction (exp, exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, exp->FUNC_CALL_EXP.FUNC_PARAMS);
# line 335 "SemExp.puma"
   CheckRank (exp);
  }
  }
   return exp;
yyL11:;

# line 340 "SemExp.puma"
  {
# line 344 "SemExp.puma"
   SemParamList (exp->FUNC_CALL_EXP.FUNC_PARAMS);
# line 346 "SemExp.puma"
 exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object = IdentifyGenericRoutine (exp, exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object); 
# line 348 "SemExp.puma"
   SemCalling (exp);
# line 350 "SemExp.puma"
   CheckRank (exp);
  }
   return exp;

  }

# line 355 "SemExp.puma"
  {
# line 357 "SemExp.puma"
   failure_protocol (MODULE, "SemExpression", exp);
  }
   return NoTree;

}

static void NormalIntrinsicParams
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 377 "SemExp.puma"
  {
# line 379 "SemExp.puma"
   if (! (((name == MakeIdent ("ALL", 3)) || (name == MakeIdent ("ANY", 3)) || (name == MakeIdent ("COUNT", 5))))) goto yyL1;
  {
# line 383 "SemExp.puma"
 params->BTP_LIST.Next->BTP_LIST.Next = mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), params->BTP_LIST.Next->BTP_LIST.Next); 
  }
  }
   return;
yyL1:;

  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 386 "SemExp.puma"
 {
  tTree help;
  {
# line 388 "SemExp.puma"
   if (! ((IntrFuncRed (name) || IntrFuncLocRed (name)))) goto yyL2;
  {
# line 389 "SemExp.puma"
   if (! ((TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem) > 0))) goto yyL2;
  {
# line 391 "SemExp.puma"

# line 392 "SemExp.puma"
 help = params->BTP_LIST.Next->BTP_LIST.Elem; params->BTP_LIST.Next->BTP_LIST.Elem = params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem; params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem = help; 
  }
  }
  }
   return;
 }
yyL2:;

  }
  }
  }
;
}

static void CheckRank
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
# line 405 "SemExp.puma"
  {
# line 407 "SemExp.puma"
   if (! ((TreeRank (exp) >= 0))) goto yyL1;
  }
   return;
yyL1:;

# line 410 "SemExp.puma"
  {
# line 412 "SemExp.puma"
 char msg[100];
     char f_name[MAXID_LENGTH];
     GetString (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, f_name);
     if (IsIntrCall (exp))
        sprintf (msg, "rank error for intrinsic function %s", f_name);
      else
        sprintf (msg, "rank error for function call of %s", f_name);
     error_protocol (msg);
   
  }
   return;

  }
;
}

static void CheckTypeExpression
# if defined __STDC__ | defined __cplusplus
(register tDefinitions complist, register tTree explist)
# else
(complist, explist)
 register tDefinitions complist;
 register tTree explist;
# endif
{
  if (complist->Kind == kENTRY_EMPTY) {
  if (explist->Kind == kBTE_LIST) {
# line 431 "SemExp.puma"
  {
# line 433 "SemExp.puma"
   error_protocol ("too many components in type expression");
  }
   return;

  }
  if (explist->Kind == kBTE_EMPTY) {
# line 436 "SemExp.puma"
   return;

  }
  }
  if (complist->Kind == kENTRY_LIST) {
  if (explist->Kind == kBTE_EMPTY) {
# line 439 "SemExp.puma"
  {
# line 441 "SemExp.puma"
   error_protocol ("not enough components in type expression");
  }
   return;

  }
  if (explist->Kind == kBTE_LIST) {
# line 444 "SemExp.puma"
 {
  type_rec type1;
  type_rec type2;
  {
# line 446 "SemExp.puma"
   CheckRankTypeAssign (VarRank (complist->ENTRY_LIST.Elem), TreeRank (explist->BTE_LIST.Elem), explist->BTE_LIST.Elem);
# line 448 "SemExp.puma"

# line 449 "SemExp.puma"

# line 451 "SemExp.puma"
   GetTypeRecord (GetBaseType (GetObjectType (complist->ENTRY_LIST.Elem)), & type1);
# line 452 "SemExp.puma"
   GetExpType (explist->BTE_LIST.Elem, & type2);
# line 454 "SemExp.puma"
 explist->BTE_LIST.Elem = ClassifyTypeExp (explist->BTE_LIST.Elem, type1, type2); 
# line 456 "SemExp.puma"
   CheckTypeExpression (complist->ENTRY_LIST.Next, explist->BTE_LIST.Next);
  }
   return;
 }

  }
  }
# line 459 "SemExp.puma"
  {
# line 460 "SemExp.puma"
   failure_protocol (MODULE, "ChecktTypeExpression", explist);
  }
   return;

;
}

tTree SemAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree assign)
# else
(assign)
 register tTree assign;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
# line 471 "SemExp.puma"
 {
  type_rec type1;
  type_rec type2;
  {
# line 473 "SemExp.puma"
   SemVariable (assign->ASSIGN_STMT.ASSIGN_VAR);
# line 475 "SemExp.puma"
 if (!IsLegalOutVar (assign->ASSIGN_STMT.ASSIGN_VAR))
        error_protocol (type_error_msg);

     assign->ASSIGN_STMT.ASSIGN_EXP = SemExpression (assign->ASSIGN_STMT.ASSIGN_EXP);

   
# line 482 "SemExp.puma"
   CheckRankAssign (TreeRank (assign->ASSIGN_STMT.ASSIGN_VAR), TreeRank (assign->ASSIGN_STMT.ASSIGN_EXP));
# line 484 "SemExp.puma"

# line 485 "SemExp.puma"

# line 487 "SemExp.puma"
   GetExpType (assign->ASSIGN_STMT.ASSIGN_VAR, & type1);
# line 488 "SemExp.puma"
   GetExpType (assign->ASSIGN_STMT.ASSIGN_EXP, & type2);
  }
  {
   return ClassifyAssign (assign, type1, type2);
  }
 }

  }
# line 493 "SemExp.puma"
  {
# line 494 "SemExp.puma"
   failure_protocol (MODULE, "SemAssignment", assign);
  }
   return assign;

}

static tTree ClassifyBinExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, type_rec type, type_rec type1, type_rec type2)
# else
(exp, type, type1, type2)
 register tTree exp;
 type_rec type;
 type_rec type1;
 type_rec type2;
# endif
{
# line 512 "SemExp.puma"
  {
# line 514 "SemExp.puma"
   if (! ((type1 . type_kind == kDUMMY_TYPE))) goto yyL1;
  }
   return exp;
yyL1:;

# line 518 "SemExp.puma"
  {
# line 520 "SemExp.puma"
   if (! ((type2 . type_kind == kDUMMY_TYPE))) goto yyL2;
  }
   return exp;
yyL2:;

  if (exp->Kind == kOP_EXP) {
# line 524 "SemExp.puma"
  {
# line 528 "SemExp.puma"
   if (! ((type . type_kind != kDUMMY_TYPE))) goto yyL3;
  {
# line 529 "SemExp.puma"
   if (! ((SameTypeRecord (type1, type2)))) goto yyL3;
  }
  }
   return exp;
yyL3:;

# line 534 "SemExp.puma"
  {
# line 538 "SemExp.puma"
   if (! ((type . type_kind != kDUMMY_TYPE))) goto yyL4;
  {
# line 539 "SemExp.puma"
   if (! ((IsSubType (type1, type2)))) goto yyL4;
  {
# line 541 "SemExp.puma"
 exp->OP_EXP.OPND1 = ExpConvert (exp->OP_EXP.OPND1, type2.type_kind, type2.type_size); 
  }
  }
  }
   return exp;
yyL4:;

# line 546 "SemExp.puma"
  {
# line 550 "SemExp.puma"
   if (! ((type . type_kind != kDUMMY_TYPE))) goto yyL5;
  {
# line 551 "SemExp.puma"
   if (! ((IsSubType (type2, type1)))) goto yyL5;
  {
# line 553 "SemExp.puma"
 exp->OP_EXP.OPND2 = ExpConvert (exp->OP_EXP.OPND2, type1.type_kind, type1.type_size); 
  }
  }
  }
   return exp;
yyL5:;

# line 558 "SemExp.puma"
 {
  tTree new_exp;
  {
# line 562 "SemExp.puma"

# line 564 "SemExp.puma"
   new_exp = IdentifyBinaryRoutine (exp);
# line 566 "SemExp.puma"
   if (! ((new_exp != NoTree))) goto yyL6;
  }
  {
   return new_exp;
  }
 }
yyL6:;

# line 571 "SemExp.puma"
  {
# line 573 "SemExp.puma"
 char str1[30], str2[30], msg[100];
     OutType (str1, type1);
     OutType (str2, type2);
     sprintf (msg, "illegal operand types (%s,%s) for binary operation", 
              str1, str2);
     error_protocol (msg);
     tree_protocol ("binary expression is : ", exp);

   
  }
   return exp;

  }
 yyAbort ("ClassifyBinExp");
}

static tTree ClassifyUnExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, type_rec type, type_rec type1)
# else
(exp, type, type1)
 register tTree exp;
 type_rec type;
 type_rec type1;
# endif
{
# line 595 "SemExp.puma"
  {
# line 597 "SemExp.puma"
   if (! ((type1 . type_kind == kDUMMY_TYPE))) goto yyL1;
  }
   return exp;
yyL1:;

  if (exp->Kind == kOP1_EXP) {
# line 601 "SemExp.puma"
  {
# line 605 "SemExp.puma"
   if (! ((type . type_kind != kDUMMY_TYPE))) goto yyL2;
  }
   return exp;
yyL2:;

# line 609 "SemExp.puma"
 {
  tTree new_exp;
  {
# line 613 "SemExp.puma"

# line 615 "SemExp.puma"
   new_exp = IdentifyUnaryRoutine (exp);
# line 617 "SemExp.puma"
   if (! ((new_exp != NoTree))) goto yyL3;
  }
  {
   return new_exp;
  }
 }
yyL3:;

# line 622 "SemExp.puma"
  {
# line 624 "SemExp.puma"
   error_protocol ("illegal operand for unary operation");
# line 625 "SemExp.puma"
   tree_protocol ("unary expression is : ", exp);
  }
   return exp;

  }
# line 629 "SemExp.puma"
  {
# line 630 "SemExp.puma"
   failure_protocol (MODULE, "UnaryCheck", exp);
  }
   return exp;

}

static tTree ClassifyAssign
# if defined __STDC__ | defined __cplusplus
(register tTree assign, type_rec type_var, type_rec type_exp)
# else
(assign, type_var, type_exp)
 register tTree assign;
 type_rec type_var;
 type_rec type_exp;
# endif
{
# line 648 "SemExp.puma"
  {
# line 650 "SemExp.puma"
   if (! ((type_var . type_kind == kDUMMY_TYPE))) goto yyL1;
  }
   return assign;
yyL1:;

# line 655 "SemExp.puma"
  {
# line 657 "SemExp.puma"
   if (! ((type_exp . type_kind == kDUMMY_TYPE))) goto yyL2;
  }
   return assign;
yyL2:;

# line 662 "SemExp.puma"
  {
# line 666 "SemExp.puma"
   if (! ((LegalAssignmentTypes (type_var, type_exp)))) goto yyL3;
  {
# line 668 "SemExp.puma"
   if (! ((SameTypeRecord (type_var, type_exp)))) goto yyL3;
  }
  }
   return assign;
yyL3:;

  if (assign->Kind == kASSIGN_STMT) {
# line 673 "SemExp.puma"
  {
# line 677 "SemExp.puma"
   if (! ((LegalAssignmentTypes (type_var, type_exp)))) goto yyL4;
  {
# line 679 "SemExp.puma"
 assign->ASSIGN_STMT.ASSIGN_EXP = ExpConvert (assign->ASSIGN_STMT.ASSIGN_EXP, type_var.type_kind, type_var.type_size); 
  }
  }
   return assign;
yyL4:;

# line 684 "SemExp.puma"
 {
  tTree new_assign;
  {
# line 688 "SemExp.puma"

# line 690 "SemExp.puma"
   new_assign = IdentifyAssignRoutine (assign);
# line 692 "SemExp.puma"
   if (! ((new_assign != NoTree))) goto yyL5;
  }
  {
   return new_assign;
  }
 }
yyL5:;

# line 697 "SemExp.puma"
  {
# line 699 "SemExp.puma"
 char str1[30], str2[30], msg[100];
     OutType (str1, type_var);
     OutType (str2, type_exp);
     sprintf (msg, "illegal types (%s=%s) for assignment", str1, str2);
     error_protocol (msg);
   
  }
   return assign;

  }
# line 709 "SemExp.puma"
  {
# line 711 "SemExp.puma"
   failure_protocol (MODULE, "ClassifyAssign", assign);
  }
   return assign;

}

static tTree ClassifyTypeExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, type_rec type_var, type_rec type_exp)
# else
(exp, type_var, type_exp)
 register tTree exp;
 type_rec type_var;
 type_rec type_exp;
# endif
{
# line 728 "SemExp.puma"
  {
# line 730 "SemExp.puma"
   if (! ((type_var . type_kind == kDUMMY_TYPE))) goto yyL1;
  }
   return exp;
yyL1:;

# line 734 "SemExp.puma"
  {
# line 736 "SemExp.puma"
   if (! ((type_exp . type_kind == kDUMMY_TYPE))) goto yyL2;
  }
   return exp;
yyL2:;

# line 740 "SemExp.puma"
  {
# line 744 "SemExp.puma"
   if (! ((LegalAssignmentTypes (type_var, type_exp)))) goto yyL3;
  {
# line 746 "SemExp.puma"
   if (! ((type_var . type_kind == type_exp . type_kind))) goto yyL3;
  {
# line 747 "SemExp.puma"
   if (! ((type_var . type_size == type_exp . type_size))) goto yyL3;
  }
  }
  }
   return exp;
yyL3:;

# line 752 "SemExp.puma"
  {
# line 756 "SemExp.puma"
   if (! ((LegalAssignmentTypes (type_var, type_exp)))) goto yyL4;
  }
   return ExpConvert (exp, type_var . type_kind, type_var . type_size);
yyL4:;

# line 761 "SemExp.puma"
  {
# line 763 "SemExp.puma"
 char str1[30], str2[30], msg[100];
     OutType (str1, type_var);
     OutType (str2, type_exp);
     sprintf (msg, "illegal type (%s expected, not %s) within type exp",
                    str1, str2);
     error_protocol (msg);
     tree_protocol ("illegal exp is ", exp);
   
  }
   return exp;

}

static void CheckRankAssign
# if defined __STDC__ | defined __cplusplus
(register int rank1, register int rank2)
# else
(rank1, rank2)
 register int rank1;
 register int rank2;
# endif
{
# line 786 "SemExp.puma"
 {
  bool okay;
  {
# line 788 "SemExp.puma"

# line 790 "SemExp.puma"
   if (! ((rank1 >= 0))) goto yyL1;
  {
# line 791 "SemExp.puma"
   if (! ((rank2 >= 0))) goto yyL1;
  {
# line 793 "SemExp.puma"
   okay = (rank2 == 0) || (rank1 == rank2);
# line 795 "SemExp.puma"
 if (!okay)
       { char msg[100];
         sprintf (msg, "ASSIGN rank mismatch, lhs = %d, rhs = %d",
                        rank1, rank2);
         error_protocol (msg);
       }
   
  }
  }
  }
   return;
 }
yyL1:;

;
}

static void CheckRankTypeAssign
# if defined __STDC__ | defined __cplusplus
(register int rank1, register int rank2, register tTree exp)
# else
(rank1, rank2, exp)
 register int rank1;
 register int rank2;
 register tTree exp;
# endif
{
# line 806 "SemExp.puma"
 {
  bool okay;
  {
# line 808 "SemExp.puma"

# line 810 "SemExp.puma"
   if (! ((rank1 >= 0))) goto yyL1;
  {
# line 811 "SemExp.puma"
   if (! ((rank2 >= 0))) goto yyL1;
  {
# line 813 "SemExp.puma"
   okay = (rank2 == 0) || (rank1 == rank2);
# line 815 "SemExp.puma"
 if (!okay)
       { char msg[100];
         sprintf (msg, "rank error in type exp, rank = %d should be %d",
                        rank2, rank1);
         error_protocol (msg);
         tree_error_protocol ("illegal component is ", exp);
       }
   
  }
  }
  }
   return;
 }
yyL1:;

;
}

static void CheckRankBinExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int rank1, register int rank2)
# else
(exp, rank1, rank2)
 register tTree exp;
 register int rank1;
 register int rank2;
# endif
{
# line 827 "SemExp.puma"
 {
  bool okay;
  {
# line 829 "SemExp.puma"

# line 831 "SemExp.puma"
   if (! ((rank1 >= 0))) goto yyL1;
  {
# line 832 "SemExp.puma"
   if (! ((rank2 >= 0))) goto yyL1;
  {
# line 834 "SemExp.puma"
   okay = (rank1 == 0) || (rank2 == 0) || (rank1 == rank2);
# line 836 "SemExp.puma"
 if (!okay)
       { char msg[100];
         sprintf (msg, "binary exp rank mismatch, e1 = %d, e2 = %d",
                        rank1, rank2);
         error_protocol (msg);
         tree_protocol ("expression is : ", exp);
       }
   
# line 844 "SemExp.puma"
   if (! ((okay))) goto yyL1;
  }
  }
  }
   return;
 }
yyL1:;

;
}

static tTree ExpConvert
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int kind, register int size)
# else
(exp, kind, size)
 register tTree exp;
 register int kind;
 register int size;
# endif
{
# line 860 "SemExp.puma"
  {
# line 862 "SemExp.puma"
   if (! ((kind == kREAL_TYPE))) goto yyL1;
  {
# line 863 "SemExp.puma"
   if (! ((size == default_real_size))) goto yyL1;
  }
  }
   return MakeCall (MakeIdent ("REAL", 4), exp, 0);
yyL1:;

# line 868 "SemExp.puma"
  {
# line 870 "SemExp.puma"
   if (! ((kind == kREAL_TYPE))) goto yyL2;
  {
# line 871 "SemExp.puma"
   if (! ((size == 2 * default_real_size))) goto yyL2;
  }
  }
   return MakeCall (MakeIdent ("DBLE", 4), exp, - 1);
yyL2:;

# line 876 "SemExp.puma"
  {
# line 878 "SemExp.puma"
   if (! ((kind == kREAL_TYPE))) goto yyL3;
  }
   return MakeCall (MakeIdent ("REAL", 4), exp, size);
yyL3:;

# line 883 "SemExp.puma"
  {
# line 885 "SemExp.puma"
   if (! ((kind == kINTEGER_TYPE))) goto yyL4;
  {
# line 886 "SemExp.puma"
   if (! ((size == default_int_size))) goto yyL4;
  }
  }
   return MakeCall (MakeIdent ("INT", 3), exp, 0);
yyL4:;

# line 891 "SemExp.puma"
  {
# line 893 "SemExp.puma"
   if (! ((kind == kINTEGER_TYPE))) goto yyL5;
  }
   return MakeCall (MakeIdent ("INT", 3), exp, size);
yyL5:;

# line 897 "SemExp.puma"
  {
# line 899 "SemExp.puma"
   if (! ((kind == kCOMPLEX_TYPE))) goto yyL6;
  {
# line 900 "SemExp.puma"
   if (! ((size == 2 * default_real_size))) goto yyL6;
  }
  }
   return MakeCall (MakeIdent ("CMPLX", 5), exp, 0);
yyL6:;

# line 905 "SemExp.puma"
  {
# line 907 "SemExp.puma"
   if (! ((kind == kCOMPLEX_TYPE))) goto yyL7;
  {
# line 908 "SemExp.puma"
   if (! ((size == 4 * default_real_size))) goto yyL7;
  }
  }
   return MakeCall (MakeIdent ("DCMPLX", 6), exp, 0);
yyL7:;

# line 913 "SemExp.puma"
  {
# line 915 "SemExp.puma"
 char str1[30], msg[100];
     type_rec t;
     t.type_kind = kind;
     t.type_size = size;
     OutType (str1, t);
     sprintf (msg, "illegal type conversion (%s)", str1);
     error_protocol (msg);
   
  }
   return exp;

}

static tTree MakeCall
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree exp, register int size)
# else
(id, exp, size)
 register tIdent id;
 register tTree exp;
 register int size;
# endif
{
# line 933 "SemExp.puma"
 {
  tTree call;
  tTree params;
  {
# line 935 "SemExp.puma"

# line 936 "SemExp.puma"

# line 938 "SemExp.puma"
 call = mPROC_OBJ (id);
     call->PROC_OBJ.Object = GetIntrinsicObject (id);
     params = mBTP_EMPTY ();
     if (size == 0)
        params = mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), params);
      else if (size > 0)
        params = mBTP_LIST (ExpToVarParam (MakeConstant (size)), params);
     params = mBTP_LIST (ExpToVarParam (exp), params);
     SetIntentInCall (params);
     call = mFUNC_CALL_EXP (call, params);
   
  }
  {
   return call;
  }
 }

}

static void SetIntentInCall
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 955 "SemExp.puma"
  {
# line 957 "SemExp.puma"
 params->BTP_LIST.Elem->VAR_PARAM.intent = IntentIn; 
  }
   return;

  }
  }
# line 960 "SemExp.puma"
  {
# line 961 "SemExp.puma"
   failure_protocol (MODULE, "SetIntentInCall", params);
  }
   return;

;
}

static void SemConstant
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kREAL_CONSTANT) {
# line 972 "SemExp.puma"
  {
# line 974 "SemExp.puma"
   if (! ((t->REAL_CONSTANT.kind >= 0))) goto yyL1;
  }
   return;
yyL1:;

# line 977 "SemExp.puma"
  {
# line 979 "SemExp.puma"
   if (! (((- t->REAL_CONSTANT.kind) == DefaultId ()))) goto yyL2;
  {
# line 981 "SemExp.puma"
 t->REAL_CONSTANT.kind = default_real_size; 
  }
  }
   return;
yyL2:;

# line 984 "SemExp.puma"
  {
# line 986 "SemExp.puma"
   t->REAL_CONSTANT.kind = EvalParameter (- t->REAL_CONSTANT.kind, GetGlobalObject (- t->REAL_CONSTANT.kind), default_real_size);
  }
   return;

  }
;
}

static int EvalParameter
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tDefinitions obj, register int default_size)
# else
(id, obj, default_size)
 register tIdent id;
 register tDefinitions obj;
 register int default_size;
# endif
{
# line 991 "SemExp.puma"

char msg[100], string[100];

# line 995 "SemExp.puma"
  {
# line 997 "SemExp.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 999 "SemExp.puma"
 GetString (id, string);
     sprintf (msg, "unknown kind identifier %s in constant", string);
     error_protocol (msg);
   
  }
  }
   return default_size;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarParameter) {
# line 1006 "SemExp.puma"
 {
  bool found;
  int val;
  {
# line 1008 "SemExp.puma"

# line 1009 "SemExp.puma"

# line 1011 "SemExp.puma"
   GetIntConstValue (obj->VarObject.Kind->VarParameter.Val, & found, & val);
# line 1013 "SemExp.puma"
 if (!found)
      { val = default_size;
        GetString (id, string);
        sprintf (msg, "kind identifier %s not known at compile time", string);
        error_protocol (msg);
        tree_protocol ("kind expression is : ", obj->VarObject.Kind->VarParameter.Val);
      }
     else if (val < 0)
      { GetString (id, string);
        sprintf (msg, "kind %s not supported", string);
        error_protocol (msg);
        val = default_size;
      }
   
  }
  {
   return val;
  }
 }

  }
  }
# line 1030 "SemExp.puma"
  {
# line 1032 "SemExp.puma"
 GetString (id, string);
     sprintf (msg, "kind identifier %s is not parameter", string);
     error_protocol (msg);
   
  }
   return default_size;

}

void SemParameter
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
# line 1047 "SemExp.puma"
  {
# line 1049 "SemExp.puma"
 param->VAR_PARAM.V->ADDR.E = SemExpression (param->VAR_PARAM.V->ADDR.E); 
  }
   return;

  }
# line 1052 "SemExp.puma"
  {
# line 1054 "SemExp.puma"
   SemVariable (param->VAR_PARAM.V);
  }
   return;

  }
  if (param->Kind == kNO_PARAM) {
# line 1057 "SemExp.puma"
   return;

  }
  if (param->Kind == kNAMED_PARAM) {
# line 1060 "SemExp.puma"
  {
# line 1062 "SemExp.puma"
   SemParameter (param->NAMED_PARAM.VAL);
  }
   return;

  }
  if (param->Kind == kFUNC_PARAM) {
# line 1065 "SemExp.puma"
   return;

  }
  if (param->Kind == kPROC_PARAM) {
# line 1068 "SemExp.puma"
   return;

  }
# line 1071 "SemExp.puma"
  {
# line 1072 "SemExp.puma"
   failure_protocol (MODULE, "SemParameter", param);
  }
   return;

;
}

void SemIndexList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_LIST) {
# line 1092 "SemExp.puma"
  {
# line 1094 "SemExp.puma"
 t->BTE_LIST.Elem = SemExpression (t->BTE_LIST.Elem);

     if (!IntExpr (t->BTE_LIST.Elem))
        { error_protocol ("subscript not integer");
          tree_protocol ("subscript : ", t->BTE_LIST.Elem);
        }
     if (TreeRank (t->BTE_LIST.Elem) > 1)
        { error_protocol ("vector-subscript must have rank 1");
          tree_protocol ("subscript : ", t->BTE_LIST.Elem);
        }
   
# line 1105 "SemExp.puma"
   SemIndexList (t->BTE_LIST.Next);
  }
   return;

  }
  if (t->Kind == kBTE_EMPTY) {
# line 1108 "SemExp.puma"
   return;

  }
# line 1111 "SemExp.puma"
  {
# line 1112 "SemExp.puma"
   failure_protocol (MODULE, "SemIndexList", t);
  }
   return;

;
}

static void SemExpList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_LIST) {
# line 1125 "SemExp.puma"
  {
# line 1127 "SemExp.puma"
 t->BTE_LIST.Elem = SemExpression (t->BTE_LIST.Elem); 
# line 1128 "SemExp.puma"
   SemExpList (t->BTE_LIST.Next);
  }
   return;

  }
  if (t->Kind == kBTE_EMPTY) {
# line 1131 "SemExp.puma"
   return;

  }
# line 1134 "SemExp.puma"
  {
# line 1135 "SemExp.puma"
   failure_protocol (MODULE, "SemExpList", t);
  }
   return;

;
}

void SemParamList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
# line 1146 "SemExp.puma"
  {
# line 1148 "SemExp.puma"
   SemParameter (t->BTP_LIST.Elem);
# line 1149 "SemExp.puma"
   SemParamList (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->Kind == kBTP_EMPTY) {
# line 1152 "SemExp.puma"
   return;

  }
# line 1155 "SemExp.puma"
  {
# line 1156 "SemExp.puma"
   failure_protocol (MODULE, "SemParamList", t);
  }
   return;

;
}

void BeginSemExp ()
{
}

void CloseSemExp ()
{
}
