# include "SemDecls.h"
# include "yySemDecls.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 37 "SemDecls.puma"

# include "Idents.h"
# include "StringMem.h"
# include "Types.h"
# include "protocol.h"

# include "DefTable.h"
# include "Objects.h"

# include "TreeOps.h"
# include "Rank.h"
# include "SemExp.h"         /* import SemExp            */
# include "Common.h"         /* import CheckCommonBlock  */
# include "Nesting.h"
# include "Expressions.h"
# include "Semantic.h"
# include "SemPreds.h"

# define MODULE "SemDecls"



static void yyExit () { Exit (1); }

void (* SemDecls_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemDecls, routine %s failed\n", yyFunction);
 SemDecls_Exit ();
}

void SemDeclarations ARGS((tTree t, tTree current_unit));
static void SemInterface ARGS((tTree items));
void SemDefinitions ARGS((tDefinitions t));
static void SemDefinitions1 ARGS((tDefinitions t));
static void SemDefinitions2 ARGS((tDefinitions t));
static void SemObjectType ARGS((tDefinitions o));
static void CorrectType ARGS((tIdent id, tTree t));
static int GetSize ARGS((tTree kind));
static void CheckKindValue ARGS((tTree type, int size));
static void EvaluateKindParam ARGS((tTree type));
static tTree ComputeSize ARGS((tTree kind, int default_size));
static void GetArrayKind ARGS((tTree t, int * yyP2, int * yyP1));
static int TypeCombination ARGS((int kind1, int kind2));
static bool CheckArrayKind ARGS((tTree type, tDefinitions desc));

void SemDeclarations
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree current_unit)
# else
(t, current_unit)
 register tTree t;
 register tTree current_unit;
# endif
{

  switch (t->Kind) {
  case kDECL_EMPTY:
# line 71 "SemDecls.puma"
   return;

  case kDECL_LIST:
# line 74 "SemDecls.puma"
  {
# line 76 "SemDecls.puma"
   set_protocol_stmt (t->DECL_LIST.Elem);
# line 78 "SemDecls.puma"
   SemDeclarations (t->DECL_LIST.Elem, current_unit);
# line 79 "SemDecls.puma"
   SemDeclarations (t->DECL_LIST.Next, current_unit);
  }
   return;

  case kVAR_DECL:
# line 88 "SemDecls.puma"
   return;

  case kTYPE_DECL:
# line 93 "SemDecls.puma"
   return;

  case kTEMPLATE_DECL:
# line 98 "SemDecls.puma"
   return;

  case kPROCESSORS_DECL:
# line 103 "SemDecls.puma"
   return;

  case kDIMENSION_DECL:
# line 108 "SemDecls.puma"
  {
# line 110 "SemDecls.puma"
   error_protocol ("there should be no longer any DIMENSION_DECL");
  }
   return;

  case kPARAMETER_DECL:
# line 113 "SemDecls.puma"
   return;

  case kCOMMON_DECL:
# line 118 "SemDecls.puma"
 {
  bool is_main;
  {
# line 122 "SemDecls.puma"

# line 124 "SemDecls.puma"
   is_main = (current_unit -> Kind == kPROGRAM_DECL);
# line 126 "SemDecls.puma"
   CheckCommonBlock (t, is_main);
  }
   return;
 }

  case kNAMELIST_DECL:
# line 129 "SemDecls.puma"
   return;

  case kEQV_DECL:
# line 133 "SemDecls.puma"
   return;

  case kDATA_DECL:
# line 137 "SemDecls.puma"
   return;

  case kSAVE_DECL:
# line 140 "SemDecls.puma"
   return;

  case kHPF_SEQUENCE_DECL:
# line 144 "SemDecls.puma"
   return;

  case kNOSEQUENCE_DECL:
# line 147 "SemDecls.puma"
   return;

  case kEXTERNAL_DECL:
# line 150 "SemDecls.puma"
   return;

  case kINTRINSIC_DECL:
# line 153 "SemDecls.puma"
   return;

  case kINTENT_DECL:
# line 156 "SemDecls.puma"
   return;

  case kPUBLIC_DECL:
# line 159 "SemDecls.puma"
   return;

  case kPRIVATE_DECL:
# line 162 "SemDecls.puma"
   return;

  case kALLOCATABLE_DECL:
# line 165 "SemDecls.puma"
   return;

  case kPOINTER_DECL:
# line 168 "SemDecls.puma"
   return;

  case kTARGET_DECL:
# line 171 "SemDecls.puma"
   return;

  case kIMPLICIT_DECL:
# line 174 "SemDecls.puma"
   return;

  case kDISTRIBUTE_DECL:
# line 179 "SemDecls.puma"
   return;

  case kRANGE_DECL:
# line 182 "SemDecls.puma"
   return;

  case kOPTIONAL_DECL:
# line 185 "SemDecls.puma"
   return;

  case kMAP_DECL:
# line 188 "SemDecls.puma"
   return;

  case kSHARED_DECL:
# line 191 "SemDecls.puma"
   return;

  case kOVERLAP_DECL:
# line 194 "SemDecls.puma"
   return;

  case kTRACE_DECL:
# line 197 "SemDecls.puma"
   return;

  case kTREE_DECL:
# line 200 "SemDecls.puma"
   return;

  case kPASS_BY_DECL:
# line 203 "SemDecls.puma"
   return;

  case kLAYOUT_DECL:
# line 206 "SemDecls.puma"
   return;

  case kDYNAMIC_DECL:
# line 209 "SemDecls.puma"
   return;

  case kINHERIT_DECL:
# line 212 "SemDecls.puma"
   return;

  case kALIGN_DECL:
# line 217 "SemDecls.puma"
   return;

  case kSTMT_FUNC_DECL:
# line 220 "SemDecls.puma"
   return;

  case kINTERFACE_DECL:
  if (t->INTERFACE_DECL.SPEC->Kind == kNO_GENERIC_SPEC) {
# line 224 "SemDecls.puma"
  {
# line 226 "SemDecls.puma"
   SemInterface (t->INTERFACE_DECL.ITEMS);
  }
   return;

  }
# line 229 "SemDecls.puma"
 {
  tDefinitions Obj;
  {
# line 231 "SemDecls.puma"

# line 233 "SemDecls.puma"
   Obj = GetLocalObject (GetGenericId (t->INTERFACE_DECL.SPEC));
# line 235 "SemDecls.puma"
   OpenScope (Obj->GenericObject.Interfaces);
# line 236 "SemDecls.puma"
   SemInterface (t->INTERFACE_DECL.ITEMS);
# line 237 "SemDecls.puma"
   CloseScope ();
  }
   return;
 }

  case kUSE_DECL:
# line 262 "SemDecls.puma"
   return;

  case kONLY_USE_DECL:
# line 265 "SemDecls.puma"
   return;

  case kFORMAT_DECL:
# line 268 "SemDecls.puma"
   return;

  }

# line 271 "SemDecls.puma"
  {
# line 272 "SemDecls.puma"
   failure_protocol ("SemDecls", "SemDeclarations", t);
  }
   return;

;
}

static void SemInterface
# if defined __STDC__ | defined __cplusplus
(register tTree items)
# else
(items)
 register tTree items;
# endif
{
  if (items->Kind == kUNIT_EMPTY) {
# line 283 "SemDecls.puma"
   return;

  }
  if (items->Kind == kUNIT_LIST) {
# line 286 "SemDecls.puma"
  {
# line 288 "SemDecls.puma"
   SemInterface (items->UNIT_LIST.Elem);
# line 289 "SemDecls.puma"
   SemInterface (items->UNIT_LIST.Next);
  }
   return;

  }
  if (items->Kind == kPROC_DECL) {
# line 292 "SemDecls.puma"
  {
# line 294 "SemDecls.puma"
   NestOpenUnit (items);
# line 295 "SemDecls.puma"
   SemDefinitions (GetCurrentScope ());
# line 296 "SemDecls.puma"
   Semantic (items->PROC_DECL.PROC_BODY);
# line 297 "SemDecls.puma"
   NestCloseUnit (items);
  }
   return;

  }
  if (items->Kind == kFUNC_DECL) {
# line 300 "SemDecls.puma"
  {
# line 302 "SemDecls.puma"
   NestOpenUnit (items);
# line 303 "SemDecls.puma"
   SemDefinitions (GetCurrentScope ());
# line 304 "SemDecls.puma"
   Semantic (items->FUNC_DECL.FUNC_BODY);
# line 305 "SemDecls.puma"
   NestCloseUnit (items);
  }
   return;

  }
  if (items->Kind == kMODULE_PROC_DECL) {
# line 308 "SemDecls.puma"
   return;

  }
# line 311 "SemDecls.puma"
  {
# line 313 "SemDecls.puma"
   failure_protocol (MODULE, "SemInterface", items);
  }
   return;

;
}

void SemDefinitions
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
# line 324 "SemDecls.puma"
  {
# line 326 "SemDecls.puma"
   SemDefinitions1 (t);
# line 327 "SemDecls.puma"
   SemDefinitions2 (t);
  }
   return;

;
}

static void SemDefinitions1
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kENTRY_LIST) {
# line 343 "SemDecls.puma"
  {
# line 347 "SemDecls.puma"
   SemDefinitions1 (t->ENTRY_LIST.Next);
# line 348 "SemDecls.puma"
   set_protocol_stmt (t->ENTRY_LIST.Elem->Object.decl);
# line 349 "SemDecls.puma"
   SemDefinitions1 (t->ENTRY_LIST.Elem);
  }
   return;

  }
  if (t->Kind == kENTRY_EMPTY) {
# line 352 "SemDecls.puma"
   return;

  }
# line 355 "SemDecls.puma"
  {
# line 357 "SemDecls.puma"
   if (! ((IsUsedObject (t, GetCurrentUnitObject ())))) goto yyL3;
  }
   return;
yyL3:;

  if (t->Kind == kVarObject) {
  if (t->VarObject.Kind->Kind == kVarParameter) {
# line 360 "SemDecls.puma"
  {
# line 362 "SemDecls.puma"
 t->VarObject.Kind->VarParameter.Val = SemExpression (t->VarObject.Kind->VarParameter.Val);
     if (!InitializationExpr (t->VarObject.Kind->VarParameter.Val))
       error_protocol ("expression in PARAMETER must be initialization expr");
   
  }
   return;

  }
  if (t->VarObject.Kind->Kind == kVarDummy) {
# line 368 "SemDecls.puma"
  {
# line 370 "SemDecls.puma"
   if (! ((! IsVarAssumedShape (t)))) goto yyL5;
  {
# line 371 "SemDecls.puma"
   if (! ((VarRank (t) > 0))) goto yyL5;
  {
# line 372 "SemDecls.puma"
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL5;
  {
# line 373 "SemDecls.puma"
   if (! ((! IsF77Unit (GetCurrentUnit ())))) goto yyL5;
  {
# line 375 "SemDecls.puma"
   error_protocol ("HPF_LOCAL only with assumed shape args");
  }
  }
  }
  }
  }
   return;
yyL5:;

  }
  }
;
}

static void SemDefinitions2
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
# line 386 "SemDecls.puma"

char msg[100];
char name[80];


  switch (t->Kind) {
  case kENTRY_LIST:
# line 391 "SemDecls.puma"
  {
# line 393 "SemDecls.puma"
   set_protocol_stmt (t->ENTRY_LIST.Elem->Object.decl);
# line 395 "SemDecls.puma"
   SemObjectType (t->ENTRY_LIST.Elem);
# line 398 "SemDecls.puma"
   SemDefinitions2 (t->ENTRY_LIST.Elem);
# line 399 "SemDecls.puma"
   SemDefinitions2 (t->ENTRY_LIST.Next);
  }
   return;

  case kENTRY_EMPTY:
# line 402 "SemDecls.puma"
   return;

  case kVarObject:
  if (t->VarObject.decl->Kind == kVAR_DECL) {
# line 405 "SemDecls.puma"
  {
# line 407 "SemDecls.puma"
 if (!CheckArrayKind (t->VarObject.decl->VAR_DECL.VAL, t->VarObject.Kind))
         obj_error_protocol ("array declaration illegal ", t);
     
  }
   return;

  }
  if (t->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 412 "SemDecls.puma"
  {
# line 414 "SemDecls.puma"
 if (!CheckArrayKind (t->VarObject.decl->VAR_PARAM_DECL.VAL, t->VarObject.Kind))
         { set_protocol_stmt (t->VarObject.decl);
           error_protocol ("array declaration illegal ");
         }
     
  }
   return;

  }
  break;
  case kTemplateObject:
  if (t->TemplateObject.decl->Kind == kTEMPLATE_DECL) {
# line 421 "SemDecls.puma"
   return;

  }
  break;
  case kTopologyObject:
  if (t->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
# line 427 "SemDecls.puma"
  {
# line 429 "SemDecls.puma"
 if (t->TopologyObject.target != NoTree)
     { t->TopologyObject.target = SemExpression (t->TopologyObject.target); 
       if (!ScalarIntExpr (t->TopologyObject.target))
         error_protocol ("target in MAP directive must be scalar int expr");
     }
  
  }
   return;

  }
  if (t->TopologyObject.decl->Kind == kSUB_PROCS_DECL) {
# line 437 "SemDecls.puma"
   return;

  }
  break;
  case kFuncObject:
  if (t->FuncObject.decl->Kind == kFUNC_DECL) {
# line 442 "SemDecls.puma"
   return;

  }
  if (t->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 447 "SemDecls.puma"
   return;

  }
  if (t->FuncObject.decl->Kind == kINTRINSIC_DECL) {
# line 452 "SemDecls.puma"
   return;

  }
  break;
  case kProcObject:
  if (t->ProcObject.decl->Kind == kPROGRAM_DECL) {
# line 457 "SemDecls.puma"
  {
# line 459 "SemDecls.puma"
   obj_error_protocol ("call of main program", t);
  }
   return;

  }
  if (t->ProcObject.decl->Kind == kPROC_DECL) {
# line 462 "SemDecls.puma"
   return;

  }
  if (t->ProcObject.decl->Kind == kINTRINSIC_DECL) {
# line 465 "SemDecls.puma"
   return;

  }
  break;
  }

  if (t->Kind == kExternalObject) {
# line 468 "SemDecls.puma"
   return;

  }
  if (t->Kind == kBlockObject) {
# line 471 "SemDecls.puma"
   return;

  }
  if (t->Kind == kTypeObject) {
# line 474 "SemDecls.puma"
  {
# line 476 "SemDecls.puma"
   if (! ((t->TypeObject.Components == NoEntries))) goto yyL16;
  {
# line 478 "SemDecls.puma"
   GetString (t->TypeObject.Ident, name);
# line 480 "SemDecls.puma"
 sprintf (msg, "type %d has not been defined", name);
       error_protocol (msg);
     
  }
  }
   return;
yyL16:;

# line 485 "SemDecls.puma"
  {
# line 487 "SemDecls.puma"
   SemDefinitions (t->TypeObject.Components);
  }
   return;

  }
  if (t->Kind == kNameListObject) {
# line 490 "SemDecls.puma"
   return;

  }
  if (t->Kind == kGenericObject) {
# line 493 "SemDecls.puma"
   return;

  }
  if (Definitions_IsType (t, kObject)) {
# line 496 "SemDecls.puma"
  {
# line 498 "SemDecls.puma"
   tree_error_protocol ("Unknown/Illegal object in Semantic Analysis : ", t->Object.decl);
  }
   return;

  }
# line 501 "SemDecls.puma"
  {
# line 502 "SemDecls.puma"
   failure_protocol (MODULE, "SemDefinitions", NoTree);
  }
   return;

;
}

static void SemObjectType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions o)
# else
(o)
 register tDefinitions o;
# endif
{
  if (o->Kind == kVarObject) {
  if (o->VarObject.decl->Kind == kVAR_DECL) {
# line 516 "SemDecls.puma"
  {
# line 518 "SemDecls.puma"
   CorrectType (o->VarObject.Ident, o->VarObject.decl->VAR_DECL.VAL);
  }
   return;

  }
  if (o->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 521 "SemDecls.puma"
  {
# line 523 "SemDecls.puma"
   CorrectType (o->VarObject.Ident, o->VarObject.decl->VAR_PARAM_DECL.VAL);
  }
   return;

  }
  }
  if (o->Kind == kTemplateObject) {
  if (o->TemplateObject.decl->Kind == kTEMPLATE_DECL) {
# line 526 "SemDecls.puma"
  {
# line 528 "SemDecls.puma"
   CorrectType (o->TemplateObject.Ident, o->TemplateObject.decl->TEMPLATE_DECL.DIMENSIONS);
  }
   return;

  }
  }
  if (o->Kind == kTopologyObject) {
  if (o->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
# line 531 "SemDecls.puma"
  {
# line 533 "SemDecls.puma"
   CorrectType (o->TopologyObject.Ident, o->TopologyObject.decl->PROCESSORS_DECL.DIMENSIONS);
  }
   return;

  }
  }
  if (o->Kind == kFuncObject) {
  if (o->FuncObject.decl->Kind == kFUNC_DECL) {
# line 536 "SemDecls.puma"
   return;

  }
  if (o->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 541 "SemDecls.puma"
  {
# line 543 "SemDecls.puma"
   CorrectType (o->FuncObject.Ident, o->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE);
  }
   return;

  }
  }
;
}

static void CorrectType
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree t)
# else
(id, t)
 register tIdent id;
 register tTree t;
# endif
{
# line 554 "SemDecls.puma"

char string[50], msg [100];


  switch (t->Kind) {
  case kALIGN_TYPE:
# line 558 "SemDecls.puma"
   return;

  case kDUMMY_TYPE:
# line 563 "SemDecls.puma"
  {
# line 565 "SemDecls.puma"
   GetString (id, string);
# line 566 "SemDecls.puma"
   sprintf (msg, "%s undeclared (has no type)", string);
# line 567 "SemDecls.puma"
   error_protocol (msg);
  }
   return;

  case kINTEGER_TYPE:
# line 570 "SemDecls.puma"
  {
# line 572 "SemDecls.puma"
   EvaluateKindParam (t);
# line 573 "SemDecls.puma"
   CheckKindValue (t, GetSize (t->INTEGER_TYPE.SIZE));
  }
   return;

  case kREAL_TYPE:
# line 576 "SemDecls.puma"
  {
# line 578 "SemDecls.puma"
   EvaluateKindParam (t);
# line 579 "SemDecls.puma"
   CheckKindValue (t, GetSize (t->REAL_TYPE.SIZE));
  }
   return;

  case kBOOLEAN_TYPE:
# line 582 "SemDecls.puma"
  {
# line 584 "SemDecls.puma"
   EvaluateKindParam (t);
# line 585 "SemDecls.puma"
   CheckKindValue (t, GetSize (t->BOOLEAN_TYPE.SIZE));
  }
   return;

  case kCOMPLEX_TYPE:
# line 588 "SemDecls.puma"
  {
# line 590 "SemDecls.puma"
   EvaluateKindParam (t);
# line 591 "SemDecls.puma"
   CheckKindValue (t, GetSize (t->COMPLEX_TYPE.SIZE));
  }
   return;

  case kSTRING_TYPE:
  if (t->STRING_TYPE.LENGTH->Kind == kDUMMY_EXP) {
# line 594 "SemDecls.puma"
   return;

  }
# line 597 "SemDecls.puma"
  {
# line 599 "SemDecls.puma"
 t->STRING_TYPE.LENGTH = ComputeSize (t->STRING_TYPE.LENGTH, -1); 
  }
   return;

  case kARRAY_TYPE:
# line 602 "SemDecls.puma"
  {
# line 603 "SemDecls.puma"
   CorrectType (id, t->ARRAY_TYPE.ARRAY_INDEX_TYPES);
# line 604 "SemDecls.puma"
   CorrectType (id, t->ARRAY_TYPE.ARRAY_COMP_TYPE);
  }
   return;

  case kSHAPE_LIST:
# line 607 "SemDecls.puma"
  {
# line 608 "SemDecls.puma"
   CorrectType (id, t->SHAPE_LIST.Elem);
# line 609 "SemDecls.puma"
   CorrectType (id, t->SHAPE_LIST.Next);
  }
   return;

  case kSHAPE_EMPTY:
# line 612 "SemDecls.puma"
   return;

  case kEXPLICIT_SHAPE:
# line 615 "SemDecls.puma"
  {
# line 617 "SemDecls.puma"
 t->EXPLICIT_SHAPE.LOWER = SemExpression (t->EXPLICIT_SHAPE.LOWER);
      if (!ScalarIntExpr (t->EXPLICIT_SHAPE.LOWER))
         { error_protocol ("array bound must be scalar integer expression");
           tree_protocol  ("illegal lower bound : ", t->EXPLICIT_SHAPE.LOWER);
         }
      t->EXPLICIT_SHAPE.UPPER = SemExpression (t->EXPLICIT_SHAPE.UPPER);
      if (!ScalarIntExpr (t->EXPLICIT_SHAPE.UPPER))
        {  error_protocol ("array bound must be scalar integer expression");
           tree_protocol  ("illegal upper bound : ", t->EXPLICIT_SHAPE.UPPER);
         }
    
  }
   return;

  case kSHAPE_SPEC:
  case kASSUMED_SHAPE:
  case kDEFERRED_SHAPE:
  case kASSUMED_SIZE:
# line 630 "SemDecls.puma"
   return;

  case kTYPE_ID:
# line 633 "SemDecls.puma"
   return;

  }

;
}

static int GetSize
# if defined __STDC__ | defined __cplusplus
(register tTree kind)
# else
(kind)
 register tTree kind;
# endif
{
  if (kind->Kind == kCONST_EXP) {
  if (kind->CONST_EXP.C->Kind == kINT_CONSTANT) {
# line 644 "SemDecls.puma"
   return kind->CONST_EXP.C->INT_CONSTANT.value;

  }
  }
 yyAbort ("GetSize");
}

static void CheckKindValue
# if defined __STDC__ | defined __cplusplus
(register tTree type, register int size)
# else
(type, size)
 register tTree type;
 register int size;
# endif
{
# line 648 "SemDecls.puma"
 char msg[100]; 
  if (type->Kind == kINTEGER_TYPE) {
# line 650 "SemDecls.puma"
  {
# line 652 "SemDecls.puma"
   if (! ((size == default_int_size))) goto yyL1;
  }
   return;
yyL1:;

# line 655 "SemDecls.puma"
  {
# line 657 "SemDecls.puma"
   error_protocol ("illegal INTEGER type");
# line 658 "SemDecls.puma"
   sprintf (msg, "Only INTEGER*%d allowed", default_int_size);
# line 659 "SemDecls.puma"
   print_protocol (msg);
  }
   return;

  }
  if (type->Kind == kBOOLEAN_TYPE) {
# line 662 "SemDecls.puma"
  {
# line 663 "SemDecls.puma"
   if (! ((size == 1))) goto yyL3;
  }
   return;
yyL3:;

# line 666 "SemDecls.puma"
  {
# line 667 "SemDecls.puma"
   if (! ((size == default_int_size))) goto yyL4;
  }
   return;
yyL4:;

# line 670 "SemDecls.puma"
  {
# line 672 "SemDecls.puma"
   error_protocol ("illegal LOGICAL type");
# line 673 "SemDecls.puma"
   sprintf (msg, "Only LOGICAL*1 or LOGICAL*%d allowed", default_int_size);
# line 674 "SemDecls.puma"
   print_protocol (msg);
  }
   return;

  }
  if (type->Kind == kREAL_TYPE) {
# line 677 "SemDecls.puma"
  {
# line 678 "SemDecls.puma"
   if (! ((size == default_real_size))) goto yyL6;
  }
   return;
yyL6:;

# line 681 "SemDecls.puma"
  {
# line 682 "SemDecls.puma"
   if (! ((size == 2 * default_real_size))) goto yyL7;
  }
   return;
yyL7:;

# line 685 "SemDecls.puma"
  {
# line 687 "SemDecls.puma"
   error_protocol ("illegal REAL type");
# line 688 "SemDecls.puma"
   sprintf (msg, "Only REAL*%d or REAL*%d allowed", default_real_size, 2 * default_real_size);
# line 690 "SemDecls.puma"
   print_protocol (msg);
  }
   return;

  }
  if (type->Kind == kCOMPLEX_TYPE) {
# line 693 "SemDecls.puma"
  {
# line 694 "SemDecls.puma"
   if (! ((size == 2 * default_real_size))) goto yyL9;
  }
   return;
yyL9:;

# line 697 "SemDecls.puma"
  {
# line 698 "SemDecls.puma"
   if (! ((size == 4 * default_real_size))) goto yyL10;
  }
   return;
yyL10:;

# line 701 "SemDecls.puma"
  {
# line 702 "SemDecls.puma"
   sprintf (msg, "Only COMPLEX*%d or COMPLEX*%d allowed", 2 * default_real_size, 4 * default_real_size);
# line 704 "SemDecls.puma"
   print_protocol (msg);
  }
   return;

  }
;
}

static void EvaluateKindParam
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
  if (type->Kind == kREAL_TYPE) {
# line 721 "SemDecls.puma"
  {
# line 722 "SemDecls.puma"
 type->REAL_TYPE.SIZE = ComputeSize (type->REAL_TYPE.SIZE, default_real_size); 
  }
   return;

  }
  if (type->Kind == kINTEGER_TYPE) {
# line 725 "SemDecls.puma"
  {
# line 726 "SemDecls.puma"
 type->INTEGER_TYPE.SIZE = ComputeSize (type->INTEGER_TYPE.SIZE, default_int_size); 
  }
   return;

  }
  if (type->Kind == kCOMPLEX_TYPE) {
# line 729 "SemDecls.puma"
  {
# line 730 "SemDecls.puma"
 type->COMPLEX_TYPE.SIZE = ComputeSize (type->COMPLEX_TYPE.SIZE, 2*default_real_size); 
  }
   return;

  }
  if (type->Kind == kBOOLEAN_TYPE) {
# line 733 "SemDecls.puma"
  {
# line 734 "SemDecls.puma"
 type->BOOLEAN_TYPE.SIZE = ComputeSize (type->BOOLEAN_TYPE.SIZE, default_int_size); 
  }
   return;

  }
;
}

static tTree ComputeSize
# if defined __STDC__ | defined __cplusplus
(register tTree kind, register int default_size)
# else
(kind, default_size)
 register tTree kind;
 register int default_size;
# endif
{
  if (kind->Kind == kCONST_EXP) {
  if (kind->CONST_EXP.C->Kind == kINT_CONSTANT) {
# line 745 "SemDecls.puma"
   return kind;

  }
  }
  if (kind->Kind == kDUMMY_EXP) {
# line 749 "SemDecls.puma"
 {
  {
  register tTree yyV1;
   yyALLOC (tTree,Tree_PoolFreePtr,Tree_PoolMaxPtr,Tree_Alloc,Tree_NodeSize,MakeTree,yyV1,kINT_CONSTANT)
    yyV1->INT_CONSTANT.value = default_size;
   return mCONST_EXP (yyV1);
  }
 }

  }
# line 753 "SemDecls.puma"
 {
  bool found;
  int val;
  {
# line 755 "SemDecls.puma"

# line 756 "SemDecls.puma"

# line 758 "SemDecls.puma"
   GetIntConstValue (kind, & found, & val);
# line 760 "SemDecls.puma"
 if (!found)
       { val = default_size;
         error_protocol ("kind of type must be evaluated at compile time");
         tree_protocol ("kind expression is : ", kind);
         WriteTree (stdout, kind);
       }
     else if (val < 0)
       { error_protocol ("kind not suppported");
         tree_protocol  ("kind value is : ", kind);
         val = default_size;
       }
   
  }
  {
  register tTree yyV1;
   yyALLOC (tTree,Tree_PoolFreePtr,Tree_PoolMaxPtr,Tree_Alloc,Tree_NodeSize,MakeTree,yyV1,kINT_CONSTANT)
    yyV1->INT_CONSTANT.value = val;
   return mCONST_EXP (yyV1);
  }
 }

}

static void GetArrayKind
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int * yyP2, register int * yyP1)
# else
(t, yyP2, yyP1)
 register tTree t;
 register int * yyP2;
 register int * yyP1;
# endif
{
  if (t->Kind == kASSUMED_SIZE) {
# line 794 "SemDecls.puma"
   * yyP2 = arr_assumed_size;
   * yyP1 = 0;
   return;

  }
  if (t->Kind == kEXPLICIT_SHAPE) {
# line 797 "SemDecls.puma"
 {
  int size;
  int val;
  bool found;
  {
# line 800 "SemDecls.puma"

# line 801 "SemDecls.puma"

# line 802 "SemDecls.puma"

# line 804 "SemDecls.puma"
   GetIntConstValue (t->EXPLICIT_SHAPE.LOWER, & found, & val);
# line 805 "SemDecls.puma"
   if (! ((found))) goto yyL2;
  {
# line 806 "SemDecls.puma"
   GetIntConstValue (t->EXPLICIT_SHAPE.UPPER, & found, & size);
# line 807 "SemDecls.puma"
   if (! ((found))) goto yyL2;
  {
# line 808 "SemDecls.puma"
   size = size - val + 1;
  }
  }
  }
   * yyP2 = arr_fixed_size;
   * yyP1 = size;
   return;
 }
yyL2:;

# line 811 "SemDecls.puma"
   * yyP2 = arr_automatic;
   * yyP1 = 0;
   return;

  }
  if (t->Kind == kDEFERRED_SHAPE) {
# line 814 "SemDecls.puma"
   * yyP2 = arr_allocatable;
   * yyP1 = 0;
   return;

  }
  if (t->Kind == kASSUMED_SHAPE) {
# line 817 "SemDecls.puma"
   * yyP2 = arr_assumed_shape;
   * yyP1 = 0;
   return;

  }
  if (t->Kind == kARRAY_TYPE) {
# line 832 "SemDecls.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 834 "SemDecls.puma"
   GetArrayKind (t->ARRAY_TYPE.ARRAY_INDEX_TYPES, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (t->Kind == kSHAPE_LIST) {
  if (t->SHAPE_LIST.Next->Kind == kSHAPE_EMPTY) {
# line 837 "SemDecls.puma"
 {
  int yyV1;
  int yyV2;
  {
# line 839 "SemDecls.puma"
   GetArrayKind (t->SHAPE_LIST.Elem, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
# line 842 "SemDecls.puma"
 {
  int yyV1;
  int yyV2;
  int yyV3;
  int yyV4;
  {
# line 844 "SemDecls.puma"
   GetArrayKind (t->SHAPE_LIST.Elem, & yyV1, & yyV2);
# line 845 "SemDecls.puma"
   GetArrayKind (t->SHAPE_LIST.Next, & yyV3, & yyV4);
  }
   * yyP2 = TypeCombination (yyV1, yyV3);
   * yyP1 = yyV2 * yyV4;
   return;
 }

  }
# line 848 "SemDecls.puma"
  {
# line 849 "SemDecls.puma"
   failure_protocol (MODULE, "GetArrayKind", t);
  }
   * yyP2 = 0;
   * yyP1 = 0;
   return;

;
}

static int TypeCombination
# if defined __STDC__ | defined __cplusplus
(register int kind1, register int kind2)
# else
(kind1, kind2)
 register int kind1;
 register int kind2;
# endif
{
  if (equalint (kind1, arr_illegal)) {
# line 860 "SemDecls.puma"
   return arr_illegal;

  }
  if (equalint (kind2, arr_illegal)) {
# line 862 "SemDecls.puma"
   return arr_illegal;

  }
  if (equalint (kind1, arr_assumed_shape)) {
  if (equalint (kind2, arr_assumed_shape)) {
# line 868 "SemDecls.puma"
   return arr_assumed_shape;

  }
  }
  if (equalint (kind1, arr_allocatable)) {
  if (equalint (kind2, arr_assumed_shape)) {
# line 871 "SemDecls.puma"
   return arr_assumed_shape;

  }
  }
  if (equalint (kind1, arr_assumed_shape)) {
  if (equalint (kind2, arr_allocatable)) {
# line 874 "SemDecls.puma"
   return arr_assumed_shape;

  }
  }
  if (equalint (kind1, arr_assumed_shape)) {
# line 877 "SemDecls.puma"
   return arr_illegal;

  }
  if (equalint (kind2, arr_assumed_shape)) {
# line 880 "SemDecls.puma"
   return arr_illegal;

  }
  if (equalint (kind1, arr_allocatable)) {
  if (equalint (kind2, arr_allocatable)) {
# line 887 "SemDecls.puma"
   return arr_allocatable;

  }
  }
  if (equalint (kind1, arr_allocatable)) {
# line 890 "SemDecls.puma"
   return arr_illegal;

  }
  if (equalint (kind2, arr_allocatable)) {
# line 893 "SemDecls.puma"
   return arr_illegal;

  }
  if (equalint (kind1, arr_assumed_size)) {
# line 900 "SemDecls.puma"
   return arr_illegal;

  }
  if (equalint (kind1, arr_fixed_size)) {
  if (equalint (kind2, arr_assumed_size)) {
# line 903 "SemDecls.puma"
   return arr_assumed_size;

  }
  }
  if (equalint (kind1, arr_automatic)) {
  if (equalint (kind2, arr_assumed_size)) {
# line 906 "SemDecls.puma"
   return arr_assumed_size;

  }
  }
  if (equalint (kind1, arr_fixed_size)) {
  if (equalint (kind2, arr_fixed_size)) {
# line 914 "SemDecls.puma"
   return arr_fixed_size;

  }
  }
  if (equalint (kind1, arr_fixed_size)) {
  if (equalint (kind2, arr_automatic)) {
# line 917 "SemDecls.puma"
   return arr_automatic;

  }
  }
  if (equalint (kind1, arr_automatic)) {
  if (equalint (kind2, arr_fixed_size)) {
# line 920 "SemDecls.puma"
   return arr_automatic;

  }
  }
  if (equalint (kind1, arr_automatic)) {
  if (equalint (kind2, arr_automatic)) {
# line 923 "SemDecls.puma"
   return arr_automatic;

  }
  }
# line 926 "SemDecls.puma"
  {
# line 927 "SemDecls.puma"
   failure_protocol (MODULE, "ArrayTypeCombination", NoTree);
  }
   return arr_illegal;

}

static bool CheckArrayKind
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tDefinitions desc)
# else
(type, desc)
 register tTree type;
 register tDefinitions desc;
# endif
{
# line 940 "SemDecls.puma"

int  k, size;
bool okay;

  if (type->Kind == kARRAY_TYPE) {
  if (desc->Kind == kVarDummy) {
# line 945 "SemDecls.puma"
  {
# line 947 "SemDecls.puma"
 GetArrayKind (type, &k, &size);
     desc->VarDummy.dynamic = k;
     okay = true;
     if (k == arr_illegal)
       { print_protocol ("illegal specification for dummy variable");
         okay = false;
       }
   
  }
   return okay;

  }
  if (desc->Kind == kVarLocal) {
# line 958 "SemDecls.puma"
  {
# line 960 "SemDecls.puma"
 GetArrayKind (type, &k, &size);
     desc->VarLocal.dynamic = k;
     okay = true;
     if (k == arr_assumed_size)
       { print_protocol ("assumed size not allowed for local variable");
         okay = false;
       }
     if (k == arr_assumed_shape)
       { print_protocol ("assumed shape not allowed for local variable");
         okay = false;
       }
     if (k == arr_illegal)
       { print_protocol ("illegal specification for local variable");
         okay = false;
       }
   
  }
   return okay;

  }
  if (desc->Kind == kVarCommon) {
# line 979 "SemDecls.puma"
  {
# line 981 "SemDecls.puma"
 GetArrayKind (type, &k, &size);
     okay = true;
     if (k != arr_fixed_size)
       { okay = false;
         print_protocol ("size of common variable is unknown");
       }
   
  }
   return okay;

  }
  }
# line 991 "SemDecls.puma"
   return true;

}

void BeginSemDecls ()
{
}

void CloseSemDecls ()
{
}
