# include "SemCalling.h"
# include "yySemCalling.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 36 "SemCalling.puma"


# include <string.h>

# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "Objects.h"     /* GetReferenceObject */
# include "Types.h"       /* type_rec, GetTypeRecord */
# include "Rank.h"
# include "TreeOps.h"
# include "DefTable.h" 
# include "ShowDefs.h"
# include "Intrinsics.h"

# include "Transform.h"

# include "SemIntr.h"
# include "SemExp.h"
# include "SemPreds.h"

# define MODULE "SemCalling"

# undef DEBUG

static tTree MoveParameter ();    /* needed to define static function */
 
static int  param_counter = 0;

# define KIND_UNKNOWN  0
# define KIND_VAR      1
# define KIND_FUNC     2
# define KIND_PROC     3
# define KIND_EXT      4

/* values needed for optional parameters */

static bool    is_mandatory  [MAX_PARAMS];
static tIdent  param_name    [MAX_PARAMS];
static tTree   param_val     [MAX_PARAMS];

/* values needed for type checking */

typedef bool check_routine ();

static tObject param_dummy [MAX_PARAMS];  /* VAR, DSP, FUNC, PROC, EXT    */
static int  param_kind     [MAX_PARAMS];  /* VAR, DSP, FUNC, PROC, EXT    */
static int  param_intent   [MAX_PARAMS];  /* IN, OUT, INOUT, <unknown>    */
static int  param_layout   [MAX_PARAMS];  /* LAYOUT (F77_ARRAY), ...      */
static int  param_pass_by  [MAX_PARAMS];  /* PASS_BY ('*', HANDLE)        */
static int  param_trace    [MAX_PARAMS];  /* TRACE attribute of dummy     */
static int  param_sequence [MAX_PARAMS];  /* SEQUENCE attribute of dummy  */
static int  param_rank     [MAX_PARAMS];  /* rank of dummy argument       */
static int  param_type     [MAX_PARAMS];  /* type of dummy argument       */
static int  param_size     [MAX_PARAMS];  /* size of dummy argument       */

static check_routine *param_check [MAX_PARAMS];  /* check for intrinsic arg */

       /*************************************************
       *                                                *
       *  init_parameters ()                            *
       *                                                *
       *************************************************/

static void init_parameters () 

{ 
  param_counter = 0;
}

       /*************************************************
       *                                                *
       *  set_no_interface ()                           *
       *  no_interface ()         ! no interface avail. *
       *                                                *
       *************************************************/

static void set_no_interface () 

{ 
  param_counter = -1;
}

static bool no_interface ()

{
  return (param_counter == -1);

} /* no_interface */

       /*************************************************
       *                                                *
       *  set_intrinsic_parameter (...)                 *
       *                                                *
       *************************************************/

static void set_intrinsic_parameter (name, mandatory, kind, check, rank)

char *name;
bool mandatory;
int  kind;
check_routine check;
int  rank;

{ param_name   [param_counter] = MakeIdent (name, strlen(name));
  param_dummy  [param_counter] = NoObject;
  is_mandatory [param_counter] = mandatory;
  param_val    [param_counter] = NoTree;

  param_kind     [param_counter] = KIND_UNKNOWN;
  param_intent   [param_counter] = kind;
  param_layout   [param_counter] = kDEFAULT_LAYOUT;
  param_pass_by  [param_counter] = kDEFAULT_PASS_BY;
  param_trace    [param_counter] = 0;
  param_rank     [param_counter] = rank; 
  param_sequence [param_counter] = 0;     /* no sequence association */

  /* for type make difference between string and other arguments */

  if (check == StringExpr)
    param_type   [param_counter] = kSTRING_TYPE;
   else
    param_type   [param_counter] = kDUMMY_TYPE;

  param_size   [param_counter] = -1;           /* every size is allowed */
  param_check  [param_counter] = check;

  param_counter += 1;

#ifdef DEBUG
  printf ("set intrinsic parameter %d, mand = %d, rank = %d\n",
           param_counter, mandatory, rank);
#endif

} /* set_intrinsic_parameter */

       /*************************************************
       *                                                *
       *  set_user_parameter (...)                      *
       *                                                *
       *************************************************/

static void set_user_parameter (name, dummy, mandatory, 
                                kind, intent, layout, pass_by, trace, 
                                sequence, rank, type, size)

tIdent  name;
tObject dummy;
bool   mandatory;
int kind, intent, layout, pass_by, trace, sequence, rank, type, size;

{ param_name   [param_counter] = name;
  param_dummy  [param_counter] = dummy;
  is_mandatory [param_counter] = mandatory;
  param_val    [param_counter] = NoTree;

  param_kind     [param_counter] = kind;
  param_intent   [param_counter] = intent;
  param_layout   [param_counter] = layout;
  param_pass_by  [param_counter] = pass_by;
  param_trace    [param_counter] = trace;
  param_sequence [param_counter] = sequence;
  param_rank     [param_counter] = rank;
  param_type     [param_counter] = type;
  param_size     [param_counter] = size;

  param_counter += 1;

#ifdef DEBUG
  printf ("set user param %d, mand = %d, rank = %d, kind = %d, intent =%d\n",
           param_counter, mandatory, rank, kind, intent);
#endif

} /* set_user_parameter */


static void get_type_string (tstr, type_kind)

char *tstr;
int type_kind;

{ switch (type_kind) {

  case kINTEGER_TYPE : sprintf (tstr, "INTEGER"); break;
  case kREAL_TYPE    : sprintf (tstr, "REAL"); break;
  case kBOOLEAN_TYPE : sprintf (tstr, "LOGICAL"); break;
  case kCOMPLEX_TYPE : sprintf (tstr, "COMPLEX"); break;
  case kSTRING_TYPE  : sprintf (tstr, "CHARACTER"); break;
  case kTYPE_ID      : sprintf (tstr, "TYPE"); break;
  case kDUMMY_TYPE   : sprintf (tstr, "<dummy>"); break;
  default            : sprintf (tstr, "<unknown>"); break;

  } /* switch */

} /* get_type_string */
 
       /*************************************************
       *                                                *
       *  FindNamedPosition (name => flag, pos)         *
       *                                                *
       *  flag = 0            parameter not available   *
       *  flag = 2   pos      parameter already set     *
       *  flag = 1   pos      parameter at position pos *
       *                                                *
       *************************************************/
 
static void FindNamedPosition (name, flag, pos)

tIdent name;
int *flag, *pos;
 
{ int found, i;
 
  found = 0;
  i     = 0;
 
  while ( (!found) && (i<param_counter))
   { found = (param_name[i] == name);
     if (!found) i++;
   }
 
  if (!found) 
     *flag = 0;
    else if (param_val[i] != NoTree)
     *flag = 2;
    else
     *flag = 1;

  *pos = i;
 
} /* FindNamedPosition */

       /*************************************************
       *                                                *
       *  PutNamedParameter (tIdent name, tTree val)    *
       *                                                *
       *************************************************/
 
static void PutNamedParameter (name, val)
tIdent name;
tTree  val;
 
{ int found, pos;
  char string[100], msg[100];
 
  FindNamedPosition (name, &found, &pos);

  if (found == 0)
   { GetString (name, string);
     sprintf (msg, "formal parameter %s does not exist", string);
     error_protocol (msg);
   }
  else if (found > 1)
   { GetString (name, string);
     sprintf (msg, "formal parameter %s specified more than once", string);
     error_protocol (msg);
   }
  else
     param_val[pos] = val;

} /* PutNamedParameter */
 
       /*************************************************
       *                                                *
       *  SetNamedParameter (tIdent name, tTree val)    *
       *                                                *
       *  - returns true if it was okay                 *
       *                                                *
       *************************************************/

static bool SetNamedParameter (name, val)

tIdent name;
tTree  val;

{ int found, pos;
 
  FindNamedPosition (name, &found, &pos);
 
  if (found == 1)
     { param_val[pos] = val;
       return (true);
     }
   else
     return (false);

} /* SetNamedParameter */

       /*************************************************
       *                                                *
       *  FindFreePosition (name => pos)                *
       *                                                *
       *  pos >= 0  free position found                 *
       *                                                *
       *************************************************/
 
static void FindFreePosition (pos)
 
int *pos;
 
{ int found, i;
 
  i     = 0;
  found = 0;
 
  /* find free position */
 
  while ( (!found) && (i<param_counter))
   { found = (param_val[i] == NoTree);
     if (!found) i++;
   }
 
  *pos = i;
  if (!found) *pos = -1;

} /* FindFreePosition */

       /*************************************************
       *                                                *
       *  PutUnNamedParameter (tTree val)             *
       *                                                *
       *************************************************/
 
static void PutUnNamedParameter (val)
tTree val;
 
{ int pos;
  char msg[100];
 
  FindFreePosition (&pos);
 
  if (pos < 0)
   { sprintf (msg, "too many arguments (max = %d)", param_counter);
     error_protocol (msg);
   }
  else
     param_val[pos] = val;
 
} /* put_unnamed_parameter */

       /*************************************************
       *                                                *
       *  SetUnNamedParameter (tTree val)               *
       *                                                *
       *  - returns true if it was okay                 *
       *                                                *
       *************************************************/
 
static bool SetUnNamedParameter (val)
 
tTree  val;
 
{ int pos;
 
  FindFreePosition (&pos);
 
  if (pos >= 0)
     { param_val[pos] = val;
       return (true);
     }
   else
     return (false);
 
} /* SetUnNamedParameter */
 
       /*************************************************
       *                                                *
       *  Tree make_new_parameterlist                   *
       *                                                *
       *************************************************/
 
static tTree MakeNewParameterList (old)
 
tTree old;
 
{ tTree new, val;
  int i;
 
  new = old;
 
#ifdef DEBUG
  printf ("MakeNewParameterList, old has %d params, %d params required\n", 
           TreeListLength (old), param_counter);
#endif

  for (i=0; i<param_counter; i++)

    {  val = param_val[i];
       if (val == NoTree) val = mNO_PARAM (param_type[i]);
       new = MoveParameter (new, i, val);
    }

  return (new);
 
} /* MakeNewParameterList */
 


static void yyExit () { Exit (1); }

void (* SemCalling_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemCalling, routine %s failed\n", yyFunction);
 SemCalling_Exit ();
}

void SemCalling ARGS((tTree t));
static void SetInterfaceUse ARGS((tDefinitions obj));
static void SetUserParamFormals ARGS((tTree formals, tDefinitions entries));
static int GetDummyKind ARGS((tDefinitions obj));
static int GetDummyIntent ARGS((tDefinitions obj));
static int GetDummyLayout ARGS((tDefinitions obj));
static int GetDummyPassBy ARGS((tDefinitions obj));
static int GetDummyTrace ARGS((tDefinitions obj));
static int GetDummySequence ARGS((tDefinitions obj));
static void GetDummyType ARGS((tDefinitions obj, int * yyP2, int * yyP1));
static bool HasOptionalAttribute ARGS((tDefinitions obj));
static void CheckCorrectParameterList ARGS((tTree params, bool intrinsic_flag));
static void SetNamedParameters ARGS((tTree t));
static void SetUnNamedParameters ARGS((tTree t));
static void CheckKind ARGS((tTree t, int kind));
void CheckIntention ARGS((tTree t, int intent));
static void CheckLayout ARGS((tTree t, int dummy_layout));
static void CheckPassBy ARGS((tTree t, int dummy_pass_by));
static void CheckTrace ARGS((tTree t, int dummy_trace));
static void SetDummy ARGS((tTree t, tDefinitions dummy));
static void CheckRank ARGS((tTree t, int rank, int sequence));
static void CheckType ARGS((tTree t, int type, int size));
static bool IsEqualType ARGS((int kind1, int kind2, int size1, int size2));
tDefinitions IdentifyGenericRoutine ARGS((tTree call, tDefinitions MyObj));
tTree IdentifyBinaryRoutine ARGS((tTree exp));
tTree IdentifyUnaryRoutine ARGS((tTree exp));
tTree IdentifyAssignRoutine ARGS((tTree ass));
static tDefinitions GetOpEntries ARGS((tDefinitions Obj));
static tDefinitions FindRoutine ARGS((tTree t, tDefinitions entries));
static tDefinitions FindBinaryRoutine ARGS((tTree e1, tTree e2, tDefinitions entries));
static tDefinitions FindUnaryRoutine ARGS((tTree e1, tDefinitions entries));
static bool Match ARGS((tTree t, tDefinitions Obj));
static bool MatchBinary ARGS((tTree e1, tTree e2, tDefinitions Obj));
static bool MatchUnary ARGS((tTree e1, tDefinitions Obj));
static bool CanSetNamedParameters ARGS((tTree params));
static bool CanSetUnNamedParameters ARGS((tTree params));
static bool MatchingParameters ARGS((tTree params));
static bool MatchType ARGS((tTree p, int type, int size));
static bool MatchExpType ARGS((tTree exp, int type, int size));
static tTree MoveParameter ARGS((tTree paramlist, int pos, tTree val));
static bool WithNamedParameters ARGS((tTree t));
static int ScatterRank ARGS((tIdent name, tTree params));
static void SetParamDefaults ARGS((tTree call, tTree params));
static void SetVarParamDefaults ARGS((tTree call, tTree param));
static void SetDefaultIntention ARGS((tTree param));
static void SetDefaultLayout ARGS((tTree call, tTree param));
static void SetDefaultPassBy ARGS((tTree call, tTree param));
static void PrintParamVals ARGS((tTree params));

void SemCalling
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
# line 450 "SemCalling.puma"
  {
# line 452 "SemCalling.puma"
   if (! ((IsIntrCall (t)))) goto yyL1;
  {
# line 454 "SemCalling.puma"
   init_parameters ();
# line 455 "SemCalling.puma"
   SetIntrinsicInfo (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, ScatterRank (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->FUNC_CALL_EXP.FUNC_PARAMS), set_intrinsic_parameter);
# line 457 "SemCalling.puma"
   CheckCorrectParameterList (t->FUNC_CALL_EXP.FUNC_PARAMS, true);
# line 458 "SemCalling.puma"
   t->FUNC_CALL_EXP.FUNC_PARAMS = MakeNewParameterList (t->FUNC_CALL_EXP.FUNC_PARAMS);
# line 460 "SemCalling.puma"
   SetParamDefaults (t, t->FUNC_CALL_EXP.FUNC_PARAMS);
# line 461 "SemCalling.puma"
   tree_protocol ("function call : ", t);
# line 462 "SemCalling.puma"
   PrintParamVals (t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
  }
   return;
yyL1:;

# line 465 "SemCalling.puma"
  {
# line 467 "SemCalling.puma"
   SetInterfaceUse (GetReferenceObject (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object));
# line 468 "SemCalling.puma"
   CheckCorrectParameterList (t->FUNC_CALL_EXP.FUNC_PARAMS, false);
# line 469 "SemCalling.puma"
   t->FUNC_CALL_EXP.FUNC_PARAMS = MakeNewParameterList (t->FUNC_CALL_EXP.FUNC_PARAMS);
# line 471 "SemCalling.puma"
   SetParamDefaults (t, t->FUNC_CALL_EXP.FUNC_PARAMS);
# line 472 "SemCalling.puma"
   tree_protocol ("function call : ", t);
# line 473 "SemCalling.puma"
   PrintParamVals (t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
   return;

  }
  if (t->Kind == kCALL_STMT) {
# line 476 "SemCalling.puma"
  {
# line 478 "SemCalling.puma"
   if (! ((IsIntrCall (t)))) goto yyL3;
  {
# line 479 "SemCalling.puma"
   init_parameters ();
# line 480 "SemCalling.puma"
   SetIntrinsicInfo (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, ScatterRank (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, t->CALL_STMT.CALL_PARAMS), set_intrinsic_parameter);
# line 482 "SemCalling.puma"
   CheckCorrectParameterList (t->CALL_STMT.CALL_PARAMS, true);
# line 483 "SemCalling.puma"
   t->CALL_STMT.CALL_PARAMS = MakeNewParameterList (t->CALL_STMT.CALL_PARAMS);
# line 485 "SemCalling.puma"
   SetParamDefaults (t, t->CALL_STMT.CALL_PARAMS);
# line 486 "SemCalling.puma"
   tree_protocol ("subroutine call : ", t);
# line 487 "SemCalling.puma"
   PrintParamVals (t->CALL_STMT.CALL_PARAMS);
  }
  }
   return;
yyL3:;

# line 490 "SemCalling.puma"
  {
# line 492 "SemCalling.puma"
   SetInterfaceUse (GetReferenceObject (t->CALL_STMT.CALL_ID->PROC_OBJ.Object));
# line 493 "SemCalling.puma"
   CheckCorrectParameterList (t->CALL_STMT.CALL_PARAMS, false);
# line 494 "SemCalling.puma"
   t->CALL_STMT.CALL_PARAMS = MakeNewParameterList (t->CALL_STMT.CALL_PARAMS);
# line 496 "SemCalling.puma"
   SetParamDefaults (t, t->CALL_STMT.CALL_PARAMS);
# line 497 "SemCalling.puma"
   tree_protocol ("subroutine call : ", t);
# line 498 "SemCalling.puma"
   PrintParamVals (t->CALL_STMT.CALL_PARAMS);
  }
   return;

  }
# line 501 "SemCalling.puma"
  {
# line 502 "SemCalling.puma"
   failure_protocol (MODULE, "SemCalling", t);
  }
   return;

;
}

static void SetInterfaceUse
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 518 "SemCalling.puma"
  {
# line 519 "SemCalling.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 520 "SemCalling.puma"
   set_no_interface ();
  }
  }
   return;
yyL1:;

  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
# line 523 "SemCalling.puma"
  {
# line 526 "SemCalling.puma"
   init_parameters ();
# line 527 "SemCalling.puma"
   SetUserParamFormals (obj->FuncObject.decl->FUNC_DECL.FORMALS, obj->FuncObject.Declarations);
  }
   return;

  }
  if (obj->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 530 "SemCalling.puma"
  {
# line 534 "SemCalling.puma"
   set_no_interface ();
  }
   return;

  }
  }
  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kPROC_DECL) {
# line 537 "SemCalling.puma"
  {
# line 540 "SemCalling.puma"
   init_parameters ();
# line 541 "SemCalling.puma"
   SetUserParamFormals (obj->ProcObject.decl->PROC_DECL.FORMALS, obj->ProcObject.Declarations);
  }
   return;

  }
  }
  if (obj->Kind == kGenericObject) {
# line 544 "SemCalling.puma"
  {
# line 546 "SemCalling.puma"
   set_no_interface ();
# line 547 "SemCalling.puma"
   stmt_protocol ("could not check parameters of the call");
  }
   return;

  }
# line 550 "SemCalling.puma"
  {
# line 551 "SemCalling.puma"
   error_protocol ("illegal object for the call");
  }
   return;

;
}

static void SetUserParamFormals
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tDefinitions entries)
# else
(formals, entries)
 register tTree formals;
 register tDefinitions entries;
# endif
{
  if (formals->Kind == kDECL_LIST) {
# line 562 "SemCalling.puma"
  {
# line 564 "SemCalling.puma"
   SetUserParamFormals (formals->DECL_LIST.Elem, entries);
# line 565 "SemCalling.puma"
   SetUserParamFormals (formals->DECL_LIST.Next, entries);
  }
   return;

  }
  if (formals->Kind == kDECL_EMPTY) {
# line 568 "SemCalling.puma"
   return;

  }
  if (formals->Kind == kVAR_PARAM_DECL) {
# line 571 "SemCalling.puma"
 {
  tDefinitions dummy;
  bool optional;
  int yyV1;
  int yyV2;
  {
# line 573 "SemCalling.puma"

# line 574 "SemCalling.puma"

# line 576 "SemCalling.puma"
   dummy = GetDeclEntry (formals->VAR_PARAM_DECL.Ident, entries);
# line 578 "SemCalling.puma"
   optional = HasOptionalAttribute (dummy);
# line 580 "SemCalling.puma"
   GetDummyType (dummy, & yyV1, & yyV2);
# line 582 "SemCalling.puma"
   set_user_parameter (formals->VAR_PARAM_DECL.Ident, dummy, (! optional), GetDummyKind (dummy), GetDummyIntent (dummy), GetDummyLayout (dummy), GetDummyPassBy (dummy), GetDummyTrace (dummy), GetDummySequence (dummy), VarRank (dummy), yyV1, yyV2);
  }
   return;
 }

  }
# line 588 "SemCalling.puma"
  {
# line 590 "SemCalling.puma"
   failure_protocol (MODULE, "SetUserParamFormals", formals);
  }
   return;

;
}

static int GetDummyKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 601 "SemCalling.puma"
   return KIND_VAR;

  }
  }
  if (obj->Kind == kFuncObject) {
# line 605 "SemCalling.puma"
   return KIND_FUNC;

  }
  if (obj->Kind == kProcObject) {
# line 609 "SemCalling.puma"
   return KIND_PROC;

  }
  if (obj->Kind == kExternalObject) {
# line 613 "SemCalling.puma"
   return KIND_EXT;

  }
 yyAbort ("GetDummyKind");
}

static int GetDummyIntent
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 619 "SemCalling.puma"
   return obj->VarObject.Kind->VarDummy.Intent;

  }
  }
  if (obj->Kind == kFuncObject) {
# line 623 "SemCalling.puma"
   return 0;

  }
  if (obj->Kind == kProcObject) {
# line 627 "SemCalling.puma"
   return 0;

  }
  if (obj->Kind == kExternalObject) {
# line 631 "SemCalling.puma"
   return 0;

  }
# line 635 "SemCalling.puma"
  {
# line 636 "SemCalling.puma"
   failure_protocol ("MODULE", "GetDummyIntent", obj->Object.decl);
  }
   return 0;

}

static int GetDummyLayout
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 648 "SemCalling.puma"
   return obj->VarObject.Kind->VarDummy.layout;

  }
  }
# line 652 "SemCalling.puma"
   return kDEFAULT_LAYOUT;

}

static int GetDummyPassBy
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 664 "SemCalling.puma"
   return obj->VarObject.Kind->VarDummy.pass_by;

  }
  }
# line 668 "SemCalling.puma"
   return kDEFAULT_PASS_BY;

}

static int GetDummyTrace
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
# line 680 "SemCalling.puma"
   return obj->VarObject.trace;

  }
# line 685 "SemCalling.puma"
   return 0;

}

static int GetDummySequence
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
# line 697 "SemCalling.puma"
   return obj->VarObject.sequence;

  }
# line 702 "SemCalling.puma"
   return 0;

}

static void GetDummyType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int * yyP2, register int * yyP1)
# else
(obj, yyP2, yyP1)
 register tDefinitions obj;
 register int * yyP2;
 register int * yyP1;
# endif
{
  if (obj->Kind == kProcObject) {
# line 714 "SemCalling.puma"
   * yyP2 = 0;
   * yyP1 = 0;
   return;

  }
  if (obj->Kind == kExternalObject) {
# line 717 "SemCalling.puma"
   * yyP2 = 0;
   * yyP1 = 0;
   return;

  }
# line 720 "SemCalling.puma"
 {
  type_rec type;
  {
# line 722 "SemCalling.puma"

# line 724 "SemCalling.puma"
   GetTypeRecord (GetBaseType (GetObjectType (obj)), & type);
  }
   * yyP2 = type . type_kind;
   * yyP1 = type . type_size;
   return;
 }

;
}

static bool HasOptionalAttribute
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
# line 735 "SemCalling.puma"
  {
# line 736 "SemCalling.puma"
   if (! ((obj->VarObject.Kind->VarDummy.optional))) goto yyL1;
  }
   return true;
yyL1:;

# line 739 "SemCalling.puma"
  {
# line 740 "SemCalling.puma"
   return false;
  }

  }
  }
  if (obj->Kind == kProcObject) {
# line 743 "SemCalling.puma"
  {
# line 744 "SemCalling.puma"
   if (! ((obj->ProcObject.Kind == DummyRoutine))) goto yyL3;
  {
# line 745 "SemCalling.puma"
   return false;
  }
  }
yyL3:;

  }
  if (obj->Kind == kFuncObject) {
# line 748 "SemCalling.puma"
  {
# line 749 "SemCalling.puma"
   if (! ((obj->FuncObject.Kind == DummyRoutine))) goto yyL4;
  {
# line 750 "SemCalling.puma"
   return false;
  }
  }
yyL4:;

  }
  if (obj->Kind == kExternalObject) {
# line 753 "SemCalling.puma"
  {
# line 754 "SemCalling.puma"
   if (! ((obj->ExternalObject.Kind == DummyRoutine))) goto yyL5;
  {
# line 755 "SemCalling.puma"
   return false;
  }
  }
yyL5:;

  }
# line 758 "SemCalling.puma"
  {
# line 759 "SemCalling.puma"
   obj_protocol ("cannot ask this object for optional attribute", obj);
# line 760 "SemCalling.puma"
   failure_protocol (MODULE, "HasOptionalAttribute", obj->Object.decl);
  }
   return true;

}

static void CheckCorrectParameterList
# if defined __STDC__ | defined __cplusplus
(register tTree params, register bool intrinsic_flag)
# else
(params, intrinsic_flag)
 register tTree params;
 register bool intrinsic_flag;
# endif
{
# line 773 "SemCalling.puma"
  {
# line 775 "SemCalling.puma"
   if (! ((no_interface ()))) goto yyL1;
  {
# line 777 "SemCalling.puma"
 if (WithNamedParameters (params))
     error_protocol ("cannot verify named parameters (no interface available)");
 
  }
  }
   return;
yyL1:;

# line 782 "SemCalling.puma"
  {
# line 785 "SemCalling.puma"
 int i;
   char string[100], msg[100];
   type_rec act_type;

   check_routine *p;

   SetNamedParameters (params);
   SetUnNamedParameters (params);

   for (i=0; i<param_counter; i++)

     { 
#ifdef DEBUG
       printf ("checking parameter %d of %d, mandatory = %d\n",
                i+1, param_counter, is_mandatory[i]); 
#endif

       if (is_mandatory[i] && (param_val[i] == NoTree))

        { GetString (param_name[i], string);
          sprintf (msg, "actual for dummy argument %s is missed", string);
          error_protocol (msg);
        }

        else if (param_val[i] != NoTree)

        { CheckKind      (param_val[i], param_kind[i]);
          CheckLayout    (param_val[i], param_layout[i]);
          CheckPassBy    (param_val[i], param_pass_by[i]);
          CheckTrace     (param_val[i], param_trace[i]);
          CheckIntention (param_val[i], param_intent[i]);
          CheckRank      (param_val[i], param_rank[i], param_sequence[i]);
          SetDummy       (param_val[i], param_dummy[i]);
   
          if (!intrinsic_flag)

             CheckType   (param_val[i], param_type[i], param_size[i]);

           else 
   
             { p = param_check[i];

               if (!p (param_val[i]))

                 { GetString (param_name[i], string);
                   sprintf (msg, "intrinsic argument %s %s", 
                                 string, type_error_msg);
                   error_protocol (msg);
                   tree_protocol ("illegal argument is ", param_val[i]);
 
                   GetParamType (param_val[i], &act_type);
 
                   get_type_string (string, act_type.type_kind);
                   sprintf (msg, "actual type : %s*%d : ", 
                                  string, act_type.type_size);
                   tree_protocol (msg, param_val[i]);
                 }
             }

        } 

     } 
 
  }
   return;

;
}

static void SetNamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
# line 858 "SemCalling.puma"
  {
# line 860 "SemCalling.puma"
   PutNamedParameter (t->BTP_LIST.Elem->NAMED_PARAM.Name, t->BTP_LIST.Elem->NAMED_PARAM.VAL);
# line 861 "SemCalling.puma"
   SetNamedParameters (t->BTP_LIST.Next);
  }
   return;

  }
# line 864 "SemCalling.puma"
  {
# line 866 "SemCalling.puma"
   SetNamedParameters (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->Kind == kBTP_EMPTY) {
# line 869 "SemCalling.puma"
   return;

  }
;
}

static void SetUnNamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
# line 880 "SemCalling.puma"
  {
# line 882 "SemCalling.puma"
   SetUnNamedParameters (t->BTP_LIST.Next);
  }
   return;

  }
# line 885 "SemCalling.puma"
  {
# line 887 "SemCalling.puma"
   PutUnNamedParameter (t->BTP_LIST.Elem);
# line 888 "SemCalling.puma"
   SetUnNamedParameters (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->Kind == kBTP_EMPTY) {
# line 891 "SemCalling.puma"
   return;

  }
;
}

static void CheckKind
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int kind)
# else
(t, kind)
 register tTree t;
 register int kind;
# endif
{
  if (t->Kind == kNO_PARAM) {
# line 902 "SemCalling.puma"
   return;

  }
  if (t->Kind == kFUNC_PARAM) {
# line 905 "SemCalling.puma"
  {
# line 907 "SemCalling.puma"
 switch (kind) {

     case KIND_FUNC    : break;
     case KIND_EXT     : break;
     case KIND_UNKNOWN : break;
     case KIND_PROC    : error_protocol ("subroutine expected, not function");
                         break;
     case KIND_VAR     : error_protocol ("var expected, not function");
                         break;
     }
   
  }
   return;

  }
  if (t->Kind == kPROC_PARAM) {
# line 920 "SemCalling.puma"
  {
# line 922 "SemCalling.puma"
 switch (kind) {

     case KIND_PROC    : break;
     case KIND_EXT     : break;
     case KIND_UNKNOWN : break;
     case KIND_FUNC    : error_protocol ("function expected, not subroutine");
                         break;
     case KIND_VAR     : error_protocol ("var expected, not subroutine");
                         break;
     }
   
  }
   return;

  }
  if (t->Kind == kVAR_PARAM) {
# line 935 "SemCalling.puma"
  {
# line 937 "SemCalling.puma"
 switch (kind) {

     case KIND_VAR     : break;
     case KIND_UNKNOWN : break;
     case KIND_PROC    : error_protocol ("subroutine expected, not variable");
                         break;
     case KIND_FUNC    : error_protocol ("function exptected, not variable");
                         break;
     case KIND_EXT     : error_protocol ("external exptected, not variable");
                         break;
     }
   
  }
   return;

  }
# line 951 "SemCalling.puma"
   return;

;
}

void CheckIntention
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int intent)
# else
(t, intent)
 register tTree t;
 register int intent;
# endif
{
  if (t->Kind == kVAR_PARAM) {
# line 964 "SemCalling.puma"
  {
# line 966 "SemCalling.puma"
   if (! ((! IsDefinableParam (t)))) goto yyL1;
  {
# line 967 "SemCalling.puma"
   if (! ((intent == IntentOut))) goto yyL1;
  {
# line 969 "SemCalling.puma"
   error_protocol ("not definable argument for OUT argument");
# line 970 "SemCalling.puma"
   tree_protocol ("wrong argument is ", t);
  }
  }
  }
   return;
yyL1:;

# line 973 "SemCalling.puma"
  {
# line 975 "SemCalling.puma"
   if (! ((! IsDefinableParam (t)))) goto yyL2;
  {
# line 976 "SemCalling.puma"
   if (! ((intent == IntentInOut))) goto yyL2;
  {
# line 978 "SemCalling.puma"
   error_protocol ("not definable arguemnt for INOUT argument");
# line 979 "SemCalling.puma"
   tree_protocol ("wrong argument is ", t);
  }
  }
  }
   return;
yyL2:;

# line 982 "SemCalling.puma"
  {
# line 984 "SemCalling.puma"
 t->VAR_PARAM.intent = intent; 
  }
   return;

  }
;
}

static void CheckLayout
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int dummy_layout)
# else
(t, dummy_layout)
 register tTree t;
 register int dummy_layout;
# endif
{
  if (t->Kind == kVAR_PARAM) {
# line 995 "SemCalling.puma"
  {
# line 997 "SemCalling.puma"
 t->VAR_PARAM.layout = dummy_layout; 
  }
   return;

  }
;
}

static void CheckPassBy
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int dummy_pass_by)
# else
(t, dummy_pass_by)
 register tTree t;
 register int dummy_pass_by;
# endif
{
  if (t->Kind == kVAR_PARAM) {
# line 1008 "SemCalling.puma"
  {
# line 1010 "SemCalling.puma"
 t->VAR_PARAM.pass_by = dummy_pass_by; 
  }
   return;

  }
;
}

static void CheckTrace
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int dummy_trace)
# else
(t, dummy_trace)
 register tTree t;
 register int dummy_trace;
# endif
{
  if (t->Kind == kVAR_PARAM) {
# line 1021 "SemCalling.puma"
  {
# line 1023 "SemCalling.puma"
 t->VAR_PARAM.trace = dummy_trace; 
  }
   return;

  }
;
}

static void SetDummy
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions dummy)
# else
(t, dummy)
 register tTree t;
 register tDefinitions dummy;
# endif
{
  if (t->Kind == kVAR_PARAM) {
# line 1028 "SemCalling.puma"
  {
# line 1030 "SemCalling.puma"
 t->VAR_PARAM.formal = dummy; 
  }
   return;

  }
;
}

static void CheckRank
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int rank, register int sequence)
# else
(t, rank, sequence)
 register tTree t;
 register int rank;
 register int sequence;
# endif
{
# line 1041 "SemCalling.puma"

char msg[100];

# line 1045 "SemCalling.puma"
  {
# line 1047 "SemCalling.puma"
   if (! ((rank == - 1))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kVAR_PARAM) {
# line 1050 "SemCalling.puma"
  {
# line 1052 "SemCalling.puma"
   if (! ((TreeRank (t) != rank))) goto yyL2;
  {
# line 1054 "SemCalling.puma"
 
 
     if (semantic_check == 0)
         warning_protocol ("rank mismatch for actual argument");
       else if (sequence == IsSequence)
         warning_protocol ("sequence association for actual argument");
       else
         error_protocol ("rank mismatch for actual argument");
 
     sprintf (msg, "   actual parameter (rank = %d) is ", TreeRank(t));
     tree_protocol (msg, t);
     sprintf (msg, "   dummy  parameter (rank = %d) ", rank);
     print_protocol (msg);

   
  }
  }
   return;
yyL2:;

  }
# line 1071 "SemCalling.puma"
   return;

;
}

static void CheckType
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int type, register int size)
# else
(t, type, size)
 register tTree t;
 register int type;
 register int size;
# endif
{
# line 1082 "SemCalling.puma"

char msg[100], tstr[50];

# line 1086 "SemCalling.puma"
  {
# line 1087 "SemCalling.puma"
   if (! ((type == kDUMMY_TYPE))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kVAR_PARAM) {
# line 1090 "SemCalling.puma"
 {
  type_rec act_type;
  {
# line 1092 "SemCalling.puma"

# line 1094 "SemCalling.puma"
   GetParamType (t, & act_type);
# line 1096 "SemCalling.puma"
 if (!IsEqualType (act_type.type_kind, type, act_type.type_size, size))

       { if (semantic_check == 0)
            warning_protocol ("type/size mismatch for actual and dummy");
           else
            error_protocol ("type/size mismatch for actual and dummy");
         get_type_string (tstr, act_type.type_kind);
         sprintf (msg, "actual type : %s*%d : ", tstr, act_type.type_size);
         tree_protocol (msg, t);
         get_type_string (tstr, type);
         sprintf (msg, "formal type : %s*%d", tstr, size);
         print_protocol (msg);
       }
   
  }
   return;
 }

  }
;
}

static bool IsEqualType
# if defined __STDC__ | defined __cplusplus
(register int kind1, register int kind2, register int size1, register int size2)
# else
(kind1, kind2, size1, size2)
 register int kind1;
 register int kind2;
 register int size1;
 register int size2;
# endif
{
# line 1114 "SemCalling.puma"
  {
# line 1115 "SemCalling.puma"
   if (! ((kind1 == kind2))) goto yyL1;
  {
# line 1116 "SemCalling.puma"
   if (! ((size1 == size2))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 1119 "SemCalling.puma"
  {
# line 1120 "SemCalling.puma"
   if (! ((kind1 == kind2))) goto yyL2;
  {
# line 1121 "SemCalling.puma"
   if (! ((kind1 == kTYPE_ID))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 1124 "SemCalling.puma"
  {
# line 1125 "SemCalling.puma"
   if (! ((kind1 == kind2))) goto yyL3;
  {
# line 1126 "SemCalling.puma"
   if (! ((kind1 == kSTRING_TYPE))) goto yyL3;
  {
# line 1127 "SemCalling.puma"
   if (! ((size2 == - 1))) goto yyL3;
  }
  }
  }
   return true;
yyL3:;

  return false;
}

tDefinitions IdentifyGenericRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tDefinitions MyObj)
# else
(call, MyObj)
 register tTree call;
 register tDefinitions MyObj;
# endif
{
  if (call->Kind == kCALL_STMT) {
  if (MyObj->Kind == kGenericObject) {
# line 1138 "SemCalling.puma"
 {
  tDefinitions Obj;
  {
# line 1140 "SemCalling.puma"

# line 1142 "SemCalling.puma"
   Obj = FindRoutine (call, MyObj->GenericObject.Interfaces);
# line 1144 "SemCalling.puma"
 if (Obj == NoObject)
         { error_protocol ("no interface subroutine matches");
           Obj = MyObj;
         }
       else
         { tree_protocol ("generic subroutine call : ", call);
           obj_protocol ("identified with ", Obj);
         }
    
  }
  {
   return Obj;
  }
 }

  }
  if (MyObj->Kind == kProcObject) {
# line 1157 "SemCalling.puma"
   return MyObj;

  }
  }
  if (call->Kind == kFUNC_CALL_EXP) {
  if (MyObj->Kind == kGenericObject) {
# line 1162 "SemCalling.puma"
 {
  tDefinitions Obj;
  {
# line 1164 "SemCalling.puma"

# line 1166 "SemCalling.puma"
   Obj = FindRoutine (call, MyObj->GenericObject.Interfaces);
# line 1168 "SemCalling.puma"
 if (Obj == NoObject)
        { error_protocol ("no interface function matches");
          Obj = MyObj;
        }
       else
        { tree_protocol ("generic function call : ", call);
          obj_protocol ("identified with ", Obj);
        }
    
  }
  {
   return Obj;
  }
 }

  }
  if (MyObj->Kind == kFuncObject) {
# line 1181 "SemCalling.puma"
   return MyObj;

  }
  }
# line 1186 "SemCalling.puma"
  {
# line 1188 "SemCalling.puma"
   error_protocol ("no legal object for subroutine/function");
# line 1189 "SemCalling.puma"
   tree_protocol ("call is : ", call);
# line 1190 "SemCalling.puma"
   obj_protocol ("this is object : ", MyObj);
  }
   return MyObj;

}

tTree IdentifyBinaryRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kOP_EXP) {
# line 1202 "SemCalling.puma"
 {
  tTree new;
  tDefinitions Obj;
  tDefinitions f_entries;
  {
# line 1204 "SemCalling.puma"

# line 1205 "SemCalling.puma"

# line 1206 "SemCalling.puma"

# line 1208 "SemCalling.puma"
   f_entries = GetOpEntries (GetGlobalObject (MakeOperatorId (exp->OP_EXP.EXP_OP)));
# line 1210 "SemCalling.puma"
   if (! ((f_entries != NoEntries))) goto yyL1;
  {
# line 1212 "SemCalling.puma"
   Obj = FindBinaryRoutine (exp->OP_EXP.OPND1, exp->OP_EXP.OPND2, f_entries);
# line 1214 "SemCalling.puma"
 if (Obj == NoObject)
        new = NoTree;
      else
        { new = mPROC_OBJ (Obj->Object.Ident);
          new->PROC_OBJ.Object = Obj;
          new = mFUNC_CALL_EXP (new,
                 mBTP_LIST (ExpToVarParam (exp->OP_EXP.OPND1),
                  mBTP_LIST (ExpToVarParam (exp->OP_EXP.OPND2), mBTP_EMPTY ())));
        }
   
  }
  }
  {
   return new;
  }
 }
yyL1:;

  }
# line 1228 "SemCalling.puma"
   return NoTree;

}

tTree IdentifyUnaryRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kOP1_EXP) {
# line 1240 "SemCalling.puma"
 {
  tTree new;
  tDefinitions Obj;
  tDefinitions f_entries;
  {
# line 1242 "SemCalling.puma"

# line 1243 "SemCalling.puma"

# line 1244 "SemCalling.puma"

# line 1246 "SemCalling.puma"
   f_entries = GetOpEntries (GetGlobalObject (MakeOperatorId (exp->OP1_EXP.EXP_OP1)));
# line 1248 "SemCalling.puma"
   if (! ((f_entries != NoEntries))) goto yyL1;
  {
# line 1251 "SemCalling.puma"
   Obj = FindUnaryRoutine (exp->OP1_EXP.OPND, f_entries);
# line 1253 "SemCalling.puma"
 if (Obj == NoObject)
        new = NoTree;
      else
        { new = mPROC_OBJ (Obj->Object.Ident);
          new->PROC_OBJ.Object = Obj;
          new = mFUNC_CALL_EXP (new,
                  mBTP_LIST (ExpToVarParam (exp->OP1_EXP.OPND), mBTP_EMPTY ()));
        }
   
  }
  }
  {
   return new;
  }
 }
yyL1:;

  }
# line 1266 "SemCalling.puma"
   return NoTree;

}

tTree IdentifyAssignRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree ass)
# else
(ass)
 register tTree ass;
# endif
{
  if (ass->Kind == kASSIGN_STMT) {
# line 1278 "SemCalling.puma"
 {
  tTree new;
  tDefinitions Obj;
  tDefinitions f_entries;
  {
# line 1280 "SemCalling.puma"

# line 1281 "SemCalling.puma"

# line 1282 "SemCalling.puma"

# line 1284 "SemCalling.puma"
   f_entries = GetOpEntries (GetGlobalObject (MakeIdent ("=", 1)));
# line 1286 "SemCalling.puma"
   if (! ((f_entries != NoEntries))) goto yyL1;
  {
# line 1288 "SemCalling.puma"
   Obj = FindBinaryRoutine (ass->ASSIGN_STMT.ASSIGN_VAR, ass->ASSIGN_STMT.ASSIGN_EXP, f_entries);
# line 1290 "SemCalling.puma"
 if (Obj == NoObject)
        new = NoTree;
      else
        { new = mPROC_OBJ (Obj->Object.Ident);
          new->PROC_OBJ.Object = Obj;
          new = mCALL_STMT (new,
                 mBTP_LIST (mVAR_PARAM (ass->ASSIGN_STMT.ASSIGN_VAR),
                  mBTP_LIST (ExpToVarParam (ass->ASSIGN_STMT.ASSIGN_EXP), mBTP_EMPTY ())));
        }
   
  }
  }
  {
   return new;
  }
 }
yyL1:;

  }
# line 1304 "SemCalling.puma"
   return NoTree;

}

static tDefinitions GetOpEntries
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj)
# else
(Obj)
 register tDefinitions Obj;
# endif
{
# line 1310 "SemCalling.puma"
  {
# line 1311 "SemCalling.puma"
   if (! ((Obj == NoObject))) goto yyL1;
  }
   return NoEntries;
yyL1:;

  if (Obj->Kind == kGenericObject) {
# line 1315 "SemCalling.puma"
   return Obj->GenericObject.Interfaces;

  }
# line 1319 "SemCalling.puma"
   return NoEntries;

}

static tDefinitions FindRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions entries)
# else
(t, entries)
 register tTree t;
 register tDefinitions entries;
# endif
{
  if (entries->Kind == kENTRY_LIST) {
# line 1331 "SemCalling.puma"
  {
# line 1333 "SemCalling.puma"
   if (! ((Match (t, entries->ENTRY_LIST.Elem)))) goto yyL1;
  {
# line 1335 "SemCalling.puma"
 if (FindRoutine (t, entries->ENTRY_LIST.Next) != NoObject)
         error_protocol ("call of generic routine is ambiguous");
    
  }
  }
   return entries->ENTRY_LIST.Elem;
yyL1:;

# line 1342 "SemCalling.puma"
   return FindRoutine (t, entries->ENTRY_LIST.Next);

  }
  if (entries->Kind == kENTRY_EMPTY) {
# line 1347 "SemCalling.puma"
   return NoObject;

  }
 yyAbort ("FindRoutine");
}

static tDefinitions FindBinaryRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2, register tDefinitions entries)
# else
(e1, e2, entries)
 register tTree e1;
 register tTree e2;
 register tDefinitions entries;
# endif
{
  if (entries->Kind == kENTRY_LIST) {
# line 1365 "SemCalling.puma"
  {
# line 1367 "SemCalling.puma"
   if (! ((MatchBinary (e1, e2, entries->ENTRY_LIST.Elem)))) goto yyL1;
  {
# line 1369 "SemCalling.puma"
 if (FindBinaryRoutine (e1, e2, entries->ENTRY_LIST.Next) != NoObject)
         error_protocol ("call of binary interface operator is ambiguous");
    
  }
  }
   return entries->ENTRY_LIST.Elem;
yyL1:;

# line 1376 "SemCalling.puma"
   return FindBinaryRoutine (e1, e2, entries->ENTRY_LIST.Next);

  }
  if (entries->Kind == kENTRY_EMPTY) {
# line 1381 "SemCalling.puma"
   return NoObject;

  }
 yyAbort ("FindBinaryRoutine");
}

static tDefinitions FindUnaryRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tDefinitions entries)
# else
(e1, entries)
 register tTree e1;
 register tDefinitions entries;
# endif
{
  if (entries->Kind == kENTRY_LIST) {
# line 1394 "SemCalling.puma"
  {
# line 1396 "SemCalling.puma"
   if (! ((MatchUnary (e1, entries->ENTRY_LIST.Elem)))) goto yyL1;
  {
# line 1398 "SemCalling.puma"
 if (FindUnaryRoutine (e1, entries->ENTRY_LIST.Next) != NoObject)
         error_protocol ("call of unary interface operator is ambiguous");
    
  }
  }
   return entries->ENTRY_LIST.Elem;
yyL1:;

# line 1405 "SemCalling.puma"
   return FindUnaryRoutine (e1, entries->ENTRY_LIST.Next);

  }
  if (entries->Kind == kENTRY_EMPTY) {
# line 1410 "SemCalling.puma"
   return NoObject;

  }
 yyAbort ("FindUnaryRoutine");
}

static bool Match
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions Obj)
# else
(t, Obj)
 register tTree t;
 register tDefinitions Obj;
# endif
{
  if (t->Kind == kCALL_STMT) {
  if (Obj->Kind == kProcObject) {
  if (Obj->ProcObject.decl->Kind == kPROC_DECL) {
# line 1423 "SemCalling.puma"
  {
# line 1426 "SemCalling.puma"
   SetInterfaceUse (Obj);
# line 1427 "SemCalling.puma"
   if (! ((MatchingParameters (t->CALL_STMT.CALL_PARAMS)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  }
  if (t->Kind == kFUNC_CALL_EXP) {
  if (Obj->Kind == kFuncObject) {
  if (Obj->FuncObject.decl->Kind == kFUNC_DECL) {
# line 1430 "SemCalling.puma"
  {
# line 1433 "SemCalling.puma"
   SetInterfaceUse (Obj);
# line 1434 "SemCalling.puma"
   if (! ((MatchingParameters (t->FUNC_CALL_EXP.FUNC_PARAMS)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  }
  return false;
}

static bool MatchBinary
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2, register tDefinitions Obj)
# else
(e1, e2, Obj)
 register tTree e1;
 register tTree e2;
 register tDefinitions Obj;
# endif
{
  if (Obj->Kind == kFuncObject) {
# line 1447 "SemCalling.puma"
  {
# line 1449 "SemCalling.puma"
   SetInterfaceUse (Obj);
# line 1451 "SemCalling.puma"
   if (! ((param_counter == 2))) goto yyL1;
  {
# line 1453 "SemCalling.puma"
   if (! ((MatchExpType (e1, param_type [0], param_size [0])))) goto yyL1;
  {
# line 1454 "SemCalling.puma"
   if (! ((MatchExpType (e2, param_type [1], param_size [1])))) goto yyL1;
  }
  }
  }
   return true;
yyL1:;

  }
  return false;
}

static bool MatchUnary
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tDefinitions Obj)
# else
(e1, Obj)
 register tTree e1;
 register tDefinitions Obj;
# endif
{
  if (Obj->Kind == kFuncObject) {
# line 1467 "SemCalling.puma"
  {
# line 1469 "SemCalling.puma"
   SetInterfaceUse (Obj);
# line 1471 "SemCalling.puma"
   if (! ((param_counter == 1))) goto yyL1;
  {
# line 1473 "SemCalling.puma"
   if (! ((MatchExpType (e1, param_type [0], param_size [0])))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  return false;
}

static bool CanSetNamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
# line 1484 "SemCalling.puma"
  {
# line 1486 "SemCalling.puma"
   if (! ((SetNamedParameter (params->BTP_LIST.Elem->NAMED_PARAM.Name, params->BTP_LIST.Elem->NAMED_PARAM.VAL)))) goto yyL1;
  {
# line 1487 "SemCalling.puma"
   if (! ((CanSetNamedParameters (params->BTP_LIST.Next)))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 1490 "SemCalling.puma"
  {
# line 1492 "SemCalling.puma"
   return false;
  }

  }
# line 1495 "SemCalling.puma"
  {
# line 1497 "SemCalling.puma"
   if (! ((CanSetNamedParameters (params->BTP_LIST.Next)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  if (params->Kind == kBTP_EMPTY) {
# line 1500 "SemCalling.puma"
   return true;

  }
  return false;
}

static bool CanSetUnNamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
# line 1511 "SemCalling.puma"
  {
# line 1513 "SemCalling.puma"
   if (! ((CanSetUnNamedParameters (params->BTP_LIST.Next)))) goto yyL1;
  }
   return true;
yyL1:;

  }
# line 1516 "SemCalling.puma"
  {
# line 1518 "SemCalling.puma"
   if (! ((SetUnNamedParameter (params->BTP_LIST.Elem)))) goto yyL2;
  {
# line 1519 "SemCalling.puma"
   if (! ((CanSetUnNamedParameters (params->BTP_LIST.Next)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  if (params->Kind == kBTP_EMPTY) {
# line 1522 "SemCalling.puma"
   return true;

  }
  return false;
}

static bool MatchingParameters
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
# line 1533 "SemCalling.puma"
 {
  bool match;
  int i;
  {
# line 1535 "SemCalling.puma"

# line 1536 "SemCalling.puma"

# line 1538 "SemCalling.puma"
   if (! ((CanSetNamedParameters (params)))) goto yyL1;
  {
# line 1539 "SemCalling.puma"
   if (! ((CanSetUnNamedParameters (params)))) goto yyL1;
  {
# line 1541 "SemCalling.puma"
 match = true;
 
     for (i=0; i<param_counter; i++)
 
      { if (is_mandatory[i] && (param_val[i] == NoTree))

           match = false;    

         else if (param_val[i] != NoTree)
 
         { if (!MatchType (param_val[i], param_type[i], param_size[i]))
            match = false;
 
         } 
 
     } 

   
# line 1560 "SemCalling.puma"
   if (! ((match))) goto yyL1;
  }
  }
  }
   return true;
 }
yyL1:;

  return false;
}

static bool MatchType
# if defined __STDC__ | defined __cplusplus
(register tTree p, register int type, register int size)
# else
(p, type, size)
 register tTree p;
 register int type;
 register int size;
# endif
{
  if (p->Kind == kVAR_PARAM) {
# line 1565 "SemCalling.puma"
 {
  type_rec act_type;
  {
# line 1567 "SemCalling.puma"

# line 1569 "SemCalling.puma"
   GetParamType (p, & act_type);
# line 1571 "SemCalling.puma"
   if (! ((IsEqualType (act_type . type_kind, type, act_type . type_size, size)))) goto yyL1;
  }
   return true;
 }
yyL1:;

  }
  return false;
}

static bool MatchExpType
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int type, register int size)
# else
(exp, type, size)
 register tTree exp;
 register int type;
 register int size;
# endif
{
# line 1576 "SemCalling.puma"
 {
  type_rec act_type;
  {
# line 1578 "SemCalling.puma"

# line 1580 "SemCalling.puma"
   GetExpType (exp, & act_type);
# line 1582 "SemCalling.puma"
   if (! ((IsEqualType (act_type . type_kind, type, act_type . type_size, size)))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static tTree MoveParameter
# if defined __STDC__ | defined __cplusplus
(register tTree paramlist, register int pos, register tTree val)
# else
(paramlist, pos, val)
 register tTree paramlist;
 register int pos;
 register tTree val;
# endif
{
  if (paramlist->Kind == kBTP_LIST) {
# line 1595 "SemCalling.puma"
  {
# line 1597 "SemCalling.puma"
   if (! ((pos > 0))) goto yyL1;
  {
# line 1599 "SemCalling.puma"
 paramlist->BTP_LIST.Next = MoveParameter (paramlist->BTP_LIST.Next, pos-1, val); 
  }
  }
   return paramlist;
yyL1:;

  if (equalint (pos, 0)) {
# line 1604 "SemCalling.puma"
  {
# line 1606 "SemCalling.puma"
 paramlist->BTP_LIST.Elem = val; 
  }
   return paramlist;

  }
  }
  if (paramlist->Kind == kBTP_EMPTY) {
  if (equalint (pos, 0)) {
# line 1611 "SemCalling.puma"
   return mBTP_LIST (val, paramlist);

  }
  }
# line 1616 "SemCalling.puma"
  {
# line 1618 "SemCalling.puma"
   failure_protocol (MODULE, "MoveParameter", paramlist);
  }
   return NoTree;

}

static bool WithNamedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
# line 1633 "SemCalling.puma"
   return true;

  }
# line 1636 "SemCalling.puma"
  {
# line 1637 "SemCalling.puma"
   if (! ((WithNamedParameters (t->BTP_LIST.Next)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

static int ScatterRank
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 1658 "SemCalling.puma"
  {
# line 1662 "SemCalling.puma"
   if (! ((IntrFuncRed (name) || IntrFuncLocRed (name)))) goto yyL1;
  }
   return TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V);
yyL1:;

  }
# line 1666 "SemCalling.puma"
  {
# line 1668 "SemCalling.puma"
   if (! ((IntrFuncScatter (name)))) goto yyL2;
  }
   return TreeRank (params->BTP_LIST.Next->BTP_LIST.Elem);
yyL2:;

  }
  }
# line 1672 "SemCalling.puma"
  {
# line 1674 "SemCalling.puma"
   if (! ((IntrFuncElemental (name)))) goto yyL3;
  }
   return TreeListLength (params);
yyL3:;

# line 1678 "SemCalling.puma"
   return 0;

}

static void SetParamDefaults
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree params)
# else
(call, params)
 register tTree call;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
# line 1690 "SemCalling.puma"
  {
# line 1692 "SemCalling.puma"
   SetParamDefaults (call, params->BTP_LIST.Elem);
# line 1693 "SemCalling.puma"
   SetParamDefaults (call, params->BTP_LIST.Next);
  }
   return;

  }
  if (params->Kind == kVAR_PARAM) {
# line 1696 "SemCalling.puma"
  {
# line 1698 "SemCalling.puma"
   SetVarParamDefaults (call, params);
  }
   return;

  }
;
}

static void SetVarParamDefaults
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree param)
# else
(call, param)
 register tTree call;
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
# line 1709 "SemCalling.puma"
  {
# line 1711 "SemCalling.puma"
   if (! ((param->VAR_PARAM.intent == IntentNo))) goto yyL1;
  {
# line 1713 "SemCalling.puma"
   SetDefaultIntention (param);
# line 1715 "SemCalling.puma"
   goto yyL1;
  }
  }
yyL1:;

# line 1718 "SemCalling.puma"
  {
# line 1720 "SemCalling.puma"
   if (! ((param->VAR_PARAM.layout == kDEFAULT_LAYOUT))) goto yyL2;
  {
# line 1722 "SemCalling.puma"
   SetDefaultLayout (call, param);
# line 1724 "SemCalling.puma"
   goto yyL2;
  }
  }
yyL2:;

# line 1727 "SemCalling.puma"
  {
# line 1729 "SemCalling.puma"
   if (! ((param->VAR_PARAM.pass_by == kDEFAULT_PASS_BY))) goto yyL3;
  {
# line 1731 "SemCalling.puma"
   SetDefaultPassBy (call, param);
# line 1733 "SemCalling.puma"
   goto yyL3;
  }
  }
yyL3:;

  }
;
}

static void SetDefaultIntention
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
# line 1744 "SemCalling.puma"
  {
# line 1746 "SemCalling.puma"
   if (! ((! IsDefinableParam (param)))) goto yyL1;
  {
# line 1748 "SemCalling.puma"
   param->VAR_PARAM.intent = IntentIn;
  }
  }
   return;
yyL1:;

# line 1751 "SemCalling.puma"
  {
# line 1753 "SemCalling.puma"
   param->VAR_PARAM.intent = IntentInOut;
  }
   return;

  }
;
}

static void SetDefaultLayout
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree param)
# else
(call, param)
 register tTree call;
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
# line 1764 "SemCalling.puma"
 {
  int model;
  {
# line 1766 "SemCalling.puma"

# line 1768 "SemCalling.puma"
 model = HPF_GLOBAL;

     if (IsLocalCall (call))  model = HPF_LOCAL;
     if (IsSerialCall (call)) model = HPF_SERIAL;
   
# line 1774 "SemCalling.puma"
   param->VAR_PARAM.layout = GetLayout (IsF77Call (call), model);
  }
   return;
 }

  }
;
}

static void SetDefaultPassBy
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree param)
# else
(call, param)
 register tTree call;
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
# line 1785 "SemCalling.puma"
  {
# line 1787 "SemCalling.puma"
   if (! ((IsF77Call (call)))) goto yyL1;
  {
# line 1789 "SemCalling.puma"
   param->VAR_PARAM.pass_by = kDATA_PASS_BY;
  }
  }
   return;
yyL1:;

# line 1792 "SemCalling.puma"
  {
# line 1794 "SemCalling.puma"
   param->VAR_PARAM.pass_by = kHPF_HANDLE_PASS_BY;
  }
   return;

  }
;
}

static void PrintParamVals
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
# line 1805 "SemCalling.puma"

char str_layout [20];
char str_pass   [20];
char msg[120];

  if (params->Kind == kBTP_LIST) {
# line 1811 "SemCalling.puma"
  {
# line 1813 "SemCalling.puma"
   PrintParamVals (params->BTP_LIST.Elem);
# line 1814 "SemCalling.puma"
   PrintParamVals (params->BTP_LIST.Next);
  }
   return;

  }
  if (params->Kind == kVAR_PARAM) {
# line 1817 "SemCalling.puma"
  {
# line 1819 "SemCalling.puma"
 if (params->VAR_PARAM.layout == kDEFAULT_LAYOUT)
        sprintf (str_layout, "default");
      else if (params->VAR_PARAM.layout == kHPF_GLOBAL_LAYOUT)
        sprintf (str_layout, "hpf_global_array");
      else if (params->VAR_PARAM.layout == kHPF_LOCAL_LAYOUT)
        sprintf (str_layout, "hpf_local_array");
      else if (params->VAR_PARAM.layout == kHPF_SERIAL_LAYOUT)
        sprintf (str_layout, "hpf_serial_array");
      else if (params->VAR_PARAM.layout == kF77_LOCAL_LAYOUT)
        sprintf (str_layout, "f77_local_array");
      else if (params->VAR_PARAM.layout == kF77_SERIAL_LAYOUT)
        sprintf (str_layout, "f77_serial_array");
      else
        sprintf (str_layout, "unknown");

     if (params->VAR_PARAM.pass_by == kDEFAULT_PASS_BY)
        sprintf (str_pass, "default");
      else if (params->VAR_PARAM.pass_by == kDATA_PASS_BY)
        sprintf (str_pass, "data");
      else if (params->VAR_PARAM.pass_by == kHPF_HANDLE_PASS_BY)
        sprintf (str_pass, "handle");
      else
        sprintf (str_pass, "unknown");

     sprintf (msg, "argument (intent=%d,layout=%s,pass_by=%s) : ",
                    params->VAR_PARAM.intent, str_layout, str_pass);
     tree_protocol (msg, params);
   
  }
   return;

  }
;
}

void BeginSemCalling ()
{
}

void CloseSemCalling ()
{
}
