# include "Selection.h"
# include "yySelection.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 23 "Selection.puma"


# include <string.h>

# include "protocol.h"
# include "Tree.h"
# include "Idents.h"
# include "StringMem.h"
# include "TreeOps.h"
# include "Expressions.h"

# define MODULE "Selection"



static void yyExit () { Exit (1); }

void (* Selection_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Selection, routine %s failed\n", yyFunction);
 Selection_Exit ();
}

bool ShouldBeInterchanged ARGS((tTree loop1, tTree loop2));
static bool IsNoVectorLoop ARGS((tTree loop));
void CodeParallelLoop ARGS((tTree t));
static bool NoVars ARGS((tTree varlist));
static int GetLoopCount ARGS((tTree range));

bool ShouldBeInterchanged
# if defined __STDC__ | defined __cplusplus
(register tTree loop1, register tTree loop2)
# else
(loop1, loop2)
 register tTree loop1;
 register tTree loop2;
# endif
{
# line 46 "Selection.puma"
  {
# line 48 "Selection.puma"
   if (! ((vectorization))) goto yyL1;
  {
# line 49 "Selection.puma"
   if (! ((IsNoVectorLoop (loop2)))) goto yyL1;
  {
# line 50 "Selection.puma"
   if (! ((! IsNoVectorLoop (loop1)))) goto yyL1;
  }
  }
  }
   return true;
yyL1:;

  return false;
}

static bool IsNoVectorLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 61 "Selection.puma"
  {
# line 63 "Selection.puma"
   if (! ((loop->ACF_DO.DO_DEP_INFO->INDEP_INFO.selection & kSELECT_NOVECTOR))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  return false;
}

void CodeParallelLoop
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
# line 73 "Selection.puma"
  {
# line 75 "Selection.puma"
 t->ACF_DO.DO_HOME_INFO = mNO_HOME_INFO (); 
# line 77 "Selection.puma"
   goto yyL1;
  }
yyL1:;

  }
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 80 "Selection.puma"
  {
# line 82 "Selection.puma"
   if (! ((t->ACF_DO.DO_DEP_INFO->INDEP_INFO.selection & kSELECT_CONCUR))) goto yyL2;
  {
# line 84 "Selection.puma"
 t->ACF_DO.DO_DEP_INFO = mPARDO_INFO (); 
  }
  }
   return;
yyL2:;

  }
  if (t->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
# line 87 "Selection.puma"
   return;

  }
# line 90 "Selection.puma"
  {
# line 92 "Selection.puma"
   if (! ((! vectorization))) goto yyL4;
  {
# line 94 "Selection.puma"
 t->ACF_DO.DO_DEP_INFO = mSERIAL_INFO (); 
  }
  }
   return;
yyL4:;

  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 97 "Selection.puma"
  {
# line 102 "Selection.puma"
   if (! ((NoVars (t->ACF_DO.DO_DEP_INFO->INDEP_INFO.new_vars)))) goto yyL5;
  {
# line 103 "Selection.puma"
   if (! ((NoVars (t->ACF_DO.DO_DEP_INFO->INDEP_INFO.red_vars)))) goto yyL5;
  {
# line 107 "Selection.puma"
 t->ACF_DO.DO_DEP_INFO = mVECTOR_INFO (true, t->ACF_DO.DO_DEP_INFO->INDEP_INFO.selection, GetLoopCount (t->ACF_DO.DO_RANGE), NoTree); 
  }
  }
  }
   return;
yyL5:;

# line 110 "Selection.puma"
  {
# line 117 "Selection.puma"
 t->ACF_DO.DO_DEP_INFO = mVECTOR_INFO (false, t->ACF_DO.DO_DEP_INFO->INDEP_INFO.selection, GetLoopCount (t->ACF_DO.DO_RANGE), NoTree); 
  }
   return;

  }
# line 120 "Selection.puma"
  {
# line 124 "Selection.puma"
 t->ACF_DO.DO_DEP_INFO = mSERIAL_INFO (); 
  }
   return;

  }
# line 127 "Selection.puma"
  {
# line 128 "Selection.puma"
   failure_protocol (MODULE, "CodeParallelLoop", t);
  }
   return;

;
}

static bool NoVars
# if defined __STDC__ | defined __cplusplus
(register tTree varlist)
# else
(varlist)
 register tTree varlist;
# endif
{
# line 133 "Selection.puma"
  {
# line 135 "Selection.puma"
   if (! ((varlist == NoTree))) goto yyL1;
  }
   return true;
yyL1:;

  if (varlist->Kind == kBTV_EMPTY) {
# line 138 "Selection.puma"
   return true;

  }
  return false;
}

static int GetLoopCount
# if defined __STDC__ | defined __cplusplus
(register tTree range)
# else
(range)
 register tTree range;
# endif
{
  if (range->Kind == kSLICE_EXP) {
# line 149 "Selection.puma"
 {
  bool found;
  int val;
  int str;
  {
# line 151 "Selection.puma"

# line 152 "Selection.puma"

# line 153 "Selection.puma"

# line 155 "Selection.puma"
   GetConstDifference (range->SLICE_EXP.STOP, range->SLICE_EXP.START, & found, & val);
# line 157 "Selection.puma"
   if (! ((found))) goto yyL1;
  {
# line 159 "Selection.puma"
   SliceIncrement (range, & found, & str);
# line 161 "Selection.puma"
   if (! ((found))) goto yyL1;
  {
# line 162 "Selection.puma"
   if (! ((str != 0))) goto yyL1;
  {
# line 164 "Selection.puma"
 if (str == 1)

        { if (val >= 0)
             val = val + 1;
           else
             val = 0;
        }

      else if (str > 0)

        { if (val >= 0)
             val = val / str + 1;
           else
             val = 0;
        }

      else 

        { if (val <= 0)
             val = (-val)/(- str) + 1;
           else
             val = 0;
        }

    
  }
  }
  }
  }
  {
   return val;
  }
 }
yyL1:;

  }
# line 193 "Selection.puma"
   return - 1;

}

void BeginSelection ()
{
}

void CloseSelection ()
{
}
