# include "Scatter.h"
# include "yyScatter.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 31 "Scatter.puma"


# define MODULE "Scatter"

# define MAX_INDIRECT_RANK 4
# include "Idents.h"
# include "StringMem.h"
# include "Types.h"      /* IntrFuncRed */
# include "protocol.h"

# include "MoveControl.h"          /* CountMovement */
# include "Transform.h"            /* ExpToVarParam, ConcatParams */

# include "Expressions.h"          /* MakeConstant     */

# include "Reductions.h"
# include "Distributions.h"
# include "CodeGeneral.h"
# include "CodeDescriptors.h"
# include "Dalib.h"
# include "Rank.h"
# include "TreeOps.h"
# include "Shapes.h"
# include "Nesting.h"

# define TARGET_SEC_ID 1
# define SOURCE_SEC_ID 2
# define MASK_SEC_ID   3
# define INDEX_SEC_ID  4



static void yyExit () { Exit (1); }

void (* Scatter_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Scatter, routine %s failed\n", yyFunction);
 Scatter_Exit ();
}

static tTree VarTopParam ARGS((tTree A));
static void MakeIndDefine ARGS((tTree s_id, tTree A, tTree B, tTree M, tTree indexes, tTree * yyP2, tTree * yyP1));
static void MakeScatterCall ARGS((int op, tTree A, tTree B, tTree M, tTree indexes, tTree * yyP3));
static void MakeIndexParams ARGS((tTree indexes, int nr, int snr, tTree * yyP6, tTree * yyP5, tTree * yyP4));
static tTree MakeDescriptorParam ARGS((tTree var, int nr));
static void GetScatterParams ARGS((tTree params, tTree * yyP10, tTree * yyP9, tTree * yyP8, tTree * yyP7));
static void SplitTail ARGS((tTree params, tTree * yyP12, tTree * yyP11));
tTree MakeScatterStmt ARGS((tTree call));
static bool BaseIsVar ARGS((tTree base, tTree var));
static int GetScatterOp ARGS((tTree type, tIdent name));
tTree CodeScatterStmt ARGS((tTree stmt));
tTree CodeIndShadow ARGS((tTree s));
static tTree CodeVarList ARGS((tTree vars, tTree params));
static tTree DalibScheduleId ARGS((int id));

static tTree VarTopParam
# if defined __STDC__ | defined __cplusplus
(register tTree A)
# else
(A)
 register tTree A;
# endif
{
  if (A->Kind == kINDEXED_VAR) {
# line 70 "Scatter.puma"
   return VarTopParam (A->INDEXED_VAR.IND_VAR);

  }
  if (A->Kind == kUSED_VAR) {
# line 75 "Scatter.puma"
   return MakeTopologyParam (GetTopologyObj (A->USED_VAR.VARNAME->VAR_OBJ.Object));

  }
 yyAbort ("VarTopParam");
}

static void MakeIndDefine
# if defined __STDC__ | defined __cplusplus
(register tTree s_id, register tTree A, register tTree B, register tTree M, register tTree indexes, register tTree * yyP2, register tTree * yyP1)
# else
(s_id, A, B, M, indexes, yyP2, yyP1)
 register tTree s_id;
 register tTree A;
 register tTree B;
 register tTree M;
 register tTree indexes;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
# line 92 "Scatter.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree call;
  tTree param;
  tTree pre1;
  tTree post1;
  {
# line 94 "Scatter.puma"
   MakeIndexParams (indexes, TreeRank (B), INDEX_SEC_ID, & yyV1, & yyV2, & yyV3);
# line 97 "Scatter.puma"
   yyV2 = CompleteBTPs (yyV2);
# line 99 "Scatter.puma"

# line 100 "Scatter.puma"

# line 101 "Scatter.puma"

# line 102 "Scatter.puma"

# line 104 "Scatter.puma"
 if (M != NoTree)

       {  MakeIndexParams (M, 1, MASK_SEC_ID, &pre1, &param, &post1);
          yyV1 = CombineACF (yyV1, pre1);
          yyV3 = CombineACF (post1, yyV3);
          yyV2 = CombineBTP (param, yyV2); 
       }

      else

          yyV2 = mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), 
                        mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), yyV2));

     MakeIndexParams (B, 1, TARGET_SEC_ID, &pre1, &param, &post1);
     yyV1 = CombineACF (yyV1, pre1);
     yyV3 = CombineACF (post1, yyV3);
     yyV2 = CombineBTP (param, yyV2); 

     MakeIndexParams (A, 1, SOURCE_SEC_ID, &pre1, &param, &post1);
     yyV1 = CombineACF (yyV1, pre1);
     yyV3 = CombineACF (post1, yyV3);
     yyV2 = CombineBTP (param, yyV2); 

     yyV2 = mBTP_LIST (s_id, yyV2);

     call = mPROC_OBJ (MakeDalibId ("inspector_get"));

     call = mACF_BASIC (mCALL_STMT (call, yyV2));
     SetACFNode (call, 0, 0);

   
  }
   * yyP2 = CombineACF (yyV1, call);
   * yyP1 = yyV3;
   return;
 }

;
}

static void MakeScatterCall
# if defined __STDC__ | defined __cplusplus
(register int op, register tTree A, register tTree B, register tTree M, register tTree indexes, register tTree * yyP3)
# else
(op, A, B, M, indexes, yyP3)
 register int op;
 register tTree A;
 register tTree B;
 register tTree M;
 register tTree indexes;
 register tTree * yyP3;
# endif
{
# line 145 "Scatter.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree call;
  tTree param;
  tTree pre1;
  tTree post1;
  {
# line 147 "Scatter.puma"
   MakeIndexParams (indexes, TreeRank (B), INDEX_SEC_ID, & yyV1, & yyV2, & yyV3);
# line 150 "Scatter.puma"
   yyV2 = CompleteBTPs (yyV2);
# line 152 "Scatter.puma"

# line 153 "Scatter.puma"

# line 154 "Scatter.puma"

# line 155 "Scatter.puma"

# line 157 "Scatter.puma"
 if (M != NoTree)
 
       {  MakeIndexParams (M, 1, MASK_SEC_ID, &pre1, &param, &post1);
          yyV1 = CombineACF (yyV1, pre1);
          yyV3 = CombineACF (post1, yyV3);
          yyV2 = CombineBTP (param, yyV2);
       }
 
      else
 
          yyV2 = mBTP_LIST (mNO_PARAM (kDUMMY_TYPE),
                        mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), yyV2));
 
     MakeIndexParams (B, 1, TARGET_SEC_ID, &pre1, &param, &post1);
     yyV1 = CombineACF (yyV1, pre1);
     yyV3 = CombineACF (post1, yyV3);
     yyV2 = CombineBTP (param, yyV2);
 
     MakeIndexParams (A, 1, SOURCE_SEC_ID, &pre1, &param, &post1);

     yyV1 = CombineACF (yyV1, pre1);
     yyV3 = CombineACF (post1, yyV3);
     yyV2 = CombineBTP (param, yyV2);
 
     yyV2 = mBTP_LIST (ExpToVarParam (MakeConstant (op)), yyV2);
 
     call = mPROC_OBJ (MakeDalibId ("scatter"));
 
     call = mACF_BASIC (mCALL_STMT (call, yyV2));
     SetACFNode (call, 0, 0);
 
   
  }
   * yyP3 = CombineACF (CombineACF (yyV1, call), yyV3);
   return;
 }

;
}

static void MakeIndexParams
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int nr, register int snr, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(indexes, nr, snr, yyP6, yyP5, yyP4)
 register tTree indexes;
 register int nr;
 register int snr;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
  if (indexes->Kind == kBTP_LIST) {
# line 200 "Scatter.puma"
  {
# line 201 "Scatter.puma"
   if (! ((nr == 0))) goto yyL1;
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;
yyL1:;

# line 204 "Scatter.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 208 "Scatter.puma"
   MakeIndexParams (indexes->BTP_LIST.Elem, nr, snr, & yyV1, & yyV2, & yyV3);
# line 209 "Scatter.puma"
   MakeIndexParams (indexes->BTP_LIST.Next, nr - 1, snr + 1, & yyV4, & yyV5, & yyV6);
  }
   * yyP6 = CombineACF (yyV1, yyV4);
   * yyP5 = CombineBTP (yyV2, yyV5);
   * yyP4 = CombineACF (yyV3, yyV6);
   return;
 }

  }
  if (indexes->Kind == kBTP_EMPTY) {
# line 212 "Scatter.puma"
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;

  }
  if (indexes->Kind == kNO_PARAM) {
# line 215 "Scatter.puma"
 {
  tTree params;
  {
# line 217 "Scatter.puma"

# line 218 "Scatter.puma"
   params = mBTP_LIST (indexes, mBTP_LIST (indexes, NoTree));
  }
   * yyP6 = NoTree;
   * yyP5 = params;
   * yyP4 = NoTree;
   return;
 }

  }
  if (indexes->Kind == kVAR_PARAM) {
  if (indexes->VAR_PARAM.V->Kind == kADDR) {
# line 221 "Scatter.puma"
 {
  tTree params;
  {
# line 223 "Scatter.puma"

# line 224 "Scatter.puma"
   params = mBTP_LIST (indexes, mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), NoTree));
  }
   * yyP6 = NoTree;
   * yyP5 = params;
   * yyP4 = NoTree;
   return;
 }

  }
# line 227 "Scatter.puma"
 {
  tTree params;
  {
# line 229 "Scatter.puma"
   if (! ((TreeRank (indexes->VAR_PARAM.V) == 0))) goto yyL6;
  {
# line 230 "Scatter.puma"
   if (! ((TreeReadDistribution (indexes) == 0))) goto yyL6;
  {
# line 232 "Scatter.puma"

# line 233 "Scatter.puma"
   params = mBTP_LIST (indexes, mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), NoTree));
  }
  }
  }
   * yyP6 = NoTree;
   * yyP5 = params;
   * yyP4 = NoTree;
   return;
 }
yyL6:;

# line 236 "Scatter.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 238 "Scatter.puma"
   MakeIndexParams (indexes->VAR_PARAM.V, nr, snr, & yyV1, & yyV2, & yyV3);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

  }
  if (indexes->Kind == kINDEXED_VAR) {
# line 241 "Scatter.puma"
 {
  tTree pre;
  tTree post;
  tTree params;
  {
# line 243 "Scatter.puma"

# line 244 "Scatter.puma"

# line 245 "Scatter.puma"

# line 247 "Scatter.puma"
   DalibSectionTranslation (snr, indexes, & pre, & params, & post);
# line 248 "Scatter.puma"
   params = mBTP_LIST (mVAR_PARAM (FirstArrayElement (indexes)), mBTP_LIST (params, NoTree));
  }
   * yyP6 = pre;
   * yyP5 = params;
   * yyP4 = post;
   return;
 }

  }
# line 252 "Scatter.puma"
  {
# line 254 "Scatter.puma"
   failure_protocol (MODULE, "MakeIndexParams", indexes);
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;

;
}

static tTree MakeDescriptorParam
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int nr)
# else
(var, nr)
 register tTree var;
 register int nr;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 268 "Scatter.puma"
   return mVAR_PARAM (MakeUsedVarA (TreeVarName (var->USED_VAR.VARNAME), "_DSP"));

  }
  if (var->Kind == kINDEXED_VAR) {
# line 273 "Scatter.puma"
  {
# line 275 "Scatter.puma"
   if (! ((IsWholeVar (var)))) goto yyL2;
  }
   return mVAR_PARAM (MakeUsedVarA (TreeVarName (var->INDEXED_VAR.IND_VAR), "_DSP"));
yyL2:;

# line 280 "Scatter.puma"
   return DalibSectionDescriptor (nr);

  }
# line 285 "Scatter.puma"
  {
# line 287 "Scatter.puma"
   failure_protocol (MODULE, "MakeDescriptorParam", var);
  }
   return NoTree;

}

static void GetScatterParams
# if defined __STDC__ | defined __cplusplus
(register tTree params, register tTree * yyP10, register tTree * yyP9, register tTree * yyP8, register tTree * yyP7)
# else
(params, yyP10, yyP9, yyP8, yyP7)
 register tTree params;
 register tTree * yyP10;
 register tTree * yyP9;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 299 "Scatter.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 302 "Scatter.puma"
   SplitTail (params->BTP_LIST.Next->BTP_LIST.Next, & yyV1, & yyV2);
  }
   * yyP10 = params->BTP_LIST.Elem->VAR_PARAM.V;
   * yyP9 = params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V;
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }

  }
  }
  }
  }
# line 305 "Scatter.puma"
  {
# line 307 "Scatter.puma"
   failure_protocol (MODULE, "GetScatterParams", params);
  }
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

;
}

static void SplitTail
# if defined __STDC__ | defined __cplusplus
(register tTree params, register tTree * yyP12, register tTree * yyP11)
# else
(params, yyP12, yyP11)
 register tTree params;
 register tTree * yyP12;
 register tTree * yyP11;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 318 "Scatter.puma"
 {
  tTree save_mask;
  {
# line 320 "Scatter.puma"

# line 321 "Scatter.puma"
 save_mask = params->BTP_LIST.Next->BTP_LIST.Elem;
      params->BTP_LIST.Next = params->BTP_LIST.Next->BTP_LIST.Next;          
    
  }
   * yyP12 = params;
   * yyP11 = save_mask;
   return;
 }

  }
  }
# line 326 "Scatter.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 328 "Scatter.puma"
   SplitTail (params->BTP_LIST.Next, & yyV1, & yyV2);
  }
   * yyP12 = params;
   * yyP11 = yyV2;
   return;
 }

  }
# line 331 "Scatter.puma"
  {
# line 333 "Scatter.puma"
   failure_protocol (MODULE, "SplitTail scatter params", params);
  }
   * yyP12 = NoTree;
   * yyP11 = NoTree;
   return;

;
}

tTree MakeScatterStmt
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kACF_BASIC) {
  if (call->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (call->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 346 "Scatter.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 349 "Scatter.puma"
   GetScatterParams (call->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2, & yyV3, & yyV4);
# line 353 "Scatter.puma"
 if (!BaseIsVar (yyV2, call->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR))
         error_protocol ("base of scatter must be lhs var");

      call->ACF_BASIC.BASIC_STMT = mSCATTER_STMT (call->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, yyV1, yyV2, yyV3, yyV4);

    
  }
  {
   return call;
  }
 }

  }
  }
  }
# line 363 "Scatter.puma"
  {
# line 364 "Scatter.puma"
   failure_protocol (MODULE, "MakeScatterStmt", call);
  }
   return NoTree;

}

static bool BaseIsVar
# if defined __STDC__ | defined __cplusplus
(register tTree base, register tTree var)
# else
(base, var)
 register tTree base;
 register tTree var;
# endif
{
  if (base->Kind == kINDEXED_VAR) {
  if (var->Kind == kINDEXED_VAR) {
# line 370 "Scatter.puma"
  {
# line 372 "Scatter.puma"
   if (! ((TreeVarName (base->INDEXED_VAR.IND_VAR) == TreeVarName (var->INDEXED_VAR.IND_VAR)))) goto yyL1;
  {
# line 373 "Scatter.puma"
   if (! ((EqualIndexes (base->INDEXED_VAR.IND_EXPS, var->INDEXED_VAR.IND_EXPS)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  }
  return false;
}

static int GetScatterOp
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tIdent name)
# else
(type, name)
 register tTree type;
 register tIdent name;
# endif
{
# line 384 "Scatter.puma"

char str[100];

# line 388 "Scatter.puma"
  {
# line 390 "Scatter.puma"
   if (! ((name == MakeIdent ("COPY_SCATTER", 12)))) goto yyL1;
  }
   return 0;
yyL1:;

# line 394 "Scatter.puma"
  {
# line 398 "Scatter.puma"
   GetString (name, str);
  }
   return GetGlobalOp (type, MakeIdent (str, strlen (str) - 8));

}

tTree CodeScatterStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kSCATTER_STMT) {
# line 410 "Scatter.puma"
 {
  tTree stmtlist;
  tTree s_id;
  tTree size;
  tTree free_dsp;
  tTree params;
  tTree call;
  int nop;
  {
# line 412 "Scatter.puma"
   if (! ((stmt->SCATTER_STMT.func == MakeIdent ("GET_SCATTER", 11)))) goto yyL1;
  {
# line 414 "Scatter.puma"

# line 415 "Scatter.puma"

# line 416 "Scatter.puma"

# line 417 "Scatter.puma"

# line 418 "Scatter.puma"

# line 419 "Scatter.puma"

# line 420 "Scatter.puma"

# line 422 "Scatter.puma"
 s_id = mVAR_PARAM (MakeUsedVarAn (MakeIdent ("IS",2), "_", 1));
     DefineNewIntVar (TreeVarName (s_id));
 
     size = MakeTreeSizeParam (stmt->SCATTER_STMT.BASE);
 
     
 
     params = mBTP_LIST (s_id, mBTP_EMPTY());
     call   = mPROC_OBJ (MakeDalibId ("inspector_release"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
     SetACFNode (call, 0, 0);
     stmtlist = mACF_LIST (call, NoTree);
 
     
 
     params = mBTP_EMPTY();
     params = mBTP_LIST (MakeDescriptorParam(stmt->SCATTER_STMT.ARRAY, SOURCE_SEC_ID), params);
     params = mBTP_LIST (s_id, params);
     call   = mPROC_OBJ (MakeDalibId ("executor_gather_recv"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
     SetACFNode (call, 0, 0);
     stmtlist = mACF_LIST (call, stmtlist);
 
     
 
     params = mBTP_EMPTY();
     params = mBTP_LIST (MakeDescriptorParam(stmt->SCATTER_STMT.BASE, TARGET_SEC_ID), params);
     params = mBTP_LIST (s_id, params);
     call   = mPROC_OBJ (MakeDalibId ("executor_gather_send"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
     SetACFNode (call, 0, 0);
     stmtlist = mACF_LIST (call, stmtlist);
 
     
 
     MakeIndDefine (s_id, stmt->SCATTER_STMT.ARRAY, stmt->SCATTER_STMT.BASE, stmt->SCATTER_STMT.MASK, stmt->SCATTER_STMT.INDEXES, &call, &free_dsp);
     stmtlist = CombineACF (call, stmtlist);
     stmtlist = CombineACF (stmtlist, free_dsp);
 
   
  }
  }
  {
   return stmtlist;
  }
 }
yyL1:;

# line 466 "Scatter.puma"
 {
  tTree stmtlist;
  int nop;
  {
# line 470 "Scatter.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  {
# line 474 "Scatter.puma"

# line 475 "Scatter.puma"

# line 477 "Scatter.puma"
 nop = GetScatterOp (TreeType (stmt->SCATTER_STMT.BASE), stmt->SCATTER_STMT.func);

     MakeScatterCall (nop, stmt->SCATTER_STMT.ARRAY, stmt->SCATTER_STMT.BASE, stmt->SCATTER_STMT.MASK, stmt->SCATTER_STMT.INDEXES, &stmtlist);

   
  }
  }
  {
   return stmtlist;
  }
 }
yyL2:;

# line 486 "Scatter.puma"
 {
  tTree stmtlist;
  tTree s_id;
  tTree size;
  tTree free_dsp;
  tTree params;
  tTree call;
  int nop;
  {
# line 490 "Scatter.puma"

# line 491 "Scatter.puma"

# line 492 "Scatter.puma"

# line 493 "Scatter.puma"

# line 494 "Scatter.puma"

# line 495 "Scatter.puma"

# line 496 "Scatter.puma"

# line 498 "Scatter.puma"
 s_id = mVAR_PARAM (MakeUsedVarAn (MakeIdent ("IS",2), "_", 1));
     DefineNewIntVar (TreeVarName (s_id));

     size = MakeTreeSizeParam (stmt->SCATTER_STMT.BASE);

     

     params = mBTP_LIST (s_id, mBTP_EMPTY());
     call   = mPROC_OBJ (MakeDalibId ("inspector_release"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
     SetACFNode (call, 0, 0);
     stmtlist = mACF_LIST (call, NoTree);

     

     nop = GetScatterOp (TreeType (stmt->SCATTER_STMT.BASE), stmt->SCATTER_STMT.func);

     params = mBTP_EMPTY();
     params = mBTP_LIST (MakeDescriptorParam(stmt->SCATTER_STMT.BASE, TARGET_SEC_ID), params);
     params = mBTP_LIST (ExpToVarParam (MakeConstant(nop)), params);
     params = mBTP_LIST (s_id, params);
     call   = mPROC_OBJ (MakeDalibId ("executor_scatter_recv"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
     SetACFNode (call, 0, 0);
     stmtlist = mACF_LIST (call, stmtlist);

     

     params = mBTP_EMPTY();
     params = mBTP_LIST (MakeDescriptorParam(stmt->SCATTER_STMT.ARRAY, SOURCE_SEC_ID), params);
     params = mBTP_LIST (s_id, params);
     call   = mPROC_OBJ (MakeDalibId ("executor_scatter_send"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
     SetACFNode (call, 0, 0);
     stmtlist = mACF_LIST (call, stmtlist);

     

     MakeIndDefine (s_id, stmt->SCATTER_STMT.ARRAY, stmt->SCATTER_STMT.BASE, stmt->SCATTER_STMT.MASK, stmt->SCATTER_STMT.INDEXES, &call, &free_dsp);
     stmtlist = CombineACF (call, stmtlist);
     stmtlist = CombineACF (stmtlist, free_dsp);

   
  }
  {
   return stmtlist;
  }
 }

  }
# line 545 "Scatter.puma"
  {
# line 546 "Scatter.puma"
   failure_protocol (MODULE, "CodeScatterStmt", stmt);
  }
   return NoTree;

}

tTree CodeIndShadow
# if defined __STDC__ | defined __cplusplus
(register tTree s)
# else
(s)
 register tTree s;
# endif
{
  if (s->Kind == kIND_SHADOW_CREATE) {
# line 570 "Scatter.puma"
 {
  tTree call;
  tTree param;
  tTree params;
  {
# line 572 "Scatter.puma"

# line 573 "Scatter.puma"

# line 574 "Scatter.puma"

# line 576 "Scatter.puma"
   params = mBTP_EMPTY ();
# line 577 "Scatter.puma"
   params = CodeVarList (s->IND_SHADOW_CREATE.MASK, params);
# line 578 "Scatter.puma"
   params = CodeVarList (s->IND_SHADOW_CREATE.INDEX_VAR, params);
# line 579 "Scatter.puma"
   params = CodeVarList (s->IND_SHADOW_CREATE.TMP_INDEX_VAR, params);
# line 580 "Scatter.puma"
   params = CodeVarList (s->IND_SHADOW_CREATE.SHADOW_VAR, params);
# line 581 "Scatter.puma"
   param = DalibScheduleId (s->IND_SHADOW_CREATE.id);
# line 582 "Scatter.puma"
   params = mBTP_LIST (param, params);
# line 583 "Scatter.puma"
   call = mPROC_OBJ (MakeDalibId ("insp_shadow_get"));
# line 584 "Scatter.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
  {
   return call;
  }
 }

  }
  if (s->Kind == kIND_SHADOW_FREE) {
# line 589 "Scatter.puma"
 {
  tTree call;
  tTree param;
  tTree params;
  {
# line 591 "Scatter.puma"

# line 592 "Scatter.puma"

# line 593 "Scatter.puma"

# line 595 "Scatter.puma"
   params = mBTP_EMPTY ();
# line 596 "Scatter.puma"
   params = CodeVarList (s->IND_SHADOW_FREE.INDEX_VAR, params);
# line 597 "Scatter.puma"
   param = DalibScheduleId (s->IND_SHADOW_FREE.id);
# line 598 "Scatter.puma"
   params = mBTP_LIST (param, params);
# line 599 "Scatter.puma"
   call = mPROC_OBJ (MakeDalibId ("insp_shadow_release"));
# line 600 "Scatter.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
  {
   return call;
  }
 }

  }
  if (s->Kind == kIND_SHADOW_GET) {
# line 605 "Scatter.puma"
 {
  tTree call;
  tTree params;
  tTree param;
  {
# line 607 "Scatter.puma"

# line 608 "Scatter.puma"

# line 609 "Scatter.puma"

# line 611 "Scatter.puma"
   params = mBTP_EMPTY ();
# line 612 "Scatter.puma"
   params = mBTP_LIST (MakeDescriptorParam (s->IND_SHADOW_GET.SHADOW_VAR, 0), params);
# line 613 "Scatter.puma"
   param = DalibScheduleId (s->IND_SHADOW_GET.id);
# line 614 "Scatter.puma"
   params = mBTP_LIST (param, params);
# line 615 "Scatter.puma"
   call = mPROC_OBJ (MakeDalibId ("exec_shadow_get"));
# line 616 "Scatter.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
  {
   return call;
  }
 }

  }
  if (s->Kind == kIND_SHADOW_SET) {
# line 621 "Scatter.puma"
 {
  tTree call;
  tTree params;
  tTree param;
  {
# line 623 "Scatter.puma"

# line 624 "Scatter.puma"

# line 625 "Scatter.puma"

# line 627 "Scatter.puma"
   params = mBTP_EMPTY ();
# line 628 "Scatter.puma"
   params = mBTP_LIST (ExpToVarParam (s->IND_SHADOW_SET.VAL), params);
# line 629 "Scatter.puma"
   params = mBTP_LIST (MakeDescriptorParam (s->IND_SHADOW_SET.SHADOW_VAR, 0), params);
# line 630 "Scatter.puma"
   param = DalibScheduleId (s->IND_SHADOW_SET.id);
# line 631 "Scatter.puma"
   params = mBTP_LIST (param, params);
# line 632 "Scatter.puma"
   call = mPROC_OBJ (MakeDalibId ("exec_shadow_set"));
# line 633 "Scatter.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
  {
   return call;
  }
 }

  }
  if (s->Kind == kIND_SHADOW_PUT) {
# line 638 "Scatter.puma"
 {
  tTree call;
  tTree params;
  tTree param;
  {
# line 640 "Scatter.puma"

# line 641 "Scatter.puma"

# line 642 "Scatter.puma"

# line 644 "Scatter.puma"
   params = mBTP_EMPTY ();
# line 645 "Scatter.puma"
   params = mBTP_LIST (ExpToVarParam (MakeConstant (s->IND_SHADOW_PUT.op)), params);
# line 646 "Scatter.puma"
   params = mBTP_LIST (MakeDescriptorParam (s->IND_SHADOW_PUT.SHADOW_VAR, 0), params);
# line 647 "Scatter.puma"
   param = DalibScheduleId (s->IND_SHADOW_PUT.id);
# line 648 "Scatter.puma"
   params = mBTP_LIST (param, params);
# line 649 "Scatter.puma"
   call = mPROC_OBJ (MakeDalibId ("exec_shadow_put"));
# line 650 "Scatter.puma"
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
  {
   return call;
  }
 }

  }
# line 655 "Scatter.puma"
  {
# line 657 "Scatter.puma"
   failure_protocol (MODULE, "CodeIndShadow", s);
  }
   return NoTree;

}

static tTree CodeVarList
# if defined __STDC__ | defined __cplusplus
(register tTree vars, register tTree params)
# else
(vars, params)
 register tTree vars;
 register tTree params;
# endif
{
  if (vars->Kind == kBTV_EMPTY) {
# line 670 "Scatter.puma"
   return params;

  }
  if (vars->Kind == kBTV_LIST) {
# line 675 "Scatter.puma"
   return CodeVarList (vars->BTV_LIST.Elem, CodeVarList (vars->BTV_LIST.Next, params));

  }
  if (vars->Kind == kDUMMY_VAR) {
# line 680 "Scatter.puma"
   return mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), mBTP_LIST (mNO_PARAM (kDUMMY_TYPE), params));

  }
# line 686 "Scatter.puma"
 {
  tTree param_data;
  tTree param_dsp;
  {
# line 688 "Scatter.puma"

# line 689 "Scatter.puma"

# line 691 "Scatter.puma"
   param_dsp = mVAR_PARAM (MakeUsedVarA (TreeVarName (vars), "_DSP"));
# line 692 "Scatter.puma"
   param_data = mVAR_PARAM (FirstArrayElement (vars));
  }
  {
   return mBTP_LIST (param_data, mBTP_LIST (param_dsp, params));
  }
 }

}

static tTree DalibScheduleId
# if defined __STDC__ | defined __cplusplus
(register int id)
# else
(id)
 register int id;
# endif
{
# line 705 "Scatter.puma"
 {
  tTree var;
  {
# line 707 "Scatter.puma"

# line 709 "Scatter.puma"
   var = MakeUsedVarAn (IsIdent ("S"), "_ID", id);
# line 710 "Scatter.puma"
   DefineNewIntVar (TreeVarName (var));
  }
  {
   return mVAR_PARAM (var);
  }
 }

}

void BeginScatter ()
{
}

void CloseScatter ()
{
}
