# include "SMParallel.h"
# include "yySMParallel.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 25 "SMParallel.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Types.h"
# include "Transform.h"      /* CombineACF, CombineBTV, ... */
# include "Traverse.h"       /* ReplaceAST                  */
# include "VarDescriptor.h"  /* SetVarDescriptor            */

# define MODULE "SMParallel"

static tTree new_vars;       /* used globally to collect local vars */
static int   par_loops;      /* nest depth of parallel loops        */

static tTree global_reduction;

# define MAX_PAR_LOOPS 1     /* maximal nesting of parallel loops   */

static tTree local1, local2, global;



static void yyExit () { Exit (1); }

void (* SMParallel_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SMParallel, routine %s failed\n", yyFunction);
 SMParallel_Exit ();
}

static bool IsSMParallelLoop ARGS((tTree t));
void FindSMParallel ARGS((tTree t));
static bool StopFind ARGS((tTree t));
static tTree FindPARALLEL ARGS((tTree t));
static bool DoItParallel ARGS((tTree t));
static void SetItParallel ARGS((tTree t));
static bool IsDistributedId ARGS((tTree home_var, tTree id));
void MakeSMParallel ARGS((tTree t));
static bool StopPARALLEL ARGS((tTree t));
static tTree TranslatePARALLEL ARGS((tTree t));
tTree MakeParallel ARGS((tTree t));
static tTree TranslateParBody ARGS((tTree t));
static bool StopTranslation ARGS((tTree t));
static tTree DoTranslation ARGS((tTree t));
static void MakeLocalLoopVar ARGS((tTree t));
static tTree ApplySMReduction ARGS((tTree reduction, tTree stmts));
static bool StopREDUCTION ARGS((tTree t));
static tTree TranslateREDUCTION ARGS((tTree t));
static tTree GetRedVar ARGS((tTree t));
void AutoScope ARGS((tTree t));
static void AddSharedVariable ARGS((tTree t));
tTree FinalSM ARGS((tTree t));

static bool IsSMParallelLoop
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 61 "SMParallel.puma"
  {
# line 63 "SMParallel.puma"
   if (! ((t->ACF_DO.DO_DEP_INFO->INDEP_INFO.selection & kSELECT_CONCUR))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  return false;
}

void FindSMParallel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 76 "SMParallel.puma"
  {
# line 78 "SMParallel.puma"
   if (! ((sm_parallelization))) goto yyL1;
  {
# line 80 "SMParallel.puma"
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopFind, FindPARALLEL); 
  }
  }
   return;
yyL1:;

# line 83 "SMParallel.puma"
   return;

  }
# line 86 "SMParallel.puma"
  {
# line 87 "SMParallel.puma"
   failure_protocol (MODULE, "FindSMParallel", t);
  }
   return;

;
}

static bool StopFind
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
# line 101 "SMParallel.puma"
   return true;

  }
  return false;
}

static tTree FindPARALLEL
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
# line 114 "SMParallel.puma"
  {
# line 116 "SMParallel.puma"
   if (! ((DoItParallel (t)))) goto yyL1;
  {
# line 118 "SMParallel.puma"
   SetItParallel (t);
  }
  }
   return t;
yyL1:;

# line 123 "SMParallel.puma"
  {
# line 127 "SMParallel.puma"
 t->ACF_DO.DO_BODY = ReplaceAST (t->ACF_DO.DO_BODY, StopFind, FindPARALLEL); 
  }
   return t;

  }
# line 132 "SMParallel.puma"
   return t;

}

static bool DoItParallel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 147 "SMParallel.puma"
  {
# line 149 "SMParallel.puma"
   if (! ((sm_parallelization))) goto yyL1;
  {
# line 150 "SMParallel.puma"
   if (! ((t->ACF_DO.DO_DEP_INFO->INDEP_INFO.user_independent))) goto yyL1;
  {
# line 152 "SMParallel.puma"
   tree_protocol ("INDEPENDEDNT loop will be used for SM parallelism :\n", t);
  }
  }
  }
   return true;
yyL1:;

  }
  if (t->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
# line 155 "SMParallel.puma"
  {
# line 157 "SMParallel.puma"
   if (! ((sm_parallelization))) goto yyL2;
  {
# line 158 "SMParallel.puma"
   if (! ((IsDistributedId (t->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var, t->ACF_DO.DO_ID)))) goto yyL2;
  {
# line 160 "SMParallel.puma"
   tree_protocol ("DO loop over distributed dimension will be used for SM parallelism :\n", t);
  }
  }
  }
   return true;
yyL2:;

  }
  }
# line 164 "SMParallel.puma"
  {
# line 165 "SMParallel.puma"
   tree_protocol ("DO loop not used for SM parallelism :\n", t);
# line 166 "SMParallel.puma"
   return false;
  }

}

static void SetItParallel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 179 "SMParallel.puma"
  {
# line 181 "SMParallel.puma"
 t->ACF_DO.DO_DEP_INFO->INDEP_INFO.selection = 1; 
  }
   return;

  }
  }
;
}

static bool IsDistributedId
# if defined __STDC__ | defined __cplusplus
(register tTree home_var, register tTree id)
# else
(home_var, id)
 register tTree home_var;
 register tTree id;
# endif
{
# line 195 "SMParallel.puma"
 {
  var_descriptor vard;
  bool found;
  int topdim;
  tTree val;
  {
# line 197 "SMParallel.puma"

# line 198 "SMParallel.puma"

# line 199 "SMParallel.puma"

# line 200 "SMParallel.puma"

# line 202 "SMParallel.puma"
   SetVarDescriptor (home_var, & vard);
# line 204 "SMParallel.puma"
 found  = false;
     topdim = 0;

     while ((!found) && (topdim < vard.topology_rank))

       { val= vard.on_val[topdim];

         if (val != NoTree)
            found = IsVarInExp (TreeVarName (id), val);

         topdim += 1;
       }

     

   
# line 221 "SMParallel.puma"
   if (! ((found))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

void MakeSMParallel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 237 "SMParallel.puma"
  {
# line 239 "SMParallel.puma"
   tree_protocol ("body before SM parallelism : \n", t->BODY_NODE.STATS);
# line 241 "SMParallel.puma"
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopPARALLEL, TranslatePARALLEL); 
# line 243 "SMParallel.puma"
   tree_protocol ("body after SM parallelism : \n", t->BODY_NODE.STATS);
  }
   return;

  }
# line 246 "SMParallel.puma"
  {
# line 247 "SMParallel.puma"
   failure_protocol (MODULE, "MakeSMParallel", t);
  }
   return;

;
}

static bool StopPARALLEL
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
# line 260 "SMParallel.puma"
  {
# line 262 "SMParallel.puma"
   if (! ((IsSMParallelLoop (t)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  return false;
}

static tTree TranslatePARALLEL
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
# line 273 "SMParallel.puma"
 {
  tTree new;
  {
# line 275 "SMParallel.puma"
   if (! ((IsSMParallelLoop (t)))) goto yyL1;
  {
# line 277 "SMParallel.puma"

# line 279 "SMParallel.puma"
   new = MakeParallel (t);
# line 281 "SMParallel.puma"
   tree_protocol ("translation of SM parallel loops :\n", new);
  }
  }
  {
   return new;
  }
 }
yyL1:;

  }
  if (t->Kind == kACF_NEW) {
# line 286 "SMParallel.puma"
   return t->ACF_NEW.NEW_BODY;

  }
  if (t->Kind == kACF_REDUCTION) {
# line 291 "SMParallel.puma"
  {
# line 293 "SMParallel.puma"
   if (! ((sm_parallelization == NO_MP))) goto yyL3;
  }
   return t->ACF_REDUCTION.REDUCTION_BODY;
yyL3:;

# line 298 "SMParallel.puma"
   return ApplySMReduction (t, t->ACF_REDUCTION.REDUCTION_BODY);

  }
# line 303 "SMParallel.puma"
   return t;

}

tTree MakeParallel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
# line 318 "SMParallel.puma"
 {
  tTree new;
  {
# line 320 "SMParallel.puma"

# line 322 "SMParallel.puma"
 new_vars  = mBTV_EMPTY ();    
     par_loops = 1;

     t->ACF_DO.DO_BODY = TranslateParBody (t->ACF_DO.DO_BODY);

     MakeLocalLoopVar (t);

     new = mACF_PARALLEL (mBTV_EMPTY(), mBTV_EMPTY (),
                          new_vars, mACF_LIST (t, mACF_EMPTY ()));

     tree_protocol ("translation of SM parallel loop : \n", new);

   
  }
  {
   return new;
  }
 }

  }
  if (t->Kind == kACF_PARALLEL) {
# line 339 "SMParallel.puma"
  {
# line 341 "SMParallel.puma"
 new_vars = t->ACF_PARALLEL.LOCAL_VARS;

     par_loops = 0;

     t->ACF_PARALLEL.PARALLEL_BODY = TranslateParBody (t->ACF_PARALLEL.PARALLEL_BODY);

     t->ACF_PARALLEL.LOCAL_VARS = new_vars;

   
  }
   return t;

  }
# line 354 "SMParallel.puma"
  {
# line 356 "SMParallel.puma"
   failure_protocol (MODULE, "MakeParallel", t);
  }
   return t;

}

static tTree TranslateParBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 367 "SMParallel.puma"
   return ReplaceAST (t, StopTranslation, DoTranslation);

}

static bool StopTranslation
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
# line 374 "SMParallel.puma"
   return true;

  }
  if (t->Kind == kACF_DO) {
# line 377 "SMParallel.puma"
  {
# line 379 "SMParallel.puma"
   if (! ((IsSMParallelLoop (t)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

static tTree DoTranslation
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_HOME) {
# line 384 "SMParallel.puma"
   return t->ACF_HOME.HOME_BODY;

  }
  if (t->Kind == kACF_NEW) {
# line 389 "SMParallel.puma"
  {
# line 391 "SMParallel.puma"
 new_vars = ConcatVars (t->ACF_NEW.NEW_VAR, new_vars); 
  }
   return t->ACF_NEW.NEW_BODY;

  }
  if (t->Kind == kACF_RESIDENT) {
# line 396 "SMParallel.puma"
   return t->ACF_RESIDENT.RESIDENT_BODY;

  }
  if (t->Kind == kACF_REDUCTION) {
# line 401 "SMParallel.puma"
   return t->ACF_REDUCTION.REDUCTION_BODY;

  }
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kPARDO_INFO) {
# line 406 "SMParallel.puma"
  {
# line 408 "SMParallel.puma"
   MakeLocalLoopVar (t);
# line 410 "SMParallel.puma"
 par_loops ++;

     t->ACF_DO.DO_BODY = TranslateParBody (t->ACF_DO.DO_BODY);

     par_loops --;

     if (par_loops >= MAX_PAR_LOOPS) t->ACF_DO.DO_DEP_INFO = mSERIAL_INFO ();

   
  }
   return t;

  }
  }
# line 423 "SMParallel.puma"
  {
# line 425 "SMParallel.puma"
   MakeLocalLoopVar (t);
  }
   return t;

}

static void MakeLocalLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
# line 432 "SMParallel.puma"
  {
# line 434 "SMParallel.puma"
 new_vars = mBTV_LIST (CopyTree(t->ACF_DO.DO_ID), new_vars); 
  }
   return;

  }
;
}

static tTree ApplySMReduction
# if defined __STDC__ | defined __cplusplus
(register tTree reduction, register tTree stmts)
# else
(reduction, stmts)
 register tTree reduction;
 register tTree stmts;
# endif
{
  if (reduction->Kind == kACF_REDUCTION) {
  if (reduction->ACF_REDUCTION.REDUCTION_VAR->Kind == kBTV_LIST) {
  if (reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next->Kind == kBTV_EMPTY) {
# line 447 "SMParallel.puma"
  {
# line 449 "SMParallel.puma"
   if (! ((TreeRank (reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem) > 0))) goto yyL1;
  {
# line 451 "SMParallel.puma"
   set_protocol_stmt (reduction);
# line 453 "SMParallel.puma"
   error_protocol ("SM reduction only for scalar variables");
# line 454 "SMParallel.puma"
   tree_protocol ("illegal reduction variable : ", reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem);
  }
  }
   return stmts;
yyL1:;

  }
  }
  }
# line 459 "SMParallel.puma"
 {
  tTree new;
  {
# line 461 "SMParallel.puma"

# line 463 "SMParallel.puma"
 global_reduction = reduction; 

     tree_protocol ("apply reduction : \n", reduction);

     new = ReplaceAST (stmts, StopREDUCTION, TranslateREDUCTION);

     tree_protocol ("result of applied reduction : \n", new);

   
  }
  {
   return new;
  }
 }

}

static bool StopREDUCTION
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
# line 486 "SMParallel.puma"
  {
# line 488 "SMParallel.puma"
   if (! ((IsSMParallelLoop (t)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kACF_PARALLEL) {
# line 491 "SMParallel.puma"
   return true;

  }
  return false;
}

static tTree TranslateREDUCTION
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_PARALLEL) {
# line 502 "SMParallel.puma"
  {
# line 504 "SMParallel.puma"
 t->ACF_PARALLEL.REDUCTION_VARS = CombineBTV (GetRedVar(global_reduction), t->ACF_PARALLEL.REDUCTION_VARS); 
  }
   return t;

  }
# line 509 "SMParallel.puma"
   return t;

}

static tTree GetRedVar
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_REDUCTION) {
# line 515 "SMParallel.puma"
   return t->ACF_REDUCTION.REDUCTION_VAR;

  }
# line 522 "SMParallel.puma"
  {
# line 524 "SMParallel.puma"
   failure_protocol (MODULE, "GetRedVar", t);
  }
   return NoTree;

}

void AutoScope
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_PARALLEL) {
# line 539 "SMParallel.puma"
  {
# line 542 "SMParallel.puma"
 local1 = t->ACF_PARALLEL.REDUCTION_VARS;
     local2 = t->ACF_PARALLEL.LOCAL_VARS;
     global = t->ACF_PARALLEL.SHARED_VARS;
   
# line 547 "SMParallel.puma"
   tree_protocol ("AutoScope : local vars = ", t->ACF_PARALLEL.LOCAL_VARS);
# line 548 "SMParallel.puma"
   tree_protocol ("AutoScope : shared vars = ", t->ACF_PARALLEL.SHARED_VARS);
# line 549 "SMParallel.puma"
   tree_protocol ("AutoScope : red vars = ", t->ACF_PARALLEL.REDUCTION_VARS);
# line 551 "SMParallel.puma"
   FullTraverseAST (t->ACF_PARALLEL.PARALLEL_BODY, AddSharedVariable);
# line 553 "SMParallel.puma"
   tree_protocol ("AutoScope : new shared vars = ", global);
# line 555 "SMParallel.puma"
 t->ACF_PARALLEL.SHARED_VARS = global; 
  }
   return;

  }
# line 558 "SMParallel.puma"
  {
# line 559 "SMParallel.puma"
   failure_protocol (MODULE, "AutoScope", t);
  }
   return;

;
}

static void AddSharedVariable
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
# line 565 "SMParallel.puma"
  {
# line 567 "SMParallel.puma"
   if (! ((t->USED_VAR.VARNAME->VAR_OBJ.Object != NoObject))) goto yyL1;
  {
# line 568 "SMParallel.puma"
   if (! ((IsVarParameter (t->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL1;
  }
  }
   return;
yyL1:;

# line 571 "SMParallel.puma"
  {
# line 573 "SMParallel.puma"
   if (! ((! IsVarInExp (t->USED_VAR.VARNAME->VAR_OBJ.Ident, local1)))) goto yyL2;
  {
# line 574 "SMParallel.puma"
   if (! ((! IsVarInExp (t->USED_VAR.VARNAME->VAR_OBJ.Ident, local2)))) goto yyL2;
  {
# line 575 "SMParallel.puma"
   if (! ((! IsVarInExp (t->USED_VAR.VARNAME->VAR_OBJ.Ident, global)))) goto yyL2;
  {
# line 577 "SMParallel.puma"
 global = mBTV_LIST (CopyTree (t), global); 
  }
  }
  }
  }
   return;
yyL2:;

  }
  if (t->Kind == kLOOP_VAR) {
# line 582 "SMParallel.puma"
  {
# line 584 "SMParallel.puma"
   if (! ((! IsVarInExp (t->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, local1)))) goto yyL3;
  {
# line 585 "SMParallel.puma"
   if (! ((! IsVarInExp (t->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, local2)))) goto yyL3;
  {
# line 586 "SMParallel.puma"
   if (! ((! IsVarInExp (t->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, global)))) goto yyL3;
  {
# line 588 "SMParallel.puma"
 global = mBTV_LIST (CopyTree (t), global); 
  }
  }
  }
  }
   return;
yyL3:;

  }
;
}

tTree FinalSM
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_PARALLEL) {
  if (t->ACF_PARALLEL.REDUCTION_VARS->Kind == kBTV_EMPTY) {
# line 601 "SMParallel.puma"
   return t;

  }
# line 606 "SMParallel.puma"
  {
# line 608 "SMParallel.puma"
   if (! ((sm_parallelization == CRAY_MP))) goto yyL2;
  {
# line 610 "SMParallel.puma"
   set_protocol_stmt (t);
# line 612 "SMParallel.puma"
   serious_warning_protocol ("REDUCTION not supported here");
  }
  }
   return t->ACF_PARALLEL.PARALLEL_BODY;
yyL2:;

# line 617 "SMParallel.puma"
   return t;

  }
# line 622 "SMParallel.puma"
  {
# line 624 "SMParallel.puma"
   failure_protocol (MODULE, "FinalSM", t);
  }
   return NoTree;

}

void BeginSMParallel ()
{
}

void CloseSMParallel ()
{
}
