# include "ReplaceExp.h"
# include "yyReplaceExp.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 20 "ReplaceExp.puma"


# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Expressions.h"   /* AddConstant */
# include "TreeOps.h"       /* IsVarInExp  */

# define MODULE "ReplaceExp"

       /*************************************************
       *                                                *
       *  global data for replacing expressions         *
       *                                                *
       *************************************************/

# define NEW_LOOP_ID  1

static int action;

static tTree new_loop_id;    /*  action == NEW_LOOP_ID    */



static void yyExit () { Exit (1); }

void (* ReplaceExp_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ReplaceExp, routine %s failed\n", yyFunction);
 ReplaceExp_Exit ();
}

void RenameLoopId ARGS((tTree t, tTree id, tTree id_new));
tTree RenameExpLoopId ARGS((tTree t, tTree id, tTree id_new));
static void DoReplace ARGS((tTree t, tTree id));
static tTree ReplaceExp ARGS((tTree exp, tTree id));
static void ChangeLoopId ARGS((tTree loopid1, tTree loopid2));

void RenameLoopId
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree id, register tTree id_new)
# else
(t, id, id_new)
 register tTree t;
 register tTree id;
 register tTree id_new;
# endif
{
  if (id->Kind == kLOOP_VAR) {
  if (id_new->Kind == kLOOP_VAR) {
# line 54 "ReplaceExp.puma"
  {
# line 56 "ReplaceExp.puma"
   action = NEW_LOOP_ID;
# line 57 "ReplaceExp.puma"
   new_loop_id = id_new;
# line 59 "ReplaceExp.puma"
   DoReplace (t, id);
  }
   return;

  }
  }
# line 62 "ReplaceExp.puma"
  {
# line 64 "ReplaceExp.puma"
   failure2_protocol (MODULE, "RenameLoopId", id, id_new);
  }
   return;

;
}

tTree RenameExpLoopId
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree id, register tTree id_new)
# else
(t, id, id_new)
 register tTree t;
 register tTree id;
 register tTree id_new;
# endif
{
  if (id->Kind == kLOOP_VAR) {
  if (id_new->Kind == kLOOP_VAR) {
# line 75 "ReplaceExp.puma"
  {
# line 77 "ReplaceExp.puma"
   action = NEW_LOOP_ID;
# line 78 "ReplaceExp.puma"
   new_loop_id = id_new;
  }
   return ReplaceExp (t, id);

  }
  }
# line 83 "ReplaceExp.puma"
  {
# line 85 "ReplaceExp.puma"
   failure2_protocol (MODULE, "RenameExpLoopId", id, id_new);
  }
   return t;

}

static void DoReplace
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree id)
# else
(t, id)
 register tTree t;
 register tTree id;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 101 "ReplaceExp.puma"
  {
# line 102 "ReplaceExp.puma"
   DoReplace (t->ACF_LIST.Elem, id);
# line 103 "ReplaceExp.puma"
   DoReplace (t->ACF_LIST.Next, id);
  }
   return;

  case kACF_EMPTY:
# line 106 "ReplaceExp.puma"
   return;

  case kACF_DUMMY:
# line 109 "ReplaceExp.puma"
   return;

  case kACF_BASIC:
# line 112 "ReplaceExp.puma"
  {
# line 113 "ReplaceExp.puma"
   DoReplace (t->ACF_BASIC.BASIC_STMT, id);
  }
   return;

  case kACF_IF:
# line 116 "ReplaceExp.puma"
  {
# line 117 "ReplaceExp.puma"
 t->ACF_IF.IF_EXP = ReplaceExp (t->ACF_IF.IF_EXP, id); 
# line 118 "ReplaceExp.puma"
   DoReplace (t->ACF_IF.THEN_PART, id);
# line 119 "ReplaceExp.puma"
   DoReplace (t->ACF_IF.ELSE_PART, id);
  }
   return;

  case kACF_WHERE:
# line 122 "ReplaceExp.puma"
  {
# line 124 "ReplaceExp.puma"
 t->ACF_WHERE.WHERE_EXP = ReplaceExp (t->ACF_WHERE.WHERE_EXP, id); 
# line 125 "ReplaceExp.puma"
   DoReplace (t->ACF_WHERE.TRUE_PART, id);
# line 126 "ReplaceExp.puma"
   DoReplace (t->ACF_WHERE.FALSE_PART, id);
  }
   return;

  case kACF_CASE:
# line 129 "ReplaceExp.puma"
  {
# line 130 "ReplaceExp.puma"
 t->ACF_CASE.CASE_EXP = ReplaceExp (t->ACF_CASE.CASE_EXP, id); 
# line 131 "ReplaceExp.puma"
   DoReplace (t->ACF_CASE.CASE_ALTS, id);
  }
   return;

  case kSELECTED_ACF_LIST:
# line 134 "ReplaceExp.puma"
  {
# line 135 "ReplaceExp.puma"
   DoReplace (t->SELECTED_ACF_LIST.Elem, id);
# line 136 "ReplaceExp.puma"
   DoReplace (t->SELECTED_ACF_LIST.Next, id);
  }
   return;

  case kSELECTED_ACF_EMPTY:
# line 139 "ReplaceExp.puma"
   return;

  case kSELECTED_ACF_NODE:
# line 142 "ReplaceExp.puma"
  {
# line 143 "ReplaceExp.puma"
   DoReplace (t->SELECTED_ACF_NODE.SELECT_LIST, id);
# line 144 "ReplaceExp.puma"
   DoReplace (t->SELECTED_ACF_NODE.SELECT_ACFS, id);
  }
   return;

  case kACF_WHILE:
# line 147 "ReplaceExp.puma"
  {
# line 148 "ReplaceExp.puma"
 t->ACF_WHILE.WHILE_EXP = ReplaceExp (t->ACF_WHILE.WHILE_EXP, id); 
# line 149 "ReplaceExp.puma"
   DoReplace (t->ACF_WHILE.WHILE_BODY, id);
  }
   return;

  case kACF_FORALL:
# line 152 "ReplaceExp.puma"
  {
# line 154 "ReplaceExp.puma"
 t->ACF_FORALL.FORALL_RANGE = ReplaceExp (t->ACF_FORALL.FORALL_RANGE, id); 
# line 155 "ReplaceExp.puma"
   DoReplace (t->ACF_FORALL.FORALL_BODY, id);
  }
   return;

  case kACF_DO:
# line 158 "ReplaceExp.puma"
  {
# line 159 "ReplaceExp.puma"
 t->ACF_DO.DO_RANGE = ReplaceExp (t->ACF_DO.DO_RANGE, id); 
# line 160 "ReplaceExp.puma"
   DoReplace (t->ACF_DO.DO_BODY, id);
  }
   return;

  case kACF_ON:
# line 163 "ReplaceExp.puma"
  {
# line 164 "ReplaceExp.puma"
   DoReplace (t->ACF_ON.ON_BODY, id);
  }
   return;

  case kASSIGN_STMT:
# line 172 "ReplaceExp.puma"
  {
# line 173 "ReplaceExp.puma"
   DoReplace (t->ASSIGN_STMT.ASSIGN_VAR, id);
# line 174 "ReplaceExp.puma"
 t->ASSIGN_STMT.ASSIGN_EXP = ReplaceExp (t->ASSIGN_STMT.ASSIGN_EXP, id); 
  }
   return;

  case kFORMAT_STMT:
# line 177 "ReplaceExp.puma"
   return;

  case kIO_STMT:
# line 181 "ReplaceExp.puma"
  {
# line 182 "ReplaceExp.puma"
   DoReplace (t->IO_STMT.IO_ITEMS, id);
  }
   return;

  case kCALL_STMT:
# line 185 "ReplaceExp.puma"
  {
# line 186 "ReplaceExp.puma"
   DoReplace (t->CALL_STMT.CALL_PARAMS, id);
  }
   return;

  case kREDUCE_STMT:
# line 189 "ReplaceExp.puma"
  {
# line 190 "ReplaceExp.puma"
   DoReplace (t->REDUCE_STMT.RED_PARAMS, id);
  }
   return;

  case kALLOCATE_STMT:
# line 193 "ReplaceExp.puma"
  {
# line 194 "ReplaceExp.puma"
   DoReplace (t->ALLOCATE_STMT.PARAMS, id);
# line 195 "ReplaceExp.puma"
 t->ALLOCATE_STMT.STATUS = ReplaceExp (t->ALLOCATE_STMT.STATUS, id); 
  }
   return;

  case kDEALLOCATE_STMT:
# line 198 "ReplaceExp.puma"
  {
# line 199 "ReplaceExp.puma"
   DoReplace (t->DEALLOCATE_STMT.PARAMS, id);
# line 200 "ReplaceExp.puma"
 t->DEALLOCATE_STMT.STATUS = ReplaceExp (t->DEALLOCATE_STMT.STATUS, id); 
  }
   return;

  case kINHERIT_DSP_STMT:
# line 203 "ReplaceExp.puma"
   return;

  case kCREATE_DSP_STMT:
# line 206 "ReplaceExp.puma"
   return;

  case kFREE_DSP_STMT:
# line 209 "ReplaceExp.puma"
   return;

  case kGOTO_STMT:
# line 212 "ReplaceExp.puma"
   return;

  case kCOMP_IF_STMT:
# line 215 "ReplaceExp.puma"
  {
# line 217 "ReplaceExp.puma"
 t->COMP_IF_STMT.IF_EXP = ReplaceExp (t->COMP_IF_STMT.IF_EXP, id); 
  }
   return;

  case kSTOP_STMT:
# line 220 "ReplaceExp.puma"
  {
# line 222 "ReplaceExp.puma"
 t->STOP_STMT.STOP_CONST = ReplaceExp (t->STOP_STMT.STOP_CONST, id); 
  }
   return;

  case kRETURN_STMT:
# line 225 "ReplaceExp.puma"
  {
# line 227 "ReplaceExp.puma"
 t->RETURN_STMT.RETURN_EXP = ReplaceExp (t->RETURN_STMT.RETURN_EXP, id); 
  }
   return;

  case kBTP_LIST:
# line 236 "ReplaceExp.puma"
  {
# line 237 "ReplaceExp.puma"
   DoReplace (t->BTP_LIST.Elem, id);
# line 238 "ReplaceExp.puma"
   DoReplace (t->BTP_LIST.Next, id);
  }
   return;

  case kBTP_EMPTY:
# line 241 "ReplaceExp.puma"
   return;

  case kBTE_LIST:
# line 244 "ReplaceExp.puma"
  {
# line 245 "ReplaceExp.puma"
 t->BTE_LIST.Elem = ReplaceExp (t->BTE_LIST.Elem, id); 
# line 246 "ReplaceExp.puma"
   DoReplace (t->BTE_LIST.Next, id);
  }
   return;

  case kBTE_EMPTY:
# line 249 "ReplaceExp.puma"
   return;

  case kVAR_PARAM:
  if (t->VAR_PARAM.V->Kind == kLOOP_VAR) {
  if (id->Kind == kLOOP_VAR) {
# line 260 "ReplaceExp.puma"
  {
# line 263 "ReplaceExp.puma"
   if (! ((t->VAR_PARAM.V->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident == id->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident))) goto yyL33;
  {
# line 265 "ReplaceExp.puma"
 if (action == NEW_LOOP_ID)
        ChangeLoopId (t->VAR_PARAM.V, new_loop_id);
   
  }
  }
   return;
yyL33:;

  }
  }
  if (t->VAR_PARAM.V->Kind == kADDR) {
# line 270 "ReplaceExp.puma"
  {
# line 271 "ReplaceExp.puma"
 t->VAR_PARAM.V->ADDR.E = ReplaceExp (t->VAR_PARAM.V->ADDR.E, id); 
  }
   return;

  }
# line 274 "ReplaceExp.puma"
  {
# line 275 "ReplaceExp.puma"
   DoReplace (t->VAR_PARAM.V, id);
  }
   return;

  case kFUNC_PARAM:
# line 278 "ReplaceExp.puma"
   return;

  case kPROC_PARAM:
# line 281 "ReplaceExp.puma"
   return;

  case kNO_PARAM:
# line 284 "ReplaceExp.puma"
   return;

  case kUSED_VAR:
# line 293 "ReplaceExp.puma"
   return;

  case kLOOP_VAR:
# line 296 "ReplaceExp.puma"
   return;

  case kSUBSTRING_VAR:
# line 299 "ReplaceExp.puma"
  {
# line 301 "ReplaceExp.puma"
   DoReplace (t->SUBSTRING_VAR.IND_VAR, id);
# line 302 "ReplaceExp.puma"
 t->SUBSTRING_VAR.IND_EXP = ReplaceExp (t->SUBSTRING_VAR.IND_EXP, id); 
  }
   return;

  case kINDEXED_VAR:
# line 305 "ReplaceExp.puma"
  {
# line 306 "ReplaceExp.puma"
   DoReplace (t->INDEXED_VAR.IND_VAR, id);
# line 307 "ReplaceExp.puma"
   DoReplace (t->INDEXED_VAR.IND_EXPS, id);
  }
   return;

  }

# line 310 "ReplaceExp.puma"
  {
# line 311 "ReplaceExp.puma"
   failure_protocol (MODULE, "DoReplace", t);
  }
   return;

;
}

static tTree ReplaceExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id)
# else
(exp, id)
 register tTree exp;
 register tTree id;
# endif
{
# line 322 "ReplaceExp.puma"
  {
# line 324 "ReplaceExp.puma"
   if (! ((exp == NoTree))) goto yyL1;
  {
# line 325 "ReplaceExp.puma"
   failure_protocol (MODULE, "ReplaceExp with exp = NoTree", exp);
  }
  }
   return NoTree;
yyL1:;

# line 329 "ReplaceExp.puma"
  {
# line 331 "ReplaceExp.puma"
   if (! ((id == NoTree))) goto yyL2;
  {
# line 332 "ReplaceExp.puma"
   failure_protocol (MODULE, "ReplaceExp with id = NoTree", id);
  }
  }
   return NoTree;
yyL2:;

# line 336 "ReplaceExp.puma"
  {
# line 338 "ReplaceExp.puma"
   if (! ((! IsVarInExp (TreeVarName (id), exp)))) goto yyL3;
  }
   return exp;
yyL3:;


  switch (exp->Kind) {
  case kVAR_EXP:
  if (exp->VAR_EXP.V->Kind == kLOOP_VAR) {
  if (id->Kind == kLOOP_VAR) {
# line 343 "ReplaceExp.puma"
  {
# line 345 "ReplaceExp.puma"
   if (! ((TreeVarName (exp->VAR_EXP.V) == TreeVarName (id)))) goto yyL4;
  {
# line 347 "ReplaceExp.puma"
   ChangeLoopId (exp->VAR_EXP.V, new_loop_id);
  }
  }
   return exp;
yyL4:;

  }
  }
# line 352 "ReplaceExp.puma"
  {
# line 353 "ReplaceExp.puma"
   DoReplace (exp->VAR_EXP.V, id);
  }
   return exp;

  case kADDR:
# line 357 "ReplaceExp.puma"
  {
# line 358 "ReplaceExp.puma"
   DoReplace (exp->ADDR.E, id);
  }
   return exp;

  case kARRAY_EXP:
# line 362 "ReplaceExp.puma"
  {
# line 363 "ReplaceExp.puma"
   DoReplace (exp->ARRAY_EXP.ELEMENTS, id);
  }
   return exp;

  case kSLICE_EXP:
# line 367 "ReplaceExp.puma"
  {
# line 368 "ReplaceExp.puma"
 exp->SLICE_EXP.START =  ReplaceExp (exp->SLICE_EXP.START, id); 
      exp->SLICE_EXP.STOP  =  ReplaceExp (exp->SLICE_EXP.STOP, id);
      exp->SLICE_EXP.INC  =  ReplaceExp (exp->SLICE_EXP.INC, id);
    
  }
   return exp;

  case kOP_EXP:
# line 375 "ReplaceExp.puma"
  {
# line 376 "ReplaceExp.puma"
 exp->OP_EXP.OPND1 = ReplaceExp (exp->OP_EXP.OPND1, id);
      exp->OP_EXP.OPND2 = ReplaceExp (exp->OP_EXP.OPND2, id);
    
  }
   return exp;

  case kOP1_EXP:
# line 382 "ReplaceExp.puma"
  {
# line 383 "ReplaceExp.puma"
 exp->OP1_EXP.OPND = ReplaceExp (exp->OP1_EXP.OPND, id); 
  }
   return exp;

  case kFUNC_CALL_EXP:
# line 387 "ReplaceExp.puma"
  {
# line 388 "ReplaceExp.puma"
 DoReplace (exp->FUNC_CALL_EXP.FUNC_PARAMS, id); 
  }
   return exp;

  case kDO_EXP:
# line 392 "ReplaceExp.puma"
  {
# line 393 "ReplaceExp.puma"
 exp->DO_EXP.RANGE = ReplaceExp (exp->DO_EXP.RANGE, id);
      DoReplace (exp->DO_EXP.BODY, id);
    
  }
   return exp;

  }

# line 399 "ReplaceExp.puma"
  {
# line 400 "ReplaceExp.puma"
   failure_protocol (MODULE, "ReplaceExp", exp);
  }
   return NoTree;

}

static void ChangeLoopId
# if defined __STDC__ | defined __cplusplus
(register tTree loopid1, register tTree loopid2)
# else
(loopid1, loopid2)
 register tTree loopid1;
 register tTree loopid2;
# endif
{
  if (loopid1->Kind == kLOOP_VAR) {
  if (loopid2->Kind == kLOOP_VAR) {
# line 412 "ReplaceExp.puma"
  {
# line 415 "ReplaceExp.puma"
 loopid1->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident = loopid2->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident;
    loopid1->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Object  = loopid2->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Object;
  
  }
   return;

  }
  }
# line 425 "ReplaceExp.puma"
  {
# line 427 "ReplaceExp.puma"
   failure2_protocol (MODULE, "ChangeLoopId", loopid1, loopid2);
  }
   return;

;
}

void BeginReplaceExp ()
{
}

void CloseReplaceExp ()
{
}
