# include "ReductionComm.h"
# include "yyReductionComm.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 21 "ReductionComm.puma"


# undef DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "HomeTraverse.h"    /* AppendBody */

# include "Transform.h"    /* AppendBody */
# include "Rank.h"

# include "Distributions.h"
# include "Ownership.h"    /* MakeOnSpecs, MakeOnTopology */
# include "Descriptor.h"   /* PrintableDescriptorVar      */
# include "HomeDescriptor.h"   /* IsSerialDescriptor      */
# include "MoveDescriptor.h"   /* IsSerialDescriptor      */

# define MODULE "ReductionComm"



static void yyExit () { Exit (1); }

void (* ReductionComm_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ReductionComm, routine %s failed\n", yyFunction);
 ReductionComm_Exit ();
}

void ReductionCommunication ARGS((tTree body));
static tTree TranslateReduction ARGS((tTree stmt, pvar home));
static tTree GenerateReduction ARGS((pvar active_home, pvar red_home, tTree func, tTree var));
static tTree GenerateTopReduction ARGS((pvar active_home, pvar red_home, tTree func, tTree var));
static tTree GenerateTopBroadcast ARGS((tTree var, pvar home));
static tTree MakeRedDimSpecs ARGS((pvar active_home));
static tTree MakeNewRedDimSpecs ARGS((pvar active_home, pvar sub_home));
static tTree MakeReplicatedOnSpecs ARGS((pvar all_home, pvar red_home, pvar var_home));
static void FindReductionHome ARGS((tTree t, pvar home, tTree red_var, pvar red_home, bool * yyP1));
static void CombineReductionHome ARGS((pvar home1, bool found1, pvar home2, bool found2, bool * yyP2));
static bool SameReductionVar ARGS((tTree vl1, tTree vl2));
static bool SameReplication ARGS((pvar home1, pvar home2));
static void MakeFullTopHome ARGS((pvar home));
static bool OnMoreProcs ARGS((pvar home, int pdim));

void ReductionCommunication
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
# line 61 "ReductionComm.puma"
 {
  var_descriptor home;
  {
# line 63 "ReductionComm.puma"

# line 65 "ReductionComm.puma"
   MakeReplicatedDescriptor (& home);
# line 67 "ReductionComm.puma"
 body->BODY_NODE.STATS = HomeReplaceAST (body->BODY_NODE.STATS, &home, TranslateReduction); 
  }
   return;
 }

  }
# line 70 "ReductionComm.puma"
  {
# line 72 "ReductionComm.puma"
   failure_protocol (MODULE, "ReductionCommunication", body);
  }
   return;

;
}

static tTree TranslateReduction
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar home)
# else
(stmt, home)
 register tTree stmt;
 pvar home;
# endif
{
  if (stmt->Kind == kACF_REDUCTION) {
# line 122 "ReductionComm.puma"
 {
  tTree comm;
  var_descriptor red_home;
  bool yyV1;
  {
# line 126 "ReductionComm.puma"

# line 128 "ReductionComm.puma"

# line 130 "ReductionComm.puma"
   set_protocol_stmt (stmt);
# line 132 "ReductionComm.puma"
   FindReductionHome (stmt->ACF_REDUCTION.REDUCTION_BODY, home, stmt->ACF_REDUCTION.REDUCTION_VAR, & red_home, & yyV1);
# line 134 "ReductionComm.puma"
 if (!yyV1)
       { warning_protocol ("reduction variable not used");
         MakeReplicatedDescriptor (&red_home);
       }
   
# line 140 "ReductionComm.puma"
   tree_protocol ("generate reduction, var = ", stmt->ACF_REDUCTION.REDUCTION_VAR);
# line 141 "ReductionComm.puma"
   tree_protocol ("home of reduction is    = ", PrintableDescriptorVar (home));
# line 142 "ReductionComm.puma"
   tree_protocol ("home of reduce    is    = ", PrintableDescriptorVar (& red_home));
# line 145 "ReductionComm.puma"
   comm = GenerateReduction (home, & red_home, stmt->ACF_REDUCTION.REDUCTION_FUNC, stmt->ACF_REDUCTION.REDUCTION_VAR);
# line 147 "ReductionComm.puma"
   tree_protocol ("==> generated reduction = \n ", comm);
  }
  {
   return CombineACF (stmt, comm);
  }
 }

  }
# line 152 "ReductionComm.puma"
   return stmt;

}

static tTree GenerateReduction
# if defined __STDC__ | defined __cplusplus
(pvar active_home, pvar red_home, register tTree func, register tTree var)
# else
(active_home, red_home, func, var)
 pvar active_home;
 pvar red_home;
 register tTree func;
 register tTree var;
# endif
{
# line 183 "ReductionComm.puma"
  {
# line 185 "ReductionComm.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return NoTree;
yyL1:;

# line 190 "ReductionComm.puma"
  {
# line 192 "ReductionComm.puma"
   if (! ((IsReplicatedDescriptor (red_home)))) goto yyL2;
  }
   return NoTree;
yyL2:;

# line 200 "ReductionComm.puma"
  {
# line 202 "ReductionComm.puma"
   if (! ((VDIsSame (active_home, red_home)))) goto yyL3;
  }
   return NoTree;
yyL3:;

# line 210 "ReductionComm.puma"
  {
# line 212 "ReductionComm.puma"
   if (! ((TreeWriteDistribution (var) == 0))) goto yyL4;
  {
# line 214 "ReductionComm.puma"
   if (! ((IsSerialDescriptor (red_home)))) goto yyL4;
  }
  }
   return mACF_BASIC (mREDUCTION_STMT (func, var, MakeOnTopology (active_home), MakeRedDimSpecs (active_home)));
yyL4:;

# line 223 "ReductionComm.puma"
 {
  var_descriptor full_top_home;
  {
# line 225 "ReductionComm.puma"
   if (! ((IsReplicatedDescriptor (active_home)))) goto yyL5;
  {
# line 229 "ReductionComm.puma"

# line 231 "ReductionComm.puma"
 full_top_home = *red_home; 
# line 233 "ReductionComm.puma"
   MakeFullTopHome (& full_top_home);
  }
  }
  {
   return CombineACF (GenerateTopBroadcast (var, & full_top_home), GenerateTopReduction (& full_top_home, red_home, func, var));
  }
 }
yyL5:;

# line 243 "ReductionComm.puma"
   return GenerateTopReduction (active_home, red_home, func, var);

}

static tTree GenerateTopReduction
# if defined __STDC__ | defined __cplusplus
(pvar active_home, pvar red_home, register tTree func, register tTree var)
# else
(active_home, red_home, func, var)
 pvar active_home;
 pvar red_home;
 register tTree func;
 register tTree var;
# endif
{
# line 276 "ReductionComm.puma"
 {
  tTree on_top;
  tTree on_spec;
  {
# line 278 "ReductionComm.puma"
   if (! ((TreeWriteDistribution (var) == 0))) goto yyL1;
  {
# line 280 "ReductionComm.puma"

# line 281 "ReductionComm.puma"

# line 283 "ReductionComm.puma"
   on_top = MakeOnTopology (active_home);
# line 284 "ReductionComm.puma"
   on_spec = MakeNewRedDimSpecs (active_home, red_home);
  }
  }
  {
   return mACF_BASIC (mREDUCTION_STMT (func, var, on_top, on_spec));
  }
 }
yyL1:;

  if (var->Kind == kBTV_LIST) {
# line 289 "ReductionComm.puma"
 {
  var_descriptor var_home;
  tTree on_top;
  tTree on_spec;
  {
# line 291 "ReductionComm.puma"

# line 293 "ReductionComm.puma"
   SetVarDescriptor (var->BTV_LIST.Elem, & var_home);
# line 295 "ReductionComm.puma"

# line 296 "ReductionComm.puma"

# line 298 "ReductionComm.puma"
   on_top = MakeOnTopology (active_home);
# line 299 "ReductionComm.puma"
   on_spec = MakeReplicatedOnSpecs (active_home, red_home, & var_home);
  }
  {
   return mACF_BASIC (mREDUCTION_STMT (func, var, on_top, on_spec));
  }
 }

  }
 yyAbort ("GenerateTopReduction");
}

static tTree GenerateTopBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
# line 315 "ReductionComm.puma"
  {
# line 317 "ReductionComm.puma"
   if (! ((IsReplicatedDescriptor (home)))) goto yyL1;
  }
   return NoTree;
yyL1:;

# line 322 "ReductionComm.puma"
  {
# line 324 "ReductionComm.puma"
   if (! ((IsHostDescriptor (home)))) goto yyL2;
  }
   return mACF_BASIC (mBROADCAST_STMT (CopyTree (var), mON_HOST (), mON_EMPTY ()));
yyL2:;

# line 330 "ReductionComm.puma"
  {
# line 332 "ReductionComm.puma"
   if (! ((IsFullTopologyObj (home -> topology_obj)))) goto yyL3;
  }
   return NoTree;
yyL3:;

# line 337 "ReductionComm.puma"
   return mACF_BASIC (mBROADCAST_STMT (CopyTree (var), MakeOnTopology (home), mON_EMPTY ()));

}

static tTree MakeRedDimSpecs
# if defined __STDC__ | defined __cplusplus
(pvar active_home)
# else
(active_home)
 pvar active_home;
# endif
{
# line 355 "ReductionComm.puma"
 {
  tTree on_specs;
  {
# line 357 "ReductionComm.puma"

# line 359 "ReductionComm.puma"
 int pdim;

     on_specs = mON_EMPTY ();

     for (pdim=1; pdim<=active_home->topology_rank; pdim++)
       if (OnMoreProcs (active_home, pdim))  
          on_specs = mON_LIST (MakeOnVal (active_home, pdim), on_specs);
   
  }
  {
   return on_specs;
  }
 }

}

static tTree MakeNewRedDimSpecs
# if defined __STDC__ | defined __cplusplus
(pvar active_home, pvar sub_home)
# else
(active_home, sub_home)
 pvar active_home;
 pvar sub_home;
# endif
{
# line 383 "ReductionComm.puma"
 {
  tTree specs;
  int pdim;
  {
# line 385 "ReductionComm.puma"

# line 386 "ReductionComm.puma"

# line 388 "ReductionComm.puma"
 specs = mON_EMPTY();

    for (pdim = 1; pdim <= active_home->topology_rank; pdim++)

       if (    OnMoreProcs (active_home, pdim)
              && !OnMoreProcs (sub_home, pdim)   )

             specs = mON_LIST (MakeOnVal (active_home, pdim), specs);
  
  }
  {
   return specs;
  }
 }

}

static tTree MakeReplicatedOnSpecs
# if defined __STDC__ | defined __cplusplus
(pvar all_home, pvar red_home, pvar var_home)
# else
(all_home, red_home, var_home)
 pvar all_home;
 pvar red_home;
 pvar var_home;
# endif
{
# line 410 "ReductionComm.puma"
 {
  tTree specs;
  int pdim;
  {
# line 412 "ReductionComm.puma"

# line 413 "ReductionComm.puma"

# line 415 "ReductionComm.puma"
 specs = mON_EMPTY();

    for (pdim = 1; pdim <= all_home->topology_rank; pdim++)

       { tTree val = var_home->on_val [pdim-1];

         if (     OnMoreProcs (all_home, pdim) 
              && !OnMoreProcs (red_home, pdim)
              && (val == NoTree)              )

             specs = mON_LIST (MakeOnVal (all_home, pdim), specs);
       }
  
  }
  {
   return specs;
  }
 }

}

static void FindReductionHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar home, register tTree red_var, pvar red_home, register bool * yyP1)
# else
(t, home, red_var, red_home, yyP1)
 register tTree t;
 pvar home;
 register tTree red_var;
 pvar red_home;
 register bool * yyP1;
# endif
{

  switch (t->Kind) {
  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 447 "ReductionComm.puma"
  {
# line 449 "ReductionComm.puma"
   if (! ((SameReductionVar (red_var, t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS)))) goto yyL1;
  {
# line 451 "ReductionComm.puma"
 *red_home = *home; 
  }
  }
   * yyP1 = true;
   return;
yyL1:;

  }
# line 454 "ReductionComm.puma"
   * yyP1 = false;
   return;

  case kACF_LIST:
# line 457 "ReductionComm.puma"
 {
  var_descriptor red_home1;
  bool yyV1;
  bool yyV2;
  bool yyV3;
  {
# line 459 "ReductionComm.puma"

# line 461 "ReductionComm.puma"
   FindReductionHome (t->ACF_LIST.Elem, home, red_var, red_home, & yyV1);
# line 462 "ReductionComm.puma"
   FindReductionHome (t->ACF_LIST.Next, home, red_var, & red_home1, & yyV2);
# line 464 "ReductionComm.puma"
   CombineReductionHome (red_home, yyV1, & red_home1, yyV2, & yyV3);
  }
   * yyP1 = yyV3;
   return;
 }

  case kACF_EMPTY:
# line 467 "ReductionComm.puma"
   * yyP1 = false;
   return;

  case kACF_HOME:
  if (t->ACF_HOME.HOME_VAR->Kind == kON_HOST_CLAUSE) {
# line 470 "ReductionComm.puma"
 {
  var_descriptor on_home;
  bool yyV1;
  {
# line 473 "ReductionComm.puma"

# line 475 "ReductionComm.puma"
   MakeHostDescriptor (& on_home);
# line 477 "ReductionComm.puma"
   FindReductionHome (t->ACF_HOME.HOME_BODY, & on_home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
# line 480 "ReductionComm.puma"
 {
  var_descriptor on_home;
  bool yyV1;
  {
# line 483 "ReductionComm.puma"

# line 485 "ReductionComm.puma"
   SetVarDescriptor (t->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & on_home);
# line 487 "ReductionComm.puma"
   FindReductionHome (t->ACF_HOME.HOME_BODY, & on_home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  break;
  case kACF_NEW:
# line 490 "ReductionComm.puma"
 {
  bool yyV1;
  {
# line 492 "ReductionComm.puma"
   FindReductionHome (t->ACF_NEW.NEW_BODY, home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kACF_RESIDENT:
# line 495 "ReductionComm.puma"
 {
  bool yyV1;
  {
# line 497 "ReductionComm.puma"
   FindReductionHome (t->ACF_RESIDENT.RESIDENT_BODY, home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kACF_REDUCTION:
# line 500 "ReductionComm.puma"
 {
  bool yyV1;
  {
# line 502 "ReductionComm.puma"
   FindReductionHome (t->ACF_REDUCTION.REDUCTION_BODY, home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kACF_DO:
# line 505 "ReductionComm.puma"
 {
  bool yyV1;
  {
# line 507 "ReductionComm.puma"
   FindReductionHome (t->ACF_DO.DO_BODY, home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kACF_WHILE:
# line 510 "ReductionComm.puma"
 {
  bool yyV1;
  {
# line 512 "ReductionComm.puma"
   FindReductionHome (t->ACF_WHILE.WHILE_BODY, home, red_var, red_home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kACF_IF:
# line 515 "ReductionComm.puma"
 {
  var_descriptor red_home1;
  bool yyV1;
  bool yyV2;
  bool yyV3;
  {
# line 517 "ReductionComm.puma"

# line 519 "ReductionComm.puma"
   FindReductionHome (t->ACF_IF.THEN_PART, home, red_var, red_home, & yyV1);
# line 520 "ReductionComm.puma"
   FindReductionHome (t->ACF_IF.ELSE_PART, home, red_var, & red_home1, & yyV2);
# line 522 "ReductionComm.puma"
   CombineReductionHome (red_home, yyV1, & red_home1, yyV2, & yyV3);
  }
   * yyP1 = yyV3;
   return;
 }

  }

# line 525 "ReductionComm.puma"
  {
# line 527 "ReductionComm.puma"
   failure_protocol (MODULE, "FindReductionHome", t);
  }
   * yyP1 = false;
   return;

;
}

static void CombineReductionHome
# if defined __STDC__ | defined __cplusplus
(pvar home1, register bool found1, pvar home2, register bool found2, register bool * yyP2)
# else
(home1, found1, home2, found2, yyP2)
 pvar home1;
 register bool found1;
 pvar home2;
 register bool found2;
 register bool * yyP2;
# endif
{
# line 543 "ReductionComm.puma"
  {
# line 545 "ReductionComm.puma"
   if (! ((! found2))) goto yyL1;
  }
   * yyP2 = found1;
   return;
yyL1:;

# line 548 "ReductionComm.puma"
  {
# line 550 "ReductionComm.puma"
   if (! ((! found1))) goto yyL2;
  {
# line 551 "ReductionComm.puma"
 *home1 = *home2; 
  }
  }
   * yyP2 = found2;
   return;
yyL2:;

# line 554 "ReductionComm.puma"
  {
# line 556 "ReductionComm.puma"
   if (! ((SameReplication (home1, home2)))) goto yyL3;
  {
# line 558 "ReductionComm.puma"
   tree_protocol ("home 1 is : ", PrintableDescriptorVar (home1));
# line 559 "ReductionComm.puma"
   tree_protocol ("home 2 is : ", PrintableDescriptorVar (home2));
  }
  }
   * yyP2 = true;
   return;
yyL3:;

# line 562 "ReductionComm.puma"
  {
# line 564 "ReductionComm.puma"
   error_protocol ("two different homes for reductions");
# line 565 "ReductionComm.puma"
   tree_protocol ("home 1 is : ", PrintableDescriptorVar (home1));
# line 566 "ReductionComm.puma"
   tree_protocol ("home 2 is : ", PrintableDescriptorVar (home2));
  }
   * yyP2 = true;
   return;

;
}

static bool SameReductionVar
# if defined __STDC__ | defined __cplusplus
(register tTree vl1, register tTree vl2)
# else
(vl1, vl2)
 register tTree vl1;
 register tTree vl2;
# endif
{
  if (vl1->Kind == kBTV_LIST) {
  if (vl2->Kind == kBTP_LIST) {
  if (vl2->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 577 "ReductionComm.puma"
  {
# line 579 "ReductionComm.puma"
   if (! ((TreeVarName (vl1->BTV_LIST.Elem) == TreeVarName (vl2->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  }
  return false;
}

static bool SameReplication
# if defined __STDC__ | defined __cplusplus
(pvar home1, pvar home2)
# else
(home1, home2)
 pvar home1;
 pvar home2;
# endif
{
# line 590 "ReductionComm.puma"
  {
# line 592 "ReductionComm.puma"
   if (! ((IsReplicatedDescriptor (home1)))) goto yyL1;
  {
# line 593 "ReductionComm.puma"
   if (! ((IsReplicatedDescriptor (home2)))) goto yyL1;
  {
# line 595 "ReductionComm.puma"
   print_protocol ("both homes are full replicated");
  }
  }
  }
   return true;
yyL1:;

# line 598 "ReductionComm.puma"
  {
# line 600 "ReductionComm.puma"
   if (! ((IsSerialDescriptor (home1)))) goto yyL2;
  {
# line 601 "ReductionComm.puma"
   if (! ((IsSerialDescriptor (home2)))) goto yyL2;
  {
# line 603 "ReductionComm.puma"
   print_protocol ("both homes are are on a single processor");
  }
  }
  }
   return true;
yyL2:;

# line 606 "ReductionComm.puma"
  {
# line 608 "ReductionComm.puma"
   if (! ((home1 -> topology_obj != home2 -> topology_obj))) goto yyL3;
  {
# line 609 "ReductionComm.puma"
   return false;
  }
  }
yyL3:;

# line 612 "ReductionComm.puma"
 {
  bool okay;
  {
# line 614 "ReductionComm.puma"

# line 616 "ReductionComm.puma"
 int pdim;

      okay = true;

      for (pdim = 1; pdim <= home1->topology_rank; pdim++)

       { if (OnMoreProcs (home1, pdim) && !OnMoreProcs(home2, pdim))
            okay = false;
         if (OnMoreProcs (home2, pdim) && !OnMoreProcs(home1, pdim))
            okay = false;
       }
    
# line 629 "ReductionComm.puma"
   if (! ((okay))) goto yyL4;
  }
   return true;
 }
yyL4:;

  return false;
}

static void MakeFullTopHome
# if defined __STDC__ | defined __cplusplus
(pvar home)
# else
(home)
 pvar home;
# endif
{
# line 643 "ReductionComm.puma"
  {
# line 645 "ReductionComm.puma"
 int pdim;

     for (pdim = 1; pdim <= home->topology_rank; pdim++)

         home->on_val[pdim-1] = NoTree;

   
  }
   return;

;
}

static bool OnMoreProcs
# if defined __STDC__ | defined __cplusplus
(pvar home, register int pdim)
# else
(home, pdim)
 pvar home;
 register int pdim;
# endif
{
# line 665 "ReductionComm.puma"
  {
# line 667 "ReductionComm.puma"
   if (! ((home -> on_val [pdim - 1] == NoTree))) goto yyL1;
  }
   return true;
yyL1:;

# line 670 "ReductionComm.puma"
  {
# line 672 "ReductionComm.puma"
   if (! ((TreeRank (home -> on_val [pdim - 1]) > 0))) goto yyL2;
  }
   return true;
yyL2:;

  return false;
}

void BeginReductionComm ()
{
}

void CloseReductionComm ()
{
}
