# include "Reaching.h"
# include "yyReaching.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 43 "Reaching.puma"


# include "Idents.h"
# include "protocol.h"

# include "TreeOps.h"        /* IsDeferredShape  */
# include "Objects.h"        /* ArrayFormals     */
# include "Types.h"          /* ArrayFormals     */
# include "Transform.h"      /* ExpToVarParam    */
# include "Expressions.h"    /* MakeConstant     */
# include "Nesting.h"    
# include "Traverse.h"
# include "Rank.h"
# include "Unparse.h"

# define MODULE "Reaching"

/*********************************************************************
*                                                                    * 
*  Global Data for Allocate                                          *
*                                                                    *
*    allocate_stack:                                                 * 
*                                MAX_ALLOCATES                       * 
*    -------------------------                                       * 
*    |                       |                                       * 
*    -------------------------                                       * 
*    |                       |                                       * 
*    |   ...............     |                                       * 
*    |                       |                                       * 
*    -------------------------                                       * 
*    |                       |   3  <- allocate_top                  * 
*    -------------------------                                       * 
*    |    alloc_obj 3        |   2                                   *
*    -------------------------                                       *
*    |    alloc_obj 2        |   1                                   *
*    -------------------------                                       *
*    |    alloc_obj 1        |   0                                   *
*    -------------------------                                       * 
*                                                                    * 
*********************************************************************/

# define MAX_ALLOCATES 100

static int allocate_top;
static tObject allocate_obj [MAX_ALLOCATES];
static tTree   allocate_val [MAX_ALLOCATES];

# define MAX_DYN_DISTRIBUTIONS 10

static int distribution_top;
static tObject      distribution_obj [MAX_DYN_DISTRIBUTIONS];
static tDefinitions distribution_val [MAX_DYN_DISTRIBUTIONS];

/*********************************************************************
*                                                                    * 
*   int GetAllocPosition (tObject obj)                               * 
*                                                                    * 
*   - find an object in the stack of allocated objects               * 
*   - pos == allocate_top implies not found                          * 
*                                                                    * 
*********************************************************************/

static int GetAllocPosition (obj)

tObject obj;

{ int pos;
  bool found;

  pos = 0;
  found = false;

  while ((pos < allocate_top) && (!found))

   { found = (allocate_obj[pos] == obj);
     if (!found) pos+=1;
   }

  return pos;

} /* GetAllocPosition */

       /*************************************************
       *                                                *
       *  Find an object in the distribution stack      *
       *                                                *
       *************************************************/

static int GetDistPosition (obj)

tObject obj;

{ int pos;
  bool found;

  pos = 0;
  found = false;

  while ((pos < distribution_top) && (!found))

   { found = (distribution_obj[pos] == obj);
     if (!found) pos+=1;
   }

  return pos;

} /* GetDistPosition */

       /*************************************************
       *                                                *
       *  Check if name has been allocated              *
       *                                                *
       *************************************************/

static bool IsAllocated (obj)

tObject obj;

{ 
  return (GetAllocPosition (obj) < allocate_top);

} /* IsAllocated */

       /*************************************************
       *                                                *
       *  InsertObjAllocate (obj, indexes)              *
       *                                                *
       *************************************************/

static void InsertObjAllocate (obj, indexes)

tObject obj;
tTree   indexes;

{  allocate_obj [allocate_top] = obj;
   allocate_val [allocate_top] = indexes;
   allocate_top += 1;

} /* InsertObjAllocate */

       /*************************************************
       *                                                *
       *  RemoveObjAllocate (obj)                       *
       *                                                *
       *************************************************/

static void RemoveObjAllocate (obj)

tObject obj;

{ int i, pos;

  pos = GetAllocPosition (obj);

  for (i=pos+1; i < allocate_top; i++)

     { allocate_obj [i-1] = allocate_obj[i];
       allocate_val [i-1] = allocate_val[i];
     }

 allocate_top -= 1;

} /* RemoveObjAllocate */

       /*************************************************
       *                                                *
       *  SetObjDistribution (obj, distribution)        *
       *                                                *
       *************************************************/
 
static void SetObjDistribution (obj, distribution)
 
tObject obj;
tDefinitions distribution;
 
{  int pos;

   pos = GetDistPosition (obj);

   distribution_obj [pos] = obj;
   distribution_val [pos] = distribution;

   if (pos == distribution_top) distribution_top += 1;
 
} /* SetObjDistribution */

#include "ShowDefs.h"



static void yyExit () { Exit (1); }

void (* Reaching_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Reaching, routine %s failed\n", yyFunction);
 Reaching_Exit ();
}

void ReachingAllocate ARGS((tTree t));
static bool StopTraversing ARGS((tTree t));
static void DoIt ARGS((tTree t));
static tDefinitions GetTemplateObj ARGS((tDefinitions obj, tDefinitions dist));
static void SetAllocateParameters ARGS((tTree params));
static void SetAllocateParam ARGS((tTree var));
static void ResetDeallocateParameters ARGS((tTree params));
static void ResetDeallocateParam ARGS((tTree var));
static void SetObjAllocated ARGS((tDefinitions obj, tTree indexes));
static void SetObjDeallocated ARGS((tDefinitions obj));
static void SetRemapping ARGS((tTree distributees, tDefinitions map_info));
static tTree GetReachingInfo ARGS((tTree uv, tDefinitions obj));
static tDefinitions GetReachingDistribution ARGS((tDefinitions obj));
static tTree GetReachingAllocate ARGS((tTree uv, tDefinitions obj));
static void NoReachingWarning ARGS((tDefinitions obj));
static tTree MakeUsedVarTree ARGS((tTree uv, tDefinitions obj));
static void DeallocateCheck ARGS(());
static void DeallocateCheckObj ARGS((tDefinitions obj));
static bool IsLocalObject ARGS((tDefinitions obj));
static tTree MakeIndexBoundaries ARGS((tTree var, tTree formals, int n));
static tTree MakeIndexBound ARGS((tTree var, tTree shape, int dim));
void PrintReachingInfo ARGS((tTree uv));

void ReachingAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 240 "Reaching.puma"
  {
# line 241 "Reaching.puma"
   TraverseAST (t, StopTraversing, DoIt);
  }
   return;

;
}

static bool StopTraversing
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 252 "Reaching.puma"
   return true;

  }
  if (t->Kind == kALLOCATE_STMT) {
# line 255 "Reaching.puma"
   return true;

  }
  if (t->Kind == kDEALLOCATE_STMT) {
# line 258 "Reaching.puma"
   return true;

  }
  return false;
}

static void DoIt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 269 "Reaching.puma"
  {
# line 271 "Reaching.puma"
   allocate_top = 0;
# line 272 "Reaching.puma"
   distribution_top = 0;
# line 274 "Reaching.puma"
   ReachingAllocate (t->BODY_NODE.DECLS);
# line 275 "Reaching.puma"
   ReachingAllocate (t->BODY_NODE.STATS);
# line 279 "Reaching.puma"
   DeallocateCheck ();
# line 281 "Reaching.puma"
   ReachingAllocate (t->BODY_NODE.INTERNALS);
  }
   return;

  }
  if (t->Kind == kALLOCATE_STMT) {
# line 284 "Reaching.puma"
  {
# line 286 "Reaching.puma"
   SetAllocateParameters (t->ALLOCATE_STMT.PARAMS);
# line 287 "Reaching.puma"
   ReachingAllocate (t->ALLOCATE_STMT.STATUS);
  }
   return;

  }
  if (t->Kind == kDEALLOCATE_STMT) {
# line 290 "Reaching.puma"
  {
# line 292 "Reaching.puma"
   ResetDeallocateParameters (t->DEALLOCATE_STMT.PARAMS);
# line 293 "Reaching.puma"
   ReachingAllocate (t->DEALLOCATE_STMT.STATUS);
  }
   return;

  }
  if (t->Kind == kREDISTRIBUTE_STMT) {
# line 296 "Reaching.puma"
  {
# line 298 "Reaching.puma"
   SetRemapping (t->REDISTRIBUTE_STMT.DISTRIBUTEE, t->REDISTRIBUTE_STMT.distribution);
  }
   return;

  }
  if (t->Kind == kREALIGN_STMT) {
# line 301 "Reaching.puma"
  {
# line 303 "Reaching.puma"
   SetRemapping (t->REALIGN_STMT.ALIGNEE, t->REALIGN_STMT.distribution);
  }
   return;

  }
  if (t->Kind == kUSED_VAR) {
# line 306 "Reaching.puma"
  {
# line 308 "Reaching.puma"
   if (! ((VarRank (t->USED_VAR.VARNAME->VAR_OBJ.Object) > 0))) goto yyL6;
  {
# line 310 "Reaching.puma"
 t->USED_VAR.VARNAME->VAR_OBJ.Reaching = GetReachingInfo (t, t->USED_VAR.VARNAME->VAR_OBJ.Object); 
  }
  }
   return;
yyL6:;

  }
;
}

static tDefinitions GetTemplateObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions dist)
# else
(obj, dist)
 register tDefinitions obj;
 register tDefinitions dist;
# endif
{
  if (dist->Kind == kAlignDistribution) {
# line 323 "Reaching.puma"
   return dist->AlignDistribution.template_obj;

  }
# line 328 "Reaching.puma"
   return obj;

}

static void SetAllocateParameters
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 344 "Reaching.puma"
  {
# line 346 "Reaching.puma"
   SetAllocateParam (params->BTP_LIST.Elem->VAR_PARAM.V);
# line 347 "Reaching.puma"
   SetAllocateParameters (params->BTP_LIST.Next);
  }
   return;

  }
  }
  if (params->Kind == kBTP_EMPTY) {
# line 350 "Reaching.puma"
   return;

  }
;
}

static void SetAllocateParam
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 361 "Reaching.puma"
  {
# line 363 "Reaching.puma"
   ReachingAllocate (var->INDEXED_VAR.IND_EXPS);
# line 364 "Reaching.puma"
   goto yyL1;
  }
yyL1:;

  if (var->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
# line 367 "Reaching.puma"
   return;

  }
  if (var->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 372 "Reaching.puma"
  {
# line 374 "Reaching.puma"
   SetObjAllocated (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object, var->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
  }
  if (var->Kind == kUSED_VAR) {
# line 379 "Reaching.puma"
   return;

  }
# line 382 "Reaching.puma"
  {
# line 384 "Reaching.puma"
   failure_protocol (MODULE, "SetAllocateParam", var);
  }
   return;

;
}

static void ResetDeallocateParameters
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 395 "Reaching.puma"
  {
# line 397 "Reaching.puma"
   ResetDeallocateParam (params->BTP_LIST.Elem->VAR_PARAM.V);
# line 398 "Reaching.puma"
   ResetDeallocateParameters (params->BTP_LIST.Next);
  }
   return;

  }
  }
  if (params->Kind == kBTP_EMPTY) {
# line 401 "Reaching.puma"
   return;

  }
;
}

static void ResetDeallocateParam
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 412 "Reaching.puma"
  {
# line 414 "Reaching.puma"
   SetObjDeallocated (var->USED_VAR.VARNAME->VAR_OBJ.Object);
  }
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
# line 417 "Reaching.puma"
   return;

  }
# line 422 "Reaching.puma"
  {
# line 423 "Reaching.puma"
   failure_protocol (MODULE, "ResetDeallocateParam", var);
  }
   return;

;
}

static void SetObjAllocated
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree indexes)
# else
(obj, indexes)
 register tDefinitions obj;
 register tTree indexes;
# endif
{
# line 434 "Reaching.puma"
  {
# line 436 "Reaching.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 437 "Reaching.puma"
   failure_protocol (MODULE, "SetObjAllocated", NoTree);
  }
  }
   return;
yyL1:;

# line 441 "Reaching.puma"
  {
# line 443 "Reaching.puma"
   if (! ((IsTreeObject (obj)))) goto yyL2;
  }
   return;
yyL2:;

# line 446 "Reaching.puma"
  {
# line 448 "Reaching.puma"
   if (! ((IsAllocated (obj)))) goto yyL3;
  {
# line 449 "Reaching.puma"
   error_protocol ("two reaching allocates for one object");
  }
  }
   return;
yyL3:;

# line 452 "Reaching.puma"
  {
# line 454 "Reaching.puma"
   if (! ((allocate_top == MAX_ALLOCATES))) goto yyL4;
  {
# line 455 "Reaching.puma"
   error_protocol ("too many allocates in one unit");
# line 456 "Reaching.puma"
   kill_in_protocol ();
  }
  }
   return;
yyL4:;

# line 459 "Reaching.puma"
  {
# line 461 "Reaching.puma"
   InsertObjAllocate (obj, indexes);
  }
   return;

;
}

static void SetObjDeallocated
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 472 "Reaching.puma"
  {
# line 474 "Reaching.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 475 "Reaching.puma"
   failure_protocol (MODULE, "SetObjDeallocated", NoTree);
  }
  }
   return;
yyL1:;

# line 478 "Reaching.puma"
  {
# line 480 "Reaching.puma"
   if (! ((IsAllocated (obj)))) goto yyL2;
  {
# line 481 "Reaching.puma"
   RemoveObjAllocate (obj);
  }
  }
   return;
yyL2:;

# line 484 "Reaching.puma"
  {
# line 486 "Reaching.puma"
   if (! ((IsUsedObject (obj, GetCurrentUnitObject ())))) goto yyL3;
  }
   return;
yyL3:;

# line 489 "Reaching.puma"
  {
# line 491 "Reaching.puma"
   warning_protocol ("DEALLOCATE: obj is not allocated");
  }
   return;

;
}

static void SetRemapping
# if defined __STDC__ | defined __cplusplus
(register tTree distributees, register tDefinitions map_info)
# else
(distributees, map_info)
 register tTree distributees;
 register tDefinitions map_info;
# endif
{
  if (distributees->Kind == kBTV_LIST) {
  if (distributees->BTV_LIST.Elem->Kind == kUSED_VAR) {
# line 502 "Reaching.puma"
  {
# line 504 "Reaching.puma"
   SetObjDistribution (distributees->BTV_LIST.Elem->USED_VAR.VARNAME->VAR_OBJ.Object, map_info);
# line 505 "Reaching.puma"
   SetRemapping (distributees->BTV_LIST.Next, map_info);
  }
   return;

  }
  }
  if (distributees->Kind == kBTV_EMPTY) {
# line 508 "Reaching.puma"
   return;

  }
# line 511 "Reaching.puma"
  {
# line 513 "Reaching.puma"
   failure_protocol (MODULE, "SetRemapping", distributees);
  }
   return;

;
}

static tTree GetReachingInfo
# if defined __STDC__ | defined __cplusplus
(register tTree uv, register tDefinitions obj)
# else
(uv, obj)
 register tTree uv;
 register tDefinitions obj;
# endif
{
# line 526 "Reaching.puma"
  {
# line 528 "Reaching.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 529 "Reaching.puma"
   failure_protocol (MODULE, "GetReachingAllocate", uv);
  }
  }
   return NoTree;
yyL1:;

# line 535 "Reaching.puma"
 {
  tDefinitions template_obj;
  tTree var_alloc;
  tTree temp_alloc;
  tDefinitions var_dist;
  tDefinitions temp_dist;
  {
# line 537 "Reaching.puma"

# line 539 "Reaching.puma"

# line 540 "Reaching.puma"

# line 541 "Reaching.puma"

# line 542 "Reaching.puma"

# line 547 "Reaching.puma"
   var_dist = GetReachingDistribution (obj);
# line 548 "Reaching.puma"
   var_alloc = GetReachingAllocate (uv, obj);
# line 552 "Reaching.puma"
   template_obj = GetTemplateObj (obj, var_dist);
# line 554 "Reaching.puma"
   temp_dist = GetReachingDistribution (template_obj);
# line 555 "Reaching.puma"
   temp_alloc = GetReachingAllocate (NoTree, template_obj);
  }
  {
   return mREACHING_INFO (var_alloc, temp_alloc, var_dist, temp_dist);
  }
 }

}

static tDefinitions GetReachingDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 568 "Reaching.puma"
 {
  int pos;
  {
# line 570 "Reaching.puma"

# line 572 "Reaching.puma"
   pos = GetDistPosition (obj);
# line 574 "Reaching.puma"
   if (! ((pos < distribution_top))) goto yyL1;
  }
  {
   return distribution_val [pos];
  }
 }
yyL1:;

  if (obj->Kind == kVarObject) {
# line 579 "Reaching.puma"
   return obj->VarObject.Dist;

  }
  if (obj->Kind == kTemplateObject) {
# line 583 "Reaching.puma"
   return obj->TemplateObject.Dist;

  }
  if (obj->Kind == kRaggedObject) {
# line 587 "Reaching.puma"
   return obj->RaggedObject.Dist;

  }
# line 591 "Reaching.puma"
  {
# line 592 "Reaching.puma"
   failure_protocol (MODULE, "GetReachingDistribution", obj->Object.decl);
  }
   return NoDefinitions;

}

static tTree GetReachingAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree uv, register tDefinitions obj)
# else
(uv, obj)
 register tTree uv;
 register tDefinitions obj;
# endif
{
# line 606 "Reaching.puma"
  {
# line 608 "Reaching.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 609 "Reaching.puma"
   failure_protocol (MODULE, "GetReachingAllocate", uv);
  }
  }
   return NoTree;
yyL1:;

# line 613 "Reaching.puma"
 {
  tTree indexes;
  {
# line 615 "Reaching.puma"

# line 617 "Reaching.puma"
   indexes = ArrayFormals (obj);
# line 619 "Reaching.puma"
   if (! ((! IsDeferredShape (indexes)))) goto yyL2;
  {
# line 620 "Reaching.puma"
   if (! ((! IsAssumedShape (indexes)))) goto yyL2;
  }
  }
  {
   return indexes;
  }
 }
yyL2:;

# line 627 "Reaching.puma"
 {
  int pos;
  {
# line 629 "Reaching.puma"

# line 631 "Reaching.puma"
   pos = GetAllocPosition (obj);
# line 633 "Reaching.puma"
   if (! ((pos < allocate_top))) goto yyL3;
  }
  {
   return allocate_val [pos];
  }
 }
yyL3:;

# line 638 "Reaching.puma"
 {
  tTree indexes;
  {
# line 640 "Reaching.puma"

# line 642 "Reaching.puma"
   NoReachingWarning (obj);
# line 644 "Reaching.puma"
 indexes = MakeIndexBoundaries (MakeUsedVarTree (uv, obj),
                                    ArrayFormals    (obj), 1    );
     SetObjAllocated (obj, indexes);
   
  }
  {
   return indexes;
  }
 }

}

static void NoReachingWarning
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 660 "Reaching.puma"

char string [MAXID_LENGTH];
char msg    [MAX_LINE_LENGTH];

# line 665 "Reaching.puma"
  {
# line 667 "Reaching.puma"
   if (! ((IsVarAssumedShape (obj)))) goto yyL1;
  {
# line 669 "Reaching.puma"
   GetString (obj->Object.Ident, string);
# line 670 "Reaching.puma"
   sprintf (msg, "no info about sizes of assumed shape array %s", string);
# line 671 "Reaching.puma"
   warning_protocol (msg);
  }
  }
   return;
yyL1:;

# line 674 "Reaching.puma"
  {
# line 676 "Reaching.puma"
   if (! ((IsUsedObject (obj, GetCurrentUnitObject ())))) goto yyL2;
  {
# line 678 "Reaching.puma"
   GetString (obj->Object.Ident, string);
# line 679 "Reaching.puma"
   sprintf (msg, "no info about sizes for global object %s", string);
# line 680 "Reaching.puma"
   warning_protocol (msg);
  }
  }
   return;
yyL2:;

# line 683 "Reaching.puma"
  {
# line 685 "Reaching.puma"
   GetString (obj->Object.Ident, string);
# line 686 "Reaching.puma"
   sprintf (msg, "no reaching allocate for local object %s", string);
# line 687 "Reaching.puma"
   warning_protocol (msg);
  }
   return;

;
}

static tTree MakeUsedVarTree
# if defined __STDC__ | defined __cplusplus
(register tTree uv, register tDefinitions obj)
# else
(uv, obj)
 register tTree uv;
 register tDefinitions obj;
# endif
{
# line 698 "Reaching.puma"
  {
# line 700 "Reaching.puma"
   if (! ((uv != NoTree))) goto yyL1;
  }
   return uv;
yyL1:;

# line 705 "Reaching.puma"
 {
  tTree v;
  {
# line 707 "Reaching.puma"

# line 709 "Reaching.puma"
 v = mVAR_OBJ (0, obj->Object.Ident);
     v->VAR_OBJ.Object = obj;
   
  }
  {
   return mUSED_VAR (v);
  }
 }

}

static void DeallocateCheck
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 728 "Reaching.puma"
  {
# line 730 "Reaching.puma"
 int i;
    for (i=allocate_top-1; i>=0; i--)
       DeallocateCheckObj (allocate_obj[i]);
  
  }
   return;

;
}

static void DeallocateCheckObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 738 "Reaching.puma"
  {
# line 740 "Reaching.puma"
   if (! ((IsVarAssumedShape (obj)))) goto yyL1;
  }
   return;
yyL1:;

# line 743 "Reaching.puma"
  {
# line 745 "Reaching.puma"
   if (! ((IsUsedObject (obj, GetCurrentUnitObject ())))) goto yyL2;
  }
   return;
yyL2:;

# line 748 "Reaching.puma"
  {
# line 750 "Reaching.puma"
 char msg[MAX_LINE_LENGTH], name[MAXID_LENGTH];

     

     GetString (obj->Object.Ident, name);
     sprintf (msg, "Missing DEALLOCATE for %s", name);
     simple_warning_protocol (msg);
   
  }
   return;

;
}

static bool IsLocalObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 768 "Reaching.puma"
  {
# line 770 "Reaching.puma"
   if (! ((obj->Object.in == GetCurrentUnitObject ()))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

static tTree MakeIndexBoundaries
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree formals, register int n)
# else
(var, formals, n)
 register tTree var;
 register tTree formals;
 register int n;
# endif
{
  if (formals->Kind == kSHAPE_LIST) {
# line 783 "Reaching.puma"
   return mBTE_LIST (MakeIndexBound (var, formals->SHAPE_LIST.Elem, n), MakeIndexBoundaries (var, formals->SHAPE_LIST.Next, n + 1));

  }
  if (formals->Kind == kSHAPE_EMPTY) {
# line 789 "Reaching.puma"
   return mBTE_EMPTY ();

  }
 yyAbort ("MakeIndexBoundaries");
}

static tTree MakeIndexBound
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree shape, register int dim)
# else
(var, shape, dim)
 register tTree var;
 register tTree shape;
 register int dim;
# endif
{
  if (shape->Kind == kASSUMED_SHAPE) {
# line 800 "Reaching.puma"
 {
  int local;
  {
# line 802 "Reaching.puma"

# line 804 "Reaching.puma"
   local = 0;
  }
  {
   return mSLICE_EXP (shape->ASSUMED_SHAPE.LOWER, mBOUND_EXP (var, dim, 1, local), mDUMMY_EXP ());
  }
 }

  }
# line 811 "Reaching.puma"
 {
  int local;
  {
# line 813 "Reaching.puma"

# line 815 "Reaching.puma"
   local = 0;
  }
  {
   return mSLICE_EXP (mBOUND_EXP (var, dim, 0, local), mBOUND_EXP (var, dim, 1, local), mDUMMY_EXP ());
  }
 }

}

void PrintReachingInfo
# if defined __STDC__ | defined __cplusplus
(register tTree uv)
# else
(uv)
 register tTree uv;
# endif
{
  if (uv->Kind == kUSED_VAR) {
  if (uv->USED_VAR.VARNAME->VAR_OBJ.Reaching->Kind == kREACHING_INFO) {
# line 830 "Reaching.puma"
  {
# line 832 "Reaching.puma"
   printf ("reaching info for ");
# line 832 "Reaching.puma"
   FileUnparse (stdout, uv);
# line 832 "Reaching.puma"
   printf ("\n");
# line 833 "Reaching.puma"
   printf (" size var  ");
# line 833 "Reaching.puma"
   FileUnparse (stdout, uv->USED_VAR.VARNAME->VAR_OBJ.Reaching->REACHING_INFO.var_allocate);
# line 833 "Reaching.puma"
   printf ("\n");
# line 834 "Reaching.puma"
   printf (" size temp ");
# line 834 "Reaching.puma"
   FileUnparse (stdout, uv->USED_VAR.VARNAME->VAR_OBJ.Reaching->REACHING_INFO.temp_allocate);
# line 834 "Reaching.puma"
   printf ("\n");
# line 836 "Reaching.puma"
   SemFile = stdout;
# line 838 "Reaching.puma"
   printf (" dist var  ");
# line 838 "Reaching.puma"
   ShowDistribution (uv->USED_VAR.VARNAME->VAR_OBJ.Reaching->REACHING_INFO.var_distribution);
# line 838 "Reaching.puma"
   printf ("\n");
# line 839 "Reaching.puma"
   printf (" dist temp ");
# line 839 "Reaching.puma"
   ShowDistribution (uv->USED_VAR.VARNAME->VAR_OBJ.Reaching->REACHING_INFO.temp_distribution);
# line 839 "Reaching.puma"
   printf ("\n");
  }
   return;

  }
  }
# line 842 "Reaching.puma"
  {
# line 844 "Reaching.puma"
   failure_protocol (MODULE, "PrintReachInfo", uv);
  }
   return;

;
}

void BeginReaching ()
{
}

void CloseReaching ()
{
}
