# include "Rank.h"
# include "yyRank.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 23 "Rank.puma"


# define MODULE "Rank"

# include "Idents.h"
# include "protocol.h"

# include "TreeOps.h"
# include "Expressions.h"
# include "DefTable.h"    /* GetIntrinsicObject */
# include "Objects.h"     /* GetFuncVarObj */
# include "Intrinsics.h"
# include "Types.h"       /* ArrayFormsls  */



static void yyExit () { Exit (1); }

void (* Rank_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Rank, routine %s failed\n", yyFunction);
 Rank_Exit ();
}

int VarRank ARGS((tDefinitions v));
int TreeRank ARGS((tTree t));
static int CountSlices ARGS((tTree list));
int MergeRank ARGS((int rank1, int rank2));
static int ParameterRank ARGS((tTree t));
static int IntrFuncRank ARGS((tIdent name, tTree param));
static int ArraySize ARGS((tTree exp));
static int ArrayExpLength ARGS((tTree exp));
static int FormalSize ARGS((tTree t));
static int ActualSize ARGS((tTree t));
static int GetSliceSize ARGS((tTree lb, tTree ub));
static bool HasDimArgument ARGS((tTree param));

int VarRank
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 49 "Rank.puma"
  {
# line 50 "Rank.puma"
   if (! ((v == NoObject))) goto yyL1;
  }
   return 0;
yyL1:;


  switch (v->Kind) {
  case kVarObject:
  if (v->VarObject.decl->Kind == kVAR_DECL) {
# line 54 "Rank.puma"
   return TreeRank (v->VarObject.decl->VAR_DECL.VAL);

  }
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 58 "Rank.puma"
   return TreeRank (v->VarObject.decl->VAR_PARAM_DECL.VAL);

  }
  if (v->VarObject.decl->Kind == kPARAMETER_DECL) {
# line 62 "Rank.puma"
   return 0;

  }
# line 82 "Rank.puma"
  {
# line 83 "Rank.puma"
   obj_protocol ("no var rank of this object : ", v);
  }
   return - 1;

  case kTemplateObject:
  if (v->TemplateObject.decl->Kind == kTEMPLATE_DECL) {
# line 66 "Rank.puma"
   return TreeListLength (v->TemplateObject.decl->TEMPLATE_DECL.DIMENSIONS);

  }
  break;
  case kRaggedObject:
  if (v->RaggedObject.decl->Kind == kRAGGED_DECL) {
# line 71 "Rank.puma"
   return TreeListLength (v->RaggedObject.decl->RAGGED_DECL.DIMENSIONS);

  }
  break;
  case kTopologyObject:
# line 78 "Rank.puma"
   return v->TopologyObject.rank;

  case kFuncObject:
  if (v->FuncObject.decl->Kind == kFUNC_DECL) {
# line 87 "Rank.puma"
  {
# line 89 "Rank.puma"
   if (! ((v->FuncObject.decl->FUNC_DECL.FUNC_BODY == NoTree))) goto yyL9;
  }
   return 0;
yyL9:;

# line 93 "Rank.puma"
   return VarRank (GetFuncVarObj (v));

  }
# line 98 "Rank.puma"
   return 0;

  case kExternalObject:
# line 104 "Rank.puma"
  {
# line 105 "Rank.puma"
   obj_protocol ("no var rank of this object : ", v);
  }
   return - 1;

  case kProcObject:
# line 109 "Rank.puma"
  {
# line 110 "Rank.puma"
   obj_protocol ("no var rank of this object : ", v);
  }
   return - 1;

  case kGenericObject:
# line 114 "Rank.puma"
  {
# line 115 "Rank.puma"
   obj_protocol ("no var rank of this object : ", v);
  }
   return - 1;

  }

# line 119 "Rank.puma"
  {
# line 120 "Rank.puma"
   obj_protocol ("no var rank of this object : ", v);
  }
   return - 1;

}

int TreeRank
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kVAR_DECL:
# line 132 "Rank.puma"
   return TreeRank (t->VAR_DECL.VAL);

  case kVAR_PARAM_DECL:
# line 136 "Rank.puma"
   return TreeRank (t->VAR_PARAM_DECL.VAL);

  case kPARAMETER_DECL:
# line 140 "Rank.puma"
   return 0;

  case kDUMMY_TYPE:
# line 144 "Rank.puma"
   return 0;

  case kINTEGER_TYPE:
# line 148 "Rank.puma"
   return 0;

  case kREAL_TYPE:
# line 152 "Rank.puma"
   return 0;

  case kBOOLEAN_TYPE:
# line 156 "Rank.puma"
   return 0;

  case kCOMPLEX_TYPE:
# line 160 "Rank.puma"
   return 0;

  case kSTRING_TYPE:
# line 164 "Rank.puma"
   return 0;

  case kARRAY_TYPE:
# line 169 "Rank.puma"
   return TreeListLength (t->ARRAY_TYPE.ARRAY_INDEX_TYPES);

  case kPOINTER_TYPE:
# line 173 "Rank.puma"
   return TreeRank (t->POINTER_TYPE.PTR_COMP);

  case kSHAPE_LIST:
# line 179 "Rank.puma"
   return TreeListLength (t);

  case kSHAPE_EMPTY:
# line 183 "Rank.puma"
   return 0;

  case kTYPE_ID:
# line 187 "Rank.puma"
   return 0;

  case kVAR_OBJ:
# line 191 "Rank.puma"
   return VarRank (t->VAR_OBJ.Object);

  case kUSED_VAR:
# line 195 "Rank.puma"
   return TreeRank (t->USED_VAR.VARNAME);

  case kSUBSTRING_VAR:
# line 199 "Rank.puma"
   return TreeRank (t->SUBSTRING_VAR.IND_VAR);

  case kLOOP_VAR:
# line 203 "Rank.puma"
   return 0;

  case kINDEXED_VAR:
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 207 "Rank.puma"
   return CountSlices (t->INDEXED_VAR.IND_EXPS);

  }
  if (t->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
# line 212 "Rank.puma"
   return TreeRank (t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR) + CountSlices (t->INDEXED_VAR.IND_EXPS);

  }
  break;
  case kSELECTED_VAR:
# line 217 "Rank.puma"
   return TreeRank (t->SELECTED_VAR.SELEC_VAR) + VarRank (t->SELECTED_VAR.SELECTOR->REC_COMP.Object);

  case kPERM_VAR:
# line 221 "Rank.puma"
   return TreeRank (t->PERM_VAR.VAL);

  case kDO_VAR:
# line 225 "Rank.puma"
   return 1;

  case kADDR:
# line 229 "Rank.puma"
   return TreeRank (t->ADDR.E);

  case kDUMMY_EXP:
# line 233 "Rank.puma"
   return 0;

  case kCONST_EXP:
# line 237 "Rank.puma"
   return 0;

  case kARRAY_EXP:
# line 241 "Rank.puma"
   return 1;

  case kBOUND_EXP:
# line 245 "Rank.puma"
   return 0;

  case kTYPE_EXP:
# line 249 "Rank.puma"
   return 0;

  case kSLICE_EXP:
# line 253 "Rank.puma"
   return 1;

  case kOP_EXP:
# line 257 "Rank.puma"
   return MergeRank (TreeRank (t->OP_EXP.OPND1), TreeRank (t->OP_EXP.OPND2));

  case kOP1_EXP:
# line 262 "Rank.puma"
   return TreeRank (t->OP1_EXP.OPND);

  case kVAR_EXP:
# line 266 "Rank.puma"
   return TreeRank (t->VAR_EXP.V);

  case kFUNC_CALL_EXP:
# line 270 "Rank.puma"
  {
# line 272 "Rank.puma"
   if (! ((IsIntrCall (t)))) goto yyL34;
  }
   return IntrFuncRank (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->FUNC_CALL_EXP.FUNC_PARAMS);
yyL34:;

# line 276 "Rank.puma"
   return VarRank (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object);

  case kDO_EXP:
# line 283 "Rank.puma"
   return 1;

  case kNO_PARAM:
# line 288 "Rank.puma"
   return 0;

  case kNAMED_PARAM:
# line 292 "Rank.puma"
   return TreeRank (t->NAMED_PARAM.VAL);

  case kVAR_PARAM:
# line 296 "Rank.puma"
   return TreeRank (t->VAR_PARAM.V);

  }

# line 300 "Rank.puma"
  {
# line 301 "Rank.puma"
   failure_protocol (MODULE, "TreeRank (unknown tree)", t);
  }
   return 0;

}

static int CountSlices
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
  if (list->Kind == kBTE_EMPTY) {
# line 313 "Rank.puma"
   return 0;

  }
  if (list->Kind == kBTE_LIST) {
# line 317 "Rank.puma"
   return TreeRank (list->BTE_LIST.Elem) + CountSlices (list->BTE_LIST.Next);

  }
# line 321 "Rank.puma"
  {
# line 322 "Rank.puma"
   failure_protocol (MODULE, "CountSlices", list);
  }
   return - 1;

}

int MergeRank
# if defined __STDC__ | defined __cplusplus
(register int rank1, register int rank2)
# else
(rank1, rank2)
 register int rank1;
 register int rank2;
# endif
{
  if (equalint (rank1, 0)) {
# line 334 "Rank.puma"
   return rank2;

  }
  if (equalint (rank2, 0)) {
# line 338 "Rank.puma"
   return rank1;

  }
# line 342 "Rank.puma"
  {
# line 343 "Rank.puma"
   if (! ((rank1 == rank2))) goto yyL3;
  }
   return rank1;
yyL3:;

# line 347 "Rank.puma"
   return - 1;

}

static int ParameterRank
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_EMPTY) {
# line 359 "Rank.puma"
   return 0;

  }
  if (t->Kind == kBTP_LIST) {
# line 364 "Rank.puma"
   return MergeRank (TreeRank (t->BTP_LIST.Elem), ParameterRank (t->BTP_LIST.Next));

  }
 yyAbort ("ParameterRank");
}

static int IntrFuncRank
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree param)
# else
(name, param)
 register tIdent name;
 register tTree param;
# endif
{
# line 377 "Rank.puma"
  {
# line 379 "Rank.puma"
   if (! ((IntrFuncInquiry (name)))) goto yyL1;
  {
# line 380 "Rank.puma"
   if (! ((IntrFuncShape (name)))) goto yyL1;
  }
  }
   return 1;
yyL1:;

  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (param->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 386 "Rank.puma"
  {
# line 388 "Rank.puma"
   if (! (((name == IsIdent ("LBOUND")) || (name == IsIdent ("UBOUND"))))) goto yyL2;
  }
   return 1;
yyL2:;

  }
  }
  }
  }
# line 392 "Rank.puma"
  {
# line 394 "Rank.puma"
   if (! ((IntrFuncInquiry (name)))) goto yyL3;
  }
   return 0;
yyL3:;

  if (param->Kind == kBTP_LIST) {
# line 398 "Rank.puma"
  {
# line 400 "Rank.puma"
   if (! ((IntrFuncElemental (name)))) goto yyL4;
  }
   return ParameterRank (param);
yyL4:;

# line 404 "Rank.puma"
  {
# line 406 "Rank.puma"
   if (! ((IntrFuncRed (name)))) goto yyL5;
  {
# line 407 "Rank.puma"
   if (! ((HasDimArgument (param)))) goto yyL5;
  }
  }
   return TreeRank (param->BTP_LIST.Elem) - 1;
yyL5:;

# line 411 "Rank.puma"
  {
# line 413 "Rank.puma"
   if (! ((IntrFuncRed (name)))) goto yyL6;
  }
   return 0;
yyL6:;

# line 417 "Rank.puma"
  {
# line 419 "Rank.puma"
   if (! ((IntrFuncScan (name)))) goto yyL7;
  }
   return TreeRank (param->BTP_LIST.Elem);
yyL7:;

  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 423 "Rank.puma"
  {
# line 425 "Rank.puma"
   if (! ((IntrFuncScatter (name)))) goto yyL8;
  }
   return TreeRank (param->BTP_LIST.Next->BTP_LIST.Elem);
yyL8:;

  }
# line 429 "Rank.puma"
  {
# line 431 "Rank.puma"
   if (! ((IntrFuncLocRed (name)))) goto yyL9;
  {
# line 432 "Rank.puma"
   if (! ((HasDimArgument (param)))) goto yyL9;
  }
  }
   return TreeRank (param->BTP_LIST.Elem) - 1;
yyL9:;

# line 436 "Rank.puma"
  {
# line 438 "Rank.puma"
   if (! ((IntrFuncLocRed (name)))) goto yyL10;
  }
   return 1;
yyL10:;

  }
  if (equaltIdent (name, IsIdent ("TRANSPOSE"))) {
  if (param->Kind == kBTP_LIST) {
# line 442 "Rank.puma"
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("CSHIFT"))) {
  if (param->Kind == kBTP_LIST) {
# line 446 "Rank.puma"
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("EOSHIFT"))) {
  if (param->Kind == kBTP_LIST) {
# line 451 "Rank.puma"
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("SPREAD"))) {
  if (param->Kind == kBTP_LIST) {
# line 456 "Rank.puma"
   return TreeRank (param->BTP_LIST.Elem) + 1;

  }
  }
  if (equaltIdent (name, IsIdent ("MERGE"))) {
# line 463 "Rank.puma"
   return ParameterRank (param);

  }
  if (equaltIdent (name, IsIdent ("PACK"))) {
# line 468 "Rank.puma"
   return 1;

  }
  if (equaltIdent (name, IsIdent ("UNPACK"))) {
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 473 "Rank.puma"
   return TreeRank (param->BTP_LIST.Next->BTP_LIST.Elem);

  }
  }
  }
  if (equaltIdent (name, IsIdent ("MATMUL"))) {
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 478 "Rank.puma"
   return TreeRank (param->BTP_LIST.Elem) + TreeRank (param->BTP_LIST.Next->BTP_LIST.Elem) - 2;

  }
  }
  }
  if (equaltIdent (name, IsIdent ("DOT_PRODUCT"))) {
# line 483 "Rank.puma"
   return 0;

  }
  if (equaltIdent (name, IsIdent ("RESHAPE"))) {
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 488 "Rank.puma"
   return ArraySize (param->BTP_LIST.Next->BTP_LIST.Elem);

  }
  }
  }
  if (equaltIdent (name, IsIdent ("REPEAT"))) {
# line 495 "Rank.puma"
   return 0;

  }
  if (equaltIdent (name, IsIdent ("GRADE_UP"))) {
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
# line 506 "Rank.puma"
   return 2;

  }
  }
  }
  }
  if (equaltIdent (name, IsIdent ("GRADE_DOWN"))) {
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
# line 510 "Rank.puma"
   return 2;

  }
  }
  }
  }
  if (equaltIdent (name, IsIdent ("GRADE_UP"))) {
  if (param->Kind == kBTP_LIST) {
# line 514 "Rank.puma"
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("GRADE_DOWN"))) {
  if (param->Kind == kBTP_LIST) {
# line 518 "Rank.puma"
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("SORT_UP"))) {
  if (param->Kind == kBTP_LIST) {
# line 526 "Rank.puma"
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("SORT_DOWN"))) {
  if (param->Kind == kBTP_LIST) {
# line 530 "Rank.puma"
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, IsIdent ("TRIM"))) {
# line 538 "Rank.puma"
   return 0;

  }
  if (equaltIdent (name, IsIdent ("SELECTED_INT_KIND"))) {
# line 542 "Rank.puma"
   return 0;

  }
  if (equaltIdent (name, IsIdent ("SELECTED_REAL_KIND"))) {
# line 546 "Rank.puma"
   return 0;

  }
# line 550 "Rank.puma"
  {
# line 551 "Rank.puma"
   obj_protocol ("no rank for this intrinsic object : ", GetIntrinsicObject (name));
  }
   return - 1;

}

static int ArraySize
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kVAR_PARAM:
# line 566 "Rank.puma"
   return ArraySize (exp->VAR_PARAM.V);

  case kARRAY_EXP:
# line 570 "Rank.puma"
   return ArrayExpLength (exp->ARRAY_EXP.ELEMENTS);

  case kADDR:
# line 575 "Rank.puma"
   return ArraySize (exp->ADDR.E);

  case kVAR_EXP:
# line 580 "Rank.puma"
   return ArraySize (exp->VAR_EXP.V);

  case kINDEXED_VAR:
# line 586 "Rank.puma"
   return ActualSize (exp->INDEXED_VAR.IND_EXPS);

  case kUSED_VAR:
# line 591 "Rank.puma"
   return FormalSize (ArrayFormals (exp->USED_VAR.VARNAME->VAR_OBJ.Object));

  case kFUNC_CALL_EXP:
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 596 "Rank.puma"
  {
# line 598 "Rank.puma"
   if (! ((IsIntrCall (exp)))) goto yyL7;
  {
# line 599 "Rank.puma"
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("SHAPE")))) goto yyL7;
  }
  }
   return TreeRank (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem);
yyL7:;

  }
  }
  break;
  }

# line 604 "Rank.puma"
   return - 1;

}

static int ArrayExpLength
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kBTE_EMPTY) {
# line 611 "Rank.puma"
   return 0;

  }
  if (exp->Kind == kBTE_LIST) {
# line 615 "Rank.puma"
  {
# line 617 "Rank.puma"
   if (! ((TreeRank (exp->BTE_LIST.Elem) == 0))) goto yyL2;
  {
# line 618 "Rank.puma"
   if (! ((ArrayExpLength (exp->BTE_LIST.Next) >= 0))) goto yyL2;
  }
  }
   return ArrayExpLength (exp->BTE_LIST.Next) + 1;
yyL2:;

  }
# line 622 "Rank.puma"
   return - 1;

}

static int FormalSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kSHAPE_LIST) {
  if (t->SHAPE_LIST.Next->Kind == kSHAPE_EMPTY) {
# line 629 "Rank.puma"
   return FormalSize (t->SHAPE_LIST.Elem);

  }
  }
  if (t->Kind == kEXPLICIT_SHAPE) {
# line 634 "Rank.puma"
   return GetSliceSize (t->EXPLICIT_SHAPE.LOWER, t->EXPLICIT_SHAPE.UPPER);

  }
  if (Tree_IsType (t, kSHAPE_SPEC)) {
# line 638 "Rank.puma"
   return - 1;

  }
# line 642 "Rank.puma"
   return - 1;

}

static int ActualSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 648 "Rank.puma"
  {
# line 650 "Rank.puma"
   if (! ((IsStride1 (t->BTE_LIST.Elem->SLICE_EXP.INC)))) goto yyL1;
  }
   return GetSliceSize (t->BTE_LIST.Elem->SLICE_EXP.START, t->BTE_LIST.Elem->SLICE_EXP.STOP);
yyL1:;

  }
  }
  }
# line 655 "Rank.puma"
   return - 1;

}

static int GetSliceSize
# if defined __STDC__ | defined __cplusplus
(register tTree lb, register tTree ub)
# else
(lb, ub)
 register tTree lb;
 register tTree ub;
# endif
{
# line 662 "Rank.puma"
 {
  bool found;
  int val1;
  int val2;
  {
# line 664 "Rank.puma"

# line 665 "Rank.puma"

# line 666 "Rank.puma"

# line 668 "Rank.puma"
   GetIntConstValue (lb, & found, & val1);
# line 669 "Rank.puma"
   if (! ((found))) goto yyL1;
  {
# line 670 "Rank.puma"
   GetIntConstValue (ub, & found, & val2);
# line 671 "Rank.puma"
   if (! ((found))) goto yyL1;
  }
  }
  {
   return val2 - val1 + 1;
  }
 }
yyL1:;

# line 675 "Rank.puma"
   return - 1;

}

static bool HasDimArgument
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 693 "Rank.puma"
  {
# line 694 "Rank.puma"
   if (! ((TreeRank (param->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V) == 0))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (param->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 697 "Rank.puma"
  {
# line 698 "Rank.puma"
   if (! ((TreeRank (param->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V) == 0))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  }
  }
  return false;
}

void BeginRank ()
{
}

void CloseRank ()
{
}
