# include "PseudoDynamic.h"
# include "yyPseudoDynamic.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 50 "PseudoDynamic.puma"


# include <stdio.h>
# include "Idents.h"
# include "protocol.h"
# include "StringMem.h"
# include "Types.h"

# include "Transform.h"     /* ReplaceDECL, ... */
# include "Expressions.h"   /* MakeConstant, ... */
# include "Dalib.h"         /* MakeVarDeclA, ... */
# include "CodeDescriptors.h" /* DalibArrayAllocate */
# include "CodeMapping.h" /* DalibArrayAllocate */
# include "TriDenT.h"

# include "DefTable.h"

# define  MODULE "PseudoDynamic"

# define  static_lower_bound 1
# define  static_upper_bound 2

   /* every allocatable array will be translated to an array
      of size (static_lower_bound : static_upper_bound), but
      this size does not matter in any case                   */



static void yyExit () { Exit (1); }

void (* PseudoDynamic_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module PseudoDynamic, routine %s failed\n", yyFunction);
 PseudoDynamic_Exit ();
}

tTree MakePseudoDynamicArray ARGS((tTree val));
static int GetMaximalSize ARGS((tTree formals));
static int FormalIndexSize ARGS((tTree index, int tail_length));
static int GetIndexSize ARGS((tTree index, int MinProc));
tTree PseudoDynamicDecls ARGS((tIdent name, int rank, tTree type));
void PseudoDynamicIndexing ARGS((tTree t));
tTree PseudoDynamicAllocate ARGS((tTree var, int kind));
tTree PseudoDynamicDeallocate ARGS((tTree var));
static tTree FullDimStatements ARGS((tTree t, tIdent name, int n));
static tTree MakeStaticDimExp ARGS((tTree t, tIdent name, int n));
static tTree FullZeroStatement ARGS((tTree t, tIdent name, bool add_flag));
static tTree FullZeroAddDim ARGS((tTree t, tIdent name, int n));
static tTree MakeTheAllocate ARGS((tIdent name, int k, int N));
static tTree MakeTheDeallocate ARGS((tTree first));
static tTree MakeSizeCheck ARGS((tIdent name, int n, tIdent unitname, int maxsize));
static void LinearizeIndexes ARGS((tTree indexes, tIdent varname, int n));
static tTree MakeLinearIndex ARGS((tTree index, tIdent varname, int n));
static tTree MakeLinearIndexExpression ARGS((tTree index, tIdent varname, int n));
static tTree MakeDimExp ARGS((tTree exp, tIdent name, int n));

tTree MakePseudoDynamicArray
# if defined __STDC__ | defined __cplusplus
(register tTree val)
# else
(val)
 register tTree val;
# endif
{
  if (val->Kind == kVAR_DECL) {
# line 92 "PseudoDynamic.puma"
 {
  tDefinitions obj;
  tTree new_var;
  tTree new_decl;
  int rank;
  {
# line 94 "PseudoDynamic.puma"

# line 95 "PseudoDynamic.puma"

# line 96 "PseudoDynamic.puma"

# line 97 "PseudoDynamic.puma"

# line 99 "PseudoDynamic.puma"
   obj = GetLocalObject (val->VAR_DECL.Ident);
# line 101 "PseudoDynamic.puma"
 rank = VarRank (obj);

     if (IsRaggedVarObject (obj)) rank = 1;

     new_decl = PseudoDynamicDecls (val->VAR_DECL.Ident, rank,
                             MakeIntegerType (default_int_size));

     

     

     new_var = mEXPLICIT_SHAPE (MakeConstant (static_lower_bound), 
                                MakeConstant (static_upper_bound));

     new_var->EXPLICIT_SHAPE.Overlap = mOVERLAP_SPEC (0, 0, 0, 0);

     new_var = mARRAY_TYPE (mSHAPE_LIST (new_var, mSHAPE_EMPTY()), 
                            GetBaseType (GetObjectType (obj))); 

     new_var = mVAR_DECL (val->VAR_DECL.Ident, val->VAR_DECL.Line, new_var);

     new_decl = mDECL_LIST (new_var, new_decl);

   
  }
  {
   return new_decl;
  }
 }

  }
 yyAbort ("MakePseudoDynamicArray");
}

static int GetMaximalSize
# if defined __STDC__ | defined __cplusplus
(register tTree formals)
# else
(formals)
 register tTree formals;
# endif
{
  if (formals->Kind == kSHAPE_LIST) {
# line 137 "PseudoDynamic.puma"
   return GetMaximalSize (formals->SHAPE_LIST.Next) * FormalIndexSize (formals->SHAPE_LIST.Elem, TreeListLength (formals->SHAPE_LIST.Next));

  }
  if (formals->Kind == kSHAPE_EMPTY) {
# line 142 "PseudoDynamic.puma"
   return 1;

  }
# line 146 "PseudoDynamic.puma"
  {
# line 147 "PseudoDynamic.puma"
   failure_protocol ("PseudoDynamic", "GetMaximalSize", formals);
  }
   return 0;

}

static int FormalIndexSize
# if defined __STDC__ | defined __cplusplus
(register tTree index, register int tail_length)
# else
(index, tail_length)
 register tTree index;
 register int tail_length;
# endif
{
  if (index->Kind == kEXPLICIT_SHAPE) {
# line 153 "PseudoDynamic.puma"
 {
  int size;
  {
# line 155 "PseudoDynamic.puma"

# line 157 "PseudoDynamic.puma"
 if (tail_length == 0) 
        size = GetIndexSize (index, 1);
      else
        size = GetIndexSize (index, 1);
     size += index->EXPLICIT_SHAPE.Overlap->OVERLAP_SPEC.left_size + index->EXPLICIT_SHAPE.Overlap->OVERLAP_SPEC.right_size;
   
  }
  {
   return size;
  }
 }

  }
# line 166 "PseudoDynamic.puma"
  {
# line 167 "PseudoDynamic.puma"
   failure_protocol ("PseudoDynamic", "FormalIndexSize", index);
  }
   return 0;

}

static int GetIndexSize
# if defined __STDC__ | defined __cplusplus
(register tTree index, register int MinProc)
# else
(index, MinProc)
 register tTree index;
 register int MinProc;
# endif
{
  if (index->Kind == kEXPLICIT_SHAPE) {
# line 179 "PseudoDynamic.puma"
 {
  int val;
  int val1;
  bool found;
  {
# line 181 "PseudoDynamic.puma"

# line 182 "PseudoDynamic.puma"

# line 183 "PseudoDynamic.puma"

# line 185 "PseudoDynamic.puma"
 GetIntConstValue (index->EXPLICIT_SHAPE.LOWER, &found, &val);
     if (!found)
       failure_protocol ("PseudoDynamice", "GetIndexSize (lb)", index);
     GetIntConstValue (index->EXPLICIT_SHAPE.UPPER, &found, &val1);
     if (!found)
       failure_protocol ("PseudoDynamice", "GetIndexSize (ub)", index);
     val = val1 - val + 1;               
     val = (val + MinProc - 1) / MinProc;
   
  }
  {
   return val;
  }
 }

  }
 yyAbort ("GetIndexSize");
}

tTree PseudoDynamicDecls
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int rank, register tTree type)
# else
(name, rank, type)
 register tIdent name;
 register int rank;
 register tTree type;
# endif
{
  if (equalint (rank, 0)) {
# line 214 "PseudoDynamic.puma"
   return mDECL_LIST (MakeVarDeclA (name, "_ZERO", MakeIntegerType (default_addr_size)), NoTree);

  }
# line 220 "PseudoDynamic.puma"
   return mDECL_LIST (MakeVarDeclAn (name, "_DIM", rank, type), PseudoDynamicDecls (name, rank - 1, type));

}

void PseudoDynamicIndexing
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 241 "PseudoDynamic.puma"
 {
  tDefinitions obj;
  tTree zero;
  {
# line 243 "PseudoDynamic.puma"

# line 245 "PseudoDynamic.puma"
   obj = GetGlobalObject (t->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
# line 247 "PseudoDynamic.puma"
   if (! ((IsRaggedVarObject (obj)))) goto yyL1;
  {
# line 249 "PseudoDynamic.puma"

# line 251 "PseudoDynamic.puma"
 zero = mVAR_EXP (MakeUsedVarA (t->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, "_ZERO")); 

     zero = mOP_EXP (mOP_PLUS (), zero, TriDenTOffset (obj, t->INDEXED_VAR.IND_EXPS));
 
     t->INDEXED_VAR.IND_EXPS = mBTE_LIST (zero, mBTE_EMPTY ());
   
  }
  }
   return;
 }
yyL1:;

# line 269 "PseudoDynamic.puma"
  {
# line 271 "PseudoDynamic.puma"
   LinearizeIndexes (t->INDEXED_VAR.IND_EXPS, t->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, 0);
  }
   return;

  }
  }
;
}

tTree PseudoDynamicAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 289 "PseudoDynamic.puma"
   return DalibArrayAllocate (var->INDEXED_VAR.IND_VAR, kind);

  }
# line 294 "PseudoDynamic.puma"
  {
# line 295 "PseudoDynamic.puma"
   failure_protocol (MODULE, "PseudoDynamicAllocate", var);
  }
   return NoTree;

}

tTree PseudoDynamicDeallocate
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 303 "PseudoDynamic.puma"
   return NoTree;

}

static tTree FullDimStatements
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tIdent name, register int n)
# else
(t, name, n)
 register tTree t;
 register tIdent name;
 register int n;
# endif
{
# line 317 "PseudoDynamic.puma"

tTree var, exp, newacf;

  if (t->Kind == kBTE_LIST) {
# line 321 "PseudoDynamic.puma"
  {
# line 322 "PseudoDynamic.puma"
 var    = MakeUsedVarAn (name, "_DIM", n);
      exp    = MakeStaticDimExp (t->BTE_LIST.Elem, name, n);
      newacf = mACF_BASIC (mASSIGN_STMT (var, exp));
      newacf = CombineACF (newacf, FullDimStatements (t->BTE_LIST.Next, name, n+1));
    
  }
   return newacf;

  }
  if (t->Kind == kBTE_EMPTY) {
# line 330 "PseudoDynamic.puma"
   return NoTree;

  }
# line 334 "PseudoDynamic.puma"
  {
# line 335 "PseudoDynamic.puma"
   failure_protocol ("PseudoDynamic", "FullDimStatements", t);
  }
   return NoTree;

}

static tTree MakeStaticDimExp
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tIdent name, register int n)
# else
(t, name, n)
 register tTree t;
 register tIdent name;
 register int n;
# endif
{
  if (t->Kind == kSLICE_EXP) {
# line 341 "PseudoDynamic.puma"
   return MakeDimExp (MakeSliceExp (t->SLICE_EXP.START, t->SLICE_EXP.STOP), name, n - 1);

  }
# line 348 "PseudoDynamic.puma"
   return MakeDimExp (t, name, n - 1);

}

static tTree FullZeroStatement
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tIdent name, register bool add_flag)
# else
(t, name, add_flag)
 register tTree t;
 register tIdent name;
 register bool add_flag;
# endif
{
# line 366 "PseudoDynamic.puma"

tTree var, exp, newacf;

# line 370 "PseudoDynamic.puma"
  {
# line 371 "PseudoDynamic.puma"
 var = MakeUsedVarA (name, "_ZERO");
      if (add_flag)
         { exp = mVAR_EXP (MakeUsedVarA (name, "_ZERO"));
           exp = AddConstant (exp, static_lower_bound);
         }
        else
         exp = MakeConstant (static_lower_bound);
      exp = mOP_EXP (mOP_MINUS (), exp, FullZeroAddDim (t, name, 0));
      newacf = mASSIGN_STMT (var, exp);
      newacf = mACF_BASIC (newacf);
      newacf = mACF_LIST (newacf, NoTree);
    
  }
   return newacf;

}

static tTree FullZeroAddDim
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tIdent name, register int n)
# else
(t, name, n)
 register tTree t;
 register tIdent name;
 register int n;
# endif
{
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 388 "PseudoDynamic.puma"
   return MakeDimExp (t->BTE_LIST.Elem->SLICE_EXP.START, name, n);

  }
# line 397 "PseudoDynamic.puma"
   return mOP_EXP (mOP_PLUS (), MakeDimExp (t->BTE_LIST.Elem->SLICE_EXP.START, name, n), FullZeroAddDim (t->BTE_LIST.Next, name, n + 1));

  }
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 393 "PseudoDynamic.puma"
   return MakeDimExp (NoTree, name, n);

  }
# line 403 "PseudoDynamic.puma"
   return mOP_EXP (mOP_PLUS (), MakeDimExp (NoTree, name, n), FullZeroAddDim (t->BTE_LIST.Next, name, n + 1));

  }
# line 409 "PseudoDynamic.puma"
  {
# line 410 "PseudoDynamic.puma"
   failure_protocol ("PseudoDynamic", "FullZeroAddDim", t);
  }
   return NoTree;

}

static tTree MakeTheAllocate
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int k, register int N)
# else
(name, k, N)
 register tIdent name;
 register int k;
 register int N;
# endif
{
# line 422 "PseudoDynamic.puma"

tTree param, paramlist, new;

# line 426 "PseudoDynamic.puma"
  {
# line 428 "PseudoDynamic.puma"
 paramlist = mBTP_EMPTY ();
     param     = ExpToVarParam (MakeConstant (N));
     paramlist = mBTP_LIST (param, paramlist);
     param     = mVAR_PARAM (MakeUsedVarAn (name, "_DIM", k));
     paramlist = mBTP_LIST (param, paramlist);
     param     = mVAR_PARAM (MakeUsedVarA (name, "_ZERO"));
     paramlist = mBTP_LIST (param, paramlist);
     param     = mVAR_PARAM (MakeUsedVarA (name, ""));
     paramlist = mBTP_LIST (param, paramlist);
     new       = mPROC_OBJ (MakeDalibId ("allocate"));
     new       = mACF_BASIC (mCALL_STMT (new, paramlist));
     new       = mACF_LIST (new, NoTree);
   
  }
   return new;

}

static tTree MakeTheDeallocate
# if defined __STDC__ | defined __cplusplus
(register tTree first)
# else
(first)
 register tTree first;
# endif
{
# line 454 "PseudoDynamic.puma"

tTree param, paramlist, new;

# line 458 "PseudoDynamic.puma"
  {
# line 460 "PseudoDynamic.puma"
 paramlist = mBTP_EMPTY ();
     param     = mVAR_PARAM (first);
     paramlist = mBTP_LIST (param, paramlist);
     new       = mPROC_OBJ (MakeDalibId ("deallocate"));
     new       = mACF_BASIC (mCALL_STMT (new, paramlist));
     new       = mACF_LIST (new, NoTree);
   
  }
   return new;

}

static tTree MakeSizeCheck
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int n, register tIdent unitname, register int maxsize)
# else
(name, n, unitname, maxsize)
 register tIdent name;
 register int n;
 register tIdent unitname;
 register int maxsize;
# endif
{
# line 480 "PseudoDynamic.puma"

tTree param, paramlist;
tTree newacf;
char string[50];
int  len;

# line 487 "PseudoDynamic.puma"
  {
# line 488 "PseudoDynamic.puma"
 paramlist = mBTP_EMPTY();
    GetString (unitname, string); len = strlen (string);
    param     = ExpToVarParam (MakeConstant (len));
    paramlist = mBTP_LIST(param, paramlist);
    param     = mSTRING_CONSTANT (PutString (string, len));
    param     = mVAR_PARAM (mADDR (mCONST_EXP (param)));
    paramlist = mBTP_LIST(param, paramlist);
    GetString (name, string); len = strlen (string);
    param     = ExpToVarParam (MakeConstant (len));
    paramlist = mBTP_LIST(param, paramlist);
    param     = mSTRING_CONSTANT (PutString (string, len));
    param     = mVAR_PARAM (mADDR (mCONST_EXP (param)));
    paramlist = mBTP_LIST(param, paramlist);
    param     = ExpToVarParam (MakeConstant (maxsize));
    paramlist = mBTP_LIST(param, paramlist);
    param     = mVAR_PARAM (MakeUsedVarAn (name, "_DIM", n));
    paramlist = mBTP_LIST(param, paramlist);
    newacf    = mCALL_STMT (mPROC_OBJ (MakeDalibId ("verify_size")), paramlist);
    newacf    = mACF_LIST (mACF_BASIC (newacf), NoTree);
  
  }
   return newacf;

}

static void LinearizeIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register tIdent varname, register int n)
# else
(indexes, varname, n)
 register tTree indexes;
 register tIdent varname;
 register int n;
# endif
{
  if (indexes->Kind == kBTE_LIST) {
# line 535 "PseudoDynamic.puma"
  {
# line 536 "PseudoDynamic.puma"
   if (! ((n > 0))) goto yyL1;
  {
# line 537 "PseudoDynamic.puma"
   LinearizeIndexes (indexes->BTE_LIST.Next, varname, n - 1);
  }
  }
   return;
yyL1:;

# line 544 "PseudoDynamic.puma"
  {
# line 545 "PseudoDynamic.puma"
 indexes->BTE_LIST.Elem  = MakeLinearIndex (indexes, varname, 0);
     indexes->BTE_LIST.Next = mBTE_EMPTY ();  
   
  }
   return;

  }
  if (indexes->Kind == kBTE_EMPTY) {
# line 540 "PseudoDynamic.puma"
  {
# line 541 "PseudoDynamic.puma"
   if (! ((n == 0))) goto yyL2;
  }
   return;
yyL2:;

  }
# line 550 "PseudoDynamic.puma"
  {
# line 551 "PseudoDynamic.puma"
   failure_protocol ("PseudoDynamic", "ChangeFullIndexExpression", indexes);
  }
   return;

;
}

static tTree MakeLinearIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index, register tIdent varname, register int n)
# else
(index, varname, n)
 register tTree index;
 register tIdent varname;
 register int n;
# endif
{
  if (index->Kind == kBTE_LIST) {
  if (index->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 565 "PseudoDynamic.puma"
  {
# line 566 "PseudoDynamic.puma"
 index->BTE_LIST.Elem->SLICE_EXP.START = MakeLinearIndexExpression (mBTE_LIST (index->BTE_LIST.Elem->SLICE_EXP.START, index->BTE_LIST.Next), varname, n);
      index->BTE_LIST.Elem->SLICE_EXP.STOP  = MakeLinearIndexExpression (mBTE_LIST (index->BTE_LIST.Elem->SLICE_EXP.STOP, index->BTE_LIST.Next), varname, n);
    
  }
   return index->BTE_LIST.Elem;

  }
# line 572 "PseudoDynamic.puma"
   return MakeLinearIndexExpression (index, varname, 0);

  }
 yyAbort ("MakeLinearIndex");
}

static tTree MakeLinearIndexExpression
# if defined __STDC__ | defined __cplusplus
(register tTree index, register tIdent varname, register int n)
# else
(index, varname, n)
 register tTree index;
 register tIdent varname;
 register int n;
# endif
{
  if (index->Kind == kBTE_LIST) {
  if (index->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 585 "PseudoDynamic.puma"
  {
# line 586 "PseudoDynamic.puma"
   error_protocol ("linearization of index triplet not possible");
  }
   return MakeLinearIndexExpression (index->BTE_LIST.Next, varname, n + 1);

  }
# line 590 "PseudoDynamic.puma"
   return mOP_EXP (mOP_PLUS (), MakeLinearIndexExpression (index->BTE_LIST.Next, varname, n + 1), MakeDimExp (index->BTE_LIST.Elem, varname, n));

  }
  if (index->Kind == kBTE_EMPTY) {
# line 598 "PseudoDynamic.puma"
   return mVAR_EXP (MakeUsedVarA (varname, "_ZERO"));

  }
 yyAbort ("MakeLinearIndexExpression");
}

static tTree MakeDimExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tIdent name, register int n)
# else
(exp, name, n)
 register tTree exp;
 register tIdent name;
 register int n;
# endif
{
# line 612 "PseudoDynamic.puma"

tTree newexp;
int val;
bool found;

# line 618 "PseudoDynamic.puma"
  {
# line 619 "PseudoDynamic.puma"
   if (! ((exp == NoTree))) goto yyL1;
  {
# line 620 "PseudoDynamic.puma"
   if (! ((n <= 0))) goto yyL1;
  }
  }
   return (MakeConstant (1));
yyL1:;

# line 624 "PseudoDynamic.puma"
  {
# line 625 "PseudoDynamic.puma"
   if (! ((exp == NoTree))) goto yyL2;
  }
   return mVAR_EXP (MakeUsedVarAn (name, "_DIM", n));
yyL2:;

# line 629 "PseudoDynamic.puma"
  {
# line 630 "PseudoDynamic.puma"
   if (! ((n <= 0))) goto yyL3;
  }
   return exp;
yyL3:;

# line 633 "PseudoDynamic.puma"
  {
# line 634 "PseudoDynamic.puma"
 newexp = mVAR_EXP (MakeUsedVarAn (name, "_DIM", n));
     GetIntConstValue (exp, &found, &val);
     if (found && (val == 0))
        newexp = exp;           
      else if (found && (val == 1))
        newexp = newexp;
      else
        newexp = mOP_EXP (mOP_TIMES (), exp, newexp);
   
  }
   return newexp;

}

void BeginPseudoDynamic ()
{
}

void ClosePseudoDynamic ()
{
}
