# include "ParNest.h"
# include "yyParNest.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 37 "ParNest.puma"


# undef DEBUG

# include "Idents.h"
# include "protocol.h"

# include "Nesting.h"
# include "Expressions.h"
# include "Shapes.h"
# include "TreeOps.h"          /* TreeVarName */

# define MODULE "ParNest"

# define MAXConstructs 100

/*********************************************************************
*                                                                    * 
*  Global Data for ParNest                                           * 
*                                                                    * 
*  ParNest[0]          DO     I1 = ...                               *
*  ParNest[1]          DO     I2 = ...                               *
*  ...                                                               *
*  ParNest[ParNesting-1]  FORALL Ik = ...                            *
*                                                                    *
*    stmt      :         A(I1,I2,...,Ik)  = ....                     *
*                                                                    *
*********************************************************************/

static int ParNesting = 0;            /* actual depth of nesting          */
static tTree ParNest[MAXConstructs];  /* actual stmts of parallel nesting */



static void yyExit () { Exit (1); }

void (* ParNest_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ParNest, routine %s failed\n", yyFunction);
 ParNest_Exit ();
}

void IncParNesting ARGS((tTree stmt));
void DecParNesting ARGS((tTree stmt));
int GetParNestingDepth ARGS(());
tTree GetParNestACF ARGS((int n));
bool HasUserHome ARGS(());
tTree GetUserHome ARGS(());
bool UserIndependent ARGS(());
bool InTaskRegion ARGS(());
static bool IsTaskRegionStmt ARGS((tTree stmt));
bool IsParallelMasked ARGS(());
static bool IsConditionalStmt ARGS((tTree stmt));
static bool IsHomeStmt ARGS((tTree stmt));
static bool IsUserIndependentLoop ARGS((tTree stmt));
static bool IsUserHomeStmt ARGS((tTree stmt));
static tTree GetHomeVar ARGS((tTree stmt));
bool IsNewVariable ARGS((tTree var));
bool IsResidentVariable ARGS((tTree var));
static bool IsNewDefined ARGS((tTree var, tTree stmt));
static bool IsResidentDefined ARGS((tTree var, tTree stmt));
static bool IsSubVarInVarList ARGS((tTree v, tTree vlist));
static bool IsSubVar ARGS((tTree selected_var, tTree full_var));

void IncParNesting
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
# line 81 "ParNest.puma"
  {
# line 83 "ParNest.puma"
   if (! ((IsCountLoop (stmt)))) goto yyL1;
  {
# line 84 "ParNest.puma"
   IncLoopNesting (stmt);
# line 85 "ParNest.puma"
   goto yyL1;
  }
  }
yyL1:;

# line 88 "ParNest.puma"
  {
# line 90 "ParNest.puma"
 if (ParNesting >= MAXConstructs)  
       simple_error_protocol ("to deep nesting within parallel constructs");
      else
       { ParNest [ParNesting] = stmt;
         ParNesting += 1;
       }
   
  }
   return;

;
}

void DecParNesting
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
# line 101 "ParNest.puma"
  {
# line 103 "ParNest.puma"
   if (! ((IsCountLoop (stmt)))) goto yyL1;
  {
# line 104 "ParNest.puma"
   DecLoopNesting (stmt);
# line 105 "ParNest.puma"
   goto yyL1;
  }
  }
yyL1:;

# line 108 "ParNest.puma"
  {
# line 110 "ParNest.puma"
 if (ParNesting == 0)  
       simple_error_protocol ("ParNest : no construct to be quit");
      else if (ParNest[ParNesting-1] != stmt)
       simple_error_protocol ("ParNest : wrong stmt to be quit");
      else
       ParNesting -= 1;
   
  }
   return;

;
}

int GetParNestingDepth
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 121 "ParNest.puma"
   return ParNesting;

}

tTree GetParNestACF
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
# line 127 "ParNest.puma"
  {
# line 128 "ParNest.puma"
   if (! ((n >= 1))) goto yyL1;
  {
# line 129 "ParNest.puma"
   if (! ((n <= ParNesting))) goto yyL1;
  }
  }
   return ParNest [n - 1];
yyL1:;

# line 133 "ParNest.puma"
  {
# line 135 "ParNest.puma"
 char msg[100];
      sprintf (msg, "GetParNestACF, index = %d must be >= 1 and <= %d\n",
                     n, ParNesting);
      failure_protocol (MODULE, msg, NoTree);
    
  }
   return NoTree;

}

bool HasUserHome
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 155 "ParNest.puma"
 {
  bool user_home;
  {
# line 157 "ParNest.puma"

# line 159 "ParNest.puma"
 int i;

     user_home = false;

     for (i=0; i<ParNesting; i++)

       if (IsUserHomeStmt (ParNest[i]))
       
          user_home = true;
   
# line 170 "ParNest.puma"
   if (! ((user_home))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

tTree GetUserHome
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 175 "ParNest.puma"
 {
  tTree user_home;
  {
# line 177 "ParNest.puma"

# line 179 "ParNest.puma"
 int i;

     for (i=0; i<ParNesting; i++)

       if (IsUserHomeStmt (ParNest[i]))
       
          user_home = GetHomeVar (ParNest[i]);
   
  }
  {
   return user_home;
  }
 }

}

bool UserIndependent
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 201 "ParNest.puma"
 {
  bool is_independent;
  {
# line 203 "ParNest.puma"

# line 205 "ParNest.puma"
 int i;

     is_independent = false;

     for (i=0; i<ParNesting; i++)

       if (IsUserIndependentLoop (ParNest[i]))
       
          is_independent = true;
   
# line 216 "ParNest.puma"
   if (! ((is_independent))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

bool InTaskRegion
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 227 "ParNest.puma"
 {
  bool is_task;
  {
# line 229 "ParNest.puma"

# line 231 "ParNest.puma"
 int i;

     is_task = false;

     for (i=0; i<ParNesting; i++)

       if (IsTaskRegionStmt (ParNest[i]))
       
          is_task = true;
   
# line 242 "ParNest.puma"
   if (! ((is_task))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool IsTaskRegionStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_TASK_REGION) {
# line 247 "ParNest.puma"
   return true;

  }
  return false;
}

bool IsParallelMasked
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 258 "ParNest.puma"
 {
  bool masked;
  {
# line 260 "ParNest.puma"

# line 262 "ParNest.puma"
 int i;

     masked = false;

     for (i=0; i<ParNesting; i++)

       if (IsConditionalStmt (ParNest[i]))
       
          masked = true;
   
# line 273 "ParNest.puma"
   if (! ((masked))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool IsConditionalStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_IF) {
# line 278 "ParNest.puma"
   return true;

  }
  return false;
}

static bool IsHomeStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_HOME) {
# line 283 "ParNest.puma"
   return true;

  }
  return false;
}

static bool IsUserIndependentLoop
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_DO) {
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 288 "ParNest.puma"
  {
# line 290 "ParNest.puma"
   if (! ((stmt->ACF_DO.DO_DEP_INFO->INDEP_INFO.user_independent))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  return false;
}

static bool IsUserHomeStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_HOME) {
# line 295 "ParNest.puma"
  {
# line 297 "ParNest.puma"
   if (! ((stmt->ACF_HOME.user_home))) goto yyL1;
  }
   return true;
yyL1:;

  }
  return false;
}

static tTree GetHomeVar
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_HOME) {
# line 302 "ParNest.puma"
   return stmt->ACF_HOME.HOME_VAR;

  }
# line 307 "ParNest.puma"
  {
# line 309 "ParNest.puma"
   failure_protocol (MODULE, "GetHomeVar", stmt);
  }
   return NoTree;

}

bool IsNewVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 336 "ParNest.puma"
 {
  bool found;
  {
# line 338 "ParNest.puma"

# line 340 "ParNest.puma"
 int  i;
     bool stop;

#ifdef DEBUG
     printf ("IsNewVariable (");
     FileUnparse (stdout, var);
#endif

     found = false;
     i     = ParNesting;   
     stop  = (i <= 0);

     while (!stop) 

       { i--;

         

         if (IsHomeStmt (ParNest[i])) stop = true;
         if (IsNewDefined (var, ParNest[i])) found = true;
         if (i == 0) stop = true;
       }

   
# line 365 "ParNest.puma"
   if (! ((found))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

bool IsResidentVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 376 "ParNest.puma"
 {
  bool found;
  {
# line 379 "ParNest.puma"

# line 381 "ParNest.puma"
 int  i;
     bool stop;

     found = false;
     i     = ParNesting;   
     stop  = (i <= 0);

     while (!stop) 

       { i--;

         

         if (IsHomeStmt (ParNest[i])) stop = true;
         if (IsResidentDefined (var, ParNest[i])) found = true;
         if (i == 0) stop = true;
       }

   
# line 401 "ParNest.puma"
   if (! ((found))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool IsNewDefined
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stmt)
# else
(var, stmt)
 register tTree var;
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_NEW) {
# line 416 "ParNest.puma"
  {
# line 418 "ParNest.puma"
   if (! ((IsSubVarInVarList (var, stmt->ACF_NEW.NEW_VAR)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  return false;
}

static bool IsResidentDefined
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stmt)
# else
(var, stmt)
 register tTree var;
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_RESIDENT) {
# line 429 "ParNest.puma"
  {
# line 431 "ParNest.puma"
   if (! ((IsSubVarInVarList (var, stmt->ACF_RESIDENT.RESIDENT_VAR)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  return false;
}

static bool IsSubVarInVarList
# if defined __STDC__ | defined __cplusplus
(register tTree v, register tTree vlist)
# else
(v, vlist)
 register tTree v;
 register tTree vlist;
# endif
{
# line 442 "ParNest.puma"
  {
# line 444 "ParNest.puma"
   if (! ((vlist == NoTree))) goto yyL1;
  {
# line 445 "ParNest.puma"
   return false;
  }
  }
yyL1:;

  if (vlist->Kind == kBTV_LIST) {
  if (vlist->BTV_LIST.Elem->Kind == kDUMMY_VAR) {
  if (vlist->BTV_LIST.Next->Kind == kBTV_EMPTY) {
# line 448 "ParNest.puma"
   return true;

  }
  }
# line 451 "ParNest.puma"
  {
# line 453 "ParNest.puma"
   if (! ((IsSubVar (v, vlist->BTV_LIST.Elem)))) goto yyL3;
  }
   return true;
yyL3:;

# line 456 "ParNest.puma"
  {
# line 458 "ParNest.puma"
   if (! ((IsSubVarInVarList (v, vlist->BTV_LIST.Next)))) goto yyL4;
  }
   return true;
yyL4:;

  }
  return false;
}

static bool IsSubVar
# if defined __STDC__ | defined __cplusplus
(register tTree selected_var, register tTree full_var)
# else
(selected_var, full_var)
 register tTree selected_var;
 register tTree full_var;
# endif
{
  if (full_var->Kind == kINDEXED_VAR) {
# line 478 "ParNest.puma"
  {
# line 480 "ParNest.puma"
   if (! ((IsWholeVar (full_var)))) goto yyL1;
  {
# line 481 "ParNest.puma"
   if (! ((IsSubVar (selected_var, full_var->INDEXED_VAR.IND_VAR)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  if (selected_var->Kind == kUSED_VAR) {
  if (full_var->Kind == kUSED_VAR) {
# line 484 "ParNest.puma"
  {
# line 486 "ParNest.puma"
   if (! ((TreeVarName (selected_var->USED_VAR.VARNAME) == TreeVarName (full_var->USED_VAR.VARNAME)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  if (selected_var->Kind == kINDEXED_VAR) {
  if (full_var->Kind == kUSED_VAR) {
# line 489 "ParNest.puma"
  {
# line 491 "ParNest.puma"
   if (! ((IsSubVar (selected_var->INDEXED_VAR.IND_VAR, full_var)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  if (full_var->Kind == kINDEXED_VAR) {
# line 499 "ParNest.puma"
  {
# line 501 "ParNest.puma"
   if (! ((IsSubVar (selected_var->INDEXED_VAR.IND_VAR, full_var->INDEXED_VAR.IND_VAR)))) goto yyL5;
  {
# line 502 "ParNest.puma"
   if (! ((EqualIndexes (selected_var->INDEXED_VAR.IND_EXPS, full_var->INDEXED_VAR.IND_EXPS)))) goto yyL5;
  }
  }
   return true;
yyL5:;

  }
  }
  if (selected_var->Kind == kSELECTED_VAR) {
  if (full_var->Kind == kUSED_VAR) {
# line 494 "ParNest.puma"
  {
# line 496 "ParNest.puma"
   if (! ((IsSubVar (selected_var->SELECTED_VAR.SELEC_VAR, full_var)))) goto yyL4;
  }
   return true;
yyL4:;

  }
  }
  return false;
}

void BeginParNest ()
{
}

void CloseParNest ()
{
}
