# include "Ownership.h"
# include "yyOwnership.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 41 "Ownership.puma"


# include <stdio.h>
# include "protocol.h"
# include "Idents.h"
# include "StringMem.h"

# include "TreeOps.h"
# include "Rank.h"
# include "Expressions.h"
# include "Types.h"             /* TreeListGet, ... */
# include "Distributions.h"     /* DimListLength, ... */

# include "DefTable.h"          /* GetGlobalObject    */
# include "Transform.h"         /* MakeStmtList       */

# include "Descriptor.h"
# include "HomeDescriptor.h"
# include "MoveDescriptor.h"
# include "Nesting.h"           /* GetCurrentModel    */

# define MODULE "Ownership"

# undef DEBUG



static void yyExit () { Exit (1); }

void (* Ownership_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Ownership, routine %s failed\n", yyFunction);
 Ownership_Exit ();
}

tTree MakeOnSelection ARGS((tTree stmt, pvar outer_home, pvar inner_home));
void BetterOnSelection ARGS((tTree stmt, pvar inner_home, pvar outer_home));
void OnIdUpdate ARGS((tTree stmt, pvar home, tTree id));
static tTree GetOnVal ARGS((pvar vard, int topdim));
tTree MakeOnVal ARGS((pvar vard, int topdim));
tTree MakeOnTopology ARGS((pvar vard));
tTree MakeOnSpecs ARGS((pvar vard));
static tTree MakeOnSpecs1 ARGS((tTree old, pvar vard));
static tTree MakeOnIdVals ARGS((pvar home, tTree id));
static tTree AddOnIdRanges ARGS((tTree spec, pvar home, tTree id));
static void FindLoopId ARGS((pvar owner, tTree id, bool * yyP3, int * yyP2, tTree * yyP1));
static void FindShiftLoopId ARGS((pvar owner, tTree id, int * yyP7, int * yyP6, int * yyP5, int * yyP4));
static tTree AddOnSpecs ARGS((tTree spec, pvar inner_home, pvar outer_home));
void MakeOnLoop ARGS((tTree t, pvar home));
static tTree MakeOnInfo ARGS((pvar vard, int dim, int base, int stride));
static tTree SelectBody ARGS((tTree body, pvar home, tTree on_vals));
static bool IsParallelInfo ARGS((tTree info));

tTree MakeOnSelection
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar outer_home, pvar inner_home)
# else
(stmt, outer_home, inner_home)
 register tTree stmt;
 pvar outer_home;
 pvar inner_home;
# endif
{
# line 93 "Ownership.puma"
  {
# line 95 "Ownership.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return stmt;
yyL1:;

# line 100 "Ownership.puma"
  {
# line 102 "Ownership.puma"
   if (! ((IsReplicatedDescriptor (outer_home)))) goto yyL2;
  {
# line 103 "Ownership.puma"
   if (! ((IsReplicatedDescriptor (inner_home)))) goto yyL2;
  }
  }
   return stmt;
yyL2:;

# line 108 "Ownership.puma"
  {
# line 110 "Ownership.puma"
   if (! ((IsNoDescriptor (inner_home)))) goto yyL3;
  }
   return stmt;
yyL3:;

# line 115 "Ownership.puma"
  {
# line 117 "Ownership.puma"
   if (! ((IsReplicatedDescriptor (outer_home)))) goto yyL4;
  }
   return mACF_ON (MakeOnTopology (inner_home), MakeOnSpecs (inner_home), MakeStmtList (stmt));
yyL4:;

# line 125 "Ownership.puma"
 {
  int dim;
  tTree spec;
  tTree new;
  {
# line 129 "Ownership.puma"
   if (! ((SameDescriptorTopology (outer_home, inner_home)))) goto yyL5;
  {
# line 133 "Ownership.puma"

# line 134 "Ownership.puma"

# line 135 "Ownership.puma"

# line 137 "Ownership.puma"
 spec = NoTree;

     for (dim = 1; dim <= outer_home->topology_rank; dim ++)
 
      { tTree was_val, is_val;

        was_val = GetOnVal (outer_home, dim);
        is_val  = GetOnVal (inner_home, dim);
 
        

        if ((was_val == NoTree) && (is_val != NoTree))

           { if (spec == NoTree) spec = mON_EMPTY ();
             spec = mON_LIST (MakeOnVal (inner_home, dim), spec);
           }

      } 

      new = stmt;

      

      if (spec != NoTree)

        new = mACF_ON (MakeOnTopology (inner_home), spec,
                       MakeStmtList (stmt));

   
  }
  }
  {
   return new;
  }
 }
yyL5:;

# line 170 "Ownership.puma"
  {
# line 172 "Ownership.puma"
   error_protocol ("could not make on selection");
# line 173 "Ownership.puma"
   tree_protocol ("was home : ", PrintableDescriptorVar (outer_home));
# line 174 "Ownership.puma"
   tree_protocol ("is  home : ", PrintableDescriptorVar (inner_home));
  }
   return stmt;

}

void BetterOnSelection
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar inner_home, pvar outer_home)
# else
(stmt, inner_home, outer_home)
 register tTree stmt;
 pvar inner_home;
 pvar outer_home;
# endif
{
# line 192 "Ownership.puma"
  {
# line 194 "Ownership.puma"
   if (! ((VDIsSubSet (outer_home, inner_home)))) goto yyL1;
  }
   return;
yyL1:;

  if (stmt->Kind == kREDUCTION_STMT) {
# line 197 "Ownership.puma"
  {
# line 199 "Ownership.puma"
   if (! ((IsReplicatedDescriptor (outer_home)))) goto yyL2;
  {
# line 201 "Ownership.puma"
 stmt->REDUCTION_STMT.RED_TOP  = MakeOnTopology (inner_home);
     stmt->REDUCTION_STMT.RED_SPEC = MakeOnSpecs1 (stmt->REDUCTION_STMT.RED_SPEC, inner_home);
   
  }
  }
   return;
yyL2:;

# line 206 "Ownership.puma"
  {
# line 208 "Ownership.puma"
 stmt->REDUCTION_STMT.RED_SPEC = AddOnSpecs (stmt->REDUCTION_STMT.RED_SPEC, inner_home, outer_home);  
  }
   return;

  }
  if (stmt->Kind == kBROADCAST_STMT) {
# line 211 "Ownership.puma"
  {
# line 213 "Ownership.puma"
   if (! ((IsReplicatedDescriptor (outer_home)))) goto yyL4;
  {
# line 215 "Ownership.puma"
 stmt->BROADCAST_STMT.OWNER_TOP  = MakeOnTopology (inner_home);
     stmt->BROADCAST_STMT.OWNER_SPEC = MakeOnSpecs1 (stmt->BROADCAST_STMT.OWNER_SPEC, inner_home);
   
  }
  }
   return;
yyL4:;

# line 220 "Ownership.puma"
  {
# line 222 "Ownership.puma"
 stmt->BROADCAST_STMT.OWNER_SPEC = AddOnSpecs (stmt->BROADCAST_STMT.OWNER_SPEC, inner_home, outer_home); 
  }
   return;

  }
# line 225 "Ownership.puma"
  {
# line 227 "Ownership.puma"
   failure_protocol (MODULE, "BetterOnSelection", stmt);
  }
   return;

;
}

void OnIdUpdate
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar home, register tTree id)
# else
(stmt, home, id)
 register tTree stmt;
 pvar home;
 register tTree id;
# endif
{
  if (stmt->Kind == kREDUCTION_STMT) {
# line 246 "Ownership.puma"
  {
# line 248 "Ownership.puma"
 stmt->REDUCTION_STMT.RED_SPEC = AddOnIdRanges (stmt->REDUCTION_STMT.RED_SPEC, home, id); 
  }
   return;

  }
  if (stmt->Kind == kBROADCAST_STMT) {
# line 251 "Ownership.puma"
  {
# line 253 "Ownership.puma"
 stmt->BROADCAST_STMT.OWNER_SPEC = AddOnIdRanges (stmt->BROADCAST_STMT.OWNER_SPEC, home, id); 
  }
   return;

  }
# line 256 "Ownership.puma"
  {
# line 258 "Ownership.puma"
   failure_protocol (MODULE, "OnIdUpdates", stmt);
  }
   return;

;
}

static tTree GetOnVal
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int topdim)
# else
(vard, topdim)
 pvar vard;
 register int topdim;
# endif
{
# line 281 "Ownership.puma"
  {
# line 283 "Ownership.puma"
   if (! ((vard -> on_val [topdim - 1] == NoTree))) goto yyL1;
  }
   return NoTree;
yyL1:;

# line 287 "Ownership.puma"
  {
# line 289 "Ownership.puma"
   if (! ((TreeRank (vard -> on_val [topdim - 1]) > 0))) goto yyL2;
  }
   return NoTree;
yyL2:;

# line 293 "Ownership.puma"
   return (vard -> on_val [topdim - 1]);

}

tTree MakeOnVal
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int topdim)
# else
(vard, topdim)
 pvar vard;
 register int topdim;
# endif
{
# line 308 "Ownership.puma"
 {
  tTree spec;
  tTree val;
  {
# line 310 "Ownership.puma"

# line 311 "Ownership.puma"

# line 313 "Ownership.puma"
 val = vard->on_val [topdim - 1];

    if (val == NoTree)
       val = mDUMMY_EXP ();   
     else
       val = CopyTree (val);  

    spec = mON_SPEC (topdim, vard->on_temp_dim [topdim-1], 
                    vard->on_index_dim [topdim-1], val);
  
  }
  {
   return spec;
  }
 }

}

tTree MakeOnTopology
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 337 "Ownership.puma"
  {
# line 338 "Ownership.puma"
   if (! ((IsReplicatedDescriptor (vard)))) goto yyL1;
  }
   return mON_ALL ();
yyL1:;

# line 342 "Ownership.puma"
  {
# line 343 "Ownership.puma"
   if (! ((IsHostDescriptor (vard)))) goto yyL2;
  }
   return mON_HOST ();
yyL2:;

# line 347 "Ownership.puma"
  {
# line 348 "Ownership.puma"
   if (! ((IsProcDescriptor (vard)))) goto yyL3;
  }
   return mON_PROCS (vard -> var_obj);
yyL3:;

# line 352 "Ownership.puma"
   return mON_VAR (vard -> topology_obj, vard -> template_obj, GetGlobalObject (TreeVarName (vard -> var_tree)));

}

tTree MakeOnSpecs
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
# line 368 "Ownership.puma"
 {
  tTree specs;
  {
# line 370 "Ownership.puma"

# line 372 "Ownership.puma"
 int dim, rank;
    specs = mON_EMPTY();
    rank  = vard->topology_rank;
    for (dim = 1; dim <= rank; dim++)
       if (GetOnVal (vard, dim) != NoTree)
          specs = mON_LIST (MakeOnVal (vard, dim), specs);
  
  }
  {
   return specs;
  }
 }

}

static tTree MakeOnSpecs1
# if defined __STDC__ | defined __cplusplus
(register tTree old, pvar vard)
# else
(old, vard)
 register tTree old;
 pvar vard;
# endif
{
# line 384 "Ownership.puma"
 {
  tTree specs;
  {
# line 386 "Ownership.puma"

# line 388 "Ownership.puma"
 int dim, rank;
    specs = old;
    rank  = vard->topology_rank;
    for (dim = 1; dim <= rank; dim++)
       if (GetOnVal (vard, dim) != NoTree)
          specs = mON_LIST (MakeOnVal (vard, dim), specs);
  
  }
  {
   return specs;
  }
 }

}

static tTree MakeOnIdVals
# if defined __STDC__ | defined __cplusplus
(pvar home, register tTree id)
# else
(home, id)
 pvar home;
 register tTree id;
# endif
{
# line 400 "Ownership.puma"
 {
  bool yyV1;
  int yyV2;
  tTree yyV3;
  {
# line 402 "Ownership.puma"
   FindLoopId (home, id, & yyV1, & yyV2, & yyV3);
# line 403 "Ownership.puma"
   if (! ((! yyV1))) goto yyL1;
  }
  {
   return mON_EMPTY ();
  }
 }
yyL1:;

# line 408 "Ownership.puma"
 {
  bool yyV1;
  int yyV2;
  tTree yyV3;
  tTree on_val;
  {
# line 410 "Ownership.puma"
   FindLoopId (home, id, & yyV1, & yyV2, & yyV3);
# line 412 "Ownership.puma"

# line 414 "Ownership.puma"
   on_val = MakeOnVal (home, yyV2);
# line 416 "Ownership.puma"
 home->on_val[yyV2-1] = NoTree; 
  }
  {
   return mON_LIST (on_val, MakeOnIdVals (home, id));
  }
 }

}

static tTree AddOnIdRanges
# if defined __STDC__ | defined __cplusplus
(register tTree spec, pvar home, register tTree id)
# else
(spec, home, id)
 register tTree spec;
 pvar home;
 register tTree id;
# endif
{
# line 432 "Ownership.puma"
 {
  tTree new_spec;
  {
# line 434 "Ownership.puma"

# line 436 "Ownership.puma"
 int topdim, toprank;
     int found;

#ifdef DEBUG
     printf ("AddOnIdRanges for this home :\n");
     PrintVarDescriptor (home);
#endif

     new_spec = spec;

     topdim = 1;
     toprank = home->topology_rank;

     for (topdim =1; topdim <= toprank; topdim++)

       { tTree val = home->on_val[topdim-1];

         found = (val != NoTree);
         if (found)
            found = IsVarInExp (TreeVarName (id), val);

#ifdef DEBUG
         printf ("AddOnIdRanges, topdim = %d, found = %d\n", topdim, found);
         printf ("  val = "); FileUnparse (stdout, val); printf ("\n");
#endif

         if (found)

           { tTree on_range;

             on_range = mSLICE_EXP (mDUMMY_EXP(), mDUMMY_EXP (),
                                                  mDUMMY_EXP());

             on_range = mON_SPEC (topdim, home->on_temp_dim [topdim-1],
                                  home->on_index_dim [topdim-1],
                                  on_range);

             new_spec = mON_LIST (on_range, new_spec);

           } 
       } 
   
  }
  {
   return new_spec;
  }
 }

}

static void FindLoopId
# if defined __STDC__ | defined __cplusplus
(pvar owner, register tTree id, register bool * yyP3, register int * yyP2, register tTree * yyP1)
# else
(owner, id, yyP3, yyP2, yyP1)
 pvar owner;
 register tTree id;
 register bool * yyP3;
 register int * yyP2;
 register tTree * yyP1;
# endif
{
# line 498 "Ownership.puma"
 {
  bool found;
  int topdim;
  tTree val;
  {
# line 500 "Ownership.puma"

# line 501 "Ownership.puma"

# line 502 "Ownership.puma"

# line 504 "Ownership.puma"
 found  = false;
     topdim = 0;

     while ((!found) && (topdim < owner->topology_rank))

       { val= owner->on_val[topdim];

         if (val != NoTree)
            found = IsVarInExp (TreeVarName (id), val);

         topdim += 1;
       }

     

   
  }
   * yyP3 = found;
   * yyP2 = topdim;
   * yyP1 = val;
   return;
 }

;
}

static void FindShiftLoopId
# if defined __STDC__ | defined __cplusplus
(pvar owner, register tTree id, register int * yyP7, register int * yyP6, register int * yyP5, register int * yyP4)
# else
(owner, id, yyP7, yyP6, yyP5, yyP4)
 pvar owner;
 register tTree id;
 register int * yyP7;
 register int * yyP6;
 register int * yyP5;
 register int * yyP4;
# endif
{
# line 524 "Ownership.puma"
 {
  bool found;
  int topdim;
  int base;
  int stride;
  tTree val;
  {
# line 526 "Ownership.puma"

# line 527 "Ownership.puma"

# line 528 "Ownership.puma"

# line 529 "Ownership.puma"

# line 530 "Ownership.puma"

# line 532 "Ownership.puma"
 int toprank;
     tTree var;

     found   = false;
     topdim  = 0;
     toprank = owner->topology_rank;

     while ((!found) && (topdim < toprank))

       { val= owner->on_val[topdim];

         if (val != NoTree)
            found = IsVarInExp (TreeVarName (id), owner->on_val [topdim]);
         if (found)
            
            ResolveExpression (val, &found, &stride, &base, &var);
         if (found)
            found = (TreeVarName (var) == TreeVarName (id));

         topdim += 1;
       }
   
  }
   * yyP7 = found;
   * yyP6 = topdim;
   * yyP5 = base;
   * yyP4 = stride;
   return;
 }

;
}

static tTree AddOnSpecs
# if defined __STDC__ | defined __cplusplus
(register tTree spec, pvar inner_home, pvar outer_home)
# else
(spec, inner_home, outer_home)
 register tTree spec;
 pvar inner_home;
 pvar outer_home;
# endif
{
# line 565 "Ownership.puma"
  {
# line 569 "Ownership.puma"
   if (! ((! SameDescriptorTopology (inner_home, outer_home)))) goto yyL1;
  {
# line 571 "Ownership.puma"
   error_protocol ("illegal call on add on specs");
# line 572 "Ownership.puma"
   tree_protocol ("inner home : ", MakeDescriptorVar (inner_home));
# line 573 "Ownership.puma"
   tree_protocol ("outer home : ", MakeDescriptorVar (outer_home));
  }
  }
   return spec;
yyL1:;

# line 578 "Ownership.puma"
 {
  tTree new_spec;
  {
# line 580 "Ownership.puma"

# line 582 "Ownership.puma"
 int dim, rank;

     new_spec = spec;

     rank = outer_home->topology_rank;

     for (dim = 1; dim <= rank; dim ++)
 
      { tTree outer_val, inner_val;

        outer_val = GetOnVal (outer_home, dim);
        inner_val = GetOnVal (inner_home, dim);

        

        

        if ((outer_val == NoTree) && (inner_val != NoTree))

          new_spec = mON_LIST (MakeOnVal (outer_home, dim), new_spec);

      } 

   
  }
  {
   return new_spec;
  }
 }

}

void MakeOnLoop
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar home)
# else
(t, home)
 register tTree t;
 pvar home;
# endif
{
  if (t->Kind == kACF_DO) {
# line 633 "Ownership.puma"
  {
# line 635 "Ownership.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  {
# line 637 "Ownership.puma"
 t->ACF_DO.DO_HOME_INFO = mNO_HOME_INFO (); 
  }
  }
   return;
yyL1:;

# line 640 "Ownership.puma"
 {
  bool yyV1;
  int yyV2;
  tTree yyV3;
  {
# line 642 "Ownership.puma"
   FindLoopId (home, t->ACF_DO.DO_ID, & yyV1, & yyV2, & yyV3);
# line 643 "Ownership.puma"
   if (! ((! yyV1))) goto yyL2;
  {
# line 647 "Ownership.puma"
 t->ACF_DO.DO_HOME_INFO = mNO_HOME_INFO (); 
  }
  }
   return;
 }
yyL2:;

# line 675 "Ownership.puma"
 {
  int yyV1;
  int yyV2;
  int yyV3;
  int yyV4;
  {
# line 681 "Ownership.puma"
   FindShiftLoopId (home, t->ACF_DO.DO_ID, & yyV1, & yyV2, & yyV3, & yyV4);
# line 683 "Ownership.puma"
   if (! ((yyV1))) goto yyL3;
  {
# line 685 "Ownership.puma"
 t->ACF_DO.DO_HOME_INFO = MakeOnInfo (home, yyV2, yyV3, yyV4);

     home->on_val [yyV2-1] = NoTree;    

     t->ACF_DO.DO_BODY = MakeStmtList (SelectBody (t->ACF_DO.DO_BODY, home, MakeOnIdVals (home, t->ACF_DO.DO_ID)));

   
  }
  }
   return;
 }
yyL3:;

# line 694 "Ownership.puma"
  {
# line 696 "Ownership.puma"
   error_protocol ("loop variable does not appear linear in home");
# line 697 "Ownership.puma"
   tree_protocol ("loop variable      : ", t->ACF_DO.DO_ID);
# line 698 "Ownership.puma"
   tree_protocol ("home of iterations : ", PrintableDescriptorVar (home));
  }
   return;

  }
;
}

static tTree MakeOnInfo
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim, register int base, register int stride)
# else
(vard, dim, base, stride)
 pvar vard;
 register int dim;
 register int base;
 register int stride;
# endif
{
# line 715 "Ownership.puma"
 {
  int base1;
  int stride1;
  int index_dim;
  int on_dim;
  tDefinitions on_id;
  {
# line 717 "Ownership.puma"

# line 718 "Ownership.puma"

# line 720 "Ownership.puma"

# line 721 "Ownership.puma"

# line 722 "Ownership.puma"

# line 724 "Ownership.puma"
 index_dim = vard->on_index_dim[dim-1];

    base1     = vard->align_add [index_dim-1];
    stride1   = vard->align_mult[index_dim-1];

    

    base1   = base1 + stride1 * base;
    stride1 = stride * stride1;

    on_id  = vard->template_obj;

    if (on_id == NoObject) on_id = vard->var_obj;   

    on_dim = vard->on_temp_dim [dim-1];

  
  }
  {
   return mON_INFO (on_id, on_dim, base1, stride1);
  }
 }

}

static tTree SelectBody
# if defined __STDC__ | defined __cplusplus
(register tTree body, pvar home, register tTree on_vals)
# else
(body, home, on_vals)
 register tTree body;
 pvar home;
 register tTree on_vals;
# endif
{
  if (on_vals->Kind == kON_EMPTY) {
# line 757 "Ownership.puma"
   return body;

  }
# line 762 "Ownership.puma"
   return mACF_ON (MakeOnTopology (home), on_vals, body);

}

static bool IsParallelInfo
# if defined __STDC__ | defined __cplusplus
(register tTree info)
# else
(info)
 register tTree info;
# endif
{
  if (info->Kind == kINDEP_INFO) {
# line 775 "Ownership.puma"
  {
# line 777 "Ownership.puma"
   if (! ((info->INDEP_INFO.selection != 0))) goto yyL1;
  }
   return true;
yyL1:;

  }
# line 782 "Ownership.puma"
   return false;

}

void BeginOwnership ()
{
}

void CloseOwnership ()
{
}
