# include "Optimization.h"
# include "yyOptimization.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 21 "Optimization.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Traverse.h"
# include "Fusion.h"
# include "Interchange.h"

# define MODULE "Optimization"



static void yyExit () { Exit (1); }

void (* Optimization_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Optimization, routine %s failed\n", yyFunction);
 Optimization_Exit ();
}

void Optimization ARGS((tTree t));
static void ApplyOptimization ARGS((tTree t));
static bool StopOptimization ARGS((tTree t));
static void OptimizeStmtList ARGS((tTree stats, int no_opt));
static void OptimizeStmt ARGS((tTree t));
static void LoopInterchanging ARGS((tTree t));

void Optimization
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMP_UNIT) {
# line 45 "Optimization.puma"
  {
# line 47 "Optimization.puma"
   open_protocol ("adaptor.opt");
# line 48 "Optimization.puma"
   TraverseAST (t, StopOptimization, ApplyOptimization);
# line 49 "Optimization.puma"
   close_protocol ();
  }
   return;

  }
;
}

static void ApplyOptimization
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 60 "Optimization.puma"
  {
# line 62 "Optimization.puma"
   if (! ((optimization == 0))) goto yyL1;
  }
   return;
yyL1:;

# line 65 "Optimization.puma"
  {
# line 67 "Optimization.puma"
   OptimizeStmtList (t->BODY_NODE.STATS, 0);
# line 68 "Optimization.puma"
   TraverseAST (t->BODY_NODE.INTERNALS, StopOptimization, ApplyOptimization);
  }
   return;

  }
;
}

static bool StopOptimization
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 73 "Optimization.puma"
   return true;

  }
  return false;
}

static void OptimizeStmtList
# if defined __STDC__ | defined __cplusplus
(register tTree stats, register int no_opt)
# else
(stats, no_opt)
 register tTree stats;
 register int no_opt;
# endif
{
  if (stats->Kind == kACF_EMPTY) {
# line 84 "Optimization.puma"
   return;

  }
  if (stats->Kind == kACF_LIST) {
  if (stats->ACF_LIST.Next->Kind == kACF_LIST) {
# line 87 "Optimization.puma"
  {
# line 89 "Optimization.puma"
 if (no_opt < 1) OptimizeStmt (stats->ACF_LIST.Elem); 
# line 90 "Optimization.puma"
 if (no_opt < 2) OptimizeStmt (stats->ACF_LIST.Next->ACF_LIST.Elem); 
# line 92 "Optimization.puma"
   if (! ((CanBeFused (stats->ACF_LIST.Elem, stats->ACF_LIST.Next->ACF_LIST.Elem)))) goto yyL2;
  {
# line 94 "Optimization.puma"
 print_protocol ("fusion of statements");
     tree_protocol ("stmt1 :\n", stats->ACF_LIST.Elem);
     tree_protocol ("stmt2 :\n", stats->ACF_LIST.Next->ACF_LIST.Elem);
     stats->ACF_LIST.Elem = Fusion (stats->ACF_LIST.Elem, stats->ACF_LIST.Next->ACF_LIST.Elem);
     tree_protocol ("result :\n", stats->ACF_LIST.Elem);

     stats->ACF_LIST.Next = stats->ACF_LIST.Next->ACF_LIST.Next;
   
# line 105 "Optimization.puma"
   OptimizeStmtList (stats, 0);
  }
  }
   return;
yyL2:;

# line 108 "Optimization.puma"
  {
# line 112 "Optimization.puma"
   OptimizeStmtList (stats->ACF_LIST.Next, 1);
  }
   return;

  }
  if (stats->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 115 "Optimization.puma"
  {
# line 117 "Optimization.puma"
 if (no_opt < 1) OptimizeStmt (stats->ACF_LIST.Elem); 
  }
   return;

  }
  }
# line 120 "Optimization.puma"
  {
# line 122 "Optimization.puma"
   failure_protocol (MODULE, "OptimizeStmtList", stats);
  }
   return;

;
}

static void OptimizeStmt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_WHILE) {
# line 133 "Optimization.puma"
  {
# line 135 "Optimization.puma"
   OptimizeStmtList (t->ACF_WHILE.WHILE_BODY, 0);
  }
   return;

  }
  if (t->Kind == kACF_IF) {
# line 138 "Optimization.puma"
  {
# line 140 "Optimization.puma"
   OptimizeStmtList (t->ACF_IF.THEN_PART, 0);
# line 141 "Optimization.puma"
   OptimizeStmtList (t->ACF_IF.ELSE_PART, 0);
  }
   return;

  }
  if (t->Kind == kACF_DO) {
# line 144 "Optimization.puma"
  {
# line 146 "Optimization.puma"
   OptimizeStmtList (t->ACF_DO.DO_BODY, 0);
# line 147 "Optimization.puma"
   LoopInterchanging (t);
  }
   return;

  }
  if (t->Kind == kACF_ON) {
# line 150 "Optimization.puma"
  {
# line 152 "Optimization.puma"
   OptimizeStmtList (t->ACF_ON.ON_BODY, 0);
  }
   return;

  }
;
}

static void LoopInterchanging
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 157 "Optimization.puma"
  {
# line 159 "Optimization.puma"
   if (! ((CanBeInterchanged (t)))) goto yyL1;
  }
   return;
yyL1:;

;
}

void BeginOptimization ()
{
}

void CloseOptimization ()
{
}
