# include "Objects.h"
# include "yyObjects.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 67 "Objects.puma"


# define MODULE "Objects"

# include "Idents.h"

# include "protocol.h"

# include "DefTable.h"
# include "TreeOps.h"
# include "Intrinsics.h"

# define DEFAULT_TRACE_ATT     0
# define DEFAULT_TREE_ATT      0
# define DEFAULT_SEQUENCE_ATT  0
# define DEFAULT_SELECT_ATT    NoTree
# define DEFAULT_VAR_USE       mVarUse (0, 0, 0)
# define DEFAULT_DISTRIBUTION  mDefaultDistribution (0, 0, 0)



static void yyExit () { Exit (1); }

void (* Objects_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Objects, routine %s failed\n", yyFunction);
 Objects_Exit ();
}

tDefinitions MakeNewObject ARGS((tTree decl, tDefinitions unit));
static int CountSlices ARGS((tTree index_list));
tDefinitions MakeResultObject ARGS((tTree decl, tDefinitions unit));
bool IsFuncObj ARGS((tDefinitions v));
bool IsModuleObj ARGS((tDefinitions v));
bool IsTypeObj ARGS((tDefinitions v));
bool IsVarCommon ARGS((tDefinitions v));
bool IsVarDummy ARGS((tDefinitions v));
bool IsVarResult ARGS((tDefinitions v));
bool IsVarParameter ARGS((tDefinitions v));
bool IsVarLocal ARGS((tDefinitions v));
bool IsVarTraced ARGS((tDefinitions v));
bool IsTreeObject ARGS((tDefinitions v));
bool IsRaggedVarObject ARGS((tDefinitions v));
bool IsTemplate ARGS((tDefinitions v));
bool IsTopology ARGS((tDefinitions v));
bool IsOptional ARGS((tDefinitions v));
bool IsVarAllocatable ARGS((tDefinitions v));
bool IsVarAssumedShape ARGS((tDefinitions v));
bool IsVarAssumedSize ARGS((tDefinitions v));
static bool IsTreeAllocatable ARGS((tTree t));
static bool IsTreeAssumedSize ARGS((tTree t));
bool IsVarOverlapped ARGS((tDefinitions v));
bool IsArrayOverlapped ARGS((tTree t));
bool IsUserCall ARGS((tTree t));
bool IsIntrCall ARGS((tTree t));
bool IsMainUnit ARGS((tTree t));
bool IsPureUnit ARGS((tTree t));
bool IsLocalUnit ARGS((tTree t));
bool IsSerialUnit ARGS((tTree t));
bool IsF77Unit ARGS((tTree t));
bool IsStmtCall ARGS((tTree t));
bool IsStmtFunction ARGS((tDefinitions obj));
bool IsSerialCall ARGS((tTree t));
static bool IsSerialObj ARGS((tDefinitions obj));
bool IsLocalCall ARGS((tTree t));
static bool IsLocalObj ARGS((tDefinitions obj));
bool IsPureCall ARGS((tTree t));
static bool IsPureObj ARGS((tDefinitions v));
bool IsF77Call ARGS((tTree t));
static bool IsF77Obj ARGS((tDefinitions obj));
tDefinitions GetFuncVarObj ARGS((tDefinitions f));
void GetDummies ARGS((tDefinitions obj, tTree * yyP2, tDefinitions * yyP1));
tDefinitions GetReferenceObject ARGS((tDefinitions obj));
static tDefinitions ChooseReferenceObj ARGS((tDefinitions interface_obj, tDefinitions global_obj));
bool NoInterfaceObj ARGS((tDefinitions v));
static bool IsDummyRoutine ARGS((tDefinitions v));
static bool IsUserRoutine ARGS((tDefinitions v));
bool FunctionBecomesSubroutine ARGS((tTree f));
bool IsUsedObject ARGS((tDefinitions obj, tDefinitions unit));

tDefinitions MakeNewObject
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tDefinitions unit)
# else
(decl, unit)
 register tTree decl;
 register tDefinitions unit;
# endif
{

  switch (decl->Kind) {
  case kPROCESSORS_DECL:
# line 101 "Objects.puma"
   return mTopologyObject (decl->PROCESSORS_DECL.Ident, mPROCESSORS_DECL (decl->PROCESSORS_DECL.Ident, decl->PROCESSORS_DECL.Line, decl->PROCESSORS_DECL.DIMENSIONS), Default, unit, TreeListLength (decl->PROCESSORS_DECL.DIMENSIONS), NoTree, 0, 0);

  case kPROCESSOR_SUBSET:
# line 108 "Objects.puma"
   return mTopologyObject (decl->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Ident, mSUB_PROCS_DECL (decl->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Ident, 0, decl->PROCESSOR_SUBSET.FULLTOP, decl->PROCESSOR_SUBSET.SUBSCRIPTS), Default, unit, CountSlices (decl->PROCESSOR_SUBSET.SUBSCRIPTS), NoTree, 0, 0);

  case kTEMPLATE_DECL:
# line 115 "Objects.puma"
   return mTemplateObject (decl->TEMPLATE_DECL.Ident, mTEMPLATE_DECL (decl->TEMPLATE_DECL.Ident, decl->TEMPLATE_DECL.Line, decl->TEMPLATE_DECL.DIMENSIONS), Default, unit, DEFAULT_SELECT_ATT, mDefaultDistribution (0, 0, 0));

  case kVAR_DECL:
# line 122 "Objects.puma"
   return mVarObject (decl->VAR_DECL.Ident, mVAR_DECL (decl->VAR_DECL.Ident, decl->VAR_DECL.Line, decl->VAR_DECL.VAL), Default, unit, mVarLocal (0, 0, 0), DEFAULT_TRACE_ATT, DEFAULT_TREE_ATT, DEFAULT_SEQUENCE_ATT, DEFAULT_SELECT_ATT, DEFAULT_VAR_USE, mDefaultDistribution (0, 0, 0));

  case kVAR_PARAM_DECL:
# line 134 "Objects.puma"
   return mVarObject (decl->VAR_PARAM_DECL.Ident, mVAR_PARAM_DECL (decl->VAR_PARAM_DECL.Ident, decl->VAR_PARAM_DECL.Line, decl->VAR_PARAM_DECL.VAL), Default, unit, mVarDummy (IntentNo, 0, NoTree, false, false, 0, 0, 0), DEFAULT_TRACE_ATT, DEFAULT_TREE_ATT, DEFAULT_SEQUENCE_ATT, DEFAULT_SELECT_ATT, DEFAULT_VAR_USE, mDefaultDistribution (0, 0, 0));

  case kPROGRAM_DECL:
# line 146 "Objects.puma"
   return mProcObject (decl->PROGRAM_DECL.Ident, decl, Default, unit, UserRoutine, mENTRY_EMPTY ());

  case kPROC_DECL:
# line 152 "Objects.puma"
   return mProcObject (decl->PROC_DECL.Ident, decl, Default, unit, UserRoutine, mENTRY_EMPTY ());

  case kFUNC_DECL:
# line 158 "Objects.puma"
   return mFuncObject (decl->FUNC_DECL.Ident, decl, Default, unit, UserRoutine, mENTRY_EMPTY ());

  case kMODULE_DECL:
# line 164 "Objects.puma"
   return mModuleObject (decl->MODULE_DECL.Ident, decl, Default, unit, 0, mENTRY_EMPTY ());

  case kBLOCK_DATA_DECL:
# line 169 "Objects.puma"
   return mBlockObject (decl->BLOCK_DATA_DECL.Ident, decl, Default, unit, 0, mENTRY_EMPTY ());

  case kTYPE_DECL:
# line 174 "Objects.puma"
   return mTypeObject (decl->TYPE_DECL.Ident, decl, Default, unit, NoEntries);

  }

# line 179 "Objects.puma"
  {
# line 181 "Objects.puma"
   failure_protocol (MODULE, "MakeNewObject", decl);
  }
   return NoObject;

}

static int CountSlices
# if defined __STDC__ | defined __cplusplus
(register tTree index_list)
# else
(index_list)
 register tTree index_list;
# endif
{
  if (index_list->Kind == kBTE_EMPTY) {
# line 191 "Objects.puma"
   return 0;

  }
  if (index_list->Kind == kBTE_LIST) {
  if (index_list->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 196 "Objects.puma"
   return CountSlices (index_list->BTE_LIST.Next) + 1;

  }
# line 201 "Objects.puma"
   return CountSlices (index_list->BTE_LIST.Next);

  }
 yyAbort ("CountSlices");
}

tDefinitions MakeResultObject
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tDefinitions unit)
# else
(decl, unit)
 register tTree decl;
 register tDefinitions unit;
# endif
{
  if (decl->Kind == kFUNC_DECL) {
# line 218 "Objects.puma"
   return mVarObject (decl->FUNC_DECL.RESULT_ID, mVAR_PARAM_DECL (decl->FUNC_DECL.RESULT_ID, decl->FUNC_DECL.Line, decl->FUNC_DECL.RESULT_TYPE), Default, unit, mVarDummy (IntentOut, 0, decl, false, false, 0, 0, 0), DEFAULT_TRACE_ATT, DEFAULT_TREE_ATT, DEFAULT_SEQUENCE_ATT, DEFAULT_SELECT_ATT, DEFAULT_VAR_USE, mDefaultDistribution (0, 0, 0));

  }
# line 231 "Objects.puma"
  {
# line 233 "Objects.puma"
   failure_protocol (MODULE, "MakeResultDef", decl);
  }
   return NoObject;

}

bool IsFuncObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 245 "Objects.puma"
  {
# line 246 "Objects.puma"
   if (! ((v == NoObject))) goto yyL1;
  {
# line 247 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (v->Kind == kFuncObject) {
# line 250 "Objects.puma"
   return true;

  }
  return false;
}

bool IsModuleObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 255 "Objects.puma"
  {
# line 256 "Objects.puma"
   if (! ((v == NoObject))) goto yyL1;
  {
# line 257 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (v->Kind == kModuleObject) {
# line 260 "Objects.puma"
   return true;

  }
  return false;
}

bool IsTypeObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 265 "Objects.puma"
  {
# line 266 "Objects.puma"
   if (! ((v == NoObject))) goto yyL1;
  {
# line 267 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (v->Kind == kTypeObject) {
# line 270 "Objects.puma"
   return true;

  }
  return false;
}

bool IsVarCommon
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarCommon) {
# line 281 "Objects.puma"
   return true;

  }
  }
  return false;
}

bool IsVarDummy
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarDummy) {
# line 286 "Objects.puma"
   return true;

  }
  }
  return false;
}

bool IsVarResult
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarDummy) {
# line 291 "Objects.puma"
  {
# line 292 "Objects.puma"
   if (! ((v->VarObject.Kind->VarDummy.function == NoTree))) goto yyL1;
  {
# line 293 "Objects.puma"
   return false;
  }
  }
yyL1:;

# line 296 "Objects.puma"
   return true;

  }
  }
  return false;
}

bool IsVarParameter
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarParameter) {
# line 301 "Objects.puma"
   return true;

  }
  }
  return false;
}

bool IsVarLocal
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarLocal) {
# line 306 "Objects.puma"
   return true;

  }
  }
  return false;
}

bool IsVarTraced
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
# line 311 "Objects.puma"
  {
# line 313 "Objects.puma"
   if (! ((v->VarObject.trace))) goto yyL1;
  }
   return true;
yyL1:;

  }
  return false;
}

bool IsTreeObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
# line 318 "Objects.puma"
  {
# line 320 "Objects.puma"
   if (! ((v->VarObject.tree))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (v->Kind == kRaggedObject) {
# line 323 "Objects.puma"
   return true;

  }
  return false;
}

bool IsRaggedVarObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
# line 328 "Objects.puma"
  {
# line 330 "Objects.puma"
   if (! ((v->VarObject.in == NoObject))) goto yyL1;
  {
# line 331 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (v->VarObject.in->Kind == kRaggedObject) {
# line 334 "Objects.puma"
   return true;

  }
  }
  return false;
}

bool IsTemplate
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kTemplateObject) {
# line 339 "Objects.puma"
   return true;

  }
  return false;
}

bool IsTopology
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kTopologyObject) {
# line 344 "Objects.puma"
   return true;

  }
  return false;
}

bool IsOptional
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarDummy) {
# line 349 "Objects.puma"
  {
# line 350 "Objects.puma"
   if (! ((v->VarObject.Kind->VarDummy.optional))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  return false;
}

bool IsVarAllocatable
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.decl->Kind == kVAR_DECL) {
  if (v->VarObject.Kind->Kind == kVarLocal) {
# line 361 "Objects.puma"
  {
# line 362 "Objects.puma"
   if (! ((IsTreeAllocatable (v->VarObject.decl->VAR_DECL.VAL)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (v->VarObject.Kind->Kind == kVarCommon) {
# line 365 "Objects.puma"
  {
# line 366 "Objects.puma"
   if (! ((IsTreeAllocatable (v->VarObject.decl->VAR_DECL.VAL)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  }
  if (v->Kind == kTemplateObject) {
  if (v->TemplateObject.decl->Kind == kTEMPLATE_DECL) {
# line 369 "Objects.puma"
  {
# line 370 "Objects.puma"
   if (! ((IsTreeAllocatable (v->TemplateObject.decl->TEMPLATE_DECL.DIMENSIONS)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  }
  return false;
}

bool IsVarAssumedShape
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (v->VarObject.Kind->Kind == kVarDummy) {
# line 375 "Objects.puma"
  {
# line 376 "Objects.puma"
   if (! ((IsTreeAllocatable (v->VarObject.decl->VAR_PARAM_DECL.VAL)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  }
  return false;
}

bool IsVarAssumedSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (v->VarObject.Kind->Kind == kVarDummy) {
# line 381 "Objects.puma"
  {
# line 382 "Objects.puma"
   if (! ((IsTreeAssumedSize (v->VarObject.decl->VAR_PARAM_DECL.VAL)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  }
  return false;
}

static bool IsTreeAllocatable
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kARRAY_TYPE) {
# line 387 "Objects.puma"
  {
# line 388 "Objects.puma"
   if (! ((IsTreeAllocatable (t->ARRAY_TYPE.ARRAY_INDEX_TYPES)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kPOINTER_TYPE) {
# line 391 "Objects.puma"
  {
# line 392 "Objects.puma"
   if (! ((IsTreeAllocatable (t->POINTER_TYPE.PTR_COMP)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (t->Kind == kSHAPE_LIST) {
# line 395 "Objects.puma"
  {
# line 396 "Objects.puma"
   if (! ((IsTreeAllocatable (t->SHAPE_LIST.Elem)))) goto yyL3;
  {
# line 397 "Objects.puma"
   if (! ((IsTreeAllocatable (t->SHAPE_LIST.Next)))) goto yyL3;
  }
  }
   return true;
yyL3:;

  }
  if (t->Kind == kSHAPE_EMPTY) {
# line 400 "Objects.puma"
   return true;

  }
  if (t->Kind == kDEFERRED_SHAPE) {
# line 403 "Objects.puma"
   return true;

  }
  if (t->Kind == kASSUMED_SHAPE) {
# line 406 "Objects.puma"
   return true;

  }
  return false;
}

static bool IsTreeAssumedSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kARRAY_TYPE) {
# line 411 "Objects.puma"
  {
# line 412 "Objects.puma"
   if (! ((IsTreeAssumedSize (t->ARRAY_TYPE.ARRAY_INDEX_TYPES)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kSHAPE_LIST) {
  if (t->SHAPE_LIST.Elem->Kind == kASSUMED_SIZE) {
  if (t->SHAPE_LIST.Next->Kind == kSHAPE_EMPTY) {
# line 415 "Objects.puma"
   return true;

  }
  }
# line 418 "Objects.puma"
  {
# line 419 "Objects.puma"
   if (! ((IsTreeAssumedSize (t->SHAPE_LIST.Next)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

bool IsVarOverlapped
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarLocal) {
# line 430 "Objects.puma"
  {
# line 431 "Objects.puma"
   if (! ((IsArrayOverlapped (v->VarObject.decl)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (v->VarObject.Kind->Kind == kVarDummy) {
# line 434 "Objects.puma"
  {
# line 435 "Objects.puma"
   if (! ((IsArrayOverlapped (v->VarObject.decl)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (v->VarObject.Kind->Kind == kVarCommon) {
# line 438 "Objects.puma"
  {
# line 439 "Objects.puma"
   if (! ((IsArrayOverlapped (v->VarObject.decl)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  }
  return false;
}

bool IsArrayOverlapped
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kVAR_OBJ:
# line 444 "Objects.puma"
  {
# line 445 "Objects.puma"
   if (! ((IsVarOverlapped (t->VAR_OBJ.Object)))) goto yyL1;
  }
   return true;
yyL1:;

  break;
  case kUSED_VAR:
# line 448 "Objects.puma"
  {
# line 449 "Objects.puma"
   if (! ((IsArrayOverlapped (t->USED_VAR.VARNAME)))) goto yyL2;
  }
   return true;
yyL2:;

  break;
  case kINDEXED_VAR:
# line 452 "Objects.puma"
  {
# line 453 "Objects.puma"
   if (! ((IsArrayOverlapped (t->INDEXED_VAR.IND_VAR)))) goto yyL3;
  }
   return true;
yyL3:;

  break;
  case kVAR_DECL:
# line 456 "Objects.puma"
  {
# line 457 "Objects.puma"
   if (! ((IsArrayOverlapped (t->VAR_DECL.VAL)))) goto yyL4;
  }
   return true;
yyL4:;

  break;
  case kVAR_PARAM_DECL:
# line 460 "Objects.puma"
  {
# line 461 "Objects.puma"
   if (! ((IsArrayOverlapped (t->VAR_PARAM_DECL.VAL)))) goto yyL5;
  }
   return true;
yyL5:;

  break;
  case kARRAY_TYPE:
# line 464 "Objects.puma"
  {
# line 465 "Objects.puma"
   if (! ((IsArrayOverlapped (t->ARRAY_TYPE.ARRAY_INDEX_TYPES)))) goto yyL6;
  }
   return true;
yyL6:;

  break;
  case kSHAPE_LIST:
# line 468 "Objects.puma"
  {
# line 469 "Objects.puma"
   if (! ((IsArrayOverlapped (t->SHAPE_LIST.Elem->SHAPE_SPEC.Overlap)))) goto yyL7;
  }
   return true;
yyL7:;

# line 472 "Objects.puma"
  {
# line 473 "Objects.puma"
   if (! ((IsArrayOverlapped (t->SHAPE_LIST.Next)))) goto yyL8;
  }
   return true;
yyL8:;

  break;
  case kOVERLAP_SPEC:
# line 476 "Objects.puma"
  {
# line 477 "Objects.puma"
   if (! (((t->OVERLAP_SPEC.left_size > 0) || (t->OVERLAP_SPEC.right_size > 0)))) goto yyL9;
  }
   return true;
yyL9:;

  break;
  }

  return false;
}

bool IsUserCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
# line 491 "Objects.puma"
  {
# line 492 "Objects.puma"
   if (! ((IsUserCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
# line 495 "Objects.puma"
  {
# line 496 "Objects.puma"
   if (! ((IsUserCall (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
# line 499 "Objects.puma"
  {
# line 500 "Objects.puma"
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
# line 501 "Objects.puma"
   return false;
  }
  }
yyL3:;

  if (t->PROC_OBJ.Object->Kind == kFuncObject) {
  if (t->PROC_OBJ.Object->FuncObject.decl->Kind == kFUNC_DECL) {
# line 504 "Objects.puma"
   return true;

  }
  }
  if (t->PROC_OBJ.Object->Kind == kProcObject) {
  if (t->PROC_OBJ.Object->ProcObject.decl->Kind == kPROC_DECL) {
# line 507 "Objects.puma"
   return true;

  }
  }
  }
  return false;
}

bool IsIntrCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
# line 518 "Objects.puma"
  {
# line 519 "Objects.puma"
   if (! ((IsIntrCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
# line 522 "Objects.puma"
  {
# line 523 "Objects.puma"
   if (! ((IsIntrCall (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
# line 526 "Objects.puma"
  {
# line 527 "Objects.puma"
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
# line 528 "Objects.puma"
   return false;
  }
  }
yyL3:;

  if (t->PROC_OBJ.Object->Kind == kProcObject) {
  if (t->PROC_OBJ.Object->ProcObject.decl->Kind == kINTRINSIC_DECL) {
# line 531 "Objects.puma"
   return true;

  }
  }
  if (t->PROC_OBJ.Object->Kind == kFuncObject) {
  if (t->PROC_OBJ.Object->FuncObject.decl->Kind == kINTRINSIC_DECL) {
# line 534 "Objects.puma"
   return true;

  }
  }
  }
  return false;
}

bool IsMainUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROGRAM_DECL) {
# line 545 "Objects.puma"
   return true;

  }
  return false;
}

bool IsPureUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
# line 550 "Objects.puma"
  {
# line 551 "Objects.puma"
   if (! ((t->PROC_DECL.IsPure))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kFUNC_DECL) {
# line 554 "Objects.puma"
  {
# line 555 "Objects.puma"
   if (! ((t->FUNC_DECL.IsPure))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

bool IsLocalUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
# line 560 "Objects.puma"
  {
# line 562 "Objects.puma"
   if (! (((t->PROC_DECL.HPFExtrinsic == IsIdent ("HPF_LOCAL")) || (t->PROC_DECL.HPFExtrinsic == IsIdent ("F77_LOCAL"))))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kFUNC_DECL) {
# line 565 "Objects.puma"
  {
# line 567 "Objects.puma"
   if (! (((t->FUNC_DECL.HPFExtrinsic == IsIdent ("HPF_LOCAL")) || (t->FUNC_DECL.HPFExtrinsic == IsIdent ("F77_LOCAL"))))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

bool IsSerialUnit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
# line 572 "Objects.puma"
  {
# line 574 "Objects.puma"
   if (! (((t->PROC_DECL.HPFExtrinsic == IsIdent ("HPF_SERIAL")) || (t->PROC_DECL.HPFExtrinsic == IsIdent ("F77_SERIAL"))))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kFUNC_DECL) {
# line 577 "Objects.puma"
  {
# line 579 "Objects.puma"
   if (! (((t->FUNC_DECL.HPFExtrinsic == IsIdent ("HPF_SERIAL")) || (t->FUNC_DECL.HPFExtrinsic == IsIdent ("F77_SERIAL"))))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

bool IsF77Unit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
# line 584 "Objects.puma"
  {
# line 586 "Objects.puma"
   if (! (((t->PROC_DECL.HPFExtrinsic == IsIdent ("F77_LOCAL")) || (t->PROC_DECL.HPFExtrinsic == IsIdent ("F77_SERIAL"))))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kFUNC_DECL) {
# line 589 "Objects.puma"
  {
# line 591 "Objects.puma"
   if (! (((t->FUNC_DECL.HPFExtrinsic == IsIdent ("F77_LOCAL")) || (t->FUNC_DECL.HPFExtrinsic == IsIdent ("F77_SERIAL"))))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

bool IsStmtCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
# line 602 "Objects.puma"
  {
# line 603 "Objects.puma"
   if (! ((IsStmtCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kPROC_OBJ) {
# line 606 "Objects.puma"
  {
# line 607 "Objects.puma"
   if (! ((IsStmtFunction (t->PROC_OBJ.Object)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

bool IsStmtFunction
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 612 "Objects.puma"
  {
# line 613 "Objects.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 614 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 617 "Objects.puma"
   return true;

  }
  }
  return false;
}

bool IsSerialCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
# line 638 "Objects.puma"
  {
# line 639 "Objects.puma"
   if (! ((IsSerialCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
# line 642 "Objects.puma"
  {
# line 643 "Objects.puma"
   if (! ((IsSerialCall (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
# line 646 "Objects.puma"
  {
# line 647 "Objects.puma"
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
# line 648 "Objects.puma"
   return false;
  }
  }
yyL3:;

# line 651 "Objects.puma"
  {
# line 652 "Objects.puma"
   if (! ((IsIntrCall (t)))) goto yyL4;
  {
# line 653 "Objects.puma"
   if (! ((IntrSerialRoutine (t->PROC_OBJ.Ident)))) goto yyL4;
  }
  }
   return true;
yyL4:;

# line 656 "Objects.puma"
  {
# line 657 "Objects.puma"
   if (! ((IsSerialObj (GetReferenceObject (t->PROC_OBJ.Object))))) goto yyL5;
  }
   return true;
yyL5:;

  }
  return false;
}

static bool IsSerialObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 662 "Objects.puma"
  {
# line 663 "Objects.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 664 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
# line 667 "Objects.puma"
  {
# line 669 "Objects.puma"
   if (! (((obj->FuncObject.decl->FUNC_DECL.HPFExtrinsic == IsIdent ("HPF_SERIAL")) || (obj->FuncObject.decl->FUNC_DECL.HPFExtrinsic == IsIdent ("F77_SERIAL"))))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kPROC_DECL) {
# line 672 "Objects.puma"
  {
# line 674 "Objects.puma"
   if (! (((obj->ProcObject.decl->PROC_DECL.HPFExtrinsic == IsIdent ("HPF_SERIAL")) || (obj->ProcObject.decl->PROC_DECL.HPFExtrinsic == IsIdent ("F77_SERIAL"))))) goto yyL3;
  }
   return true;
yyL3:;

  }
  }
  return false;
}

bool IsLocalCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
# line 694 "Objects.puma"
  {
# line 695 "Objects.puma"
   if (! ((IsLocalCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
# line 698 "Objects.puma"
  {
# line 699 "Objects.puma"
   if (! ((IsLocalCall (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
# line 702 "Objects.puma"
  {
# line 703 "Objects.puma"
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
# line 704 "Objects.puma"
   return false;
  }
  }
yyL3:;

# line 707 "Objects.puma"
  {
# line 708 "Objects.puma"
   if (! ((IsLocalObj (GetReferenceObject (t->PROC_OBJ.Object))))) goto yyL4;
  }
   return true;
yyL4:;

  }
  return false;
}

static bool IsLocalObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 713 "Objects.puma"
  {
# line 714 "Objects.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 715 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kFuncObject) {
# line 718 "Objects.puma"
  {
# line 719 "Objects.puma"
   if (! ((IsLocalUnit (obj->FuncObject.decl)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (obj->Kind == kProcObject) {
# line 722 "Objects.puma"
  {
# line 723 "Objects.puma"
   if (! ((IsLocalUnit (obj->ProcObject.decl)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

bool IsPureCall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
# line 743 "Objects.puma"
  {
# line 744 "Objects.puma"
   if (! ((IsPureCall (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
# line 747 "Objects.puma"
  {
# line 748 "Objects.puma"
   if (! ((IsPureCall (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
# line 751 "Objects.puma"
  {
# line 752 "Objects.puma"
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
# line 753 "Objects.puma"
   return false;
  }
  }
yyL3:;

# line 756 "Objects.puma"
  {
# line 757 "Objects.puma"
   if (! ((IsIntrCall (t)))) goto yyL4;
  {
# line 758 "Objects.puma"
   if (! ((IntrPureRoutine (t->PROC_OBJ.Ident)))) goto yyL4;
  }
  }
   return true;
yyL4:;

# line 761 "Objects.puma"
  {
# line 762 "Objects.puma"
   if (! ((IsPureObj (GetReferenceObject (t->PROC_OBJ.Object))))) goto yyL5;
  }
   return true;
yyL5:;

  }
  return false;
}

static bool IsPureObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 767 "Objects.puma"
  {
# line 768 "Objects.puma"
   if (! ((v == NoObject))) goto yyL1;
  {
# line 769 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (v->Kind == kFuncObject) {
# line 772 "Objects.puma"
  {
# line 773 "Objects.puma"
   if (! ((IsPureUnit (v->FuncObject.decl)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (v->Kind == kProcObject) {
# line 776 "Objects.puma"
  {
# line 777 "Objects.puma"
   if (! ((IsPureUnit (v->ProcObject.decl)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

bool IsF77Call
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
# line 792 "Objects.puma"
  {
# line 793 "Objects.puma"
   if (! ((IsF77Call (t->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kCALL_STMT) {
# line 796 "Objects.puma"
  {
# line 797 "Objects.puma"
   if (! ((IsF77Call (t->CALL_STMT.CALL_ID)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (t->Kind == kPROC_OBJ) {
# line 800 "Objects.puma"
  {
# line 801 "Objects.puma"
   if (! ((t->PROC_OBJ.Object == NoObject))) goto yyL3;
  {
# line 802 "Objects.puma"
   return false;
  }
  }
yyL3:;

# line 805 "Objects.puma"
  {
# line 806 "Objects.puma"
   if (! ((IsF77Obj (GetReferenceObject (t->PROC_OBJ.Object))))) goto yyL4;
  }
   return true;
yyL4:;

  }
  return false;
}

static bool IsF77Obj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 811 "Objects.puma"
  {
# line 812 "Objects.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 813 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kFuncObject) {
# line 816 "Objects.puma"
  {
# line 817 "Objects.puma"
   if (! ((IsF77Unit (obj->FuncObject.decl)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (obj->Kind == kProcObject) {
# line 820 "Objects.puma"
  {
# line 821 "Objects.puma"
   if (! ((IsF77Unit (obj->ProcObject.decl)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

tDefinitions GetFuncVarObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions f)
# else
(f)
 register tDefinitions f;
# endif
{
  if (f->Kind == kFuncObject) {
  if (f->FuncObject.decl->Kind == kFUNC_DECL) {
# line 832 "Objects.puma"
  {
# line 834 "Objects.puma"
   if (! ((f->FuncObject.decl->FUNC_DECL.RESULT_ID != DefaultId ()))) goto yyL1;
  }
   return GetDeclEntry (f->FuncObject.decl->FUNC_DECL.RESULT_ID, f->FuncObject.Declarations);
yyL1:;

  }
  }
# line 839 "Objects.puma"
  {
# line 840 "Objects.puma"
   failure_protocol (MODULE, "GetFuncVarObj", f->Object.decl);
  }
   return NoObject;

}

void GetDummies
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree * yyP2, register tDefinitions * yyP1)
# else
(obj, yyP2, yyP1)
 register tDefinitions obj;
 register tTree * yyP2;
 register tDefinitions * yyP1;
# endif
{
# line 852 "Objects.puma"
  {
# line 853 "Objects.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 854 "Objects.puma"
   failure_protocol (MODULE, "GetDummies: no object", NoTree);
  }
  }
   * yyP2 = NoTree;
   * yyP1 = NoDefinitions;
   return;
yyL1:;

  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kPROC_DECL) {
# line 857 "Objects.puma"
   * yyP2 = obj->ProcObject.decl->PROC_DECL.FORMALS;
   * yyP1 = obj->ProcObject.Declarations;
   return;

  }
  if (obj->ProcObject.decl->Kind == kPROGRAM_DECL) {
# line 873 "Objects.puma"
   * yyP2 = NoTree;
   * yyP1 = obj->ProcObject.Declarations;
   return;

  }
  if (obj->ProcObject.decl->Kind == kINTRINSIC_DECL) {
# line 877 "Objects.puma"
   * yyP2 = NoTree;
   * yyP1 = NoDefinitions;
   return;

  }
  }
  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
# line 861 "Objects.puma"
   * yyP2 = obj->FuncObject.decl->FUNC_DECL.FORMALS;
   * yyP1 = obj->FuncObject.Declarations;
   return;

  }
  if (obj->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 867 "Objects.puma"
   * yyP2 = NoTree;
   * yyP1 = NoDefinitions;
   return;

  }
  if (obj->FuncObject.decl->Kind == kINTRINSIC_DECL) {
# line 881 "Objects.puma"
   * yyP2 = NoTree;
   * yyP1 = NoDefinitions;
   return;

  }
  }
# line 885 "Objects.puma"
  {
# line 887 "Objects.puma"
   obj_error_protocol ("could not get dummies for this object", obj);
# line 888 "Objects.puma"
   failure_protocol (MODULE, "GetDummies", obj->Object.decl);
  }
   * yyP2 = NoTree;
   * yyP1 = NoDefinitions;
   return;

;
}

tDefinitions GetReferenceObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 901 "Objects.puma"
  {
# line 903 "Objects.puma"
   if (! ((obj == GetIntrinsicObject (obj->Object.Ident)))) goto yyL1;
  }
   return NoObject;
yyL1:;

# line 908 "Objects.puma"
   return ChooseReferenceObj (obj, GetDeclEntry (obj->Object.Ident, GetUnitEntries ()));

}

static tDefinitions ChooseReferenceObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions interface_obj, register tDefinitions global_obj)
# else
(interface_obj, global_obj)
 register tDefinitions interface_obj;
 register tDefinitions global_obj;
# endif
{
# line 925 "Objects.puma"
  {
# line 929 "Objects.puma"
   if (! ((IsDummyRoutine (interface_obj)))) goto yyL1;
  {
# line 930 "Objects.puma"
   if (! ((NoInterfaceObj (interface_obj)))) goto yyL1;
  }
  }
   return NoObject;
yyL1:;

# line 934 "Objects.puma"
  {
# line 938 "Objects.puma"
   if (! ((IsDummyRoutine (interface_obj)))) goto yyL2;
  }
   return interface_obj;
yyL2:;

# line 942 "Objects.puma"
  {
# line 944 "Objects.puma"
   if (! ((IsUserRoutine (global_obj)))) goto yyL3;
  }
   return global_obj;
yyL3:;

# line 948 "Objects.puma"
  {
# line 950 "Objects.puma"
   if (! ((NoInterfaceObj (interface_obj)))) goto yyL4;
  }
   return NoObject;
yyL4:;

# line 954 "Objects.puma"
   return interface_obj;

}

bool NoInterfaceObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 971 "Objects.puma"
  {
# line 973 "Objects.puma"
   if (! ((v == NoObject))) goto yyL1;
  {
# line 974 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (v->Kind == kExternalObject) {
# line 977 "Objects.puma"
   return true;

  }
  if (v->Kind == kFuncObject) {
  if (v->FuncObject.decl->Kind == kFUNC_DECL) {
# line 980 "Objects.puma"
  {
# line 981 "Objects.puma"
   if (! ((v->FuncObject.decl->FUNC_DECL.FUNC_BODY == NoTree))) goto yyL3;
  }
   return true;
yyL3:;

  }
  }
  if (v->Kind == kProcObject) {
  if (v->ProcObject.decl->Kind == kPROC_DECL) {
# line 984 "Objects.puma"
  {
# line 985 "Objects.puma"
   if (! ((v->ProcObject.decl->PROC_DECL.PROC_BODY == NoTree))) goto yyL4;
  }
   return true;
yyL4:;

  }
  }
  return false;
}

static bool IsDummyRoutine
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 990 "Objects.puma"
  {
# line 991 "Objects.puma"
   if (! ((v == NoObject))) goto yyL1;
  {
# line 992 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (v->Kind == kFuncObject) {
  if (v->FuncObject.decl->Kind == kFUNC_DECL) {
# line 995 "Objects.puma"
  {
# line 996 "Objects.puma"
   if (! ((v->FuncObject.Kind == DummyRoutine))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  if (v->Kind == kProcObject) {
  if (v->ProcObject.decl->Kind == kPROC_DECL) {
# line 999 "Objects.puma"
  {
# line 1000 "Objects.puma"
   if (! ((v->ProcObject.Kind == DummyRoutine))) goto yyL3;
  }
   return true;
yyL3:;

  }
  }
  return false;
}

static bool IsUserRoutine
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 1005 "Objects.puma"
  {
# line 1006 "Objects.puma"
   if (! ((v == NoObject))) goto yyL1;
  {
# line 1007 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (v->Kind == kFuncObject) {
  if (v->FuncObject.decl->Kind == kFUNC_DECL) {
# line 1010 "Objects.puma"
   return true;

  }
  }
  if (v->Kind == kProcObject) {
  if (v->ProcObject.decl->Kind == kPROC_DECL) {
# line 1013 "Objects.puma"
   return true;

  }
  }
  return false;
}

bool FunctionBecomesSubroutine
# if defined __STDC__ | defined __cplusplus
(register tTree f)
# else
(f)
 register tTree f;
# endif
{
  if (f->Kind == kPROC_OBJ) {
# line 1026 "Objects.puma"
  {
# line 1031 "Objects.puma"
   if (! ((IsIntrCall (f)))) goto yyL1;
  {
# line 1032 "Objects.puma"
   if (! ((IntrFuncDalib (f->PROC_OBJ.Ident)))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 1035 "Objects.puma"
  {
# line 1037 "Objects.puma"
   if (! ((IsUserCall (f)))) goto yyL2;
  {
# line 1038 "Objects.puma"
   if (! ((! IsF77Call (f)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  return false;
}

bool IsUsedObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions unit)
# else
(obj, unit)
 register tDefinitions obj;
 register tDefinitions unit;
# endif
{
# line 1051 "Objects.puma"
  {
# line 1053 "Objects.puma"
   if (! ((unit == NoObject))) goto yyL1;
  {
# line 1054 "Objects.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kFuncObject) {
# line 1057 "Objects.puma"
  {
# line 1060 "Objects.puma"
   if (! ((unit == obj))) goto yyL2;
  {
# line 1061 "Objects.puma"
   return false;
  }
  }
yyL2:;

  }
# line 1066 "Objects.puma"
  {
# line 1068 "Objects.puma"
   if (! ((obj->Object.in == NoObject))) goto yyL3;
  {
# line 1070 "Objects.puma"
   return false;
  }
  }
yyL3:;

# line 1073 "Objects.puma"
  {
# line 1075 "Objects.puma"
   if (! ((obj->Object.in != unit))) goto yyL4;
  }
   return true;
yyL4:;

  return false;
}

void BeginObjects ()
{
}

void CloseObjects ()
{
}
