# include "Normalization.h"
# include "yyNormalization.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 34 "Normalization.puma"


# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"
# include "Nesting.h"

# include "DefTable.h"

# include "ArrayData.h"       /* SetActualOverlap                       */
# include "Shapes.h"          /* MakeFullShape, ...                     */

# include "Reaching.h"         /* reaching allocates */
# include "InitAllocate.h"     /* generate allocates */
# include "Inquiry.h"          /* translate inquirys */
# include "Traverse.h"         /* ReplaceAST         */
# include "Rank.h"

# include "MakeRagged.h"      

# include "FArguments.h"       /* IsPointerActual    */
# include "Distributions.h"    /* GetTopologyObj     */

# define MODULE "Normalization"



static void yyExit () { Exit (1); }

void (* Normalization_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Normalization, routine %s failed\n", yyFunction);
 Normalization_Exit ();
}

void Normalization ARGS((tTree t));
static void NormalizationBody ARGS((tTree body, tTree unit));
static tTree SortDeclarations ARGS((tTree t));
static void TryMoveDeclaration ARGS((tTree decl, bool * yyP2, tTree * yyP1));
static tIdent GetTopologyId ARGS((tDefinitions obj));
static void MoveDecl ARGS((tIdent id, tTree decl));
static bool FoundDeclaration ARGS((tIdent id, tTree list));
static bool IsDeclaration ARGS((tIdent id, tTree decl));
static void NormalShape ARGS((tTree body));
static tTree NormalShapeAST ARGS((tTree t));
static bool shape_pred ARGS((tTree t));
static tTree shape_func ARGS((tTree t));
static void MakeFullAllocParams ARGS((tTree params));
static tTree MakeFullShapeFunc ARGS((tTree t));
static void MakeFullShapeProc ARGS((tTree t));
static void NormalNotFullParam ARGS((tTree t));
static tTree MakeRaggedArrays ARGS((tTree t));
static bool ragged_pred ARGS((tTree t));
static tTree ragged_func ARGS((tTree t));

void Normalization
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kCOMP_UNIT:
# line 72 "Normalization.puma"
  {
# line 74 "Normalization.puma"
   open_protocol ("adaptor.normal");
# line 75 "Normalization.puma"
   Normalization (t->COMP_UNIT.COMP_ELEMENTS);
# line 76 "Normalization.puma"
   close_protocol ();
  }
   return;

  case kUNIT_EMPTY:
# line 79 "Normalization.puma"
   return;

  case kUNIT_LIST:
# line 82 "Normalization.puma"
  {
# line 84 "Normalization.puma"
   Normalization (t->UNIT_LIST.Elem);
# line 85 "Normalization.puma"
   Normalization (t->UNIT_LIST.Next);
  }
   return;

  case kPROGRAM_DECL:
# line 88 "Normalization.puma"
  {
# line 90 "Normalization.puma"
   NestOpenUnit (t);
# line 91 "Normalization.puma"
   NormalizationBody (t->PROGRAM_DECL.PROGRAM_BODY, t);
# line 92 "Normalization.puma"
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
# line 95 "Normalization.puma"
  {
# line 97 "Normalization.puma"
   NestOpenUnit (t);
# line 98 "Normalization.puma"
   NormalizationBody (t->PROC_DECL.PROC_BODY, t);
# line 99 "Normalization.puma"
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
# line 102 "Normalization.puma"
  {
# line 104 "Normalization.puma"
   NestOpenUnit (t);
# line 105 "Normalization.puma"
   NormalizationBody (t->FUNC_DECL.FUNC_BODY, t);
# line 106 "Normalization.puma"
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 109 "Normalization.puma"
  {
# line 111 "Normalization.puma"
   NestOpenUnit (t);
# line 112 "Normalization.puma"
   NormalizationBody (t->BLOCK_DATA_DECL.DATA_BODY, t);
# line 113 "Normalization.puma"
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
# line 116 "Normalization.puma"
  {
# line 118 "Normalization.puma"
   NestOpenUnit (t);
# line 119 "Normalization.puma"
   NormalizationBody (t->MODULE_DECL.MODULE_BODY, t);
# line 120 "Normalization.puma"
   NestCloseUnit (t);
  }
   return;

  }

# line 123 "Normalization.puma"
  {
# line 124 "Normalization.puma"
   failure_protocol (MODULE, "Normalization", t);
  }
   return;

;
}

static void NormalizationBody
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree unit)
# else
(body, unit)
 register tTree body;
 register tTree unit;
# endif
{
  if (body->Kind == kBODY_NODE) {
# line 139 "Normalization.puma"
  {
# line 141 "Normalization.puma"
 body->BODY_NODE.DECLS = SortDeclarations (body->BODY_NODE.DECLS); 
# line 143 "Normalization.puma"
 body->BODY_NODE.DECLS = MakeRaggedArrays (body->BODY_NODE.DECLS);
      body->BODY_NODE.STATS = MakeRaggedArrays (body->BODY_NODE.STATS);
    
# line 147 "Normalization.puma"
   ReachingAllocate (body);
# line 151 "Normalization.puma"
   NormalShape (body);
# line 155 "Normalization.puma"
   tree_protocol ("translated ragged arrays : ", body);
# line 157 "Normalization.puma"
   InitAllocate (body, unit);
# line 159 "Normalization.puma"
   Normalization (body->BODY_NODE.INTERNALS);
  }
   return;

  }
# line 162 "Normalization.puma"
  {
# line 164 "Normalization.puma"
   failure_protocol (MODULE, "NormalizationBody", body);
  }
   return;

;
}

static tTree SortDeclarations
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDECL_EMPTY) {
# line 182 "Normalization.puma"
   return t;

  }
  if (t->Kind == kDECL_LIST) {
# line 186 "Normalization.puma"
 {
  bool yyV1;
  tTree yyV2;
  {
# line 187 "Normalization.puma"
   TryMoveDeclaration (t, & yyV1, & yyV2);
# line 188 "Normalization.puma"
   if (! ((yyV1))) goto yyL2;
  }
  {
   return SortDeclarations (yyV2);
  }
 }
yyL2:;

# line 192 "Normalization.puma"
  {
# line 193 "Normalization.puma"
 t->DECL_LIST.Next = SortDeclarations (t->DECL_LIST.Next); 
  }
   return t;

  }
 yyAbort ("SortDeclarations");
}

static void TryMoveDeclaration
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register bool * yyP2, register tTree * yyP1)
# else
(decl, yyP2, yyP1)
 register tTree decl;
 register bool * yyP2;
 register tTree * yyP1;
# endif
{
  if (decl->Kind == kDECL_LIST) {
  if (decl->DECL_LIST.Elem->Kind == kDISTRIBUTE_DECL) {
# line 205 "Normalization.puma"
  {
# line 208 "Normalization.puma"
   if (! ((FoundDeclaration (decl->DECL_LIST.Elem->DISTRIBUTE_DECL.Ident, decl->DECL_LIST.Next)))) goto yyL1;
  {
# line 209 "Normalization.puma"
   MoveDecl (decl->DECL_LIST.Elem->DISTRIBUTE_DECL.Ident, decl);
  }
  }
   * yyP2 = true;
   * yyP1 = decl;
   return;
yyL1:;

  }
  if (decl->DECL_LIST.Elem->Kind == kTEMPLATE_DECL) {
# line 214 "Normalization.puma"
 {
  tDefinitions proc_obj;
  tIdent proc_id;
  {
# line 217 "Normalization.puma"

# line 218 "Normalization.puma"

# line 220 "Normalization.puma"
   proc_obj = GetTopologyObj (GetGlobalObject (decl->DECL_LIST.Elem->TEMPLATE_DECL.Ident));
# line 222 "Normalization.puma"
   proc_id = GetTopologyId (proc_obj);
# line 224 "Normalization.puma"
   if (! ((proc_id != DefaultId ()))) goto yyL2;
  {
# line 226 "Normalization.puma"
   if (! ((FoundDeclaration (proc_id, decl->DECL_LIST.Next)))) goto yyL2;
  {
# line 227 "Normalization.puma"
   MoveDecl (proc_id, decl);
  }
  }
  }
   * yyP2 = true;
   * yyP1 = decl;
   return;
 }
yyL2:;

  }
  if (decl->DECL_LIST.Elem->Kind == kVAR_DECL) {
# line 232 "Normalization.puma"
 {
  tDefinitions proc_obj;
  tIdent proc_id;
  {
# line 235 "Normalization.puma"

# line 236 "Normalization.puma"

# line 238 "Normalization.puma"
   proc_obj = GetTopologyObj (GetGlobalObject (decl->DECL_LIST.Elem->VAR_DECL.Ident));
# line 240 "Normalization.puma"
   proc_id = GetTopologyId (proc_obj);
# line 242 "Normalization.puma"
   if (! ((proc_id != DefaultId ()))) goto yyL3;
  {
# line 243 "Normalization.puma"
   if (! ((FoundDeclaration (proc_id, decl->DECL_LIST.Next)))) goto yyL3;
  {
# line 244 "Normalization.puma"
   MoveDecl (proc_id, decl);
  }
  }
  }
   * yyP2 = true;
   * yyP1 = decl;
   return;
 }
yyL3:;

# line 258 "Normalization.puma"
 {
  tDefinitions temp_obj;
  tIdent temp_id;
  {
# line 261 "Normalization.puma"

# line 262 "Normalization.puma"

# line 264 "Normalization.puma"
   temp_obj = GetTemplateObj (GetGlobalObject (decl->DECL_LIST.Elem->VAR_DECL.Ident));
# line 265 "Normalization.puma"
   temp_id = temp_obj->Object.Ident;
# line 267 "Normalization.puma"
   if (! (((temp_id != DefaultId ()) && (temp_id != decl->DECL_LIST.Elem->VAR_DECL.Ident)))) goto yyL5;
  {
# line 268 "Normalization.puma"
   if (! ((FoundDeclaration (temp_id, decl->DECL_LIST.Next)))) goto yyL5;
  {
# line 269 "Normalization.puma"
   MoveDecl (temp_id, decl);
  }
  }
  }
   * yyP2 = true;
   * yyP1 = decl;
   return;
 }
yyL5:;

  }
  if (decl->DECL_LIST.Elem->Kind == kALIGN_DECL) {
# line 249 "Normalization.puma"
  {
# line 252 "Normalization.puma"
   if (! ((FoundDeclaration (decl->DECL_LIST.Elem->ALIGN_DECL.Ident, decl->DECL_LIST.Next)))) goto yyL4;
  {
# line 253 "Normalization.puma"
   MoveDecl (decl->DECL_LIST.Elem->ALIGN_DECL.Ident, decl);
  }
  }
   * yyP2 = true;
   * yyP1 = decl;
   return;
yyL4:;

  }
  }
# line 274 "Normalization.puma"
   * yyP2 = false;
   * yyP1 = decl;
   return;

;
}

static tIdent GetTopologyId
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 288 "Normalization.puma"
  {
# line 290 "Normalization.puma"
   if (! ((obj == NoObject))) goto yyL1;
  }
   return DefaultId ();
yyL1:;

  if (obj->Kind == kTopologyObject) {
# line 295 "Normalization.puma"
  {
# line 297 "Normalization.puma"
   if (! ((obj->TopologyObject.Ident == DefaultId ()))) goto yyL2;
  }
   return obj->TopologyObject.Ident;
yyL2:;

  if (obj->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
# line 302 "Normalization.puma"
   return obj->TopologyObject.Ident;

  }
  if (obj->TopologyObject.decl->Kind == kSUB_PROCS_DECL) {
# line 307 "Normalization.puma"
   return obj->TopologyObject.decl->SUB_PROCS_DECL.TOP->TOP_OBJ.Ident;

  }
  }
# line 312 "Normalization.puma"
   return DefaultId ();

}

static void MoveDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree decl)
# else
(id, decl)
 register tIdent id;
 register tTree decl;
# endif
{
  if (decl->Kind == kDECL_LIST) {
  if (decl->DECL_LIST.Next->Kind == kDECL_LIST) {
# line 327 "Normalization.puma"
 {
  tTree h;
  {
# line 329 "Normalization.puma"
   if (! ((IsDeclaration (id, decl->DECL_LIST.Next->DECL_LIST.Elem)))) goto yyL1;
  {
# line 331 "Normalization.puma"

# line 333 "Normalization.puma"
 h = decl->DECL_LIST.Elem;
     decl->DECL_LIST.Elem = decl->DECL_LIST.Next->DECL_LIST.Elem;
     decl->DECL_LIST.Next->DECL_LIST.Elem = h;
   
  }
  }
   return;
 }
yyL1:;

# line 339 "Normalization.puma"
 {
  tTree h;
  {
# line 341 "Normalization.puma"

# line 343 "Normalization.puma"
 h = decl->DECL_LIST.Elem;
     decl->DECL_LIST.Elem = decl->DECL_LIST.Next->DECL_LIST.Elem;
     decl->DECL_LIST.Next->DECL_LIST.Elem = h;
   
# line 347 "Normalization.puma"
   MoveDecl (id, decl->DECL_LIST.Next);
  }
   return;
 }

  }
  }
# line 350 "Normalization.puma"
  {
# line 351 "Normalization.puma"
   failure_protocol (MODULE, "MoveDecl", decl);
  }
   return;

;
}

static bool FoundDeclaration
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree list)
# else
(id, list)
 register tIdent id;
 register tTree list;
# endif
{
  if (list->Kind == kDECL_LIST) {
# line 364 "Normalization.puma"
  {
# line 365 "Normalization.puma"
   if (! ((IsDeclaration (id, list->DECL_LIST.Elem)))) goto yyL1;
  }
   return true;
yyL1:;

# line 368 "Normalization.puma"
  {
# line 369 "Normalization.puma"
   if (! ((FoundDeclaration (id, list->DECL_LIST.Next)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

static bool IsDeclaration
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree decl)
# else
(id, decl)
 register tIdent id;
 register tTree decl;
# endif
{
  if (decl->Kind == kTEMPLATE_DECL) {
# line 380 "Normalization.puma"
  {
# line 381 "Normalization.puma"
   if (! ((id == decl->TEMPLATE_DECL.Ident))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (decl->Kind == kPROCESSORS_DECL) {
# line 384 "Normalization.puma"
  {
# line 385 "Normalization.puma"
   if (! ((id == decl->PROCESSORS_DECL.Ident))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (decl->Kind == kVAR_DECL) {
# line 388 "Normalization.puma"
  {
# line 389 "Normalization.puma"
   if (! ((id == decl->VAR_DECL.Ident))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

static void NormalShape
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
# line 410 "Normalization.puma"
  {
# line 412 "Normalization.puma"
 body->BODY_NODE.DECLS = NormalShapeAST (body->BODY_NODE.DECLS); 
      body->BODY_NODE.STATS = NormalShapeAST (body->BODY_NODE.STATS); 
    
  }
   return;

  }
# line 417 "Normalization.puma"
  {
# line 419 "Normalization.puma"
   failure_protocol (MODULE, "NormalShape", body);
  }
   return;

;
}

static tTree NormalShapeAST
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 424 "Normalization.puma"
   return ReplaceAST (t, shape_pred, shape_func);

}

static bool shape_pred
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kINDEXED_VAR:
# line 443 "Normalization.puma"
   return true;

  case kSELECTED_VAR:
# line 446 "Normalization.puma"
   return true;

  case kCALL_STMT:
# line 449 "Normalization.puma"
   return true;

  case kIO_STMT:
# line 452 "Normalization.puma"
   return true;

  case kFUNC_CALL_EXP:
# line 455 "Normalization.puma"
   return true;

  case kDEALLOCATE_STMT:
# line 458 "Normalization.puma"
   return true;

  case kALLOCATE_STMT:
# line 461 "Normalization.puma"
   return true;

  case kCREATE_DSP_STMT:
# line 464 "Normalization.puma"
   return true;

  case kINHERIT_DSP_STMT:
# line 467 "Normalization.puma"
   return true;

  case kFREE_DSP_STMT:
# line 470 "Normalization.puma"
   return true;

  }

# line 473 "Normalization.puma"
  {
# line 474 "Normalization.puma"
   return false;
  }

}

static tTree shape_func
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kIO_STMT:
# line 487 "Normalization.puma"
  {
# line 489 "Normalization.puma"
   MakeFullShapeProc (t);
  }
   return t;

  case kCALL_STMT:
# line 494 "Normalization.puma"
  {
# line 496 "Normalization.puma"
   MakeFullShapeProc (t);
  }
   return t;

  case kUSED_VAR:
# line 501 "Normalization.puma"
 {
  tTree new;
  {
# line 503 "Normalization.puma"

# line 505 "Normalization.puma"
   if (! ((TreeRank (t) > 0))) goto yyL3;
  {
# line 507 "Normalization.puma"
   new = MakeFullShape (t);
  }
  }
  {
   return new;
  }
 }
yyL3:;

  break;
  case kSELECTED_VAR:
# line 512 "Normalization.puma"
  {
# line 514 "Normalization.puma"
   if (! ((VarRank (t->SELECTED_VAR.SELECTOR->REC_COMP.Object) == 0))) goto yyL4;
  {
# line 516 "Normalization.puma"
 t->SELECTED_VAR.SELEC_VAR = NormalShapeAST (t->SELECTED_VAR.SELEC_VAR); 
  }
  }
   return t;
yyL4:;

# line 521 "Normalization.puma"
 {
  tTree new;
  {
# line 523 "Normalization.puma"

# line 525 "Normalization.puma"
   tree_protocol ("make full shape of selected var : ", t);
# line 527 "Normalization.puma"
 t->SELECTED_VAR.SELEC_VAR = NormalShapeAST (t->SELECTED_VAR.SELEC_VAR); 
# line 529 "Normalization.puma"
   new = MakeFullShape (t);
# line 531 "Normalization.puma"
   tree_protocol ("full shape of selected var  now : ", new);
  }
  {
   return new;
  }
 }

  case kINDEXED_VAR:
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 536 "Normalization.puma"
 {
  tTree new;
  {
# line 538 "Normalization.puma"

# line 540 "Normalization.puma"
   tree_protocol ("make full shape of indexed var : ", t);
# line 544 "Normalization.puma"
 t->INDEXED_VAR.IND_EXPS = NormalShapeAST (t->INDEXED_VAR.IND_EXPS); 
# line 546 "Normalization.puma"
   new = MakeFullShape (t);
# line 548 "Normalization.puma"
   tree_protocol ("full shape of indexed var now : ", new);
  }
  {
   return new;
  }
 }

  }
  if (t->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
# line 553 "Normalization.puma"
 {
  tTree new;
  {
# line 555 "Normalization.puma"

# line 557 "Normalization.puma"
   tree_protocol ("make full shape of sel indexed var : ", t);
# line 559 "Normalization.puma"
 t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR = NormalShapeAST (t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR);
     t->INDEXED_VAR.IND_EXPS = NormalShapeAST (t->INDEXED_VAR.IND_EXPS); 
   
# line 563 "Normalization.puma"
   new = MakeFullShape (t);
# line 565 "Normalization.puma"
   tree_protocol ("full shape of sel indexed var now : ", new);
  }
  {
   return new;
  }
 }

  }
  break;
  case kFUNC_CALL_EXP:
# line 570 "Normalization.puma"
   return MakeFullShapeFunc (t);

  case kALLOCATE_STMT:
# line 575 "Normalization.puma"
  {
# line 577 "Normalization.puma"
 t->ALLOCATE_STMT.STATUS = NormalShapeAST (t->ALLOCATE_STMT.STATUS); 
     MakeFullAllocParams (t->ALLOCATE_STMT.PARAMS); 
   
  }
   return t;

  }

# line 584 "Normalization.puma"
   return t;

}

static void MakeFullAllocParams
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 590 "Normalization.puma"
  {
# line 592 "Normalization.puma"
   MakeFullAllocParams (params->BTP_LIST.Next);
  }
   return;

  }
  }
# line 595 "Normalization.puma"
  {
# line 597 "Normalization.puma"
 params->BTP_LIST.Elem = NormalShapeAST (params->BTP_LIST.Elem); 
# line 599 "Normalization.puma"
   MakeFullAllocParams (params->BTP_LIST.Next);
  }
   return;

  }
;
}

static tTree MakeFullShapeFunc
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_CALL_EXP) {
# line 629 "Normalization.puma"
  {
# line 631 "Normalization.puma"
   if (! ((IsIntrCall (t)))) goto yyL1;
  {
# line 632 "Normalization.puma"
   if (! ((t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("PRESENT")))) goto yyL1;
  }
  }
   return t;
yyL1:;

# line 637 "Normalization.puma"
  {
# line 639 "Normalization.puma"
   if (! ((IsIntrCall (t)))) goto yyL2;
  {
# line 641 "Normalization.puma"
 t->FUNC_CALL_EXP.FUNC_PARAMS = NormalShapeAST (t->FUNC_CALL_EXP.FUNC_PARAMS); 
  }
  }
   return TranslateInquiryCall (t);
yyL2:;

# line 646 "Normalization.puma"
  {
# line 648 "Normalization.puma"
   NormalNotFullParam (t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
   return t;

  }
 yyAbort ("MakeFullShapeFunc");
}

static void MakeFullShapeProc
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCALL_STMT) {
# line 661 "Normalization.puma"
  {
# line 662 "Normalization.puma"
   NormalNotFullParam (t->CALL_STMT.CALL_PARAMS);
  }
   return;

  }
  if (t->Kind == kIO_STMT) {
# line 665 "Normalization.puma"
  {
# line 666 "Normalization.puma"
   NormalNotFullParam (t->IO_STMT.IO_ITEMS);
  }
   return;

  }
;
}

static void NormalNotFullParam
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
# line 677 "Normalization.puma"
  {
# line 678 "Normalization.puma"
   NormalNotFullParam (t->BTP_LIST.Elem);
# line 679 "Normalization.puma"
   NormalNotFullParam (t->BTP_LIST.Next);
  }
   return;

  }
  if (t->Kind == kBTP_EMPTY) {
# line 682 "Normalization.puma"
   return;

  }
  if (t->Kind == kVAR_PARAM) {
# line 697 "Normalization.puma"
  {
# line 699 "Normalization.puma"
 t->VAR_PARAM.V = NormalShapeAST (t->VAR_PARAM.V); 
  }
   return;

  }
  if (t->Kind == kFUNC_PARAM) {
# line 702 "Normalization.puma"
   return;

  }
  if (t->Kind == kPROC_PARAM) {
# line 705 "Normalization.puma"
   return;

  }
  if (t->Kind == kNO_PARAM) {
# line 708 "Normalization.puma"
   return;

  }
# line 711 "Normalization.puma"
  {
# line 712 "Normalization.puma"
   failure_protocol (MODULE, "NormalNotFullParam", t);
  }
   return;

;
}

static tTree MakeRaggedArrays
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 718 "Normalization.puma"
   return ReplaceAST (t, ragged_pred, ragged_func);

}

static bool ragged_pred
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 724 "Normalization.puma"
  {
# line 725 "Normalization.puma"
   if (! ((IsTreeAccess (t)))) goto yyL1;
  }
   return true;
yyL1:;

  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
# line 728 "Normalization.puma"
   return true;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
# line 731 "Normalization.puma"
   return true;

  }
  }
  return false;
}

static tTree ragged_func
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
# line 736 "Normalization.puma"
   return MakeRaggedDecls (t, GetLocalObject (t->VAR_DECL.Ident));

  }
  if (t->Kind == kTREE_DECL) {
# line 741 "Normalization.puma"
   return NoTree;

  }
  if (Tree_IsType (t, kBT_VAR)) {
# line 746 "Normalization.puma"
  {
# line 748 "Normalization.puma"
   if (! ((IsTreeAccess (t)))) goto yyL3;
  }
   return MakeRaggedAccess (t);
yyL3:;

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
# line 753 "Normalization.puma"
   return MakeRaggedAllocates (t);

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
# line 758 "Normalization.puma"
   return MakeRaggedDeallocates (t);

  }
  }
# line 763 "Normalization.puma"
   return t;

}

void BeginNormalization ()
{
}

void CloseNormalization ()
{
}
