# include "NormalDefs.h"
# include "yyNormalDefs.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 28 "NormalDefs.puma"


# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "DefTable.h"

# include "Transform.h"
# include "Types.h"         /* GetObjectType */

# include "Nesting.h"

#define MODULE "NormalDefs"

    /*****************************************************
    *                                                    *
    *    Global Variables in Making Definitions          *
    *                                                    *
    *    ProgramCounter : counts PROGRAM_DECL            *
    *                                                    *
    *****************************************************/

static tTree Entity;
static tTree NewEntityDecls;   /* global use for translating an entity */
static bool  IsParameterEntity;
static tTree InitialValue;

static tTree stmtfuncs;



static void yyExit () { Exit (1); }

void (* NormalDefs_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module NormalDefs, routine %s failed\n", yyFunction);
 NormalDefs_Exit ();
}

static tTree ReverseDeclList ARGS((tTree list, tTree newlist));
tTree Normal1Definitions ARGS((tTree t));
static tTree TranslateCommonDECL ARGS((tTree idlist));
static void TranslateEntityDecl ARGS((tIdent id, int pos, tTree attributes, tTree current_entity));
static void UpdateEntityVal ARGS((tTree decl, tTree newval));
static void UpdateEntityDims ARGS((tTree decl, tTree newdims));
tTree Normal2Definitions ARGS((tTree t));
void StatementFunctions ARGS((tTree body));
static tTree ExtractStatementFunctions ARGS((tTree t));
static bool IsStatementFunction ARGS((tTree t));
static bool NoIndexAllowed ARGS((tDefinitions obj));
static tTree MakeStmtFuncDecl ARGS((tTree var, tTree exp));
static tTree MakeStmtFuncFormals ARGS((tTree Parameters));
static bool IsDummyArgName ARGS((tTree t));
static bool IsDummyArgNameList ARGS((tTree t));
static tTree MakeDataItems ARGS((tTree val));

static tTree ReverseDeclList
# if defined __STDC__ | defined __cplusplus
(register tTree list, register tTree newlist)
# else
(list, newlist)
 register tTree list;
 register tTree newlist;
# endif
{
# line 71 "NormalDefs.puma"
  {
# line 72 "NormalDefs.puma"
   if (! ((list == NoTree))) goto yyL1;
  }
   return newlist;
yyL1:;

  if (list->Kind == kDECL_LIST) {
# line 76 "NormalDefs.puma"
 {
  tTree help;
  {
# line 78 "NormalDefs.puma"

# line 80 "NormalDefs.puma"
 help = list->DECL_LIST.Next;
     list->DECL_LIST.Next = newlist;
   
  }
  {
   return ReverseDeclList (help, list);
  }
 }

  }
 yyAbort ("ReverseDeclList");
}

tTree Normal1Definitions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDECL_LIST) {
# line 108 "NormalDefs.puma"
 {
  tTree newdecl;
  {
# line 110 "NormalDefs.puma"

# line 112 "NormalDefs.puma"
 newdecl = Normal1Definitions (t->DECL_LIST.Elem);
     t->DECL_LIST.Next    = Normal1Definitions (t->DECL_LIST.Next);
     newdecl = ReplaceDECL (t, newdecl, t->DECL_LIST.Next);
   
  }
  {
   return newdecl;
  }
 }

  }
  if (t->Kind == kDECL_EMPTY) {
# line 119 "NormalDefs.puma"
   return t;

  }
  if (t->Kind == kENTITY_DECL) {
# line 131 "NormalDefs.puma"
  {
# line 133 "NormalDefs.puma"
   Entity = NoTree;
# line 134 "NormalDefs.puma"
   NewEntityDecls = NoTree;
# line 135 "NormalDefs.puma"
   IsParameterEntity = false;
# line 136 "NormalDefs.puma"
   InitialValue = NoTree;
# line 138 "NormalDefs.puma"
   TranslateEntityDecl (t->ENTITY_DECL.Ident, t->ENTITY_DECL.Line, t->ENTITY_DECL.ATTRIBUTES, t);
  }
   return NewEntityDecls;

  }
  if (t->Kind == kCOMMON_DECL) {
# line 143 "NormalDefs.puma"
 {
  tTree newdecl;
  {
# line 147 "NormalDefs.puma"

# line 149 "NormalDefs.puma"
 newdecl = TranslateCommonDECL (t->COMMON_DECL.IDS);
     if (newdecl == NoTree)
        newdecl = t;
      else
        newdecl = mDECL_LIST (t, newdecl);
   
  }
  {
   return newdecl;
  }
 }

  }
# line 160 "NormalDefs.puma"
   return t;

}

static tTree TranslateCommonDECL
# if defined __STDC__ | defined __cplusplus
(register tTree idlist)
# else
(idlist)
 register tTree idlist;
# endif
{
# line 178 "NormalDefs.puma"

tTree newdecl;

  if (idlist->Kind == kDECL_LIST) {
# line 182 "NormalDefs.puma"
  {
# line 183 "NormalDefs.puma"
 newdecl = TranslateCommonDECL (idlist->DECL_LIST.Elem);
     if (newdecl == NoTree)
        newdecl = TranslateCommonDECL (idlist->DECL_LIST.Next);
      else
        newdecl = mDECL_LIST (newdecl, TranslateCommonDECL (idlist->DECL_LIST.Next));
   
  }
   return newdecl;

  }
  if (idlist->Kind == kDECL_EMPTY) {
# line 192 "NormalDefs.puma"
   return NoTree;

  }
  if (idlist->Kind == kVAR_DECL) {
  if (idlist->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 196 "NormalDefs.puma"
  {
# line 197 "NormalDefs.puma"
 newdecl = mDIMENSION_DECL (idlist->VAR_DECL.Ident, idlist->VAR_DECL.Line, idlist->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES); 
     idlist->VAR_DECL.VAL = idlist->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE;
   
  }
   return newdecl;

  }
# line 205 "NormalDefs.puma"
   return NoTree;

  }
 yyAbort ("TranslateCommonDECL");
}

static void TranslateEntityDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register int pos, register tTree attributes, register tTree current_entity)
# else
(id, pos, attributes, current_entity)
 register tIdent id;
 register int pos;
 register tTree attributes;
 register tTree current_entity;
# endif
{
# line 220 "NormalDefs.puma"

tTree newdecl;

  if (attributes->Kind == kDECL_EMPTY) {
# line 226 "NormalDefs.puma"
  {
# line 228 "NormalDefs.puma"
 if (IsParameterEntity && (InitialValue == NoTree))
       tree_error_protocol ("Missing initial value for PARAMETER", 
                             current_entity);

    

    NewEntityDecls = ReverseDeclList (NewEntityDecls, NoTree);

    

    if (Entity != NoTree)
       NewEntityDecls = mDECL_LIST (Entity, NewEntityDecls);

  
  }
   return;

  }
  if (attributes->Kind == kDECL_LIST) {

  switch (attributes->DECL_LIST.Elem->Kind) {
  case kTYPESPEC_DECL:
# line 244 "NormalDefs.puma"
  {
# line 245 "NormalDefs.puma"
 if (Entity == NoTree)
      Entity = mVAR_DECL (id, pos, attributes->DECL_LIST.Elem->TYPESPEC_DECL.VAL);
     else 
      UpdateEntityVal (Entity, attributes->DECL_LIST.Elem->TYPESPEC_DECL.VAL);
  
# line 250 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kDIMENSION_DECL:
# line 253 "NormalDefs.puma"
  {
# line 254 "NormalDefs.puma"
 if (Entity == NoTree)
      Entity = mVAR_DECL (id, pos, mARRAY_TYPE (attributes->DECL_LIST.Elem->DIMENSION_DECL.INDEXES, mDUMMY_TYPE()));
     else 
      UpdateEntityDims (Entity, attributes->DECL_LIST.Elem->DIMENSION_DECL.INDEXES);
  
# line 259 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kINIT_DATA_DECL:
# line 262 "NormalDefs.puma"
  {
# line 263 "NormalDefs.puma"
  InitialValue = attributes->DECL_LIST.Elem->INIT_DATA_DECL.VAL;
     if (IsParameterEntity)
       { newdecl = mPARAMETER_DECL (id, pos, attributes->DECL_LIST.Elem->INIT_DATA_DECL.VAL);
         NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
       }
      else
       
       { newdecl = mDATA_DECL (DefaultId(), pos, 
                      mBTV_LIST (mUSED_VAR (mVAR_OBJ (pos, id)), 
                                 mBTV_EMPTY ()),
                      MakeDataItems (attributes->DECL_LIST.Elem->INIT_DATA_DECL.VAL));
         NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
       }
  
# line 277 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kSAVE_DECL:
# line 280 "NormalDefs.puma"
  {
# line 281 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->SAVE_DECL.Ident = id; attributes->DECL_LIST.Elem->SAVE_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 284 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kEXTERNAL_DECL:
# line 287 "NormalDefs.puma"
  {
# line 288 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->EXTERNAL_DECL.Ident = id; attributes->DECL_LIST.Elem->EXTERNAL_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 291 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kINTRINSIC_DECL:
# line 294 "NormalDefs.puma"
  {
# line 295 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->INTRINSIC_DECL.Ident = id; attributes->DECL_LIST.Elem->INTRINSIC_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 298 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kINTENT_DECL:
# line 301 "NormalDefs.puma"
  {
# line 302 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->INTENT_DECL.Ident = id; attributes->DECL_LIST.Elem->INTENT_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 305 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kOPTIONAL_DECL:
# line 308 "NormalDefs.puma"
  {
# line 309 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->OPTIONAL_DECL.Ident = id; attributes->DECL_LIST.Elem->OPTIONAL_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 312 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kALLOCATABLE_DECL:
# line 315 "NormalDefs.puma"
  {
# line 316 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->ALLOCATABLE_DECL.Ident = id; attributes->DECL_LIST.Elem->ALLOCATABLE_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 319 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kPOINTER_DECL:
# line 322 "NormalDefs.puma"
  {
# line 323 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->POINTER_DECL.Ident = id; attributes->DECL_LIST.Elem->POINTER_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 326 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kTARGET_DECL:
# line 329 "NormalDefs.puma"
  {
# line 330 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->TARGET_DECL.Ident = id; attributes->DECL_LIST.Elem->TARGET_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 333 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kPUBLIC_DECL:
# line 336 "NormalDefs.puma"
  {
# line 337 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->PUBLIC_DECL.Ident = id; attributes->DECL_LIST.Elem->PUBLIC_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 340 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kPRIVATE_DECL:
# line 343 "NormalDefs.puma"
  {
# line 344 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->PRIVATE_DECL.Ident = id; attributes->DECL_LIST.Elem->PRIVATE_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 347 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kPARAMETER_DECL:
# line 350 "NormalDefs.puma"
  {
# line 351 "NormalDefs.puma"
 IsParameterEntity = true; 
# line 352 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kTEMPLATE_DECL:
# line 355 "NormalDefs.puma"
  {
# line 356 "NormalDefs.puma"
 if (Entity == NoTree)
      { Entity = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->TEMPLATE_DECL.Ident = id; attributes->DECL_LIST.Elem->TEMPLATE_DECL.Line = pos; }
     else 
      tree_error_protocol ("Illegal TEMPLATE", current_entity);
  
# line 361 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kPROCESSORS_DECL:
# line 364 "NormalDefs.puma"
  {
# line 365 "NormalDefs.puma"
 if (Entity == NoTree)
      { Entity = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->PROCESSORS_DECL.Ident = id; attributes->DECL_LIST.Elem->PROCESSORS_DECL.Line = pos; }
     else 
      tree_error_protocol ("Illegal PROCESSORS", current_entity);
  
# line 370 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kALIGN_DECL:
# line 373 "NormalDefs.puma"
  {
# line 374 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->ALIGN_DECL.Ident = id; attributes->DECL_LIST.Elem->ALIGN_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 377 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kDYNAMIC_DECL:
# line 380 "NormalDefs.puma"
  {
# line 381 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->DYNAMIC_DECL.Ident = id; attributes->DECL_LIST.Elem->DYNAMIC_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 384 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kDISTRIBUTE_DECL:
# line 387 "NormalDefs.puma"
  {
# line 388 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->DISTRIBUTE_DECL.Ident = id; attributes->DECL_LIST.Elem->DISTRIBUTE_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 391 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kOVERLAP_DECL:
# line 394 "NormalDefs.puma"
  {
# line 395 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->OVERLAP_DECL.Ident = id; attributes->DECL_LIST.Elem->OVERLAP_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 398 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kINHERIT_DECL:
# line 401 "NormalDefs.puma"
  {
# line 402 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->INHERIT_DECL.Ident = id; attributes->DECL_LIST.Elem->INHERIT_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 405 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kSHARED_DECL:
# line 408 "NormalDefs.puma"
  {
# line 409 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->SHARED_DECL.Ident = id; attributes->DECL_LIST.Elem->SHARED_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 412 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kRANGE_DECL:
# line 415 "NormalDefs.puma"
  {
# line 416 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->RANGE_DECL.Ident = id; attributes->DECL_LIST.Elem->RANGE_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 419 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kLAYOUT_DECL:
# line 422 "NormalDefs.puma"
  {
# line 423 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->LAYOUT_DECL.Ident = id; attributes->DECL_LIST.Elem->LAYOUT_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 426 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kPASS_BY_DECL:
# line 429 "NormalDefs.puma"
  {
# line 430 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->PASS_BY_DECL.Ident = id; attributes->DECL_LIST.Elem->PASS_BY_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 433 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  case kMAP_TO_DECL:
# line 436 "NormalDefs.puma"
  {
# line 437 "NormalDefs.puma"
  newdecl = attributes->DECL_LIST.Elem; attributes->DECL_LIST.Elem->MAP_TO_DECL.Ident = id; attributes->DECL_LIST.Elem->MAP_TO_DECL.Line = pos;
     NewEntityDecls = mDECL_LIST (newdecl, NewEntityDecls);
  
# line 440 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  }

# line 443 "NormalDefs.puma"
  {
# line 444 "NormalDefs.puma"
   tree_error_protocol ("Unknown Attribute", attributes->DECL_LIST.Elem);
# line 445 "NormalDefs.puma"
   TranslateEntityDecl (id, pos, attributes->DECL_LIST.Next, current_entity);
  }
   return;

  }
;
}

static void UpdateEntityVal
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tTree newval)
# else
(decl, newval)
 register tTree decl;
 register tTree newval;
# endif
{
  if (decl->Kind == kVAR_DECL) {
  if (decl->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 450 "NormalDefs.puma"
  {
# line 451 "NormalDefs.puma"
 decl->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE = newval; 
  }
   return;

  }
# line 454 "NormalDefs.puma"
  {
# line 455 "NormalDefs.puma"
 decl->VAR_DECL.VAL = newval; 
  }
   return;

  }
;
}

static void UpdateEntityDims
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tTree newdims)
# else
(decl, newdims)
 register tTree decl;
 register tTree newdims;
# endif
{
  if (decl->Kind == kVAR_DECL) {
  if (decl->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 460 "NormalDefs.puma"
  {
# line 461 "NormalDefs.puma"
 decl->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES = newdims; 
  }
   return;

  }
# line 464 "NormalDefs.puma"
  {
# line 465 "NormalDefs.puma"
 decl->VAR_DECL.VAL = mARRAY_TYPE (newdims, decl->VAR_DECL.VAL); 
  }
   return;

  }
  if (decl->Kind == kTEMPLATE_DECL) {
# line 468 "NormalDefs.puma"
  {
# line 469 "NormalDefs.puma"
 decl->TEMPLATE_DECL.DIMENSIONS = newdims; 
  }
   return;

  }
  if (decl->Kind == kPROCESSORS_DECL) {
# line 472 "NormalDefs.puma"
  {
# line 473 "NormalDefs.puma"
 decl->PROCESSORS_DECL.DIMENSIONS = newdims; 
  }
   return;

  }
;
}

tTree Normal2Definitions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 493 "NormalDefs.puma"

tTree newdecl;

  if (t->Kind == kDECL_LIST) {
# line 497 "NormalDefs.puma"
  {
# line 498 "NormalDefs.puma"
 newdecl = Normal2Definitions (t->DECL_LIST.Elem);
     t->DECL_LIST.Next    = Normal2Definitions (t->DECL_LIST.Next);
     newdecl = ReplaceDECL (t, newdecl, t->DECL_LIST.Next);
   
  }
   return newdecl;

  }
  if (t->Kind == kDECL_EMPTY) {
# line 505 "NormalDefs.puma"
   return t;

  }
  if (t->Kind == kDIMENSION_DECL) {
# line 509 "NormalDefs.puma"
 {
  tTree type;
  {
# line 513 "NormalDefs.puma"

# line 515 "NormalDefs.puma"
 type = GetBaseType (GetObjectType (GetLocalObject (t->DIMENSION_DECL.Ident)));
      type = mARRAY_TYPE (t->DIMENSION_DECL.INDEXES, type);
      t->Kind = kVAR_DECL;
      t->VAR_DECL.VAL = type;
    
  }
  {
   return t;
  }
 }

  }
  if (t->Kind == kVAR_DECL) {
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 523 "NormalDefs.puma"
   return t;

  }
# line 530 "NormalDefs.puma"
 {
  tTree newdecl;
  tDefinitions obj;
  int rank;
  {
# line 534 "NormalDefs.puma"

# line 535 "NormalDefs.puma"

# line 536 "NormalDefs.puma"

# line 538 "NormalDefs.puma"
 obj = GetLocalObject (t->VAR_DECL.Ident);
      if (obj != NoObject)
         rank = VarRank (obj);
        else
         rank = 0;
      if (rank == 0)
         newdecl = t;
       else
         newdecl = NoTree;
    
  }
  {
   return newdecl;
  }
 }

  }
# line 553 "NormalDefs.puma"
   return t;

}

void StatementFunctions
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
# line 565 "NormalDefs.puma"
  {
# line 567 "NormalDefs.puma"
 
      

      stmtfuncs = mDECL_EMPTY ();

      

      body->BODY_NODE.STATS = ExtractStatementFunctions (body->BODY_NODE.STATS);  

      body->BODY_NODE.DECLS = AppendDECLS (body->BODY_NODE.DECLS, stmtfuncs);  

    
  }
   return;

  }
;
}

static tTree ExtractStatementFunctions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 596 "NormalDefs.puma"

tTree StmtFuncDecl;
tTree NextList;

  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Elem->Kind == kACF_BASIC) {
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 601 "NormalDefs.puma"
  {
# line 603 "NormalDefs.puma"
   if (! ((IsStatementFunction (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  {
# line 605 "NormalDefs.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 607 "NormalDefs.puma"
   stmt_protocol ("this is a statement function");
# line 613 "NormalDefs.puma"
 StmtFuncDecl = MakeStmtFuncDecl (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
      NextList     = ExtractStatementFunctions (t->ACF_LIST.Next);
      stmtfuncs    = mDECL_LIST (StmtFuncDecl, stmtfuncs);
    
  }
  }
   return NextList;
yyL1:;

  }
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind == kFORMAT_STMT) {
# line 621 "NormalDefs.puma"
  {
# line 625 "NormalDefs.puma"
 t->ACF_LIST.Next = ExtractStatementFunctions (t->ACF_LIST.Next); 
  }
   return t;

  }
  }
# line 630 "NormalDefs.puma"
   return t;

  }
  if (t->Kind == kACF_EMPTY) {
# line 637 "NormalDefs.puma"
   return t;

  }
 yyAbort ("ExtractStatementFunctions");
}

static bool IsStatementFunction
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 649 "NormalDefs.puma"
  {
# line 656 "NormalDefs.puma"
   if (! ((IsDummyArgNameList (t->INDEXED_VAR.IND_EXPS)))) goto yyL1;
  {
# line 657 "NormalDefs.puma"
   if (! ((NoIndexAllowed (GetGlobalObject (t->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident))))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  }
  return false;
}

static bool NoIndexAllowed
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 662 "NormalDefs.puma"
  {
# line 664 "NormalDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  }
   return true;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
# line 667 "NormalDefs.puma"
  {
# line 669 "NormalDefs.puma"
   if (! ((obj->VarObject.in == GetCurrentUnitObject ()))) goto yyL2;
  {
# line 671 "NormalDefs.puma"
   if (! ((VarRank (obj) == 0))) goto yyL2;
  {
# line 672 "NormalDefs.puma"
   if (! ((! IsStringType (GetObjectType (obj))))) goto yyL2;
  }
  }
  }
   return true;
yyL2:;

  }
  }
  return false;
}

static tTree MakeStmtFuncDecl
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
# line 684 "NormalDefs.puma"

   tObject OldObj, NewObj;
   tTree   ResType, Decl, Formals;

  if (var->Kind == kINDEXED_VAR) {
  if (var->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 689 "NormalDefs.puma"
  {
# line 691 "NormalDefs.puma"
 Formals = MakeStmtFuncFormals (var->INDEXED_VAR.IND_EXPS);

    OldObj = GetLocalObject (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);

    if (OldObj == NoObject)
       ResType = mDUMMY_TYPE ();
     else
       { if (OldObj->Object.decl->Kind != kVAR_DECL)
            printf ("Error in MakeStmtFuncDecl\n");
         ResType = CopyTree(OldObj->Object.decl->VAR_DECL.VAL);  
       }

    

    Decl   = mSTMT_FUNC_DECL (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Pos, Formals, ResType, exp);

    NewObj = mFuncObject (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, Decl, Default, NoObject,
                          UserRoutine, mENTRY_EMPTY ());

    if (OldObj != NoObject)
       ChangeEntry (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, NewObj);
     else
       InsertEntry (NewObj);
    
  }
   return Decl;

  }
  }
 yyAbort ("MakeStmtFuncDecl");
}

static tTree MakeStmtFuncFormals
# if defined __STDC__ | defined __cplusplus
(register tTree Parameters)
# else
(Parameters)
 register tTree Parameters;
# endif
{
  if (Parameters->Kind == kBTE_LIST) {
  if (Parameters->BTE_LIST.Elem->Kind == kVAR_EXP) {
  if (Parameters->BTE_LIST.Elem->VAR_EXP.V->Kind == kUSED_VAR) {
# line 726 "NormalDefs.puma"
 {
  tTree P;
  {
# line 728 "NormalDefs.puma"

# line 730 "NormalDefs.puma"
   P = mVAR_PARAM_DECL (Parameters->BTE_LIST.Elem->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident, Parameters->BTE_LIST.Elem->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Pos, mDUMMY_TYPE ());
  }
  {
   return mDECL_LIST (P, MakeStmtFuncFormals (Parameters->BTE_LIST.Next));
  }
 }

  }
  }
# line 735 "NormalDefs.puma"
  {
# line 739 "NormalDefs.puma"
   error_protocol ("Illegal Statement Function");
# line 740 "NormalDefs.puma"
   tree_protocol ("Not a legal parameter : ", Parameters->BTE_LIST.Elem);
  }
   return MakeStmtFuncFormals (Parameters->BTE_LIST.Next);

  }
  if (Parameters->Kind == kBTE_EMPTY) {
# line 744 "NormalDefs.puma"
   return mDECL_EMPTY ();

  }
 yyAbort ("MakeStmtFuncFormals");
}

static bool IsDummyArgName
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
# line 756 "NormalDefs.puma"
   return true;

  }
  return false;
}

static bool IsDummyArgNameList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_EMPTY) {
# line 763 "NormalDefs.puma"
   return true;

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kVAR_EXP) {
# line 766 "NormalDefs.puma"
  {
# line 767 "NormalDefs.puma"
   if (! ((IsDummyArgName (t->BTE_LIST.Elem->VAR_EXP.V)))) goto yyL2;
  {
# line 768 "NormalDefs.puma"
   if (! ((IsDummyArgNameList (t->BTE_LIST.Next)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  }
  return false;
}

static tTree MakeDataItems
# if defined __STDC__ | defined __cplusplus
(register tTree val)
# else
(val)
 register tTree val;
# endif
{
  if (val->Kind == kARRAY_EXP) {
# line 785 "NormalDefs.puma"
   return val->ARRAY_EXP.ELEMENTS;

  }
# line 790 "NormalDefs.puma"
   return mBTE_LIST (val, mBTE_EMPTY ());

}

void BeginNormalDefs ()
{
}

void CloseNormalDefs ()
{
}
