/*********************************************************************
*                                                                    *
*  Author      : Dr. Thomas Brandes, GMD, I1.LAB                     *
*  Date        : Mar 94                                              *
*  Last Update : Mar 94                                              *
*                                                                    *
*  Module      : MySource                                            *
*                                                                    *
*********************************************************************/

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include "ratc.h"
# include "global.h"
# include "MySource.h"
# include "SrcLines.h"

# undef DEBUG
# define is_EOF(x)  ((x == -1) || (x == 255))

int SourceFileErrors;   /* global error counter */

/*********************************************************************
*                                                                    *
*  ERROR HANDLING  for  Source Files                                 *
*                                                                    *
*********************************************************************/

void SourceError (msg)
char *msg;

{  fprintf (stderr, "Error : %s at line %d in file %s\n",
                     msg, CurrentSourceLine (), CurrentSourceName ());
   SourceFileErrors += 1;
}

/*********************************************************************
*                                                                    *
*  Data Structures needed for all Files                              *
*                                                                    *
*********************************************************************/

#define MAX_SOURCES 400   /* maximal names of different sources */

char *SourceFileNames [MAX_SOURCES];

int TopSourceFilePtr  = -1;

/* entries 0 <= i <= TopSourceFilePtr are valid names */

/*********************************************************************
*                                                                    *
*  Data Structures needed for Include Stack                          *
*                                                                    *
*********************************************************************/

#define MAX_INCLUDES 10   /* maximal nesting of include */

typedef struct {

   int SrcFilePtr;              /* pointer to SourceFileNames   */

   FILE *CharFile;              /* character file for scanner   */
   int  NoLine;                 /* current line                 */

   SourceLine ReadLine;         /* line that has already been read */

   int LastLine;                /* last considered line   */
   int LastColumn;              /* last considered column */
   int LastPos;                 /* last found position    */

} FileStackEntry;

FileStackEntry  IncludeFileStack  [MAX_INCLUDES];

int TopIncludeFilePtr = -1;

/* entries 0 <= i <= TopIncludeFilePtr are valid */

/*********************************************************************
*                                                                    *
*  Initialization before starting the Scanner                        *
*                                                                    *
*  - becomes necessary if parsing of a file is done twice            *
*                                                                    *
*********************************************************************/

void InitSource ()

{
  SourceFileErrors  = 0;
  TopIncludeFilePtr = -1; 
  TopSourceFilePtr  = -1;

} /* InitSource */

/*********************************************************************
*                                                                    *
*  Get information out of the top of Include Stack                   *
*                                                                    *
*********************************************************************/

int CurrentSourcePtr ()
{  if (TopIncludeFilePtr == -1)
      return -1;
   return IncludeFileStack[TopIncludeFilePtr].SrcFilePtr;
}

char *CurrentSourceName ()
{  if (TopIncludeFilePtr == -1)
      return "";     /* no file name if no file open for parsing */
    else
      return SourceFileNames [IncludeFileStack[TopIncludeFilePtr].SrcFilePtr];
}

int CurrentSourceLine ()
{  if (TopIncludeFilePtr == -1)
      return 0;     /* no file name if no file open for parsing */
    else
      return IncludeFileStack[TopIncludeFilePtr].NoLine;
}

/*********************************************************************
*                                                                    *
*  GetFilePtr returns a pointer in list of source file names         *
*                                                                    *
*********************************************************************/

char *GetSourceName (ptr)
int ptr;

{ if ((ptr < 0) || (ptr > TopSourceFilePtr))
      return "";     /* no file name for illegal pointer */
    else
      return SourceFileNames [ptr];
}

int GetFilePtr (name)
char * name;
{ int pos, found;
  pos = 0;
  found = 0;
  while ((pos <= TopSourceFilePtr) && (!found))
    { if (strcmp (name, SourceFileNames[pos]) == 0)
        { /* file name already exists */
          found = 1;
        }
       else
          pos++;
    }

  /* pos is pointer in array SourceFileNames */

  if (!found)
     { /* new entry required */
       TopSourceFilePtr += 1;
       pos = TopSourceFilePtr;
       if (pos == MAX_SOURCES)
         { fprintf (stderr, "INTERNAL ERROR: too many source files, max = %d\n",
                            MAX_SOURCES);
           exit(-1);
         }

       SourceFileNames [pos] = (char *) malloc (strlen (name) + 1);
       strcpy (SourceFileNames [pos], name);
     }

  /* printf ("GetFilePtr: %s has pointer = %d\n", name, pos); */

  return pos;

}  /* GetFilePtr */

/*******************************************************************
*                                                                  *
*   OpenSourceFile (FileName)                                      *
*                                                                  *
*     - input is name of the file                                  *
*     - many files can be used simultaneously                      *
*                                                                  *
*   CloseSourceFile (FileName)                                     *
*                                                                  *
*******************************************************************/

int OpenSourceFile (FileName)

   char *       FileName;

   { int src_ptr;
     FILE *f;
     int code;

     FileStackEntry *Descriptor;

     f = include_open (FileName);

     if (f == NULL)
       { fprintf (stderr, "ATTENTION: File %s could not be opened\n",
                  FileName);
         code = -1;
       }
      else
         code = 0;

     TopIncludeFilePtr += 1;

#ifdef DEBUG
     printf ("SourceFile %s will be opened, stack pos = %d\n",
              FileName, TopIncludeFilePtr);
#endif

     if (TopIncludeFilePtr == MAX_INCLUDES)
       { fprintf (stderr, "too deep nesting of includes, max = %d\n",
                          MAX_INCLUDES);
         exit(-1);
       }

     src_ptr = GetFilePtr (FileName);

#ifdef DEBUG
     printf ("Source File has global index = %d\n", src_ptr);
#endif

     Descriptor = IncludeFileStack + TopIncludeFilePtr;

     Descriptor->NoLine      = 1;
     Descriptor->SrcFilePtr  = src_ptr;
     Descriptor->CharFile    = f;
     Descriptor->LastLine    = 1;
     Descriptor->LastColumn  = 0;
     Descriptor->LastPos     = 0;

     Descriptor->ReadLine.counter = 0;

     return (code);

   }

void CloseSourceFile ()

   {  FileStackEntry *Descriptor;
      FILE *f;

      if (TopIncludeFilePtr < 0)
         { printf ("CloseSourceFile : no more file open\n");
           exit (-1);
         }

      Descriptor = IncludeFileStack + TopIncludeFilePtr;

#ifdef DEBUG
      printf ("source file %s will be closed\n",
              GetSourceName (Descriptor->SrcFilePtr));
#endif

      f = Descriptor->CharFile;

      if (f != NULL)
        { fclose (f);
        }

      TopIncludeFilePtr -= 1;

   }

/*********************************************************************
*                                                                    *
*  Exported Routines of Scanner 1                                    *
*                                                                    *
*  Attention: BeginSource and CloseSource must only be               *
*             called in a stack manner                               *
*                                                                    *
*             GetLine reads only from the current file               *
*                                                                    *
*********************************************************************/

int BeginSource (FileName)

char *FileName;

{

  OpenSourceFile (FileName);
  return (0);

}  /* BeginSource */

int GetLine (File, Buffer, Size)
   int          File;
   char *       Buffer;
   int          Size;

{  FileStackEntry *Descriptor;
   FILE *f;

   int no_chars;
   int new_lines;

   Descriptor = IncludeFileStack + TopIncludeFilePtr;

   f = Descriptor->CharFile;

   if (f == NULL)
      return (0);

   no_chars = GetCompleteLine (f, Buffer, Size,
                               &(Descriptor->ReadLine), &new_lines);

   if (LineError ())
      SourceError (LineErrorMsg ());

   Descriptor->NoLine += new_lines;

   return (no_chars);

} /* GetLine */

void CloseSource (File)
   int          File;

   {  

     CloseSourceFile ();

   }  /* CloseSource */

