# include "MoveDescriptor.h"
# include "yyMoveDescriptor.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 62 "MoveDescriptor.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Rank.h"
# include "AlignCheck.h"     /* GetSimpleAlignment */

# include "Descriptor.h"     /* MakeTemplateDescriptor */
# include "Expressions.h"    /* IsStride1              */
# include "HomeDescriptor.h"

# define MODULE "MoveDescriptor"

# undef DEBUG

/********************************************************************
*                                                                   *
*  IndexDifference (A1(..., l1:u1:s1, ...], A2(...,l2:u2:s2,...)    *
*                                                                   *
*  - tries to find an compile time constant for the difference      *
*    between the two index expressions                              *
*                                                                   *
*  - important : if index expressions are slices they must          *
*                have the same rank position                        *
*                                                                   *
********************************************************************/

static bool ActShapeIsSlice (vd, ind)

pvar vd;
int  ind;

/* returns true if actual index at position ind (1..act_rank) is slice */

{ if (vd->actual_shape[ind-1][0] != vd->actual_shape[ind-1][1])
     return (true);
  if (TreeRank (vd->actual_shape[ind-1][0]) > 0)
     return (true);
  return (false);

} /* ActShapeIsSlice */

/* help function : returns rank position of index

   0                       : if actual index is scalar
   1 <= val <= actual_rank : if actual index is slice

*/

static int IndexRankPos (vd, ind)

pvar vd;
int  ind;

{ int i, act_rank, pos_rank;;

  pos_rank = 0;
  act_rank = 0;

  for (i=0; i<vd->formal_rank; i++)

    { /* increase act_rank if slice */

      if (ActShapeIsSlice (vd, i+1))
         { act_rank ++;
           if (ind-1 == i)
              pos_rank = act_rank;
         }
    } /* for loop */

  if (act_rank != vd->actual_rank)
     { printf ("serious error for actual rank of array descriptor\n");
       PrintVarDescriptor (vd);
       printf ("index : %d, act_rank = %d, pos_rank = %d, \n",
               ind, act_rank, pos_rank);
       kill_in_protocol ();
     }

  return (pos_rank);

} /* IndexRankPos */



static void yyExit () { Exit (1); }

void (* MoveDescriptor_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MoveDescriptor, routine %s failed\n", yyFunction);
 MoveDescriptor_Exit ();
}

void PrintShifting ARGS((pshift s));
bool IsZeroShifting ARGS((pshift shift));
bool VDIsShifting ARGS((pvar d1, pvar d2, pshift sv));
bool VDIsSame ARGS((pvar d1, pvar d2));
bool VDIsSubSet ARGS((pvar vard1, pvar vard2));
void VDIsTopDimAligned ARGS((pvar vard1, pvar vard2, int top_dim, bool * yyP2, int * yyP1));
static void IndexDifference ARGS((pvar vard1, int idim1, pvar vard2, int idim2, bool * yyP4, int * yyP3));
bool VDIsSubTopDim ARGS((pvar vard1, pvar vard2, int top_dim));
static bool VDHasFullIndexDim ARGS((pvar vard, int index_dim));
static bool IsTheFormalRange ARGS((tTree actual, tTree formal));
bool VDIsAligned ARGS((pvar vard1, pvar vard2));
static bool VDFullAlignedDim ARGS((pvar vard1, pvar vard2, int top_dim));
static bool SameDistribution ARGS((pvar vard1, pvar vard2, int top_dim));
static bool SameDistributionKind ARGS((int kind1, int kind2));
static bool SameDistributionSize ARGS((tTree size1, tTree size2));

void PrintShifting
# if defined __STDC__ | defined __cplusplus
(pshift s)
# else
(s)
 pshift s;
# endif
{
# line 158 "MoveDescriptor.puma"
 {
  int i;
  {
# line 160 "MoveDescriptor.puma"

# line 161 "MoveDescriptor.puma"
 printf ("Shifting, rank = %d, pos = [", s->shift_rank);
     for (i=0; i<s->shift_rank; i++)
         printf (" %d", s->shift_pos[i]);
     printf (" ]\n");
   
  }
   return;
 }

;
}

bool IsZeroShifting
# if defined __STDC__ | defined __cplusplus
(pshift shift)
# else
(shift)
 pshift shift;
# endif
{
# line 176 "MoveDescriptor.puma"
 {
  bool okay;
  int i;
  int n;
  {
# line 178 "MoveDescriptor.puma"

# line 180 "MoveDescriptor.puma"

# line 181 "MoveDescriptor.puma"

# line 183 "MoveDescriptor.puma"
 okay = true;
    n = shift->shift_rank;
    for (i=0; i<n; i++)
       okay = okay && (shift->shift_pos[i] == 0);
  
# line 189 "MoveDescriptor.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

bool VDIsShifting
# if defined __STDC__ | defined __cplusplus
(pvar d1, pvar d2, pshift sv)
# else
(d1, d2, sv)
 pvar d1;
 pvar d2;
 pshift sv;
# endif
{
# line 210 "MoveDescriptor.puma"
 {
  int top_rank;
  int top_dim;
  bool found;
  {
# line 220 "MoveDescriptor.puma"
   if (! ((SameDescriptorTopology (d1, d2)))) goto yyL1;
  {
# line 224 "MoveDescriptor.puma"
   MakeTemplateDescriptor (d1);
# line 225 "MoveDescriptor.puma"
   MakeTemplateDescriptor (d2);
# line 227 "MoveDescriptor.puma"

# line 228 "MoveDescriptor.puma"

# line 229 "MoveDescriptor.puma"

# line 233 "MoveDescriptor.puma"
 found = true;
 
    sv->shift_rank = d2->formal_rank;

    for (top_dim = 0; top_dim < sv->shift_rank; top_dim++)
       sv->shift_pos [top_dim] = 0;

    top_rank = d2->topology_rank;

    for (top_dim = 0; top_dim < top_rank; top_dim++)

      { int  val;
        bool ok;

        VDIsTopDimAligned (d1, d2, top_dim+1, &ok, &val);

#ifdef DEBUG
        printf ("top dim align of top_dim = %d returns ok = %d, val = %d\n",
                 top_dim, ok, val);
#endif
 
        

        if (ok && (val != 0))

           { int ind2;

             ind2 = d2->on_index_dim[top_dim];

             switch (d2->distribution_kind[ind2-1]) {

             case kBLOCK_DIM         :  sv->shift_pos[ind2-1] = val; break;
             case kGEN_BLOCK_DIM     :  sv->shift_pos[ind2-1] = val; break;
             case kANY_GEN_BLOCK_DIM :  sv->shift_pos[ind2-1] = val; break;
             case kANY_BLOCK_DIM     :  sv->shift_pos[ind2-1] = val; break;

             default : ok = false;

             } 

           }

        found = found && ok;                
      }
 
  
# line 280 "MoveDescriptor.puma"
   if (! ((found))) goto yyL1;
  }
  }
   return true;
 }
yyL1:;

  return false;
}

bool VDIsSame
# if defined __STDC__ | defined __cplusplus
(pvar d1, pvar d2)
# else
(d1, d2)
 pvar d1;
 pvar d2;
# endif
{
# line 291 "MoveDescriptor.puma"
  {
# line 293 "MoveDescriptor.puma"
   if (! ((VDIsSubSet (d1, d2)))) goto yyL1;
  {
# line 294 "MoveDescriptor.puma"
   if (! ((VDIsSubSet (d2, d1)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  return false;
}

bool VDIsSubSet
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2)
# else
(vard1, vard2)
 pvar vard1;
 pvar vard2;
# endif
{
# line 310 "MoveDescriptor.puma"
  {
# line 313 "MoveDescriptor.puma"
   if (! ((IsReplicatedDescriptor (vard2)))) goto yyL1;
  }
   return true;
yyL1:;

# line 316 "MoveDescriptor.puma"
  {
# line 318 "MoveDescriptor.puma"
   if (! ((IsNoDescriptor (vard1)))) goto yyL2;
  }
   return true;
yyL2:;

# line 321 "MoveDescriptor.puma"
  {
# line 323 "MoveDescriptor.puma"
   if (! ((IsNoDescriptor (vard2)))) goto yyL3;
  {
# line 325 "MoveDescriptor.puma"
   return false;
  }
  }
yyL3:;

# line 328 "MoveDescriptor.puma"
 {
  bool okay;
  int dim;
  int rank;
  {
# line 330 "MoveDescriptor.puma"
   if (! ((SameDescriptorTopology (vard1, vard2)))) goto yyL4;
  {
# line 334 "MoveDescriptor.puma"
   MakeTemplateDescriptor (vard1);
# line 335 "MoveDescriptor.puma"
   MakeTemplateDescriptor (vard2);
# line 337 "MoveDescriptor.puma"

# line 338 "MoveDescriptor.puma"

# line 339 "MoveDescriptor.puma"

# line 341 "MoveDescriptor.puma"
 okay = true;

#ifdef DEBUG
     printf ("VDIsSubset vard1 of vard2\n");
     PrintVarDescriptor (vard1);
     PrintVarDescriptor (vard2);
#endif

     rank = vard1->topology_rank;

     if (vard1->topology_obj != NoObject)

       { if (rank != VarRank (vard1->topology_obj))

           { printf ("vard->rank = %d, vard->topology = %d (rank = %d)\n",
             rank, vard1->topology_obj, VarRank (vard1->topology_obj));
             obj_protocol ("illegal topolgy : ", vard1->topology_obj);
             failure_protocol (MODULE, "VDIsSubset", NoTree);
           }
       };

     for (dim = 1; dim <= rank; dim ++)

      { 

        okay = okay && VDIsSubTopDim (vard1, vard2, dim);

      }

#ifdef DEBUG
      printf ("is subset = %d\n", okay);
#endif

   
# line 376 "MoveDescriptor.puma"
   if (! ((okay))) goto yyL4;
  }
  }
   return true;
 }
yyL4:;

  return false;
}

void VDIsTopDimAligned
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2, register int top_dim, register bool * yyP2, register int * yyP1)
# else
(vard1, vard2, top_dim, yyP2, yyP1)
 pvar vard1;
 pvar vard2;
 register int top_dim;
 register bool * yyP2;
 register int * yyP1;
# endif
{
# line 393 "MoveDescriptor.puma"
  {
# line 397 "MoveDescriptor.puma"
   if (! ((vard2 -> on_index_dim [top_dim - 1] == 0))) goto yyL1;
  }
   * yyP2 = true;
   * yyP1 = 0;
   return;
yyL1:;

# line 400 "MoveDescriptor.puma"
 {
  int idim2;
  {
# line 402 "MoveDescriptor.puma"

# line 404 "MoveDescriptor.puma"
   idim2 = vard2 -> on_index_dim [top_dim - 1];
# line 406 "MoveDescriptor.puma"
   if (! (VDHasFullIndexDim (vard2, idim2))) goto yyL2;
  }
   * yyP2 = true;
   * yyP1 = 0;
   return;
 }
yyL2:;

# line 409 "MoveDescriptor.puma"
 {
  int idim1;
  int idim2;
  bool yyV1;
  int yyV2;
  {
# line 411 "MoveDescriptor.puma"
   if (! ((vard1 -> on_kind [top_dim - 1] == vard2 -> on_kind [top_dim - 1]))) goto yyL3;
  {
# line 413 "MoveDescriptor.puma"

# line 414 "MoveDescriptor.puma"

# line 416 "MoveDescriptor.puma"
   idim1 = vard1 -> on_index_dim [top_dim - 1];
# line 417 "MoveDescriptor.puma"
   idim2 = vard2 -> on_index_dim [top_dim - 1];
# line 419 "MoveDescriptor.puma"
   if (! ((idim1 > 0))) goto yyL3;
  {
# line 420 "MoveDescriptor.puma"
   if (! ((idim2 > 0))) goto yyL3;
  {
# line 422 "MoveDescriptor.puma"
   IndexDifference (vard1, idim1, vard2, idim2, & yyV1, & yyV2);
  }
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL3:;

# line 425 "MoveDescriptor.puma"
   * yyP2 = false;
   * yyP1 = 0;
   return;

;
}

static void IndexDifference
# if defined __STDC__ | defined __cplusplus
(pvar vard1, register int idim1, pvar vard2, register int idim2, register bool * yyP4, register int * yyP3)
# else
(vard1, idim1, vard2, idim2, yyP4, yyP3)
 pvar vard1;
 register int idim1;
 pvar vard2;
 register int idim2;
 register bool * yyP4;
 register int * yyP3;
# endif
{
# line 431 "MoveDescriptor.puma"
 {
  bool found;
  int val;
  {
# line 433 "MoveDescriptor.puma"
   if (! ((IndexRankPos (vard1, idim1) == IndexRankPos (vard2, idim2)))) goto yyL1;
  {
# line 435 "MoveDescriptor.puma"

# line 436 "MoveDescriptor.puma"

# line 438 "MoveDescriptor.puma"
   GetSimpleAlignment (vard1, idim1, vard2, idim2, & found, & val);
  }
  }
   * yyP4 = found;
   * yyP3 = val;
   return;
 }
yyL1:;

# line 441 "MoveDescriptor.puma"
   * yyP4 = false;
   * yyP3 = 0;
   return;

;
}

bool VDIsSubTopDim
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2, register int top_dim)
# else
(vard1, vard2, top_dim)
 pvar vard1;
 pvar vard2;
 register int top_dim;
# endif
{
# line 452 "MoveDescriptor.puma"
  {
# line 454 "MoveDescriptor.puma"
   if (! ((vard2 -> on_index_dim [top_dim - 1] == 0))) goto yyL1;
  }
   return true;
yyL1:;

# line 457 "MoveDescriptor.puma"
 {
  int idim2;
  {
# line 459 "MoveDescriptor.puma"

# line 461 "MoveDescriptor.puma"
   idim2 = vard2 -> on_index_dim [top_dim - 1];
# line 463 "MoveDescriptor.puma"
   if (! (VDHasFullIndexDim (vard2, idim2))) goto yyL2;
  }
   return true;
 }
yyL2:;

# line 466 "MoveDescriptor.puma"
 {
  int idim1;
  int idim2;
  bool found;
  int val;
  {
# line 468 "MoveDescriptor.puma"
   if (! ((vard1 -> on_kind [top_dim - 1] == vard2 -> on_kind [top_dim - 1]))) goto yyL3;
  {
# line 470 "MoveDescriptor.puma"

# line 471 "MoveDescriptor.puma"

# line 473 "MoveDescriptor.puma"
   idim1 = vard1 -> on_index_dim [top_dim - 1];
# line 474 "MoveDescriptor.puma"
   idim2 = vard2 -> on_index_dim [top_dim - 1];
# line 476 "MoveDescriptor.puma"
   if (! ((idim1 > 0))) goto yyL3;
  {
# line 477 "MoveDescriptor.puma"
   if (! ((idim2 > 0))) goto yyL3;
  {
# line 479 "MoveDescriptor.puma"

# line 480 "MoveDescriptor.puma"

# line 482 "MoveDescriptor.puma"
   GetSimpleAlignment (vard1, idim1, vard2, idim2, & found, & val);
# line 484 "MoveDescriptor.puma"
   if (! ((found))) goto yyL3;
  {
# line 485 "MoveDescriptor.puma"
   if (! ((val == 0))) goto yyL3;
  }
  }
  }
  }
  }
   return true;
 }
yyL3:;

  return false;
}

static bool VDHasFullIndexDim
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int index_dim)
# else
(vard, index_dim)
 pvar vard;
 register int index_dim;
# endif
{
# line 496 "MoveDescriptor.puma"
 {
  bool okay;
  {
# line 500 "MoveDescriptor.puma"

# line 502 "MoveDescriptor.puma"
 tTree a_lb, a_ub, a_inc;
     tTree f_lb, f_ub, f_inc;

     a_lb  = vard->actual_shape[index_dim-1][0];
     a_ub  = vard->actual_shape[index_dim-1][1];
     a_inc = vard->actual_shape[index_dim-1][2];

     f_lb  = vard->formal_shape[index_dim-1][0];
     f_ub  = vard->formal_shape[index_dim-1][1];

     okay = IsTheFormalRange (a_lb, f_lb) &&
            IsTheFormalRange (a_ub, f_ub) &&
            IsStride1 (a_inc);

   
# line 518 "MoveDescriptor.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool IsTheFormalRange
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree formal)
# else
(actual, formal)
 register tTree actual;
 register tTree formal;
# endif
{
# line 544 "MoveDescriptor.puma"
  {
# line 546 "MoveDescriptor.puma"
   if (! ((formal == NoTree))) goto yyL1;
  {
# line 548 "MoveDescriptor.puma"
   return false;
  }
  }
yyL1:;

# line 551 "MoveDescriptor.puma"
  {
# line 553 "MoveDescriptor.puma"
   if (! ((actual == NoTree))) goto yyL2;
  }
   return true;
yyL2:;

  if (actual->Kind == kDUMMY_EXP) {
# line 556 "MoveDescriptor.puma"
   return true;

  }
# line 559 "MoveDescriptor.puma"
  {
# line 561 "MoveDescriptor.puma"
   if (! ((EqualExpression (actual, formal)))) goto yyL4;
  }
   return true;
yyL4:;

  return false;
}

bool VDIsAligned
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2)
# else
(vard1, vard2)
 pvar vard1;
 pvar vard2;
# endif
{
# line 581 "MoveDescriptor.puma"
  {
# line 583 "MoveDescriptor.puma"
   if (! ((IsReplicatedDescriptor (vard1)))) goto yyL1;
  {
# line 584 "MoveDescriptor.puma"
   if (! ((IsReplicatedDescriptor (vard2)))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 587 "MoveDescriptor.puma"
  {
# line 589 "MoveDescriptor.puma"
   if (! ((IsHostDescriptor (vard1)))) goto yyL2;
  {
# line 590 "MoveDescriptor.puma"
   if (! ((IsHostDescriptor (vard2)))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 593 "MoveDescriptor.puma"
 {
  bool okay;
  int dim;
  {
# line 595 "MoveDescriptor.puma"
   if (! ((SameDescriptorTopology (vard1, vard2)))) goto yyL3;
  {
# line 601 "MoveDescriptor.puma"
   MakeTemplateDescriptor (vard1);
# line 602 "MoveDescriptor.puma"
   MakeTemplateDescriptor (vard2);
# line 604 "MoveDescriptor.puma"

# line 605 "MoveDescriptor.puma"

# line 607 "MoveDescriptor.puma"
 okay = true;

     for (dim = 1; dim <= vard1->topology_rank; dim ++)

      { 

        okay = okay && VDFullAlignedDim (vard1, vard2, dim);

      }

   
# line 619 "MoveDescriptor.puma"
   if (! ((okay))) goto yyL3;
  }
  }
   return true;
 }
yyL3:;

  return false;
}

static bool VDFullAlignedDim
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2, register int top_dim)
# else
(vard1, vard2, top_dim)
 pvar vard1;
 pvar vard2;
 register int top_dim;
# endif
{
# line 624 "MoveDescriptor.puma"
  {
# line 628 "MoveDescriptor.puma"
   if (! ((vard1 -> on_val [top_dim - 1] == NoTree))) goto yyL1;
  {
# line 629 "MoveDescriptor.puma"
   if (! ((vard2 -> on_val [top_dim - 1] == NoTree))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 632 "MoveDescriptor.puma"
 {
  int idim1;
  int idim2;
  bool yyV1;
  int yyV2;
  {
# line 634 "MoveDescriptor.puma"
   if (! ((SameDistribution (vard1, vard2, top_dim)))) goto yyL2;
  {
# line 636 "MoveDescriptor.puma"

# line 637 "MoveDescriptor.puma"

# line 639 "MoveDescriptor.puma"
   idim1 = vard1 -> on_index_dim [top_dim - 1];
# line 640 "MoveDescriptor.puma"
   idim2 = vard2 -> on_index_dim [top_dim - 1];
# line 642 "MoveDescriptor.puma"
   if (! ((idim1 > 0))) goto yyL2;
  {
# line 643 "MoveDescriptor.puma"
   if (! ((idim2 > 0))) goto yyL2;
  {
# line 645 "MoveDescriptor.puma"
   IndexDifference (vard1, idim1, vard2, idim2, & yyV1, & yyV2);
# line 647 "MoveDescriptor.puma"
   if (! ((yyV1))) goto yyL2;
  {
# line 648 "MoveDescriptor.puma"
   if (! ((yyV2 == 0))) goto yyL2;
  }
  }
  }
  }
  }
   return true;
 }
yyL2:;

  return false;
}

static bool SameDistribution
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2, register int top_dim)
# else
(vard1, vard2, top_dim)
 pvar vard1;
 pvar vard2;
 register int top_dim;
# endif
{
# line 659 "MoveDescriptor.puma"
  {
# line 661 "MoveDescriptor.puma"
   if (! ((vard1 -> template_obj == vard2 -> template_obj))) goto yyL1;
  {
# line 662 "MoveDescriptor.puma"
   if (! ((vard1 -> template_obj != NoObject))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 665 "MoveDescriptor.puma"
  {
# line 667 "MoveDescriptor.puma"
   if (! ((vard1 -> topology_obj == vard2 -> topology_obj))) goto yyL2;
  {
# line 668 "MoveDescriptor.puma"
   if (! ((vard1 -> topology_obj != NoObject))) goto yyL2;
  {
# line 670 "MoveDescriptor.puma"
   if (! ((SameDistributionKind (vard1 -> on_kind [top_dim - 1], vard2 -> on_kind [top_dim - 1])))) goto yyL2;
  {
# line 673 "MoveDescriptor.puma"
   if (! ((SameDistributionSize (vard1 -> on_size [top_dim - 1], vard2 -> on_size [top_dim - 1])))) goto yyL2;
  }
  }
  }
  }
   return true;
yyL2:;

  return false;
}

static bool SameDistributionKind
# if defined __STDC__ | defined __cplusplus
(register int kind1, register int kind2)
# else
(kind1, kind2)
 register int kind1;
 register int kind2;
# endif
{
# line 687 "MoveDescriptor.puma"
  {
# line 689 "MoveDescriptor.puma"
   if (! ((kind1 == kBLOCK_DIM))) goto yyL1;
  {
# line 690 "MoveDescriptor.puma"
   if (! ((kind2 == kBLOCK_DIM))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 693 "MoveDescriptor.puma"
  {
# line 695 "MoveDescriptor.puma"
   if (! ((kind1 == kCYCLIC_DIM))) goto yyL2;
  {
# line 696 "MoveDescriptor.puma"
   if (! ((kind2 == kCYCLIC_DIM))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 699 "MoveDescriptor.puma"
  {
# line 701 "MoveDescriptor.puma"
   if (! ((kind1 == kGEN_BLOCK_DIM))) goto yyL3;
  {
# line 702 "MoveDescriptor.puma"
   if (! ((kind2 == kGEN_BLOCK_DIM))) goto yyL3;
  }
  }
   return true;
yyL3:;

# line 705 "MoveDescriptor.puma"
  {
# line 707 "MoveDescriptor.puma"
   if (! ((kind1 == kINDIRECT_DIM))) goto yyL4;
  {
# line 708 "MoveDescriptor.puma"
   if (! ((kind2 == kINDIRECT_DIM))) goto yyL4;
  }
  }
   return true;
yyL4:;

  return false;
}

static bool SameDistributionSize
# if defined __STDC__ | defined __cplusplus
(register tTree size1, register tTree size2)
# else
(size1, size2)
 register tTree size1;
 register tTree size2;
# endif
{
# line 721 "MoveDescriptor.puma"
  {
# line 723 "MoveDescriptor.puma"
   if (! ((size1 == NoTree))) goto yyL1;
  {
# line 724 "MoveDescriptor.puma"
   if (! ((size2 == NoTree))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 727 "MoveDescriptor.puma"
  {
# line 729 "MoveDescriptor.puma"
   if (! ((size1 != NoTree))) goto yyL2;
  {
# line 730 "MoveDescriptor.puma"
   if (! ((size2 != NoTree))) goto yyL2;
  {
# line 731 "MoveDescriptor.puma"
   if (! ((EqualExpression (size1, size2)))) goto yyL2;
  }
  }
  }
   return true;
yyL2:;

  return false;
}

void BeginMoveDescriptor ()
{
}

void CloseMoveDescriptor ()
{
}
