# include "MoveControl.h"
# include "yyMoveControl.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 94 "MoveControl.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
# include "Types.h"
# include "Distributions.h"

# include "DefTable.h"

# include "Expressions.h"    /* AddConstant        */
# include "Types.h"          /* ArrayFormals       */

# include "AlignCheck.h"     /* GetSimpleAlignment */
# include "Nesting.h"        /* GetCurrentUnit     */

# include "Descriptor.h"
# include "MoveDescriptor.h"  /*  VDIsShifting, pshift */
# include "HomeDescriptor.h"  /*  VDIsShifting, pshift */
# include "Objects.h"
# include "Rank.h"
# include "protocol.h"

# define MODULE "MoveControl"

# undef DEBUG



static void yyExit () { Exit (1); }

void (* MoveControl_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MoveControl, routine %s failed\n", yyFunction);
 MoveControl_Exit ();
}

static bool EnoughVDOverlapArea ARGS((pvar vard, pshift pv));
bool VDHasLocalCopy ARGS((pvar home, pvar var));
bool VDIsOwner ARGS((pvar home, pvar var));
bool VDIsSingleOwner ARGS((pvar home, pvar var));
int CountCommunication ARGS((pvar home, tTree exp));
static int CountVarIndexCommunication ARGS((pvar home, tTree var));
int CountMovements ARGS((tTree var, tTree exp));
static int CountSpreadMovements ARGS((tTree var, tTree params));
static int CountSpreadVarMovements ARGS((tTree var, tTree array, int dim));
bool SpreadAligned ARGS((tTree var, tTree maj_var, int dim));
void GetMajorityVar ARGS((tTree exp, int * flag, tTree * var));
void GetMajorityVar2 ARGS((tTree exp1, tTree exp2, int * yyP2, tTree * yyP1));
static void MergeMajorityVars ARGS((int yyP6, tTree yyP5, int yyP4, tTree yyP3, int * yyP8, tTree * yyP7));
static bool HigherRank ARGS((tTree var1, tTree var2));
int CountVarMovements ARGS((tTree var, tTree var1));
static bool IsLocalAssignment ARGS((tTree lvar, int lvardist, tTree rvar, int rvardist));
bool VDIsLocalAssignment ARGS((pvar lvar, pvar rvar));
static bool ReplicatedIndexes ARGS((tTree var));
void GetShifting ARGS((tTree lvar, tTree rvar, bool * yyP10, shift_vector * yyP9));
void GetCircularShifting ARGS((tTree exp, bool * yyP13, tTree * yyP12, shift_vector * yyP11));
static void ResolveCShiftParams ARGS((tTree params, tTree * yyP16, int * yyP15, int * yyP14));
static void FindVarShift ARGS((tTree var, bool * yyP19, tTree * yyP18, shift_vector * yyP17));
static bool AreDimsShiftable ARGS((tTree var, pshift sv));
static bool ActualEqFormal ARGS((tTree formal_exp, tTree actual_exp));
static int GetIndexPosition ARGS((tTree indexes, int dim));
bool EnoughOverlapArea ARGS((tTree var, pshift pos));
static bool IsEnoughVarOverlap ARGS((tTree indexes, int dim, pshift pos));
static bool SufficientOverlapIndex ARGS((tTree index, int pos));
bool SameDistribution ARGS((tDefinitions actual, tDefinitions formal));
static bool SameDescriptorDistribution ARGS((pvar vard1, pvar vard2));
static void FindLegalVarDescriptor ARGS((tTree var, bool * yyP21, var_descriptor * yyP20));

static bool EnoughVDOverlapArea
# if defined __STDC__ | defined __cplusplus
(pvar vard, pshift pv)
# else
(vard, pv)
 pvar vard;
 pshift pv;
# endif
{
# line 134 "MoveControl.puma"
  {
# line 136 "MoveControl.puma"
   if (! ((IsZeroShifting (pv)))) goto yyL1;
  }
   return true;
yyL1:;

# line 139 "MoveControl.puma"
  {
# line 141 "MoveControl.puma"
   if (! ((vard -> var_tree != NoTree))) goto yyL2;
  {
# line 142 "MoveControl.puma"
   if (! ((EnoughOverlapArea (vard -> var_tree, pv)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  return false;
}

bool VDHasLocalCopy
# if defined __STDC__ | defined __cplusplus
(pvar home, pvar var)
# else
(home, var)
 pvar home;
 pvar var;
# endif
{
# line 162 "MoveControl.puma"
  {
# line 164 "MoveControl.puma"
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return true;
yyL1:;

# line 167 "MoveControl.puma"
  {
# line 169 "MoveControl.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  }
   return true;
yyL2:;

# line 172 "MoveControl.puma"
  {
# line 176 "MoveControl.puma"
   if (! ((var -> topology_obj == GetDefaultTopology (0)))) goto yyL3;
  }
   return true;
yyL3:;

# line 179 "MoveControl.puma"
  {
# line 183 "MoveControl.puma"
   if (! ((var -> shared == 1))) goto yyL4;
  }
   return true;
yyL4:;

# line 186 "MoveControl.puma"
 {
  shift_vector pv;
  {
# line 188 "MoveControl.puma"
   if (! ((home -> topology_rank > 0))) goto yyL5;
  {
# line 189 "MoveControl.puma"
   if (! ((var -> topology_rank > 0))) goto yyL5;
  {
# line 191 "MoveControl.puma"

# line 193 "MoveControl.puma"
   if (! ((VDIsShifting (home, var, & pv)))) goto yyL5;
  {
# line 195 "MoveControl.puma"

#ifdef DEBUG
   print_shift ("VDShifting found", &pv);
#endif
   
# line 201 "MoveControl.puma"
   if (! (EnoughVDOverlapArea (var, & pv))) goto yyL5;
  }
  }
  }
  }
   return true;
 }
yyL5:;

  return false;
}

bool VDIsOwner
# if defined __STDC__ | defined __cplusplus
(pvar home, pvar var)
# else
(home, var)
 pvar home;
 pvar var;
# endif
{
# line 220 "MoveControl.puma"
  {
# line 222 "MoveControl.puma"
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return true;
yyL1:;

# line 225 "MoveControl.puma"
  {
# line 227 "MoveControl.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  }
   return true;
yyL2:;

# line 230 "MoveControl.puma"
  {
# line 234 "MoveControl.puma"
   if (! ((var -> topology_obj == GetDefaultTopology (0)))) goto yyL3;
  }
   return true;
yyL3:;

# line 237 "MoveControl.puma"
  {
# line 241 "MoveControl.puma"
   if (! ((var -> shared == 1))) goto yyL4;
  }
   return true;
yyL4:;

# line 244 "MoveControl.puma"
  {
# line 246 "MoveControl.puma"
   if (! ((home -> topology_rank == - 1))) goto yyL5;
  {
# line 247 "MoveControl.puma"
   if (! ((var -> topology_rank == - 1))) goto yyL5;
  }
  }
   return true;
yyL5:;

# line 250 "MoveControl.puma"
 {
  shift_vector pv;
  {
# line 252 "MoveControl.puma"
   if (! ((home -> topology_rank > 0))) goto yyL6;
  {
# line 253 "MoveControl.puma"
   if (! ((var -> topology_rank > 0))) goto yyL6;
  {
# line 255 "MoveControl.puma"

# line 257 "MoveControl.puma"
   if (! ((VDIsShifting (home, var, & pv)))) goto yyL6;
  {
# line 258 "MoveControl.puma"
   if (! ((IsZeroShifting (& pv)))) goto yyL6;
  }
  }
  }
  }
   return true;
 }
yyL6:;

  return false;
}

bool VDIsSingleOwner
# if defined __STDC__ | defined __cplusplus
(pvar home, pvar var)
# else
(home, var)
 pvar home;
 pvar var;
# endif
{
# line 276 "MoveControl.puma"
  {
# line 278 "MoveControl.puma"
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return true;
yyL1:;

# line 281 "MoveControl.puma"
  {
# line 283 "MoveControl.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  }
   return true;
yyL2:;

# line 286 "MoveControl.puma"
  {
# line 288 "MoveControl.puma"
   if (! ((home -> topology_obj == GetDefaultTopology (0)))) goto yyL3;
  {
# line 289 "MoveControl.puma"
   if (! ((var -> topology_obj == GetDefaultTopology (0)))) goto yyL3;
  }
  }
   return true;
yyL3:;

# line 292 "MoveControl.puma"
  {
# line 296 "MoveControl.puma"
   if (! ((var -> shared == 1))) goto yyL4;
  {
# line 297 "MoveControl.puma"
   if (! ((IsSerialDescriptor (home)))) goto yyL4;
  }
  }
   return true;
yyL4:;

# line 300 "MoveControl.puma"
 {
  shift_vector pv;
  {
# line 302 "MoveControl.puma"
   if (! ((home -> topology_rank > 0))) goto yyL5;
  {
# line 303 "MoveControl.puma"
   if (! ((var -> topology_rank > 0))) goto yyL5;
  {
# line 305 "MoveControl.puma"

# line 307 "MoveControl.puma"
   if (! ((VDIsShifting (home, var, & pv)))) goto yyL5;
  {
# line 308 "MoveControl.puma"
   if (! ((IsZeroShifting (& pv)))) goto yyL5;
  {
# line 309 "MoveControl.puma"
   if (! ((VDIsShifting (var, home, & pv)))) goto yyL5;
  {
# line 310 "MoveControl.puma"
   if (! ((IsZeroShifting (& pv)))) goto yyL5;
  }
  }
  }
  }
  }
  }
   return true;
 }
yyL5:;

  return false;
}

int CountCommunication
# if defined __STDC__ | defined __cplusplus
(pvar home, register tTree exp)
# else
(home, exp)
 pvar home;
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kADDR:
# line 323 "MoveControl.puma"
   return CountCommunication (home, exp->ADDR.E);

  case kBT_VAR:
  case kDUMMY_VAR:
  case kUSED_VAR:
  case kINDEXED_VAR:
  case kSUBSTRING_VAR:
  case kSELECTED_VAR:
  case kLOOP_VAR:
  case kPERM_VAR:
  case kDO_VAR:
  case kREMOTE_VAR:
# line 328 "MoveControl.puma"
 {
  var_descriptor vard;
  {
# line 330 "MoveControl.puma"

# line 332 "MoveControl.puma"
   SetVarDescriptor (exp, & vard);
# line 334 "MoveControl.puma"
   if (! ((VDHasLocalCopy (home, & vard)))) goto yyL2;
  }
  {
   return CountVarIndexCommunication (home, exp);
  }
 }
yyL2:;

# line 339 "MoveControl.puma"
   return 1 + CountVarIndexCommunication (home, exp);

  case kDUMMY_EXP:
# line 346 "MoveControl.puma"
   return 0;

  case kCONST_EXP:
# line 351 "MoveControl.puma"
   return 0;

  case kBOUND_EXP:
# line 356 "MoveControl.puma"
   return 0;

  case kRANK_EXP:
# line 361 "MoveControl.puma"
   return 0;

  case kARRAY_EXP:
# line 366 "MoveControl.puma"
   return CountCommunication (home, exp->ARRAY_EXP.ELEMENTS);

  case kTYPE_EXP:
# line 371 "MoveControl.puma"
   return CountCommunication (home, exp->TYPE_EXP.ELEMENTS);

  case kDO_EXP:
# line 376 "MoveControl.puma"
   return CountCommunication (home, exp->DO_EXP.RANGE) + CountCommunication (home, exp->DO_EXP.BODY);

  case kSLICE_EXP:
# line 381 "MoveControl.puma"
   return CountCommunication (home, exp->SLICE_EXP.START) + CountCommunication (home, exp->SLICE_EXP.STOP) + CountCommunication (home, exp->SLICE_EXP.INC);

  case kOP_EXP:
# line 388 "MoveControl.puma"
   return CountCommunication (home, exp->OP_EXP.OPND1) + CountCommunication (home, exp->OP_EXP.OPND2);

  case kOP1_EXP:
# line 393 "MoveControl.puma"
   return CountCommunication (home, exp->OP1_EXP.OPND);

  case kPERM_EXP:
# line 398 "MoveControl.puma"
   return CountCommunication (home, exp->PERM_EXP.VAL) + 1;

  case kVAR_EXP:
# line 403 "MoveControl.puma"
   return CountCommunication (home, exp->VAR_EXP.V);

  case kFUNC_CALL_EXP:
# line 408 "MoveControl.puma"
   return CountCommunication (home, exp->FUNC_CALL_EXP.FUNC_PARAMS);

  case kBTE_LIST:
# line 413 "MoveControl.puma"
   return CountCommunication (home, exp->BTE_LIST.Elem) + CountCommunication (home, exp->BTE_LIST.Next);

  case kBTE_EMPTY:
# line 418 "MoveControl.puma"
   return 0;

  case kBTP_LIST:
# line 423 "MoveControl.puma"
   return CountCommunication (home, exp->BTP_LIST.Elem) + CountCommunication (home, exp->BTP_LIST.Next);

  case kBTP_EMPTY:
# line 428 "MoveControl.puma"
   return 0;

  case kVAR_PARAM:
# line 433 "MoveControl.puma"
   return CountCommunication (home, exp->VAR_PARAM.V);

  case kNO_PARAM:
# line 438 "MoveControl.puma"
   return 0;

  case kFUNC_PARAM:
# line 443 "MoveControl.puma"
   return 0;

  case kPROC_PARAM:
# line 448 "MoveControl.puma"
   return 0;

  }

# line 458 "MoveControl.puma"
  {
# line 460 "MoveControl.puma"
   failure_protocol (MODULE, "CountCommunication (exp)", exp);
  }
   return 0;

}

static int CountVarIndexCommunication
# if defined __STDC__ | defined __cplusplus
(pvar home, register tTree var)
# else
(home, var)
 pvar home;
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 471 "MoveControl.puma"
   return CountVarIndexCommunication (home, var->INDEXED_VAR.IND_VAR) + CountCommunication (home, var->INDEXED_VAR.IND_EXPS);

  }
  if (var->Kind == kSUBSTRING_VAR) {
# line 477 "MoveControl.puma"
   return CountVarIndexCommunication (home, var->SUBSTRING_VAR.IND_VAR) + CountCommunication (home, var->SUBSTRING_VAR.IND_EXP);

  }
  if (var->Kind == kSELECTED_VAR) {
# line 483 "MoveControl.puma"
   return CountVarIndexCommunication (home, var->SELECTED_VAR.SELEC_VAR);

  }
# line 488 "MoveControl.puma"
   return 0;

}

int CountMovements
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
  if (Tree_IsType (exp, kBT_VAR)) {
# line 516 "MoveControl.puma"
   return CountVarMovements (var, exp);

  }
# line 520 "MoveControl.puma"
  {
# line 521 "MoveControl.puma"
   if (! ((TreeWriteDistribution (var) == - 2))) goto yyL2;
  }
   return 1;
yyL2:;


  switch (exp->Kind) {
  case kADDR:
# line 525 "MoveControl.puma"
   return CountMovements (var, exp->ADDR.E);

  case kDUMMY_EXP:
# line 529 "MoveControl.puma"
   return 0;

  case kCONST_EXP:
# line 533 "MoveControl.puma"
   return 0;

  case kBOUND_EXP:
# line 537 "MoveControl.puma"
   return 0;

  case kRANK_EXP:
# line 541 "MoveControl.puma"
   return 0;

  case kARRAY_EXP:
# line 545 "MoveControl.puma"
   return CountMovements (var, exp->ARRAY_EXP.ELEMENTS);

  case kTYPE_EXP:
# line 549 "MoveControl.puma"
   return CountMovements (var, exp->TYPE_EXP.ELEMENTS);

  case kDO_EXP:
# line 553 "MoveControl.puma"
   return CountMovements (var, exp->DO_EXP.RANGE) + CountMovements (var, exp->DO_EXP.BODY);

  case kSLICE_EXP:
# line 557 "MoveControl.puma"
   return CountMovements (var, exp->SLICE_EXP.START) + CountMovements (var, exp->SLICE_EXP.STOP) + CountMovements (var, exp->SLICE_EXP.INC);

  case kOP_EXP:
# line 562 "MoveControl.puma"
   return CountMovements (var, exp->OP_EXP.OPND1) + CountMovements (var, exp->OP_EXP.OPND2);

  case kOP1_EXP:
# line 566 "MoveControl.puma"
   return CountMovements (var, exp->OP1_EXP.OPND);

  case kPERM_EXP:
# line 570 "MoveControl.puma"
   return CountMovements (var, exp->PERM_EXP.VAL) + 1;

  case kVAR_EXP:
# line 575 "MoveControl.puma"
   return CountVarMovements (var, exp->VAR_EXP.V);

  case kFUNC_CALL_EXP:
# line 579 "MoveControl.puma"
  {
# line 581 "MoveControl.puma"
   if (! ((IsIntrCall (exp)))) goto yyL16;
  {
# line 582 "MoveControl.puma"
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("SPREAD", 6)))) goto yyL16;
  }
  }
   return CountSpreadMovements (var, exp->FUNC_CALL_EXP.FUNC_PARAMS);
yyL16:;

# line 587 "MoveControl.puma"
   return CountMovements (var, exp->FUNC_CALL_EXP.FUNC_PARAMS);

  case kBTE_LIST:
# line 592 "MoveControl.puma"
   return CountMovements (var, exp->BTE_LIST.Elem) + CountMovements (var, exp->BTE_LIST.Next);

  case kBTE_EMPTY:
# line 596 "MoveControl.puma"
   return 0;

  case kBTP_LIST:
# line 600 "MoveControl.puma"
   return CountMovements (var, exp->BTP_LIST.Elem) + CountMovements (var, exp->BTP_LIST.Next);

  case kBTP_EMPTY:
# line 604 "MoveControl.puma"
   return 0;

  case kVAR_PARAM:
  if (exp->VAR_PARAM.V->Kind == kADDR) {
# line 608 "MoveControl.puma"
   return CountMovements (var, exp->VAR_PARAM.V->ADDR.E);

  }
# line 612 "MoveControl.puma"
   return CountVarMovements (var, exp->VAR_PARAM.V);

  case kNO_PARAM:
# line 616 "MoveControl.puma"
   return 0;

  case kFUNC_PARAM:
# line 620 "MoveControl.puma"
   return 0;

  case kPROC_PARAM:
# line 624 "MoveControl.puma"
   return 0;

  case kUSED_VAR:
# line 628 "MoveControl.puma"
   return CountVarMovements (var, exp);

  case kLOOP_VAR:
# line 632 "MoveControl.puma"
   return 0;

  case kINDEXED_VAR:
# line 636 "MoveControl.puma"
   return CountVarMovements (var, exp);

  }

# line 640 "MoveControl.puma"
  {
# line 641 "MoveControl.puma"
   failure_protocol (MODULE, "CountMovements (exp)", exp);
  }
   return 0;

}

static int CountSpreadMovements
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree params)
# else
(var, params)
 register tTree var;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 657 "MoveControl.puma"
 {
  int dimval;
  bool found;
  {
# line 659 "MoveControl.puma"

# line 660 "MoveControl.puma"

# line 662 "MoveControl.puma"
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem, & found, & dimval);
# line 664 "MoveControl.puma"
 if (!found) dimval = -1; 
  }
  {
   return CountMovements (var, params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem) + CountSpreadVarMovements (var, params->BTP_LIST.Elem, dimval);
  }
 }

  }
  }
  }
  }
# line 670 "MoveControl.puma"
  {
# line 671 "MoveControl.puma"
   failure_protocol (MODULE, "CountSpreadMovements", params);
  }
   return 0;

}

static int CountSpreadVarMovements
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree array, register int dim)
# else
(var, array, dim)
 register tTree var;
 register tTree array;
 register int dim;
# endif
{
# line 677 "MoveControl.puma"
  {
# line 678 "MoveControl.puma"
   if (! ((dim == - 1))) goto yyL1;
  }
   return 1;
yyL1:;

# line 682 "MoveControl.puma"
 {
  int count;
  int yyV1;
  tTree yyV2;
  {
# line 684 "MoveControl.puma"

# line 686 "MoveControl.puma"
   GetMajorityVar (array, & yyV1, & yyV2);
# line 688 "MoveControl.puma"
 if (yyV1 == 0) count = 0;           

       else if (yyV1 != 1) count = 1;     

       else if (SpreadAligned (var, yyV2, dim))

            count = 0;
   
       else count = 1;    
    
  }
  {
   return count;
  }
 }

}

bool SpreadAligned
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree maj_var, register int dim)
# else
(var, maj_var, dim)
 register tTree var;
 register tTree maj_var;
 register int dim;
# endif
{
# line 710 "MoveControl.puma"
  {
# line 714 "MoveControl.puma"
   if (! ((TreeRank (var) != TreeRank (maj_var) + 1))) goto yyL1;
  {
# line 715 "MoveControl.puma"
   return false;
  }
  }
yyL1:;

# line 718 "MoveControl.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  bool yyV3;
  var_descriptor yyV4;
  {
# line 723 "MoveControl.puma"
   FindLegalVarDescriptor (var, & yyV1, & yyV2);
# line 724 "MoveControl.puma"
   FindLegalVarDescriptor (maj_var, & yyV3, & yyV4);
# line 726 "MoveControl.puma"
   if (! ((yyV1 && yyV3))) goto yyL2;
  {
# line 728 "MoveControl.puma"
   RedVarDescriptor (& yyV2, dim);
# line 730 "MoveControl.puma"
   if (! ((VDIsLocalAssignment (& yyV2, & yyV4)))) goto yyL2;
  }
  }
   return true;
 }
yyL2:;

  return false;
}

void GetMajorityVar
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int * flag, register tTree * var)
# else
(exp, flag, var)
 register tTree exp;
 register int * flag;
 register tTree * var;
# endif
{

  switch (exp->Kind) {
  case kADDR:
# line 741 "MoveControl.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 742 "MoveControl.puma"
   GetMajorityVar (exp->ADDR.E, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kDUMMY_EXP:
# line 745 "MoveControl.puma"
   * flag = 0;
   * var = NoTree;
   return;

  case kCONST_EXP:
# line 748 "MoveControl.puma"
   * flag = 0;
   * var = NoTree;
   return;

  case kARRAY_EXP:
# line 751 "MoveControl.puma"
  {
# line 752 "MoveControl.puma"
   if (! ((TreeReadDistribution (exp->ARRAY_EXP.ELEMENTS) == 0))) goto yyL4;
  }
   * flag = 0;
   * var = NoTree;
   return;
yyL4:;

# line 755 "MoveControl.puma"
   * flag = - 1;
   * var = NoTree;
   return;

  case kTYPE_EXP:
# line 758 "MoveControl.puma"
  {
# line 759 "MoveControl.puma"
   if (! ((TreeReadDistribution (exp->TYPE_EXP.ELEMENTS) == 0))) goto yyL6;
  }
   * flag = 0;
   * var = NoTree;
   return;
yyL6:;

# line 762 "MoveControl.puma"
   * flag = - 1;
   * var = NoTree;
   return;

  case kSLICE_EXP:
# line 765 "MoveControl.puma"
  {
# line 766 "MoveControl.puma"
   if (! ((TreeReadDistribution (exp->SLICE_EXP.START) == 0))) goto yyL8;
  {
# line 767 "MoveControl.puma"
   if (! ((TreeReadDistribution (exp->SLICE_EXP.STOP) == 0))) goto yyL8;
  {
# line 768 "MoveControl.puma"
   if (! ((TreeReadDistribution (exp->SLICE_EXP.INC) == 0))) goto yyL8;
  }
  }
  }
   * flag = 0;
   * var = NoTree;
   return;
yyL8:;

# line 771 "MoveControl.puma"
   * flag = - 1;
   * var = NoTree;
   return;

  case kOP_EXP:
# line 774 "MoveControl.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 776 "MoveControl.puma"
   GetMajorityVar2 (exp->OP_EXP.OPND1, exp->OP_EXP.OPND2, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kOP1_EXP:
# line 779 "MoveControl.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 781 "MoveControl.puma"
   GetMajorityVar (exp->OP1_EXP.OPND, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kPERM_EXP:
# line 784 "MoveControl.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 786 "MoveControl.puma"
   GetMajorityVar (exp->PERM_EXP.VAL, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kVAR_EXP:
# line 789 "MoveControl.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 790 "MoveControl.puma"
   GetMajorityVar (exp->VAR_EXP.V, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kFUNC_CALL_EXP:
# line 793 "MoveControl.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 797 "MoveControl.puma"
   if (! ((IsIntrCall (exp)))) goto yyL14;
  {
# line 798 "MoveControl.puma"
   if (! ((IntrFuncElemental (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL14;
  {
# line 800 "MoveControl.puma"
   GetMajorityVar (exp->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }
yyL14:;

# line 803 "MoveControl.puma"
   * flag = - 1;
   * var = NoTree;
   return;

  case kBTE_LIST:
# line 808 "MoveControl.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 810 "MoveControl.puma"
   GetMajorityVar2 (exp->BTE_LIST.Elem, exp->BTE_LIST.Next, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kBTE_EMPTY:
# line 813 "MoveControl.puma"
   * flag = 0;
   * var = NoTree;
   return;

  case kBTP_LIST:
# line 817 "MoveControl.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 819 "MoveControl.puma"
   GetMajorityVar2 (exp->BTP_LIST.Elem, exp->BTP_LIST.Next, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kBTP_EMPTY:
# line 822 "MoveControl.puma"
   * flag = 0;
   * var = NoTree;
   return;

  case kVAR_PARAM:
# line 825 "MoveControl.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 826 "MoveControl.puma"
   GetMajorityVar (exp->VAR_PARAM.V, & yyV1, & yyV2);
  }
   * flag = yyV1;
   * var = yyV2;
   return;
 }

  case kNO_PARAM:
# line 829 "MoveControl.puma"
   * flag = 0;
   * var = NoTree;
   return;

  case kUSED_VAR:
# line 832 "MoveControl.puma"
   * flag = 1;
   * var = exp;
   return;

  case kLOOP_VAR:
# line 835 "MoveControl.puma"
   * flag = 1;
   * var = exp;
   return;

  case kINDEXED_VAR:
# line 838 "MoveControl.puma"
   * flag = 1;
   * var = exp;
   return;

  }

# line 841 "MoveControl.puma"
  {
# line 842 "MoveControl.puma"
   failure_protocol (MODULE, "GetMajorityVar", exp);
  }
   * flag = - 1;
   * var = NoTree;
   return;

;
}

void GetMajorityVar2
# if defined __STDC__ | defined __cplusplus
(register tTree exp1, register tTree exp2, register int * yyP2, register tTree * yyP1)
# else
(exp1, exp2, yyP2, yyP1)
 register tTree exp1;
 register tTree exp2;
 register int * yyP2;
 register tTree * yyP1;
# endif
{
# line 853 "MoveControl.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 855 "MoveControl.puma"
   if (! ((exp2 == NoTree))) goto yyL1;
  {
# line 856 "MoveControl.puma"
   GetMajorityVar (exp1, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL1:;

# line 859 "MoveControl.puma"
 {
  int yyV1;
  tTree yyV2;
  int yyV3;
  tTree yyV4;
  int yyV5;
  tTree yyV6;
  {
# line 861 "MoveControl.puma"
   GetMajorityVar (exp1, & yyV1, & yyV2);
# line 862 "MoveControl.puma"
   GetMajorityVar (exp2, & yyV3, & yyV4);
# line 863 "MoveControl.puma"
   MergeMajorityVars (yyV1, yyV2, yyV3, yyV4, & yyV5, & yyV6);
  }
   * yyP2 = yyV5;
   * yyP1 = yyV6;
   return;
 }

;
}

static void MergeMajorityVars
# if defined __STDC__ | defined __cplusplus
(register int yyP6, register tTree yyP5, register int yyP4, register tTree yyP3, register int * yyP8, register tTree * yyP7)
# else
(yyP6, yyP5, yyP4, yyP3, yyP8, yyP7)
 register int yyP6;
 register tTree yyP5;
 register int yyP4;
 register tTree yyP3;
 register int * yyP8;
 register tTree * yyP7;
# endif
{
  if (equalint (yyP4, 0)) {
# line 878 "MoveControl.puma"
  {
# line 879 "MoveControl.puma"
   if (! ((HigherRank (yyP5, yyP3)))) goto yyL1;
  }
   * yyP8 = yyP6;
   * yyP7 = yyP5;
   return;
yyL1:;

  }
  if (equalint (yyP6, 0)) {
# line 882 "MoveControl.puma"
  {
# line 883 "MoveControl.puma"
   if (! ((HigherRank (yyP3, yyP5)))) goto yyL2;
  }
   * yyP8 = yyP4;
   * yyP7 = yyP3;
   return;
yyL2:;

  }
  if (equalint (yyP4, - 1)) {
# line 886 "MoveControl.puma"
   * yyP8 = - 1;
   * yyP7 = NoTree;
   return;

  }
  if (equalint (yyP6, - 1)) {
# line 889 "MoveControl.puma"
   * yyP8 = - 1;
   * yyP7 = NoTree;
   return;

  }
  if (equalint (yyP6, 1)) {
  if (equalint (yyP4, 1)) {
# line 892 "MoveControl.puma"
  {
# line 893 "MoveControl.puma"
   if (! ((CountMovements (yyP5, yyP3) == 0))) goto yyL5;
  {
# line 894 "MoveControl.puma"
   if (! ((HigherRank (yyP5, yyP3)))) goto yyL5;
  }
  }
   * yyP8 = 1;
   * yyP7 = yyP5;
   return;
yyL5:;

  }
  }
  if (equalint (yyP6, 1)) {
  if (equalint (yyP4, 1)) {
# line 897 "MoveControl.puma"
  {
# line 898 "MoveControl.puma"
   if (! ((CountMovements (yyP3, yyP5) == 0))) goto yyL6;
  {
# line 899 "MoveControl.puma"
   if (! ((HigherRank (yyP3, yyP5)))) goto yyL6;
  }
  }
   * yyP8 = 1;
   * yyP7 = yyP3;
   return;
yyL6:;

  }
  }
# line 902 "MoveControl.puma"
   * yyP8 = - 1;
   * yyP7 = NoTree;
   return;

;
}

static bool HigherRank
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register tTree var2)
# else
(var1, var2)
 register tTree var1;
 register tTree var2;
# endif
{
# line 907 "MoveControl.puma"
  {
# line 908 "MoveControl.puma"
   if (! ((var2 == NoTree))) goto yyL1;
  }
   return true;
yyL1:;

# line 911 "MoveControl.puma"
  {
# line 912 "MoveControl.puma"
   if (! ((var1 == NoTree))) goto yyL2;
  {
# line 913 "MoveControl.puma"
   return false;
  }
  }
yyL2:;

# line 916 "MoveControl.puma"
  {
# line 917 "MoveControl.puma"
   if (! ((TreeRank (var1) >= TreeRank (var2)))) goto yyL3;
  }
   return true;
yyL3:;

  return false;
}

int CountVarMovements
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree var1)
# else
(var, var1)
 register tTree var;
 register tTree var1;
# endif
{
  if (var1->Kind == kINDEXED_VAR) {
# line 942 "MoveControl.puma"
  {
# line 944 "MoveControl.puma"
   if (! ((TreeWriteDistribution (var1->INDEXED_VAR.IND_VAR) == 0))) goto yyL1;
  }
   return CountMovements (var, var1->INDEXED_VAR.IND_EXPS);
yyL1:;

# line 948 "MoveControl.puma"
  {
# line 950 "MoveControl.puma"
   if (! ((TreeWriteDistribution (var1->INDEXED_VAR.IND_VAR) == 2))) goto yyL2;
  }
   return CountMovements (var, var1->INDEXED_VAR.IND_EXPS);
yyL2:;

  }
  if (var->Kind == kINDEXED_VAR) {
# line 954 "MoveControl.puma"
  {
# line 956 "MoveControl.puma"
   if (! ((TreeWriteDistribution (var->INDEXED_VAR.IND_VAR) == 2))) goto yyL3;
  }
   return CountMovements (var1, var->INDEXED_VAR.IND_EXPS);
yyL3:;

  }
# line 960 "MoveControl.puma"
  {
# line 969 "MoveControl.puma"
   if (! ((IsLocalAssignment (var, TreeWriteDistribution (var), var1, TreeWriteDistribution (var1))))) goto yyL4;
  }
   return 0;
yyL4:;

# line 974 "MoveControl.puma"
   return 1;

}

static bool IsLocalAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree lvar, register int lvardist, register tTree rvar, register int rvardist)
# else
(lvar, lvardist, rvar, rvardist)
 register tTree lvar;
 register int lvardist;
 register tTree rvar;
 register int rvardist;
# endif
{
# line 990 "MoveControl.puma"
  {
# line 991 "MoveControl.puma"
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return true;
yyL1:;

  if (equalint (rvardist, 0)) {
# line 994 "MoveControl.puma"
   return true;

  }
  if (equalint (lvardist, - 1)) {
  if (equalint (rvardist, - 1)) {
# line 997 "MoveControl.puma"
   return true;

  }
  }
 {
  bool yyV1;
  shift_vector yyV2;
  if (equalint (lvardist, 1)) {
  if (equalint (rvardist, 1)) {
# line 1000 "MoveControl.puma"
  {
# line 1002 "MoveControl.puma"
   if (! (ReplicatedIndexes (lvar))) goto yyL4;
  {
# line 1003 "MoveControl.puma"
   if (! (ReplicatedIndexes (rvar))) goto yyL4;
  {
# line 1005 "MoveControl.puma"
   GetShifting (lvar, rvar, & yyV1, & yyV2);
# line 1007 "MoveControl.puma"
   if (! ((yyV1))) goto yyL4;
  {
# line 1011 "MoveControl.puma"
   if (! ((EnoughOverlapArea (rvar, & yyV2)))) goto yyL4;
  }
  }
  }
  }
   return true;
yyL4:;

  }
  }
 }
  return false;
}

bool VDIsLocalAssignment
# if defined __STDC__ | defined __cplusplus
(pvar lvar, pvar rvar)
# else
(lvar, rvar)
 pvar lvar;
 pvar rvar;
# endif
{
# line 1036 "MoveControl.puma"
  {
# line 1038 "MoveControl.puma"
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return true;
yyL1:;

# line 1041 "MoveControl.puma"
  {
# line 1045 "MoveControl.puma"
   if (! ((rvar -> topology_obj == GetDefaultTopology (0)))) goto yyL2;
  }
   return true;
yyL2:;

# line 1048 "MoveControl.puma"
 {
  shift_vector pv;
  {
# line 1050 "MoveControl.puma"
   if (! ((lvar -> topology_rank > 0))) goto yyL3;
  {
# line 1051 "MoveControl.puma"
   if (! ((rvar -> topology_rank > 0))) goto yyL3;
  {
# line 1053 "MoveControl.puma"

# line 1055 "MoveControl.puma"
   if (! ((VDIsShifting (lvar, rvar, & pv)))) goto yyL3;
  {
# line 1057 "MoveControl.puma"

#ifdef DEBUG
   print_shift ("VDShifting found", &pv);
#endif
   
# line 1063 "MoveControl.puma"
   if (! (EnoughVDOverlapArea (rvar, & pv))) goto yyL3;
  }
  }
  }
  }
   return true;
 }
yyL3:;

  return false;
}

static bool ReplicatedIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 1074 "MoveControl.puma"
   return true;

  }
  if (var->Kind == kINDEXED_VAR) {
# line 1077 "MoveControl.puma"
  {
# line 1078 "MoveControl.puma"
   if (! ((TreeReadDistribution (var->INDEXED_VAR.IND_EXPS) == 0))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

void GetShifting
# if defined __STDC__ | defined __cplusplus
(register tTree lvar, register tTree rvar, register bool * yyP10, shift_vector * yyP9)
# else
(lvar, rvar, yyP10, yyP9)
 register tTree lvar;
 register tTree rvar;
 register bool * yyP10;
 shift_vector * yyP9;
# endif
{
# line 1099 "MoveControl.puma"
 {
  shift_vector sv;
  {
# line 1101 "MoveControl.puma"

# line 1103 "MoveControl.puma"
   if (! (((TreeWriteDistribution (lvar) != 1) || (TreeWriteDistribution (rvar) != 1)))) goto yyL1;
  }
   * yyP10 = false;
   * yyP9 = sv;
   return;
 }
yyL1:;

# line 1106 "MoveControl.puma"
 {
  shift_vector sv;
  bool yyV1;
  var_descriptor yyV2;
  bool yyV3;
  var_descriptor yyV4;
  {
# line 1108 "MoveControl.puma"

# line 1112 "MoveControl.puma"
   FindLegalVarDescriptor (lvar, & yyV1, & yyV2);
# line 1113 "MoveControl.puma"
   FindLegalVarDescriptor (rvar, & yyV3, & yyV4);
# line 1125 "MoveControl.puma"
   if (! ((yyV1 && yyV3))) goto yyL2;
  {
# line 1127 "MoveControl.puma"
   if (! ((VDIsShifting (& yyV2, & yyV4, & sv)))) goto yyL2;
  }
  }
   * yyP10 = true;
   * yyP9 = sv;
   return;
 }
yyL2:;

# line 1130 "MoveControl.puma"
 {
  shift_vector sv;
  {
# line 1132 "MoveControl.puma"

  }
   * yyP10 = false;
   * yyP9 = sv;
   return;
 }

;
}

void GetCircularShifting
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register bool * yyP13, register tTree * yyP12, shift_vector * yyP11)
# else
(exp, yyP13, yyP12, yyP11)
 register tTree exp;
 register bool * yyP13;
 register tTree * yyP12;
 shift_vector * yyP11;
# endif
{
# line 1151 "MoveControl.puma"
 {
  bool yyV1;
  tTree yyV2;
  shift_vector yyV3;
  {
# line 1155 "MoveControl.puma"
   FindVarShift (exp, & yyV1, & yyV2, & yyV3);
# line 1157 "MoveControl.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 1162 "MoveControl.puma"
   if (! ((AreDimsShiftable (yyV2, & yyV3)))) goto yyL1;
  }
  }
   * yyP13 = yyV1;
   * yyP12 = yyV2;
   * yyP11 = yyV3;
   return;
 }
yyL1:;

# line 1165 "MoveControl.puma"
 {
  shift_vector sv;
  {
# line 1167 "MoveControl.puma"

  }
   * yyP13 = false;
   * yyP12 = NoTree;
   * yyP11 = sv;
   return;
 }

;
}

static void ResolveCShiftParams
# if defined __STDC__ | defined __cplusplus
(register tTree params, register tTree * yyP16, register int * yyP15, register int * yyP14)
# else
(params, yyP16, yyP15, yyP14)
 register tTree params;
 register tTree * yyP16;
 register int * yyP15;
 register int * yyP14;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1182 "MoveControl.puma"
 {
  bool found;
  int idim;
  int ipos;
  {
# line 1186 "MoveControl.puma"

# line 1187 "MoveControl.puma"

# line 1188 "MoveControl.puma"

# line 1190 "MoveControl.puma"
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V, & found, & idim);
# line 1191 "MoveControl.puma"
   if (! ((found))) goto yyL1;
  {
# line 1192 "MoveControl.puma"
   if (! ((idim > 0))) goto yyL1;
  {
# line 1193 "MoveControl.puma"
   if (! ((idim <= TreeRank (params->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL1;
  {
# line 1195 "MoveControl.puma"
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V, & found, & ipos);
# line 1196 "MoveControl.puma"
   if (! ((found))) goto yyL1;
  }
  }
  }
  }
   * yyP16 = params->BTP_LIST.Elem->VAR_PARAM.V;
   * yyP15 = idim;
   * yyP14 = ipos;
   return;
 }
yyL1:;

# line 1199 "MoveControl.puma"
   * yyP16 = params->BTP_LIST.Elem->VAR_PARAM.V;
   * yyP15 = 0;
   * yyP14 = 0;
   return;

  }
  }
  }
  }
  }
  }
  }
# line 1204 "MoveControl.puma"
  {
# line 1205 "MoveControl.puma"
   failure_protocol (MODULE, "ResolveCShiftParams", params);
  }
   * yyP16 = NoTree;
   * yyP15 = 0;
   * yyP14 = 0;
   return;

;
}

static void FindVarShift
# if defined __STDC__ | defined __cplusplus
(register tTree var, register bool * yyP19, register tTree * yyP18, shift_vector * yyP17)
# else
(var, yyP19, yyP18, yyP17)
 register tTree var;
 register bool * yyP19;
 register tTree * yyP18;
 shift_vector * yyP17;
# endif
{
  if (var->Kind == kADDR) {
# line 1216 "MoveControl.puma"
 {
  bool yyV1;
  tTree yyV2;
  shift_vector yyV3;
  {
# line 1218 "MoveControl.puma"
   FindVarShift (var->ADDR.E, & yyV1, & yyV2, & yyV3);
  }
   * yyP19 = yyV1;
   * yyP18 = yyV2;
   * yyP17 = yyV3;
   return;
 }

  }
  if (var->Kind == kFUNC_CALL_EXP) {
# line 1221 "MoveControl.puma"
 {
  tTree yyV1;
  int yyV2;
  int yyV3;
  bool yyV4;
  tTree yyV5;
  shift_vector yyV6;
  int formal_dim;
  {
# line 1223 "MoveControl.puma"
   if (! ((IsIntrCall (var)))) goto yyL2;
  {
# line 1224 "MoveControl.puma"
   if (! ((var->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("CSHIFT", 6)))) goto yyL2;
  {
# line 1226 "MoveControl.puma"
   ResolveCShiftParams (var->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2, & yyV3);
# line 1228 "MoveControl.puma"
   if (! ((yyV2 > 0))) goto yyL2;
  {
# line 1230 "MoveControl.puma"
   FindVarShift (yyV1, & yyV4, & yyV5, & yyV6);
# line 1232 "MoveControl.puma"
   if (! ((yyV4))) goto yyL2;
  {
# line 1234 "MoveControl.puma"

# line 1235 "MoveControl.puma"
   formal_dim = GetIndexPosition (yyV5, yyV2);
# line 1237 "MoveControl.puma"
 yyV6.shift_pos[formal_dim-1] -= yyV3; 
  }
  }
  }
  }
  }
   * yyP19 = yyV4;
   * yyP18 = yyV5;
   * yyP17 = yyV6;
   return;
 }
yyL2:;

  }
  if (var->Kind == kINDEXED_VAR) {
# line 1240 "MoveControl.puma"
 {
  shift_vector sv;
  int i;
  {
# line 1242 "MoveControl.puma"

# line 1243 "MoveControl.puma"

# line 1245 "MoveControl.puma"
 sv.shift_rank = TreeRank (var->INDEXED_VAR.IND_VAR);
    for (i=0; i< sv.shift_rank; i++) sv.shift_pos[i] = 0;
  
  }
   * yyP19 = true;
   * yyP18 = var;
   * yyP17 = sv;
   return;
 }

  }
# line 1250 "MoveControl.puma"
 {
  shift_vector sv;
  {
# line 1252 "MoveControl.puma"

  }
   * yyP19 = false;
   * yyP18 = NoTree;
   * yyP17 = sv;
   return;
 }

;
}

static bool AreDimsShiftable
# if defined __STDC__ | defined __cplusplus
(register tTree var, pshift sv)
# else
(var, sv)
 register tTree var;
 pshift sv;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 1275 "MoveControl.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  bool okay;
  int dim;
  int rank;
  {
# line 1277 "MoveControl.puma"
   FindLegalVarDescriptor (var, & yyV1, & yyV2);
# line 1278 "MoveControl.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 1280 "MoveControl.puma"

# line 1281 "MoveControl.puma"

# line 1282 "MoveControl.puma"

# line 1284 "MoveControl.puma"
 rank = yyV2.formal_rank;

     if (rank != sv->shift_rank) 
       { printf ("var rank = %d, shift rank = %d\n", rank, sv->shift_rank);
         failure_protocol (MODULE, "AreDimsShiftable (rank mismatch)", var);
       }

     okay = true;

     for (dim = 0; dim < rank; dim ++)

     {  if (sv->shift_pos[dim] != 0)

          { okay = okay && ActualEqFormal (yyV2.formal_shape[dim][0], 
                                           yyV2.actual_shape[dim][0]);

            okay = okay && ActualEqFormal (yyV2.formal_shape[dim][1], 
                                           yyV2.actual_shape[dim][1]);

            

            okay = okay && IsStride1 (yyV2.actual_shape[dim][2]);

            if (yyV2.topology_rank > 0)
              okay = okay && (yyV2.distribution_kind[dim] != kCYCLIC_DIM);

          }

     }   

   
# line 1315 "MoveControl.puma"
   if (! ((okay))) goto yyL1;
  }
  }
   return true;
 }
yyL1:;

  }
  return false;
}

static bool ActualEqFormal
# if defined __STDC__ | defined __cplusplus
(register tTree formal_exp, register tTree actual_exp)
# else
(formal_exp, actual_exp)
 register tTree formal_exp;
 register tTree actual_exp;
# endif
{
# line 1328 "MoveControl.puma"
  {
# line 1330 "MoveControl.puma"
   if (! ((formal_exp == NoTree))) goto yyL1;
  {
# line 1331 "MoveControl.puma"
   if (! ((actual_exp == NoTree))) goto yyL1;
  {
# line 1332 "MoveControl.puma"
   return false;
  }
  }
  }
yyL1:;

# line 1335 "MoveControl.puma"
  {
# line 1337 "MoveControl.puma"
   if (! ((formal_exp != NoTree))) goto yyL2;
  {
# line 1338 "MoveControl.puma"
   if (! ((actual_exp != NoTree))) goto yyL2;
  {
# line 1339 "MoveControl.puma"
   if (! ((EqualExpression (formal_exp, actual_exp)))) goto yyL2;
  }
  }
  }
   return true;
yyL2:;

  return false;
}

static int GetIndexPosition
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int dim)
# else
(indexes, dim)
 register tTree indexes;
 register int dim;
# endif
{
  if (indexes->Kind == kINDEXED_VAR) {
# line 1354 "MoveControl.puma"
   return GetIndexPosition (indexes->INDEXED_VAR.IND_EXPS, dim);

  }
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 1358 "MoveControl.puma"
  {
# line 1359 "MoveControl.puma"
   if (! ((dim == 1))) goto yyL2;
  }
   return 1;
yyL2:;

# line 1363 "MoveControl.puma"
   return GetIndexPosition (indexes->BTE_LIST.Next, dim - 1) + 1;

  }
# line 1367 "MoveControl.puma"
   return GetIndexPosition (indexes->BTE_LIST.Next, dim) + 1;

  }
# line 1371 "MoveControl.puma"
  {
# line 1372 "MoveControl.puma"
   failure_protocol (MODULE, "GetIndexPosition", indexes);
  }
   return 0;

}

bool EnoughOverlapArea
# if defined __STDC__ | defined __cplusplus
(register tTree var, pshift pos)
# else
(var, pos)
 register tTree var;
 pshift pos;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 1386 "MoveControl.puma"
  {
# line 1387 "MoveControl.puma"
   if (! ((EnoughOverlapArea (var->INDEXED_VAR.IND_VAR, pos)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (var->Kind == kUSED_VAR) {
# line 1390 "MoveControl.puma"
  {
# line 1391 "MoveControl.puma"
   if (! ((EnoughOverlapArea (var->USED_VAR.VARNAME, pos)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (var->Kind == kVAR_OBJ) {
# line 1394 "MoveControl.puma"
  {
# line 1395 "MoveControl.puma"
   if (! ((IsEnoughVarOverlap (ArrayFormals (var->VAR_OBJ.Object), 0, pos)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

static bool IsEnoughVarOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int dim, pshift pos)
# else
(indexes, dim, pos)
 register tTree indexes;
 register int dim;
 pshift pos;
# endif
{
  if (indexes->Kind == kSHAPE_EMPTY) {
# line 1400 "MoveControl.puma"
   return true;

  }
  if (indexes->Kind == kSHAPE_LIST) {
# line 1405 "MoveControl.puma"
  {
# line 1407 "MoveControl.puma"
   if (! (SufficientOverlapIndex (indexes->SHAPE_LIST.Elem, pos -> shift_pos [dim]))) goto yyL2;
  {
# line 1408 "MoveControl.puma"
   if (! (IsEnoughVarOverlap (indexes->SHAPE_LIST.Next, dim + 1, pos))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  return false;
}

static bool SufficientOverlapIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index, register int pos)
# else
(index, pos)
 register tTree index;
 register int pos;
# endif
{
  if (index->Kind == kOVERLAP_SPEC) {
# line 1421 "MoveControl.puma"
  {
# line 1423 "MoveControl.puma"
   if (! ((index->OVERLAP_SPEC.right_update >= - pos))) goto yyL1;
  {
# line 1424 "MoveControl.puma"
   if (! ((index->OVERLAP_SPEC.left_update >= pos))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  if (Tree_IsType (index, kSHAPE_SPEC)) {
# line 1427 "MoveControl.puma"
  {
# line 1429 "MoveControl.puma"
   if (! ((SufficientOverlapIndex (index->SHAPE_SPEC.Overlap, pos)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

bool SameDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions actual, register tDefinitions formal)
# else
(actual, formal)
 register tDefinitions actual;
 register tDefinitions formal;
# endif
{
# line 1442 "MoveControl.puma"
 {
  var_descriptor vard1;
  var_descriptor vard2;
  {
# line 1444 "MoveControl.puma"

# line 1445 "MoveControl.puma"

# line 1447 "MoveControl.puma"
   SetVarObjDescriptor (& vard1, actual, NoTree);
# line 1448 "MoveControl.puma"
   SetVarObjDescriptor (& vard2, formal, NoTree);
# line 1450 "MoveControl.puma"
   if (! ((SameDescriptorDistribution (& vard1, & vard2)))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static bool SameDescriptorDistribution
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2)
# else
(vard1, vard2)
 pvar vard1;
 pvar vard2;
# endif
{
# line 1456 "MoveControl.puma"
  {
# line 1458 "MoveControl.puma"
   if (! ((vard1 -> topology_rank == 0))) goto yyL1;
  {
# line 1459 "MoveControl.puma"
   if (! ((vard2 -> topology_rank == 0))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 1462 "MoveControl.puma"
  {
# line 1464 "MoveControl.puma"
   if (! ((vard1 -> topology_rank == - 1))) goto yyL2;
  {
# line 1465 "MoveControl.puma"
   if (! ((vard2 -> topology_rank == - 1))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 1468 "MoveControl.puma"
 {
  bool equal;
  int pdim;
  {
# line 1470 "MoveControl.puma"
   printf ("SameDescriptorDistribution, vard1, vard2\n");
# line 1471 "MoveControl.puma"
   PrintVarDescriptor (vard1);
# line 1472 "MoveControl.puma"
   PrintVarDescriptor (vard2);
# line 1474 "MoveControl.puma"
   if (! ((SameDescriptorTopology (vard1, vard2)))) goto yyL3;
  {
# line 1476 "MoveControl.puma"

# line 1477 "MoveControl.puma"

# line 1479 "MoveControl.puma"
 equal = true;

      for (pdim=0; pdim < vard1->topology_rank; pdim++)

        { int kind1, kind2;

          kind1 = vard1->on_kind [pdim];
          kind2 = vard2->on_kind [pdim];

          if (kind1 != kind2) equal = false;

          

          
        }

    
# line 1496 "MoveControl.puma"
   if (! ((equal))) goto yyL3;
  }
  }
   return true;
 }
yyL3:;

  return false;
}

static void FindLegalVarDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register bool * yyP21, var_descriptor * yyP20)
# else
(var, yyP21, yyP20)
 register tTree var;
 register bool * yyP21;
 var_descriptor * yyP20;
# endif
{
# line 1509 "MoveControl.puma"
 {
  var_descriptor vard;
  bool found;
  {
# line 1511 "MoveControl.puma"

# line 1512 "MoveControl.puma"

# line 1514 "MoveControl.puma"
   GetVarDescriptor (var, & found, & vard);
  }
   * yyP21 = found;
   * yyP20 = vard;
   return;
 }

;
}

void BeginMoveControl ()
{
}

void CloseMoveControl ()
{
}
