# include "Modules.h"
# include "yyModules.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 24 "Modules.puma"


# define MODULE "Modules"

# include <stdio.h>
# include <string.h>

# include "protocol.h"

# include "Idents.h"
# include "StringMem.h"

# include "DefTable.h"
# include "Objects.h"



static void yyExit () { Exit (1); }

void (* Modules_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Modules, routine %s failed\n", yyFunction);
 Modules_Exit ();
}

void WriteModules ARGS((tTree t));
static tTree ReadModule ARGS((tIdent module_name));
static void AddUsedModule ARGS((tTree root, tTree new_module));
static void MakeModuleObject ARGS((tTree module_tree, tDefinitions * yyP1));
static void CheckModule ARGS((tIdent name, tDefinitions obj));
tDefinitions GetModule ARGS((tIdent module_name));

void WriteModules
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMP_UNIT) {
# line 49 "Modules.puma"
  {
# line 51 "Modules.puma"
   WriteModules (t->COMP_UNIT.COMP_ELEMENTS);
  }
   return;

  }
  if (t->Kind == kUNIT_EMPTY) {
# line 54 "Modules.puma"
   return;

  }
  if (t->Kind == kUNIT_LIST) {
# line 57 "Modules.puma"
  {
# line 59 "Modules.puma"
   WriteModules (t->UNIT_LIST.Elem);
# line 60 "Modules.puma"
   WriteModules (t->UNIT_LIST.Next);
  }
   return;

  }
  if (t->Kind == kMODULE_DECL) {
# line 63 "Modules.puma"
  {
# line 65 "Modules.puma"
 char string[100];
     FILE *f;

     GetString (t->MODULE_DECL.Ident, string);
     printf ("write definition file of MODULE %s\n", string);

     if (!CheckTree (t))
        { printf ("SERIOUS ERROR: Illegal module tree %s\n", string);
          kill_in_protocol ();
        }

     strcat (string, ".ext");

     f = fopen (string, "w");

     if (f == (FILE *) NULL)

        { printf ("Adaptor failed to write module definition in %s\n", string);
          printf ("Please check permissions\n");
          exit (-1);
        }

     PutTree (f, t);
     fclose (f);
   
  }
   return;

  }
;
}

static tTree ReadModule
# if defined __STDC__ | defined __cplusplus
(register tIdent module_name)
# else
(module_name)
 register tIdent module_name;
# endif
{
# line 103 "Modules.puma"
 {
  tTree t;
  {
# line 105 "Modules.puma"

# line 107 "Modules.puma"
 char string[100];
     FILE *f;

     GetString (module_name, string);

     strcat (string, ".ext");

     f = include_open (string);

     if (f == (FILE *) NULL)

        t = NoTree;

      else

        { t = GetTree (f);

          if (!CheckTree (t))
             { printf ("SERIOUS ERROR: Illegal tree in file %s\n", string);
               
             }
          fclose (f);

          tree_protocol ("READ MODULE : \n", t);
        }

   
  }
  {
   return t;
  }
 }

}

static void AddUsedModule
# if defined __STDC__ | defined __cplusplus
(register tTree root, register tTree new_module)
# else
(root, new_module)
 register tTree root;
 register tTree new_module;
# endif
{
  if (root->Kind == kCOMP_UNIT) {
# line 145 "Modules.puma"
  {
# line 147 "Modules.puma"
 root->COMP_UNIT.USED_ELEMENTS = mUNIT_LIST (new_module, root->COMP_UNIT.USED_ELEMENTS); 
  }
   return;

  }
# line 150 "Modules.puma"
  {
# line 152 "Modules.puma"
   failure_protocol (MODULE, "AddUsedModule", root);
  }
   return;

;
}

static void MakeModuleObject
# if defined __STDC__ | defined __cplusplus
(register tTree module_tree, register tDefinitions * yyP1)
# else
(module_tree, yyP1)
 register tTree module_tree;
 register tDefinitions * yyP1;
# endif
{
# line 163 "Modules.puma"
  {
# line 165 "Modules.puma"
   if (! ((module_tree == NoTree))) goto yyL1;
  }
   * yyP1 = NoObject;
   return;
yyL1:;

  if (module_tree->Kind == kMODULE_DECL) {
# line 168 "Modules.puma"
 {
  tDefinitions new_obj;
  {
# line 170 "Modules.puma"

# line 172 "Modules.puma"
   new_obj = MakeNewObject (module_tree, NoObject);
# line 174 "Modules.puma"
   InsertUnitEntry (new_obj);
# line 175 "Modules.puma"
   AddUsedModule (TreeRoot, module_tree);
# line 177 "Modules.puma"
 module_tree->MODULE_DECL.Object = new_obj; 
  }
   * yyP1 = new_obj;
   return;
 }

  }
# line 180 "Modules.puma"
   * yyP1 = NoObject;
   return;

;
}

static void CheckModule
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tDefinitions obj)
# else
(name, obj)
 register tIdent name;
 register tDefinitions obj;
# endif
{
# line 195 "Modules.puma"
 
char string[MAXID_LENGTH];
char msg[MAX_LINE_LENGTH];

# line 200 "Modules.puma"
  {
# line 202 "Modules.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 204 "Modules.puma"
   GetString (name, string);
# line 205 "Modules.puma"
   sprintf (msg, "USE %s : no definition module found", string);
# line 206 "Modules.puma"
   error_protocol (msg);
  }
  }
   return;
yyL1:;

  if (obj->Kind == kModuleObject) {
# line 209 "Modules.puma"
   return;

  }
# line 212 "Modules.puma"
  {
# line 214 "Modules.puma"
   GetString (name, string);
# line 215 "Modules.puma"
   sprintf (msg, "USE %s : not a MODULE", string);
# line 216 "Modules.puma"
   error_protocol (msg);
# line 217 "Modules.puma"
   obj_protocol ("illegal object is : \n", obj);
  }
   return;

;
}

tDefinitions GetModule
# if defined __STDC__ | defined __cplusplus
(register tIdent module_name)
# else
(module_name)
 register tIdent module_name;
# endif
{
# line 231 "Modules.puma"
 {
  tDefinitions obj;
  {
# line 233 "Modules.puma"

# line 235 "Modules.puma"
   obj = GetDeclEntry (module_name, GetUnitEntries ());
# line 237 "Modules.puma"
   if (! ((obj != NoObject))) goto yyL1;
  {
# line 239 "Modules.puma"
   CheckModule (module_name, obj);
  }
  }
  {
   return obj;
  }
 }
yyL1:;

# line 244 "Modules.puma"
  {
# line 246 "Modules.puma"
   if (! ((module_name == IsIdent ("HPF_LIBRARY")))) goto yyL2;
  }
   return GetHPFLibrary ();
yyL2:;

# line 251 "Modules.puma"
  {
# line 253 "Modules.puma"
   if (! ((module_name == IsIdent ("HPF_LOCAL_LIBRARY")))) goto yyL3;
  }
   return GetHPFLocalLibrary ();
yyL3:;

# line 258 "Modules.puma"
  {
# line 260 "Modules.puma"
   if (! ((module_name == IsIdent ("HPF_TASK_LIBRARY")))) goto yyL4;
  }
   return GetHPFTaskLibrary ();
yyL4:;

# line 265 "Modules.puma"
 {
  tDefinitions yyV1;
  {
# line 267 "Modules.puma"
   MakeModuleObject (ReadModule (module_name), & yyV1);
# line 269 "Modules.puma"
   CheckModule (module_name, yyV1);
  }
  {
   return yyV1;
  }
 }

}

void BeginModules ()
{
}

void CloseModules ()
{
}
