# include "Mapping.h"
# include "yyMapping.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 33 "Mapping.puma"


# include "Idents.h"
# include "StringMem.h"

# include "Objects.h"
# include "Unparse.h"
# include "protocol.h"
# include "DefTable.h" 

# include "Rank.h"         /* VarRank */

# define MODULE "Mapping"



static void yyExit () { Exit (1); }

void (* Mapping_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Mapping, routine %s failed\n", yyFunction);
 Mapping_Exit ();
}

void ReplaceDefaultDistributions ARGS((tDefinitions v, tTree dist_decl));
static tTree MakeDefaultProcArray ARGS((int proc_rank));
static void SetTopologyObject ARGS((tTree p, tDefinitions obj));
static tTree MakeDefaultDistFormat ARGS((tDefinitions v, tDefinitions p, int kind));
static tTree MakeDefaultDistList ARGS((int var_rank, int proc_rank));
void ControlDistributeDecl ARGS((tDefinitions o, tTree dist));
void ControlRedistributeStmt ARGS((tTree dist));
static bool IsUnderSpecifiedDistribution ARGS((tTree dist_spec, tTree proc_spec));
static bool IsUnderSpecifiedMapping ARGS((tTree mapping));
static void MakeFullSpecDistFormat ARGS((tTree distribute_decl));
static void MakeFullSpecifiedMapping ARGS((tTree dim_list));
static void MakeFullOntoClause ARGS((tTree distribute_decl));
static int CountMappingDistDims ARGS((tTree mapping));
static void VerifyTopologyRank ARGS((tTree dist_format, tTree onto_clause));
static void RestrictDistribution ARGS((tTree layout));

void ReplaceDefaultDistributions
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v, register tTree dist_decl)
# else
(v, dist_decl)
 register tDefinitions v;
 register tTree dist_decl;
# endif
{
  if (dist_decl->Kind == kDISTRIBUTE_DECL) {
  if (dist_decl->DISTRIBUTE_DECL.DISTRIBUTION->Kind == kDEFAULT_DISTRIBUTION) {
  if (dist_decl->DISTRIBUTE_DECL.TARGET->Kind == kPROCESSOR_ARRAY) {
# line 68 "Mapping.puma"
  {
# line 71 "Mapping.puma"
   tree_protocol ("replace default dist format in : ", dist_decl);
# line 73 "Mapping.puma"
 dist_decl->DISTRIBUTE_DECL.DISTRIBUTION = MakeDefaultDistFormat (v, dist_decl->DISTRIBUTE_DECL.TARGET->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object, dist_decl->DISTRIBUTE_DECL.DISTRIBUTION->DEFAULT_DISTRIBUTION.is_descriptive); 
# line 75 "Mapping.puma"
   tree_protocol ("default distribution replaced with : ", dist_decl);
  }
   return;

  }
  if (dist_decl->DISTRIBUTE_DECL.TARGET->Kind == kDEFAULT_PROCESSOR_ARRAY) {
# line 112 "Mapping.puma"
  {
# line 115 "Mapping.puma"
   error_protocol ("illegal default distribution directive");
  }
   return;

  }
  }
  if (dist_decl->DISTRIBUTE_DECL.DISTRIBUTION->Kind == kNODE_DISTRIBUTION) {
  if (dist_decl->DISTRIBUTE_DECL.TARGET->Kind == kDEFAULT_PROCESSOR_ARRAY) {
# line 88 "Mapping.puma"
  {
# line 91 "Mapping.puma"
   tree_protocol ("replace default topology in : ", dist_decl);
# line 93 "Mapping.puma"
   RestrictDistribution (dist_decl);
# line 95 "Mapping.puma"
 dist_decl->DISTRIBUTE_DECL.TARGET = MakeDefaultProcArray (CountMappingDistDims (dist_decl->DISTRIBUTE_DECL.DISTRIBUTION->NODE_DISTRIBUTION.MAPPING)); 
# line 97 "Mapping.puma"
   tree_protocol ("default distribution replaced with : ", dist_decl);
  }
   return;

  }
  }
  }
  if (dist_decl->Kind == kREDISTRIBUTE_STMT) {
  if (dist_decl->REDISTRIBUTE_STMT.DISTRIBUTION->Kind == kDEFAULT_DISTRIBUTION) {
  if (dist_decl->REDISTRIBUTE_STMT.TARGET->Kind == kPROCESSOR_ARRAY) {
# line 78 "Mapping.puma"
  {
# line 81 "Mapping.puma"
   tree_protocol ("replace default dist format in : ", dist_decl);
# line 83 "Mapping.puma"
 dist_decl->REDISTRIBUTE_STMT.DISTRIBUTION = MakeDefaultDistFormat (v, dist_decl->REDISTRIBUTE_STMT.TARGET->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object, dist_decl->REDISTRIBUTE_STMT.DISTRIBUTION->DEFAULT_DISTRIBUTION.is_descriptive); 
# line 85 "Mapping.puma"
   tree_protocol ("default redistribution replaced with : ", dist_decl);
  }
   return;

  }
  if (dist_decl->REDISTRIBUTE_STMT.TARGET->Kind == kDEFAULT_PROCESSOR_ARRAY) {
# line 118 "Mapping.puma"
  {
# line 121 "Mapping.puma"
   error_protocol ("illegal default redistribution statement");
  }
   return;

  }
  }
  if (dist_decl->REDISTRIBUTE_STMT.DISTRIBUTION->Kind == kNODE_DISTRIBUTION) {
  if (dist_decl->REDISTRIBUTE_STMT.TARGET->Kind == kDEFAULT_PROCESSOR_ARRAY) {
# line 100 "Mapping.puma"
  {
# line 103 "Mapping.puma"
   RestrictDistribution (dist_decl);
# line 105 "Mapping.puma"
   tree_protocol ("replace default topology in : ", dist_decl);
# line 107 "Mapping.puma"
 dist_decl->REDISTRIBUTE_STMT.TARGET = MakeDefaultProcArray (CountMappingDistDims (dist_decl->REDISTRIBUTE_STMT.DISTRIBUTION->NODE_DISTRIBUTION.MAPPING)); 
# line 109 "Mapping.puma"
   tree_protocol ("default redistribution replaced with : ", dist_decl);
  }
   return;

  }
  }
  }
;
}

static tTree MakeDefaultProcArray
# if defined __STDC__ | defined __cplusplus
(register int proc_rank)
# else
(proc_rank)
 register int proc_rank;
# endif
{
# line 132 "Mapping.puma"
 {
  tTree p;
  {
# line 134 "Mapping.puma"

# line 136 "Mapping.puma"
 if (proc_rank > MAX_TORUS_RANK) 

      { char msg[100];
        sprintf (msg, "too many distributed dimensions (max=%d)",
                      MAX_TORUS_RANK);
        error_protocol (msg);
        proc_rank = MAX_TORUS_RANK;
      }

    p = mPROCESSOR_ARRAY (mTOP_OBJ (DefaultId()));

    SetTopologyObject (p, GetDefaultTopology (proc_rank));

  
  }
  {
   return p;
  }
 }

}

static void SetTopologyObject
# if defined __STDC__ | defined __cplusplus
(register tTree p, register tDefinitions obj)
# else
(p, obj)
 register tTree p;
 register tDefinitions obj;
# endif
{
  if (p->Kind == kPROCESSOR_ARRAY) {
# line 162 "Mapping.puma"
  {
# line 164 "Mapping.puma"
 p->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object = obj; 
  }
   return;

  }
;
}

static tTree MakeDefaultDistFormat
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v, register tDefinitions p, register int kind)
# else
(v, p, kind)
 register tDefinitions v;
 register tDefinitions p;
 register int kind;
# endif
{
# line 175 "Mapping.puma"
 {
  int var_rank;
  int proc_rank;
  {
# line 177 "Mapping.puma"

# line 178 "Mapping.puma"

# line 180 "Mapping.puma"
 var_rank  = VarRank (v);
    proc_rank = VarRank (p);

    if (var_rank < proc_rank)

     { char msg[150];
       sprintf (msg, 
          "var of rank %d cannot be distributed onto topology of rank %d", 
           var_rank, proc_rank);
       error_protocol (msg);

     }
 
  
  }
  {
   return mNODE_DISTRIBUTION (kind, MakeDefaultDistList (var_rank, proc_rank));
  }
 }

}

static tTree MakeDefaultDistList
# if defined __STDC__ | defined __cplusplus
(register int var_rank, register int proc_rank)
# else
(var_rank, proc_rank)
 register int var_rank;
 register int proc_rank;
# endif
{
# line 208 "Mapping.puma"
  {
# line 210 "Mapping.puma"
   if (! ((var_rank <= 0))) goto yyL1;
  }
   return mDIST_EMPTY ();
yyL1:;

# line 215 "Mapping.puma"
  {
# line 217 "Mapping.puma"
   if (! ((var_rank > proc_rank))) goto yyL2;
  }
   return mDIST_LIST (mSERIAL_DISTRIBUTION (), MakeDefaultDistList (var_rank - 1, proc_rank));
yyL2:;

# line 223 "Mapping.puma"
   return mDIST_LIST (mBLOCK_DISTRIBUTION (mDUMMY_EXP ()), MakeDefaultDistList (var_rank - 1, proc_rank - 1));

}

void ControlDistributeDecl
# if defined __STDC__ | defined __cplusplus
(register tDefinitions o, register tTree dist)
# else
(o, dist)
 register tDefinitions o;
 register tTree dist;
# endif
{
  if (dist->Kind == kDISTRIBUTE_DECL) {
# line 238 "Mapping.puma"
  {
# line 240 "Mapping.puma"
   if (! ((IsUnderSpecifiedDistribution (dist->DISTRIBUTE_DECL.DISTRIBUTION, dist->DISTRIBUTE_DECL.TARGET)))) goto yyL1;
  {
# line 242 "Mapping.puma"
 if (IsVarCommon (o))

     { error_protocol ("underspecified mapping not allowed for common objects");
       tree_protocol ("mapping : ", dist);
       MakeFullSpecDistFormat (dist);
       MakeFullOntoClause (dist);
     }

     else if ( (IsVarLocal (o)) || (IsVarParameter (o)) )

     { MakeFullSpecDistFormat (dist);
       MakeFullOntoClause (dist);
       tree_protocol ("full mapping of local array: ", dist);
     }

     else if (IsVarDummy (o))

     { tree_protocol ("underspecified mapping for dummy: ", dist); }

    else

     { error_protocol ("underspecified mapping for illegal object");
       tree_protocol ("full mapping : ", dist);
       MakeFullSpecDistFormat (dist);
       MakeFullOntoClause (dist);
     }

   
  }
  }
   return;
yyL1:;

# line 272 "Mapping.puma"
  {
# line 274 "Mapping.puma"
   VerifyTopologyRank (dist->DISTRIBUTE_DECL.DISTRIBUTION, dist->DISTRIBUTE_DECL.TARGET);
  }
   return;

  }
;
}

void ControlRedistributeStmt
# if defined __STDC__ | defined __cplusplus
(register tTree dist)
# else
(dist)
 register tTree dist;
# endif
{
  if (dist->Kind == kREDISTRIBUTE_STMT) {
# line 285 "Mapping.puma"
  {
# line 287 "Mapping.puma"
   if (! ((IsUnderSpecifiedDistribution (dist->REDISTRIBUTE_STMT.DISTRIBUTION, dist->REDISTRIBUTE_STMT.TARGET)))) goto yyL1;
  {
# line 289 "Mapping.puma"
   error_protocol ("underspecified mapping not allowed for REDISTRIBUTE");
  }
  }
   return;
yyL1:;

# line 292 "Mapping.puma"
  {
# line 294 "Mapping.puma"
   VerifyTopologyRank (dist->REDISTRIBUTE_STMT.DISTRIBUTION, dist->REDISTRIBUTE_STMT.TARGET);
  }
   return;

  }
;
}

static bool IsUnderSpecifiedDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree dist_spec, register tTree proc_spec)
# else
(dist_spec, proc_spec)
 register tTree dist_spec;
 register tTree proc_spec;
# endif
{
  if (proc_spec->Kind == kANY_PROCESSOR_ARRAY) {
# line 305 "Mapping.puma"
   return true;

  }
  if (dist_spec->Kind == kANY_DISTRIBUTION) {
# line 308 "Mapping.puma"
   return true;

  }
  if (dist_spec->Kind == kNODE_DISTRIBUTION) {
# line 311 "Mapping.puma"
  {
# line 312 "Mapping.puma"
   if (! ((IsUnderSpecifiedMapping (dist_spec->NODE_DISTRIBUTION.MAPPING)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

static bool IsUnderSpecifiedMapping
# if defined __STDC__ | defined __cplusplus
(register tTree mapping)
# else
(mapping)
 register tTree mapping;
# endif
{
  if (mapping->Kind == kDIST_LIST) {
# line 317 "Mapping.puma"
  {
# line 318 "Mapping.puma"
   if (! ((IsUnderSpecifiedMapping (mapping->DIST_LIST.Elem)))) goto yyL1;
  }
   return true;
yyL1:;

# line 321 "Mapping.puma"
  {
# line 322 "Mapping.puma"
   if (! ((IsUnderSpecifiedMapping (mapping->DIST_LIST.Next)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (mapping->Kind == kANY_BLOCK_DISTRIBUTION) {
# line 325 "Mapping.puma"
   return true;

  }
  if (mapping->Kind == kANY_CYCLIC_DISTRIBUTION) {
# line 328 "Mapping.puma"
   return true;

  }
  if (mapping->Kind == kANY_GEN_BLOCK_DISTRIBUTION) {
# line 331 "Mapping.puma"
   return true;

  }
  if (mapping->Kind == kANY_INDIRECT_DISTRIBUTION) {
# line 334 "Mapping.puma"
   return true;

  }
  if (mapping->Kind == kANY_DIM_DISTRIBUTION) {
# line 337 "Mapping.puma"
   return true;

  }
  return false;
}

static void MakeFullSpecDistFormat
# if defined __STDC__ | defined __cplusplus
(register tTree distribute_decl)
# else
(distribute_decl)
 register tTree distribute_decl;
# endif
{
  if (distribute_decl->Kind == kDISTRIBUTE_DECL) {
  if (distribute_decl->DISTRIBUTE_DECL.DISTRIBUTION->Kind == kANY_DISTRIBUTION) {
# line 348 "Mapping.puma"
  {
# line 350 "Mapping.puma"
 distribute_decl->DISTRIBUTE_DECL.DISTRIBUTION = mREPL_DISTRIBUTION (distribute_decl->DISTRIBUTE_DECL.DISTRIBUTION->ANY_DISTRIBUTION.is_descriptive); 
  }
   return;

  }
  if (distribute_decl->DISTRIBUTE_DECL.DISTRIBUTION->Kind == kNODE_DISTRIBUTION) {
# line 353 "Mapping.puma"
  {
# line 355 "Mapping.puma"
   MakeFullSpecifiedMapping (distribute_decl->DISTRIBUTE_DECL.DISTRIBUTION->NODE_DISTRIBUTION.MAPPING);
  }
   return;

  }
  }
;
}

static void MakeFullSpecifiedMapping
# if defined __STDC__ | defined __cplusplus
(register tTree dim_list)
# else
(dim_list)
 register tTree dim_list;
# endif
{
  if (dim_list->Kind == kDIST_LIST) {
  if (dim_list->DIST_LIST.Elem->Kind == kANY_BLOCK_DISTRIBUTION) {
# line 360 "Mapping.puma"
  {
# line 362 "Mapping.puma"
 dim_list->DIST_LIST.Elem = mBLOCK_DISTRIBUTION (mDUMMY_EXP ()); 
# line 364 "Mapping.puma"
   MakeFullSpecifiedMapping (dim_list->DIST_LIST.Next);
  }
   return;

  }
  if (dim_list->DIST_LIST.Elem->Kind == kANY_CYCLIC_DISTRIBUTION) {
# line 367 "Mapping.puma"
  {
# line 369 "Mapping.puma"
 dim_list->DIST_LIST.Elem = mCYCLIC_DISTRIBUTION (mDUMMY_EXP ()); 
# line 371 "Mapping.puma"
   MakeFullSpecifiedMapping (dim_list->DIST_LIST.Next);
  }
   return;

  }
  if (dim_list->DIST_LIST.Elem->Kind == kANY_DIM_DISTRIBUTION) {
# line 374 "Mapping.puma"
  {
# line 376 "Mapping.puma"
 dim_list->DIST_LIST.Elem = mBLOCK_DISTRIBUTION (mDUMMY_EXP ()); 
# line 378 "Mapping.puma"
   MakeFullSpecifiedMapping (dim_list->DIST_LIST.Next);
  }
   return;

  }
  if (dim_list->DIST_LIST.Elem->Kind == kANY_GEN_BLOCK_DISTRIBUTION) {
# line 381 "Mapping.puma"
  {
# line 383 "Mapping.puma"
   error_protocol ("GEN_BLOCK() not allowed here");
# line 385 "Mapping.puma"
 dim_list->DIST_LIST.Elem = mBLOCK_DISTRIBUTION (mDUMMY_EXP ()); 
# line 387 "Mapping.puma"
   MakeFullSpecifiedMapping (dim_list->DIST_LIST.Next);
  }
   return;

  }
  if (dim_list->DIST_LIST.Elem->Kind == kANY_INDIRECT_DISTRIBUTION) {
# line 390 "Mapping.puma"
  {
# line 392 "Mapping.puma"
   error_protocol ("INDIRECT() not allowed here");
# line 394 "Mapping.puma"
 dim_list->DIST_LIST.Elem = mBLOCK_DISTRIBUTION (mDUMMY_EXP ()); 
# line 396 "Mapping.puma"
   MakeFullSpecifiedMapping (dim_list->DIST_LIST.Next);
  }
   return;

  }
# line 399 "Mapping.puma"
  {
# line 401 "Mapping.puma"
   MakeFullSpecifiedMapping (dim_list->DIST_LIST.Next);
  }
   return;

  }
;
}

static void MakeFullOntoClause
# if defined __STDC__ | defined __cplusplus
(register tTree distribute_decl)
# else
(distribute_decl)
 register tTree distribute_decl;
# endif
{
  if (distribute_decl->Kind == kDISTRIBUTE_DECL) {
  if (distribute_decl->DISTRIBUTE_DECL.DISTRIBUTION->Kind == kNODE_DISTRIBUTION) {
  if (distribute_decl->DISTRIBUTE_DECL.TARGET->Kind == kANY_PROCESSOR_ARRAY) {
# line 412 "Mapping.puma"
 {
  int proc_rank;
  {
# line 415 "Mapping.puma"

# line 417 "Mapping.puma"
 proc_rank = CountMappingDistDims (distribute_decl->DISTRIBUTE_DECL.DISTRIBUTION->NODE_DISTRIBUTION.MAPPING);

    if (proc_rank > MAX_TORUS_RANK) 

      { char msg[100];
        sprintf (msg, "too many distributed dimensions (max=%d)",
                      MAX_TORUS_RANK);
        error_protocol (msg);
        proc_rank = MAX_TORUS_RANK;
      }

    distribute_decl->DISTRIBUTE_DECL.TARGET = mPROCESSOR_ARRAY (mTOP_OBJ (DefaultId()));

    SetTopologyObject (distribute_decl->DISTRIBUTE_DECL.TARGET, GetDefaultTopology (proc_rank));

  
  }
   return;
 }

  }
  }
# line 435 "Mapping.puma"
  {
# line 437 "Mapping.puma"
   VerifyTopologyRank (distribute_decl->DISTRIBUTE_DECL.DISTRIBUTION, distribute_decl->DISTRIBUTE_DECL.TARGET);
  }
   return;

  }
;
}

static int CountMappingDistDims
# if defined __STDC__ | defined __cplusplus
(register tTree mapping)
# else
(mapping)
 register tTree mapping;
# endif
{
  if (mapping->Kind == kNODE_DISTRIBUTION) {
# line 448 "Mapping.puma"
   return CountMappingDistDims (mapping->NODE_DISTRIBUTION.MAPPING);

  }
  if (mapping->Kind == kREPL_DISTRIBUTION) {
# line 453 "Mapping.puma"
   return 0;

  }
  if (mapping->Kind == kDIST_EMPTY) {
# line 458 "Mapping.puma"
   return 0;

  }
  if (mapping->Kind == kDIST_LIST) {
  if (mapping->DIST_LIST.Elem->Kind == kSERIAL_DISTRIBUTION) {
# line 462 "Mapping.puma"
   return CountMappingDistDims (mapping->DIST_LIST.Next);

  }
# line 466 "Mapping.puma"
   return CountMappingDistDims (mapping->DIST_LIST.Next) + 1;

  }
 yyAbort ("CountMappingDistDims");
}

static void VerifyTopologyRank
# if defined __STDC__ | defined __cplusplus
(register tTree dist_format, register tTree onto_clause)
# else
(dist_format, onto_clause)
 register tTree dist_format;
 register tTree onto_clause;
# endif
{
  if (dist_format->Kind == kNODE_DISTRIBUTION) {
  if (onto_clause->Kind == kPROCESSOR_ARRAY) {
# line 478 "Mapping.puma"
 {
  int dist_dims;
  int proc_rank;
  {
# line 480 "Mapping.puma"

# line 481 "Mapping.puma"

# line 483 "Mapping.puma"
 dist_dims = CountMappingDistDims (dist_format->NODE_DISTRIBUTION.MAPPING);
     proc_rank = VarRank (onto_clause->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object);

     if (proc_rank != dist_dims)
       { char msg[150];
         sprintf (msg, "processor array has rank = %d, but rank = %d expected",
                  proc_rank, dist_dims);
         error_protocol (msg);
       };
   
  }
   return;
 }

  }
  }
;
}

static void RestrictDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree layout)
# else
(layout)
 register tTree layout;
# endif
{
  if (layout->Kind == kDISTRIBUTE_DECL) {
  if (layout->DISTRIBUTE_DECL.DISTRIBUTION->Kind == kNODE_DISTRIBUTION) {
# line 509 "Mapping.puma"
  {
# line 510 "Mapping.puma"
   RestrictDistribution (layout->DISTRIBUTE_DECL.DISTRIBUTION->NODE_DISTRIBUTION.MAPPING);
  }
   return;

  }
  }
  if (layout->Kind == kREDISTRIBUTE_STMT) {
  if (layout->REDISTRIBUTE_STMT.DISTRIBUTION->Kind == kNODE_DISTRIBUTION) {
# line 513 "Mapping.puma"
  {
# line 514 "Mapping.puma"
   RestrictDistribution (layout->REDISTRIBUTE_STMT.DISTRIBUTION->NODE_DISTRIBUTION.MAPPING);
  }
   return;

  }
  }
  if (layout->Kind == kDIST_EMPTY) {
# line 517 "Mapping.puma"
   return;

  }
  if (layout->Kind == kDIST_LIST) {
  if (layout->DIST_LIST.Elem->Kind == kSERIAL_DISTRIBUTION) {
# line 520 "Mapping.puma"
  {
# line 522 "Mapping.puma"
   RestrictDistribution (layout->DIST_LIST.Next);
  }
   return;

  }
# line 525 "Mapping.puma"
  {
# line 527 "Mapping.puma"
   if (! ((CountMappingDistDims (layout->DIST_LIST.Next) >= MaxDistributedDims))) goto yyL5;
  {
# line 529 "Mapping.puma"
 layout->DIST_LIST.Elem = mSERIAL_DISTRIBUTION (); 
# line 530 "Mapping.puma"
   RestrictDistribution (layout->DIST_LIST.Next);
  }
  }
   return;
yyL5:;

  }
;
}

void BeginMapping ()
{
}

void CloseMapping ()
{
}
