# include "MapDefs.h"
# include "yyMapDefs.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 48 "MapDefs.puma"


# include <string.h>

# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "DefTable.h"
# include "Objects.h"

# include "ChangeDefs.h"   /* GetLocalVarEntity */
# include "SetDefs.h"
# include "Expressions.h"  /* ResolveExpression */

# include "Types.h"
# include "TreeOps.h"
# include "Rank.h"
# include "DerivedTypes.h"
# include "Nesting.h"

# define MODULE "MapDefs"

/*********************************************************************
*                                                                    *
*   Global structures are used to verify that no source              *
*   dimension is used more than once                                 *
*                                                                    *
*********************************************************************/

static DistributedDimensions UsedPos;

static bool IsNewSourcePosition (pos)

int pos;

{ int i, n;
  bool is_new;

  if (pos <= 0) return true;

  is_new = true;

  n = UsedPos.no_dims;

  for (i=0; i<n; i++)

    if (pos == UsedPos.DimsArray[i])

       is_new = false;

  if (is_new)

     { /* make an entry in Used Positions */

       UsedPos.DimsArray[n] = pos;
       UsedPos.no_dims      = n+1;

     }

  return (is_new);

} /* IsNewSourcePosition */



static void yyExit () { Exit (1); }

void (* MapDefs_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MapDefs, routine %s failed\n", yyFunction);
 MapDefs_Exit ();
}

void SetDistributions ARGS((tTree t, tDefinitions unit));
static void SetAnyTopology ARGS((tTree d));
void SetAlignments ARGS((tTree t, tDefinitions unit));
void MakeRedistributeDefs ARGS((tTree t));
static void SetRedistributees ARGS((tTree varlist, tTree dist_spec));
void MakeRealignDefs ARGS((tTree t));
static void SetRealignees ARGS((tTree varlist, tTree source, tTree target));
static void SetObjDistribution ARGS((tTree layout, tDefinitions obj));
static void SetObjMapping ARGS((tTree map_decl, tDefinitions obj));
static void SetObjOverlapping ARGS((tTree overlap_decl, tDefinitions obj));
static void DefineOverlap ARGS((tTree decl, tTree overlaps, bool * yyP1));
static void SetOverlapIndexes ARGS((tTree shape_specs, tTree overlaps));
static int GetTheValue ARGS((tTree t));
static void SetObjAlignment ARGS((tTree alignment, tDefinitions obj));
static void SetObjRange ARGS((tTree layout, tDefinitions obj));
static void CheckDistributee ARGS((tDefinitions distributee, tTree dspec));
static void DistributionDefs ARGS((tTree dspec, tTree top));
static void SetMappingDefs ARGS((tTree spec));
static void CheckTopology ARGS((tTree spec));
static void VerifyTopologyObject ARGS((tDefinitions obj));
static void CheckAlignee ARGS((tDefinitions alignee, tTree source, tTree target));
static void AlignmentDefs ARGS((tTree align_source, tTree align_spec));
static bool AlignSpecDefs ARGS((tTree align_spec));
static bool FittingAlignment ARGS((tTree align_sources, tTree align_subscripts));
static int FillAlignSpec ARGS((tTree t, int n));
static tTree MakeSlices ARGS((int rank));
static void CheckTargetSubscripts ARGS((tTree targets, tTree sources));
static tDefinitions GetDistributeeObj ARGS((tTree distributee));
static tDefinitions GetAligneeObj ARGS((tTree alignee));
static bool CanBeDistributed ARGS((tDefinitions obj));
static bool IsMappedTypeObj ARGS((tDefinitions obj));
static bool CanBeAligned ARGS((tDefinitions obj));
static bool IsDynamic ARGS((tDefinitions obj));
void AnalTargetExp ARGS((tTree exp, tTree free_vars, int * yyP7, bool * yyP6, tTree * yyP5, int * yyP4, tTree * yyP3, int * yyP2));
static void FindFreeVar ARGS((tTree exp, tTree free_vars, bool * yyP10, int * yyP9, tTree * yyP8));
static void ResolveFreeVar ARGS((tTree exp, tTree fvar, bool * yyP15, tTree * yyP14, int * yyP13, tTree * yyP12, int * yyP11));
static bool FreeVarInExp ARGS((tTree fvar, tTree exp));
static void MakeAlignTypes ARGS((tTree align_source));
static void MakeAlignVar ARGS((tDefinitions obj, tTree var, tDefinitions my_unit));

void SetDistributions
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions unit)
# else
(t, unit)
 register tTree t;
 register tDefinitions unit;
# endif
{
  if (t->Kind == kDECL_LIST) {
# line 137 "MapDefs.puma"
  {
# line 139 "MapDefs.puma"
   set_protocol_stmt (t->DECL_LIST.Elem);
# line 141 "MapDefs.puma"
   SetDistributions (t->DECL_LIST.Elem, unit);
# line 142 "MapDefs.puma"
   SetDistributions (t->DECL_LIST.Next, unit);
  }
   return;

  }
  if (t->Kind == kDISTRIBUTE_DECL) {
# line 145 "MapDefs.puma"
 {
  tDefinitions Obj;
  {
# line 147 "MapDefs.puma"
   SetAnyTopology (t);
# line 149 "MapDefs.puma"

# line 151 "MapDefs.puma"
   Obj = GetLocalVarEntity (t->DISTRIBUTE_DECL.Ident, t->DISTRIBUTE_DECL.Line, unit);
# line 153 "MapDefs.puma"
 if (IsMappedTypeObj (Obj))
        error_protocol ("variable cannot be mapped (explicitly mapped type)");
      else if (!CanBeDistributed (Obj))
        error_protocol ("this entity cannot be distributed");
   
# line 159 "MapDefs.puma"
   DistributionDefs (t->DISTRIBUTE_DECL.DISTRIBUTION, t->DISTRIBUTE_DECL.TARGET);
# line 160 "MapDefs.puma"
   CheckDistributee (Obj, t->DISTRIBUTE_DECL.DISTRIBUTION);
# line 162 "MapDefs.puma"
   SetObjDistribution (t, Obj);
  }
   return;
 }

  }
  if (t->Kind == kMAP_DECL) {
# line 165 "MapDefs.puma"
  {
# line 167 "MapDefs.puma"
   SetObjMapping (t, GetLocalVarEntity (t->MAP_DECL.Ident, t->MAP_DECL.Line, unit));
  }
   return;

  }
  if (t->Kind == kOVERLAP_DECL) {
# line 170 "MapDefs.puma"
  {
# line 172 "MapDefs.puma"
   SetObjOverlapping (t, GetLocalVarEntity (t->OVERLAP_DECL.Ident, t->OVERLAP_DECL.Line, unit));
  }
   return;

  }
  if (t->Kind == kINHERIT_DECL) {
# line 175 "MapDefs.puma"
   return;

  }
  if (t->Kind == kRANGE_DECL) {
  if (t->RANGE_DECL.RANGES->Kind == kRANGE_LIST) {
  if (t->RANGE_DECL.RANGES->RANGE_LIST.Next->Kind == kRANGE_EMPTY) {
# line 178 "MapDefs.puma"
 {
  tDefinitions Obj;
  {
# line 180 "MapDefs.puma"

# line 182 "MapDefs.puma"
   Obj = GetLocalVarEntity (t->RANGE_DECL.Ident, t->RANGE_DECL.Line, unit);
# line 184 "MapDefs.puma"
 if (!CanBeDistributed (Obj))
        error_protocol ("this entity cannot be distributed");
   
# line 188 "MapDefs.puma"
   DistributionDefs (t->RANGE_DECL.RANGES->RANGE_LIST.Elem, NoTree);
# line 189 "MapDefs.puma"
   CheckDistributee (Obj, t->RANGE_DECL.RANGES->RANGE_LIST.Elem);
# line 191 "MapDefs.puma"
   SetObjRange (t, Obj);
  }
   return;
 }

  }
  }
# line 194 "MapDefs.puma"
  {
# line 196 "MapDefs.puma"
   error_protocol ("RANGE directive can contain only one range");
  }
   return;

  }
# line 199 "MapDefs.puma"
   return;

;
}

static void SetAnyTopology
# if defined __STDC__ | defined __cplusplus
(register tTree d)
# else
(d)
 register tTree d;
# endif
{
  if (d->Kind == kDISTRIBUTE_DECL) {
  if (d->DISTRIBUTE_DECL.TARGET->Kind == kPROCESSOR_ARRAY) {
# line 206 "MapDefs.puma"
  {
# line 208 "MapDefs.puma"
   if (! ((d->DISTRIBUTE_DECL.TARGET->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Ident == DefaultId ()))) goto yyL1;
  {
# line 210 "MapDefs.puma"
 d->DISTRIBUTE_DECL.TARGET = mDEFAULT_PROCESSOR_ARRAY (); 
  }
  }
   return;
yyL1:;

  }
  }
  if (d->Kind == kREDISTRIBUTE_STMT) {
  if (d->REDISTRIBUTE_STMT.TARGET->Kind == kPROCESSOR_ARRAY) {
# line 213 "MapDefs.puma"
  {
# line 215 "MapDefs.puma"
   if (! ((d->REDISTRIBUTE_STMT.TARGET->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Ident == DefaultId ()))) goto yyL2;
  {
# line 217 "MapDefs.puma"
 d->REDISTRIBUTE_STMT.TARGET = mDEFAULT_PROCESSOR_ARRAY (); 
  }
  }
   return;
yyL2:;

  }
  }
;
}

void SetAlignments
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions unit)
# else
(t, unit)
 register tTree t;
 register tDefinitions unit;
# endif
{
  if (t->Kind == kDECL_LIST) {
# line 230 "MapDefs.puma"
  {
# line 232 "MapDefs.puma"
   set_protocol_stmt (t->DECL_LIST.Elem);
# line 233 "MapDefs.puma"
   SetAlignments (t->DECL_LIST.Elem, unit);
# line 234 "MapDefs.puma"
   SetAlignments (t->DECL_LIST.Next, unit);
  }
   return;

  }
  if (t->Kind == kALIGN_DECL) {
# line 237 "MapDefs.puma"
 {
  tDefinitions Obj;
  {
# line 239 "MapDefs.puma"

# line 241 "MapDefs.puma"
   Obj = GetLocalVarEntity (t->ALIGN_DECL.Ident, t->ALIGN_DECL.Line, unit);
# line 245 "MapDefs.puma"
 if (IsMappedTypeObj (Obj))
        error_protocol ("variable cannot be mapped (explicitly mapped type)");
     if (TreeListLength (t->ALIGN_DECL.ALIGN_SOURCE) == 0)
        t->ALIGN_DECL.ALIGN_SOURCE = MakeSlices (VarRank (Obj));
   
# line 251 "MapDefs.puma"
   AlignmentDefs (t->ALIGN_DECL.ALIGN_SOURCE, t->ALIGN_DECL.ALIGN_TARGET);
# line 252 "MapDefs.puma"
   CheckAlignee (Obj, t->ALIGN_DECL.ALIGN_SOURCE, t->ALIGN_DECL.ALIGN_TARGET);
# line 254 "MapDefs.puma"
   SetObjAlignment (t, GetLocalVarEntity (t->ALIGN_DECL.Ident, t->ALIGN_DECL.Line, unit));
  }
   return;
 }

  }
  if (t->Kind == kTYPE_DECL) {
  if (t->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
# line 257 "MapDefs.puma"
 {
  tDefinitions Obj;
  {
# line 259 "MapDefs.puma"
   if (! ((0 == 1))) goto yyL3;
  {
# line 261 "MapDefs.puma"

# line 263 "MapDefs.puma"
   Obj = GetLocalObject (t->TYPE_DECL.Ident);
# line 265 "MapDefs.puma"
   OpenScope (Obj->TypeObject.Components);
# line 266 "MapDefs.puma"
   SetAlignments (t->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS, Obj);
# line 267 "MapDefs.puma"
   CloseScope ();
  }
  }
   return;
 }
yyL3:;

  }
  }
# line 270 "MapDefs.puma"
   return;

;
}

void MakeRedistributeDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kREDISTRIBUTE_STMT) {
# line 285 "MapDefs.puma"
  {
# line 287 "MapDefs.puma"
   SetAnyTopology (t);
# line 289 "MapDefs.puma"
   DistributionDefs (t->REDISTRIBUTE_STMT.DISTRIBUTION, t->REDISTRIBUTE_STMT.TARGET);
# line 290 "MapDefs.puma"
   SetRedistributees (t->REDISTRIBUTE_STMT.DISTRIBUTEE, t->REDISTRIBUTE_STMT.DISTRIBUTION);
  }
   return;

  }
# line 293 "MapDefs.puma"
  {
# line 295 "MapDefs.puma"
   failure_protocol (MODULE, "MakeRedistributeDefs", t);
  }
   return;

;
}

static void SetRedistributees
# if defined __STDC__ | defined __cplusplus
(register tTree varlist, register tTree dist_spec)
# else
(varlist, dist_spec)
 register tTree varlist;
 register tTree dist_spec;
# endif
{
  if (varlist->Kind == kBTV_LIST) {
# line 300 "MapDefs.puma"
  {
# line 302 "MapDefs.puma"
   SetRedistributees (varlist->BTV_LIST.Elem, dist_spec);
# line 303 "MapDefs.puma"
   SetRedistributees (varlist->BTV_LIST.Next, dist_spec);
  }
   return;

  }
  if (varlist->Kind == kBTV_EMPTY) {
# line 306 "MapDefs.puma"
   return;

  }
  if (varlist->Kind == kUSED_VAR) {
# line 309 "MapDefs.puma"
 {
  tDefinitions Obj;
  {
# line 311 "MapDefs.puma"

# line 313 "MapDefs.puma"
   Obj = GetDistributeeObj (varlist);
# line 315 "MapDefs.puma"
   CheckDistributee (Obj, dist_spec);
  }
   return;
 }

  }
;
}

void MakeRealignDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kREALIGN_STMT) {
# line 326 "MapDefs.puma"
  {
# line 328 "MapDefs.puma"
   if (! ((t->REALIGN_STMT.ALIGN_TARGET->ALIGN_SPEC.is_descriptive != 0))) goto yyL1;
  {
# line 330 "MapDefs.puma"
   error_protocol ("align_spec in REALIGN must not begin with *");
  }
  }
   return;
yyL1:;

  if (t->REALIGN_STMT.ALIGNEE->Kind == kBTV_LIST) {
  if (t->REALIGN_STMT.ALIGN_SOURCE->Kind == kBTE_EMPTY) {
# line 335 "MapDefs.puma"
  {
# line 340 "MapDefs.puma"
 t->REALIGN_STMT.ALIGN_SOURCE = MakeSlices (TreeRank (t->REALIGN_STMT.ALIGNEE->BTV_LIST.Elem)); 
# line 342 "MapDefs.puma"
   if (! ((TreeRank (t->REALIGN_STMT.ALIGNEE->BTV_LIST.Elem) > 0))) goto yyL2;
  {
# line 344 "MapDefs.puma"
   MakeRealignDefs (t);
  }
  }
   return;
yyL2:;

  }
  }
# line 347 "MapDefs.puma"
  {
# line 349 "MapDefs.puma"
   AlignmentDefs (t->REALIGN_STMT.ALIGN_SOURCE, t->REALIGN_STMT.ALIGN_TARGET);
# line 350 "MapDefs.puma"
   SetRealignees (t->REALIGN_STMT.ALIGNEE, t->REALIGN_STMT.ALIGN_SOURCE, t->REALIGN_STMT.ALIGN_TARGET);
  }
   return;

  }
# line 353 "MapDefs.puma"
  {
# line 354 "MapDefs.puma"
   failure_protocol (MODULE, "MakeRealignDefs", t);
  }
   return;

;
}

static void SetRealignees
# if defined __STDC__ | defined __cplusplus
(register tTree varlist, register tTree source, register tTree target)
# else
(varlist, source, target)
 register tTree varlist;
 register tTree source;
 register tTree target;
# endif
{
  if (varlist->Kind == kBTV_LIST) {
# line 359 "MapDefs.puma"
  {
# line 361 "MapDefs.puma"
   SetRealignees (varlist->BTV_LIST.Elem, source, target);
# line 362 "MapDefs.puma"
   SetRealignees (varlist->BTV_LIST.Next, source, target);
  }
   return;

  }
  if (varlist->Kind == kBTV_EMPTY) {
# line 365 "MapDefs.puma"
   return;

  }
  if (varlist->Kind == kUSED_VAR) {
# line 368 "MapDefs.puma"
 {
  tDefinitions Obj;
  {
# line 370 "MapDefs.puma"

# line 372 "MapDefs.puma"
   Obj = GetAligneeObj (varlist);
# line 374 "MapDefs.puma"
   CheckAlignee (Obj, source, target);
  }
   return;
 }

  }
# line 377 "MapDefs.puma"
  {
# line 379 "MapDefs.puma"
   failure_protocol (MODULE, "SetRealignees", varlist);
  }
   return;

;
}

static void SetObjDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree layout, register tDefinitions obj)
# else
(layout, obj)
 register tTree layout;
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
# line 398 "MapDefs.puma"
  {
# line 400 "MapDefs.puma"
   if (! ((obj->VarObject.Dist->Distribution.inherited))) goto yyL1;
  {
# line 401 "MapDefs.puma"
   error_protocol ("DISTRIBUTE not possible for object with INHERIT");
  }
  }
   return;
yyL1:;

  }
# line 404 "MapDefs.puma"
  {
# line 406 "MapDefs.puma"
   if (! ((IsVarAssumedSize (obj)))) goto yyL2;
  {
# line 407 "MapDefs.puma"
   error_protocol ("no explicit mapping for assumed size arrays");
  }
  }
   return;
yyL2:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Kind == kDefaultDistribution) {
# line 410 "MapDefs.puma"
  {
# line 412 "MapDefs.puma"
 obj->VarObject.Dist = mDeclDistribution (obj->VarObject.Dist->DefaultDistribution.dynamic, obj->VarObject.Dist->DefaultDistribution.shared, obj->VarObject.Dist->DefaultDistribution.inherited, layout); 
  }
   return;

  }
# line 415 "MapDefs.puma"
  {
# line 417 "MapDefs.puma"
   error_protocol ("variable is already distributed");
# line 418 "MapDefs.puma"
   obj_protocol ("variable object : ", obj);
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
  if (obj->TemplateObject.Dist->Kind == kDefaultDistribution) {
# line 421 "MapDefs.puma"
  {
# line 423 "MapDefs.puma"
 obj->TemplateObject.Dist = mDeclDistribution (obj->TemplateObject.Dist->DefaultDistribution.dynamic, obj->TemplateObject.Dist->DefaultDistribution.shared, obj->TemplateObject.Dist->DefaultDistribution.inherited, layout); 
  }
   return;

  }
# line 426 "MapDefs.puma"
  {
# line 428 "MapDefs.puma"
   error_protocol ("template is already distributed");
# line 429 "MapDefs.puma"
   obj_protocol ("template object : ", obj);
  }
   return;

  }
# line 432 "MapDefs.puma"
  {
# line 434 "MapDefs.puma"
   error_protocol ("distributed object no variable/template");
# line 435 "MapDefs.puma"
   obj_protocol ("object is : ", obj);
  }
   return;

;
}

static void SetObjMapping
# if defined __STDC__ | defined __cplusplus
(register tTree map_decl, register tDefinitions obj)
# else
(map_decl, obj)
 register tTree map_decl;
 register tDefinitions obj;
# endif
{
# line 446 "MapDefs.puma"
  {
# line 447 "MapDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 448 "MapDefs.puma"
   tree_error_protocol ("mapping: unknown object:", map_decl);
  }
  }
   return;
yyL1:;

  if (map_decl->Kind == kMAP_DECL) {
  if (obj->Kind == kTopologyObject) {
# line 451 "MapDefs.puma"
  {
# line 452 "MapDefs.puma"
   if (! ((obj->TopologyObject.target == NoTree))) goto yyL2;
  {
# line 453 "MapDefs.puma"
 obj->TopologyObject.target =  map_decl->MAP_DECL.MAP_TARGET; 
# line 454 "MapDefs.puma"
   obj_protocol ("processor array has been mapped", obj);
  }
  }
   return;
yyL2:;

  }
  }
  if (obj->Kind == kTopologyObject) {
# line 457 "MapDefs.puma"
  {
# line 458 "MapDefs.puma"
   error_protocol ("map directive used more than once for same object");
# line 459 "MapDefs.puma"
   obj_protocol ("this processor array is already mapped", obj);
  }
   return;

  }
# line 462 "MapDefs.puma"
  {
# line 463 "MapDefs.puma"
   error_protocol ("map directive only for PROCESSORS objects");
# line 464 "MapDefs.puma"
   obj_protocol ("mapped object no processor array/topology", obj);
  }
   return;

;
}

static void SetObjOverlapping
# if defined __STDC__ | defined __cplusplus
(register tTree overlap_decl, register tDefinitions obj)
# else
(overlap_decl, obj)
 register tTree overlap_decl;
 register tDefinitions obj;
# endif
{
# line 475 "MapDefs.puma"
  {
# line 476 "MapDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 477 "MapDefs.puma"
   tree_error_protocol ("overlapping: unknown object:", overlap_decl);
  }
  }
   return;
yyL1:;

  if (overlap_decl->Kind == kOVERLAP_DECL) {
  if (obj->Kind == kVarObject) {
# line 480 "MapDefs.puma"
 {
  bool yyV1;
  {
# line 482 "MapDefs.puma"
   if (! ((! IsVarOverlapped (obj)))) goto yyL2;
  {
# line 483 "MapDefs.puma"
   DefineOverlap (obj->VarObject.decl, overlap_decl->OVERLAP_DECL.OVERLAPS, & yyV1);
# line 484 "MapDefs.puma"
 if (yyV1)
        obj_protocol ("array got an overlap", obj);
      else
        obj_protocol ("illegal variable is ", obj);
   
  }
  }
   return;
 }
yyL2:;

  }
  }
  if (obj->Kind == kVarObject) {
# line 491 "MapDefs.puma"
  {
# line 492 "MapDefs.puma"
   error_protocol ("overrides existing overlap");
# line 493 "MapDefs.puma"
   obj_protocol ("this array has already an overlapping", obj);
  }
   return;

  }
# line 496 "MapDefs.puma"
  {
# line 497 "MapDefs.puma"
   error_protocol ("shadow for an illegal object");
# line 498 "MapDefs.puma"
   obj_protocol ("illegal object is not array", obj);
  }
   return;

;
}

static void DefineOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tTree overlaps, register bool * yyP1)
# else
(decl, overlaps, yyP1)
 register tTree decl;
 register tTree overlaps;
 register bool * yyP1;
# endif
{
  if (decl->Kind == kVAR_DECL) {
  if (decl->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 503 "MapDefs.puma"
 {
  bool yyV1;
  {
# line 504 "MapDefs.puma"
   DefineOverlap (decl->VAR_DECL.VAL, overlaps, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
# line 520 "MapDefs.puma"
  {
# line 521 "MapDefs.puma"
   error_protocol ("overlap variable is not an array");
  }
   * yyP1 = false;
   return;

  }
  if (decl->Kind == kVAR_PARAM_DECL) {
  if (decl->VAR_PARAM_DECL.VAL->Kind == kARRAY_TYPE) {
# line 507 "MapDefs.puma"
 {
  bool yyV1;
  {
# line 508 "MapDefs.puma"
   DefineOverlap (decl->VAR_PARAM_DECL.VAL, overlaps, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
# line 524 "MapDefs.puma"
  {
# line 525 "MapDefs.puma"
   error_protocol ("overlap variable is not an array");
  }
   * yyP1 = false;
   return;

  }
  if (decl->Kind == kARRAY_TYPE) {
# line 511 "MapDefs.puma"
  {
# line 512 "MapDefs.puma"
   if (! ((TreeListLength (decl->ARRAY_TYPE.ARRAY_INDEX_TYPES) == TreeListLength (overlaps)))) goto yyL3;
  {
# line 513 "MapDefs.puma"
   SetOverlapIndexes (decl->ARRAY_TYPE.ARRAY_INDEX_TYPES, overlaps);
  }
  }
   * yyP1 = true;
   return;
yyL3:;

# line 516 "MapDefs.puma"
  {
# line 517 "MapDefs.puma"
   error_protocol ("rank mismatch for overlapping");
  }
   * yyP1 = false;
   return;

  }
;
}

static void SetOverlapIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree shape_specs, register tTree overlaps)
# else
(shape_specs, overlaps)
 register tTree shape_specs;
 register tTree overlaps;
# endif
{
  if (shape_specs->Kind == kSHAPE_LIST) {
  if (overlaps->Kind == kSHAPE_LIST) {
# line 536 "MapDefs.puma"
  {
# line 537 "MapDefs.puma"
   SetOverlapIndexes (shape_specs->SHAPE_LIST.Elem, overlaps->SHAPE_LIST.Elem);
# line 538 "MapDefs.puma"
   SetOverlapIndexes (shape_specs->SHAPE_LIST.Next, overlaps->SHAPE_LIST.Next);
  }
   return;

  }
  }
  if (shape_specs->Kind == kSHAPE_EMPTY) {
  if (overlaps->Kind == kSHAPE_EMPTY) {
# line 541 "MapDefs.puma"
   return;

  }
  }
  if (Tree_IsType (shape_specs, kSHAPE_SPEC)) {
  if (overlaps->Kind == kEXPLICIT_SHAPE) {
# line 544 "MapDefs.puma"
  {
# line 547 "MapDefs.puma"
 shape_specs->SHAPE_SPEC.Overlap->OVERLAP_SPEC.left_size = GetTheValue (overlaps->EXPLICIT_SHAPE.LOWER);
     shape_specs->SHAPE_SPEC.Overlap->OVERLAP_SPEC.right_size = GetTheValue (overlaps->EXPLICIT_SHAPE.UPPER);
   
  }
   return;

  }
  }
;
}

static int GetTheValue
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 554 "MapDefs.puma"
 {
  bool found;
  int val;
  {
# line 555 "MapDefs.puma"

# line 556 "MapDefs.puma"

# line 557 "MapDefs.puma"
   GetIntConstValue (t, & found, & val);
# line 558 "MapDefs.puma"
   if (! ((found))) goto yyL1;
  }
  {
   return val;
  }
 }
yyL1:;

# line 562 "MapDefs.puma"
  {
# line 563 "MapDefs.puma"
   error_protocol ("size of overlap area not known at compile-time");
  }
   return 0;

}

static void SetObjAlignment
# if defined __STDC__ | defined __cplusplus
(register tTree alignment, register tDefinitions obj)
# else
(alignment, obj)
 register tTree alignment;
 register tDefinitions obj;
# endif
{
# line 575 "MapDefs.puma"
  {
# line 577 "MapDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 578 "MapDefs.puma"
   error_protocol ("alignment for unknown entity");
  }
  }
   return;
yyL1:;

# line 581 "MapDefs.puma"
  {
# line 583 "MapDefs.puma"
   if (! ((IsVarAssumedSize (obj)))) goto yyL2;
  {
# line 584 "MapDefs.puma"
   error_protocol ("no explicit mapping for assumed size arrays");
  }
  }
   return;
yyL2:;

  if (obj->Kind == kVarObject) {
# line 587 "MapDefs.puma"
  {
# line 589 "MapDefs.puma"
   if (! ((obj->VarObject.Dist->Distribution.inherited))) goto yyL3;
  {
# line 590 "MapDefs.puma"
   error_protocol ("ALIGN not possible for object with INHERIT");
  }
  }
   return;
yyL3:;

  if (obj->VarObject.Dist->Kind == kDefaultDistribution) {
# line 593 "MapDefs.puma"
  {
# line 595 "MapDefs.puma"
 obj->VarObject.Dist = mDeclDistribution (obj->VarObject.Dist->DefaultDistribution.dynamic, obj->VarObject.Dist->DefaultDistribution.shared, obj->VarObject.Dist->DefaultDistribution.inherited, alignment); 
  }
   return;

  }
# line 598 "MapDefs.puma"
  {
# line 600 "MapDefs.puma"
   error_protocol ("variable is already distributed/aligned");
# line 601 "MapDefs.puma"
   obj_protocol ("variable object : ", obj);
  }
   return;

  }
# line 604 "MapDefs.puma"
  {
# line 606 "MapDefs.puma"
   error_protocol ("object cannot be aligned");
# line 607 "MapDefs.puma"
   tree_protocol ("align : ", alignment);
# line 608 "MapDefs.puma"
   obj_protocol ("alignee obj is : ", obj);
  }
   return;

;
}

static void SetObjRange
# if defined __STDC__ | defined __cplusplus
(register tTree layout, register tDefinitions obj)
# else
(layout, obj)
 register tTree layout;
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
# line 619 "MapDefs.puma"
  {
# line 621 "MapDefs.puma"
   if (! ((! obj->VarObject.Dist->Distribution.inherited))) goto yyL1;
  {
# line 623 "MapDefs.puma"
   error_protocol ("RANGE directive only for inherited variables");
  }
  }
   return;
yyL1:;

  if (obj->VarObject.Dist->Kind == kDefaultDistribution) {
# line 626 "MapDefs.puma"
  {
# line 628 "MapDefs.puma"
 obj->VarObject.Dist = mDeclDistribution (obj->VarObject.Dist->DefaultDistribution.dynamic, obj->VarObject.Dist->DefaultDistribution.shared, obj->VarObject.Dist->DefaultDistribution.inherited, layout); 
  }
   return;

  }
# line 631 "MapDefs.puma"
  {
# line 633 "MapDefs.puma"
   error_protocol ("variable is already distributed");
# line 634 "MapDefs.puma"
   obj_protocol ("variable object : ", obj);
  }
   return;

  }
# line 637 "MapDefs.puma"
  {
# line 639 "MapDefs.puma"
   error_protocol ("ranged object no variable");
# line 640 "MapDefs.puma"
   obj_protocol ("object is : ", obj);
  }
   return;

;
}

static void CheckDistributee
# if defined __STDC__ | defined __cplusplus
(register tDefinitions distributee, register tTree dspec)
# else
(distributee, dspec)
 register tDefinitions distributee;
 register tTree dspec;
# endif
{
# line 651 "MapDefs.puma"
  {
# line 653 "MapDefs.puma"
   if (! ((distributee == NoObject))) goto yyL1;
  }
   return;
yyL1:;

# line 656 "MapDefs.puma"
  {
# line 658 "MapDefs.puma"
   if (! ((! CanBeDistributed (distributee)))) goto yyL2;
  }
   return;
yyL2:;

  if (dspec->Kind == kNODE_DISTRIBUTION) {
# line 661 "MapDefs.puma"
  {
# line 663 "MapDefs.puma"
   if (! ((TreeListLength (dspec->NODE_DISTRIBUTION.MAPPING) != VarRank (distributee)))) goto yyL3;
  {
# line 664 "MapDefs.puma"
   error_protocol ("illegal distribution (rank!)");
# line 665 "MapDefs.puma"
   obj_protocol ("this is the distributed object", distributee);
  }
  }
   return;
yyL3:;

  }
;
}

static void DistributionDefs
# if defined __STDC__ | defined __cplusplus
(register tTree dspec, register tTree top)
# else
(dspec, top)
 register tTree dspec;
 register tTree top;
# endif
{
  if (dspec->Kind == kNODE_DISTRIBUTION) {
# line 670 "MapDefs.puma"
  {
# line 672 "MapDefs.puma"
   SetMappingDefs (dspec->NODE_DISTRIBUTION.MAPPING);
# line 673 "MapDefs.puma"
   CheckTopology (top);
  }
   return;

  }
  if (dspec->Kind == kDEFAULT_DISTRIBUTION) {
# line 676 "MapDefs.puma"
  {
# line 678 "MapDefs.puma"
   CheckTopology (top);
  }
   return;

  }
  if (dspec->Kind == kSERIAL_DISTRIBUTION) {
# line 681 "MapDefs.puma"
   return;

  }
;
}

static void SetMappingDefs
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{

  switch (spec->Kind) {
  case kDIST_EMPTY:
# line 694 "MapDefs.puma"
   return;

  case kDIST_LIST:
# line 697 "MapDefs.puma"
  {
# line 698 "MapDefs.puma"
   SetMappingDefs (spec->DIST_LIST.Elem);
# line 699 "MapDefs.puma"
   SetMappingDefs (spec->DIST_LIST.Next);
  }
   return;

  case kBLOCK_DISTRIBUTION:
# line 702 "MapDefs.puma"
  {
# line 704 "MapDefs.puma"
 spec->BLOCK_DISTRIBUTION.SIZE = CheckExp (spec->BLOCK_DISTRIBUTION.SIZE); 
  }
   return;

  case kCYCLIC_DISTRIBUTION:
# line 707 "MapDefs.puma"
  {
# line 709 "MapDefs.puma"
 spec->CYCLIC_DISTRIBUTION.SIZE = CheckExp (spec->CYCLIC_DISTRIBUTION.SIZE); 
  }
   return;

  case kGEN_BLOCK_DISTRIBUTION:
# line 712 "MapDefs.puma"
  {
# line 714 "MapDefs.puma"
   MakeVarDefs (spec->GEN_BLOCK_DISTRIBUTION.ARRAY);
  }
   return;

  case kINDIRECT_DISTRIBUTION:
# line 717 "MapDefs.puma"
  {
# line 719 "MapDefs.puma"
   MakeVarDefs (spec->INDIRECT_DISTRIBUTION.ARRAY);
  }
   return;

  case kARBITRARY_DISTRIBUTION:
# line 722 "MapDefs.puma"
  {
# line 724 "MapDefs.puma"
 spec->ARBITRARY_DISTRIBUTION.SIZE = CheckExp (spec->ARBITRARY_DISTRIBUTION.SIZE); 
# line 726 "MapDefs.puma"
   MakeVarDefs (spec->ARBITRARY_DISTRIBUTION.LENGTH);
# line 727 "MapDefs.puma"
   MakeVarDefs (spec->ARBITRARY_DISTRIBUTION.MAP);
  }
   return;

  case kSERIAL_DISTRIBUTION:
# line 730 "MapDefs.puma"
   return;

  case kANY_BLOCK_DISTRIBUTION:
# line 733 "MapDefs.puma"
   return;

  case kANY_CYCLIC_DISTRIBUTION:
# line 736 "MapDefs.puma"
   return;

  case kANY_GEN_BLOCK_DISTRIBUTION:
# line 739 "MapDefs.puma"
   return;

  case kANY_INDIRECT_DISTRIBUTION:
# line 742 "MapDefs.puma"
   return;

  case kANY_ARBITRARY_DISTRIBUTION:
# line 745 "MapDefs.puma"
   return;

  case kANY_DIM_DISTRIBUTION:
# line 748 "MapDefs.puma"
   return;

  }

# line 751 "MapDefs.puma"
  {
# line 752 "MapDefs.puma"
   failure_protocol (MODULE, "SetMappingDefs", spec);
  }
   return;

;
}

static void CheckTopology
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
# line 763 "MapDefs.puma"
  {
# line 764 "MapDefs.puma"
   if (! ((spec == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (spec->Kind == kANY_PROCESSOR_ARRAY) {
# line 767 "MapDefs.puma"
   return;

  }
  if (spec->Kind == kDEFAULT_PROCESSOR_ARRAY) {
# line 770 "MapDefs.puma"
   return;

  }
  if (spec->Kind == kPROCESSOR_ARRAY) {
# line 773 "MapDefs.puma"
  {
# line 775 "MapDefs.puma"
   MakeTopologyDef (spec);
  }
   return;

  }
  if (spec->Kind == kPROCESSOR_SUBSET) {
# line 778 "MapDefs.puma"
  {
# line 780 "MapDefs.puma"
   MakeTopologyDef (spec);
  }
   return;

  }
# line 783 "MapDefs.puma"
  {
# line 785 "MapDefs.puma"
   failure_protocol (MODULE, "CheckTopology", spec);
  }
   return;

;
}

static void VerifyTopologyObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 796 "MapDefs.puma"
  {
# line 798 "MapDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 799 "MapDefs.puma"
   error_protocol ("processor array not defined\n");
  }
  }
   return;
yyL1:;

  if (obj->Kind == kTopologyObject) {
# line 802 "MapDefs.puma"
   return;

  }
# line 807 "MapDefs.puma"
  {
# line 809 "MapDefs.puma"
   error_protocol ("distribute onto an object that is no processor array");
# line 810 "MapDefs.puma"
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

static void CheckAlignee
# if defined __STDC__ | defined __cplusplus
(register tDefinitions alignee, register tTree source, register tTree target)
# else
(alignee, source, target)
 register tDefinitions alignee;
 register tTree source;
 register tTree target;
# endif
{
# line 821 "MapDefs.puma"
  {
# line 823 "MapDefs.puma"
   if (! ((alignee == NoObject))) goto yyL1;
  }
   return;
yyL1:;

# line 826 "MapDefs.puma"
  {
# line 828 "MapDefs.puma"
   if (! ((TreeListLength (source) != VarRank (alignee)))) goto yyL2;
  {
# line 830 "MapDefs.puma"
   error_protocol ("rank error for align_source_list");
  }
  }
   return;
yyL2:;

  if (target->Kind == kALIGN_SPEC) {
# line 833 "MapDefs.puma"
  {
# line 835 "MapDefs.puma"
   if (! ((target->ALIGN_SPEC.is_descriptive))) goto yyL3;
  {
# line 836 "MapDefs.puma"
   if (! ((! IsVarDummy (alignee)))) goto yyL3;
  {
# line 838 "MapDefs.puma"
   error_protocol ("alignee must be a dummy argument");
# line 840 "MapDefs.puma"
   goto yyL3;
  }
  }
  }
yyL3:;

  }
;
}

static void AlignmentDefs
# if defined __STDC__ | defined __cplusplus
(register tTree align_source, register tTree align_spec)
# else
(align_source, align_spec)
 register tTree align_source;
 register tTree align_spec;
# endif
{
  if (align_spec->Kind == kALIGN_SPEC) {
# line 846 "MapDefs.puma"
  {
# line 848 "MapDefs.puma"
   if (! ((AlignSpecDefs (align_spec)))) goto yyL1;
  {
# line 850 "MapDefs.puma"
   if (! ((FittingAlignment (align_source, align_spec->ALIGN_SPEC.SUBSCRIPTS)))) goto yyL1;
  {
# line 852 "MapDefs.puma"
   MakeAlignTypes (align_source);
# line 856 "MapDefs.puma"
 UsedPos.no_dims = 0;   
     CheckTargetSubscripts (align_spec->ALIGN_SPEC.SUBSCRIPTS, align_source);
   
  }
  }
  }
   return;
yyL1:;

  }
;
}

static bool AlignSpecDefs
# if defined __STDC__ | defined __cplusplus
(register tTree align_spec)
# else
(align_spec)
 register tTree align_spec;
# endif
{
  if (align_spec->Kind == kALIGN_SPEC) {
# line 873 "MapDefs.puma"
 {
  tDefinitions TObj;
  int len;
  bool okay;
  {
# line 875 "MapDefs.puma"

# line 876 "MapDefs.puma"

# line 877 "MapDefs.puma"

# line 879 "MapDefs.puma"
   MakeIndexDefs (align_spec->ALIGN_SPEC.SUBSCRIPTS);
# line 881 "MapDefs.puma"
 TObj = GetGlobalObject (align_spec->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Ident);
     okay = false;
     len  = TreeListLength (align_spec->ALIGN_SPEC.SUBSCRIPTS);

     if (TObj == NoObject)

        { char tname [MAXID_LENGTH];
          char msg   [MAX_LINE_LENGTH];
          GetString (align_spec->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Ident, tname);
          sprintf (msg, "align target %s is undefined entity", tname);
          error_protocol (msg);
        }

      else if (!CanBeDistributed (TObj))
        error_protocol ("cannot align to such an object");
      else if (IsOptional (TObj))
        error_protocol ("align target may not have the OPTIONAL attribute");
      else if (len == 0)
        { align_spec->ALIGN_SPEC.SUBSCRIPTS = MakeSlices (VarRank (TObj));
          okay = true;
        }
      else if (len != VarRank (TObj))
        error_protocol ("illegal target in alignment (rank!)");
      else
        okay = true;

     align_spec->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Object = TObj;

   
  }
  {
   return okay;
  }
 }

  }
 yyAbort ("AlignSpecDefs");
}

static bool FittingAlignment
# if defined __STDC__ | defined __cplusplus
(register tTree align_sources, register tTree align_subscripts)
# else
(align_sources, align_subscripts)
 register tTree align_sources;
 register tTree align_subscripts;
# endif
{
# line 927 "MapDefs.puma"

char msg[40];

# line 931 "MapDefs.puma"
 {
  int n1;
  int n2;
  {
# line 933 "MapDefs.puma"

# line 934 "MapDefs.puma"

# line 936 "MapDefs.puma"
   n1 = FillAlignSpec (align_sources, 0);
# line 937 "MapDefs.puma"
   n2 = FillAlignSpec (align_subscripts, 0);
# line 939 "MapDefs.puma"
   if (! ((n1 != n2))) goto yyL1;
  {
# line 940 "MapDefs.puma"
   error_protocol ("alignment has mismatch of source/target");
# line 941 "MapDefs.puma"
   sprintf (msg, "source spec has %d free vars: ", n1);
# line 942 "MapDefs.puma"
   tree_protocol (msg, align_sources);
# line 943 "MapDefs.puma"
   sprintf (msg, "target spec has %d free vars: ", n2);
# line 944 "MapDefs.puma"
   tree_protocol (msg, align_subscripts);
  }
  }
  {
   return false;
  }
 }
yyL1:;

# line 948 "MapDefs.puma"
   return true;

}

static int FillAlignSpec
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int n)
# else
(t, n)
 register tTree t;
 register int n;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
# line 967 "MapDefs.puma"
   return FillAlignSpec (t->INDEXED_VAR.IND_EXPS, n);

  }
  if (t->Kind == kBTE_EMPTY) {
# line 971 "MapDefs.puma"
   return n;

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->BTE_LIST.Elem->SLICE_EXP.START->Kind == kDUMMY_EXP) {
  if (t->BTE_LIST.Elem->SLICE_EXP.STOP->Kind == kDUMMY_EXP) {
  if (t->BTE_LIST.Elem->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
# line 975 "MapDefs.puma"
  {
# line 977 "MapDefs.puma"
 char name[20];
     tTree e;
     sprintf (name, "I_%d", n+1);
     e = mVAR_OBJ (0, MakeIdent (name, strlen (name)));
     e = mVAR_EXP (mUSED_VAR (e));
     t->BTE_LIST.Elem = e;
   
  }
   return FillAlignSpec (t->BTE_LIST.Next, n + 1);

  }
  }
  }
  }
# line 987 "MapDefs.puma"
   return FillAlignSpec (t->BTE_LIST.Next, n);

  }
# line 991 "MapDefs.puma"
  {
# line 992 "MapDefs.puma"
   failure_protocol (MODULE, "FillAlignSpec", t);
  }
   return n;

}

static tTree MakeSlices
# if defined __STDC__ | defined __cplusplus
(register int rank)
# else
(rank)
 register int rank;
# endif
{
# line 1004 "MapDefs.puma"
  {
# line 1005 "MapDefs.puma"
   if (! ((rank <= 0))) goto yyL1;
  }
   return mBTE_EMPTY ();
yyL1:;

# line 1009 "MapDefs.puma"
   return mBTE_LIST (mSLICE_EXP (mDUMMY_EXP (), mDUMMY_EXP (), mDUMMY_EXP ()), MakeSlices (rank - 1));

}

static void CheckTargetSubscripts
# if defined __STDC__ | defined __cplusplus
(register tTree targets, register tTree sources)
# else
(targets, sources)
 register tTree targets;
 register tTree sources;
# endif
{
  if (targets->Kind == kBTE_LIST) {
  if (targets->BTE_LIST.Elem->Kind == kDUMMY_EXP) {
# line 1032 "MapDefs.puma"
  {
# line 1034 "MapDefs.puma"
   CheckTargetSubscripts (targets->BTE_LIST.Next, sources);
  }
   return;

  }
# line 1037 "MapDefs.puma"
 {
  int yyV1;
  bool yyV2;
  tTree yyV3;
  int yyV4;
  tTree yyV5;
  int yyV6;
  {
# line 1043 "MapDefs.puma"
   AnalTargetExp (targets->BTE_LIST.Elem, sources, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5, & yyV6);
# line 1046 "MapDefs.puma"
 if (yyV1 == -1) 

        { tree_protocol ("The following align-subscript causes an error: ", 
                          targets->BTE_LIST.Elem);
          error_protocol ("align-subscript may contain only one align-dummy");
        }

      else if (yyV1 == 0)

        {  }

      else if (!yyV2)

        { tree_protocol ("The following target causes an error: ", targets->BTE_LIST.Elem);
          error_protocol ("invalid align-subscript-use");
        }
   
      else if (!IsNewSourcePosition (yyV1))
     
        { 

          error_protocol (
             "align-dummy appears more than once in align-subscripts");
        }
    
# line 1073 "MapDefs.puma"
   CheckTargetSubscripts (targets->BTE_LIST.Next, sources);
  }
   return;
 }

  }
  if (targets->Kind == kBTE_EMPTY) {
# line 1076 "MapDefs.puma"
   return;

  }
# line 1079 "MapDefs.puma"
  {
# line 1080 "MapDefs.puma"
   failure_protocol (MODULE, "CheckTargetSubscripts", targets);
  }
   return;

;
}

static tDefinitions GetDistributeeObj
# if defined __STDC__ | defined __cplusplus
(register tTree distributee)
# else
(distributee)
 register tTree distributee;
# endif
{
  if (distributee->Kind == kUSED_VAR) {
# line 1091 "MapDefs.puma"
 {
  tDefinitions DObj;
  {
# line 1093 "MapDefs.puma"

# line 1095 "MapDefs.puma"
 DObj = GetGlobalObject (distributee->USED_VAR.VARNAME->VAR_OBJ.Ident);

     if (DObj == NoObject)
        error_protocol ("distributee is unknown entity");
      else if (!CanBeDistributed (DObj))
        error_protocol ("entity cannot be distributed");
      else if (!IsDynamic (DObj))
        error_protocol ("entity is not DYNAMIC");

     distributee->USED_VAR.VARNAME->VAR_OBJ.Object = DObj;
   
  }
  {
   return DObj;
  }
 }

  }
# line 1110 "MapDefs.puma"
  {
# line 1111 "MapDefs.puma"
   failure_protocol (MODULE, "GetDistributeeObj", distributee);
  }
   return NoObject;

}

static tDefinitions GetAligneeObj
# if defined __STDC__ | defined __cplusplus
(register tTree alignee)
# else
(alignee)
 register tTree alignee;
# endif
{
  if (alignee->Kind == kUSED_VAR) {
# line 1123 "MapDefs.puma"
 {
  tDefinitions DObj;
  {
# line 1125 "MapDefs.puma"

# line 1127 "MapDefs.puma"
 DObj = GetGlobalObject (alignee->USED_VAR.VARNAME->VAR_OBJ.Ident);

     if (DObj == NoObject)
        error_protocol ("alignee is unknown entity");
      else if (!CanBeAligned (DObj))
        error_protocol ("entity cannot be aligned");
      else if (!IsDynamic (DObj))
        error_protocol ("entity is not DYNAMIC");

     alignee->USED_VAR.VARNAME->VAR_OBJ.Object = DObj;
   
  }
  {
   return DObj;
  }
 }

  }
# line 1142 "MapDefs.puma"
  {
# line 1143 "MapDefs.puma"
   failure_protocol (MODULE, "GetAligneeObj", alignee);
  }
   return NoObject;

}

static bool CanBeDistributed
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 1153 "MapDefs.puma"
  {
# line 1154 "MapDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 1155 "MapDefs.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kVarObject) {
# line 1158 "MapDefs.puma"
 {
  tTree type;
  {
# line 1160 "MapDefs.puma"

# line 1162 "MapDefs.puma"
   type = GetObjectType (obj);
# line 1164 "MapDefs.puma"
   if (! ((! IsPointerType (type)))) goto yyL2;
  {
# line 1165 "MapDefs.puma"
   if (! ((! IsExplicitlyMappedType (GetBaseType (type))))) goto yyL2;
  }
  }
   return true;
 }
yyL2:;

  }
  if (obj->Kind == kTemplateObject) {
# line 1168 "MapDefs.puma"
   return true;

  }
  return false;
}

static bool IsMappedTypeObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 1177 "MapDefs.puma"
  {
# line 1178 "MapDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 1179 "MapDefs.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kVarObject) {
# line 1182 "MapDefs.puma"
  {
# line 1184 "MapDefs.puma"
   if (! ((IsExplicitlyMappedType (GetBaseType (GetObjectType (obj)))))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

static bool CanBeAligned
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 1193 "MapDefs.puma"
  {
# line 1194 "MapDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 1195 "MapDefs.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kVarObject) {
# line 1198 "MapDefs.puma"
 {
  tTree type;
  {
# line 1200 "MapDefs.puma"

# line 1202 "MapDefs.puma"
   type = GetObjectType (obj);
# line 1204 "MapDefs.puma"
   if (! ((! IsPointerType (type)))) goto yyL2;
  {
# line 1205 "MapDefs.puma"
   if (! ((! IsExplicitlyMappedType (GetBaseType (type))))) goto yyL2;
  }
  }
   return true;
 }
yyL2:;

  }
  return false;
}

static bool IsDynamic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 1214 "MapDefs.puma"
  {
# line 1215 "MapDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 1216 "MapDefs.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kVarObject) {
# line 1219 "MapDefs.puma"
  {
# line 1220 "MapDefs.puma"
   if (! ((obj->VarObject.Dist->Distribution.dynamic))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (obj->Kind == kTemplateObject) {
# line 1223 "MapDefs.puma"
  {
# line 1224 "MapDefs.puma"
   if (! ((obj->TemplateObject.Dist->Distribution.dynamic))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

void AnalTargetExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree free_vars, register int * yyP7, register bool * yyP6, register tTree * yyP5, register int * yyP4, register tTree * yyP3, register int * yyP2)
# else
(exp, free_vars, yyP7, yyP6, yyP5, yyP4, yyP3, yyP2)
 register tTree exp;
 register tTree free_vars;
 register int * yyP7;
 register bool * yyP6;
 register tTree * yyP5;
 register int * yyP4;
 register tTree * yyP3;
 register int * yyP2;
# endif
{
# line 1250 "MapDefs.puma"
 {
  bool yyV1;
  int yyV2;
  tTree yyV3;
  bool yyV4;
  tTree yyV5;
  int yyV6;
  tTree yyV7;
  int yyV8;
  {
# line 1252 "MapDefs.puma"
   FindFreeVar (exp, free_vars, & yyV1, & yyV2, & yyV3);
# line 1254 "MapDefs.puma"
   if (! ((yyV1))) goto yyL1;
  {
# line 1256 "MapDefs.puma"
   if (! ((yyV2 > 0))) goto yyL1;
  {
# line 1258 "MapDefs.puma"
   ResolveFreeVar (exp, yyV3, & yyV4, & yyV5, & yyV6, & yyV7, & yyV8);
  }
  }
  }
   * yyP7 = yyV2;
   * yyP6 = yyV4;
   * yyP5 = yyV5;
   * yyP4 = yyV6;
   * yyP3 = yyV7;
   * yyP2 = yyV8;
   return;
 }
yyL1:;

# line 1264 "MapDefs.puma"
 {
  bool yyV1;
  int yyV2;
  tTree yyV3;
  {
# line 1268 "MapDefs.puma"
   FindFreeVar (exp, free_vars, & yyV1, & yyV2, & yyV3);
# line 1270 "MapDefs.puma"
 if (!yyV1) yyV2 = -1; 
  }
   * yyP7 = yyV2;
   * yyP6 = true;
   * yyP5 = NoTree;
   * yyP4 = 0;
   * yyP3 = NoTree;
   * yyP2 = 0;
   return;
 }

;
}

static void FindFreeVar
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree free_vars, register bool * yyP10, register int * yyP9, register tTree * yyP8)
# else
(exp, free_vars, yyP10, yyP9, yyP8)
 register tTree exp;
 register tTree free_vars;
 register bool * yyP10;
 register int * yyP9;
 register tTree * yyP8;
# endif
{
  if (free_vars->Kind == kBTE_LIST) {
  if (free_vars->BTE_LIST.Elem->Kind == kVAR_EXP) {
# line 1286 "MapDefs.puma"
 {
  bool yyV1;
  int yyV2;
  tTree yyV3;
  {
# line 1288 "MapDefs.puma"
   if (! ((FreeVarInExp (free_vars->BTE_LIST.Elem->VAR_EXP.V, exp)))) goto yyL1;
  {
# line 1290 "MapDefs.puma"
   FindFreeVar (exp, free_vars->BTE_LIST.Next, & yyV1, & yyV2, & yyV3);
  }
  }
   * yyP10 = yyV1 && (yyV2 == 0);
   * yyP9 = 1;
   * yyP8 = free_vars->BTE_LIST.Elem->VAR_EXP.V;
   return;
 }
yyL1:;

  }
# line 1293 "MapDefs.puma"
 {
  bool yyV1;
  int yyV2;
  tTree yyV3;
  {
# line 1295 "MapDefs.puma"
   FindFreeVar (exp, free_vars->BTE_LIST.Next, & yyV1, & yyV2, & yyV3);
# line 1297 "MapDefs.puma"
 if (yyV1 && (yyV2 > 0)) yyV2++; 
  }
   * yyP10 = yyV1;
   * yyP9 = yyV2;
   * yyP8 = yyV3;
   return;
 }

  }
  if (free_vars->Kind == kBTE_EMPTY) {
# line 1300 "MapDefs.puma"
   * yyP10 = true;
   * yyP9 = 0;
   * yyP8 = NoTree;
   return;

  }
;
}

static void ResolveFreeVar
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree fvar, register bool * yyP15, register tTree * yyP14, register int * yyP13, register tTree * yyP12, register int * yyP11)
# else
(exp, fvar, yyP15, yyP14, yyP13, yyP12, yyP11)
 register tTree exp;
 register tTree fvar;
 register bool * yyP15;
 register tTree * yyP14;
 register int * yyP13;
 register tTree * yyP12;
 register int * yyP11;
# endif
{
# line 1318 "MapDefs.puma"
 {
  int add_const;
  int mult_const;
  bool found;
  tTree var;
  {
# line 1320 "MapDefs.puma"

# line 1321 "MapDefs.puma"

# line 1323 "MapDefs.puma"

# line 1324 "MapDefs.puma"

# line 1326 "MapDefs.puma"
   ResolveExpression (exp, & found, & mult_const, & add_const, & var);
# line 1328 "MapDefs.puma"
   if (! ((found))) goto yyL1;
  {
# line 1329 "MapDefs.puma"
   if (! ((TreeVarName (var) == TreeVarName (fvar)))) goto yyL1;
  }
  }
   * yyP15 = true;
   * yyP14 = NoTree;
   * yyP13 = mult_const;
   * yyP12 = NoTree;
   * yyP11 = add_const;
   return;
 }
yyL1:;

  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
# line 1332 "MapDefs.puma"
 {
  bool yyV1;
  tTree yyV2;
  int yyV3;
  tTree yyV4;
  int yyV5;
  {
# line 1335 "MapDefs.puma"
   if (! ((! FreeVarInExp (fvar, exp->OP_EXP.OPND2)))) goto yyL2;
  {
# line 1337 "MapDefs.puma"
   ResolveFreeVar (exp->OP_EXP.OPND1, fvar, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
# line 1339 "MapDefs.puma"
   if (! ((yyV1))) goto yyL2;
  {
# line 1340 "MapDefs.puma"
   if (! ((yyV2 == NoTree))) goto yyL2;
  {
# line 1341 "MapDefs.puma"
   if (! ((yyV4 == NoTree))) goto yyL2;
  }
  }
  }
  }
   * yyP15 = yyV1;
   * yyP14 = exp->OP_EXP.OPND2;
   * yyP13 = yyV3;
   * yyP12 = yyV4;
   * yyP11 = yyV5 * yyV3;
   return;
 }
yyL2:;

# line 1344 "MapDefs.puma"
 {
  bool yyV1;
  tTree yyV2;
  int yyV3;
  tTree yyV4;
  int yyV5;
  {
# line 1347 "MapDefs.puma"
   if (! ((! FreeVarInExp (fvar, exp->OP_EXP.OPND1)))) goto yyL3;
  {
# line 1349 "MapDefs.puma"
   ResolveFreeVar (exp->OP_EXP.OPND2, fvar, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
# line 1351 "MapDefs.puma"
   if (! ((yyV1))) goto yyL3;
  {
# line 1352 "MapDefs.puma"
   if (! ((yyV2 == NoTree))) goto yyL3;
  {
# line 1353 "MapDefs.puma"
   if (! ((yyV4 == NoTree))) goto yyL3;
  }
  }
  }
  }
   * yyP15 = yyV1;
   * yyP14 = exp->OP_EXP.OPND1;
   * yyP13 = yyV3;
   * yyP12 = yyV4;
   * yyP11 = yyV5 * yyV3;
   return;
 }
yyL3:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
# line 1356 "MapDefs.puma"
 {
  bool yyV1;
  tTree yyV2;
  int yyV3;
  tTree yyV4;
  int yyV5;
  {
# line 1359 "MapDefs.puma"
   if (! ((! FreeVarInExp (fvar, exp->OP_EXP.OPND2)))) goto yyL4;
  {
# line 1361 "MapDefs.puma"
   ResolveFreeVar (exp->OP_EXP.OPND1, fvar, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
# line 1363 "MapDefs.puma"
   if (! ((yyV1))) goto yyL4;
  {
# line 1364 "MapDefs.puma"
   if (! ((yyV4 == NoTree))) goto yyL4;
  }
  }
  }
   * yyP15 = yyV1;
   * yyP14 = yyV2;
   * yyP13 = yyV3;
   * yyP12 = exp->OP_EXP.OPND2;
   * yyP11 = yyV5;
   return;
 }
yyL4:;

# line 1367 "MapDefs.puma"
 {
  bool yyV1;
  tTree yyV2;
  int yyV3;
  tTree yyV4;
  int yyV5;
  {
# line 1370 "MapDefs.puma"
   if (! ((! FreeVarInExp (fvar, exp->OP_EXP.OPND1)))) goto yyL5;
  {
# line 1372 "MapDefs.puma"
   ResolveFreeVar (exp->OP_EXP.OPND2, fvar, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
# line 1374 "MapDefs.puma"
   if (! ((yyV1))) goto yyL5;
  {
# line 1375 "MapDefs.puma"
   if (! ((yyV4 == NoTree))) goto yyL5;
  }
  }
  }
   * yyP15 = yyV1;
   * yyP14 = yyV2;
   * yyP13 = yyV3;
   * yyP12 = exp->OP_EXP.OPND1;
   * yyP11 = yyV5;
   return;
 }
yyL5:;

  }
  }
# line 1380 "MapDefs.puma"
   * yyP15 = false;
   * yyP14 = NoTree;
   * yyP13 = 0;
   * yyP12 = NoTree;
   * yyP11 = 0;
   return;

;
}

static bool FreeVarInExp
# if defined __STDC__ | defined __cplusplus
(register tTree fvar, register tTree exp)
# else
(fvar, exp)
 register tTree fvar;
 register tTree exp;
# endif
{
# line 1393 "MapDefs.puma"
  {
# line 1395 "MapDefs.puma"
   if (! ((IsVarInExp (TreeVarName (fvar), exp)))) goto yyL1;
  }
   return true;
yyL1:;

  return false;
}

static void MakeAlignTypes
# if defined __STDC__ | defined __cplusplus
(register tTree align_source)
# else
(align_source)
 register tTree align_source;
# endif
{
  if (align_source->Kind == kBTE_LIST) {
# line 1408 "MapDefs.puma"
  {
# line 1410 "MapDefs.puma"
   MakeAlignTypes (align_source->BTE_LIST.Elem);
# line 1411 "MapDefs.puma"
   MakeAlignTypes (align_source->BTE_LIST.Next);
  }
   return;

  }
  if (align_source->Kind == kVAR_EXP) {
# line 1414 "MapDefs.puma"
  {
# line 1416 "MapDefs.puma"
   MakeAlignTypes (align_source->VAR_EXP.V);
  }
   return;

  }
  if (align_source->Kind == kUSED_VAR) {
# line 1419 "MapDefs.puma"
 {
  tDefinitions my_unit_obj;
  {
# line 1421 "MapDefs.puma"

# line 1423 "MapDefs.puma"
 my_unit_obj = GetCurrentUnitObject ();

     align_source->USED_VAR.VARNAME->VAR_OBJ.Object    = GetLocalObject (align_source->USED_VAR.VARNAME->VAR_OBJ.Ident);

     

     if (align_source->USED_VAR.VARNAME->VAR_OBJ.Object == NoObject)
        align_source->USED_VAR.VARNAME->VAR_OBJ.Object = GetLocalVarEntity (align_source->USED_VAR.VARNAME->VAR_OBJ.Ident, align_source->USED_VAR.VARNAME->VAR_OBJ.Pos, my_unit_obj);

     MakeAlignVar (align_source->USED_VAR.VARNAME->VAR_OBJ.Object, align_source, my_unit_obj);

   
  }
   return;
 }

  }
  if (align_source->Kind == kBTE_EMPTY) {
# line 1437 "MapDefs.puma"
   return;

  }
;
}

static void MakeAlignVar
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree var, register tDefinitions my_unit)
# else
(obj, var, my_unit)
 register tDefinitions obj;
 register tTree var;
 register tDefinitions my_unit;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_DECL) {
  if (obj->VarObject.decl->VAR_DECL.VAL->Kind == kDUMMY_TYPE) {
# line 1449 "MapDefs.puma"
  {
# line 1453 "MapDefs.puma"
   if (! ((obj->VarObject.in == my_unit))) goto yyL1;
  {
# line 1455 "MapDefs.puma"
 obj->VarObject.decl->VAR_DECL.VAL = mALIGN_TYPE (); 
  }
  }
   return;
yyL1:;

  }
  if (obj->VarObject.decl->VAR_DECL.VAL->Kind == kALIGN_TYPE) {
# line 1460 "MapDefs.puma"
   return;

  }
  if (obj->VarObject.decl->VAR_DECL.VAL->Kind == kINTEGER_TYPE) {
# line 1463 "MapDefs.puma"
   return;

  }
  }
  }
# line 1466 "MapDefs.puma"
  {
# line 1468 "MapDefs.puma"
   warning_protocol ("ALIGN subscript not INTEGER");
# line 1469 "MapDefs.puma"
   tree_protocol ("illegal subscript is : ", var);
# line 1470 "MapDefs.puma"
   tree_protocol ("illegal type is : ", obj->Object.decl);
  }
   return;

;
}

void BeginMapDefs ()
{
}

void CloseMapDefs ()
{
}
