# include "MakeSerial.h"
# include "yyMakeSerial.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 42 "MakeSerial.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "DefTable.h" 
# include "TreeOps.h"          /* IsForallLoop, IsIndepLoop    */
# include "Traverse.h"
# include "Invariant.h"
# include "Transform.h"        /* CombineACF */

# include "FindHome.h"
# include "VarDescriptor.h"
# include "ExpDescriptor.h"    /* GetExpDescriptor */
# include "Expressions.h"      /* MakeNotExp */
# include "Nesting.h"          /* GetOuterLoop */
# include "Accepted.h"

# define MODULE "MakeSerial"



static void yyExit () { Exit (1); }

void (* MakeSerial_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeSerial, routine %s failed\n", yyFunction);
 MakeSerial_Exit ();
}

void MakeSerial ARGS((tTree t));
static bool StopMakeSerial ARGS((tTree t));
static tTree DoMakeSerial ARGS((tTree t));
static bool NeedsSerialization ARGS((tTree stmt));
static bool UpdatesExpression ARGS((tTree stmts, tTree exp));
static void NewWhereMask ARGS((tTree t, tTree * yyP2, tTree * yyP1));
static bool NewWhereMaskRequired ARGS((tTree t));
static void MakeNewWhereMask ARGS((tTree t, tTree * yyP4, tTree * yyP3));
static void NewIfMask ARGS((tTree t, tTree * yyP6, tTree * yyP5));
static bool NewIfMaskRequired ARGS((tTree t));
static void MakeNewIfMask ARGS((tTree t, tTree * yyP8, tTree * yyP7));
static void NewForallBounds ARGS((tTree t, tTree * yyP10, tTree * yyP9));
static bool NewForallBoundsRequired ARGS((tTree t));
static tTree SplitWhere ARGS((tTree where_stmt));
static tTree SplitIf ARGS((tTree if_stmt));
static void SplitAssign ARGS((tTree s, tTree * yyP12, tTree * yyP11));
static void MyMakeTempAssignment ARGS((tTree exp, pvar vard, tTree * yyP15, tTree * yyP14, tTree * yyP13));
static bool HasOuterIndependentLoop ARGS(());

void MakeSerial
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 75 "MakeSerial.puma"
  {
# line 77 "MakeSerial.puma"
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeSerial, DoMakeSerial); 
  }
   return;

  }
# line 80 "MakeSerial.puma"
  {
# line 81 "MakeSerial.puma"
   failure_protocol (MODULE, "MakeSerial", t);
  }
   return;

;
}

static bool StopMakeSerial
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 98 "MakeSerial.puma"
  {
# line 99 "MakeSerial.puma"
   return false;
  }

}

static tTree DoMakeSerial
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 125 "MakeSerial.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree new;
  {
# line 127 "MakeSerial.puma"
   if (! ((NeedsSerialization (t)))) goto yyL1;
  {
# line 129 "MakeSerial.puma"
   stmt_protocol ("array assignment will be serialized");
# line 131 "MakeSerial.puma"
   SplitAssign (t->ACF_BASIC.BASIC_STMT, & yyV1, & yyV2);
# line 133 "MakeSerial.puma"

# line 135 "MakeSerial.puma"
   new = ComposeNewACF (yyV1, t, yyV2);
# line 137 "MakeSerial.puma"
   tree_protocol ("after serialization : \n", new);
  }
  }
  {
   return new;
  }
 }
yyL1:;

# line 142 "MakeSerial.puma"
   return t;

  }
  }
  if (t->Kind == kACF_WHERE) {
# line 157 "MakeSerial.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree new;
  {
# line 161 "MakeSerial.puma"
   NewWhereMask (t, & yyV1, & yyV2);
# line 163 "MakeSerial.puma"

# line 165 "MakeSerial.puma"
   new = CombineACF (yyV1, CombineACF (SplitWhere (t), yyV2));
# line 167 "MakeSerial.puma"
   tree_protocol ("serialized WHERE statement: \n", new);
  }
  {
   return new;
  }
 }

  }
  if (t->Kind == kACF_IF) {
# line 182 "MakeSerial.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree new;
  {
# line 184 "MakeSerial.puma"
   if (! ((OuterLoops () > 0))) goto yyL4;
  {
# line 185 "MakeSerial.puma"
   if (! ((IsForallLoop (GetOuterLoop (OuterLoops ()))))) goto yyL4;
  {
# line 189 "MakeSerial.puma"
   NewIfMask (t, & yyV1, & yyV2);
# line 191 "MakeSerial.puma"

# line 193 "MakeSerial.puma"
   new = CombineACF (yyV1, CombineACF (SplitIf (t), yyV2));
# line 195 "MakeSerial.puma"
   tree_protocol ("serialized FORALL mask statement: \n", new);
  }
  }
  }
  {
   return new;
  }
 }
yyL4:;

  }
  if (t->Kind == kACF_FORALL) {
# line 223 "MakeSerial.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree new;
  {
# line 227 "MakeSerial.puma"
   NewForallBounds (t, & yyV1, & yyV2);
# line 229 "MakeSerial.puma"

# line 233 "MakeSerial.puma"
   t->ACF_FORALL.FORALL_DEP_INFO = mINDEP_INFO (false, 0, NoTree, NoTree);
# line 237 "MakeSerial.puma"
   new = t->ACF_FORALL.FORALL_BODY;
# line 238 "MakeSerial.puma"
   ExpandNewStatements (t->ACF_FORALL.FORALL_BODY, t, t->ACF_FORALL.Line);
# line 239 "MakeSerial.puma"
   new = CombineACF (yyV1, CombineACF (new, yyV2));
# line 241 "MakeSerial.puma"
   tree_protocol ("splitted forall : \n", new);
  }
  {
   return new;
  }
 }

  }
# line 248 "MakeSerial.puma"
   return t;

}

static bool NeedsSerialization
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 267 "MakeSerial.puma"
  {
# line 269 "MakeSerial.puma"
   if (! ((ForallVarExpDependences (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  }
  return false;
}

static bool UpdatesExpression
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, register tTree exp)
# else
(stmts, exp)
 register tTree stmts;
 register tTree exp;
# endif
{
  if (stmts->Kind == kACF_LIST) {
# line 282 "MakeSerial.puma"
  {
# line 283 "MakeSerial.puma"
   if (! (UpdatesExpression (stmts->ACF_LIST.Elem, exp))) goto yyL1;
  }
   return true;
yyL1:;

# line 286 "MakeSerial.puma"
  {
# line 287 "MakeSerial.puma"
   if (! (UpdatesExpression (stmts->ACF_LIST.Next, exp))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (stmts->Kind == kACF_BASIC) {
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 290 "MakeSerial.puma"
  {
# line 292 "MakeSerial.puma"
   if (! ((ForallVarExpDependences (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, exp)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  }
  if (stmts->Kind == kACF_WHERE) {
# line 295 "MakeSerial.puma"
  {
# line 297 "MakeSerial.puma"
   if (! (UpdatesExpression (stmts->ACF_WHERE.TRUE_PART, exp))) goto yyL4;
  {
# line 298 "MakeSerial.puma"
   if (! (UpdatesExpression (stmts->ACF_WHERE.FALSE_PART, exp))) goto yyL4;
  }
  }
   return true;
yyL4:;

  }
  return false;
}

static void NewWhereMask
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP2, register tTree * yyP1)
# else
(t, yyP2, yyP1)
 register tTree t;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (t->Kind == kACF_WHERE) {
# line 314 "MakeSerial.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 316 "MakeSerial.puma"
   if (! ((NewWhereMaskRequired (t)))) goto yyL1;
  {
# line 317 "MakeSerial.puma"
   MakeNewWhereMask (t, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL1:;

# line 322 "MakeSerial.puma"
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  }
;
}

static bool NewWhereMaskRequired
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_WHERE) {
# line 336 "MakeSerial.puma"
  {
# line 338 "MakeSerial.puma"
   if (! ((UpdatesExpression (t->ACF_WHERE.TRUE_PART, t->ACF_WHERE.WHERE_EXP)))) goto yyL1;
  }
   return true;
yyL1:;

# line 341 "MakeSerial.puma"
  {
# line 343 "MakeSerial.puma"
   if (! ((UpdatesExpression (t->ACF_WHERE.FALSE_PART, t->ACF_WHERE.WHERE_EXP)))) goto yyL2;
  }
   return true;
yyL2:;

  if (t->ACF_WHERE.WHERE_EXP->Kind == kVAR_EXP) {
# line 346 "MakeSerial.puma"
  {
# line 348 "MakeSerial.puma"
   if (! ((IsDescriptorVar (t->ACF_WHERE.WHERE_EXP->VAR_EXP.V)))) goto yyL3;
  {
# line 349 "MakeSerial.puma"
   return false;
  }
  }
yyL3:;

  }
# line 352 "MakeSerial.puma"
   return true;

  }
  return false;
}

static void MakeNewWhereMask
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP4, register tTree * yyP3)
# else
(t, yyP4, yyP3)
 register tTree t;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
  if (t->Kind == kACF_WHERE) {
# line 363 "MakeSerial.puma"
 {
  var_descriptor vard;
  bool found;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 365 "MakeSerial.puma"

# line 366 "MakeSerial.puma"

# line 368 "MakeSerial.puma"
   GetExpDescriptor (t->ACF_WHERE.WHERE_EXP, & found, & vard);
# line 369 "MakeSerial.puma"
   if (! ((found))) goto yyL1;
  {
# line 371 "MakeSerial.puma"
   SetExpType (t->ACF_WHERE.WHERE_EXP, & vard);
# line 373 "MakeSerial.puma"
   MyMakeTempAssignment (t->ACF_WHERE.WHERE_EXP, & vard, & yyV1, & yyV2, & yyV3);
# line 375 "MakeSerial.puma"
 t->ACF_WHERE.WHERE_EXP = yyV1; 
  }
  }
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }
yyL1:;

  }
# line 378 "MakeSerial.puma"
  {
# line 380 "MakeSerial.puma"
   error_protocol ("no var descriptor for where statement");
  }
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

;
}

static void NewIfMask
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP6, register tTree * yyP5)
# else
(t, yyP6, yyP5)
 register tTree t;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
  if (t->Kind == kACF_IF) {
# line 396 "MakeSerial.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 398 "MakeSerial.puma"
   if (! ((NewIfMaskRequired (t)))) goto yyL1;
  {
# line 399 "MakeSerial.puma"
   MakeNewIfMask (t, & yyV1, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL1:;

# line 404 "MakeSerial.puma"
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

  }
;
}

static bool NewIfMaskRequired
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_IF) {
# line 415 "MakeSerial.puma"
  {
# line 417 "MakeSerial.puma"
   if (! ((UpdatesExpression (t->ACF_IF.THEN_PART, t->ACF_IF.IF_EXP)))) goto yyL1;
  }
   return true;
yyL1:;

# line 420 "MakeSerial.puma"
  {
# line 422 "MakeSerial.puma"
   if (! ((UpdatesExpression (t->ACF_IF.ELSE_PART, t->ACF_IF.IF_EXP)))) goto yyL2;
  }
   return true;
yyL2:;

  if (t->ACF_IF.IF_EXP->Kind == kVAR_EXP) {
# line 425 "MakeSerial.puma"
  {
# line 427 "MakeSerial.puma"
   if (! ((IsDescriptorVar (t->ACF_IF.IF_EXP->VAR_EXP.V)))) goto yyL3;
  {
# line 428 "MakeSerial.puma"
   return false;
  }
  }
yyL3:;

  }
# line 431 "MakeSerial.puma"
   return true;

  }
  return false;
}

static void MakeNewIfMask
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP8, register tTree * yyP7)
# else
(t, yyP8, yyP7)
 register tTree t;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
  if (t->Kind == kACF_IF) {
# line 442 "MakeSerial.puma"
 {
  var_descriptor vard;
  bool found;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 444 "MakeSerial.puma"

# line 445 "MakeSerial.puma"

# line 447 "MakeSerial.puma"
   GetExpDescriptor (t->ACF_IF.IF_EXP, & found, & vard);
# line 448 "MakeSerial.puma"
   if (! ((found))) goto yyL1;
  {
# line 450 "MakeSerial.puma"
   printf ("exp descriptor for if mask : ");
# line 451 "MakeSerial.puma"
   FileUnparse (stdout, t->ACF_IF.IF_EXP);
# line 451 "MakeSerial.puma"
   printf ("\n");
# line 452 "MakeSerial.puma"
   PrintVarDescriptor (& vard);
# line 454 "MakeSerial.puma"
   SetExpType (t->ACF_IF.IF_EXP, & vard);
# line 456 "MakeSerial.puma"
   MyMakeTempAssignment (t->ACF_IF.IF_EXP, & vard, & yyV1, & yyV2, & yyV3);
# line 458 "MakeSerial.puma"
 t->ACF_IF.IF_EXP = yyV1; 
  }
  }
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }
yyL1:;

  }
# line 461 "MakeSerial.puma"
  {
# line 463 "MakeSerial.puma"
   error_protocol ("no var descriptor for masked forall statement");
  }
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

;
}

static void NewForallBounds
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP10, register tTree * yyP9)
# else
(t, yyP10, yyP9)
 register tTree t;
 register tTree * yyP10;
 register tTree * yyP9;
# endif
{
  if (t->Kind == kACF_FORALL) {
# line 478 "MakeSerial.puma"
  {
# line 482 "MakeSerial.puma"
   if (! ((NewForallBoundsRequired (t)))) goto yyL1;
  {
# line 484 "MakeSerial.puma"
   error_protocol ("cannot create new bounds for FORALL loops");
  }
  }
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   return;
yyL1:;

# line 487 "MakeSerial.puma"
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   return;

  }
;
}

static bool NewForallBoundsRequired
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_FORALL) {
# line 498 "MakeSerial.puma"
  {
# line 500 "MakeSerial.puma"
   if (! ((UpdatesExpression (t->ACF_FORALL.FORALL_BODY, t->ACF_FORALL.FORALL_RANGE->SLICE_EXP.START)))) goto yyL1;
  }
   return true;
yyL1:;

# line 503 "MakeSerial.puma"
  {
# line 505 "MakeSerial.puma"
   if (! ((UpdatesExpression (t->ACF_FORALL.FORALL_BODY, t->ACF_FORALL.FORALL_RANGE->SLICE_EXP.STOP)))) goto yyL2;
  }
   return true;
yyL2:;

# line 508 "MakeSerial.puma"
  {
# line 510 "MakeSerial.puma"
   if (! ((UpdatesExpression (t->ACF_FORALL.FORALL_BODY, t->ACF_FORALL.FORALL_RANGE->SLICE_EXP.INC)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

static tTree SplitWhere
# if defined __STDC__ | defined __cplusplus
(register tTree where_stmt)
# else
(where_stmt)
 register tTree where_stmt;
# endif
{
  if (where_stmt->Kind == kACF_WHERE) {
# line 530 "MakeSerial.puma"
  {
# line 532 "MakeSerial.puma"
   MaskNewStatements (where_stmt->ACF_WHERE.TRUE_PART, where_stmt->ACF_WHERE.WHERE_EXP, true, where_stmt->ACF_WHERE.Line);
# line 533 "MakeSerial.puma"
   MaskNewStatements (where_stmt->ACF_WHERE.FALSE_PART, where_stmt->ACF_WHERE.WHERE_EXP, false, where_stmt->ACF_WHERE.Line);
  }
   return CombineACF (where_stmt->ACF_WHERE.TRUE_PART, where_stmt->ACF_WHERE.FALSE_PART);

  }
# line 538 "MakeSerial.puma"
  {
# line 539 "MakeSerial.puma"
   failure_protocol (MODULE, "SplitWhere", where_stmt);
  }
   return NoTree;

}

static tTree SplitIf
# if defined __STDC__ | defined __cplusplus
(register tTree if_stmt)
# else
(if_stmt)
 register tTree if_stmt;
# endif
{
  if (if_stmt->Kind == kACF_IF) {
# line 560 "MakeSerial.puma"
  {
# line 562 "MakeSerial.puma"
   MaskNewStatements (if_stmt->ACF_IF.THEN_PART, if_stmt->ACF_IF.IF_EXP, true, if_stmt->ACF_IF.Line);
# line 563 "MakeSerial.puma"
   MaskNewStatements (if_stmt->ACF_IF.ELSE_PART, if_stmt->ACF_IF.IF_EXP, false, if_stmt->ACF_IF.Line);
  }
   return CombineACF (if_stmt->ACF_IF.THEN_PART, if_stmt->ACF_IF.ELSE_PART);

  }
# line 568 "MakeSerial.puma"
  {
# line 569 "MakeSerial.puma"
   failure_protocol (MODULE, "SplitIf", if_stmt);
  }
   return NoTree;

}

static void SplitAssign
# if defined __STDC__ | defined __cplusplus
(register tTree s, register tTree * yyP12, register tTree * yyP11)
# else
(s, yyP12, yyP11)
 register tTree s;
 register tTree * yyP12;
 register tTree * yyP11;
# endif
{
  if (s->Kind == kASSIGN_STMT) {
# line 591 "MakeSerial.puma"
 {
  var_descriptor vard;
  bool found;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 593 "MakeSerial.puma"

# line 594 "MakeSerial.puma"

# line 596 "MakeSerial.puma"
   if (! ((TreeRank (s->ASSIGN_STMT.ASSIGN_EXP) < TreeRank (s->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  {
# line 598 "MakeSerial.puma"
   GetExpDescriptor (s->ASSIGN_STMT.ASSIGN_EXP, & found, & vard);
# line 599 "MakeSerial.puma"
   if (! ((found))) goto yyL1;
  {
# line 601 "MakeSerial.puma"
   MyMakeTempAssignment (s->ASSIGN_STMT.ASSIGN_EXP, & vard, & yyV1, & yyV2, & yyV3);
# line 603 "MakeSerial.puma"
 s->ASSIGN_STMT.ASSIGN_EXP = yyV1; 
  }
  }
  }
   * yyP12 = yyV2;
   * yyP11 = yyV3;
   return;
 }
yyL1:;

# line 606 "MakeSerial.puma"
 {
  var_descriptor vard;
  bool found;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 608 "MakeSerial.puma"

# line 609 "MakeSerial.puma"

# line 611 "MakeSerial.puma"
   GetVarDescriptor (s->ASSIGN_STMT.ASSIGN_VAR, & found, & vard);
# line 612 "MakeSerial.puma"
   if (! ((found))) goto yyL2;
  {
# line 614 "MakeSerial.puma"
   SetExpType (s->ASSIGN_STMT.ASSIGN_EXP, & vard);
# line 616 "MakeSerial.puma"
   MyMakeTempAssignment (s->ASSIGN_STMT.ASSIGN_EXP, & vard, & yyV1, & yyV2, & yyV3);
# line 618 "MakeSerial.puma"
 s->ASSIGN_STMT.ASSIGN_EXP = yyV1; 
  }
  }
   * yyP12 = yyV2;
   * yyP11 = yyV3;
   return;
 }
yyL2:;

  }
# line 621 "MakeSerial.puma"
  {
# line 623 "MakeSerial.puma"
   error_protocol ("no home descriptor for this assignment");
  }
   * yyP12 = NoTree;
   * yyP11 = NoTree;
   return;

;
}

static void MyMakeTempAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard, register tTree * yyP15, register tTree * yyP14, register tTree * yyP13)
# else
(exp, vard, yyP15, yyP14, yyP13)
 register tTree exp;
 pvar vard;
 register tTree * yyP15;
 register tTree * yyP14;
 register tTree * yyP13;
# endif
{
# line 636 "MakeSerial.puma"
 {
  tTree pre_stmt;
  tTree post_stmt;
  tTree new_exp;
  {
# line 638 "MakeSerial.puma"

# line 639 "MakeSerial.puma"

# line 640 "MakeSerial.puma"

# line 642 "MakeSerial.puma"
   ForallExpansion (vard);
# line 646 "MakeSerial.puma"
 if (HasOuterIndependentLoop ())

         { vard->topology_rank = 0;
           vard->topology_obj = GetDefaultTopology (0);
         }
    
# line 653 "MakeSerial.puma"
   MakeTempAssignment (exp, vard, & new_exp, & pre_stmt, & post_stmt);
  }
   * yyP15 = new_exp;
   * yyP14 = pre_stmt;
   * yyP13 = post_stmt;
   return;
 }

;
}

static bool HasOuterIndependentLoop
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 664 "MakeSerial.puma"
 {
  bool parloop;
  {
# line 665 "MakeSerial.puma"

# line 667 "MakeSerial.puma"
 int i;
      parloop = false;
 
      for (i=1; i<= OuterLoops(); i++)
        parloop = parloop || IsIndepDoLoop (GetOuterLoop(i));
    
# line 673 "MakeSerial.puma"
   if (! ((parloop))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

void BeginMakeSerial ()
{
}

void CloseMakeSerial ()
{
}
