# include "MakeRemapping.h"
# include "yyMakeRemapping.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 21 "MakeRemapping.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
 
# include "protocol.h"

# include "Traverse.h"     /* ReplaceAST, ...                      */
# include "Transform.h"    /* ComposeACF, ...                      */

# include "Rank.h"
# include "Distributions.h"
# include "MoveControl.h"
# include "Intrinsics.h"
# include "SpecialMap.h"
# include "VarDescriptor.h" 
# include "Descriptor.h"       /* PrintableDescriptorVar */

# define MODULE "MakeRemapping"
 
# undef DEBUG



static void yyExit () { Exit (1); }

void (* MakeRemapping_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeRemapping, routine %s failed\n", yyFunction);
 MakeRemapping_Exit ();
}

void MakeRemapping ARGS((tTree t));
static bool StopMakeRemapArgs ARGS((tTree t));
static tTree DoMakeRemapArgs ARGS((tTree t));
static bool CanHaveRemapping ARGS((tTree stmt));
static void RemappingArguments ARGS((tTree basic_stmt, tTree * yyP2, tTree * yyP1));
static void IntrArgRemapping ARGS((tIdent name, tTree var, tTree actuals, tTree * yyP4, tTree * yyP3));
static void AlignParamList ARGS((tTree target, tTree params, tTree * yyP6, tTree * yyP5));
static void AlignParam ARGS((tTree target, tTree param, tTree * yyP8, tTree * yyP7));
static void ParamListRemapping ARGS((tTree actuals, tTree call, tTree * yyP10, tTree * yyP9));
static void ParamRemapping ARGS((tTree actual, tTree call, tTree * yyP12, tTree * yyP11));
static void IntrResRemapping ARGS((tIdent name, tTree assign, tTree * yyP14, tTree * yyP13));
static void NewResultTmp ARGS((tTree assign, tTree * yyP16, tTree * yyP15));
static void MakeSerialArguments ARGS((tTree actuals, tTree * yyP18, tTree * yyP17));
static void MakeSerialArgument ARGS((tTree actual, tTree * yyP20, tTree * yyP19));
static void MakeSerialVar ARGS((tTree var, tTree * yyP23, tTree * yyP22, tTree * yyP21));
static bool AcceptedSerialVar ARGS((tTree var));
static bool MightBeRedistributed ARGS((tTree p, tTree actual, tDefinitions dummy));
static void FindParamDescriptor ARGS((tTree actual, bool * yyP25, var_descriptor * yyP24));
static void MakeParamTemporary ARGS((tTree actual, pvar vard, tTree * yyP27, tTree * yyP26));
static void MakeNewAssignment ARGS((tTree exp, pvar vard, tTree * yyP30, tTree * yyP29, tTree * yyP28));

void MakeRemapping
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 54 "MakeRemapping.puma"
  {
# line 56 "MakeRemapping.puma"
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeRemapArgs, DoMakeRemapArgs); 
  }
   return;

  }
# line 59 "MakeRemapping.puma"
  {
# line 60 "MakeRemapping.puma"
   failure_protocol (MODULE, "MakeRemapping", t);
  }
   return;

;
}

static bool StopMakeRemapArgs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 77 "MakeRemapping.puma"
  {
# line 78 "MakeRemapping.puma"
   return false;
  }

}

static tTree DoMakeRemapArgs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
# line 89 "MakeRemapping.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 91 "MakeRemapping.puma"
   if (! ((CanHaveRemapping (t->ACF_BASIC.BASIC_STMT)))) goto yyL1;
  {
# line 93 "MakeRemapping.puma"
   RemappingArguments (t->ACF_BASIC.BASIC_STMT, & yyV1, & yyV2);
# line 95 "MakeRemapping.puma"
 if (yyV1 != NoTree)

      { set_protocol_stmt (t);
        stmt_protocol ("remapping necessary for this stmt");
        tree_protocol ("pre_stmts  : \n", yyV1);
        tree_protocol ("post_stmts : \n", yyV2);
      }
  
  }
  }
  {
   return ComposeNewACF (yyV1, t, yyV2);
  }
 }
yyL1:;

  }
# line 107 "MakeRemapping.puma"
   return t;

}

static bool CanHaveRemapping
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kCALL_STMT) {
# line 119 "MakeRemapping.puma"
   return true;

  }
  if (stmt->Kind == kASSIGN_STMT) {
  if (stmt->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 122 "MakeRemapping.puma"
   return true;

  }
  }
  return false;
}

static void RemappingArguments
# if defined __STDC__ | defined __cplusplus
(register tTree basic_stmt, register tTree * yyP2, register tTree * yyP1)
# else
(basic_stmt, yyP2, yyP1)
 register tTree basic_stmt;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (basic_stmt->Kind == kASSIGN_STMT) {
  if (basic_stmt->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 132 "MakeRemapping.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 136 "MakeRemapping.puma"
   if (! ((IsIntrCall (basic_stmt->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL1;
  {
# line 138 "MakeRemapping.puma"
   IntrArgRemapping (basic_stmt->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, basic_stmt->ASSIGN_STMT.ASSIGN_VAR, basic_stmt->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2);
# line 139 "MakeRemapping.puma"
   IntrResRemapping (basic_stmt->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, basic_stmt, & yyV3, & yyV4);
# line 141 "MakeRemapping.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 142 "MakeRemapping.puma"
   yyV2 = CombineACF (yyV4, yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL1:;

# line 145 "MakeRemapping.puma"
 {
  bool found;
  var_descriptor home;
  {
# line 149 "MakeRemapping.puma"
   if (! ((IsSerialCall (basic_stmt->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL2;
  {
# line 151 "MakeRemapping.puma"

# line 152 "MakeRemapping.puma"

# line 154 "MakeRemapping.puma"
   FindSerialHome (basic_stmt, & home, & found);
# line 155 "MakeRemapping.puma"
   if (! ((found))) goto yyL2;
  {
# line 157 "MakeRemapping.puma"
   stmt_protocol ("serial function call on dedicated home (no remapping)");
# line 158 "MakeRemapping.puma"
   tree_protocol ("home of serial call : ", PrintableDescriptorVar (& home));
  }
  }
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;
 }
yyL2:;

# line 161 "MakeRemapping.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
# line 165 "MakeRemapping.puma"
   if (! ((IsSerialCall (basic_stmt->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL3;
  {
# line 167 "MakeRemapping.puma"
   stmt_protocol ("serial call will be executed on HOST");
# line 169 "MakeRemapping.puma"
   MakeSerialArguments (basic_stmt->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2);
# line 170 "MakeRemapping.puma"
   MakeSerialVar (basic_stmt->ASSIGN_STMT.ASSIGN_VAR, & yyV3, & yyV4, & yyV5);
# line 172 "MakeRemapping.puma"
 basic_stmt->ASSIGN_STMT.ASSIGN_VAR = yyV3; 
# line 174 "MakeRemapping.puma"
   yyV1 = CombineACF (yyV4, yyV1);
# line 175 "MakeRemapping.puma"
   yyV2 = CombineACF (yyV2, yyV5);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL3:;

  }
  }
  if (basic_stmt->Kind == kCALL_STMT) {
# line 178 "MakeRemapping.puma"
 {
  bool found;
  var_descriptor home;
  {
# line 180 "MakeRemapping.puma"
   if (! ((IsSerialCall (basic_stmt)))) goto yyL4;
  {
# line 182 "MakeRemapping.puma"

# line 183 "MakeRemapping.puma"

# line 185 "MakeRemapping.puma"
   FindSerialHome (basic_stmt, & home, & found);
# line 186 "MakeRemapping.puma"
   if (! ((found))) goto yyL4;
  {
# line 188 "MakeRemapping.puma"
   stmt_protocol ("serial subroutine call on dedicated home (no remapping)");
# line 189 "MakeRemapping.puma"
   tree_protocol ("home of serial call : ", PrintableDescriptorVar (& home));
  }
  }
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;
 }
yyL4:;

# line 192 "MakeRemapping.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 194 "MakeRemapping.puma"
   if (! ((IsSerialCall (basic_stmt)))) goto yyL5;
  {
# line 196 "MakeRemapping.puma"
   stmt_protocol ("serial subroutine call will be executed on HOST");
# line 198 "MakeRemapping.puma"
   MakeSerialArguments (basic_stmt->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL5:;

# line 201 "MakeRemapping.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 203 "MakeRemapping.puma"
   ParamListRemapping (basic_stmt->CALL_STMT.CALL_PARAMS, basic_stmt, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
# line 206 "MakeRemapping.puma"
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static void IntrArgRemapping
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree var, register tTree actuals, register tTree * yyP4, register tTree * yyP3)
# else
(name, var, actuals, yyP4, yyP3)
 register tIdent name;
 register tTree var;
 register tTree actuals;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
  if (actuals->Kind == kBTP_LIST) {
  if (actuals->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (actuals->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 227 "MakeRemapping.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 230 "MakeRemapping.puma"
   if (! ((IntrFuncScatter (name)))) goto yyL1;
  {
# line 234 "MakeRemapping.puma"
   AlignParamList (actuals->BTP_LIST.Elem->VAR_PARAM.V, actuals->BTP_LIST.Next->BTP_LIST.Next, & yyV1, & yyV2);
  }
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }
yyL1:;

  }
  }
  }
# line 237 "MakeRemapping.puma"
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

;
}

static void AlignParamList
# if defined __STDC__ | defined __cplusplus
(register tTree target, register tTree params, register tTree * yyP6, register tTree * yyP5)
# else
(target, params, yyP6, yyP5)
 register tTree target;
 register tTree params;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
  if (params->Kind == kBTP_LIST) {
# line 249 "MakeRemapping.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 251 "MakeRemapping.puma"
   AlignParam (target, params->BTP_LIST.Elem, & yyV1, & yyV2);
# line 252 "MakeRemapping.puma"
   AlignParamList (target, params->BTP_LIST.Next, & yyV3, & yyV4);
# line 254 "MakeRemapping.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 255 "MakeRemapping.puma"
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }

  }
  if (params->Kind == kBTP_EMPTY) {
# line 258 "MakeRemapping.puma"
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

  }
# line 261 "MakeRemapping.puma"
  {
# line 263 "MakeRemapping.puma"
   failure_protocol (MODULE, "AlignParamList", params);
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

;
}

static void AlignParam
# if defined __STDC__ | defined __cplusplus
(register tTree target, register tTree param, register tTree * yyP8, register tTree * yyP7)
# else
(target, param, yyP8, yyP7)
 register tTree target;
 register tTree param;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
  if (param->Kind == kVAR_PARAM) {
# line 268 "MakeRemapping.puma"
  {
# line 272 "MakeRemapping.puma"
   if (! ((TreeRank (param->VAR_PARAM.V) == 0))) goto yyL1;
  {
# line 273 "MakeRemapping.puma"
   if (! ((TreeReadDistribution (param) == 0))) goto yyL1;
  }
  }
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;
yyL1:;

# line 276 "MakeRemapping.puma"
 {
  var_descriptor vd1;
  var_descriptor vd2;
  bool found;
  {
# line 278 "MakeRemapping.puma"

# line 279 "MakeRemapping.puma"

# line 281 "MakeRemapping.puma"

# line 283 "MakeRemapping.puma"
   GetVarDescriptor (target, & found, & vd1);
# line 284 "MakeRemapping.puma"
   if (! ((found))) goto yyL2;
  {
# line 285 "MakeRemapping.puma"
   GetVarDescriptor (param->VAR_PARAM.V, & found, & vd2);
# line 286 "MakeRemapping.puma"
   if (! ((found))) goto yyL2;
  {
# line 288 "MakeRemapping.puma"
 if (!VDIsAligned (&vd1, &vd2))
       { error_protocol ("SCATTER requires aligned parameters");
         tree_protocol ("not aligned argument is : ", param->VAR_PARAM.V);
         tree_protocol ("must be aligned to : ", target);
       }
   
  }
  }
  }
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;
 }
yyL2:;

  }
  if (param->Kind == kNO_PARAM) {
# line 296 "MakeRemapping.puma"
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

  }
# line 301 "MakeRemapping.puma"
  {
# line 303 "MakeRemapping.puma"
   error_protocol ("could not verify alignment in SCATTER");
# line 304 "MakeRemapping.puma"
   tree_protocol ("not verified argument is : ", param);
  }
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

;
}

static void ParamListRemapping
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register tTree call, register tTree * yyP10, register tTree * yyP9)
# else
(actuals, call, yyP10, yyP9)
 register tTree actuals;
 register tTree call;
 register tTree * yyP10;
 register tTree * yyP9;
# endif
{
  if (actuals->Kind == kBTP_LIST) {
# line 314 "MakeRemapping.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 316 "MakeRemapping.puma"
   ParamRemapping (actuals->BTP_LIST.Elem, call, & yyV1, & yyV2);
# line 317 "MakeRemapping.puma"
   ParamListRemapping (actuals->BTP_LIST.Next, call, & yyV3, & yyV4);
# line 319 "MakeRemapping.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 320 "MakeRemapping.puma"
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP10 = yyV1;
   * yyP9 = yyV2;
   return;
 }

  }
  if (actuals->Kind == kBTP_EMPTY) {
# line 323 "MakeRemapping.puma"
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   return;

  }
# line 326 "MakeRemapping.puma"
  {
# line 328 "MakeRemapping.puma"
   failure_protocol (MODULE, "ParamListRempapping", actuals);
  }
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   return;

;
}

static void ParamRemapping
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree call, register tTree * yyP12, register tTree * yyP11)
# else
(actual, call, yyP12, yyP11)
 register tTree actual;
 register tTree call;
 register tTree * yyP12;
 register tTree * yyP11;
# endif
{
  if (actual->Kind == kVAR_PARAM) {
# line 333 "MakeRemapping.puma"
 {
  bool found;
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  {
# line 335 "MakeRemapping.puma"
   if (! ((actual->VAR_PARAM.formal != NoObject))) goto yyL1;
  {
# line 336 "MakeRemapping.puma"
   if (! ((call != NoTree))) goto yyL1;
  {
# line 338 "MakeRemapping.puma"
   if (! ((GetCurrentModel () == HPF_GLOBAL))) goto yyL1;
  {
# line 340 "MakeRemapping.puma"
   if (! ((IsLocalCall (call)))) goto yyL1;
  {
# line 342 "MakeRemapping.puma"
   if (! ((MightBeRedistributed (call, actual, actual->VAR_PARAM.formal)))) goto yyL1;
  {
# line 344 "MakeRemapping.puma"

# line 345 "MakeRemapping.puma"

# line 347 "MakeRemapping.puma"
   GetDummyVarDescriptor (actual, actual->VAR_PARAM.formal, call, & found, & vard);
# line 349 "MakeRemapping.puma"
 if (!found)

       { error_protocol ("could not create dummy descriptor");
         tree_protocol ("actual", actual);
       }

     else

       { char msg[80];
         char vstr[40];
         StrUnparse (vstr, 40, actual->VAR_PARAM.V);
         sprintf (msg, "argument %s of call will be redistributed", vstr);
         serious_warning_protocol (msg);
       }

   
# line 366 "MakeRemapping.puma"
   if (! ((found))) goto yyL1;
  {
# line 368 "MakeRemapping.puma"
   MakeParamTemporary (actual, & vard, & yyV1, & yyV2);
  }
  }
  }
  }
  }
  }
  }
   * yyP12 = yyV1;
   * yyP11 = yyV2;
   return;
 }
yyL1:;

# line 371 "MakeRemapping.puma"
  {
# line 373 "MakeRemapping.puma"
   if (! ((actual->VAR_PARAM.formal != NoObject))) goto yyL2;
  {
# line 374 "MakeRemapping.puma"
   if (! ((call != NoTree))) goto yyL2;
  {
# line 378 "MakeRemapping.puma"
 

     if (MightBeRedistributed (call, actual, actual->VAR_PARAM.formal))

        { char msg[80];
          char vstr[40];
          StrUnparse (vstr, 40, actual->VAR_PARAM.V);
          sprintf (msg, "argument %s of call might be redistributed", vstr);
          serious_warning_protocol (msg);
        }
   
  }
  }
  }
   * yyP12 = NoTree;
   * yyP11 = NoTree;
   return;
yyL2:;

  }
# line 392 "MakeRemapping.puma"
   * yyP12 = NoTree;
   * yyP11 = NoTree;
   return;

;
}

static void IntrResRemapping
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree assign, register tTree * yyP14, register tTree * yyP13)
# else
(name, assign, yyP14, yyP13)
 register tIdent name;
 register tTree assign;
 register tTree * yyP14;
 register tTree * yyP13;
# endif
{
# line 404 "MakeRemapping.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 406 "MakeRemapping.puma"
   if (! ((IntrFuncRed (name) || IntrFuncLocRed (name)))) goto yyL1;
  {
# line 408 "MakeRemapping.puma"
   NewResultTmp (assign, & yyV1, & yyV2);
  }
  }
   * yyP14 = yyV1;
   * yyP13 = yyV2;
   return;
 }
yyL1:;

# line 411 "MakeRemapping.puma"
   * yyP14 = NoTree;
   * yyP13 = NoTree;
   return;

;
}

static void NewResultTmp
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register tTree * yyP16, register tTree * yyP15)
# else
(assign, yyP16, yyP15)
 register tTree assign;
 register tTree * yyP16;
 register tTree * yyP15;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
  if (assign->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 422 "MakeRemapping.puma"
 {
  bool found;
  var_descriptor vard1;
  var_descriptor vard2;
  {
# line 426 "MakeRemapping.puma"

# line 427 "MakeRemapping.puma"

# line 428 "MakeRemapping.puma"

# line 430 "MakeRemapping.puma"
   GetExpDescriptor (assign->ASSIGN_STMT.ASSIGN_EXP, & found, & vard2);
# line 431 "MakeRemapping.puma"
   if (! ((found))) goto yyL1;
  {
# line 433 "MakeRemapping.puma"
   GetVarDescriptor (assign->ASSIGN_STMT.ASSIGN_VAR, & found, & vard1);
# line 434 "MakeRemapping.puma"
   if (! ((found))) goto yyL1;
  {
# line 436 "MakeRemapping.puma"

#ifdef DEBUG
    if (!VDIsLocalAssignment (&vard1, &vard2))
       { printf ("temp for fn_call(1) in : ");
         FileUnparse (stdout, assign); printf ("\n");
         PrintVarDescriptor (&vard1);
         PrintVarDescriptor (&vard2);
       }
     else if (!VDIsLocalAssignment (&vard2, &vard1))
       { printf ("temp for fn_call(2) in : ");
         FileUnparse (stdout, assign); printf ("\n");
         PrintVarDescriptor (&vard1);
         PrintVarDescriptor (&vard2);
       }
#endif
   
# line 453 "MakeRemapping.puma"
   if (! ((VDIsLocalAssignment (& vard1, & vard2)))) goto yyL1;
  {
# line 454 "MakeRemapping.puma"
   if (! ((VDIsLocalAssignment (& vard2, & vard1)))) goto yyL1;
  }
  }
  }
  }
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;
 }
yyL1:;

# line 457 "MakeRemapping.puma"
 {
  bool found;
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 459 "MakeRemapping.puma"

# line 460 "MakeRemapping.puma"

# line 462 "MakeRemapping.puma"
   GetExpDescriptor (assign->ASSIGN_STMT.ASSIGN_EXP, & found, & vard);
# line 463 "MakeRemapping.puma"
   if (! ((found))) goto yyL2;
  {
# line 465 "MakeRemapping.puma"
   MakeNewAssignment (assign->ASSIGN_STMT.ASSIGN_EXP, & vard, & yyV1, & yyV2, & yyV3);
# line 466 "MakeRemapping.puma"
 assign->ASSIGN_STMT.ASSIGN_EXP = yyV1; 
  }
  }
   * yyP16 = yyV2;
   * yyP15 = yyV3;
   return;
 }
yyL2:;

# line 469 "MakeRemapping.puma"
  {
# line 471 "MakeRemapping.puma"
   error_protocol ("no descriptor for required result remapping found");
# line 472 "MakeRemapping.puma"
   tree_protocol ("call is : ", assign->ASSIGN_STMT.ASSIGN_EXP);
  }
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;

  }
  }
;
}

static void MakeSerialArguments
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register tTree * yyP18, register tTree * yyP17)
# else
(actuals, yyP18, yyP17)
 register tTree actuals;
 register tTree * yyP18;
 register tTree * yyP17;
# endif
{
  if (actuals->Kind == kBTP_LIST) {
# line 483 "MakeRemapping.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 485 "MakeRemapping.puma"
   MakeSerialArgument (actuals->BTP_LIST.Elem, & yyV1, & yyV2);
# line 486 "MakeRemapping.puma"
   MakeSerialArguments (actuals->BTP_LIST.Next, & yyV3, & yyV4);
# line 488 "MakeRemapping.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 489 "MakeRemapping.puma"
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP18 = yyV1;
   * yyP17 = yyV2;
   return;
 }

  }
  if (actuals->Kind == kBTP_EMPTY) {
# line 492 "MakeRemapping.puma"
   * yyP18 = NoTree;
   * yyP17 = NoTree;
   return;

  }
;
}

static void MakeSerialArgument
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree * yyP20, register tTree * yyP19)
# else
(actual, yyP20, yyP19)
 register tTree actual;
 register tTree * yyP20;
 register tTree * yyP19;
# endif
{
  if (actual->Kind == kVAR_PARAM) {
# line 497 "MakeRemapping.puma"
  {
# line 499 "MakeRemapping.puma"
   if (! ((AcceptedSerialVar (actual->VAR_PARAM.V)))) goto yyL1;
  }
   * yyP20 = NoTree;
   * yyP19 = NoTree;
   return;
yyL1:;

  }
  if (actual->Kind == kNO_PARAM) {
# line 502 "MakeRemapping.puma"
   * yyP20 = NoTree;
   * yyP19 = NoTree;
   return;

  }
  if (actual->Kind == kFUNC_PARAM) {
# line 505 "MakeRemapping.puma"
   * yyP20 = NoTree;
   * yyP19 = NoTree;
   return;

  }
  if (actual->Kind == kPROC_PARAM) {
# line 508 "MakeRemapping.puma"
   * yyP20 = NoTree;
   * yyP19 = NoTree;
   return;

  }
# line 511 "MakeRemapping.puma"
 {
  bool yyV1;
  var_descriptor yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 513 "MakeRemapping.puma"
   FindParamDescriptor (actual, & yyV1, & yyV2);
# line 514 "MakeRemapping.puma"
   if (! ((yyV1))) goto yyL5;
  {
# line 516 "MakeRemapping.puma"
 yyV2.topology_rank = -1;    
# line 518 "MakeRemapping.puma"
   MakeParamTemporary (actual, & yyV2, & yyV3, & yyV4);
  }
  }
   * yyP20 = yyV3;
   * yyP19 = yyV4;
   return;
 }
yyL5:;

# line 521 "MakeRemapping.puma"
  {
# line 523 "MakeRemapping.puma"
   error_protocol ("could not serialize actual argument");
# line 524 "MakeRemapping.puma"
   tree_protocol ("actual argument : ", actual);
  }
   * yyP20 = NoTree;
   * yyP19 = NoTree;
   return;

;
}

static void MakeSerialVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree * yyP23, register tTree * yyP22, register tTree * yyP21)
# else
(var, yyP23, yyP22, yyP21)
 register tTree var;
 register tTree * yyP23;
 register tTree * yyP22;
 register tTree * yyP21;
# endif
{
# line 529 "MakeRemapping.puma"
  {
# line 531 "MakeRemapping.puma"
   if (! ((AcceptedSerialVar (var)))) goto yyL1;
  }
   * yyP23 = var;
   * yyP22 = NoTree;
   * yyP21 = NoTree;
   return;
yyL1:;

# line 534 "MakeRemapping.puma"
 {
  var_descriptor vard;
  tTree pre_stmts;
  tTree post_stmts;
  tTree new_var;
  {
# line 536 "MakeRemapping.puma"

# line 538 "MakeRemapping.puma"
   SetVarDescriptor (var, & vard);
# line 540 "MakeRemapping.puma"
 vard.topology_rank = -1;    
# line 542 "MakeRemapping.puma"

# line 543 "MakeRemapping.puma"

# line 545 "MakeRemapping.puma"

# line 547 "MakeRemapping.puma"
   NoExpansion (vard);
# line 548 "MakeRemapping.puma"
   MakeTempVarStmt (var, IntentOut, vard, & new_var, & pre_stmts, & post_stmts);
  }
   * yyP23 = new_var;
   * yyP22 = pre_stmts;
   * yyP21 = post_stmts;
   return;
 }

;
}

static bool AcceptedSerialVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 559 "MakeRemapping.puma"
 {
  int dist;
  {
# line 561 "MakeRemapping.puma"
   if (! ((TreeRank (var) > 0))) goto yyL1;
  {
# line 563 "MakeRemapping.puma"

# line 565 "MakeRemapping.puma"
   dist = TreeWriteDistribution (var);
# line 567 "MakeRemapping.puma"
   if (! (((dist == 0) || (dist == - 1) || (dist == 2)))) goto yyL1;
  }
  }
   return true;
 }
yyL1:;

# line 570 "MakeRemapping.puma"
  {
# line 572 "MakeRemapping.puma"
   if (! ((TreeRank (var) > 0))) goto yyL2;
  {
# line 573 "MakeRemapping.puma"
   return false;
  }
  }
yyL2:;

# line 576 "MakeRemapping.puma"
   return true;

}

static bool MightBeRedistributed
# if defined __STDC__ | defined __cplusplus
(register tTree p, register tTree actual, register tDefinitions dummy)
# else
(p, actual, dummy)
 register tTree p;
 register tTree actual;
 register tDefinitions dummy;
# endif
{
# line 589 "MakeRemapping.puma"
 {
  bool might_be;
  var_descriptor dummy_vard;
  bool yyV1;
  var_descriptor yyV2;
  {
# line 591 "MakeRemapping.puma"

# line 592 "MakeRemapping.puma"

# line 594 "MakeRemapping.puma"
   FindParamDescriptor (actual, & yyV1, & yyV2);
# line 596 "MakeRemapping.puma"
 might_be = true;

     if (yyV1)
 
       { SetVarObjDescriptor (&dummy_vard, dummy, NoTree);

         

         might_be = (! IsSpecialisation (&yyV2, &dummy_vard));

       }
   
# line 609 "MakeRemapping.puma"
   if (! ((might_be))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

static void FindParamDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register bool * yyP25, var_descriptor * yyP24)
# else
(actual, yyP25, yyP24)
 register tTree actual;
 register bool * yyP25;
 var_descriptor * yyP24;
# endif
{
# line 620 "MakeRemapping.puma"
 {
  bool found;
  var_descriptor vard;
  {
# line 622 "MakeRemapping.puma"

# line 623 "MakeRemapping.puma"

# line 625 "MakeRemapping.puma"
   GetParamDescriptor (actual, & found, & vard);
# line 626 "MakeRemapping.puma"
   if (! ((found))) goto yyL1;
  }
   * yyP25 = found;
   * yyP24 = vard;
   return;
 }
yyL1:;

# line 629 "MakeRemapping.puma"
 {
  var_descriptor vard;
  {
# line 631 "MakeRemapping.puma"

  }
   * yyP25 = false;
   * yyP24 = vard;
   return;
 }

;
}

static void MakeParamTemporary
# if defined __STDC__ | defined __cplusplus
(register tTree actual, pvar vard, register tTree * yyP27, register tTree * yyP26)
# else
(actual, vard, yyP27, yyP26)
 register tTree actual;
 pvar vard;
 register tTree * yyP27;
 register tTree * yyP26;
# endif
{
  if (actual->Kind == kVAR_PARAM) {
  if (actual->VAR_PARAM.V->Kind == kADDR) {
# line 642 "MakeRemapping.puma"
 {
  tTree pre_stmts;
  tTree post_stmts;
  tTree assign;
  tTree tmp_var;
  {
# line 647 "MakeRemapping.puma"

# line 648 "MakeRemapping.puma"

# line 649 "MakeRemapping.puma"

# line 650 "MakeRemapping.puma"

# line 652 "MakeRemapping.puma"
   NoExpansion (vard);
# line 653 "MakeRemapping.puma"
   MakeTemporaryStmt (actual->VAR_PARAM.V->ADDR.E, vard, & pre_stmts, & tmp_var, & assign, & post_stmts);
# line 655 "MakeRemapping.puma"
 actual->VAR_PARAM.V = tmp_var; 
  }
   * yyP27 = CombineACF (pre_stmts, assign);
   * yyP26 = post_stmts;
   return;
 }

  }
# line 658 "MakeRemapping.puma"
 {
  tTree pre_stmts;
  tTree post_stmts;
  tTree new_var;
  {
# line 660 "MakeRemapping.puma"

# line 661 "MakeRemapping.puma"

# line 663 "MakeRemapping.puma"

# line 665 "MakeRemapping.puma"
   NoExpansion (vard);
# line 666 "MakeRemapping.puma"
   MakeTempVarStmt (actual->VAR_PARAM.V, actual->VAR_PARAM.intent, vard, & new_var, & pre_stmts, & post_stmts);
# line 668 "MakeRemapping.puma"
 actual->VAR_PARAM.V = new_var; 
  }
   * yyP27 = pre_stmts;
   * yyP26 = post_stmts;
   return;
 }

  }
# line 671 "MakeRemapping.puma"
  {
# line 673 "MakeRemapping.puma"
   failure_protocol (MODULE, "MakeParamTemporary", actual);
  }
   * yyP27 = NoTree;
   * yyP26 = NoTree;
   return;

;
}

static void MakeNewAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard, register tTree * yyP30, register tTree * yyP29, register tTree * yyP28)
# else
(exp, vard, yyP30, yyP29, yyP28)
 register tTree exp;
 pvar vard;
 register tTree * yyP30;
 register tTree * yyP29;
 register tTree * yyP28;
# endif
{
# line 684 "MakeRemapping.puma"
 {
  tTree pre_stmt;
  tTree post_stmt;
  tTree tmp_var;
  tTree assign;
  {
# line 686 "MakeRemapping.puma"

# line 687 "MakeRemapping.puma"

# line 688 "MakeRemapping.puma"

# line 690 "MakeRemapping.puma"

# line 692 "MakeRemapping.puma"
   NoExpansion (vard);
# line 694 "MakeRemapping.puma"
   MakeTemporaryStmt (exp, vard, & pre_stmt, & tmp_var, & assign, & post_stmt);
  }
   * yyP30 = mVAR_EXP (tmp_var);
   * yyP29 = CombineACF (pre_stmt, assign);
   * yyP28 = post_stmt;
   return;
 }

;
}

void BeginMakeRemapping ()
{
}

void CloseMakeRemapping ()
{
}
