# include "MakeReductions.h"
# include "yyMakeReductions.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 23 "MakeReductions.puma"


# include "protocol.h"

# define MODULE "MakeReductions"

static tTree new_var;
static tIdent old_id;

# include "Transform.h"
# include "Traverse.h"
# include "DefTable.h"
# include "VarDescriptor.h"
# include "Temporary.h"
# include "Reductions.h"  /* InitReduction */
# include "TreeOps.h"
# include "Types.h"
# include "Nesting.h"     /* GetCurrentModel */
# include "Expansion.h"   /* NoExpansion     */

# undef DEBUG



static void yyExit () { Exit (1); }

void (* MakeReductions_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeReductions, routine %s failed\n", yyFunction);
 MakeReductions_Exit ();
}

void MakeReductions ARGS((tTree t));
static bool StopMakeReductions ARGS((tTree t));
static tTree DoMakeReductions ARGS((tTree t));
static bool NeedsLocalVariable ARGS((tTree reduction));
static tTree MakeTempReduction ARGS((tTree reduction));
static void ReplaceVar ARGS((tTree body, tTree old, tTree new));
static void ReplaceVarId ARGS((tTree t));
static void ChangeVariable ARGS((tTree var, tIdent old_id, tTree new_var));
static tTree Get_VAR_OBJ ARGS((tTree t));
static tTree Get_USED_VAR ARGS((tTree t));

void MakeReductions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 55 "MakeReductions.puma"
  {
# line 57 "MakeReductions.puma"
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeReductions, DoMakeReductions); 
  }
   return;

  }
# line 60 "MakeReductions.puma"
  {
# line 61 "MakeReductions.puma"
   failure_protocol (MODULE, "MakeReductions", t);
  }
   return;

;
}

static bool StopMakeReductions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
# line 75 "MakeReductions.puma"
   return true;

  }
  if (Tree_IsType (t, kBT_EXP)) {
# line 78 "MakeReductions.puma"
   return true;

  }
  return false;
}

static tTree DoMakeReductions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_REDUCTION) {
# line 89 "MakeReductions.puma"
  {
# line 91 "MakeReductions.puma"
   if (! ((NeedsLocalVariable (t)))) goto yyL1;
  }
   return MakeTempReduction (t);
yyL1:;

  }
# line 96 "MakeReductions.puma"
   return t;

}

static bool NeedsLocalVariable
# if defined __STDC__ | defined __cplusplus
(register tTree reduction)
# else
(reduction)
 register tTree reduction;
# endif
{
  if (reduction->Kind == kACF_REDUCTION) {
# line 111 "MakeReductions.puma"
  {
# line 115 "MakeReductions.puma"
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  {
# line 116 "MakeReductions.puma"
   if (! ((! sm_parallelization))) goto yyL1;
  {
# line 118 "MakeReductions.puma"
   return false;
  }
  }
  }
yyL1:;

# line 121 "MakeReductions.puma"
  {
# line 123 "MakeReductions.puma"
   if (! ((reduction->ACF_REDUCTION.REDUCTION_FUNC->PROC_OBJ.Ident == DefaultId ()))) goto yyL2;
  {
# line 125 "MakeReductions.puma"
   return false;
  }
  }
yyL2:;

  }
# line 128 "MakeReductions.puma"
   return true;

}

static tTree MakeTempReduction
# if defined __STDC__ | defined __cplusplus
(register tTree reduction)
# else
(reduction)
 register tTree reduction;
# endif
{
  if (reduction->Kind == kACF_REDUCTION) {
  if (reduction->ACF_REDUCTION.REDUCTION_VAR->Kind == kBTV_LIST) {
  if (reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next->Kind == kBTV_EMPTY) {
# line 159 "MakeReductions.puma"
 {
  var_descriptor tmp_var;
  tTree new_var;
  tTree alloc;
  tTree dealloc;
  tTree init_stmt;
  tTree red_stmt;
  tTree new_stmt;
  {
# line 163 "MakeReductions.puma"

# line 164 "MakeReductions.puma"

# line 165 "MakeReductions.puma"

# line 166 "MakeReductions.puma"

# line 168 "MakeReductions.puma"

# line 169 "MakeReductions.puma"

# line 170 "MakeReductions.puma"

# line 172 "MakeReductions.puma"
   set_protocol_stmt (reduction);
# line 174 "MakeReductions.puma"
 SetVarDescriptor (reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem, &tmp_var);

     NoExpansion (&tmp_var);

     

     tmp_var.topology_rank = 0;
     tmp_var.topology_obj = GetDefaultTopology(0);

     new_var = GetVDTemporary (&tmp_var);

     GetMemoryStmts (&alloc, &dealloc);

     init_stmt = InitReductionStmt (CopyTree (new_var), TreeType(new_var), reduction->ACF_REDUCTION.REDUCTION_FUNC);
     red_stmt  = mACF_BASIC (GenRedAssign (CopyTree (reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem),
                                     mVAR_EXP (CopyTree (new_var)), reduction->ACF_REDUCTION.REDUCTION_FUNC->PROC_OBJ.Ident));

     ReplaceVar (reduction, reduction->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Elem, new_var);

     new_stmt = CombineACF (alloc,
                 CombineACF (init_stmt,
                  CombineACF (reduction, 
                   CombineACF (red_stmt,
                    CombineACF (dealloc, mACF_EMPTY ())))));

     new_stmt = mACF_NEW (mBTV_LIST (Get_USED_VAR (new_var), mBTV_EMPTY()), 
                          new_stmt);

   
  }
  {
   return new_stmt;
  }
 }

  }
  }
  }
# line 207 "MakeReductions.puma"
  {
# line 209 "MakeReductions.puma"
   failure_protocol (MODULE, "MakeTempReduction", reduction);
  }
   return NoTree;

}

static void ReplaceVar
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree old, register tTree new)
# else
(body, old, new)
 register tTree body;
 register tTree old;
 register tTree new;
# endif
{
# line 223 "MakeReductions.puma"
  {
# line 225 "MakeReductions.puma"
 old_id  = TreeVarName (old);
     new_var = Get_VAR_OBJ (new);

     FullTraverseAST (body, ReplaceVarId); 
   
  }
   return;

;
}

static void ReplaceVarId
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_OBJ) {
# line 234 "MakeReductions.puma"
  {
# line 236 "MakeReductions.puma"
   ChangeVariable (t, old_id, new_var);
  }
   return;

  }
;
}

static void ChangeVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent old_id, register tTree new_var)
# else
(var, old_id, new_var)
 register tTree var;
 register tIdent old_id;
 register tTree new_var;
# endif
{
  if (var->Kind == kVAR_OBJ) {
  if (new_var->Kind == kVAR_OBJ) {
# line 241 "MakeReductions.puma"
  {
# line 244 "MakeReductions.puma"
 if (var->VAR_OBJ.Ident == old_id)

       { var->VAR_OBJ.Ident  = new_var->VAR_OBJ.Ident; 
         var->VAR_OBJ.Object = new_var->VAR_OBJ.Object;
         var->VAR_OBJ.Reaching  = new_var->VAR_OBJ.Reaching;
       }
   
  }
   return;

  }
  }
# line 254 "MakeReductions.puma"
  {
# line 256 "MakeReductions.puma"
   failure_protocol (MODULE, "ChangeVariable", var);
  }
   return;

;
}

static tTree Get_VAR_OBJ
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
# line 266 "MakeReductions.puma"
   return Get_VAR_OBJ (t->USED_VAR.VARNAME);

  }
  if (t->Kind == kVAR_OBJ) {
# line 271 "MakeReductions.puma"
   return t;

  }
  if (t->Kind == kINDEXED_VAR) {
# line 276 "MakeReductions.puma"
   return Get_VAR_OBJ (t->INDEXED_VAR.IND_VAR);

  }
# line 281 "MakeReductions.puma"
  {
# line 282 "MakeReductions.puma"
   failure_protocol (MODULE, "Get_VAR_OBJ", t);
  }
   return NoTree;

}

static tTree Get_USED_VAR
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
# line 289 "MakeReductions.puma"
   return t;

  }
  if (t->Kind == kINDEXED_VAR) {
# line 294 "MakeReductions.puma"
   return Get_USED_VAR (t->INDEXED_VAR.IND_VAR);

  }
# line 299 "MakeReductions.puma"
  {
# line 300 "MakeReductions.puma"
   failure_protocol (MODULE, "Get_USED_VAR", t);
  }
   return NoTree;

}

void BeginMakeReductions ()
{
}

void CloseMakeReductions ()
{
}
