# include "MakeRagged.h"
# include "yyMakeRagged.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 27 "MakeRagged.puma"


# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "DefTable.h"

# include "Objects.h"
# include "Types.h"
# include "Nesting.h"
# include "Transform.h"
# include "MapDefs.h"     /* SetDistribution */
# include "SemMap.h"      /* EvalObjDistribution */
# include "BuildTree.h"   /* ConcatDecls         */
# include "Rank.h"

# define MODULE "MakeRagged"



static void yyExit () { Exit (1); }

void (* MakeRagged_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeRagged, routine %s failed\n", yyFunction);
 MakeRagged_Exit ();
}

tTree MakeRaggedDecls ARGS((tTree decl, tDefinitions obj));
static tTree TranslateTreeObject ARGS((tDefinitions tree_obj, tDefinitions ragged_obj, int level, tIdent name, tTree type));
static tTree TranslateTypeComponents ARGS((tDefinitions tree_obj, tDefinitions ragged_obj, int level, tIdent name, tDefinitions entries));
static tDefinitions GetTypeEntries ARGS((tDefinitions t));
static tIdent AddId ARGS((tIdent name, tIdent add));
static void AddRaggedObject ARGS((tDefinitions ragged_obj, int level, tDefinitions obj));
static tDefinitions AddRaggedComponent ARGS((tDefinitions levels, int depth, int level, tDefinitions obj));
static int GetDistributionLevel ARGS((tDefinitions obj));
static int GetFirstDistDim ARGS((tDefinitions dim));
static tTree MakeDistributeDecl ARGS((tIdent name, int level, int dist_level));
bool IsTreeAccess ARGS((tTree t));
tTree MakeRaggedAccess ARGS((tTree var));
static bool IsRaggedVarAccess ARGS((tTree var));
static tTree MakeRaggedVarAccess ARGS((tTree var));
tTree MakeRaggedTreeAccess ARGS((tTree var));
static tTree AppendIndexes ARGS((tTree var, tTree indexes));
static void AppendId ARGS((tTree var, tIdent id));
tTree MakeRaggedAllocates ARGS((tTree stmt));
static tTree TranslateAllocParams ARGS((tTree params));
tTree MakeRaggedDeallocates ARGS((tTree stmt));
static tTree CheckEmptyDeallocate ARGS((tTree stmt));
static tTree TranslateDeallocParams ARGS((tTree params));
static void GetRaggedObject ARGS((tTree t, tDefinitions * yyP1));
static tTree MakeAllAllocates ARGS((tDefinitions def, tTree tail));
static tTree MakeAllDeallocates ARGS((tDefinitions def, tTree tail));
static tTree MakeDeferredShape ARGS((int rank));

tTree MakeRaggedDecls
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tDefinitions obj)
# else
(decl, obj)
 register tTree decl;
 register tDefinitions obj;
# endif
{
# line 56 "MakeRagged.puma"
  {
# line 58 "MakeRagged.puma"
   if (! ((! IsTreeObject (obj)))) goto yyL1;
  }
   return decl;
yyL1:;

  if (decl->Kind == kVAR_DECL) {
  if (obj->Kind == kVarObject) {
# line 63 "MakeRagged.puma"
 {
  tDefinitions ragged_obj;
  tTree ragged_decl;
  tTree comp_decls;
  {
# line 66 "MakeRagged.puma"

# line 67 "MakeRagged.puma"

# line 68 "MakeRagged.puma"

# line 70 "MakeRagged.puma"
 int i;

     ragged_obj = mRaggedObject (obj->VarObject.Ident, obj->VarObject.decl, obj->VarObject.private, obj->VarObject.in, 0, mSCOPE_EMPTY (), obj->VarObject.Dist);

     comp_decls = TranslateTreeObject (obj, ragged_obj, 0, decl->VAR_DECL.Ident, 
                                       GetObjectType (obj));

     ragged_decl = mRAGGED_DECL (decl->VAR_DECL.Ident, decl->VAR_DECL.Line, 
                                 MakeDeferredShape (ragged_obj->RaggedObject.depth));

     ragged_obj->RaggedObject.decl = ragged_decl;

     ChangeEntry (decl->VAR_DECL.Ident, ragged_obj);

   
  }
  {
   return mDECL_LIST (ragged_decl, comp_decls);
  }
 }

  }
  }
  if (decl->Kind == kTREE_DECL) {
# line 89 "MakeRagged.puma"
   return NoTree;

  }
# line 94 "MakeRagged.puma"
  {
# line 96 "MakeRagged.puma"
   failure_protocol (MODULE, "MakeRaggedDecls", decl);
  }
   return NoTree;

}

static tTree TranslateTreeObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions tree_obj, register tDefinitions ragged_obj, register int level, register tIdent name, register tTree type)
# else
(tree_obj, ragged_obj, level, name, type)
 register tDefinitions tree_obj;
 register tDefinitions ragged_obj;
 register int level;
 register tIdent name;
 register tTree type;
# endif
{
  if (type->Kind == kPOINTER_TYPE) {
# line 110 "MakeRagged.puma"
   return TranslateTreeObject (tree_obj, ragged_obj, level, name, type->POINTER_TYPE.PTR_COMP);

  }
  if (type->Kind == kARRAY_TYPE) {
  if (type->ARRAY_TYPE.ARRAY_COMP_TYPE->Kind == kTYPE_ID) {
# line 115 "MakeRagged.puma"
   return TranslateTypeComponents (tree_obj, ragged_obj, level + 1, name, GetTypeEntries (type->ARRAY_TYPE.ARRAY_COMP_TYPE->TYPE_ID.ID->TYPE_OBJ.Object));

  }
  }
  if (ragged_obj->Kind == kRaggedObject) {
# line 121 "MakeRagged.puma"
 {
  tTree new_decl;
  tTree new_dist;
  tTree new_type;
  tDefinitions new_obj;
  {
# line 123 "MakeRagged.puma"

# line 124 "MakeRagged.puma"

# line 126 "MakeRagged.puma"

# line 127 "MakeRagged.puma"

# line 129 "MakeRagged.puma"
 int i;

     if (level > ragged_obj->RaggedObject.depth) ragged_obj->RaggedObject.depth = level;

     new_type = mARRAY_TYPE (MakeDeferredShape (level), 
                             CopyTree(type));

     new_decl = mVAR_DECL (name, 0, new_type);

     new_obj = MakeNewObject (new_decl, ragged_obj);

     new_obj->VarObject.Kind->VarLocal.dynamic = arr_assumed_shape;

     new_dist = MakeDistributeDecl (name, level, GetDistributionLevel (tree_obj));

     InsertEntry (new_obj);

     AddRaggedObject (ragged_obj, level, new_obj);

     SetDistributions (new_dist, GetCurrentUnitObject());
     EvalObjDistribution (new_obj);

   
  }
  {
   return mDECL_LIST (new_decl, mDECL_LIST (new_dist, NoTree));
  }
 }

  }
 yyAbort ("TranslateTreeObject");
}

static tTree TranslateTypeComponents
# if defined __STDC__ | defined __cplusplus
(register tDefinitions tree_obj, register tDefinitions ragged_obj, register int level, register tIdent name, register tDefinitions entries)
# else
(tree_obj, ragged_obj, level, name, entries)
 register tDefinitions tree_obj;
 register tDefinitions ragged_obj;
 register int level;
 register tIdent name;
 register tDefinitions entries;
# endif
{
  if (entries->Kind == kENTRY_LIST) {
# line 161 "MakeRagged.puma"
   return ConcatDecls (TranslateTypeComponents (tree_obj, ragged_obj, level, name, entries->ENTRY_LIST.Elem), TranslateTypeComponents (tree_obj, ragged_obj, level, name, entries->ENTRY_LIST.Next));

  }
  if (entries->Kind == kENTRY_EMPTY) {
# line 168 "MakeRagged.puma"
   return NoTree;

  }
  if (entries->Kind == kVarObject) {
# line 173 "MakeRagged.puma"
   return TranslateTreeObject (tree_obj, ragged_obj, level, AddId (name, entries->VarObject.Ident), GetObjectType (entries));

  }
 yyAbort ("TranslateTypeComponents");
}

static tDefinitions GetTypeEntries
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kTypeObject) {
# line 185 "MakeRagged.puma"
   return t->TypeObject.Components;

  }
 yyAbort ("GetTypeEntries");
}

static tIdent AddId
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tIdent add)
# else
(name, add)
 register tIdent name;
 register tIdent add;
# endif
{
# line 192 "MakeRagged.puma"

char str1[MAXID_LENGTH], str2[MAXID_LENGTH], str3[MAXID_LENGTH]; 

# line 196 "MakeRagged.puma"
  {
# line 198 "MakeRagged.puma"
   GetString (name, str1);
# line 199 "MakeRagged.puma"
   GetString (add, str2);
# line 200 "MakeRagged.puma"
   sprintf (str3, "%s_%s", str1, str2);
  }
   return IsIdent (str3);

}

static void AddRaggedObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions ragged_obj, register int level, register tDefinitions obj)
# else
(ragged_obj, level, obj)
 register tDefinitions ragged_obj;
 register int level;
 register tDefinitions obj;
# endif
{
  if (ragged_obj->Kind == kRaggedObject) {
# line 211 "MakeRagged.puma"
  {
# line 213 "MakeRagged.puma"
 if (level > ragged_obj->RaggedObject.depth) ragged_obj->RaggedObject.depth = level;

     printf ("add ragged component at level  %d\n", level);

     ragged_obj->RaggedObject.Levels = AddRaggedComponent (ragged_obj->RaggedObject.Levels, 1, level, obj);
   
  }
   return;

  }
;
}

static tDefinitions AddRaggedComponent
# if defined __STDC__ | defined __cplusplus
(register tDefinitions levels, register int depth, register int level, register tDefinitions obj)
# else
(levels, depth, level, obj)
 register tDefinitions levels;
 register int depth;
 register int level;
 register tDefinitions obj;
# endif
{
# line 224 "MakeRagged.puma"
  {
# line 226 "MakeRagged.puma"
   printf ("add ragged component at depth %d, level %d\n", depth, level);
# line 227 "MakeRagged.puma"
   goto yyL1;
  }
yyL1:;

  if (levels->Kind == kSCOPE_LIST) {
# line 230 "MakeRagged.puma"
  {
# line 232 "MakeRagged.puma"
   if (! ((depth == level))) goto yyL2;
  {
# line 234 "MakeRagged.puma"
 levels->SCOPE_LIST.Table = mENTRY_LIST (obj, levels->SCOPE_LIST.Table); 
  }
  }
   return levels;
yyL2:;

# line 239 "MakeRagged.puma"
  {
# line 241 "MakeRagged.puma"
   if (! ((depth < level))) goto yyL3;
  {
# line 243 "MakeRagged.puma"
 levels->SCOPE_LIST.Hidden = AddRaggedComponent (levels->SCOPE_LIST.Hidden, depth+1, level, obj); 
  }
  }
   return levels;
yyL3:;

  }
  if (levels->Kind == kSCOPE_EMPTY) {
# line 248 "MakeRagged.puma"
  {
# line 250 "MakeRagged.puma"
   if (! ((depth == level))) goto yyL4;
  }
   return mSCOPE_LIST (mENTRY_LIST (obj, mENTRY_EMPTY ()), mSCOPE_EMPTY ());
yyL4:;

# line 255 "MakeRagged.puma"
  {
# line 257 "MakeRagged.puma"
   if (! ((depth < level))) goto yyL5;
  }
   return mSCOPE_LIST (mSCOPE_EMPTY (), AddRaggedComponent (levels, depth + 1, level, obj));
yyL5:;

  }
# line 263 "MakeRagged.puma"
   return levels;

}

static int GetDistributionLevel
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
# line 281 "MakeRagged.puma"
   return GetDistributionLevel (obj->VarObject.Dist);

  }
  if (obj->Kind == kNodeDistribution) {
# line 286 "MakeRagged.puma"
   return GetFirstDistDim (obj->NodeDistribution.ArrayList);

  }
# line 291 "MakeRagged.puma"
   return 0;

}

static int GetFirstDistDim
# if defined __STDC__ | defined __cplusplus
(register tDefinitions dim)
# else
(dim)
 register tDefinitions dim;
# endif
{
  if (dim->Kind == kDIM_LIST) {
  if (dim->DIM_LIST.Elem->Kind == kDistributedDimension) {
# line 297 "MakeRagged.puma"
   return 1;

  }
# line 302 "MakeRagged.puma"
   return GetFirstDistDim (dim->DIM_LIST.Next) + 1;

  }
  if (dim->Kind == kDIM_EMPTY) {
# line 307 "MakeRagged.puma"
   return 1;

  }
 yyAbort ("GetFirstDistDim");
}

static tTree MakeDistributeDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int level, register int dist_level)
# else
(name, level, dist_level)
 register tIdent name;
 register int level;
 register int dist_level;
# endif
{
# line 320 "MakeRagged.puma"
 {
  tTree decl;
  {
# line 322 "MakeRagged.puma"

# line 324 "MakeRagged.puma"
 

     int i;

     decl = mDIST_EMPTY ();

     for (i=level; i>= 1; i--)
        if (i == dist_level)
            decl = mDIST_LIST (mBLOCK_DISTRIBUTION (mDUMMY_EXP()), decl);
          else
            decl = mDIST_LIST (mSERIAL_DISTRIBUTION (), decl);

     decl = mNODE_DISTRIBUTION (0, decl);

     decl = mDISTRIBUTE_DECL (name, 0, decl,
                              mDEFAULT_PROCESSOR_ARRAY());
   
  }
  {
   return decl;
  }
 }

}

bool IsTreeAccess
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
# line 347 "MakeRagged.puma"
  {
# line 349 "MakeRagged.puma"
   if (! ((IsTreeAccess (t->INDEXED_VAR.IND_VAR)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kSELECTED_VAR) {
# line 352 "MakeRagged.puma"
  {
# line 354 "MakeRagged.puma"
   if (! ((IsTreeAccess (t->SELECTED_VAR.SELEC_VAR)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (t->Kind == kUSED_VAR) {
# line 357 "MakeRagged.puma"
  {
# line 359 "MakeRagged.puma"
   if (! ((IsTreeObject (t->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

tTree MakeRaggedAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 370 "MakeRagged.puma"
  {
# line 372 "MakeRagged.puma"
   if (! ((IsRaggedVarAccess (var)))) goto yyL1;
  }
   return MakeRaggedVarAccess (var);
yyL1:;

# line 377 "MakeRagged.puma"
   return MakeRaggedTreeAccess (var);

}

static bool IsRaggedVarAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kSELECTED_VAR) {
# line 384 "MakeRagged.puma"
  {
# line 386 "MakeRagged.puma"
   if (! ((VarRank (var->SELECTED_VAR.SELECTOR->REC_COMP.Object) == 0))) goto yyL1;
  }
   return true;
yyL1:;

  }
  return false;
}

static tTree MakeRaggedVarAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 391 "MakeRagged.puma"
   return AppendIndexes (MakeRaggedVarAccess (var->INDEXED_VAR.IND_VAR), var->INDEXED_VAR.IND_EXPS);

  }
  if (var->Kind == kSELECTED_VAR) {
# line 396 "MakeRagged.puma"
 {
  tTree new;
  {
# line 398 "MakeRagged.puma"

# line 400 "MakeRagged.puma"
   new = MakeRaggedVarAccess (var->SELECTED_VAR.SELEC_VAR);
# line 402 "MakeRagged.puma"
   AppendId (new, var->SELECTED_VAR.SELECTOR->REC_COMP.Ident);
  }
  {
   return new;
  }
 }

  }
  if (var->Kind == kUSED_VAR) {
# line 407 "MakeRagged.puma"
   return var;

  }
# line 412 "MakeRagged.puma"
  {
# line 413 "MakeRagged.puma"
   failure_protocol (MODULE, "MakeRaggedVarAccess", var);
  }
   return NoTree;

}

tTree MakeRaggedTreeAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 425 "MakeRagged.puma"
   return AppendIndexes (MakeRaggedTreeAccess (var->INDEXED_VAR.IND_VAR), var->INDEXED_VAR.IND_EXPS);

  }
  if (var->Kind == kSELECTED_VAR) {
# line 430 "MakeRagged.puma"
   return MakeRaggedTreeAccess (var->SELECTED_VAR.SELEC_VAR);

  }
  if (var->Kind == kUSED_VAR) {
# line 435 "MakeRagged.puma"
  {
# line 437 "MakeRagged.puma"
 var->USED_VAR.VARNAME->VAR_OBJ.Object = GetGlobalObject (var->USED_VAR.VARNAME->VAR_OBJ.Ident); 
  }
   return var;

  }
# line 442 "MakeRagged.puma"
  {
# line 443 "MakeRagged.puma"
   failure_protocol (MODULE, "MakeRaggedVarAccess", var);
  }
   return NoTree;

}

static tTree AppendIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree indexes)
# else
(var, indexes)
 register tTree var;
 register tTree indexes;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 449 "MakeRagged.puma"
   return mINDEXED_VAR (var, indexes);

  }
  if (var->Kind == kINDEXED_VAR) {
# line 454 "MakeRagged.puma"
  {
# line 456 "MakeRagged.puma"
 var->INDEXED_VAR.IND_EXPS = AppendIndexes (var->INDEXED_VAR.IND_EXPS, indexes); 
  }
   return var;

  }
  if (var->Kind == kBTE_LIST) {
  if (var->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 461 "MakeRagged.puma"
  {
# line 463 "MakeRagged.puma"
 var->BTE_LIST.Next = indexes; 
  }
   return var;

  }
# line 468 "MakeRagged.puma"
  {
# line 470 "MakeRagged.puma"
 var->BTE_LIST.Next = AppendIndexes (var->BTE_LIST.Next, indexes); 
  }
   return var;

  }
# line 475 "MakeRagged.puma"
  {
# line 477 "MakeRagged.puma"
   failure_protocol (MODULE, "AppendIndexes", var);
  }
   return NoTree;

}

static void AppendId
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent id)
# else
(var, id)
 register tTree var;
 register tIdent id;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 484 "MakeRagged.puma"
  {
# line 486 "MakeRagged.puma"
 var->USED_VAR.VARNAME->VAR_OBJ.Ident = AddId (var->USED_VAR.VARNAME->VAR_OBJ.Ident, id);
     var->USED_VAR.VARNAME->VAR_OBJ.Object  = GetGlobalObject (var->USED_VAR.VARNAME->VAR_OBJ.Ident);
   
  }
   return;

  }
  if (var->Kind == kINDEXED_VAR) {
# line 491 "MakeRagged.puma"
  {
# line 493 "MakeRagged.puma"
   AppendId (var->INDEXED_VAR.IND_VAR, id);
  }
   return;

  }
# line 496 "MakeRagged.puma"
  {
# line 498 "MakeRagged.puma"
   failure_protocol (MODULE, "AppendId", var);
  }
   return;

;
}

tTree MakeRaggedAllocates
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
# line 509 "MakeRagged.puma"
  {
# line 511 "MakeRagged.puma"
 stmt->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS = TranslateAllocParams (stmt->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS); 
  }
   return stmt;

  }
  }
# line 516 "MakeRagged.puma"
  {
# line 518 "MakeRagged.puma"
   failure_protocol (MODULE, "MakeRaggedAllocates", stmt);
  }
   return NoTree;

}

static tTree TranslateAllocParams
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 531 "MakeRagged.puma"
 {
  tDefinitions yyV1;
  {
# line 533 "MakeRagged.puma"
   if (! ((IsTreeAccess (params->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL1;
  {
# line 535 "MakeRagged.puma"
   GetRaggedObject (params->BTP_LIST.Elem->VAR_PARAM.V, & yyV1);
# line 537 "MakeRagged.puma"
 params->BTP_LIST.Next = MakeAllAllocates (yyV1, TranslateAllocParams (params->BTP_LIST.Next)); 
  }
  }
  {
   return params;
  }
 }
yyL1:;

  }
# line 542 "MakeRagged.puma"
  {
# line 544 "MakeRagged.puma"
   if (! ((IsTreeAccess (params->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL2;
  {
# line 546 "MakeRagged.puma"
 params->BTP_LIST.Elem->VAR_PARAM.V    = MakeRaggedTreeAccess (params->BTP_LIST.Elem->VAR_PARAM.V); 
     params->BTP_LIST.Next = TranslateAllocParams (params->BTP_LIST.Next); 
  }
  }
   return params;
yyL2:;

# line 552 "MakeRagged.puma"
  {
# line 554 "MakeRagged.puma"
 params->BTP_LIST.Next = TranslateAllocParams (params->BTP_LIST.Next); 
  }
   return params;

  }
  }
  if (params->Kind == kBTP_EMPTY) {
# line 559 "MakeRagged.puma"
   return params;

  }
 yyAbort ("TranslateAllocParams");
}

tTree MakeRaggedDeallocates
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
# line 572 "MakeRagged.puma"
  {
# line 574 "MakeRagged.puma"
 stmt->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS = TranslateDeallocParams (stmt->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS); 
  }
   return CheckEmptyDeallocate (stmt);

  }
  }
# line 579 "MakeRagged.puma"
  {
# line 581 "MakeRagged.puma"
   failure_protocol (MODULE, "MakeRaggedAllocates", stmt);
  }
   return NoTree;

}

static tTree CheckEmptyDeallocate
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
  if (stmt->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS->Kind == kBTP_EMPTY) {
# line 588 "MakeRagged.puma"
   return NoTree;

  }
  }
  }
# line 593 "MakeRagged.puma"
   return stmt;

}

static tTree TranslateDeallocParams
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 600 "MakeRagged.puma"
 {
  tDefinitions yyV1;
  {
# line 602 "MakeRagged.puma"
   if (! ((IsTreeAccess (params->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL1;
  {
# line 604 "MakeRagged.puma"
 params->BTP_LIST.Next = TranslateDeallocParams (params->BTP_LIST.Next); 
# line 606 "MakeRagged.puma"
   GetRaggedObject (params->BTP_LIST.Elem->VAR_PARAM.V, & yyV1);
  }
  }
  {
   return MakeAllDeallocates (yyV1, params);
  }
 }
yyL1:;

  }
# line 611 "MakeRagged.puma"
  {
# line 613 "MakeRagged.puma"
   if (! ((IsTreeAccess (params->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL2;
  }
   return TranslateDeallocParams (params->BTP_LIST.Next);
yyL2:;

# line 619 "MakeRagged.puma"
  {
# line 621 "MakeRagged.puma"
 params->BTP_LIST.Next = TranslateDeallocParams (params->BTP_LIST.Next); 
  }
   return params;

  }
  }
  if (params->Kind == kBTP_EMPTY) {
# line 626 "MakeRagged.puma"
   return params;

  }
 yyAbort ("TranslateDeallocParams");
}

static void GetRaggedObject
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions * yyP1)
# else
(t, yyP1)
 register tTree t;
 register tDefinitions * yyP1;
# endif
{
  if (t->Kind == kUSED_VAR) {
# line 633 "MakeRagged.puma"
  {
# line 635 "MakeRagged.puma"
 t->USED_VAR.VARNAME->VAR_OBJ.Object = GetGlobalObject (t->USED_VAR.VARNAME->VAR_OBJ.Ident); 
  }
   * yyP1 = t->USED_VAR.VARNAME->VAR_OBJ.Object;
   return;

  }
;
}

static tTree MakeAllAllocates
# if defined __STDC__ | defined __cplusplus
(register tDefinitions def, register tTree tail)
# else
(def, tail)
 register tDefinitions def;
 register tTree tail;
# endif
{
  if (def->Kind == kRaggedObject) {
# line 641 "MakeRagged.puma"
   return MakeAllAllocates (def->RaggedObject.Levels, tail);

  }
  if (def->Kind == kSCOPE_LIST) {
# line 646 "MakeRagged.puma"
  {
# line 648 "MakeRagged.puma"
   printf ("scope list\n");
  }
   return MakeAllAllocates (def->SCOPE_LIST.Table, MakeAllAllocates (def->SCOPE_LIST.Hidden, tail));

  }
  if (def->Kind == kSCOPE_EMPTY) {
# line 654 "MakeRagged.puma"
   return tail;

  }
  if (def->Kind == kENTRY_LIST) {
# line 659 "MakeRagged.puma"
   return MakeAllAllocates (def->ENTRY_LIST.Elem, MakeAllAllocates (def->ENTRY_LIST.Next, tail));

  }
  if (def->Kind == kENTRY_EMPTY) {
# line 665 "MakeRagged.puma"
   return tail;

  }
  if (def->Kind == kVarObject) {
# line 670 "MakeRagged.puma"
 {
  tTree stmt;
  {
# line 672 "MakeRagged.puma"
   printf ("make allocate for object of ragged array\n");
# line 674 "MakeRagged.puma"

# line 676 "MakeRagged.puma"
 stmt = mVAR_OBJ (0, def->VarObject.Ident);
     stmt->VAR_OBJ.Object = def;

     stmt = mVAR_PARAM (mUSED_VAR (stmt));
     stmt = mBTP_LIST (stmt, tail);
   
  }
  {
   return stmt;
  }
 }

  }
 yyAbort ("MakeAllAllocates");
}

static tTree MakeAllDeallocates
# if defined __STDC__ | defined __cplusplus
(register tDefinitions def, register tTree tail)
# else
(def, tail)
 register tDefinitions def;
 register tTree tail;
# endif
{
  if (def->Kind == kRaggedObject) {
# line 688 "MakeRagged.puma"
   return MakeAllDeallocates (def->RaggedObject.Levels, tail);

  }
  if (def->Kind == kSCOPE_LIST) {
# line 693 "MakeRagged.puma"
   return MakeAllDeallocates (def->SCOPE_LIST.Hidden, MakeAllDeallocates (def->SCOPE_LIST.Table, tail));

  }
  if (def->Kind == kSCOPE_EMPTY) {
# line 699 "MakeRagged.puma"
   return tail;

  }
  if (def->Kind == kENTRY_LIST) {
# line 704 "MakeRagged.puma"
   return MakeAllDeallocates (def->ENTRY_LIST.Next, MakeAllDeallocates (def->ENTRY_LIST.Elem, tail));

  }
  if (def->Kind == kENTRY_EMPTY) {
# line 710 "MakeRagged.puma"
   return tail;

  }
  if (def->Kind == kVarObject) {
# line 715 "MakeRagged.puma"
 {
  tTree params;
  {
# line 717 "MakeRagged.puma"
   printf ("make deallocate for object of ragged array\n");
# line 719 "MakeRagged.puma"

# line 721 "MakeRagged.puma"
 params = mVAR_OBJ (0, def->VarObject.Ident);
     params->VAR_OBJ.Object = def;

     params = mVAR_PARAM (mUSED_VAR (params));
     params = mBTP_LIST (params, tail);
   
  }
  {
   return params;
  }
 }

  }
 yyAbort ("MakeAllDeallocates");
}

static tTree MakeDeferredShape
# if defined __STDC__ | defined __cplusplus
(register int rank)
# else
(rank)
 register int rank;
# endif
{
# line 733 "MakeRagged.puma"
  {
# line 735 "MakeRagged.puma"
   if (! ((rank <= 0))) goto yyL1;
  }
   return mSHAPE_EMPTY ();
yyL1:;

# line 740 "MakeRagged.puma"
 {
  tTree shp;
  {
# line 742 "MakeRagged.puma"

# line 744 "MakeRagged.puma"
 shp = mDEFERRED_SHAPE ();
     shp->DEFERRED_SHAPE.Overlap = mOVERLAP_SPEC (0, 0, 0, 0);
   
  }
  {
   return mSHAPE_LIST (shp, MakeDeferredShape (rank - 1));
  }
 }

}

void BeginMakeRagged ()
{
}

void CloseMakeRagged ()
{
}
