# include "MakeParLoops.h"
# include "yyMakeParLoops.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 34 "MakeParLoops.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Transform.h" 
# include "Traverse.h"
# include "FindHome.h"
# include "Temporary.h"

# include "Descriptor.h"
# include "MoveDescriptor.h"

# include "MakeSerial.h"            /* MakeSerial             */
# include "TempFunctions.h"         /* MakeTempFunctions      */
# include "MakeArguments.h"         /* MakeArguments          */
# include "MakeRemapping.h"         /* MakeRemapping          */
# include "MakeOvUpdates.h"         /* MakeOvUpdates          */
# include "MakeForall.h"            /* MakeForall             */
# include "Nesting.h"
# include "Objects.h"

# define MODULE "MakeParLoops"



static void yyExit () { Exit (1); }

void (* MakeParLoops_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeParLoops, routine %s failed\n", yyFunction);
 MakeParLoops_Exit ();
}

void MakeParLoops ARGS((tTree t));

void MakeParLoops
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kCOMP_UNIT:
# line 75 "MakeParLoops.puma"
  {
# line 77 "MakeParLoops.puma"
   open_protocol ("adaptor.loops");
# line 78 "MakeParLoops.puma"
   MakeParLoops (t->COMP_UNIT.COMP_ELEMENTS);
# line 79 "MakeParLoops.puma"
   close_protocol ();
  }
   return;

  case kUNIT_LIST:
# line 84 "MakeParLoops.puma"
  {
# line 86 "MakeParLoops.puma"
   MakeParLoops (t->UNIT_LIST.Elem);
# line 87 "MakeParLoops.puma"
   MakeParLoops (t->UNIT_LIST.Next);
  }
   return;

  case kUNIT_EMPTY:
# line 90 "MakeParLoops.puma"
   return;

  case kPROGRAM_DECL:
# line 93 "MakeParLoops.puma"
  {
# line 95 "MakeParLoops.puma"
   NestOpenUnit (t);
# line 96 "MakeParLoops.puma"
   MakeParLoops (t->PROGRAM_DECL.PROGRAM_BODY);
# line 97 "MakeParLoops.puma"
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
# line 100 "MakeParLoops.puma"
  {
# line 102 "MakeParLoops.puma"
   NestOpenUnit (t);
# line 103 "MakeParLoops.puma"
   MakeParLoops (t->PROC_DECL.PROC_BODY);
# line 104 "MakeParLoops.puma"
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
# line 107 "MakeParLoops.puma"
  {
# line 109 "MakeParLoops.puma"
   NestOpenUnit (t);
# line 110 "MakeParLoops.puma"
   MakeParLoops (t->FUNC_DECL.FUNC_BODY);
# line 111 "MakeParLoops.puma"
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 114 "MakeParLoops.puma"
  {
# line 116 "MakeParLoops.puma"
   NestOpenUnit (t);
# line 117 "MakeParLoops.puma"
   MakeParLoops (t->BLOCK_DATA_DECL.DATA_BODY);
# line 118 "MakeParLoops.puma"
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
# line 121 "MakeParLoops.puma"
  {
# line 123 "MakeParLoops.puma"
   NestOpenUnit (t);
# line 124 "MakeParLoops.puma"
   MakeParLoops (t->MODULE_DECL.MODULE_BODY);
# line 125 "MakeParLoops.puma"
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
# line 128 "MakeParLoops.puma"
  {
# line 130 "MakeParLoops.puma"
   if (! ((IsPureUnit (GetCurrentUnit ())))) goto yyL9;
  }
   return;
yyL9:;

# line 135 "MakeParLoops.puma"
  {
# line 137 "MakeParLoops.puma"
   TemporaryInit (t);
# line 139 "MakeParLoops.puma"
   MakeForall (t);
# line 141 "MakeParLoops.puma"
   TemporaryDone (t);
# line 143 "MakeParLoops.puma"
   MakeParLoops (t->BODY_NODE.INTERNALS);
  }
   return;

  }

;
}

void BeginMakeParLoops ()
{
}

void CloseMakeParLoops ()
{
}
