# include "MakeOvUpdates.h"
# include "yyMakeOvUpdates.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 32 "MakeOvUpdates.puma"


# define MODULE "MakeOvUpdates"

# include "Idents.h"
# include "StringMem.h"
# include "protocol.h"

# include "Types.h"
# include "Transform.h"             /* ReplaceACF       */
# include "Expressions.h"           /* MakeConstant     */

# include "MoveControl.h"           /* GetShifting, ... */
# include "OverlapUpdate.h"         /* SetOverlapUpdate, ... */



static void yyExit () { Exit (1); }

void (* MakeOvUpdates_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeOvUpdates, routine %s failed\n", yyFunction);
 MakeOvUpdates_Exit ();
}

void MakeOvUpdates ARGS((tTree t));
static tTree OverlapUpdateACF ARGS((tTree t));
static void OverlapUpdateParallel ARGS((tTree stmt));
static void OverlapUpdateMask ARGS((tTree stmt, tTree mask));
static void OverlapUpdateWHERE ARGS((tTree stmt, tTree mask, tTree * yyP1));
static tTree ReplaceCShifts ARGS((tTree exp));
static tTree TranslateCSHIFT ARGS((tTree exp));
static void OverlapUpdates ARGS((tTree var, tTree exp));
static void OverlapIndexUpdates ARGS((tTree owner, tTree var));
static void OverlapVarUpdates ARGS((tTree left_var, tTree right_var));
static void ApplyShiftToVar ARGS((tTree var, pshift pos));
static void ApplyShiftToIndexes ARGS((tTree indexes, int n, pshift pos));
static bool ValidOverlapUpdate ARGS((tTree var, pshift pos));
static bool IsEnoughVarOverlap ARGS((tTree indexes, int dim, pshift pos));
static bool SufficientOverlapIndex ARGS((tTree index, int pos));

void MakeOvUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 57 "MakeOvUpdates.puma"
  {
# line 59 "MakeOvUpdates.puma"
 t->BODY_NODE.STATS = OverlapUpdateACF (t->BODY_NODE.STATS); 
  }
   return;

  }
# line 62 "MakeOvUpdates.puma"
  {
# line 63 "MakeOvUpdates.puma"
   failure_protocol (MODULE, "MakeOvUpdates", t);
  }
   return;

;
}

static tTree OverlapUpdateACF
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 78 "MakeOvUpdates.puma"
 {
  tTree newacf;
  {
# line 80 "MakeOvUpdates.puma"

# line 82 "MakeOvUpdates.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 84 "MakeOvUpdates.puma"
 newacf = OverlapUpdateACF (t->ACF_LIST.Elem);            
     t->ACF_LIST.Next   = OverlapUpdateACF (t->ACF_LIST.Next);            
   
# line 88 "MakeOvUpdates.puma"
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
  {
   return newacf;
  }
 }

  case kACF_EMPTY:
# line 93 "MakeOvUpdates.puma"
   return t;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
# line 97 "MakeOvUpdates.puma"
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
# line 101 "MakeOvUpdates.puma"
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCREATE_DSP_STMT) {
# line 105 "MakeOvUpdates.puma"
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kFREE_DSP_STMT) {
# line 109 "MakeOvUpdates.puma"
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 113 "MakeOvUpdates.puma"
 {
  tTree OvUpdates;
  tTree NewStmt;
  {
# line 115 "MakeOvUpdates.puma"

# line 116 "MakeOvUpdates.puma"

# line 118 "MakeOvUpdates.puma"
 InitOverlapUpdates ();               

     

     t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = ReplaceCShifts (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

     

     OverlapUpdates (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

     

     OvUpdates = GetOverlapUpdates ();

     if (OvUpdates != NoTree)

        { NewStmt = CombineACF (t, GetOverlapResets ());
          NewStmt = CombineACF (OvUpdates, NewStmt);

          stmt_protocol ("assignment takes advantage of overlap");
          tree_protocol ("new stmt is :\n", NewStmt);
        }

      else

        NewStmt = t;

   
  }
  {
   return NewStmt;
  }
 }

  }
# line 150 "MakeOvUpdates.puma"
   return t;

  case kACF_IF:
# line 154 "MakeOvUpdates.puma"
  {
# line 156 "MakeOvUpdates.puma"
 t->ACF_IF.THEN_PART = OverlapUpdateACF (t->ACF_IF.THEN_PART);
     t->ACF_IF.ELSE_PART = OverlapUpdateACF (t->ACF_IF.ELSE_PART);
   
  }
   return t;

  case kACF_DUMMY:
# line 162 "MakeOvUpdates.puma"
   return t;

  case kACF_WHILE:
# line 166 "MakeOvUpdates.puma"
  {
# line 168 "MakeOvUpdates.puma"
 t->ACF_WHILE.WHILE_BODY = OverlapUpdateACF (t->ACF_WHILE.WHILE_BODY); 
  }
   return t;

  case kACF_DO:
  if (t->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
# line 172 "MakeOvUpdates.puma"
  {
# line 174 "MakeOvUpdates.puma"
 t->ACF_DO.DO_BODY = OverlapUpdateACF (t->ACF_DO.DO_BODY); 
  }
   return t;

  }
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 246 "MakeOvUpdates.puma"
 {
  tTree OvUpdates;
  tTree NewStmt;
  {
# line 248 "MakeOvUpdates.puma"

# line 249 "MakeOvUpdates.puma"

# line 251 "MakeOvUpdates.puma"
 InitOverlapUpdates ();               
 
     
 
     OverlapUpdateParallel (t->ACF_DO.DO_BODY);
 
     VectorizeOverlapUpdates (t->ACF_DO.DO_ID, t->ACF_DO.DO_RANGE);
 
     
 
     OvUpdates = GetOverlapUpdates ();
 
     if (OvUpdates != NoTree)
 
        { NewStmt = CombineACF (t, GetOverlapResets ());
          NewStmt = CombineACF (OvUpdates, NewStmt);
 
          stmt_protocol ("independent do loop takes advantage of overlap");
          tree_protocol ("new stmt is :\n", NewStmt);
        }
 
      else
 
        NewStmt = t;
 
   
  }
  {
   return NewStmt;
  }
 }

  }
  break;
  }

  if (t->Kind == kACF_WHERE) {
# line 179 "MakeOvUpdates.puma"
 {
  tTree OvUpdates;
  tTree NewStmt;
  {
# line 181 "MakeOvUpdates.puma"

# line 182 "MakeOvUpdates.puma"

# line 186 "MakeOvUpdates.puma"
 NewStmt = t;

     InitOverlapUpdates ();

     OverlapUpdateWHERE (t->ACF_WHERE.TRUE_PART, t->ACF_WHERE.WHERE_EXP, &t->ACF_WHERE.WHERE_EXP);
     OverlapUpdateWHERE (t->ACF_WHERE.FALSE_PART, t->ACF_WHERE.WHERE_EXP, &t->ACF_WHERE.WHERE_EXP);

     

     OvUpdates = GetOverlapUpdates ();

     if (OvUpdates != NoTree)

        { NewStmt = CombineACF (t, GetOverlapResets ());
          NewStmt = CombineACF (OvUpdates, NewStmt);

          stmt_protocol ("where takes advantage of overlap");
          tree_protocol ("new stmt is :\n", NewStmt);
        }

   
  }
  {
   return NewStmt;
  }
 }

  }
  if (t->Kind == kACF_FORALL) {
# line 211 "MakeOvUpdates.puma"
 {
  tTree OvUpdates;
  tTree NewStmt;
  {
# line 213 "MakeOvUpdates.puma"

# line 214 "MakeOvUpdates.puma"

# line 216 "MakeOvUpdates.puma"
 InitOverlapUpdates ();               

     

     OverlapUpdateParallel (t->ACF_FORALL.FORALL_BODY);

     VectorizeOverlapUpdates (t->ACF_FORALL.FORALL_ID, t->ACF_FORALL.FORALL_RANGE);

     

     OvUpdates = GetOverlapUpdates ();

     if (OvUpdates != NoTree)

        { NewStmt = CombineACF (t, GetOverlapResets ());
          NewStmt = CombineACF (OvUpdates, NewStmt);

          stmt_protocol ("assignment takes advantage of overlap");
          tree_protocol ("new stmt is :\n", NewStmt);
        }

      else

        NewStmt = t;

   
  }
  {
   return NewStmt;
  }
 }

  }
  if (Tree_IsType (t, kACF_NODE)) {
# line 281 "MakeOvUpdates.puma"
   return t;

  }
# line 285 "MakeOvUpdates.puma"
  {
# line 286 "MakeOvUpdates.puma"
   failure_protocol (MODULE, "OverlapUpdateACF", t);
  }
   return NoTree;

}

static void OverlapUpdateParallel
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{

  switch (stmt->Kind) {
  case kACF_EMPTY:
# line 298 "MakeOvUpdates.puma"
   return;

  case kACF_LIST:
# line 301 "MakeOvUpdates.puma"
  {
# line 303 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_LIST.Elem);
# line 304 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_LIST.Next);
  }
   return;

  case kACF_IF:
# line 307 "MakeOvUpdates.puma"
  {
# line 309 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_IF.THEN_PART);
# line 310 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_IF.ELSE_PART);
# line 311 "MakeOvUpdates.puma"
   OverlapUpdateMask (stmt->ACF_IF.THEN_PART, stmt->ACF_IF.IF_EXP);
# line 312 "MakeOvUpdates.puma"
   OverlapUpdateMask (stmt->ACF_IF.ELSE_PART, stmt->ACF_IF.IF_EXP);
  }
   return;

  case kACF_WHERE:
# line 315 "MakeOvUpdates.puma"
  {
# line 317 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_WHERE.TRUE_PART);
# line 318 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_WHERE.FALSE_PART);
# line 319 "MakeOvUpdates.puma"
   OverlapUpdateMask (stmt->ACF_WHERE.TRUE_PART, stmt->ACF_WHERE.WHERE_EXP);
# line 320 "MakeOvUpdates.puma"
   OverlapUpdateMask (stmt->ACF_WHERE.FALSE_PART, stmt->ACF_WHERE.WHERE_EXP);
  }
   return;

  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 323 "MakeOvUpdates.puma"
  {
# line 325 "MakeOvUpdates.puma"
  
# line 327 "MakeOvUpdates.puma"
   OverlapUpdates (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 330 "MakeOvUpdates.puma"
   return;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 333 "MakeOvUpdates.puma"
   return;

  }
# line 338 "MakeOvUpdates.puma"
   return;

  case kACF_FORALL:
# line 341 "MakeOvUpdates.puma"
  {
# line 343 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_FORALL.FORALL_BODY);
# line 344 "MakeOvUpdates.puma"
   VectorizeOverlapUpdates (stmt->ACF_FORALL.FORALL_ID, stmt->ACF_FORALL.FORALL_RANGE);
  }
   return;

  case kACF_DO:
# line 347 "MakeOvUpdates.puma"
  {
# line 349 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_DO.DO_BODY);
# line 350 "MakeOvUpdates.puma"
   VectorizeOverlapUpdates (stmt->ACF_DO.DO_ID, stmt->ACF_DO.DO_RANGE);
  }
   return;

  case kACF_HOME:
# line 353 "MakeOvUpdates.puma"
  {
# line 355 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_HOME.HOME_BODY);
  }
   return;

  case kACF_NEW:
# line 358 "MakeOvUpdates.puma"
  {
# line 360 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_NEW.NEW_BODY);
  }
   return;

  case kACF_REDUCTION:
# line 363 "MakeOvUpdates.puma"
  {
# line 365 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_REDUCTION.REDUCTION_BODY);
  }
   return;

  case kACF_RESIDENT:
# line 368 "MakeOvUpdates.puma"
  {
# line 370 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_RESIDENT.RESIDENT_BODY);
  }
   return;

  case kACF_WHILE:
# line 373 "MakeOvUpdates.puma"
  {
# line 375 "MakeOvUpdates.puma"
   OverlapUpdateParallel (stmt->ACF_WHILE.WHILE_BODY);
  }
   return;

  case kACF_DUMMY:
# line 378 "MakeOvUpdates.puma"
   return;

  }

# line 381 "MakeOvUpdates.puma"
  {
# line 382 "MakeOvUpdates.puma"
   failure_protocol (MODULE, "OverlapUpdateParallel", stmt);
  }
   return;

;
}

static void OverlapUpdateMask
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree mask)
# else
(stmt, mask)
 register tTree stmt;
 register tTree mask;
# endif
{
  if (stmt->Kind == kACF_EMPTY) {
# line 397 "MakeOvUpdates.puma"
   return;

  }
  if (stmt->Kind == kACF_LIST) {
# line 400 "MakeOvUpdates.puma"
  {
# line 402 "MakeOvUpdates.puma"
   OverlapUpdateMask (stmt->ACF_LIST.Elem, mask);
# line 403 "MakeOvUpdates.puma"
   OverlapUpdateMask (stmt->ACF_LIST.Next, mask);
  }
   return;

  }
  if (stmt->Kind == kACF_WHERE) {
# line 406 "MakeOvUpdates.puma"
  {
# line 408 "MakeOvUpdates.puma"
   OverlapUpdateMask (stmt->ACF_WHERE.TRUE_PART, mask);
# line 409 "MakeOvUpdates.puma"
   OverlapUpdateMask (stmt->ACF_WHERE.FALSE_PART, mask);
  }
   return;

  }
  if (stmt->Kind == kACF_IF) {
# line 412 "MakeOvUpdates.puma"
  {
# line 414 "MakeOvUpdates.puma"
   OverlapUpdateMask (stmt->ACF_IF.THEN_PART, mask);
# line 415 "MakeOvUpdates.puma"
   OverlapUpdateMask (stmt->ACF_IF.ELSE_PART, mask);
  }
   return;

  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 418 "MakeOvUpdates.puma"
  {
# line 420 "MakeOvUpdates.puma"
   OverlapUpdates (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, mask);
  }
   return;

  }
  }
;
}

static void OverlapUpdateWHERE
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree mask, register tTree * yyP1)
# else
(stmt, mask, yyP1)
 register tTree stmt;
 register tTree mask;
 register tTree * yyP1;
# endif
{
# line 442 "MakeOvUpdates.puma"
  {
# line 444 "MakeOvUpdates.puma"
   if (! ((stmt == NoTree))) goto yyL1;
  {
# line 445 "MakeOvUpdates.puma"
   failure_protocol (MODULE, "OverlapUpdateWHERE", stmt);
  }
  }
   * yyP1 = NoTree;
   return;
yyL1:;

  if (stmt->Kind == kACF_EMPTY) {
# line 448 "MakeOvUpdates.puma"
   * yyP1 = mask;
   return;

  }
  if (stmt->Kind == kACF_LIST) {
# line 451 "MakeOvUpdates.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 453 "MakeOvUpdates.puma"
   OverlapUpdateWHERE (stmt->ACF_LIST.Elem, mask, & yyV1);
# line 454 "MakeOvUpdates.puma"
   OverlapUpdateWHERE (stmt->ACF_LIST.Next, yyV1, & yyV2);
  }
   * yyP1 = yyV2;
   return;
 }

  }
  if (stmt->Kind == kACF_WHERE) {
# line 457 "MakeOvUpdates.puma"
   * yyP1 = mask;
   return;

  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 462 "MakeOvUpdates.puma"
 {
  tTree new_mask;
  {
# line 466 "MakeOvUpdates.puma"
 stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = ReplaceCShifts (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP); 
# line 470 "MakeOvUpdates.puma"
   OverlapUpdates (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
# line 472 "MakeOvUpdates.puma"

# line 476 "MakeOvUpdates.puma"
 new_mask = ReplaceCShifts (mask); 
# line 480 "MakeOvUpdates.puma"
   OverlapUpdates (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, new_mask);
  }
   * yyP1 = new_mask;
   return;
 }

  }
  }
# line 483 "MakeOvUpdates.puma"
  {
# line 484 "MakeOvUpdates.puma"
   failure_protocol (MODULE, "OverlapUpdateWHERE", stmt);
  }
   * yyP1 = NoTree;
   return;

;
}

static tTree ReplaceCShifts
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kDUMMY_EXP:
# line 495 "MakeOvUpdates.puma"
   return exp;

  case kCONST_EXP:
# line 499 "MakeOvUpdates.puma"
   return exp;

  case kBOUND_EXP:
# line 503 "MakeOvUpdates.puma"
   return exp;

  case kRANK_EXP:
# line 507 "MakeOvUpdates.puma"
   return exp;

  case kARRAY_EXP:
# line 511 "MakeOvUpdates.puma"
   return exp;

  case kTYPE_EXP:
# line 515 "MakeOvUpdates.puma"
   return exp;

  case kSLICE_EXP:
# line 519 "MakeOvUpdates.puma"
   return exp;

  case kOP_EXP:
# line 523 "MakeOvUpdates.puma"
  {
# line 524 "MakeOvUpdates.puma"
 exp->OP_EXP.OPND1 = ReplaceCShifts (exp->OP_EXP.OPND1);
     exp->OP_EXP.OPND2 = ReplaceCShifts (exp->OP_EXP.OPND2);
   
  }
   return exp;

  case kOP1_EXP:
# line 530 "MakeOvUpdates.puma"
  {
# line 531 "MakeOvUpdates.puma"
 exp->OP1_EXP.OPND = ReplaceCShifts (exp->OP1_EXP.OPND); 
  }
   return exp;

  case kPERM_EXP:
# line 535 "MakeOvUpdates.puma"
   return exp;

  case kVAR_EXP:
# line 539 "MakeOvUpdates.puma"
   return exp;

  case kFUNC_CALL_EXP:
# line 543 "MakeOvUpdates.puma"
  {
# line 544 "MakeOvUpdates.puma"
   if (! ((IsIntrCall (exp)))) goto yyL12;
  {
# line 545 "MakeOvUpdates.puma"
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("CSHIFT", 6)))) goto yyL12;
  }
  }
   return TranslateCSHIFT (exp);
yyL12:;

# line 549 "MakeOvUpdates.puma"
  {
# line 550 "MakeOvUpdates.puma"
   if (! ((IsIntrCall (exp)))) goto yyL13;
  {
# line 551 "MakeOvUpdates.puma"
   if (! ((IntrFuncElemental (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL13;
  {
# line 552 "MakeOvUpdates.puma"
 exp->FUNC_CALL_EXP.FUNC_PARAMS = ReplaceCShifts (exp->FUNC_CALL_EXP.FUNC_PARAMS); 
  }
  }
  }
   return exp;
yyL13:;

# line 584 "MakeOvUpdates.puma"
   return exp;

  case kBTP_LIST:
# line 556 "MakeOvUpdates.puma"
  {
# line 558 "MakeOvUpdates.puma"
 exp->BTP_LIST.Elem = ReplaceCShifts (exp->BTP_LIST.Elem); 
     exp->BTP_LIST.Next = ReplaceCShifts (exp->BTP_LIST.Next); 
   
  }
   return exp;

  case kBTP_EMPTY:
# line 564 "MakeOvUpdates.puma"
   return exp;

  case kNO_PARAM:
# line 569 "MakeOvUpdates.puma"
   return exp;

  case kVAR_PARAM:
  if (exp->VAR_PARAM.V->Kind == kADDR) {
# line 574 "MakeOvUpdates.puma"
  {
# line 576 "MakeOvUpdates.puma"
 exp->VAR_PARAM.V->ADDR.E = ReplaceCShifts (exp->VAR_PARAM.V->ADDR.E); 
  }
   return exp;

  }
# line 580 "MakeOvUpdates.puma"
   return exp;

  }

# line 588 "MakeOvUpdates.puma"
  {
# line 589 "MakeOvUpdates.puma"
   failure_protocol (MODULE, "ReplaceCShifts", exp);
  }
   return exp;

}

static tTree TranslateCSHIFT
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
# line 604 "MakeOvUpdates.puma"
 {
  shift_vector pos;
  bool found;
  tTree var;
  {
# line 606 "MakeOvUpdates.puma"

# line 607 "MakeOvUpdates.puma"

# line 608 "MakeOvUpdates.puma"

# line 610 "MakeOvUpdates.puma"
   GetCircularShifting (exp, & found, & var, & pos);
# line 611 "MakeOvUpdates.puma"
   if (! ((found))) goto yyL1;
  {
# line 613 "MakeOvUpdates.puma"
   stmt_protocol ("replace CSHIFT");
# line 615 "MakeOvUpdates.puma"
   if (! ((ValidOverlapUpdate (var, & pos)))) goto yyL1;
  {
# line 619 "MakeOvUpdates.puma"
   SetShiftOverlapUpdate (var, & pos);
# line 621 "MakeOvUpdates.puma"
   tree_protocol ("this is updated var: ", var);
# line 623 "MakeOvUpdates.puma"
   ApplyShiftToVar (var, & pos);
# line 625 "MakeOvUpdates.puma"
   tree_protocol ("this is shifted var: ", var);
  }
  }
  }
  {
   return mVAR_EXP (var);
  }
 }
yyL1:;

# line 630 "MakeOvUpdates.puma"
   return exp;

  }
 yyAbort ("TranslateCSHIFT");
}

static void OverlapUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kDUMMY_EXP:
# line 642 "MakeOvUpdates.puma"
   return;

  case kCONST_EXP:
# line 645 "MakeOvUpdates.puma"
   return;

  case kARRAY_EXP:
# line 648 "MakeOvUpdates.puma"
   return;

  case kBOUND_EXP:
# line 651 "MakeOvUpdates.puma"
   return;

  case kTYPE_EXP:
# line 654 "MakeOvUpdates.puma"
   return;

  case kSLICE_EXP:
# line 657 "MakeOvUpdates.puma"
   return;

  case kOP_EXP:
# line 660 "MakeOvUpdates.puma"
  {
# line 661 "MakeOvUpdates.puma"
   OverlapUpdates (var, exp->OP_EXP.OPND1);
# line 662 "MakeOvUpdates.puma"
   OverlapUpdates (var, exp->OP_EXP.OPND2);
  }
   return;

  case kOP1_EXP:
# line 665 "MakeOvUpdates.puma"
  {
# line 666 "MakeOvUpdates.puma"
   OverlapUpdates (var, exp->OP1_EXP.OPND);
  }
   return;

  case kPERM_EXP:
# line 669 "MakeOvUpdates.puma"
   return;

  case kVAR_EXP:
# line 672 "MakeOvUpdates.puma"
  {
# line 673 "MakeOvUpdates.puma"
   OverlapVarUpdates (var, exp->VAR_EXP.V);
# line 674 "MakeOvUpdates.puma"
   OverlapIndexUpdates (var, exp->VAR_EXP.V);
  }
   return;

  case kFUNC_CALL_EXP:
# line 677 "MakeOvUpdates.puma"
  {
# line 678 "MakeOvUpdates.puma"
   if (! ((IsIntrCall (exp)))) goto yyL11;
  {
# line 679 "MakeOvUpdates.puma"
   if (! ((IntrFuncElemental (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL11;
  {
# line 680 "MakeOvUpdates.puma"
   OverlapUpdates (var, exp->FUNC_CALL_EXP.FUNC_PARAMS);
  }
  }
  }
   return;
yyL11:;

# line 683 "MakeOvUpdates.puma"
   return;

  case kBTP_LIST:
# line 686 "MakeOvUpdates.puma"
  {
# line 687 "MakeOvUpdates.puma"
   OverlapUpdates (var, exp->BTP_LIST.Elem);
# line 688 "MakeOvUpdates.puma"
   OverlapUpdates (var, exp->BTP_LIST.Next);
  }
   return;

  case kBTP_EMPTY:
# line 691 "MakeOvUpdates.puma"
   return;

  case kBTE_LIST:
# line 694 "MakeOvUpdates.puma"
  {
# line 695 "MakeOvUpdates.puma"
   OverlapUpdates (var, exp->BTE_LIST.Elem);
# line 696 "MakeOvUpdates.puma"
   OverlapUpdates (var, exp->BTE_LIST.Next);
  }
   return;

  case kBTE_EMPTY:
# line 699 "MakeOvUpdates.puma"
   return;

  case kNO_PARAM:
# line 702 "MakeOvUpdates.puma"
   return;

  case kVAR_PARAM:
  if (exp->VAR_PARAM.V->Kind == kADDR) {
# line 705 "MakeOvUpdates.puma"
  {
# line 706 "MakeOvUpdates.puma"
   OverlapUpdates (var, exp->VAR_PARAM.V->ADDR.E);
  }
   return;

  }
# line 709 "MakeOvUpdates.puma"
  {
# line 710 "MakeOvUpdates.puma"
   OverlapVarUpdates (var, exp->VAR_PARAM.V);
  }
   return;

  }

# line 713 "MakeOvUpdates.puma"
  {
# line 714 "MakeOvUpdates.puma"
   failure_protocol (MODULE, "OverlapUpdates", exp);
  }
   return;

;
}

static void OverlapIndexUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree owner, register tTree var)
# else
(owner, var)
 register tTree owner;
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 719 "MakeOvUpdates.puma"
  {
# line 721 "MakeOvUpdates.puma"
   OverlapIndexUpdates (owner, var->INDEXED_VAR.IND_VAR);
# line 722 "MakeOvUpdates.puma"
   OverlapUpdates (owner, var->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
# line 725 "MakeOvUpdates.puma"
  {
# line 727 "MakeOvUpdates.puma"
   OverlapIndexUpdates (owner, var->SELECTED_VAR.SELEC_VAR);
  }
   return;

  }
  if (var->Kind == kSUBSTRING_VAR) {
# line 730 "MakeOvUpdates.puma"
  {
# line 732 "MakeOvUpdates.puma"
   OverlapIndexUpdates (owner, var->SUBSTRING_VAR.IND_VAR);
# line 733 "MakeOvUpdates.puma"
   OverlapUpdates (owner, var->SUBSTRING_VAR.IND_EXP);
  }
   return;

  }
;
}

static void OverlapVarUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree left_var, register tTree right_var)
# else
(left_var, right_var)
 register tTree left_var;
 register tTree right_var;
# endif
{
  if (right_var->Kind == kINDEXED_VAR) {
# line 738 "MakeOvUpdates.puma"
 {
  shift_vector pos;
  bool found;
  {
# line 740 "MakeOvUpdates.puma"

# line 741 "MakeOvUpdates.puma"

# line 743 "MakeOvUpdates.puma"
   GetShifting (left_var, right_var, & found, & pos);
# line 745 "MakeOvUpdates.puma"
   if (! ((found))) goto yyL1;
  {
# line 747 "MakeOvUpdates.puma"
   if (! ((ValidOverlapUpdate (right_var, & pos)))) goto yyL1;
  {
# line 749 "MakeOvUpdates.puma"
   SetOverlapUpdate (right_var, & pos);
  }
  }
  }
   return;
 }
yyL1:;

  }
# line 752 "MakeOvUpdates.puma"
   return;

;
}

static void ApplyShiftToVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, pshift pos)
# else
(var, pos)
 register tTree var;
 pshift pos;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 765 "MakeOvUpdates.puma"
  {
# line 767 "MakeOvUpdates.puma"
   ApplyShiftToIndexes (var->INDEXED_VAR.IND_EXPS, 0, pos);
  }
   return;

  }
# line 770 "MakeOvUpdates.puma"
  {
# line 771 "MakeOvUpdates.puma"
   failure_protocol (MODULE, "ApplyShiftToVar", var);
  }
   return;

;
}

static void ApplyShiftToIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int n, pshift pos)
# else
(indexes, n, pos)
 register tTree indexes;
 register int n;
 pshift pos;
# endif
{
  if (indexes->Kind == kBTE_EMPTY) {
# line 776 "MakeOvUpdates.puma"
  {
# line 777 "MakeOvUpdates.puma"
   if (! ((pos -> shift_rank == n))) goto yyL1;
  }
   return;
yyL1:;

  }
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 780 "MakeOvUpdates.puma"
  {
# line 782 "MakeOvUpdates.puma"
 indexes->BTE_LIST.Elem->SLICE_EXP.START = AddConstant (indexes->BTE_LIST.Elem->SLICE_EXP.START, -pos->shift_pos[n]);
    indexes->BTE_LIST.Elem->SLICE_EXP.STOP  = AddConstant (indexes->BTE_LIST.Elem->SLICE_EXP.STOP , -pos->shift_pos[n]);
  
# line 786 "MakeOvUpdates.puma"
   ApplyShiftToIndexes (indexes->BTE_LIST.Next, n + 1, pos);
  }
   return;

  }
# line 789 "MakeOvUpdates.puma"
  {
# line 791 "MakeOvUpdates.puma"
 indexes->BTE_LIST.Elem = AddConstant (indexes->BTE_LIST.Elem, pos->shift_pos[n]); 
# line 793 "MakeOvUpdates.puma"
   ApplyShiftToIndexes (indexes->BTE_LIST.Next, n + 1, pos);
  }
   return;

  }
# line 796 "MakeOvUpdates.puma"
  {
# line 797 "MakeOvUpdates.puma"
   failure_protocol (MODULE, "ApplyShiftToIndexes", indexes);
  }
   return;

;
}

static bool ValidOverlapUpdate
# if defined __STDC__ | defined __cplusplus
(register tTree var, pshift pos)
# else
(var, pos)
 register tTree var;
 pshift pos;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 810 "MakeOvUpdates.puma"
  {
# line 811 "MakeOvUpdates.puma"
   if (! ((ValidOverlapUpdate (var->INDEXED_VAR.IND_VAR, pos)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (var->Kind == kUSED_VAR) {
# line 814 "MakeOvUpdates.puma"
  {
# line 815 "MakeOvUpdates.puma"
   if (! ((ValidOverlapUpdate (var->USED_VAR.VARNAME, pos)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (var->Kind == kVAR_OBJ) {
# line 818 "MakeOvUpdates.puma"
  {
# line 820 "MakeOvUpdates.puma"
   if (! ((VarRank (var->VAR_OBJ.Object) == pos -> shift_rank))) goto yyL3;
  {
# line 822 "MakeOvUpdates.puma"
   if (! ((IsEnoughVarOverlap (ArrayFormals (var->VAR_OBJ.Object), 0, pos)))) goto yyL3;
  }
  }
   return true;
yyL3:;

  }
  return false;
}

static bool IsEnoughVarOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int dim, pshift pos)
# else
(indexes, dim, pos)
 register tTree indexes;
 register int dim;
 pshift pos;
# endif
{
  if (indexes->Kind == kSHAPE_EMPTY) {
# line 835 "MakeOvUpdates.puma"
   return true;

  }
  if (indexes->Kind == kSHAPE_LIST) {
# line 840 "MakeOvUpdates.puma"
  {
# line 841 "MakeOvUpdates.puma"
   if (! ((SufficientOverlapIndex (indexes->SHAPE_LIST.Elem, pos -> shift_pos [dim])))) goto yyL2;
  {
# line 842 "MakeOvUpdates.puma"
   if (! ((IsEnoughVarOverlap (indexes->SHAPE_LIST.Next, dim + 1, pos)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  return false;
}

static bool SufficientOverlapIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index, register int pos)
# else
(index, pos)
 register tTree index;
 register int pos;
# endif
{
  if (index->Kind == kOVERLAP_SPEC) {
# line 855 "MakeOvUpdates.puma"
  {
# line 857 "MakeOvUpdates.puma"
   if (! ((index->OVERLAP_SPEC.right_size >= - pos))) goto yyL1;
  {
# line 858 "MakeOvUpdates.puma"
   if (! ((index->OVERLAP_SPEC.left_size >= pos))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  if (Tree_IsType (index, kSHAPE_SPEC)) {
# line 861 "MakeOvUpdates.puma"
  {
# line 863 "MakeOvUpdates.puma"
   if (! ((SufficientOverlapIndex (index->SHAPE_SPEC.Overlap, pos)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

void BeginMakeOvUpdates ()
{
}

void CloseMakeOvUpdates ()
{
}
