# include "MakeOn.h"
# include "yyMakeOn.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 48 "MakeOn.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Types.h"            /* TreeListGet */
# include "Transform.h"        /* CombineACF, ReplaceACF, ExpToVarParam */
# include "Ownership.h"        /* owner_spec */

# include "Traverse.h"
# include "HomeTraverse.h"
# include "GlobalComm.h"

# include "SMParallel.h"

# define MODULE "MakeOn"



static void yyExit () { Exit (1); }

void (* MakeOn_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeOn, routine %s failed\n", yyFunction);
 MakeOn_Exit ();
}

void MakeOn ARGS((tTree t));
static bool StopONHOME ARGS((tTree t));
static tTree TranslateONHOME ARGS((tTree t));
static tTree MakeOnStmts ARGS((tTree t, pvar home));
static tTree Translation ARGS((tTree t, pvar home));
static tTree MakeOnStmts1 ARGS((tTree t, pvar home));

void MakeOn
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 85 "MakeOn.puma"
  {
# line 87 "MakeOn.puma"
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopONHOME, TranslateONHOME); 
  }
   return;

  }
# line 90 "MakeOn.puma"
  {
# line 91 "MakeOn.puma"
   failure_protocol (MODULE, "MakeOn", t);
  }
   return;

;
}

static bool StopONHOME
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_HOME) {
# line 104 "MakeOn.puma"
   return true;

  }
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kPARDO_INFO) {
# line 107 "MakeOn.puma"
   return true;

  }
  }
  if (t->Kind == kACF_PARALLEL) {
# line 110 "MakeOn.puma"
   return true;

  }
  return false;
}

static tTree TranslateONHOME
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_HOME) {
# line 121 "MakeOn.puma"
 {
  tTree new;
  tTree comm;
  var_descriptor owner;
  {
# line 123 "MakeOn.puma"
   stmt_protocol ("translate ON HOME (local accesses + global reductions)");
# line 125 "MakeOn.puma"

# line 126 "MakeOn.puma"

# line 128 "MakeOn.puma"
   comm = GlobalCommunication (t);
# line 129 "MakeOn.puma"
   set_protocol_stmt (t);
# line 131 "MakeOn.puma"

# line 133 "MakeOn.puma"
   MakeReplicatedDescriptor (& owner);
# line 135 "MakeOn.puma"
   new = MakeOnStmts (t, & owner);
# line 137 "MakeOn.puma"
   tree_protocol ("global comm : \n", comm);
# line 138 "MakeOn.puma"
   tree_protocol ("new stmt : \n", new);
  }
  {
   return CombineACF (new, comm);
  }
 }

  }
  if (t->Kind == kACF_RESIDENT) {
# line 143 "MakeOn.puma"
   return t->ACF_RESIDENT.RESIDENT_BODY;

  }
# line 149 "MakeOn.puma"
   return t;

}

static tTree MakeOnStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar home)
# else
(t, home)
 register tTree t;
 pvar home;
# endif
{
# line 163 "MakeOn.puma"
   return HomeReplaceAST (t, home, Translation);

}

static tTree Translation
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar home)
# else
(t, home)
 register tTree t;
 pvar home;
# endif
{
  if (t->Kind == kACF_HOME) {
  if (t->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
# line 176 "MakeOn.puma"
 {
  var_descriptor on_home;
  {
# line 178 "MakeOn.puma"

# line 180 "MakeOn.puma"
   SetVarDescriptor (t->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & on_home);
  }
  {
   return MakeOnSelection (t->ACF_HOME.HOME_BODY, home, & on_home);
  }
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_PROC_CLAUSE) {
# line 191 "MakeOn.puma"
 {
  var_descriptor on_home;
  {
# line 193 "MakeOn.puma"

# line 195 "MakeOn.puma"
   SetProcDescriptor (t->ACF_HOME.HOME_VAR->ON_PROC_CLAUSE.ON_PROC, & on_home);
  }
  {
   return MakeOnSelection (t->ACF_HOME.HOME_BODY, home, & on_home);
  }
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_HOST_CLAUSE) {
# line 206 "MakeOn.puma"
 {
  var_descriptor on_home;
  {
# line 208 "MakeOn.puma"

# line 210 "MakeOn.puma"
   MakeHostDescriptor (& on_home);
  }
  {
   return MakeOnSelection (t->ACF_HOME.HOME_BODY, home, & on_home);
  }
 }

  }
  }
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
# line 221 "MakeOn.puma"
 {
  var_descriptor home_body;
  {
# line 223 "MakeOn.puma"

# line 225 "MakeOn.puma"
   SetVarDescriptor (t->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var, & home_body);
# line 227 "MakeOn.puma"
   MakeOnLoop (t, & home_body);
  }
  {
   return MakeOnSelection (t, home, & home_body);
  }
 }

  }
  }
  if (t->Kind == kACF_RESIDENT) {
# line 236 "MakeOn.puma"
   return t->ACF_RESIDENT.RESIDENT_BODY;

  }
# line 241 "MakeOn.puma"
   return t;

}

static tTree MakeOnStmts1
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar home)
# else
(t, home)
 register tTree t;
 pvar home;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 256 "MakeOn.puma"
 {
  tTree newacf;
  {
# line 258 "MakeOn.puma"

# line 260 "MakeOn.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 262 "MakeOn.puma"
 newacf = MakeOnStmts1 (t->ACF_LIST.Elem, home);         
     t->ACF_LIST.Next   = MakeOnStmts1 (t->ACF_LIST.Next, home);         
   
# line 266 "MakeOn.puma"
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
  {
   return newacf;
  }
 }

  case kACF_EMPTY:
# line 271 "MakeOn.puma"
   return t;

  case kACF_BASIC:
# line 276 "MakeOn.puma"
   return t;

  case kACF_HOME:
  if (t->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
# line 287 "MakeOn.puma"
 {
  var_descriptor on_home;
  {
# line 289 "MakeOn.puma"

# line 291 "MakeOn.puma"
   SetVarDescriptor (t->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & on_home);
# line 293 "MakeOn.puma"
 t->ACF_HOME.HOME_BODY = MakeOnStmts1 (t->ACF_HOME.HOME_BODY, &on_home); 
  }
  {
   return MakeOnSelection (t->ACF_HOME.HOME_BODY, home, & on_home);
  }
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_HOST_CLAUSE) {
# line 304 "MakeOn.puma"
 {
  var_descriptor on_home;
  {
# line 306 "MakeOn.puma"

# line 308 "MakeOn.puma"
   MakeHostDescriptor (& on_home);
# line 310 "MakeOn.puma"
 t->ACF_HOME.HOME_BODY = MakeOnStmts1 (t->ACF_HOME.HOME_BODY, &on_home); 
  }
  {
   return MakeOnSelection (t->ACF_HOME.HOME_BODY, home, & on_home);
  }
 }

  }
  break;
  case kACF_DO:
  if (t->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
# line 321 "MakeOn.puma"
 {
  var_descriptor home_body;
  {
# line 323 "MakeOn.puma"

# line 327 "MakeOn.puma"
   IncLoopNesting (t);
# line 329 "MakeOn.puma"
   SetVarDescriptor (t->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var, & home_body);
# line 331 "MakeOn.puma"
 t->ACF_DO.DO_BODY = MakeOnStmts1 (t->ACF_DO.DO_BODY, &home_body); 
# line 333 "MakeOn.puma"
   DecLoopNesting (t);
# line 335 "MakeOn.puma"
   MakeOnLoop (t, & home_body);
  }
  {
   return MakeOnSelection (t, home, & home_body);
  }
 }

  }
  if (t->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
# line 392 "MakeOn.puma"
  {
# line 394 "MakeOn.puma"
 t->ACF_DO.DO_BODY = MakeOnStmts1 (t->ACF_DO.DO_BODY, home); 
  }
   return t;

  }
  break;
  case kACF_NEW:
# line 348 "MakeOn.puma"
   return MakeOnStmts1 (t->ACF_NEW.NEW_BODY, home);

  case kACF_RESIDENT:
# line 359 "MakeOn.puma"
   return MakeOnStmts1 (t->ACF_RESIDENT.RESIDENT_BODY, home);

  case kACF_REDUCTION:
# line 372 "MakeOn.puma"
   return t;

  case kACF_IF:
# line 383 "MakeOn.puma"
  {
# line 385 "MakeOn.puma"
 t->ACF_IF.THEN_PART = MakeOnStmts1 (t->ACF_IF.THEN_PART, home);
    t->ACF_IF.ELSE_PART = MakeOnStmts1 (t->ACF_IF.ELSE_PART, home);
  
  }
   return t;

  case kACF_WHILE:
# line 399 "MakeOn.puma"
  {
# line 401 "MakeOn.puma"
 t->ACF_WHILE.WHILE_BODY = MakeOnStmts1 (t->ACF_WHILE.WHILE_BODY, home); 
  }
   return t;

  case kACF_DUMMY:
# line 406 "MakeOn.puma"
   return t;

  }

# line 411 "MakeOn.puma"
  {
# line 413 "MakeOn.puma"
   failure_protocol (MODULE, "MakeOnStmts1", t);
  }
   return t;

}

void BeginMakeOn ()
{
}

void CloseMakeOn ()
{
}
