# include "MakeMovement.h"
# include "yyMakeMovement.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 26 "MakeMovement.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Types.h"
# include "Shapes.h"        /* MakeFullShape      */
# include "MoveControl.h"   /* CountMovements     */
# include "Transform.h"     /* ExpToVarParam      */

# include "Traverse.h"      /* ReplaceAST         */
# include "VectorMove.h"    /* VectorizeMovement  */

# include "MakeHome.h"      /* DoDetermineHome    */

# define  MODULE "MakeMovement" 

# undef  VEC_COMMUNICATION



static void yyExit () { Exit (1); }

void (* MakeMovement_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeMovement, routine %s failed\n", yyFunction);
 MakeMovement_Exit ();
}

void MakeMovement ARGS((tTree t));
static bool StopMakeMoveStmts ARGS((tTree t));
static tTree DoMakeMoveStmts ARGS((tTree t));
static void IsOnAssignment ARGS((tTree var, tTree exp, bool * yyP2, tTree * yyP1));
int TranslateMovement ARGS((tTree stmt));
static void TransMoveStmt ARGS((tTree stmt, int * yyP4, tTree * yyP3));
static tTree SetMoveMask ARGS((tTree stmt, tTree mask));
static tTree AddMask ARGS((tTree mask1, tTree mask2));
static void TranslateAssignment ARGS((tTree assign, int * yyP6, tTree * yyP5));
static void TranslateReduce ARGS((tTree reduce, int * yyP8, tTree * yyP7));
static tTree TranslateIndexes ARGS((tTree index_list));
static void MakeLocalInfo ARGS((tTree t));

void MakeMovement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 58 "MakeMovement.puma"
  {
# line 60 "MakeMovement.puma"
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeMoveStmts, DoMakeMoveStmts); 
  }
   return;

  }
# line 63 "MakeMovement.puma"
  {
# line 64 "MakeMovement.puma"
   failure_protocol (MODULE, "MakeMovements", t);
  }
   return;

;
}

static bool StopMakeMoveStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_FORALL) {
# line 80 "MakeMovement.puma"
   return true;

  }
  if (t->Kind == kACF_WHERE) {
# line 83 "MakeMovement.puma"
   return true;

  }
  if (t->Kind == kACF_HOME) {
# line 86 "MakeMovement.puma"
   return true;

  }
  return false;
}

static tTree DoMakeMoveStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_FORALL) {
# line 91 "MakeMovement.puma"
 {
  int code;
  tTree new;
  {
# line 93 "MakeMovement.puma"

# line 94 "MakeMovement.puma"

# line 96 "MakeMovement.puma"
   code = TranslateMovement (t);
# line 98 "MakeMovement.puma"
 if (code == 0)

        { new = DoDetermineHome (t);
      
          MakeLocalInfo (t);  

          set_protocol_stmt (t);
          stmt_protocol ("movement is local, home determined");
        }

      else                              

#ifdef VEC_COMMUNICATION
        new = VectorizeCommunication (t);    
#else
        new = VectorizeMovement (t);         
#endif

   
  }
  {
   return new;
  }
 }

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 123 "MakeMovement.puma"
 {
  bool yyV1;
  tTree yyV2;
  tTree new;
  {
# line 125 "MakeMovement.puma"
   IsOnAssignment (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, & yyV1, & yyV2);
# line 127 "MakeMovement.puma"
   if (! ((yyV1))) goto yyL2;
  {
# line 129 "MakeMovement.puma"

# line 131 "MakeMovement.puma"
   stmt_protocol ("statement will be executed by owner");
# line 133 "MakeMovement.puma"
   new = mACF_HOME (mON_VAR_CLAUSE (yyV2), false, mACF_LIST (t, mACF_EMPTY ()));
# line 137 "MakeMovement.puma"
   tree_protocol ("new home stmt : \n", new);
  }
  }
  {
   return new;
  }
 }
yyL2:;

# line 142 "MakeMovement.puma"
 {
  int code;
  {
# line 144 "MakeMovement.puma"

# line 146 "MakeMovement.puma"
   code = TranslateMovement (t);
  }
  {
   return t;
  }
 }

  }
  }
# line 151 "MakeMovement.puma"
   return t;

}

static void IsOnAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp, register bool * yyP2, register tTree * yyP1)
# else
(var, exp, yyP2, yyP1)
 register tTree var;
 register tTree exp;
 register bool * yyP2;
 register tTree * yyP1;
# endif
{
  if (var->Kind == kUSED_VAR) {
  if (exp->Kind == kVAR_EXP) {
# line 168 "MakeMovement.puma"
  {
# line 170 "MakeMovement.puma"
   if (! ((TreeRank (var) == 0))) goto yyL1;
  {
# line 171 "MakeMovement.puma"
   if (! ((TreeRank (exp->VAR_EXP.V) == 0))) goto yyL1;
  {
# line 173 "MakeMovement.puma"
   if (! ((CountMovements (var, exp->VAR_EXP.V) != 0))) goto yyL1;
  {
# line 174 "MakeMovement.puma"
   if (! ((CountMovements (exp->VAR_EXP.V, var) == 0))) goto yyL1;
  }
  }
  }
  }
   * yyP2 = true;
   * yyP1 = exp->VAR_EXP.V;
   return;
yyL1:;

  }
  }
  if (exp->Kind == kVAR_EXP) {
  if (exp->VAR_EXP.V->Kind == kUSED_VAR) {
# line 179 "MakeMovement.puma"
  {
# line 181 "MakeMovement.puma"
   if (! ((TreeRank (var) == 0))) goto yyL2;
  {
# line 182 "MakeMovement.puma"
   if (! ((TreeRank (exp->VAR_EXP.V) == 0))) goto yyL2;
  {
# line 184 "MakeMovement.puma"
   if (! ((CountMovements (var, exp->VAR_EXP.V) == 0))) goto yyL2;
  {
# line 185 "MakeMovement.puma"
   if (! ((CountMovements (exp->VAR_EXP.V, var) != 0))) goto yyL2;
  }
  }
  }
  }
   * yyP2 = true;
   * yyP1 = var;
   return;
yyL2:;

  }
  }
# line 188 "MakeMovement.puma"
   * yyP2 = false;
   * yyP1 = NoTree;
   return;

;
}

int TranslateMovement
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
# line 235 "MakeMovement.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 237 "MakeMovement.puma"
   stmt_protocol ("movement will be classified");
# line 239 "MakeMovement.puma"
   TransMoveStmt (stmt, & yyV1, & yyV2);
# line 241 "MakeMovement.puma"
 if (yyV1 == 0)
       tree_protocol ("is local stmt:\n", stmt);
     else
       tree_protocol ("is movement stmt :\n", stmt);
  
  }
  {
   return yyV1;
  }
 }

}

static void TransMoveStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register int * yyP4, register tTree * yyP3)
# else
(stmt, yyP4, yyP3)
 register tTree stmt;
 register int * yyP4;
 register tTree * yyP3;
# endif
{
  if (stmt->Kind == kACF_FORALL) {
# line 263 "MakeMovement.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 265 "MakeMovement.puma"
   TransMoveStmt (stmt->ACF_FORALL.FORALL_BODY, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = stmt;
   return;
 }

  }
  if (stmt->Kind == kACF_IF) {
# line 268 "MakeMovement.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 270 "MakeMovement.puma"
   TransMoveStmt (stmt->ACF_IF.THEN_PART, & yyV1, & yyV2);
# line 272 "MakeMovement.puma"
 if (yyV1 == 0)
       { 
         stmt->ACF_IF.THEN_PART = yyV2; 
         yyV2 = stmt; 
       }
     else
       yyV2 = SetMoveMask (yyV2, stmt->ACF_IF.IF_EXP);
  
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  }
  if (stmt->Kind == kACF_LIST) {
  if (stmt->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 282 "MakeMovement.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 284 "MakeMovement.puma"
   TransMoveStmt (stmt->ACF_LIST.Elem, & yyV1, & yyV2);
# line 285 "MakeMovement.puma"
 stmt->ACF_LIST.Elem = yyV2; 
  }
   * yyP4 = yyV1;
   * yyP3 = stmt;
   return;
 }

  }
# line 288 "MakeMovement.puma"
 {
  int yyV1;
  tTree yyV2;
  int yyV3;
  tTree yyV4;
  {
# line 292 "MakeMovement.puma"
   TransMoveStmt (stmt->ACF_LIST.Elem, & yyV1, & yyV2);
# line 293 "MakeMovement.puma"
   TransMoveStmt (stmt->ACF_LIST.Next, & yyV3, & yyV4);
# line 295 "MakeMovement.puma"
 if (yyV1 || yyV3)
       error_protocol ("more than one movement in FORALL nest");
  
  }
   * yyP4 = 0;
   * yyP3 = stmt;
   return;
 }

  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 300 "MakeMovement.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 302 "MakeMovement.puma"
   TranslateAssignment (stmt->ACF_BASIC.BASIC_STMT, & yyV1, & yyV2);
# line 303 "MakeMovement.puma"
 stmt->ACF_BASIC.BASIC_STMT = yyV2; 
  }
   * yyP4 = yyV1;
   * yyP3 = stmt;
   return;
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 306 "MakeMovement.puma"
 {
  int yyV1;
  tTree yyV2;
  {
# line 308 "MakeMovement.puma"
   TranslateReduce (stmt->ACF_BASIC.BASIC_STMT, & yyV1, & yyV2);
# line 309 "MakeMovement.puma"
 stmt->ACF_BASIC.BASIC_STMT = yyV2; 
  }
   * yyP4 = yyV1;
   * yyP3 = stmt;
   return;
 }

  }
  }
# line 312 "MakeMovement.puma"
  {
# line 313 "MakeMovement.puma"
   failure_protocol (MODULE, "TransMoveStmt", stmt);
  }
   * yyP4 = 0;
   * yyP3 = stmt;
   return;

;
}

static tTree SetMoveMask
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree mask)
# else
(stmt, mask)
 register tTree stmt;
 register tTree mask;
# endif
{
  if (stmt->Kind == kACF_LIST) {
  if (stmt->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 327 "MakeMovement.puma"
   return SetMoveMask (stmt->ACF_LIST.Elem, mask);

  }
  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kSCATTER_STMT) {
# line 332 "MakeMovement.puma"
  {
# line 334 "MakeMovement.puma"
 stmt->ACF_BASIC.BASIC_STMT->SCATTER_STMT.MASK = AddMask (stmt->ACF_BASIC.BASIC_STMT->SCATTER_STMT.MASK, mask); 
  }
   return stmt;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kMOVE_STMT) {
# line 339 "MakeMovement.puma"
  {
# line 341 "MakeMovement.puma"
 stmt->ACF_BASIC.BASIC_STMT->MOVE_STMT.MASK = AddMask (stmt->ACF_BASIC.BASIC_STMT->MOVE_STMT.MASK, mask); 
  }
   return stmt;

  }
  }
# line 346 "MakeMovement.puma"
  {
# line 348 "MakeMovement.puma"
   failure_protocol (MODULE, "SetMoveMask", stmt);
  }
   return NoTree;

}

static tTree AddMask
# if defined __STDC__ | defined __cplusplus
(register tTree mask1, register tTree mask2)
# else
(mask1, mask2)
 register tTree mask1;
 register tTree mask2;
# endif
{
  if (mask1->Kind == kNO_PARAM) {
# line 361 "MakeMovement.puma"
   return ExpToVarParam (mask2);

  }
# line 366 "MakeMovement.puma"
  {
# line 367 "MakeMovement.puma"
   error_protocol ("too many masks for data movement");
  }
   return mask1;

}

static void TranslateAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register int * yyP6, register tTree * yyP5)
# else
(assign, yyP6, yyP5)
 register tTree assign;
 register int * yyP6;
 register tTree * yyP5;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
# line 389 "MakeMovement.puma"
  {
# line 391 "MakeMovement.puma"
   if (! ((CountMovements (assign->ASSIGN_STMT.ASSIGN_VAR, assign->ASSIGN_STMT.ASSIGN_EXP) == 0))) goto yyL1;
  {
# line 392 "MakeMovement.puma"
   if (! ((IsDescriptorVar (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  }
  }
   * yyP6 = 0;
   * yyP5 = assign;
   return;
yyL1:;

  if (assign->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 395 "MakeMovement.puma"
   * yyP6 = 5;
   * yyP5 = assign;
   return;

  }
  if (assign->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
# line 398 "MakeMovement.puma"
  {
# line 401 "MakeMovement.puma"
   if (! ((IsDescriptorVar (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL3;
  {
# line 402 "MakeMovement.puma"
   if (! ((IsDescriptorVar (assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V)))) goto yyL3;
  }
  }
   * yyP6 = 1;
   * yyP5 = mMOVE_STMT (assign->ASSIGN_STMT.ASSIGN_VAR, assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V, mNO_PARAM (kDUMMY_TYPE));
   return;
yyL3:;

  if (assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V->Kind == kINDEXED_VAR) {
# line 405 "MakeMovement.puma"
 {
  tTree new;
  {
# line 407 "MakeMovement.puma"
   if (! ((IsDescriptorVar (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL4;
  {
# line 411 "MakeMovement.puma"

# line 413 "MakeMovement.puma"
   if (! (new = mSCATTER_STMT (MakeIdent ("GET_SCATTER", 11), assign->ASSIGN_STMT.ASSIGN_VAR, MakeFullShape (assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V->INDEXED_VAR.IND_VAR), TranslateIndexes (assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V->INDEXED_VAR.IND_EXPS), mNO_PARAM (kDUMMY_TYPE)))) goto yyL4;
  }
  }
   * yyP6 = 3;
   * yyP5 = new;
   return;
 }
yyL4:;

  }
  }
  if (assign->ASSIGN_STMT.ASSIGN_VAR->Kind == kINDEXED_VAR) {
  if (assign->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
# line 418 "MakeMovement.puma"
 {
  tTree new;
  {
# line 420 "MakeMovement.puma"
   if (! ((IsDescriptorVar (assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V)))) goto yyL5;
  {
# line 424 "MakeMovement.puma"

# line 426 "MakeMovement.puma"
   new = mSCATTER_STMT (MakeIdent ("COPY_SCATTER", 12), assign->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V, MakeFullShape (assign->ASSIGN_STMT.ASSIGN_VAR->INDEXED_VAR.IND_VAR), TranslateIndexes (assign->ASSIGN_STMT.ASSIGN_VAR->INDEXED_VAR.IND_EXPS), mNO_PARAM (kDUMMY_TYPE));
  }
  }
   * yyP6 = 2;
   * yyP5 = new;
   return;
 }
yyL5:;

  }
  }
  }
# line 431 "MakeMovement.puma"
  {
# line 433 "MakeMovement.puma"
   error_protocol ("could not translate/classify assignment");
  }
   * yyP6 = 0;
   * yyP5 = assign;
   return;

;
}

static void TranslateReduce
# if defined __STDC__ | defined __cplusplus
(register tTree reduce, register int * yyP8, register tTree * yyP7)
# else
(reduce, yyP8, yyP7)
 register tTree reduce;
 register int * yyP8;
 register tTree * yyP7;
# endif
{
# line 448 "MakeMovement.puma"

char fn_name      [20];
char scatter_name [30];

  if (reduce->Kind == kREDUCE_STMT) {
  if (reduce->REDUCE_STMT.RED_PARAMS->Kind == kBTP_LIST) {
  if (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->Kind == kINDEXED_VAR) {
  if (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 453 "MakeMovement.puma"
 {
  tTree new;
  {
# line 457 "MakeMovement.puma"
   if (! ((IsDescriptorVar (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL1;
  {
# line 461 "MakeMovement.puma"

# line 463 "MakeMovement.puma"
   GetString (reduce->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident, fn_name);
# line 465 "MakeMovement.puma"
   sprintf (scatter_name, "%s_SCATTER", fn_name);
# line 467 "MakeMovement.puma"
   new = mSCATTER_STMT (IsIdent (scatter_name), reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V, MakeFullShape (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->INDEXED_VAR.IND_VAR), TranslateIndexes (reduce->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->INDEXED_VAR.IND_EXPS), mNO_PARAM (kDUMMY_TYPE));
  }
  }
   * yyP8 = 2;
   * yyP7 = new;
   return;
 }
yyL1:;

  }
  }
  }
  }
  }
  }
  }
# line 472 "MakeMovement.puma"
  {
# line 474 "MakeMovement.puma"
   error_protocol ("could not translate/classify reduce");
  }
   * yyP8 = 0;
   * yyP7 = reduce;
   return;

;
}

static tTree TranslateIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree index_list)
# else
(index_list)
 register tTree index_list;
# endif
{
  if (index_list->Kind == kBTE_LIST) {
  if (index_list->BTE_LIST.Elem->Kind == kVAR_EXP) {
# line 485 "MakeMovement.puma"
   return mBTP_LIST (mVAR_PARAM (index_list->BTE_LIST.Elem->VAR_EXP.V), TranslateIndexes (index_list->BTE_LIST.Next));

  }
  if (index_list->BTE_LIST.Elem->Kind == kCONST_EXP) {
# line 490 "MakeMovement.puma"
   return mBTP_LIST (ExpToVarParam (index_list->BTE_LIST.Elem), TranslateIndexes (index_list->BTE_LIST.Next));

  }
  }
  if (index_list->Kind == kBTE_EMPTY) {
# line 495 "MakeMovement.puma"
   return mBTP_EMPTY ();

  }
# line 500 "MakeMovement.puma"
  {
# line 501 "MakeMovement.puma"
   failure_protocol (MODULE, "TranslateIndexes", index_list);
  }
   return NoTree;

}

static void MakeLocalInfo
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
# line 516 "MakeMovement.puma"
  {
# line 518 "MakeMovement.puma"
   MakeLocalInfo (t->ACF_DO.DO_BODY);
# line 520 "MakeMovement.puma"
 t->ACF_DO.DO_HOME_INFO->COMM_INFO.is_local = true; 
  }
   return;

  }
  }
  if (t->Kind == kACF_IF) {
# line 523 "MakeMovement.puma"
  {
# line 525 "MakeMovement.puma"
   MakeLocalInfo (t->ACF_IF.THEN_PART);
# line 526 "MakeMovement.puma"
   MakeLocalInfo (t->ACF_IF.ELSE_PART);
  }
   return;

  }
  if (t->Kind == kACF_LIST) {
# line 529 "MakeMovement.puma"
  {
# line 531 "MakeMovement.puma"
   MakeLocalInfo (t->ACF_LIST.Elem);
# line 532 "MakeMovement.puma"
   MakeLocalInfo (t->ACF_LIST.Next);
  }
   return;

  }
  if (t->Kind == kACF_EMPTY) {
# line 535 "MakeMovement.puma"
   return;

  }
  if (t->Kind == kACF_BASIC) {
# line 538 "MakeMovement.puma"
   return;

  }
  if (t->Kind == kACF_HOME) {
# line 541 "MakeMovement.puma"
  {
# line 543 "MakeMovement.puma"
   MakeLocalInfo (t->ACF_HOME.HOME_BODY);
  }
   return;

  }
# line 546 "MakeMovement.puma"
  {
# line 548 "MakeMovement.puma"
   failure_protocol (MODULE, "MakeLocalInfo", t);
  }
   return;

;
}

void BeginMakeMovement ()
{
}

void CloseMakeMovement ()
{
}
