# include "MakeLoops.h"
# include "yyMakeLoops.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 38 "MakeLoops.puma"

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Types.h"
# include "Objects.h"
# include "Rank.h"
# include "Transform.h"    /* AppendDECLS */
# include "Shapes.h"

# include "Temporary.h"    /* GetLoopTemporary */

# include "Expressions.h"

# include "IndexShapes.h"  /* FindShapeExp */
# include "ReplaceExp.h"   /* RenameLoopId */

# undef DEBUG

# define MODULE "MakeLoops"



static void yyExit () { Exit (1); }

void (* MakeLoops_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeLoops, routine %s failed\n", yyFunction);
 MakeLoops_Exit ();
}

static void FreeTemporaries0 ARGS(());
tTree SetActualShape ARGS((tTree t, shape s));
static tTree SetSpreadActualShape ARGS((tTree t, shape s));
static tTree SetTransposeShape ARGS((tTree t, shape s));
static void SetActualIndexShape ARGS((tTree ind, shape s, int n));
tTree MakeOuterLoops ARGS((int line, shape s, tTree body, int kind));
static tTree MakeListBody ARGS((tTree t));
tTree MakeOuterImpliedLoops ARGS((shape s, tTree body));
tTree MakeOuterImpliedLoopsV ARGS((shape s, tTree body));

static void FreeTemporaries0
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 66 "MakeLoops.puma"
 {
  tTree help;
  {
# line 67 "MakeLoops.puma"

# line 69 "MakeLoops.puma"
 FreeTemporaries (&help, &help); 
  }
   return;
 }

;
}

tTree SetActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
# line 85 "MakeLoops.puma"

tTree newexp;


  switch (t->Kind) {
  case kACF_WHERE:
# line 89 "MakeLoops.puma"
  {
# line 91 "MakeLoops.puma"
 t->ACF_WHERE.WHERE_EXP   = SetActualShape (t->ACF_WHERE.WHERE_EXP  , s);
     t->ACF_WHERE.TRUE_PART = SetActualShape (t->ACF_WHERE.TRUE_PART, s);
     t->ACF_WHERE.FALSE_PART = SetActualShape (t->ACF_WHERE.FALSE_PART, s); 

     t->Kind = kACF_IF; 

   
  }
   return t;

  case kACF_LIST:
# line 102 "MakeLoops.puma"
  {
# line 104 "MakeLoops.puma"
 t->ACF_LIST.Elem = SetActualShape (t->ACF_LIST.Elem, s);
     t->ACF_LIST.Next = SetActualShape (t->ACF_LIST.Next, s); 
  }
   return t;

  case kACF_EMPTY:
# line 109 "MakeLoops.puma"
   return t;

  case kACF_BASIC:
# line 113 "MakeLoops.puma"
  {
# line 114 "MakeLoops.puma"
 t->ACF_BASIC.BASIC_STMT = SetActualShape (t->ACF_BASIC.BASIC_STMT, s); 
  }
   return t;

  case kASSIGN_STMT:
# line 118 "MakeLoops.puma"
  {
# line 119 "MakeLoops.puma"
 t->ASSIGN_STMT.ASSIGN_VAR = SetActualShape (t->ASSIGN_STMT.ASSIGN_VAR, s);
     t->ASSIGN_STMT.ASSIGN_EXP = SetActualShape (t->ASSIGN_STMT.ASSIGN_EXP, s); 
  }
   return t;

  case kOP_EXP:
# line 124 "MakeLoops.puma"
  {
# line 125 "MakeLoops.puma"
 t->OP_EXP.OPND1 = SetActualShape (t->OP_EXP.OPND1, s);
     t->OP_EXP.OPND2 = SetActualShape (t->OP_EXP.OPND2, s); 
  }
   return t;

  case kOP1_EXP:
# line 130 "MakeLoops.puma"
  {
# line 131 "MakeLoops.puma"
 t->OP1_EXP.OPND = SetActualShape (t->OP1_EXP.OPND, s); 
  }
   return t;

  case kCONST_EXP:
# line 135 "MakeLoops.puma"
   return t;

  case kARRAY_EXP:
  if (t->ARRAY_EXP.ELEMENTS->Kind == kBTE_LIST) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 139 "MakeLoops.puma"
  {
# line 140 "MakeLoops.puma"
 if (s->rank != 1)
        { printf ("Illegal formal shape for current array expression\n");
          WriteTree (stdout, t);
          exit(-1);
        }
     newexp = mVAR_EXP (GetLoopTemporary (s->perm[0]));

     newexp = FindShapeExp (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem, s->bounds[0][0], s->bounds[0][1], 
                               s->bounds[0][2], newexp );
   
  }
   return newexp;

  }
  }
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->Kind == kDO_EXP) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->DO_EXP.BODY->Kind == kBTE_LIST) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->DO_EXP.BODY->BTE_LIST.Next->Kind == kBTE_EMPTY) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 153 "MakeLoops.puma"
  {
# line 156 "MakeLoops.puma"
 newexp = t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->DO_EXP.BODY->BTE_LIST.Elem;
 
     newexp = FindShapeExp (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->DO_EXP.RANGE, s->bounds[0][0], s->bounds[0][1],
                                   s->bounds[0][2], newexp );

     

     newexp = RenameExpLoopId (newexp, t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->DO_EXP.DO_ID, GetLoopTemporary (s->perm[0]));

   
  }
   return newexp;

  }
  }
  }
  }
  }
# line 169 "MakeLoops.puma"
  {
# line 170 "MakeLoops.puma"
   error_protocol ("cannot deal with this array expression");
# line 171 "MakeLoops.puma"
   tree_protocol ("array expression is : ", t);
  }
   return t;

  case kFUNC_CALL_EXP:
# line 175 "MakeLoops.puma"
  {
# line 176 "MakeLoops.puma"
 
     newexp = t;
     if (IsIntrCall (t))

      { if (IntrFuncElemental (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)) 

          { 
            t->FUNC_CALL_EXP.FUNC_PARAMS = SetActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS, s);
          }
         else if (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("SPREAD", 6))
          newexp = SetSpreadActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS, s);
         else if (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("TRANSPOSE", 9))
          newexp = SetTransposeShape (t->FUNC_CALL_EXP.FUNC_PARAMS, s);
         else
          error_protocol ("Illegal Intrinsic function for SetActualShape");
      }
     else if (IsPureCall (t))
      { t->FUNC_CALL_EXP.FUNC_PARAMS = SetActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS, s);
      }
     else
      error_protocol ("Illegal function call in SetActualShape");
   
  }
   return newexp;

  case kBTP_LIST:
# line 201 "MakeLoops.puma"
  {
# line 203 "MakeLoops.puma"
 t->BTP_LIST.Elem = SetActualShape (t->BTP_LIST.Elem, s); 
     t->BTP_LIST.Next = SetActualShape (t->BTP_LIST.Next, s);
   
  }
   return t;

  case kBTP_EMPTY:
# line 210 "MakeLoops.puma"
   return t;

  case kNO_PARAM:
# line 215 "MakeLoops.puma"
   return t;

  case kVAR_PARAM:
# line 220 "MakeLoops.puma"
  {
# line 222 "MakeLoops.puma"
 t->VAR_PARAM.V = SetActualShape (t->VAR_PARAM.V, s); 
  }
   return t;

  case kADDR:
# line 226 "MakeLoops.puma"
  {
# line 228 "MakeLoops.puma"
 t->ADDR.E = SetActualShape (t->ADDR.E, s); 
  }
   return t;

  case kVAR_EXP:
# line 232 "MakeLoops.puma"
  {
# line 233 "MakeLoops.puma"
 t->VAR_EXP.V = SetActualShape (t->VAR_EXP.V, s); 
  }
   return t;

  case kUSED_VAR:
# line 237 "MakeLoops.puma"
  {
# line 239 "MakeLoops.puma"
   if (! ((TreeRank (t) == 0))) goto yyL19;
  }
   return t;
yyL19:;

# line 243 "MakeLoops.puma"
  {
# line 245 "MakeLoops.puma"
   error_protocol ("array variable not in full shape !! ");
# line 246 "MakeLoops.puma"
   tree_protocol ("variable is ", t);
  }
   return t;

  case kLOOP_VAR:
# line 250 "MakeLoops.puma"
   return t;

  case kSELECTED_VAR:
# line 254 "MakeLoops.puma"
  {
# line 255 "MakeLoops.puma"
   if (! (SetActualShape (t->SELECTED_VAR.SELEC_VAR, s))) goto yyL22;
  }
   return t;
yyL22:;

  break;
  case kINDEXED_VAR:
  if (t->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
# line 259 "MakeLoops.puma"
  {
# line 261 "MakeLoops.puma"
   if (! ((TreeRank (t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR) > 0))) goto yyL23;
  {
# line 262 "MakeLoops.puma"
   if (! (SetActualShape (t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR, s))) goto yyL23;
  }
  }
   return t;
yyL23:;

  }
# line 266 "MakeLoops.puma"
  {
# line 268 "MakeLoops.puma"
   SetActualIndexShape (t->INDEXED_VAR.IND_EXPS, s, 0);
  }
   return t;

  }

# line 272 "MakeLoops.puma"
  {
# line 273 "MakeLoops.puma"
   failure_protocol (MODULE, "SetActualShape", t);
  }
   return NoTree;

}

static tTree SetSpreadActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
# line 279 "MakeLoops.puma"

int i, k, dimval;
bool found;
tTree newexp;
struct_shape h_shp;

  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
  if (t->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 286 "MakeLoops.puma"
  {
# line 291 "MakeLoops.puma"
 

    newexp = VarParamToExp (t->BTP_LIST.Elem);

    GetIntConstValue (t->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E, &found, &dimval);
    if (!found)
       error_protocol ("DIM in SPREAD only at run-time");
     else if ((dimval <= 0) || (dimval > s->rank))
       error_protocol ("DIM in SPREAD out of range");
     else
       { 
         h_shp.rank = s->rank-1;
         for (i=0;i<s->rank;i++)
           if (i != dimval-1)
               { k = i;
                 if (i>=dimval) k = i-1;
                 h_shp.bounds[k][0] = s->bounds[i][0];
                 h_shp.bounds[k][1] = s->bounds[i][1];
                 h_shp.bounds[k][2] = s->bounds[i][2];
                 h_shp.perm[k] = s->perm[i];
               }
         newexp = SetActualShape (newexp, &h_shp);
       }
  
  }
   return newexp;

  }
  }
  }
  }
  }
  }
  }
# line 319 "MakeLoops.puma"
  {
# line 320 "MakeLoops.puma"
   error_protocol ("illegal SPREAD for SetSpreadActualShape");
  }
   return t;

}

static tTree SetTransposeShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (t->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 332 "MakeLoops.puma"
 {
  struct_shape tshape;
  {
# line 335 "MakeLoops.puma"

# line 337 "MakeLoops.puma"
 tshape = *s;
    tshape.bounds[0][0] = s->bounds[1][0];
    tshape.bounds[0][1] = s->bounds[1][1];
    tshape.bounds[0][2] = s->bounds[1][2];
    tshape.bounds[1][0] = s->bounds[0][0];
    tshape.bounds[1][1] = s->bounds[0][1];
    tshape.bounds[1][2] = s->bounds[0][2];
    tshape.perm[0]      = s->perm[1];
    tshape.perm[1]      = s->perm[0];
    
  
  }
  {
   return SetActualShape (VarParamToExp (t->BTP_LIST.Elem), & tshape);
  }
 }

  }
  }
  }
  }
  }
# line 352 "MakeLoops.puma"
  {
# line 354 "MakeLoops.puma"
   error_protocol ("illegal TRANSPOSE for SetTransposeShape");
  }
   return t;

}

static void SetActualIndexShape
# if defined __STDC__ | defined __cplusplus
(register tTree ind, shape s, register int n)
# else
(ind, s, n)
 register tTree ind;
 shape s;
 register int n;
# endif
{
# line 361 "MakeLoops.puma"

int rank;
struct_shape h_shp;

  if (ind->Kind == kBTE_LIST) {
  if (ind->BTE_LIST.Elem->Kind == kSLICE_EXP) {
# line 366 "MakeLoops.puma"
 {
  tTree nexp;
  {
# line 368 "MakeLoops.puma"

# line 370 "MakeLoops.puma"
 nexp = mVAR_EXP (GetLoopTemporary (s->perm[n]));

     ind->BTE_LIST.Elem = FindShapeExp (ind->BTE_LIST.Elem, s->bounds[n][0], s->bounds[n][1], 
                               s->bounds[n][2], nexp);

     SetActualIndexShape (ind, s, n+1);
   
  }
   return;
 }

  }
# line 379 "MakeLoops.puma"
  {
# line 381 "MakeLoops.puma"
   if (! ((TreeRank (ind->BTE_LIST.Elem) == 0))) goto yyL2;
  {
# line 383 "MakeLoops.puma"
   SetActualIndexShape (ind->BTE_LIST.Next, s, n);
  }
  }
   return;
yyL2:;

# line 386 "MakeLoops.puma"
  {
# line 388 "MakeLoops.puma"
   if (! ((TreeRank (ind->BTE_LIST.Elem) != 1))) goto yyL3;
  {
# line 390 "MakeLoops.puma"
   error_protocol ("wrong indirect addressing in SetActualIndexShape");
  }
  }
   return;
yyL3:;

# line 393 "MakeLoops.puma"
  {
# line 397 "MakeLoops.puma"
 

    h_shp.rank = 1;
    h_shp.bounds[0][0] = s->bounds[n][0];
    h_shp.bounds[0][1] = s->bounds[n][1];
    h_shp.bounds[0][2] = s->bounds[n][2];
    h_shp.perm [0]     = s->perm[n];

    ind->BTE_LIST.Elem = SetActualShape (ind->BTE_LIST.Elem, &h_shp);

  
# line 409 "MakeLoops.puma"
   SetActualIndexShape (ind->BTE_LIST.Next, s, n + 1);
  }
   return;

  }
  if (ind->Kind == kBTE_EMPTY) {
# line 412 "MakeLoops.puma"
   return;

  }
# line 415 "MakeLoops.puma"
  {
# line 417 "MakeLoops.puma"
   failure_protocol (MODULE, "SetActualIndexShape", ind);
  }
   return;

;
}

tTree MakeOuterLoops
# if defined __STDC__ | defined __cplusplus
(register int line, shape s, register tTree body, register int kind)
# else
(line, s, body, kind)
 register int line;
 shape s;
 register tTree body;
 register int kind;
# endif
{
# line 432 "MakeLoops.puma"

tTree new, var, range, info;
int i;

# line 443 "MakeLoops.puma"
  {
# line 445 "MakeLoops.puma"
 new = body;
    for (i=0; i<s->rank; i++)
      { 
        if (s->bounds[i][0] != s->bounds[i][1])
          { 
            new = MakeListBody (new);
            var = GetLoopTemporary (s->perm[i]);
            
            if (s->bounds[i][2] != NoTree)
                range = s->bounds[i][2];
              else
                range = mDUMMY_EXP();
            
            range = mSLICE_EXP (s->bounds[i][0], 
                                s->bounds[i][1], range);
            if (kind == GEN_DO_INDEPENDENT)
               { info = mINDEP_INFO (false, 0, NoTree, NoTree);
                 new = mACF_DO (var, range, new, info, mNO_HOME_INFO ());
                 LineACFNode (new, line);
               }
             else if (kind == GEN_FORALL)
               { info = mINDEP_INFO (false, 0, NoTree, NoTree);
                 new = mACF_FORALL (var, range, new, info, mNO_HOME_INFO());
                 LineACFNode (new, line);
               }
             else
               { new = mACF_DO (var, range, new, mSERIAL_INFO(), 
                                mNO_HOME_INFO());
                 LineACFNode (new, line);
               }
          }
      }
  
  }
   return new;

}

static tTree MakeListBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_LIST) {
# line 483 "MakeLoops.puma"
   return t;

  }
  if (t->Kind == kACF_EMPTY) {
# line 487 "MakeLoops.puma"
   return t;

  }
  if (Tree_IsType (t, kACF_NODE)) {
# line 491 "MakeLoops.puma"
   return mACF_LIST (t, mACF_EMPTY ());

  }
 yyAbort ("MakeListBody");
}

tTree MakeOuterImpliedLoops
# if defined __STDC__ | defined __cplusplus
(shape s, register tTree body)
# else
(s, body)
 shape s;
 register tTree body;
# endif
{
# line 503 "MakeLoops.puma"

tTree new, var, range;
int i;

# line 508 "MakeLoops.puma"
  {
# line 509 "MakeLoops.puma"
 new = body;
    for (i=0; i<s->rank; i++)
      { 
        if (s->bounds[i][0] != s->bounds[i][1])
          { 
            new = mBTE_LIST (new, mBTE_EMPTY());
            var = GetLoopTemporary (i+1);
            
            if (s->bounds[i][2] != NoTree)
                range = s->bounds[i][2];
              else
                range = mDUMMY_EXP();
            
            range = mSLICE_EXP (s->bounds[i][0], 
                                s->bounds[i][1], range);
            new = mDO_EXP (var, range, new);
          }
      }
  
  }
   return new;

}

tTree MakeOuterImpliedLoopsV
# if defined __STDC__ | defined __cplusplus
(shape s, register tTree body)
# else
(s, body)
 shape s;
 register tTree body;
# endif
{
# line 539 "MakeLoops.puma"

tTree new, var, range;
int i;

# line 544 "MakeLoops.puma"
  {
# line 545 "MakeLoops.puma"
 new = body;
    for (i=0; i<s->rank; i++)
      { 
        if (s->bounds[i][0] != s->bounds[i][1])
          { 
            new = mBTV_LIST (new, mBTV_EMPTY());
            var = GetLoopTemporary (i+1);
            
            if (s->bounds[i][2] != NoTree)
                range = s->bounds[i][2];
              else
                range = mDUMMY_EXP();
            
            range = mSLICE_EXP (s->bounds[i][0], 
                                s->bounds[i][1], range);
            new = mDO_VAR (var, range, new);
          }
      }
  
  }
   return new;

}

void BeginMakeLoops ()
{
}

void CloseMakeLoops ()
{
}
