# include "MakeLocal.h"
# include "yyMakeLocal.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 24 "MakeLocal.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Nesting.h" 
# include "Objects.h"
# include "Temporary.h"

# include "Traverse.h"       /* ReplaceAST             */

# include "Transform.h"      /* ComposeNewACF, CombineXXX */

# include "MakeHome.h"       /* MakeNewHome               */
# include "CheckComm.h"      /* CheckCommunication        */
# include "ExtractComm.h"    /* ExtractCommunication      */

# define MODULE "MakeLocal"



static void yyExit () { Exit (1); }

void (* MakeLocal_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeLocal, routine %s failed\n", yyFunction);
 MakeLocal_Exit ();
}

void MakeLocal ARGS((tTree t));
static void MakeLocalBody ARGS((tTree t));
static tTree LocalizeStatements ARGS((tTree t));
static tTree ExtendLoop ARGS((tTree t, tTree pre, tTree post));
static tTree Serialize ARGS((tTree stmt));
static tTree GetNewHomes ARGS((tTree body));
static tTree GetNewHome1 ARGS((tTree stmt));

void MakeLocal
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kCOMP_UNIT:
# line 60 "MakeLocal.puma"
  {
# line 62 "MakeLocal.puma"
   open_protocol ("adaptor.local");
# line 63 "MakeLocal.puma"
   MakeLocal (t->COMP_UNIT.COMP_ELEMENTS);
# line 64 "MakeLocal.puma"
   close_protocol ();
  }
   return;

  case kUNIT_LIST:
# line 67 "MakeLocal.puma"
  {
# line 69 "MakeLocal.puma"
   MakeLocal (t->UNIT_LIST.Elem);
# line 70 "MakeLocal.puma"
   MakeLocal (t->UNIT_LIST.Next);
  }
   return;

  case kUNIT_EMPTY:
# line 73 "MakeLocal.puma"
   return;

  case kPROGRAM_DECL:
# line 76 "MakeLocal.puma"
  {
# line 78 "MakeLocal.puma"
   NestOpenUnit (t);
# line 79 "MakeLocal.puma"
   MakeLocal (t->PROGRAM_DECL.PROGRAM_BODY);
# line 80 "MakeLocal.puma"
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
# line 83 "MakeLocal.puma"
  {
# line 85 "MakeLocal.puma"
   NestOpenUnit (t);
# line 86 "MakeLocal.puma"
   MakeLocal (t->PROC_DECL.PROC_BODY);
# line 87 "MakeLocal.puma"
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
# line 90 "MakeLocal.puma"
  {
# line 92 "MakeLocal.puma"
   NestOpenUnit (t);
# line 93 "MakeLocal.puma"
   MakeLocal (t->FUNC_DECL.FUNC_BODY);
# line 94 "MakeLocal.puma"
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 97 "MakeLocal.puma"
  {
# line 99 "MakeLocal.puma"
   NestOpenUnit (t);
# line 100 "MakeLocal.puma"
   MakeLocal (t->BLOCK_DATA_DECL.DATA_BODY);
# line 101 "MakeLocal.puma"
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
# line 104 "MakeLocal.puma"
  {
# line 106 "MakeLocal.puma"
   NestOpenUnit (t);
# line 107 "MakeLocal.puma"
   MakeLocal (t->MODULE_DECL.MODULE_BODY);
# line 108 "MakeLocal.puma"
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
# line 111 "MakeLocal.puma"
  {
# line 113 "MakeLocal.puma"
   if (! ((IsPureUnit (GetCurrentUnit ())))) goto yyL9;
  }
   return;
yyL9:;

# line 118 "MakeLocal.puma"
  {
# line 120 "MakeLocal.puma"
   TemporaryInit (t);
# line 122 "MakeLocal.puma"
   print_protocol ("Extract communication: \n");
# line 124 "MakeLocal.puma"
   MakeLocalBody (t);
# line 126 "MakeLocal.puma"
   TemporaryDone (t);
# line 128 "MakeLocal.puma"
   MakeLocal (t->BODY_NODE.INTERNALS);
  }
   return;

  }

;
}

static void MakeLocalBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 144 "MakeLocal.puma"
  {
# line 146 "MakeLocal.puma"
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return;
yyL1:;

# line 149 "MakeLocal.puma"
  {
# line 151 "MakeLocal.puma"
 t->BODY_NODE.STATS = LocalizeStatements (t->BODY_NODE.STATS); 
  }
   return;

  }
# line 154 "MakeLocal.puma"
  {
# line 155 "MakeLocal.puma"
   failure_protocol (MODULE, "MakeLocalBody", t);
  }
   return;

;
}

static tTree LocalizeStatements
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 166 "MakeLocal.puma"
 {
  tTree newacf;
  {
# line 168 "MakeLocal.puma"

# line 170 "MakeLocal.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 172 "MakeLocal.puma"
 newacf = LocalizeStatements (t->ACF_LIST.Elem);            
     t->ACF_LIST.Next   = LocalizeStatements (t->ACF_LIST.Next);            
   
# line 176 "MakeLocal.puma"
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
  {
   return newacf;
  }
 }

  case kACF_EMPTY:
# line 181 "MakeLocal.puma"
   return t;

  case kACF_WHILE:
# line 192 "MakeLocal.puma"
 {
  int errors;
  tTree new_exp;
  tTree pre_stmts;
  tTree post_stmts;
  {
# line 194 "MakeLocal.puma"
 t->ACF_WHILE.WHILE_BODY = LocalizeStatements (t->ACF_WHILE.WHILE_BODY); 
# line 198 "MakeLocal.puma"

# line 200 "MakeLocal.puma"
   errors = CheckCommunicationExp (t->ACF_WHILE.WHILE_EXP);
# line 202 "MakeLocal.puma"
   if (! ((errors == 0))) goto yyL3;
  {
# line 204 "MakeLocal.puma"

# line 205 "MakeLocal.puma"

# line 206 "MakeLocal.puma"

# line 208 "MakeLocal.puma"
   ExtractCommunicationExp (t->ACF_WHILE.WHILE_EXP, & new_exp, & pre_stmts, & post_stmts);
# line 210 "MakeLocal.puma"
 t->ACF_WHILE.WHILE_EXP = new_exp; 
  }
  }
  {
   return ExtendLoop (t, pre_stmts, post_stmts);
  }
 }
yyL3:;

# line 215 "MakeLocal.puma"
  {
# line 217 "MakeLocal.puma"
   error_protocol ("unresolvable communication for exp in WHILE");
  }
   return t;

  case kACF_TASK_REGION:
# line 228 "MakeLocal.puma"
  {
# line 230 "MakeLocal.puma"
 t->ACF_TASK_REGION.TASK_BODY = LocalizeStatements (t->ACF_TASK_REGION.TASK_BODY); 
  }
   return t;

  case kACF_DO:
# line 241 "MakeLocal.puma"
 {
  int errors;
  tTree new_exp;
  tTree pre_stmts;
  tTree post_stmts;
  {
# line 243 "MakeLocal.puma"
 t->ACF_DO.DO_BODY = LocalizeStatements (t->ACF_DO.DO_BODY); 
# line 247 "MakeLocal.puma"

# line 249 "MakeLocal.puma"
   errors = CheckCommunicationExp (t->ACF_DO.DO_RANGE);
# line 251 "MakeLocal.puma"
   if (! ((errors == 0))) goto yyL6;
  {
# line 253 "MakeLocal.puma"

# line 254 "MakeLocal.puma"

# line 255 "MakeLocal.puma"

# line 257 "MakeLocal.puma"
   ExtractCommunicationExp (t->ACF_DO.DO_RANGE, & new_exp, & pre_stmts, & post_stmts);
# line 259 "MakeLocal.puma"
 t->ACF_DO.DO_RANGE = new_exp; 
  }
  }
  {
   return ExtendLoop (t, pre_stmts, post_stmts);
  }
 }
yyL6:;

# line 264 "MakeLocal.puma"
  {
# line 266 "MakeLocal.puma"
   error_protocol ("unresolvable communication for exp in DO");
  }
   return t;

  case kACF_IF:
# line 277 "MakeLocal.puma"
 {
  int errors;
  tTree new_exp;
  tTree pre_stmts;
  tTree post_stmts;
  {
# line 279 "MakeLocal.puma"
 t->ACF_IF.THEN_PART = LocalizeStatements (t->ACF_IF.THEN_PART); 
     t->ACF_IF.ELSE_PART = LocalizeStatements (t->ACF_IF.ELSE_PART); 
   
# line 285 "MakeLocal.puma"

# line 287 "MakeLocal.puma"
   errors = CheckCommunicationExp (t->ACF_IF.IF_EXP);
# line 289 "MakeLocal.puma"
   if (! ((errors == 0))) goto yyL8;
  {
# line 291 "MakeLocal.puma"

# line 292 "MakeLocal.puma"

# line 293 "MakeLocal.puma"

# line 295 "MakeLocal.puma"
   ExtractCommunicationExp (t->ACF_IF.IF_EXP, & new_exp, & pre_stmts, & post_stmts);
# line 297 "MakeLocal.puma"
 t->ACF_IF.IF_EXP = new_exp; 
  }
  }
  {
   return ComposeNewACF (pre_stmts, t, post_stmts);
  }
 }
yyL8:;

# line 302 "MakeLocal.puma"
  {
# line 304 "MakeLocal.puma"
   error_protocol ("unresolvable communication for exp in IF");
  }
   return t;

  case kACF_FORALL:
# line 315 "MakeLocal.puma"
 {
  int errors;
  {
# line 317 "MakeLocal.puma"

# line 319 "MakeLocal.puma"
   errors = CheckCommunication (t);
# line 321 "MakeLocal.puma"
   if (! ((errors == 0))) goto yyL10;
  }
  {
   return ExtractCommunication (t);
  }
 }
yyL10:;

# line 326 "MakeLocal.puma"
   return Serialize (t);

  case kACF_HOME:
# line 337 "MakeLocal.puma"
 {
  int errors;
  {
# line 339 "MakeLocal.puma"

# line 341 "MakeLocal.puma"
   errors = CheckCommunication (t);
# line 343 "MakeLocal.puma"
   if (! ((errors == 0))) goto yyL12;
  }
  {
   return ExtractCommunication (t);
  }
 }
yyL12:;

  if (t->ACF_HOME.HOME_BODY->Kind == kACF_LIST) {
  if (t->ACF_HOME.HOME_BODY->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 348 "MakeLocal.puma"
  {
# line 350 "MakeLocal.puma"
   if (! ((IsParallelLoop (t->ACF_HOME.HOME_BODY->ACF_LIST.Elem)))) goto yyL13;
  {
# line 352 "MakeLocal.puma"
   set_protocol_stmt (t->ACF_HOME.HOME_BODY->ACF_LIST.Elem);
# line 354 "MakeLocal.puma"
   serious_warning_protocol ("loop becomes serial");
  }
  }
   return Serialize (t->ACF_HOME.HOME_BODY->ACF_LIST.Elem);
yyL13:;

  }
  }
# line 359 "MakeLocal.puma"
  {
# line 361 "MakeLocal.puma"
   set_protocol_stmt (t);
# line 363 "MakeLocal.puma"
   serious_warning_protocol ("HOME directive is ignored");
  }
   return Serialize (t);

  case kACF_WHERE:
# line 392 "MakeLocal.puma"
  {
# line 394 "MakeLocal.puma"
   error_protocol ("there should be no more WHERE statements at this point");
  }
   return t;

  case kACF_REDUCTION:
# line 399 "MakeLocal.puma"
  {
# line 401 "MakeLocal.puma"
 t->ACF_REDUCTION.REDUCTION_BODY = LocalizeStatements (t->ACF_REDUCTION.REDUCTION_BODY); 
  }
   return t;

  case kACF_NEW:
# line 406 "MakeLocal.puma"
  {
# line 408 "MakeLocal.puma"
 t->ACF_NEW.NEW_BODY = LocalizeStatements (t->ACF_NEW.NEW_BODY); 
  }
   return t;

  }

# line 413 "MakeLocal.puma"
 {
  int errors;
  {
# line 415 "MakeLocal.puma"
   SetActualData (t);
# line 417 "MakeLocal.puma"

# line 419 "MakeLocal.puma"
   errors = CheckCommunication (t);
# line 421 "MakeLocal.puma"
   if (! ((errors == 0))) goto yyL20;
  }
  {
   return ExtractCommunication (t);
  }
 }
yyL20:;

# line 426 "MakeLocal.puma"
  {
# line 428 "MakeLocal.puma"
   error_protocol ("unresolvable communication in this stmt");
  }
   return t;

}

static tTree ExtendLoop
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree pre, register tTree post)
# else
(t, pre, post)
 register tTree t;
 register tTree pre;
 register tTree post;
# endif
{
# line 451 "MakeLocal.puma"
  {
# line 453 "MakeLocal.puma"
   if (! ((pre == NoTree))) goto yyL1;
  {
# line 454 "MakeLocal.puma"
   if (! ((post == NoTree))) goto yyL1;
  }
  }
   return t;
yyL1:;

  if (t->Kind == kACF_WHILE) {
# line 459 "MakeLocal.puma"
  {
# line 461 "MakeLocal.puma"
   if (! ((post == NoTree))) goto yyL2;
  {
# line 463 "MakeLocal.puma"
 t->ACF_WHILE.WHILE_BODY = AppendBody (t->ACF_WHILE.WHILE_BODY, CopyTree (pre)); 
  }
  }
   return CombineACF (pre, t);
yyL2:;

  }
  if (t->Kind == kACF_DO) {
# line 468 "MakeLocal.puma"
  {
# line 470 "MakeLocal.puma"
   if (! ((post == NoTree))) goto yyL3;
  {
# line 472 "MakeLocal.puma"
 t->ACF_DO.DO_BODY = AppendBody (t->ACF_DO.DO_BODY, CopyTree (pre)); 
  }
  }
   return CombineACF (pre, t);
yyL3:;

  }
# line 477 "MakeLocal.puma"
  {
# line 479 "MakeLocal.puma"
   if (! ((post != NoTree))) goto yyL4;
  {
# line 481 "MakeLocal.puma"
   error_protocol ("DO [WHILE] requires post statements for communication");
# line 483 "MakeLocal.puma"
   tree_protocol ("post : ", post);
  }
  }
   return ExtendLoop (t, pre, NoTree);
yyL4:;

 yyAbort ("ExtendLoop");
}

static tTree Serialize
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_HOME) {
# line 501 "MakeLocal.puma"
 {
  tTree new;
  {
# line 503 "MakeLocal.puma"

# line 505 "MakeLocal.puma"
   new = GetNewHomes (stmt->ACF_HOME.HOME_BODY);
# line 507 "MakeLocal.puma"
   tree_protocol ("new homes of body are :\n", new);
# line 509 "MakeLocal.puma"
   new = LocalizeStatements (new);
# line 511 "MakeLocal.puma"
   tree_protocol ("new localization is now (ignoring home) :\n", new);
  }
  {
   return new;
  }
 }

  }
  if (stmt->Kind == kACF_DO) {
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 516 "MakeLocal.puma"
 {
  tTree new;
  {
# line 518 "MakeLocal.puma"

# line 520 "MakeLocal.puma"
 stmt->ACF_DO.DO_DEP_INFO = mSERIAL_INFO (); 
# line 522 "MakeLocal.puma"
   new = stmt;
# line 524 "MakeLocal.puma"
   tree_protocol ("DO loop now serialized : \n", new);
# line 526 "MakeLocal.puma"
   new = MakeNewHome (new);
# line 528 "MakeLocal.puma"
   tree_protocol ("DO loop with new homes : \n", new);
# line 530 "MakeLocal.puma"
   new = LocalizeStatements (new);
# line 532 "MakeLocal.puma"
   tree_protocol ("DO loop localized is now  : \n", new);
  }
  {
   return new;
  }
 }

  }
  }
# line 549 "MakeLocal.puma"
  {
# line 551 "MakeLocal.puma"
   failure_protocol (MODULE, "Serialize", stmt);
  }
   return NoTree;

}

static tTree GetNewHomes
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 587 "MakeLocal.puma"
   return GetNewHome1 (body->ACF_LIST.Elem);

  }
# line 596 "MakeLocal.puma"
   return MakeNewHome (body);

  }
# line 601 "MakeLocal.puma"
  {
# line 603 "MakeLocal.puma"
   failure_protocol (MODULE, "GetNewHomes", body);
  }
   return NoTree;

}

static tTree GetNewHome1
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_NEW) {
# line 609 "MakeLocal.puma"
  {
# line 611 "MakeLocal.puma"
 stmt->ACF_NEW.NEW_BODY = MakeNewHome (stmt->ACF_NEW.NEW_BODY); 
  }
   return stmt;

  }
# line 616 "MakeLocal.puma"
  {
# line 618 "MakeLocal.puma"
   if (! ((IsParallelLoop (stmt)))) goto yyL2;
  }
   return Serialize (stmt);
yyL2:;

  if (stmt->Kind == kACF_DO) {
# line 623 "MakeLocal.puma"
  {
# line 625 "MakeLocal.puma"
 stmt->ACF_DO.DO_BODY = MakeNewHome (stmt->ACF_DO.DO_BODY); 
  }
   return stmt;

  }
  if (stmt->Kind == kACF_IF) {
# line 630 "MakeLocal.puma"
  {
# line 632 "MakeLocal.puma"
 stmt->ACF_IF.THEN_PART = MakeNewHome (stmt->ACF_IF.THEN_PART); 
     stmt->ACF_IF.ELSE_PART = MakeNewHome (stmt->ACF_IF.ELSE_PART);
   
  }
   return stmt;

  }
# line 639 "MakeLocal.puma"
   return stmt;

}

void BeginMakeLocal ()
{
}

void CloseMakeLocal ()
{
}
