# include "MakeInterface.h"
# include "yyMakeInterface.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 22 "MakeInterface.puma"


#include "protocol.h"

#include "Types.h"        /* IsVarDummy, IsTemplate */
#include "Transform.h"    /* ReplaceDECL */

#include "DefTable.h"   
#include "Objects.h"



static void yyExit () { Exit (1); }

void (* MakeInterface_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeInterface, routine %s failed\n", yyFunction);
 MakeInterface_Exit ();
}

void MakeInterface ARGS((tTree t));
static tTree UnitsInterfaces ARGS((tTree t));
static tTree InterfaceDECL ARGS((tTree t));

void MakeInterface
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMP_UNIT) {
# line 42 "MakeInterface.puma"
 {
  tTree interfaces;
  {
# line 44 "MakeInterface.puma"
   open_protocol ("adaptor.intf");
# line 46 "MakeInterface.puma"

# line 50 "MakeInterface.puma"
 interfaces = UnitsInterfaces (t->COMP_UNIT.COMP_ELEMENTS); 
      interfaces = mINTERFACE (DefaultId (), 0,
                               mNO_GENERIC_SPEC(), interfaces);

      t->COMP_UNIT.COMP_ELEMENTS = mUNIT_LIST (interfaces, mUNIT_EMPTY ());
    
# line 57 "MakeInterface.puma"
   close_protocol ();
  }
   return;
 }

  }
;
}

static tTree UnitsInterfaces
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kUNIT_LIST:
# line 70 "MakeInterface.puma"
 {
  tTree new_decl;
  {
# line 72 "MakeInterface.puma"

# line 74 "MakeInterface.puma"
 new_decl = UnitsInterfaces (t->UNIT_LIST.Elem);
     t->UNIT_LIST.Next     = UnitsInterfaces (t->UNIT_LIST.Next);
     new_decl = ReplaceUNIT (t, new_decl, t->UNIT_LIST.Next);
   
  }
  {
   return new_decl;
  }
 }

  case kUNIT_EMPTY:
# line 81 "MakeInterface.puma"
   return t;

  case kPROGRAM_DECL:
# line 86 "MakeInterface.puma"
   return NoTree;

  case kPROC_DECL:
# line 91 "MakeInterface.puma"
 {
  tDefinitions Obj;
  {
# line 93 "MakeInterface.puma"
   set_protocol_unit (t);
# line 94 "MakeInterface.puma"

# line 95 "MakeInterface.puma"
   Obj = GetDeclEntry (t->PROC_DECL.Ident, GetUnitEntries ());
# line 96 "MakeInterface.puma"
   OpenScope (Obj->ProcObject.Declarations);
# line 97 "MakeInterface.puma"
 t->PROC_DECL.PROC_BODY = UnitsInterfaces (t->PROC_DECL.PROC_BODY); 
# line 98 "MakeInterface.puma"
   CloseScope ();
  }
  {
   return t;
  }
 }

  case kFUNC_DECL:
# line 102 "MakeInterface.puma"
 {
  tDefinitions Obj;
  {
# line 104 "MakeInterface.puma"
   set_protocol_unit (t);
# line 105 "MakeInterface.puma"

# line 106 "MakeInterface.puma"
   Obj = GetDeclEntry (t->FUNC_DECL.Ident, GetUnitEntries ());
# line 107 "MakeInterface.puma"
   OpenScope (Obj->FuncObject.Declarations);
# line 108 "MakeInterface.puma"
 t->FUNC_DECL.FUNC_BODY = UnitsInterfaces (t->FUNC_DECL.FUNC_BODY); 
# line 109 "MakeInterface.puma"
   CloseScope ();
  }
  {
   return t;
  }
 }

  case kBLOCK_DATA_DECL:
# line 113 "MakeInterface.puma"
   return NoTree;

  case kMODULE_DECL:
# line 118 "MakeInterface.puma"
   return NoTree;

  case kBODY_NODE:
# line 123 "MakeInterface.puma"
  {
# line 125 "MakeInterface.puma"
 t->BODY_NODE.DECLS     = InterfaceDECL (t->BODY_NODE.DECLS);
     t->BODY_NODE.STATS     = mACF_EMPTY ();
     t->BODY_NODE.INTERNALS = mUNIT_EMPTY ();
   
  }
   return t;

  }

 yyAbort ("UnitsInterfaces");
}

static tTree InterfaceDECL
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDECL_LIST) {
# line 142 "MakeInterface.puma"
 {
  tTree new_decl;
  {
# line 144 "MakeInterface.puma"

# line 146 "MakeInterface.puma"
 new_decl = InterfaceDECL (t->DECL_LIST.Elem);
       t->DECL_LIST.Next     = InterfaceDECL (t->DECL_LIST.Next);
       new_decl = ReplaceDECL (t, new_decl, t->DECL_LIST.Next);
     
  }
  {
   return new_decl;
  }
 }

  }
  if (t->Kind == kDECL_EMPTY) {
# line 154 "MakeInterface.puma"
   return t;

  }
  if (t->Kind == kIMPLICIT_DECL) {
# line 158 "MakeInterface.puma"
   return t;

  }
  if (Tree_IsType (t, kDECL_NODE)) {
# line 165 "MakeInterface.puma"
  {
# line 166 "MakeInterface.puma"
   if (! ((GetLocalObject (t->DECL_NODE.Ident) == NoObject))) goto yyL4;
  }
   return NoTree;
yyL4:;

  }
  if (t->Kind == kTEMPLATE_DECL) {
# line 172 "MakeInterface.puma"
   return t;

  }
  if (Tree_IsType (t, kDECL_NODE)) {
# line 179 "MakeInterface.puma"
 {
  tDefinitions Obj;
  {
# line 180 "MakeInterface.puma"

# line 181 "MakeInterface.puma"
   Obj = GetLocalObject (t->DECL_NODE.Ident);
# line 182 "MakeInterface.puma"
   if (! ((IsVarDummy (Obj) || IsTemplate (Obj)))) goto yyL6;
  }
  {
   return t;
  }
 }
yyL6:;

  }
# line 188 "MakeInterface.puma"
   return NoTree;

}

void BeginMakeInterface ()
{
}

void CloseMakeInterface ()
{
}
