# include "MakeHome.h"
# include "yyMakeHome.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 48 "MakeHome.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Transform.h" 
# include "Traverse.h"
# include "FindHome.h"
# include "Temporary.h"

# include "Nesting.h"               /* NestOpen */

# include "Objects.h"

# include "Descriptor.h"
# include "HomeDescriptor.h"
# include "MoveDescriptor.h"
# include "ParNest.h"
# include "Expansion.h"             /* FullExpansion          */

# include "CheckHome.h"             /* CheckHome              */
# include "ArrayData.h"

# define MODULE "MakeHome"
# undef DEBUG



static void yyExit () { Exit (1); }

void (* MakeHome_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeHome, routine %s failed\n", yyFunction);
 MakeHome_Exit ();
}

void MakeHome ARGS((tTree t));
static void DetermineHome ARGS((tTree t));
tTree MakeNewHome ARGS((tTree t));
static bool StopDetermineHome ARGS((tTree t));
tTree DoDetermineHome ARGS((tTree t));
static tTree PropagateHome ARGS((tTree t, pvar outer_home));
static void InfoDoLoopHome ARGS((tTree loop, pvar iter_home));
static tTree SetNewHome ARGS((tTree stmt, pvar outer_home, pvar inner_home));
static tTree BuildNewVarHome ARGS((tTree stmt, pvar home));
static int GetBodyLine ARGS((tTree stmt));
static void MakeHomeTemplate ARGS((pvar home, pvar home1, tTree * yyP2, tTree * yyP1));
static void SetIterationsHome ARGS((tTree loop, pvar iter_home));
static void SetSelection ARGS((tTree loop, pvar iter_home));
static void FindNewHomeDescriptor ARGS((tTree stmt, pvar cur_home, pvar new_home));
static void FindSerialHomeDescriptor ARGS((tTree stmt, pvar cur_home, pvar new_home));
static void DetermineFinalHome ARGS((pvar cur_home, pvar min_home, pvar new_home));
static void InheritTemplate ARGS((pvar home, pvar sub_home));
static void CheckCallHome ARGS((tTree t, pvar final_home));

void MakeHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kCOMP_UNIT:
# line 91 "MakeHome.puma"
  {
# line 93 "MakeHome.puma"
   open_protocol ("adaptor.home");
# line 94 "MakeHome.puma"
   MakeHome (t->COMP_UNIT.COMP_ELEMENTS);
# line 95 "MakeHome.puma"
   close_protocol ();
  }
   return;

  case kUNIT_LIST:
# line 100 "MakeHome.puma"
  {
# line 102 "MakeHome.puma"
   MakeHome (t->UNIT_LIST.Elem);
# line 103 "MakeHome.puma"
   MakeHome (t->UNIT_LIST.Next);
  }
   return;

  case kUNIT_EMPTY:
# line 106 "MakeHome.puma"
   return;

  case kPROGRAM_DECL:
# line 109 "MakeHome.puma"
  {
# line 111 "MakeHome.puma"
   NestOpenUnit (t);
# line 112 "MakeHome.puma"
   MakeHome (t->PROGRAM_DECL.PROGRAM_BODY);
# line 113 "MakeHome.puma"
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
# line 116 "MakeHome.puma"
  {
# line 118 "MakeHome.puma"
   NestOpenUnit (t);
# line 119 "MakeHome.puma"
   MakeHome (t->PROC_DECL.PROC_BODY);
# line 120 "MakeHome.puma"
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
# line 123 "MakeHome.puma"
  {
# line 125 "MakeHome.puma"
   NestOpenUnit (t);
# line 126 "MakeHome.puma"
   MakeHome (t->FUNC_DECL.FUNC_BODY);
# line 127 "MakeHome.puma"
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 130 "MakeHome.puma"
  {
# line 132 "MakeHome.puma"
   NestOpenUnit (t);
# line 133 "MakeHome.puma"
   MakeHome (t->BLOCK_DATA_DECL.DATA_BODY);
# line 134 "MakeHome.puma"
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
# line 137 "MakeHome.puma"
  {
# line 139 "MakeHome.puma"
   NestOpenUnit (t);
# line 140 "MakeHome.puma"
   MakeHome (t->MODULE_DECL.MODULE_BODY);
# line 141 "MakeHome.puma"
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
# line 144 "MakeHome.puma"
  {
# line 146 "MakeHome.puma"
   if (! ((IsPureUnit (GetCurrentUnit ())))) goto yyL9;
  }
   return;
yyL9:;

# line 151 "MakeHome.puma"
  {
# line 153 "MakeHome.puma"
   TemporaryInit (t);
# line 155 "MakeHome.puma"
   print_protocol ("Step 1 : check home \n");
# line 157 "MakeHome.puma"
   CheckHome (t);
# line 159 "MakeHome.puma"
   print_protocol ("Step 2 : find home \n");
# line 161 "MakeHome.puma"
   DetermineHome (t);
# line 163 "MakeHome.puma"
   TemporaryDone (t);
# line 165 "MakeHome.puma"
   MakeHome (t->BODY_NODE.INTERNALS);
  }
   return;

  }

;
}

static void DetermineHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 201 "MakeHome.puma"
  {
# line 203 "MakeHome.puma"
 t->BODY_NODE.STATS = MakeNewHome (t->BODY_NODE.STATS); 
  }
   return;

  }
# line 206 "MakeHome.puma"
  {
# line 207 "MakeHome.puma"
   failure_protocol (MODULE, "DetermineHome", t);
  }
   return;

;
}

tTree MakeNewHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 212 "MakeHome.puma"
   return ReplaceAST (t, StopDetermineHome, DoDetermineHome);

}

static bool StopDetermineHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 230 "MakeHome.puma"
   return true;

  }
  }
  if (t->Kind == kACF_FORALL) {
  if (t->ACF_FORALL.FORALL_DEP_INFO->Kind == kINDEP_INFO) {
# line 233 "MakeHome.puma"
   return true;

  }
  }
  if (t->Kind == kACF_HOME) {
# line 236 "MakeHome.puma"
   return true;

  }
  if (t->Kind == kACF_BASIC) {
# line 239 "MakeHome.puma"
   return true;

  }
# line 242 "MakeHome.puma"
  {
# line 243 "MakeHome.puma"
   return false;
  }

}

tTree DoDetermineHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 263 "MakeHome.puma"
 {
  var_descriptor vard;
  tTree new;
  {
# line 265 "MakeHome.puma"

# line 266 "MakeHome.puma"

# line 268 "MakeHome.puma"
   MakeReplicatedDescriptor (& vard);
# line 270 "MakeHome.puma"
   new = PropagateHome (t, & vard);
# line 272 "MakeHome.puma"
   tree_protocol ("home of independent loop identified : \n", new);
  }
  {
   return new;
  }
 }

  }
  }
  if (t->Kind == kACF_FORALL) {
# line 277 "MakeHome.puma"
  {
# line 279 "MakeHome.puma"
 t->Kind = kACF_DO; 
  }
   return DoDetermineHome (t);

  }
  if (t->Kind == kACF_HOME) {
# line 284 "MakeHome.puma"
 {
  var_descriptor vard;
  tTree new;
  {
# line 286 "MakeHome.puma"

# line 287 "MakeHome.puma"

# line 289 "MakeHome.puma"
   MakeReplicatedDescriptor (& vard);
# line 291 "MakeHome.puma"
   new = PropagateHome (t, & vard);
# line 293 "MakeHome.puma"
   tree_protocol ("homes of home stmt/block identified : \n", new);
  }
  {
   return new;
  }
 }

  }
  if (t->Kind == kACF_BASIC) {
# line 298 "MakeHome.puma"
 {
  var_descriptor vard;
  tTree new;
  {
# line 300 "MakeHome.puma"

# line 301 "MakeHome.puma"

# line 303 "MakeHome.puma"
   MakeReplicatedDescriptor (& vard);
# line 305 "MakeHome.puma"
   new = PropagateHome (t, & vard);
# line 307 "MakeHome.puma"
 if (new != t)
        tree_protocol ("home of basic statement found : \n", new);
   
  }
  {
   return new;
  }
 }

  }
# line 314 "MakeHome.puma"
   return t;

}

static tTree PropagateHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar outer_home)
# else
(t, outer_home)
 register tTree t;
 pvar outer_home;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
# line 332 "MakeHome.puma"
 {
  tTree newacf;
  {
# line 334 "MakeHome.puma"

# line 336 "MakeHome.puma"
   set_protocol_stmt (t->ACF_LIST.Elem);
# line 338 "MakeHome.puma"
 newacf = PropagateHome (t->ACF_LIST.Elem, outer_home);         
     t->ACF_LIST.Next   = PropagateHome (t->ACF_LIST.Next, outer_home);         
   
# line 342 "MakeHome.puma"
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
  {
   return newacf;
  }
 }

  case kACF_EMPTY:
# line 347 "MakeHome.puma"
   return t;

  case kACF_FORALL:
  if (t->ACF_FORALL.FORALL_DEP_INFO->Kind == kINDEP_INFO) {
# line 352 "MakeHome.puma"
  {
# line 354 "MakeHome.puma"
 t->Kind = kACF_DO; 
  }
   return PropagateHome (t, outer_home);

  }
  break;
  case kACF_DO:
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 359 "MakeHome.puma"
 {
  var_descriptor iter_home;
  tTree yyV1;
  tTree yyV2;
  bool okay;
  {
# line 361 "MakeHome.puma"
   IncParNesting (t);
# line 363 "MakeHome.puma"

# line 365 "MakeHome.puma"
   FindNewHomeDescriptor (t->ACF_DO.DO_BODY, outer_home, & iter_home);
# line 367 "MakeHome.puma"
   tree_protocol ("home of loop ", PrintableDescriptorVar (outer_home));
# line 368 "MakeHome.puma"
   tree_protocol ("home of loop body = ", PrintableDescriptorVar (& iter_home));
# line 370 "MakeHome.puma"
   InfoDoLoopHome (t, & iter_home);
# line 372 "MakeHome.puma"
   MakeHomeTemplate (outer_home, & iter_home, & yyV1, & yyV2);
# line 374 "MakeHome.puma"
   SetIterationsHome (t, & iter_home);
# line 375 "MakeHome.puma"
   SetSelection (t, & iter_home);
# line 377 "MakeHome.puma"
 t->ACF_DO.DO_BODY = PropagateHome (t->ACF_DO.DO_BODY, &iter_home); 
     t->ACF_DO.DO_BODY = MakeStmtList (SetNewHome (t->ACF_DO.DO_BODY, outer_home, &iter_home));
   
# line 381 "MakeHome.puma"

# line 383 "MakeHome.puma"
   ExpandDescriptor (& iter_home, t->ACF_DO.DO_ID, & okay);
# line 385 "MakeHome.puma"
 if (!okay)

        { set_protocol_stmt(t);
          serious_warning_protocol ("could not expand descriptor");
        }

   
# line 393 "MakeHome.puma"
   DecParNesting (t);
  }
  {
   return ComposeNewACF (yyV1, SetNewHome (t, outer_home, & iter_home), yyV2);
  }
 }

  }
  if (t->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
# line 564 "MakeHome.puma"
  {
# line 566 "MakeHome.puma"
 t->ACF_DO.DO_BODY = PropagateHome (t->ACF_DO.DO_BODY, outer_home); 
  }
   return t;

  }
  break;
  case kACF_NEW:
# line 399 "MakeHome.puma"
  {
# line 401 "MakeHome.puma"
   IncParNesting (t);
# line 402 "MakeHome.puma"
 t->ACF_NEW.NEW_BODY = PropagateHome (t->ACF_NEW.NEW_BODY, outer_home); 
# line 403 "MakeHome.puma"
   DecParNesting (t);
  }
   return t;

  case kACF_RESIDENT:
# line 408 "MakeHome.puma"
  {
# line 410 "MakeHome.puma"
   IncParNesting (t);
# line 411 "MakeHome.puma"
 t->ACF_RESIDENT.RESIDENT_BODY = PropagateHome (t->ACF_RESIDENT.RESIDENT_BODY, outer_home); 
# line 412 "MakeHome.puma"
   DecParNesting (t);
  }
   return t;

  case kACF_TASK_REGION:
# line 417 "MakeHome.puma"
 {
  var_descriptor new_home;
  {
# line 419 "MakeHome.puma"
   IncParNesting (t);
# line 421 "MakeHome.puma"

# line 423 "MakeHome.puma"
   FindNewHomeDescriptor (t, outer_home, & new_home);
# line 425 "MakeHome.puma"
 t->ACF_TASK_REGION.TASK_BODY = PropagateHome (t->ACF_TASK_REGION.TASK_BODY, &new_home); 
# line 427 "MakeHome.puma"
   DecParNesting (t);
  }
  {
   return SetNewHome (t, outer_home, & new_home);
  }
 }

  case kACF_REDUCTION:
# line 432 "MakeHome.puma"
 {
  var_descriptor new_home;
  {
# line 434 "MakeHome.puma"
   IncParNesting (t);
# line 436 "MakeHome.puma"

# line 438 "MakeHome.puma"
   FindNewHomeDescriptor (t, outer_home, & new_home);
# line 440 "MakeHome.puma"
 t->ACF_REDUCTION.REDUCTION_BODY = PropagateHome (t->ACF_REDUCTION.REDUCTION_BODY, &new_home); 
# line 442 "MakeHome.puma"
   DecParNesting (t);
  }
  {
   return SetNewHome (t, outer_home, & new_home);
  }
 }

  case kACF_HOME:
  if (t->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
# line 447 "MakeHome.puma"
 {
  var_descriptor on_home;
  {
# line 449 "MakeHome.puma"

# line 451 "MakeHome.puma"
   IncParNesting (t);
# line 462 "MakeHome.puma"
   SetVarDescriptor (t->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & on_home);
# line 464 "MakeHome.puma"
 t->ACF_HOME.HOME_BODY = PropagateHome (t->ACF_HOME.HOME_BODY, &on_home); 
# line 466 "MakeHome.puma"
   DecParNesting (t);
  }
  {
   return t;
  }
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_ALL_CLAUSE) {
# line 471 "MakeHome.puma"
 {
  var_descriptor on_home;
  {
# line 473 "MakeHome.puma"

# line 475 "MakeHome.puma"
   IncParNesting (t);
# line 477 "MakeHome.puma"
   MakeReplicatedDescriptor (& on_home);
# line 479 "MakeHome.puma"
 t->ACF_HOME.HOME_BODY = PropagateHome (t->ACF_HOME.HOME_BODY, &on_home); 
# line 481 "MakeHome.puma"
   DecParNesting (t);
  }
  {
   return t;
  }
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_PROC_CLAUSE) {
# line 486 "MakeHome.puma"
 {
  var_descriptor on_home;
  {
# line 488 "MakeHome.puma"

# line 490 "MakeHome.puma"
   IncParNesting (t);
# line 492 "MakeHome.puma"
   SetProcDescriptor (t->ACF_HOME.HOME_VAR->ON_PROC_CLAUSE.ON_PROC, & on_home);
# line 494 "MakeHome.puma"
 t->ACF_HOME.HOME_BODY = PropagateHome (t->ACF_HOME.HOME_BODY, &on_home); 
# line 496 "MakeHome.puma"
   DecParNesting (t);
  }
  {
   return t;
  }
 }

  }
  break;
  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
# line 501 "MakeHome.puma"
 {
  var_descriptor new_home;
  {
# line 503 "MakeHome.puma"

# line 505 "MakeHome.puma"
   FindSerialHomeDescriptor (t, outer_home, & new_home);
  }
  {
   return SetNewHome (t, outer_home, & new_home);
  }
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 514 "MakeHome.puma"
 {
  var_descriptor new_home;
  {
# line 516 "MakeHome.puma"

# line 520 "MakeHome.puma"
   FindNewHomeDescriptor (t, outer_home, & new_home);
  }
  {
   return SetNewHome (t, outer_home, & new_home);
  }
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 525 "MakeHome.puma"
 {
  var_descriptor new_home;
  {
# line 527 "MakeHome.puma"
   if (! ((IsSerialCall (t->ACF_BASIC.BASIC_STMT)))) goto yyL14;
  {
# line 529 "MakeHome.puma"

# line 531 "MakeHome.puma"
   FindSerialHomeDescriptor (t, outer_home, & new_home);
  }
  }
  {
   return SetNewHome (t, outer_home, & new_home);
  }
 }
yyL14:;

  }
# line 536 "MakeHome.puma"
 {
  var_descriptor new_home;
  {
# line 538 "MakeHome.puma"
   SetActualData (t);
# line 540 "MakeHome.puma"

# line 542 "MakeHome.puma"
   FindNewHomeDescriptor (t, outer_home, & new_home);
# line 544 "MakeHome.puma"
   CheckCallHome (t, & new_home);
  }
  {
   return SetNewHome (t, outer_home, & new_home);
  }
 }

  case kACF_IF:
# line 555 "MakeHome.puma"
  {
# line 557 "MakeHome.puma"
 t->ACF_IF.THEN_PART = PropagateHome (t->ACF_IF.THEN_PART, outer_home);
     t->ACF_IF.ELSE_PART = PropagateHome (t->ACF_IF.ELSE_PART, outer_home);
   
  }
   return t;

  case kACF_WHILE:
# line 571 "MakeHome.puma"
  {
# line 573 "MakeHome.puma"
 t->ACF_WHILE.WHILE_BODY = PropagateHome (t->ACF_WHILE.WHILE_BODY, outer_home); 
  }
   return t;

  case kACF_DUMMY:
# line 578 "MakeHome.puma"
   return t;

  }

# line 583 "MakeHome.puma"
  {
# line 585 "MakeHome.puma"
   error_protocol ("illegal statement to propagate home");
  }
   return t;

}

static void InfoDoLoopHome
# if defined __STDC__ | defined __cplusplus
(register tTree loop, pvar iter_home)
# else
(loop, iter_home)
 register tTree loop;
 pvar iter_home;
# endif
{
# line 597 "MakeHome.puma"
  {
# line 599 "MakeHome.puma"
   if (! ((! IsParallelHomeDescriptor (iter_home)))) goto yyL1;
  {
# line 601 "MakeHome.puma"
   if (! ((GetCurrentModel () == HPF_GLOBAL))) goto yyL1;
  {
# line 603 "MakeHome.puma"
   set_protocol_stmt (loop);
# line 605 "MakeHome.puma"
   warning_protocol ("no parallel home descriptor for iterations found");
# line 606 "MakeHome.puma"
   tree_protocol ("proposed home is : ", PrintableDescriptorVar (iter_home));
  }
  }
  }
   return;
yyL1:;

;
}

static tTree SetNewHome
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar outer_home, pvar inner_home)
# else
(stmt, outer_home, inner_home)
 register tTree stmt;
 pvar outer_home;
 pvar inner_home;
# endif
{
# line 622 "MakeHome.puma"
  {
# line 632 "MakeHome.puma"
   if (! ((VDIsSame (outer_home, inner_home)))) goto yyL1;
  }
   return stmt;
yyL1:;

# line 637 "MakeHome.puma"
  {
# line 641 "MakeHome.puma"
   if (! ((IsNoDescriptor (inner_home)))) goto yyL2;
  }
   return stmt;
yyL2:;

# line 646 "MakeHome.puma"
 {
  tTree home_stmt;
  {
# line 648 "MakeHome.puma"

# line 650 "MakeHome.puma"
   if (! ((IsReplicatedDescriptor (outer_home)))) goto yyL3;
  {
# line 651 "MakeHome.puma"
   if (! ((IsHostDescriptor (inner_home)))) goto yyL3;
  {
# line 653 "MakeHome.puma"
   home_stmt = mACF_HOME (mON_HOST_CLAUSE (), false, MakeStmtList (stmt));
# line 656 "MakeHome.puma"
   LineACFNode (home_stmt, GetBodyLine (stmt));
  }
  }
  }
  {
   return home_stmt;
  }
 }
yyL3:;

# line 661 "MakeHome.puma"
   return BuildNewVarHome (stmt, inner_home);

}

static tTree BuildNewVarHome
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar home)
# else
(stmt, home)
 register tTree stmt;
 pvar home;
# endif
{
  if (stmt->Kind == kACF_LIST) {
  if (stmt->ACF_LIST.Elem->Kind == kACF_HOME) {
  if (stmt->ACF_LIST.Elem->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
  if (stmt->ACF_LIST.Next->Kind == kACF_EMPTY) {
# line 676 "MakeHome.puma"
  {
# line 678 "MakeHome.puma"
 stmt->ACF_LIST.Elem->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR = MakeDescriptorVar (home); 
  }
   return stmt;

  }
  }
  }
  }
  if (stmt->Kind == kACF_HOME) {
  if (stmt->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
# line 683 "MakeHome.puma"
  {
# line 685 "MakeHome.puma"
 stmt->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR = MakeDescriptorVar (home); 
  }
   return stmt;

  }
  }
# line 690 "MakeHome.puma"
 {
  tTree home_stmt;
  {
# line 692 "MakeHome.puma"

# line 694 "MakeHome.puma"
   home_stmt = mACF_HOME (mON_VAR_CLAUSE (MakeDescriptorVar (home)), false, MakeStmtList (stmt));
# line 698 "MakeHome.puma"
   LineACFNode (home_stmt, GetBodyLine (stmt));
  }
  {
   return home_stmt;
  }
 }

}

static int GetBodyLine
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
# line 705 "MakeHome.puma"
  {
# line 706 "MakeHome.puma"
   if (! ((stmt == NoTree))) goto yyL1;
  }
   return 0;
yyL1:;

  if (stmt->Kind == kACF_LIST) {
# line 710 "MakeHome.puma"
   return GetBodyLine (stmt->ACF_LIST.Elem);

  }
  if (Tree_IsType (stmt, kACF_NODE)) {
# line 715 "MakeHome.puma"
   return stmt->ACF_NODE.Line;

  }
  if (stmt->Kind == kACF_EMPTY) {
# line 720 "MakeHome.puma"
   return 0;

  }
# line 724 "MakeHome.puma"
  {
# line 725 "MakeHome.puma"
   failure_protocol (MODULE, "GetBodyLine", stmt);
  }
   return 0;

}

static void MakeHomeTemplate
# if defined __STDC__ | defined __cplusplus
(pvar home, pvar home1, register tTree * yyP2, register tTree * yyP1)
# else
(home, home1, yyP2, yyP1)
 pvar home;
 pvar home1;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
# line 745 "MakeHome.puma"
 {
  tTree tmp_var;
  tTree allocate;
  tTree deallocate;
  {
# line 747 "MakeHome.puma"
   if (! ((IsReplicatedDescriptor (home)))) goto yyL1;
  {
# line 748 "MakeHome.puma"
   if (! ((! IsReplicatedDescriptor (home1)))) goto yyL1;
  {
# line 749 "MakeHome.puma"
   if (! ((! IsNoDescriptor (home1)))) goto yyL1;
  {
# line 750 "MakeHome.puma"
   if (! ((IsTemplateDescriptor (home1)))) goto yyL1;
  {
# line 752 "MakeHome.puma"
   if (! ((home1 -> var_tree == NoTree))) goto yyL1;
  {
# line 756 "MakeHome.puma"

# line 757 "MakeHome.puma"

# line 758 "MakeHome.puma"

# line 760 "MakeHome.puma"
 

     home1->type_kind = kDUMMY_TYPE;

     FullExpansion (home1);   

     tmp_var = GetVDTemporary (home1);

     

     SetVarDescriptor (tmp_var, home1);

     GetMemoryStmts (&allocate, &deallocate);

     tree_protocol ("template home generated, tmp_var = ", tmp_var);

   
  }
  }
  }
  }
  }
  }
   * yyP2 = allocate;
   * yyP1 = deallocate;
   return;
 }
yyL1:;

# line 779 "MakeHome.puma"
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static void SetIterationsHome
# if defined __STDC__ | defined __cplusplus
(register tTree loop, pvar iter_home)
# else
(loop, iter_home)
 register tTree loop;
 pvar iter_home;
# endif
{
  if (loop->Kind == kACF_DO) {
# line 797 "MakeHome.puma"
  {
# line 799 "MakeHome.puma"
   if (! ((loop->ACF_DO.DO_HOME_INFO == NoTree))) goto yyL1;
  {
# line 801 "MakeHome.puma"
   failure_protocol (MODULE, "SetIterationsHome", NoTree);
  }
  }
   return;
yyL1:;

  if (loop->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
# line 804 "MakeHome.puma"
  {
# line 806 "MakeHome.puma"
 loop->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var = MakeDescriptorVar (iter_home); 
  }
   return;

  }
  if (loop->ACF_DO.DO_HOME_INFO->Kind == kNO_HOME_INFO) {
# line 809 "MakeHome.puma"
 {
  tTree hvar;
  {
# line 811 "MakeHome.puma"

# line 813 "MakeHome.puma"
 hvar = MakeDescriptorVar (iter_home); 
    loop->ACF_DO.DO_HOME_INFO = mCOMM_INFO (hvar, false);         
  
  }
   return;
 }

  }
  }
# line 818 "MakeHome.puma"
  {
# line 820 "MakeHome.puma"
   failure_protocol (MODULE, "SetIterationsHome", loop);
  }
   return;

;
}

static void SetSelection
# if defined __STDC__ | defined __cplusplus
(register tTree loop, pvar iter_home)
# else
(loop, iter_home)
 register tTree loop;
 pvar iter_home;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 831 "MakeHome.puma"
 {
  int dim;
  {
# line 833 "MakeHome.puma"

# line 835 "MakeHome.puma"
   dim = FindDescriptorDim (iter_home, loop->ACF_DO.DO_ID);
# line 837 "MakeHome.puma"
 if (dim > 0)
        loop->ACF_DO.DO_DEP_INFO->INDEP_INFO.selection = iter_home->selections[dim-1];
   
  }
   return;
 }

  }
  }
;
}

static void FindNewHomeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar cur_home, pvar new_home)
# else
(stmt, cur_home, new_home)
 register tTree stmt;
 pvar cur_home;
 pvar new_home;
# endif
{
# line 873 "MakeHome.puma"
 {
  var_descriptor min_home;
  {
# line 875 "MakeHome.puma"

# line 877 "MakeHome.puma"
   FindHome (stmt, & min_home, new_home);
# line 879 "MakeHome.puma"
 if (!VDIsSubSet (&min_home, cur_home))

       { tree_protocol ("illegal home constellation :\n", stmt);
         tree_protocol  ("outer home is : ",
                          PrintableDescriptorVar (cur_home));
         tree_protocol  ("minimal home is : ",
                          PrintableDescriptorVar (&min_home));

         *new_home = *cur_home;
       }

     else

      {
#ifdef DEBUG
        printf ("Determine the final home\n");
        FileUnparse (stdout, stmt);
        printf ("outer home : ");
        FileUnparse (stdout, PrintableDescriptorVar (cur_home));
        printf ("\n");
        printf ("inner home : ");
        FileUnparse (stdout, PrintableDescriptorVar (new_home));
        printf ("\n");
        printf ("min   home : ");
        FileUnparse (stdout, PrintableDescriptorVar (&min_home));
        printf ("\n");
#endif 
        DetermineFinalHome (cur_home, &min_home, new_home);
#ifdef DEBUG
        printf ("final home : ");
        FileUnparse (stdout, PrintableDescriptorVar (new_home));
        printf ("\n");
#endif
        if (!VDIsSubSet (new_home, cur_home))

          { tree_error_protocol ("illegal home constellation :\n", stmt);
            tree_protocol  ("outer home is : ",
                             PrintableDescriptorVar (cur_home));
            tree_protocol  ("new home should be : ",
                             PrintableDescriptorVar (new_home));

            *new_home = *cur_home;
          }

      }
   
  }
   return;
 }

;
}

static void FindSerialHomeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar cur_home, pvar new_home)
# else
(stmt, cur_home, new_home)
 register tTree stmt;
 pvar cur_home;
 pvar new_home;
# endif
{
# line 941 "MakeHome.puma"
  {
# line 945 "MakeHome.puma"
   if (! ((GetCurrentModel () != HPF_GLOBAL))) goto yyL1;
  {
# line 947 "MakeHome.puma"
 *new_home = *cur_home; 
  }
  }
   return;
yyL1:;

# line 950 "MakeHome.puma"
 {
  bool done;
  {
# line 954 "MakeHome.puma"

# line 958 "MakeHome.puma"
   FindNewHomeDescriptor (stmt, cur_home, new_home);
# line 959 "MakeHome.puma"
   MakeSerialDescriptor (new_home, & done);
# line 961 "MakeHome.puma"
   if (! ((done))) goto yyL2;
  }
   return;
 }
yyL2:;

# line 964 "MakeHome.puma"
  {
# line 966 "MakeHome.puma"
   set_protocol_stmt (stmt);
# line 967 "MakeHome.puma"
   error_protocol ("illegal home for SERIAL or IO routine");
# line 968 "MakeHome.puma"
   tree_protocol ("home for stmt is: ", PrintableDescriptorVar (cur_home));
# line 969 "MakeHome.puma"
 *new_home = *cur_home; 
  }
   return;

;
}

static void DetermineFinalHome
# if defined __STDC__ | defined __cplusplus
(pvar cur_home, pvar min_home, pvar new_home)
# else
(cur_home, min_home, new_home)
 pvar cur_home;
 pvar min_home;
 pvar new_home;
# endif
{
# line 998 "MakeHome.puma"
  {
# line 1000 "MakeHome.puma"
   if (! ((! VDIsSubSet (min_home, new_home)))) goto yyL1;
  {
# line 1001 "MakeHome.puma"
 *new_home = *min_home; 
  }
  }
   return;
yyL1:;

# line 1004 "MakeHome.puma"
  {
# line 1006 "MakeHome.puma"
   if (! ((IsNoDescriptor (new_home)))) goto yyL2;
  {
# line 1007 "MakeHome.puma"
 *new_home = *cur_home; 
  }
  }
   return;
yyL2:;

# line 1010 "MakeHome.puma"
  {
# line 1015 "MakeHome.puma"
   if (! ((IsFullLoopDescriptor (new_home)))) goto yyL3;
  {
# line 1016 "MakeHome.puma"
 *new_home = *cur_home; 
  }
  }
   return;
yyL3:;

# line 1019 "MakeHome.puma"
  {
# line 1021 "MakeHome.puma"
   if (! ((VDIsSubSet (new_home, cur_home)))) goto yyL4;
  {
# line 1022 "MakeHome.puma"
   InheritTemplate (cur_home, new_home);
  }
  }
   return;
yyL4:;

# line 1025 "MakeHome.puma"
  {
# line 1027 "MakeHome.puma"
   if (! ((IsNoDescriptor (min_home)))) goto yyL5;
  {
# line 1028 "MakeHome.puma"
   IntersectDescriptor (new_home, cur_home);
# line 1032 "MakeHome.puma"
   if (! ((! IsNoDescriptor (new_home)))) goto yyL5;
  }
  }
   return;
yyL5:;

# line 1035 "MakeHome.puma"
  {
# line 1037 "MakeHome.puma"
 *new_home = *cur_home; 
  }
   return;

;
}

static void InheritTemplate
# if defined __STDC__ | defined __cplusplus
(pvar home, pvar sub_home)
# else
(home, sub_home)
 pvar home;
 pvar sub_home;
# endif
{
# line 1051 "MakeHome.puma"
  {
# line 1053 "MakeHome.puma"
 if (sub_home->template_obj == NoObject)

      { sub_home->template_obj = home->template_obj;
        sub_home->reach_info   = home->reach_info;
      }
   
  }
   return;

;
}

static void CheckCallHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar final_home)
# else
(t, final_home)
 register tTree t;
 pvar final_home;
# endif
{
  if (t->Kind == kACF_BASIC) {
# line 1073 "MakeHome.puma"
  {
# line 1075 "MakeHome.puma"
   CheckCallHome (t->ACF_BASIC.BASIC_STMT, final_home);
  }
   return;

  }
  if (t->Kind == kCALL_STMT) {
# line 1078 "MakeHome.puma"
  {
# line 1080 "MakeHome.puma"
   if (! ((! IsPureCall (t)))) goto yyL2;
  {
# line 1081 "MakeHome.puma"
   if (! ((! IsSerialCall (t)))) goto yyL2;
  {
# line 1082 "MakeHome.puma"
   if (! ((! IsReplicatedDescriptor (final_home)))) goto yyL2;
  {
# line 1084 "MakeHome.puma"
   serious_warning_protocol ("PURE/RESIDENT assumed for subroutine CALL");
  }
  }
  }
  }
   return;
yyL2:;

  }
;
}

void BeginMakeHome ()
{
}

void CloseMakeHome ()
{
}
