# include "MakeForall.h"
# include "yyMakeForall.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 31 "MakeForall.puma"

# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# define  MODULE "MakeForall"

# include "Types.h"
# include "Transform.h"    /* CombineACF, ... */

# include "Nesting.h"       
# include "Traverse.h"       

# include "AdaptF77.h"
# include "Intrinsics.h"
# include "Rank.h"
# include "Objects.h"



static void yyExit () { Exit (1); }

void (* MakeForall_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeForall, routine %s failed\n", yyFunction);
 MakeForall_Exit ();
}

void MakeForall ARGS((tTree t));
static bool StopMakeForall ARGS((tTree t));
static tTree DoMakeForall ARGS((tTree t));
static tTree MakeAssignForall ARGS((tTree assign, int rankvar, int rankexp));
static bool IsBasicFunctionCall ARGS((tTree exp));
static bool IsEnumExp ARGS((tTree exp));

void MakeForall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 61 "MakeForall.puma"
  {
# line 63 "MakeForall.puma"
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeForall, DoMakeForall); 
  }
   return;

  }
# line 66 "MakeForall.puma"
  {
# line 67 "MakeForall.puma"
   failure_protocol (MODULE, "MakeForall", t);
  }
   return;

;
}

static bool StopMakeForall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_WHERE) {
# line 82 "MakeForall.puma"
   return true;

  }
# line 87 "MakeForall.puma"
  {
# line 88 "MakeForall.puma"
   return false;
  }

}

static tTree DoMakeForall
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 103 "MakeForall.puma"
   return MakeAssignForall (t, TreeRank (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR), TreeRank (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP));

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
# line 108 "MakeForall.puma"
  {
# line 110 "MakeForall.puma"
   F77IO (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS);
  }
   return t;

  }
  }
  if (t->Kind == kACF_WHERE) {
# line 114 "MakeForall.puma"
 {
  tTree newacf;
  {
# line 116 "MakeForall.puma"

# line 118 "MakeForall.puma"
 stmt_protocol ("Make F77 from where statement");
     newacf = F77Where (t);
     tree_protocol ("new loop :\n", newacf);
   
  }
  {
   return newacf;
  }
 }

  }
# line 125 "MakeForall.puma"
   return t;

}

static tTree MakeAssignForall
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register int rankvar, register int rankexp)
# else
(assign, rankvar, rankexp)
 register tTree assign;
 register int rankvar;
 register int rankexp;
# endif
{
# line 137 "MakeForall.puma"

tTree new;

  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 147 "MakeForall.puma"
  {
# line 150 "MakeForall.puma"
   if (! ((IsIntrCall (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  {
# line 151 "MakeForall.puma"
   if (! ((assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("MERGE", 5)))) goto yyL1;
  }
  }
   return F77Merge (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS);
yyL1:;

  }
# line 163 "MakeForall.puma"
  {
# line 165 "MakeForall.puma"
   if (! ((IsReduction (assign)))) goto yyL2;
  {
# line 167 "MakeForall.puma"
 stmt_protocol ("Make F77 from reduction");
     new = F77Reduction (assign->ACF_BASIC.Line, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
     tree_protocol ("new reduction loop :\n", new);
   
  }
  }
   return new;
yyL2:;

# line 181 "MakeForall.puma"
  {
# line 183 "MakeForall.puma"
   if (! ((IsLocReduction (assign)))) goto yyL3;
  {
# line 185 "MakeForall.puma"
 stmt_protocol ("Make F77 from loc reduction");
     new = F77LocReduction (assign->ACF_BASIC.Line, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
     tree_protocol ("new loc reduction loop :\n", new);
   
  }
  }
   return new;
yyL3:;

  if (equalint (rankvar, 0)) {
  if (equalint (rankexp, 0)) {
# line 199 "MakeForall.puma"
   return assign;

  }
  }
  if (equalint (rankexp, 0)) {
# line 210 "MakeForall.puma"
  {
# line 212 "MakeForall.puma"
 stmt_protocol ("Make F77 from array = scalar");
      new = F77Assign (assign);
      tree_protocol ("new loops :\n", new);
   
  }
   return new;

  }
  if (equalint (rankvar, 1)) {
  if (equalint (rankexp, 1)) {
# line 226 "MakeForall.puma"
  {
# line 228 "MakeForall.puma"
   if (! ((IsEnumExp (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL6;
  {
# line 230 "MakeForall.puma"
 stmt_protocol ("Make F77 from array = [...]");
     new = F77ManyAssign (assign); 
     tree_protocol ("new assignments :\n", new);
   
  }
  }
   return new;
yyL6:;

  }
  }
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 246 "MakeForall.puma"
  {
# line 248 "MakeForall.puma"
   if (! ((! IsBasicFunctionCall (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL7;
  }
   return assign;
yyL7:;

  }
# line 259 "MakeForall.puma"
  {
# line 261 "MakeForall.puma"
   if (! ((rankvar == rankexp))) goto yyL8;
  {
# line 263 "MakeForall.puma"
 stmt_protocol ("Make F77 from array = array_exp");
     new = F77Assign (assign);
     tree_protocol ("new loops :\n", new);
   
  }
  }
   return new;
yyL8:;

  }
  }
# line 270 "MakeForall.puma"
  {
# line 272 "MakeForall.puma"
   if (! ((rankvar != rankexp))) goto yyL9;
  {
# line 274 "MakeForall.puma"
   error_protocol ("MakeAssignForall: illegal statement (rank!)");
  }
  }
   return assign;
yyL9:;

 yyAbort ("MakeAssignForall");
}

static bool IsBasicFunctionCall
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
# line 288 "MakeForall.puma"
  {
# line 290 "MakeForall.puma"
   if (! ((IsIntrCall (exp)))) goto yyL1;
  {
# line 291 "MakeForall.puma"
   if (! ((IntrFuncElemental (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 294 "MakeForall.puma"
  {
# line 296 "MakeForall.puma"
   if (! ((IsIntrCall (exp)))) goto yyL2;
  {
# line 297 "MakeForall.puma"
   if (! ((MakeIdent ("SPREAD", 6) == exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 300 "MakeForall.puma"
  {
# line 302 "MakeForall.puma"
   if (! ((IsIntrCall (exp)))) goto yyL3;
  {
# line 303 "MakeForall.puma"
   if (! ((MakeIdent ("TRANSPOSE", 9) == exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))) goto yyL3;
  }
  }
   return true;
yyL3:;

  }
  return false;
}

static bool IsEnumExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kARRAY_EXP) {
# line 314 "MakeForall.puma"
  {
# line 315 "MakeForall.puma"
   if (! ((IsEnumExp (exp->ARRAY_EXP.ELEMENTS)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (exp->Kind == kBTE_LIST) {
# line 318 "MakeForall.puma"
  {
# line 319 "MakeForall.puma"
   if (! ((TreeRank (exp->BTE_LIST.Elem) == 0))) goto yyL2;
  {
# line 320 "MakeForall.puma"
   if (! ((IsEnumExp (exp->BTE_LIST.Next)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  if (exp->Kind == kBTE_EMPTY) {
# line 323 "MakeForall.puma"
   return true;

  }
  return false;
}

void BeginMakeForall ()
{
}

void CloseMakeForall ()
{
}
