# include "MakeDefs.h"
# include "yyMakeDefs.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 43 "MakeDefs.puma"


# include <string.h>

# include "Idents.h"
# include "StringMem.h"
# include "TreeOps.h"

# include "protocol.h"

# include "DefTable.h"       /* Operations for definition table      */
# include "Transform.h"      /*  */

# include "ImplDefs.h"       /* implicit definitions / global atts   */

# include "NormalDefs.h"     /* Normal1Definitions, Normal2Definitions   */

# include "UnitDefs.h"

# include "ChangeDefs.h"     /* MakeObjType, ..., MakeObjSave, MakeObjExternal,
                                StatementFunctions                   */

# include "SetDefs.h"        /* MakeVarDefs, MakeACFDefs, CheckExp, 
                                MakeIndexDefs                        */

# include "MapDefs.h"        /* SetDistributions, SetAlignments    */

# include "Nesting.h" 

# include "Types.h"          /* GetBaseType   */

# include "Objects.h"        /* MakeNewObject */

# include "Modules.h"        /* GetModule     */

# define MODULE "MakeDefs"

    /*****************************************************
    *                                                    *
    *    Global Variables in Making Definitions          *
    *                                                    *
    *    ProgramCounter : counts PROGRAM_DECL            *
    *                                                    *
    *****************************************************/

int ProgramCounter;     /* counter for MAIN programs */

static bool is_type_scope = false;



static void yyExit () { Exit (1); }

void (* MakeDefs_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeDefs, routine %s failed\n", yyFunction);
 MakeDefs_Exit ();
}

void MakeDefs ARGS((tTree t));
void MakeUnitDefs ARGS((tTree t));
static void MakeModuleDefs ARGS((tTree t, tDefinitions obj));
static void MakeInternalDefs ARGS((tTree internals));
static void MakeDefFunction ARGS((tTree f));
static void MoveResultType ARGS((tTree f));
static void MakeResultDef ARGS((tTree f, tDefinitions f_obj));
static void SetFuncResultType ARGS((tTree f));
static tTree GetDummyType ARGS((tDefinitions obj, tTree default_type));
static tIdent MakeResultId ARGS((tIdent id));
static bool IsThisFunction ARGS((tDefinitions obj, tIdent * yyP1));
static void MakeDummyDefinitions ARGS((tTree t, tDefinitions unit));
static void MakeDECLDefs ARGS((tTree t, tDefinitions unit));
static void MakeTYPEDefs ARGS((tTree t));
static void InsertUseEntry ARGS((tDefinitions obj));
static void MakeTypeScope ARGS((tDefinitions tobj, tTree decl));
static void MakeCommons ARGS((tTree t, tTree CommonDecl));
static void MakeInterfaceDefs ARGS((tTree t));
static void EmptyBody ARGS((tTree b));
static tDefinitions ReverseEntryList ARGS((tDefinitions list, tDefinitions newlist));
static void SetExtrinsicId ARGS((tTree unit));
static tIdent GetCurrentExtrinsic ARGS(());

void MakeDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMP_UNIT) {
# line 108 "MakeDefs.puma"
  {
# line 110 "MakeDefs.puma"
   BeginDefTable ();
# line 111 "MakeDefs.puma"
   ProgramCounter = 0;
# line 112 "MakeDefs.puma"
   open_protocol ("adaptor.def");
# line 113 "MakeDefs.puma"
   InitImplicitTable ();
# line 114 "MakeDefs.puma"
   DeclareUnits (t->COMP_UNIT.COMP_ELEMENTS, NoObject);
# line 115 "MakeDefs.puma"
   MakeDefs (t->COMP_UNIT.COMP_ELEMENTS);
# line 116 "MakeDefs.puma"
   CloseDefTable ();
# line 117 "MakeDefs.puma"
   close_protocol ();
  }
   return;

  }
  if (t->Kind == kUNIT_EMPTY) {
# line 120 "MakeDefs.puma"
   return;

  }
  if (t->Kind == kUNIT_LIST) {
# line 123 "MakeDefs.puma"
  {
# line 124 "MakeDefs.puma"
   MakeUnitDefs (t->UNIT_LIST.Elem);
# line 125 "MakeDefs.puma"
   MakeDefs (t->UNIT_LIST.Next);
  }
   return;

  }
# line 128 "MakeDefs.puma"
  {
# line 129 "MakeDefs.puma"
   failure_protocol (MODULE, "MakeDefs", t);
  }
   return;

;
}

void MakeUnitDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (Tree_IsType (t, kUNIT_NODE)) {
# line 142 "MakeDefs.puma"
  {
# line 144 "MakeDefs.puma"
   if (! ((t->UNIT_NODE.Object == NoObject))) goto yyL1;
  {
# line 146 "MakeDefs.puma"
   error_protocol ("cannot make definitions in this unit");
  }
  }
   return;
yyL1:;

  }
  if (t->Kind == kPROGRAM_DECL) {
# line 149 "MakeDefs.puma"
  {
# line 151 "MakeDefs.puma"
   NestOpenUnit (t);
# line 152 "MakeDefs.puma"
   MakeDummyDefinitions (t->PROGRAM_DECL.FORMALS, GetCurrentUnitObject ());
# line 153 "MakeDefs.puma"
   MakeUnitDefs (t->PROGRAM_DECL.PROGRAM_BODY);
# line 154 "MakeDefs.puma"
   NestCloseUnit (t);
  }
   return;

  }
  if (t->Kind == kPROC_DECL) {
# line 157 "MakeDefs.puma"
  {
# line 159 "MakeDefs.puma"
   NestOpenUnit (t);
# line 160 "MakeDefs.puma"
   SetExtrinsicId (t);
# line 161 "MakeDefs.puma"
   MakeDummyDefinitions (t->PROC_DECL.FORMALS, GetCurrentUnitObject ());
# line 162 "MakeDefs.puma"
   MakeUnitDefs (t->PROC_DECL.PROC_BODY);
# line 163 "MakeDefs.puma"
   NestCloseUnit (t);
  }
   return;

  }
  if (t->Kind == kFUNC_DECL) {
# line 166 "MakeDefs.puma"
  {
# line 168 "MakeDefs.puma"
   MakeDefFunction (t);
  }
   return;

  }
  if (t->Kind == kBLOCK_DATA_DECL) {
# line 171 "MakeDefs.puma"
  {
# line 173 "MakeDefs.puma"
   NestOpenUnit (t);
# line 174 "MakeDefs.puma"
   MakeUnitDefs (t->BLOCK_DATA_DECL.DATA_BODY);
# line 175 "MakeDefs.puma"
   NestCloseUnit (t);
  }
   return;

  }
  if (t->Kind == kMODULE_DECL) {
# line 178 "MakeDefs.puma"
  {
# line 180 "MakeDefs.puma"
   NestOpenUnit (t);
# line 182 "MakeDefs.puma"
   MakeModuleDefs (t, GetCurrentUnitObject ());
# line 184 "MakeDefs.puma"
   NestCloseUnit (t);
  }
   return;

  }
  if (t->Kind == kBODY_NODE) {
# line 187 "MakeDefs.puma"
  {
# line 189 "MakeDefs.puma"
   DeclareUnits (t->BODY_NODE.INTERNALS, GetCurrentUnitObject ());
# line 191 "MakeDefs.puma"
   PushImplicitTable ();
# line 193 "MakeDefs.puma"
 t->BODY_NODE.DECLS = Normal1Definitions (t->BODY_NODE.DECLS); 
# line 194 "MakeDefs.puma"
   MakeDECLDefs (t->BODY_NODE.DECLS, GetCurrentUnitObject ());
# line 195 "MakeDefs.puma"
 t->BODY_NODE.DECLS = Normal2Definitions (t->BODY_NODE.DECLS); 
# line 196 "MakeDefs.puma"
   SetDistributions (t->BODY_NODE.DECLS, GetCurrentUnitObject ());
# line 197 "MakeDefs.puma"
   SetAlignments (t->BODY_NODE.DECLS, GetCurrentUnitObject ());
# line 198 "MakeDefs.puma"
   StatementFunctions (t);
# line 200 "MakeDefs.puma"
   MakeACFDefs (t->BODY_NODE.STATS);
# line 201 "MakeDefs.puma"
   MakeInternalDefs (t->BODY_NODE.INTERNALS);
# line 205 "MakeDefs.puma"
   CheckImplicitDecls (GetCurrentScope ());
# line 207 "MakeDefs.puma"
   PopImplicitTable ();
  }
   return;

  }
# line 210 "MakeDefs.puma"
  {
# line 211 "MakeDefs.puma"
   failure_protocol (MODULE, "MakeUnitDefs", t);
  }
   return;

;
}

static void MakeModuleDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions obj)
# else
(t, obj)
 register tTree t;
 register tDefinitions obj;
# endif
{
  if (t->Kind == kMODULE_DECL) {
  if (obj->Kind == kModuleObject) {
# line 224 "MakeDefs.puma"
  {
# line 226 "MakeDefs.puma"
   if (! ((obj->ModuleObject.uses == 0))) goto yyL1;
  {
# line 228 "MakeDefs.puma"
   obj->ModuleObject.uses = 1;
# line 230 "MakeDefs.puma"
   MakeUnitDefs (t->MODULE_DECL.MODULE_BODY);
# line 232 "MakeDefs.puma"
   obj->ModuleObject.uses = 2;
  }
  }
   return;
yyL1:;

# line 235 "MakeDefs.puma"
  {
# line 237 "MakeDefs.puma"
   if (! ((obj->ModuleObject.uses == 2))) goto yyL2;
  }
   return;
yyL2:;

# line 240 "MakeDefs.puma"
  {
# line 242 "MakeDefs.puma"
   if (! ((obj->ModuleObject.uses == 1))) goto yyL3;
  {
# line 244 "MakeDefs.puma"
   error_protocol ("module is used (in)directly by itself");
  }
  }
   return;
yyL3:;

  }
  }
;
}

static void MakeInternalDefs
# if defined __STDC__ | defined __cplusplus
(register tTree internals)
# else
(internals)
 register tTree internals;
# endif
{
  if (internals->Kind == kUNIT_LIST) {
# line 255 "MakeDefs.puma"
  {
# line 257 "MakeDefs.puma"
   set_protocol_stmt (internals->UNIT_LIST.Elem);
# line 258 "MakeDefs.puma"
   MakeInternalDefs (internals->UNIT_LIST.Elem);
# line 259 "MakeDefs.puma"
   MakeInternalDefs (internals->UNIT_LIST.Next);
  }
   return;

  }
  if (internals->Kind == kUNIT_EMPTY) {
# line 262 "MakeDefs.puma"
   return;

  }
  if (internals->Kind == kPROC_DECL) {
# line 265 "MakeDefs.puma"
  {
# line 266 "MakeDefs.puma"
   MakeUnitDefs (internals);
  }
   return;

  }
  if (internals->Kind == kFUNC_DECL) {
# line 269 "MakeDefs.puma"
  {
# line 270 "MakeDefs.puma"
   MakeUnitDefs (internals);
  }
   return;

  }
# line 273 "MakeDefs.puma"
  {
# line 274 "MakeDefs.puma"
   error_protocol ("no subroutine/function in CONTAINS");
  }
   return;

;
}

static void MakeDefFunction
# if defined __STDC__ | defined __cplusplus
(register tTree f)
# else
(f)
 register tTree f;
# endif
{
  if (f->Kind == kFUNC_DECL) {
# line 293 "MakeDefs.puma"
 {
  tDefinitions f_obj;
  {
# line 295 "MakeDefs.puma"
   NestOpenUnit (f);
# line 297 "MakeDefs.puma"
   SetExtrinsicId (f);
# line 299 "MakeDefs.puma"

# line 300 "MakeDefs.puma"
   f_obj = GetCurrentUnitObject ();
# line 304 "MakeDefs.puma"
   InsertEntry (f_obj);
# line 308 "MakeDefs.puma"
   MoveResultType (f);
# line 312 "MakeDefs.puma"
   MakeDummyDefinitions (f->FUNC_DECL.FORMALS, f_obj);
# line 316 "MakeDefs.puma"
   MakeResultDef (f, f_obj);
# line 318 "MakeDefs.puma"
   f_obj->FuncObject.Declarations = GetCurrentScope ();
# line 320 "MakeDefs.puma"
   MakeUnitDefs (f->FUNC_DECL.FUNC_BODY);
# line 326 "MakeDefs.puma"
   NestCloseUnit (f);
  }
   return;
 }

  }
;
}

static void MoveResultType
# if defined __STDC__ | defined __cplusplus
(register tTree f)
# else
(f)
 register tTree f;
# endif
{
  if (f->Kind == kFUNC_DECL) {
  if (f->FUNC_DECL.RESULT_TYPE->Kind == kDUMMY_TYPE) {
# line 342 "MakeDefs.puma"
   return;

  }
# line 345 "MakeDefs.puma"
 {
  tTree new;
  {
# line 348 "MakeDefs.puma"

# line 350 "MakeDefs.puma"
 new = mVAR_DECL (f->FUNC_DECL.Ident, f->FUNC_DECL.Line, f->FUNC_DECL.RESULT_TYPE);
     new = mDECL_LIST (new, mDECL_EMPTY ());
     f->FUNC_DECL.FUNC_BODY->BODY_NODE.DECLS = AppendDECLS (f->FUNC_DECL.FUNC_BODY->BODY_NODE.DECLS, new);
     f->FUNC_DECL.RESULT_TYPE = mDUMMY_TYPE ();
   
  }
   return;
 }

  }
# line 357 "MakeDefs.puma"
  {
# line 359 "MakeDefs.puma"
   failure_protocol (MODULE, "MoveResultType", f);
  }
   return;

;
}

static void MakeResultDef
# if defined __STDC__ | defined __cplusplus
(register tTree f, register tDefinitions f_obj)
# else
(f, f_obj)
 register tTree f;
 register tDefinitions f_obj;
# endif
{
  if (f->Kind == kFUNC_DECL) {
# line 375 "MakeDefs.puma"
  {
# line 377 "MakeDefs.puma"
   if (! ((f->FUNC_DECL.RESULT_ID == DefaultId ()))) goto yyL1;
  {
# line 381 "MakeDefs.puma"
   f->FUNC_DECL.RESULT_ID = MakeResultId (f->FUNC_DECL.Ident);
# line 382 "MakeDefs.puma"
   MakeResultDef (f, f_obj);
  }
  }
   return;
yyL1:;

# line 385 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 387 "MakeDefs.puma"

# line 389 "MakeDefs.puma"
   Obj = GetLocalObject (f->FUNC_DECL.RESULT_ID);
# line 391 "MakeDefs.puma"
 if (Obj == NoObject)

       { Obj = MakeResultObject (f, f_obj);
         InsertEntry (Obj);
       }

      else

        tree_error_protocol ("result id already used: ", f);
   
  }
   return;
 }

  }
# line 403 "MakeDefs.puma"
  {
# line 405 "MakeDefs.puma"
   failure_protocol (MODULE, "MakeResultDef", f);
  }
   return;

;
}

static void SetFuncResultType
# if defined __STDC__ | defined __cplusplus
(register tTree f)
# else
(f)
 register tTree f;
# endif
{
  if (f->Kind == kFUNC_DECL) {
# line 419 "MakeDefs.puma"
  {
# line 421 "MakeDefs.puma"
 f->FUNC_DECL.RESULT_TYPE = GetDummyType (GetLocalObject (f->FUNC_DECL.RESULT_ID), f->FUNC_DECL.RESULT_TYPE); 
  }
   return;

  }
# line 424 "MakeDefs.puma"
  {
# line 425 "MakeDefs.puma"
   failure_protocol (MODULE, "SetFuncResultType", f);
  }
   return;

;
}

static tTree GetDummyType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree default_type)
# else
(obj, default_type)
 register tDefinitions obj;
 register tTree default_type;
# endif
{
# line 436 "MakeDefs.puma"
  {
# line 438 "MakeDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  }
   return default_type;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 442 "MakeDefs.puma"
   return GetBaseType (obj->VarObject.decl->VAR_PARAM_DECL.VAL);

  }
  }
 yyAbort ("GetDummyType");
}

static tIdent MakeResultId
# if defined __STDC__ | defined __cplusplus
(register tIdent id)
# else
(id)
 register tIdent id;
# endif
{
# line 449 "MakeDefs.puma"

char name [100];

# line 453 "MakeDefs.puma"
  {
# line 455 "MakeDefs.puma"
   GetString (id, name);
# line 456 "MakeDefs.puma"
   strcat (name, "_RESULT");
  }
   return MakeIdent (name, strlen (name));

}

static bool IsThisFunction
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tIdent * yyP1)
# else
(obj, yyP1)
 register tDefinitions obj;
 register tIdent * yyP1;
# endif
{
# line 470 "MakeDefs.puma"
  {
# line 471 "MakeDefs.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 472 "MakeDefs.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
# line 475 "MakeDefs.puma"
  {
# line 478 "MakeDefs.puma"
   if (! ((obj->FuncObject.decl->FUNC_DECL.RESULT_ID != DefaultId ()))) goto yyL2;
  {
# line 479 "MakeDefs.puma"
   if (! ((GetLocalObject (obj->FuncObject.decl->FUNC_DECL.RESULT_ID) == GetDeclEntry (obj->FuncObject.decl->FUNC_DECL.RESULT_ID, obj->FuncObject.Declarations)))) goto yyL2;
  }
  }
   * yyP1 = obj->FuncObject.decl->FUNC_DECL.RESULT_ID;
   return true;
yyL2:;

  }
  }
  return false;
}

static void MakeDummyDefinitions
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions unit)
# else
(t, unit)
 register tTree t;
 register tDefinitions unit;
# endif
{
  if (t->Kind == kDECL_LIST) {
# line 492 "MakeDefs.puma"
  {
# line 494 "MakeDefs.puma"
   set_protocol_stmt (t->DECL_LIST.Elem);
# line 495 "MakeDefs.puma"
   MakeDummyDefinitions (t->DECL_LIST.Elem, unit);
# line 496 "MakeDefs.puma"
   MakeDummyDefinitions (t->DECL_LIST.Next, unit);
  }
   return;

  }
  if (t->Kind == kVAR_PARAM_DECL) {
# line 499 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 501 "MakeDefs.puma"
   MakeTYPEDefs (t->VAR_PARAM_DECL.VAL);
# line 503 "MakeDefs.puma"

# line 504 "MakeDefs.puma"
   Obj = GetLocalObject (t->VAR_PARAM_DECL.Ident);
# line 506 "MakeDefs.puma"
 if (Obj == NoObject)

       { Obj = MakeNewObject (t, unit);
         InsertEntry (Obj); 
       }

      else 

        error_protocol ("dummy argument declared twice: ");
   
  }
   return;
 }

  }
  if (t->Kind == kRET_PARAM_DECL) {
# line 518 "MakeDefs.puma"
  {
# line 520 "MakeDefs.puma"
   error_protocol ("dummy return parameters not handled");
  }
   return;

  }
;
}

static void MakeDECLDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions unit)
# else
(t, unit)
 register tTree t;
 register tDefinitions unit;
# endif
{
  if (t->Kind == kDECL_LIST) {
# line 535 "MakeDefs.puma"
  {
# line 537 "MakeDefs.puma"
   set_protocol_stmt (t->DECL_LIST.Elem);
# line 538 "MakeDefs.puma"
   MakeDECLDefs (t->DECL_LIST.Elem, unit);
# line 539 "MakeDefs.puma"
   MakeDECLDefs (t->DECL_LIST.Next, unit);
  }
   return;

  }
  if (t->Kind == kDECL_EMPTY) {
# line 542 "MakeDefs.puma"
   return;

  }
  if (Tree_IsType (t, kDECL_NODE)) {
# line 551 "MakeDefs.puma"
 {
  tIdent yyV1;
  {
# line 553 "MakeDefs.puma"
   if (! ((IsThisFunction (GetLocalObject (t->DECL_NODE.Ident), & yyV1)))) goto yyL3;
  {
# line 554 "MakeDefs.puma"
   t->DECL_NODE.Ident = yyV1;
# line 555 "MakeDefs.puma"
   goto yyL3;
  }
  }
 }
yyL3:;

  }

  switch (t->Kind) {
  case kVAR_DECL:
# line 566 "MakeDefs.puma"
  {
# line 568 "MakeDefs.puma"
   MakeTYPEDefs (t->VAR_DECL.VAL);
# line 570 "MakeDefs.puma"
   MakeObjType (t->VAR_DECL.VAL, GetLocalVarEntity (t->VAR_DECL.Ident, t->VAR_DECL.Line, unit));
  }
   return;

  case kDIMENSION_DECL:
# line 581 "MakeDefs.puma"
  {
# line 583 "MakeDefs.puma"
   MakeTYPEDefs (t->DIMENSION_DECL.INDEXES);
# line 585 "MakeDefs.puma"
   MakeObjDimension (t->DIMENSION_DECL.INDEXES, GetLocalVarEntity (t->DIMENSION_DECL.Ident, t->DIMENSION_DECL.Line, unit));
  }
   return;

  case kSAVE_DECL:
  if (unit->Kind == kTypeObject) {
# line 596 "MakeDefs.puma"
   return;

  }
# line 599 "MakeDefs.puma"
  {
# line 601 "MakeDefs.puma"
   if (! ((t->SAVE_DECL.Ident == DefaultId ()))) goto yyL7;
  {
# line 603 "MakeDefs.puma"
 if (global_save_attribute)
       error_protocol ("only one single SAVE stmt is allowed");
     global_save_attribute = true;
   
  }
  }
   return;
yyL7:;

# line 609 "MakeDefs.puma"
  {
# line 611 "MakeDefs.puma"
   MakeObjSave (GetLocalVarEntity (t->SAVE_DECL.Ident, t->SAVE_DECL.Line, unit));
  }
   return;

  case kHPF_SEQUENCE_DECL:
# line 620 "MakeDefs.puma"
  {
# line 622 "MakeDefs.puma"
   if (! ((t->HPF_SEQUENCE_DECL.Ident == DefaultId ()))) goto yyL9;
  {
# line 624 "MakeDefs.puma"
 if (global_sequence_attribute || global_nosequence_attribute)
       error_protocol ("only one single SEQUENCE/NOSEQUENCE stmt is allowed");
     global_sequence_attribute = true;
   
  }
  }
   return;
yyL9:;

# line 630 "MakeDefs.puma"
  {
# line 632 "MakeDefs.puma"
   MakeObjSequential (GetLocalVarEntity (t->HPF_SEQUENCE_DECL.Ident, t->HPF_SEQUENCE_DECL.Line, unit));
  }
   return;

  case kNOSEQUENCE_DECL:
# line 641 "MakeDefs.puma"
  {
# line 643 "MakeDefs.puma"
   if (! ((t->NOSEQUENCE_DECL.Ident == DefaultId ()))) goto yyL11;
  {
# line 645 "MakeDefs.puma"
 if (global_sequence_attribute || global_nosequence_attribute)
       error_protocol ("only one single SEQUENCE/NOSEQUENCE stmt is allowed");
     global_nosequence_attribute = true;
   
  }
  }
   return;
yyL11:;

# line 651 "MakeDefs.puma"
  {
# line 653 "MakeDefs.puma"
   MakeObjNoSequential (GetLocalVarEntity (t->NOSEQUENCE_DECL.Ident, t->NOSEQUENCE_DECL.Line, unit));
  }
   return;

  case kINTRINSIC_DECL:
# line 662 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 664 "MakeDefs.puma"

# line 666 "MakeDefs.puma"
   Obj = GetIntrinsicObject (t->INTRINSIC_DECL.Ident);
# line 668 "MakeDefs.puma"
 if (Obj == NoObject)
       error_protocol ("INTRINSIC is unknown");
      else
       InsertEntry (Obj);  
   
  }
   return;
 }

  case kINTENT_DECL:
# line 681 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 683 "MakeDefs.puma"

# line 685 "MakeDefs.puma"
   Obj = GetLocalObject (t->INTENT_DECL.Ident);
# line 687 "MakeDefs.puma"
 if (Obj == NoObject)
        error_protocol ("no dummy argument with this name");
      else 
        MakeObjIntent (Obj, t->INTENT_DECL.intent);
   
  }
   return;
 }

  case kOPTIONAL_DECL:
# line 700 "MakeDefs.puma"
  {
# line 702 "MakeDefs.puma"
   MakeObjOptional (GetLocalVarEntity (t->OPTIONAL_DECL.Ident, t->OPTIONAL_DECL.Line, unit));
  }
   return;

  case kALLOCATABLE_DECL:
# line 711 "MakeDefs.puma"
  {
# line 713 "MakeDefs.puma"
   MakeObjAllocatable (GetLocalVarEntity (t->ALLOCATABLE_DECL.Ident, t->ALLOCATABLE_DECL.Line, unit));
  }
   return;

  case kPOINTER_DECL:
# line 722 "MakeDefs.puma"
  {
# line 724 "MakeDefs.puma"
   MakeObjPointer (GetLocalVarEntity (t->POINTER_DECL.Ident, t->POINTER_DECL.Line, unit));
  }
   return;

  case kTARGET_DECL:
# line 733 "MakeDefs.puma"
  {
# line 735 "MakeDefs.puma"
   MakeObjTarget (GetLocalVarEntity (t->TARGET_DECL.Ident, t->TARGET_DECL.Line, unit));
  }
   return;

  case kPUBLIC_DECL:
  if (unit->Kind == kTypeObject) {
# line 744 "MakeDefs.puma"
  {
# line 746 "MakeDefs.puma"
   if (! ((t->PUBLIC_DECL.Ident == DefaultId ()))) goto yyL19;
  }
   return;
yyL19:;

  }
# line 749 "MakeDefs.puma"
  {
# line 751 "MakeDefs.puma"
   if (! ((t->PUBLIC_DECL.Ident == DefaultId ()))) goto yyL20;
  {
# line 753 "MakeDefs.puma"
 if (global_public_attribute || global_private_attribute)
       error_protocol ("only one single PUBLIC or PRIVATE stmt is allowed");
     global_public_attribute = true;
   
  }
  }
   return;
yyL20:;

# line 759 "MakeDefs.puma"
  {
# line 761 "MakeDefs.puma"
   MakeObjPublic (GetLocalVarEntity (t->PUBLIC_DECL.Ident, t->PUBLIC_DECL.Line, unit));
  }
   return;

  case kPRIVATE_DECL:
  if (unit->Kind == kTypeObject) {
# line 770 "MakeDefs.puma"
  {
# line 772 "MakeDefs.puma"
   if (! ((t->PRIVATE_DECL.Ident == DefaultId ()))) goto yyL22;
  }
   return;
yyL22:;

  }
# line 775 "MakeDefs.puma"
  {
# line 777 "MakeDefs.puma"
   if (! ((t->PRIVATE_DECL.Ident == DefaultId ()))) goto yyL23;
  {
# line 779 "MakeDefs.puma"
 if (global_public_attribute || global_private_attribute)
       error_protocol ("only one single PUBLIC or PRIVATE stmt is allowed");
     global_private_attribute = true;
   
  }
  }
   return;
yyL23:;

# line 785 "MakeDefs.puma"
  {
# line 787 "MakeDefs.puma"
   MakeObjPrivate (GetLocalVarEntity (t->PRIVATE_DECL.Ident, t->PRIVATE_DECL.Line, unit));
  }
   return;

  case kSEQUENCE_DECL:
  if (unit->Kind == kTypeObject) {
# line 796 "MakeDefs.puma"
   return;

  }
# line 801 "MakeDefs.puma"
  {
# line 803 "MakeDefs.puma"
   error_protocol ("SEQUENCE statement only in derived types allowed");
  }
   return;

  case kLAYOUT_DECL:
# line 812 "MakeDefs.puma"
  {
# line 814 "MakeDefs.puma"
   MakeObjLayout (t->LAYOUT_DECL.kind, GetLocalVarEntity (t->LAYOUT_DECL.Ident, t->LAYOUT_DECL.Line, unit));
  }
   return;

  case kPASS_BY_DECL:
# line 823 "MakeDefs.puma"
  {
# line 825 "MakeDefs.puma"
   MakeObjPassBy (t->PASS_BY_DECL.kind, GetLocalVarEntity (t->PASS_BY_DECL.Ident, t->PASS_BY_DECL.Line, unit));
  }
   return;

  case kMAP_TO_DECL:
# line 834 "MakeDefs.puma"
  {
# line 836 "MakeDefs.puma"
   MakeObjMapTo (t->MAP_TO_DECL.kind, GetLocalVarEntity (t->MAP_TO_DECL.Ident, t->MAP_TO_DECL.Line, unit));
  }
   return;

  case kTYPE_DECL:
  if (t->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
# line 847 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 849 "MakeDefs.puma"

# line 851 "MakeDefs.puma"
 
     
     Obj = GetLocalObject (t->TYPE_DECL.Ident);

     if (Obj == NoObject)

       { Obj = MakeNewObject (t, unit);

         InsertEntry (Obj);   
       }

   
# line 864 "MakeDefs.puma"
   MakeTypeScope (Obj, t);
  }
   return;
 }

  }
  break;
  case kTEMPLATE_DECL:
# line 875 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 877 "MakeDefs.puma"

# line 879 "MakeDefs.puma"
   MakeTYPEDefs (t->TEMPLATE_DECL.DIMENSIONS);
# line 881 "MakeDefs.puma"
   Obj = GetLocalObject (t->TEMPLATE_DECL.Ident);
# line 883 "MakeDefs.puma"
 if (IsTypeObj (unit))

        error_protocol ("TEMPLATE not allowed in derived types");

     if (Obj == NoObject)

        { Obj = MakeNewObject (t, unit);
          InsertEntry (Obj);
        }

      else 

        { 
          MakeObjDimension (t->TEMPLATE_DECL.DIMENSIONS, Obj);
        }
   
  }
   return;
 }

  case kPROCESSORS_DECL:
# line 909 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 911 "MakeDefs.puma"

# line 913 "MakeDefs.puma"
   MakeTYPEDefs (t->PROCESSORS_DECL.DIMENSIONS);
# line 915 "MakeDefs.puma"
 if (!IsExplicitShape (t->PROCESSORS_DECL.DIMENSIONS))
        error_protocol ("PROCESSORS : shape must be explicit");
   
# line 919 "MakeDefs.puma"
   Obj = GetLocalObject (t->PROCESSORS_DECL.Ident);
# line 921 "MakeDefs.puma"
 if (IsTypeObj (unit))

        error_protocol ("PROCESSORS directive not allowed in derived types");

     

     if (Obj == NoObject)

        { Obj = MakeNewObject (t, unit);
          InsertEntry (Obj);
        }

      else 

        { 
          MakeObjDimension (t->PROCESSORS_DECL.DIMENSIONS, Obj);
        }
   
  }
   return;
 }

  case kOVERLAP_DECL:
# line 952 "MakeDefs.puma"
   return;

  case kMAP_DECL:
# line 963 "MakeDefs.puma"
  {
# line 967 "MakeDefs.puma"
 if (IsTypeObj (unit))

        error_protocol ("MAP directive not allowed in derived types");

     t->MAP_DECL.MAP_TARGET = CheckExp (t->MAP_DECL.MAP_TARGET);
   
  }
   return;

  case kFORMAT_DECL:
# line 975 "MakeDefs.puma"
   return;

  case kSHARED_DECL:
# line 980 "MakeDefs.puma"
  {
# line 982 "MakeDefs.puma"
   MakeObjShared (GetLocalVarEntity (t->SHARED_DECL.Ident, t->SHARED_DECL.Line, unit), t->SHARED_DECL.kind);
  }
   return;

  case kALIGN_DECL:
# line 985 "MakeDefs.puma"
   return;

  case kDYNAMIC_DECL:
# line 990 "MakeDefs.puma"
  {
# line 992 "MakeDefs.puma"
   MakeObjDynamic (GetLocalVarEntity (t->DYNAMIC_DECL.Ident, t->DYNAMIC_DECL.Line, unit));
  }
   return;

  case kTRACE_DECL:
# line 995 "MakeDefs.puma"
  {
# line 997 "MakeDefs.puma"
   MakeObjTrace (GetLocalVarEntity (t->TRACE_DECL.Ident, t->TRACE_DECL.Line, unit));
  }
   return;

  case kTREE_DECL:
# line 1000 "MakeDefs.puma"
  {
# line 1002 "MakeDefs.puma"
   MakeObjTree (GetLocalVarEntity (t->TREE_DECL.Ident, t->TREE_DECL.Line, unit));
  }
   return;

  case kINHERIT_DECL:
# line 1007 "MakeDefs.puma"
  {
# line 1009 "MakeDefs.puma"
   MakeObjInherited (GetLocalVarEntity (t->INHERIT_DECL.Ident, t->INHERIT_DECL.Line, unit));
  }
   return;

  case kRANGE_DECL:
# line 1012 "MakeDefs.puma"
   return;

  case kPARAMETER_DECL:
# line 1023 "MakeDefs.puma"
  {
# line 1025 "MakeDefs.puma"
 t->PARAMETER_DECL.VAL = CheckExp (t->PARAMETER_DECL.VAL); 
# line 1027 "MakeDefs.puma"
   MakeObjParameter (t->PARAMETER_DECL.VAL, GetLocalVarEntity (t->PARAMETER_DECL.Ident, t->PARAMETER_DECL.Line, unit));
  }
   return;

  case kIMPLICIT_DECL:
  if (t->IMPLICIT_DECL.TYPE->Kind == kDUMMY_TYPE) {
# line 1038 "MakeDefs.puma"
  {
# line 1042 "MakeDefs.puma"
   CharSetImplicitTable ('A', 'Z', t->IMPLICIT_DECL.TYPE);
  }
   return;

  }
# line 1045 "MakeDefs.puma"
  {
# line 1047 "MakeDefs.puma"
   SetImplicitTable (t->IMPLICIT_DECL.first, t->IMPLICIT_DECL.last, t->IMPLICIT_DECL.TYPE);
  }
   return;

  case kEXTERNAL_DECL:
# line 1056 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1058 "MakeDefs.puma"

# line 1059 "MakeDefs.puma"
   Obj = GetLocalObject (t->EXTERNAL_DECL.Ident);
# line 1061 "MakeDefs.puma"
   if (! ((Obj != NoObject))) goto yyL46;
  {
# line 1065 "MakeDefs.puma"
   MakeObjExternal (Obj);
  }
  }
   return;
 }
yyL46:;

# line 1068 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1070 "MakeDefs.puma"

# line 1072 "MakeDefs.puma"
   Obj = mExternalObject (t->EXTERNAL_DECL.Ident, t, Default, unit, UserRoutine, mENTRY_EMPTY ());
# line 1075 "MakeDefs.puma"
   SetExternalEntry (Obj);
# line 1076 "MakeDefs.puma"
   InsertEntry (Obj);
  }
   return;
 }

  case kINTERFACE_DECL:
  if (t->INTERFACE_DECL.SPEC->Kind == kNO_GENERIC_SPEC) {
# line 1087 "MakeDefs.puma"
 {
  tDefinitions HostAssociation;
  {
# line 1091 "MakeDefs.puma"
   DeclareUnits (t->INTERFACE_DECL.ITEMS, NoObject);
# line 1093 "MakeDefs.puma"

# line 1099 "MakeDefs.puma"
   MakeInterfaceDefs (t->INTERFACE_DECL.ITEMS);
  }
   return;
 }

  }
# line 1110 "MakeDefs.puma"
 {
  tDefinitions Obj;
  tDefinitions Scope;
  tDefinitions HostAssociation;
  {
# line 1112 "MakeDefs.puma"

# line 1113 "MakeDefs.puma"

# line 1114 "MakeDefs.puma"

# line 1116 "MakeDefs.puma"
 
 
     Obj = mGenericObject (GetGenericId (t->INTERFACE_DECL.SPEC), t, Default, unit, 
                           NoDefinitions);
     NewScope ();

     DeclareUnits (t->INTERFACE_DECL.ITEMS, Obj);   

     HostAssociation = RemoveHostAssociation ();
     MakeInterfaceDefs (t->INTERFACE_DECL.ITEMS);
     ResetHostAssociation (HostAssociation);
   
     Scope = GetCurrentScope ();
     CloseScope ();
     Obj->GenericObject.Interfaces = Scope;
     InsertEntry (Obj);

   
  }
   return;
 }

  case kCOMMON_DECL:
# line 1136 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1138 "MakeDefs.puma"

# line 1140 "MakeDefs.puma"
   Obj = GetDeclEntry (t->COMMON_DECL.Ident, GetCommonEntries ());
# line 1142 "MakeDefs.puma"
   MakeDECLDefs (t->COMMON_DECL.IDS, unit);
# line 1144 "MakeDefs.puma"
 if (Obj == NoObject)

        { Obj = mCommonObject (t->COMMON_DECL.Ident, t, Default, NoObject,
                               GetCurrentScope(),
                               0, 0, 0, 0);

          

          InsertCommonEntry (Obj);
        }

        
   
# line 1164 "MakeDefs.puma"
   MakeCommons (t->COMMON_DECL.IDS, t);
  }
   return;
 }

  case kNAMELIST_DECL:
# line 1167 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1169 "MakeDefs.puma"

# line 1171 "MakeDefs.puma"
   Obj = GetLocalObject (t->NAMELIST_DECL.Ident);
# line 1173 "MakeDefs.puma"
 if (Obj == NoObject)
        { Obj = mNameListObject (t->NAMELIST_DECL.Ident, t, Default, NoObject);
          InsertEntry (Obj);
        }
      else
        { 
          error_protocol ("illegal redefinition");
          tree_protocol ("NAMELIST Declaration is : ", t);
        }
   
# line 1185 "MakeDefs.puma"
   MakeDECLDefs (t->NAMELIST_DECL.IDS, unit);
  }
   return;
 }

  case kEQV_DECL:
# line 1188 "MakeDefs.puma"
  {
# line 1190 "MakeDefs.puma"
   MakeVarDefs (t->EQV_DECL.VARS);
  }
   return;

  case kDATA_DECL:
# line 1193 "MakeDefs.puma"
  {
# line 1194 "MakeDefs.puma"
   MakeVarDefs (t->DATA_DECL.VARS);
# line 1195 "MakeDefs.puma"
   MakeIndexDefs (t->DATA_DECL.VALS);
  }
   return;

  case kDISTRIBUTE_DECL:
# line 1198 "MakeDefs.puma"
   return;

  case kUSE_DECL:
# line 1202 "MakeDefs.puma"
  {
# line 1206 "MakeDefs.puma"
   UseModule (GetModule (t->USE_DECL.use), t->USE_DECL.RENAMINGS);
  }
   return;

  case kONLY_USE_DECL:
# line 1209 "MakeDefs.puma"
  {
# line 1211 "MakeDefs.puma"
   UseOnlyModule (GetModule (t->ONLY_USE_DECL.use), t->ONLY_USE_DECL.NAMES);
  }
   return;

  }

# line 1214 "MakeDefs.puma"
  {
# line 1216 "MakeDefs.puma"
   failure_protocol (MODULE, "MakeDECLDefs", t);
  }
   return;

;
}

static void MakeTYPEDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kARRAY_TYPE:
# line 1227 "MakeDefs.puma"
  {
# line 1228 "MakeDefs.puma"
   MakeTYPEDefs (t->ARRAY_TYPE.ARRAY_INDEX_TYPES);
# line 1229 "MakeDefs.puma"
   MakeTYPEDefs (t->ARRAY_TYPE.ARRAY_COMP_TYPE);
  }
   return;

  case kSHAPE_LIST:
# line 1232 "MakeDefs.puma"
  {
# line 1233 "MakeDefs.puma"
   MakeTYPEDefs (t->SHAPE_LIST.Elem);
# line 1234 "MakeDefs.puma"
   MakeTYPEDefs (t->SHAPE_LIST.Next);
  }
   return;

  case kSHAPE_EMPTY:
# line 1237 "MakeDefs.puma"
   return;

  case kEXPLICIT_SHAPE:
# line 1240 "MakeDefs.puma"
  {
# line 1242 "MakeDefs.puma"
 t->EXPLICIT_SHAPE.LOWER = CheckExp (t->EXPLICIT_SHAPE.LOWER);
     t->EXPLICIT_SHAPE.UPPER = CheckExp (t->EXPLICIT_SHAPE.UPPER);
   
  }
   return;

  case kASSUMED_SHAPE:
# line 1247 "MakeDefs.puma"
  {
# line 1249 "MakeDefs.puma"
 t->ASSUMED_SHAPE.LOWER = CheckExp (t->ASSUMED_SHAPE.LOWER); 
  }
   return;

  case kDEFERRED_SHAPE:
# line 1252 "MakeDefs.puma"
   return;

  case kASSUMED_SIZE:
# line 1256 "MakeDefs.puma"
  {
# line 1258 "MakeDefs.puma"
 t->ASSUMED_SIZE.LOWER = CheckExp (t->ASSUMED_SIZE.LOWER); 
  }
   return;

  case kDUMMY_TYPE:
# line 1261 "MakeDefs.puma"
   return;

  case kINTEGER_TYPE:
# line 1263 "MakeDefs.puma"
  {
# line 1263 "MakeDefs.puma"
 t->INTEGER_TYPE.SIZE = CheckExp (t->INTEGER_TYPE.SIZE); 
  }
   return;

  case kREAL_TYPE:
# line 1264 "MakeDefs.puma"
  {
# line 1264 "MakeDefs.puma"
 t->REAL_TYPE.SIZE = CheckExp (t->REAL_TYPE.SIZE); 
  }
   return;

  case kCOMPLEX_TYPE:
# line 1265 "MakeDefs.puma"
  {
# line 1265 "MakeDefs.puma"
 t->COMPLEX_TYPE.SIZE = CheckExp (t->COMPLEX_TYPE.SIZE); 
  }
   return;

  case kBOOLEAN_TYPE:
# line 1266 "MakeDefs.puma"
  {
# line 1266 "MakeDefs.puma"
 t->BOOLEAN_TYPE.SIZE = CheckExp (t->BOOLEAN_TYPE.SIZE); 
  }
   return;

  case kSTRING_TYPE:
# line 1268 "MakeDefs.puma"
  {
# line 1270 "MakeDefs.puma"
 t->STRING_TYPE.LENGTH = CheckExp (t->STRING_TYPE.LENGTH); 
  }
   return;

  case kTYPE_ID:
# line 1273 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1275 "MakeDefs.puma"

# line 1277 "MakeDefs.puma"
   Obj = GetGlobalObject (t->TYPE_ID.ID->TYPE_OBJ.Ident);
# line 1281 "MakeDefs.puma"
 if (Obj == NoObject)

        { Obj = MakeNewObject (mTYPE_DECL (t->TYPE_ID.ID->TYPE_OBJ.Ident, 0, NoTree),
                               GetCurrentUnitObject());
          InsertUseEntry (Obj);
          t->TYPE_ID.ID->TYPE_OBJ.Object = Obj;
          warning_protocol ("use of not defined type (should be pointer)");
        }

      else if (Obj->Kind != kTypeObject)
        error_protocol ("identifier not id of a derived type");
      else 
        t->TYPE_ID.ID->TYPE_OBJ.Object = Obj;
   
  }
   return;
 }

  }

# line 1297 "MakeDefs.puma"
  {
# line 1298 "MakeDefs.puma"
   failure_protocol (MODULE, "MakeTYPEDefs", t);
  }
   return;

;
}

static void InsertUseEntry
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 1311 "MakeDefs.puma"
 {
  tDefinitions Scope;
  {
# line 1313 "MakeDefs.puma"
   if (! ((is_type_scope))) goto yyL1;
  {
# line 1315 "MakeDefs.puma"

# line 1317 "MakeDefs.puma"
 Scope = GetCurrentScope ();
      CloseScope ();
      InsertEntry (obj);
      OpenScope (Scope);
    
  }
  }
   return;
 }
yyL1:;

# line 1324 "MakeDefs.puma"
  {
# line 1325 "MakeDefs.puma"
   InsertEntry (obj);
  }
   return;

;
}

static void MakeTypeScope
# if defined __STDC__ | defined __cplusplus
(register tDefinitions tobj, register tTree decl)
# else
(tobj, decl)
 register tDefinitions tobj;
 register tTree decl;
# endif
{
  if (tobj->Kind == kTypeObject) {
# line 1338 "MakeDefs.puma"
  {
# line 1340 "MakeDefs.puma"
   if (! ((tobj->TypeObject.Components != NoEntries))) goto yyL1;
  {
# line 1341 "MakeDefs.puma"
   error_protocol ("there is already such a defined type");
  }
  }
   return;
yyL1:;

  if (decl->Kind == kTYPE_DECL) {
  if (decl->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
# line 1344 "MakeDefs.puma"
 {
  tDefinitions Scope;
  {
# line 1347 "MakeDefs.puma"

# line 1349 "MakeDefs.puma"
 tobj->TypeObject.decl = decl;
     is_type_scope = true;
     NewScope ();
     decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS = Normal1Definitions (decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS);
     MakeDECLDefs (decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS, tobj);
     decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS = Normal2Definitions (decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS); 
     SetDistributions (decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS, tobj);
     SetAlignments    (decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS, tobj);
     Scope = GetCurrentScope ();
     CloseScope ();
     is_type_scope = false;
     tobj->TypeObject.Components = ReverseEntryList (Scope, mENTRY_EMPTY ());
   
  }
   return;
 }

  }
  }
  }
# line 1364 "MakeDefs.puma"
  {
# line 1366 "MakeDefs.puma"
   error_protocol ("type name already in use");
# line 1367 "MakeDefs.puma"
   obj_protocol ("object with this name is : ", tobj);
  }
   return;

;
}

static void MakeCommons
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree CommonDecl)
# else
(t, CommonDecl)
 register tTree t;
 register tTree CommonDecl;
# endif
{
  if (t->Kind == kDECL_EMPTY) {
# line 1380 "MakeDefs.puma"
   return;

  }
  if (t->Kind == kDECL_LIST) {
# line 1383 "MakeDefs.puma"
  {
# line 1385 "MakeDefs.puma"
   MakeCommons (t->DECL_LIST.Elem, CommonDecl);
# line 1386 "MakeDefs.puma"
   MakeCommons (t->DECL_LIST.Next, CommonDecl);
  }
   return;

  }
  if (t->Kind == kVAR_DECL) {
# line 1389 "MakeDefs.puma"
 {
  tDefinitions Obj;
  {
# line 1391 "MakeDefs.puma"

# line 1393 "MakeDefs.puma"
   Obj = GetLocalObject (t->VAR_DECL.Ident);
# line 1395 "MakeDefs.puma"
 if (Obj == NoObject)
         { error_protocol ("no object found for item in COMMON");
           tree_protocol ("item : ", t);
         }
       else
         MakeObjCommon (CommonDecl, Obj);
   
  }
   return;
 }

  }
  if (CommonDecl->Kind == kCOMMON_DECL) {
# line 1404 "MakeDefs.puma"
  {
# line 1406 "MakeDefs.puma"
   failure_protocol (MODULE, "MakeCommons", t);
  }
   return;

  }
;
}

static void MakeInterfaceDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUNIT_LIST) {
# line 1417 "MakeDefs.puma"
  {
# line 1419 "MakeDefs.puma"
   set_protocol_stmt (t->UNIT_LIST.Elem);
# line 1420 "MakeDefs.puma"
   MakeInterfaceDefs (t->UNIT_LIST.Elem);
# line 1421 "MakeDefs.puma"
   MakeInterfaceDefs (t->UNIT_LIST.Next);
  }
   return;

  }
  if (t->Kind == kUNIT_EMPTY) {
# line 1424 "MakeDefs.puma"
   return;

  }
  if (t->Kind == kMODULE_PROC_DECL) {
# line 1427 "MakeDefs.puma"
   return;

  }
  if (t->Kind == kPROC_DECL) {
# line 1430 "MakeDefs.puma"
  {
# line 1432 "MakeDefs.puma"
   MakeUnitDefs (t);
# line 1433 "MakeDefs.puma"
   EmptyBody (t->PROC_DECL.PROC_BODY);
  }
   return;

  }
  if (t->Kind == kFUNC_DECL) {
# line 1436 "MakeDefs.puma"
  {
# line 1438 "MakeDefs.puma"
   MakeUnitDefs (t);
# line 1439 "MakeDefs.puma"
   EmptyBody (t->FUNC_DECL.FUNC_BODY);
  }
   return;

  }
# line 1442 "MakeDefs.puma"
  {
# line 1443 "MakeDefs.puma"
   error_protocol ("not allowed in INTERFACE block");
  }
   return;

;
}

static void EmptyBody
# if defined __STDC__ | defined __cplusplus
(register tTree b)
# else
(b)
 register tTree b;
# endif
{
  if (b->Kind == kBODY_NODE) {
  if (b->BODY_NODE.STATS->Kind == kACF_EMPTY) {
  if (b->BODY_NODE.INTERNALS->Kind == kUNIT_EMPTY) {
# line 1448 "MakeDefs.puma"
   return;

  }
# line 1455 "MakeDefs.puma"
  {
# line 1456 "MakeDefs.puma"
   error_protocol ("internals in INTERFACE routine not allowed");
  }
   return;

  }
  if (b->BODY_NODE.INTERNALS->Kind == kUNIT_EMPTY) {
# line 1451 "MakeDefs.puma"
  {
# line 1452 "MakeDefs.puma"
   error_protocol ("statements in INTERFACE routine not allowed");
  }
   return;

  }
  }
;
}

static tDefinitions ReverseEntryList
# if defined __STDC__ | defined __cplusplus
(register tDefinitions list, register tDefinitions newlist)
# else
(list, newlist)
 register tDefinitions list;
 register tDefinitions newlist;
# endif
{
  if (list->Kind == kENTRY_EMPTY) {
# line 1479 "MakeDefs.puma"
   return newlist;

  }
  if (list->Kind == kENTRY_LIST) {
# line 1484 "MakeDefs.puma"
 {
  tDefinitions help;
  {
# line 1486 "MakeDefs.puma"

# line 1488 "MakeDefs.puma"
 help = list->ENTRY_LIST.Next;
     list->ENTRY_LIST.Next = newlist;
   
  }
  {
   return ReverseEntryList (help, list);
  }
 }

  }
 yyAbort ("ReverseEntryList");
}

static void SetExtrinsicId
# if defined __STDC__ | defined __cplusplus
(register tTree unit)
# else
(unit)
 register tTree unit;
# endif
{
  if (unit->Kind == kFUNC_DECL) {
# line 1505 "MakeDefs.puma"
  {
# line 1507 "MakeDefs.puma"
   if (! ((unit->FUNC_DECL.HPFExtrinsic == DefaultId ()))) goto yyL1;
  {
# line 1509 "MakeDefs.puma"
   unit->FUNC_DECL.HPFExtrinsic = GetCurrentExtrinsic ();
  }
  }
   return;
yyL1:;

  }
  if (unit->Kind == kPROC_DECL) {
# line 1512 "MakeDefs.puma"
  {
# line 1514 "MakeDefs.puma"
   if (! ((unit->PROC_DECL.HPFExtrinsic == DefaultId ()))) goto yyL2;
  {
# line 1516 "MakeDefs.puma"
   unit->PROC_DECL.HPFExtrinsic = GetCurrentExtrinsic ();
  }
  }
   return;
yyL2:;

  }
;
}

static tIdent GetCurrentExtrinsic
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 1521 "MakeDefs.puma"
  {
# line 1522 "MakeDefs.puma"
   if (! ((target_model == HPF_GLOBAL))) goto yyL1;
  }
   return IsIdent ("HPF_GLOBAL");
yyL1:;

# line 1526 "MakeDefs.puma"
  {
# line 1527 "MakeDefs.puma"
   if (! ((target_model == HPF_SERIAL))) goto yyL2;
  }
   return IsIdent ("HPF_SERIAL");
yyL2:;

# line 1531 "MakeDefs.puma"
  {
# line 1532 "MakeDefs.puma"
   if (! ((target_model == HPF_LOCAL))) goto yyL3;
  }
   return IsIdent ("HPF_LOCAL");
yyL3:;

 yyAbort ("GetCurrentExtrinsic");
}

void BeginMakeDefs ()
{
}

void CloseMakeDefs ()
{
}
