# include "MakeCalls.h"
# include "yyMakeCalls.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 50 "MakeCalls.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
 
# include "protocol.h"

# include "Transform.h"      /* CombineACF     */
# include "DefTable.h"
# include "Objects.h"        /* IsSerialCall   */

# include "Traverse.h" 
# include "Accepted.h" 

# include "VarDescriptor.h" 
# include "Intrinsics.h"

# include "StrUnparse.h"

# define MODULE "MakeCalls"
 
# undef DEBUG



static void yyExit () { Exit (1); }

void (* MakeCalls_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeCalls, routine %s failed\n", yyFunction);
 MakeCalls_Exit ();
}

void MakeCalls ARGS((tTree t));
static bool StopMakeTempArgs ARGS((tTree t));
static tTree DoMakeTempArgs ARGS((tTree t));
static void IntrinsicArguments ARGS((tIdent name, tTree actuals, tTree * yyP2, tTree * yyP1));
static void FunctionResult ARGS((tTree assign, tTree * yyP4, tTree * yyP3));
static void IntrinsicResult ARGS((tIdent name, tTree assign, tTree * yyP6, tTree * yyP5));
static void SplitScatter ARGS((tTree assign, tTree * yyP7));
static bool NoSplit ARGS((tTree var, tTree base));
static void MakeAcceptedIOParamList ARGS((tTree items, tTree * yyP9, tTree * yyP8));
static void MakeAcceptedIOParam ARGS((tTree item, tTree * yyP11, tTree * yyP10));
static void MakeAcceptedLoopParamList ARGS((tTree params, bool serial, tTree * yyP13, tTree * yyP12));
static void MakeAcceptedLoopParam ARGS((tTree actual, bool serial, tTree * yyP15, tTree * yyP14));
static void MakeAcceptedParamList ARGS((tTree actuals, tTree call, bool serial, tTree * yyP17, tTree * yyP16));
static void MakeAcceptedParam ARGS((tTree actual, tTree call, bool serial, tTree * yyP19, tTree * yyP18));
static void FindParamDescriptor ARGS((tTree actual, bool * yyP21, var_descriptor * yyP20));
static void MakeParamTemporary ARGS((tTree actual, pvar vard, tTree * yyP23, tTree * yyP22));
static void MakeNewAssignment ARGS((tTree exp, pvar vard, tTree * yyP26, tTree * yyP25, tTree * yyP24));
static bool AcceptedParameter ARGS((tTree param));
static bool AcceptedVarParameter ARGS((tTree var));
static void ExtractNewStatements ARGS((tTree stmts, tTree * yyP29, tTree * yyP28, tTree * yyP27));
static bool IsPreStatement ARGS((tTree t));
static bool IsPostStatement ARGS((tTree t));

void MakeCalls
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 84 "MakeCalls.puma"
  {
# line 86 "MakeCalls.puma"
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeTempArgs, DoMakeTempArgs); 
  }
   return;

  }
# line 89 "MakeCalls.puma"
  {
# line 90 "MakeCalls.puma"
   failure_protocol (MODULE, "MakeCalls", t);
  }
   return;

;
}

static bool StopMakeTempArgs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 107 "MakeCalls.puma"
  {
# line 108 "MakeCalls.puma"
   return false;
  }

}

static tTree DoMakeTempArgs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 124 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 126 "MakeCalls.puma"
   MakeAcceptedParamList (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, t->ACF_BASIC.BASIC_STMT, IsSerialCall (t->ACF_BASIC.BASIC_STMT), & yyV1, & yyV2);
# line 129 "MakeCalls.puma"
 if (yyV1 != NoTree)
      { set_protocol_stmt (t);
        stmt_protocol ("new arguments for subroutine call necessary");
        tree_protocol ("pre_stmts  : \n", yyV1);
        tree_protocol ("post_stmts : \n", yyV2);
      }
  
  }
  {
   return ComposeNewACF (yyV1, t, yyV2);
  }
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 140 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 143 "MakeCalls.puma"
   if (! ((IsIntrCall (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL2;
  {
# line 145 "MakeCalls.puma"
   IntrinsicArguments (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2);
# line 146 "MakeCalls.puma"
   IntrinsicResult (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->ACF_BASIC.BASIC_STMT, & yyV3, & yyV4);
# line 148 "MakeCalls.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 149 "MakeCalls.puma"
   yyV2 = CombineACF (yyV4, yyV2);
# line 151 "MakeCalls.puma"
 if (yyV1 != NoTree)

       { set_protocol_stmt (t);
         stmt_protocol ("new arguments for intrinsic function call necessary");
         tree_protocol ("pre_stmts  : \n", yyV1);
         tree_protocol ("post_stmts : \n", yyV2);
       }
   
  }
  }
  {
   return CombineACF (yyV1, CombineACF (t, yyV2));
  }
 }
yyL2:;

# line 163 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 166 "MakeCalls.puma"
   MakeAcceptedParamList (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, IsSerialCall (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP), & yyV1, & yyV2);
# line 169 "MakeCalls.puma"
   FunctionResult (t->ACF_BASIC.BASIC_STMT, & yyV3, & yyV4);
# line 171 "MakeCalls.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 172 "MakeCalls.puma"
   yyV2 = CombineACF (yyV4, yyV2);
# line 174 "MakeCalls.puma"
 if (yyV1 != NoTree)

       { stmt_protocol ("new arguments for function call necessary");
         tree_protocol ("pre_stmts  : \n", yyV1);
         tree_protocol ("post_stmts : \n", yyV2);
       }
   
  }
  {
   return CombineACF (yyV1, CombineACF (t, yyV2));
  }
 }

  }
  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
# line 185 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 187 "MakeCalls.puma"
   MakeAcceptedIOParamList (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS, & yyV1, & yyV2);
# line 189 "MakeCalls.puma"
 if (yyV1 != NoTree)

       { stmt_protocol ("new arguments for IO necessary");
         tree_protocol ("pre_stmts  : \n", yyV1);
         tree_protocol ("post_stmts : \n", yyV2);
       }
   
  }
  {
   return CombineACF (yyV1, CombineACF (t, yyV2));
  }
 }

  }
  }
  if (t->Kind == kACF_WHERE) {
# line 212 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 214 "MakeCalls.puma"
   ExtractNewStatements (t->ACF_WHERE.TRUE_PART, & yyV1, & yyV2, & yyV3);
# line 215 "MakeCalls.puma"
   ExtractNewStatements (t->ACF_WHERE.FALSE_PART, & yyV4, & yyV5, & yyV6);
# line 217 "MakeCalls.puma"
 t->ACF_WHERE.TRUE_PART = yyV1; t->ACF_WHERE.FALSE_PART = yyV4; 
# line 219 "MakeCalls.puma"
   yyV2 = CombineACF (yyV2, yyV5);
# line 220 "MakeCalls.puma"
   yyV3 = CombineACF (yyV6, yyV3);
  }
  {
   return ComposeNewACF (yyV2, t, yyV3);
  }
 }

  }
# line 225 "MakeCalls.puma"
   return t;

}

static void IntrinsicArguments
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree actuals, register tTree * yyP2, register tTree * yyP1)
# else
(name, actuals, yyP2, yyP1)
 register tIdent name;
 register tTree actuals;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (actuals->Kind == kBTP_LIST) {
  if (actuals->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (actuals->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (actuals->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 253 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
# line 257 "MakeCalls.puma"
   if (! (((IntrFuncRed (name)) || (IntrFuncLocRed (name))))) goto yyL1;
  {
# line 259 "MakeCalls.puma"
   MakeAcceptedParam (actuals->BTP_LIST.Next->BTP_LIST.Elem, NoTree, true, & yyV1, & yyV2);
# line 260 "MakeCalls.puma"
   MakeAcceptedLoopParam (actuals->BTP_LIST.Elem, false, & yyV3, & yyV4);
# line 262 "MakeCalls.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 263 "MakeCalls.puma"
   yyV2 = CombineACF (yyV4, yyV2);
# line 265 "MakeCalls.puma"
   MakeAcceptedLoopParam (actuals->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, false, & yyV5, & yyV6);
# line 267 "MakeCalls.puma"
   yyV1 = CombineACF (yyV1, yyV5);
# line 268 "MakeCalls.puma"
   yyV2 = CombineACF (yyV6, yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL1:;

# line 277 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 281 "MakeCalls.puma"
   if (! ((IsIdent ("SPREAD") == name))) goto yyL2;
  {
# line 283 "MakeCalls.puma"
   MakeAcceptedParam (actuals->BTP_LIST.Next->BTP_LIST.Elem, NoTree, true, & yyV1, & yyV2);
# line 285 "MakeCalls.puma"
   MakeAcceptedLoopParam (actuals->BTP_LIST.Elem, false, & yyV3, & yyV4);
# line 288 "MakeCalls.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 289 "MakeCalls.puma"
   yyV2 = CombineACF (yyV4, yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL2:;

  }
  }
  }
  }
# line 298 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 302 "MakeCalls.puma"
   if (! ((IsIdent ("MERGE") == name))) goto yyL3;
  {
# line 306 "MakeCalls.puma"
   MakeAcceptedLoopParamList (actuals, false, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL3:;

# line 309 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 313 "MakeCalls.puma"
   if (! ((IntrFuncElemental (name)))) goto yyL4;
  {
# line 315 "MakeCalls.puma"
   MakeAcceptedLoopParamList (actuals, false, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL4:;

# line 335 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 337 "MakeCalls.puma"
   MakeAcceptedParamList (actuals, NoTree, false, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

;
}

static void FunctionResult
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register tTree * yyP4, register tTree * yyP3)
# else
(assign, yyP4, yyP3)
 register tTree assign;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
  if (assign->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
# line 353 "MakeCalls.puma"
  {
# line 355 "MakeCalls.puma"
   if (! ((AcceptedVarParameter (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  }
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;
yyL1:;

# line 358 "MakeCalls.puma"
 {
  bool found;
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 360 "MakeCalls.puma"

# line 361 "MakeCalls.puma"

# line 363 "MakeCalls.puma"
   GetExpDescriptor (assign->ASSIGN_STMT.ASSIGN_EXP, & found, & vard);
# line 364 "MakeCalls.puma"
   if (! ((found))) goto yyL2;
  {
# line 366 "MakeCalls.puma"
   MakeNewAssignment (assign->ASSIGN_STMT.ASSIGN_EXP, & vard, & yyV1, & yyV2, & yyV3);
# line 367 "MakeCalls.puma"
 assign->ASSIGN_STMT.ASSIGN_EXP = yyV1; 
  }
  }
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }
yyL2:;

# line 370 "MakeCalls.puma"
  {
# line 372 "MakeCalls.puma"
   error_protocol ("no descriptor for function call found");
# line 373 "MakeCalls.puma"
   tree_protocol ("call is : ", assign->ASSIGN_STMT.ASSIGN_EXP);
  }
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  }
  }
;
}

static void IntrinsicResult
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree assign, register tTree * yyP6, register tTree * yyP5)
# else
(name, assign, yyP6, yyP5)
 register tIdent name;
 register tTree assign;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
# line 390 "MakeCalls.puma"
  {
# line 392 "MakeCalls.puma"
   if (! ((IsIdent ("SPREAD") == name))) goto yyL1;
  {
# line 393 "MakeCalls.puma"
   if (! ((DoLoopExpression (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  }
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;
yyL1:;

# line 396 "MakeCalls.puma"
  {
# line 398 "MakeCalls.puma"
   if (! ((IsIdent ("TRANSPOSE") == name))) goto yyL2;
  {
# line 399 "MakeCalls.puma"
   if (! ((DoLoopExpression (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL2;
  }
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;
yyL2:;

# line 402 "MakeCalls.puma"
  {
# line 404 "MakeCalls.puma"
   if (! ((IntrFuncElemental (name)))) goto yyL3;
  {
# line 405 "MakeCalls.puma"
   if (! ((DoLoopExpression (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL3;
  }
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;
yyL3:;

# line 408 "MakeCalls.puma"
 {
  tTree yyV1;
  {
# line 410 "MakeCalls.puma"
   if (! ((IntrFuncScatter (name)))) goto yyL4;
  {
# line 411 "MakeCalls.puma"
   SplitScatter (assign, & yyV1);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = NoTree;
   return;
 }
yyL4:;

  }
# line 414 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 416 "MakeCalls.puma"
   FunctionResult (assign, & yyV1, & yyV2);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }

;
}

static void SplitScatter
# if defined __STDC__ | defined __cplusplus
(register tTree assign, register tTree * yyP7)
# else
(assign, yyP7)
 register tTree assign;
 register tTree * yyP7;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
  if (assign->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
  if (assign->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (assign->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 430 "MakeCalls.puma"
  {
# line 433 "MakeCalls.puma"
   if (! ((! AcceptedVarParameter (assign->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  {
# line 435 "MakeCalls.puma"
   error_protocol ("not accepted LHS in scatter reduction (indirection?)");
  }
  }
   * yyP7 = NoTree;
   return;
yyL1:;

# line 438 "MakeCalls.puma"
  {
# line 441 "MakeCalls.puma"
   if (! ((NoSplit (assign->ASSIGN_STMT.ASSIGN_VAR, assign->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem)))) goto yyL2;
  }
   * yyP7 = NoTree;
   return;
yyL2:;

# line 444 "MakeCalls.puma"
 {
  tTree pre;
  {
# line 447 "MakeCalls.puma"

# line 449 "MakeCalls.puma"
 pre = mASSIGN_STMT (CopyTree(assign->ASSIGN_STMT.ASSIGN_VAR), VarParamToExp (assign->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem));
     pre = mACF_BASIC (pre);
     assign->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem = mVAR_PARAM (CopyTree(assign->ASSIGN_STMT.ASSIGN_VAR));
   
# line 454 "MakeCalls.puma"
   tree_protocol ("copy base into lhs (are different) : ", pre);
  }
   * yyP7 = pre;
   return;
 }

  }
  }
  }
  }
;
}

static bool NoSplit
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree base)
# else
(var, base)
 register tTree var;
 register tTree base;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
  if (base->Kind == kVAR_PARAM) {
  if (base->VAR_PARAM.V->Kind == kINDEXED_VAR) {
# line 459 "MakeCalls.puma"
  {
# line 461 "MakeCalls.puma"
   if (! ((TreeVarName (var->INDEXED_VAR.IND_VAR) == TreeVarName (base->VAR_PARAM.V->INDEXED_VAR.IND_VAR)))) goto yyL1;
  {
# line 462 "MakeCalls.puma"
   if (! ((EqualIndexes (var->INDEXED_VAR.IND_EXPS, base->VAR_PARAM.V->INDEXED_VAR.IND_EXPS)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  }
  }
  }
  return false;
}

static void MakeAcceptedIOParamList
# if defined __STDC__ | defined __cplusplus
(register tTree items, register tTree * yyP9, register tTree * yyP8)
# else
(items, yyP9, yyP8)
 register tTree items;
 register tTree * yyP9;
 register tTree * yyP8;
# endif
{
  if (items->Kind == kBTP_LIST) {
# line 472 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 474 "MakeCalls.puma"
   MakeAcceptedIOParam (items->BTP_LIST.Elem, & yyV1, & yyV2);
# line 475 "MakeCalls.puma"
   MakeAcceptedIOParamList (items->BTP_LIST.Next, & yyV3, & yyV4);
# line 477 "MakeCalls.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 478 "MakeCalls.puma"
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP9 = yyV1;
   * yyP8 = yyV2;
   return;
 }

  }
  if (items->Kind == kBTP_EMPTY) {
# line 481 "MakeCalls.puma"
   * yyP9 = NoTree;
   * yyP8 = NoTree;
   return;

  }
;
}

static void MakeAcceptedIOParam
# if defined __STDC__ | defined __cplusplus
(register tTree item, register tTree * yyP11, register tTree * yyP10)
# else
(item, yyP11, yyP10)
 register tTree item;
 register tTree * yyP11;
 register tTree * yyP10;
# endif
{
# line 486 "MakeCalls.puma"
  {
# line 488 "MakeCalls.puma"
   if (! ((DoLoopExpression (item)))) goto yyL1;
  }
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;
yyL1:;

# line 491 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 495 "MakeCalls.puma"
   tree_protocol ("this IO-argument requires temporary : ", item);
# line 497 "MakeCalls.puma"
   MakeAcceptedParam (item, NoTree, true, & yyV1, & yyV2);
  }
   * yyP11 = yyV1;
   * yyP10 = yyV2;
   return;
 }

;
}

static void MakeAcceptedLoopParamList
# if defined __STDC__ | defined __cplusplus
(register tTree params, register bool serial, register tTree * yyP13, register tTree * yyP12)
# else
(params, serial, yyP13, yyP12)
 register tTree params;
 register bool serial;
 register tTree * yyP13;
 register tTree * yyP12;
# endif
{
  if (params->Kind == kBTP_LIST) {
# line 509 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 511 "MakeCalls.puma"
   MakeAcceptedLoopParam (params->BTP_LIST.Elem, serial, & yyV1, & yyV2);
# line 512 "MakeCalls.puma"
   MakeAcceptedLoopParamList (params->BTP_LIST.Next, serial, & yyV3, & yyV4);
# line 514 "MakeCalls.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 515 "MakeCalls.puma"
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP13 = yyV1;
   * yyP12 = yyV2;
   return;
 }

  }
  if (params->Kind == kBTP_EMPTY) {
# line 518 "MakeCalls.puma"
   * yyP13 = NoTree;
   * yyP12 = NoTree;
   return;

  }
;
}

static void MakeAcceptedLoopParam
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register bool serial, register tTree * yyP15, register tTree * yyP14)
# else
(actual, serial, yyP15, yyP14)
 register tTree actual;
 register bool serial;
 register tTree * yyP15;
 register tTree * yyP14;
# endif
{
# line 523 "MakeCalls.puma"
  {
# line 525 "MakeCalls.puma"
   if (! ((DoLoopExpression (actual)))) goto yyL1;
  }
   * yyP15 = NoTree;
   * yyP14 = NoTree;
   return;
yyL1:;

# line 528 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 530 "MakeCalls.puma"
   MakeAcceptedParam (actual, NoTree, serial, & yyV1, & yyV2);
  }
   * yyP15 = yyV1;
   * yyP14 = yyV2;
   return;
 }

;
}

static void MakeAcceptedParamList
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register tTree call, register bool serial, register tTree * yyP17, register tTree * yyP16)
# else
(actuals, call, serial, yyP17, yyP16)
 register tTree actuals;
 register tTree call;
 register bool serial;
 register tTree * yyP17;
 register tTree * yyP16;
# endif
{
  if (actuals->Kind == kBTP_LIST) {
# line 552 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
# line 554 "MakeCalls.puma"
   MakeAcceptedParam (actuals->BTP_LIST.Elem, call, serial, & yyV1, & yyV2);
# line 555 "MakeCalls.puma"
   MakeAcceptedParamList (actuals->BTP_LIST.Next, call, serial, & yyV3, & yyV4);
# line 557 "MakeCalls.puma"
   yyV1 = CombineACF (yyV1, yyV3);
# line 558 "MakeCalls.puma"
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP17 = yyV1;
   * yyP16 = yyV2;
   return;
 }

  }
  if (actuals->Kind == kBTP_EMPTY) {
# line 561 "MakeCalls.puma"
   * yyP17 = NoTree;
   * yyP16 = NoTree;
   return;

  }
;
}

static void MakeAcceptedParam
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree call, register bool serial, register tTree * yyP19, register tTree * yyP18)
# else
(actual, call, serial, yyP19, yyP18)
 register tTree actual;
 register tTree call;
 register bool serial;
 register tTree * yyP19;
 register tTree * yyP18;
# endif
{
# line 574 "MakeCalls.puma"
  {
# line 576 "MakeCalls.puma"
   if (! ((AcceptedParameter (actual)))) goto yyL1;
  }
   * yyP19 = NoTree;
   * yyP18 = NoTree;
   return;
yyL1:;

  if (actual->Kind == kVAR_PARAM) {
# line 579 "MakeCalls.puma"
 {
  bool found;
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  {
# line 581 "MakeCalls.puma"
   if (! ((actual->VAR_PARAM.formal != NoObject))) goto yyL2;
  {
# line 582 "MakeCalls.puma"
   if (! ((call != NoTree))) goto yyL2;
  {
# line 583 "MakeCalls.puma"
   if (! ((! serial))) goto yyL2;
  {
# line 585 "MakeCalls.puma"

# line 586 "MakeCalls.puma"

# line 588 "MakeCalls.puma"
   GetDummyVarDescriptor (actual, actual->VAR_PARAM.formal, call, & found, & vard);
# line 590 "MakeCalls.puma"
   if (! ((found))) goto yyL2;
  {
# line 592 "MakeCalls.puma"
   MakeParamTemporary (actual, & vard, & yyV1, & yyV2);
  }
  }
  }
  }
  }
   * yyP19 = yyV1;
   * yyP18 = yyV2;
   return;
 }
yyL2:;

# line 595 "MakeCalls.puma"
 {
  bool found;
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  {
# line 597 "MakeCalls.puma"

# line 598 "MakeCalls.puma"

# line 600 "MakeCalls.puma"
   GetParamDescriptor (actual, & found, & vard);
# line 601 "MakeCalls.puma"
   if (! ((found))) goto yyL3;
  {
# line 603 "MakeCalls.puma"
 if (serial)

        { vard.topology_rank = 0;
          vard.topology_obj  = GetDefaultTopology (0);
        }
   
# line 610 "MakeCalls.puma"
   MakeParamTemporary (actual, & vard, & yyV1, & yyV2);
  }
  }
   * yyP19 = yyV1;
   * yyP18 = yyV2;
   return;
 }
yyL3:;

# line 613 "MakeCalls.puma"
 {
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  {
# line 615 "MakeCalls.puma"

# line 617 "MakeCalls.puma"
   if (! ((TreeRank (actual->VAR_PARAM.V) == 0))) goto yyL4;
  {
# line 619 "MakeCalls.puma"
   MakeReplicatedDescriptor (& vard);
# line 621 "MakeCalls.puma"
   MakeParamTemporary (actual, & vard, & yyV1, & yyV2);
  }
  }
   * yyP19 = yyV1;
   * yyP18 = yyV2;
   return;
 }
yyL4:;

  }
# line 624 "MakeCalls.puma"
  {
# line 626 "MakeCalls.puma"
   error_protocol ("could not make an accepted argument");
# line 627 "MakeCalls.puma"
   tree_protocol ("illegal argument : ", actual);
  }
   * yyP19 = NoTree;
   * yyP18 = NoTree;
   return;

;
}

static void FindParamDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register bool * yyP21, var_descriptor * yyP20)
# else
(actual, yyP21, yyP20)
 register tTree actual;
 register bool * yyP21;
 var_descriptor * yyP20;
# endif
{
# line 638 "MakeCalls.puma"
 {
  bool found;
  var_descriptor vard;
  {
# line 640 "MakeCalls.puma"

# line 641 "MakeCalls.puma"

# line 643 "MakeCalls.puma"
   GetParamDescriptor (actual, & found, & vard);
# line 644 "MakeCalls.puma"
   if (! ((found))) goto yyL1;
  }
   * yyP21 = found;
   * yyP20 = vard;
   return;
 }
yyL1:;

# line 647 "MakeCalls.puma"
 {
  var_descriptor vard;
  {
# line 649 "MakeCalls.puma"

  }
   * yyP21 = false;
   * yyP20 = vard;
   return;
 }

;
}

static void MakeParamTemporary
# if defined __STDC__ | defined __cplusplus
(register tTree actual, pvar vard, register tTree * yyP23, register tTree * yyP22)
# else
(actual, vard, yyP23, yyP22)
 register tTree actual;
 pvar vard;
 register tTree * yyP23;
 register tTree * yyP22;
# endif
{
  if (actual->Kind == kVAR_PARAM) {
  if (actual->VAR_PARAM.V->Kind == kADDR) {
# line 660 "MakeCalls.puma"
 {
  tTree pre_stmts;
  tTree post_stmts;
  tTree assign;
  tTree tmp_var;
  {
# line 665 "MakeCalls.puma"

# line 666 "MakeCalls.puma"

# line 667 "MakeCalls.puma"

# line 668 "MakeCalls.puma"

# line 670 "MakeCalls.puma"
   NoExpansion (vard);
# line 671 "MakeCalls.puma"
   MakeTemporaryStmt (actual->VAR_PARAM.V->ADDR.E, vard, & pre_stmts, & tmp_var, & assign, & post_stmts);
# line 673 "MakeCalls.puma"
 actual->VAR_PARAM.V = tmp_var; 
  }
   * yyP23 = CombineACF (pre_stmts, assign);
   * yyP22 = post_stmts;
   return;
 }

  }
# line 676 "MakeCalls.puma"
 {
  tTree pre_stmts;
  tTree post_stmts;
  tTree new_var;
  {
# line 678 "MakeCalls.puma"

# line 679 "MakeCalls.puma"

# line 681 "MakeCalls.puma"

# line 683 "MakeCalls.puma"
   NoExpansion (vard);
# line 684 "MakeCalls.puma"
   MakeTempVarStmt (actual->VAR_PARAM.V, actual->VAR_PARAM.intent, vard, & new_var, & pre_stmts, & post_stmts);
# line 686 "MakeCalls.puma"
 actual->VAR_PARAM.V = new_var; 
  }
   * yyP23 = pre_stmts;
   * yyP22 = post_stmts;
   return;
 }

  }
# line 689 "MakeCalls.puma"
  {
# line 691 "MakeCalls.puma"
   failure_protocol (MODULE, "MakeParamTemporary", actual);
  }
   * yyP23 = NoTree;
   * yyP22 = NoTree;
   return;

;
}

static void MakeNewAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard, register tTree * yyP26, register tTree * yyP25, register tTree * yyP24)
# else
(exp, vard, yyP26, yyP25, yyP24)
 register tTree exp;
 pvar vard;
 register tTree * yyP26;
 register tTree * yyP25;
 register tTree * yyP24;
# endif
{
# line 702 "MakeCalls.puma"
 {
  tTree pre_stmt;
  tTree post_stmt;
  tTree tmp_var;
  tTree assign;
  {
# line 704 "MakeCalls.puma"

# line 705 "MakeCalls.puma"

# line 706 "MakeCalls.puma"

# line 708 "MakeCalls.puma"

# line 710 "MakeCalls.puma"
   NoExpansion (vard);
# line 712 "MakeCalls.puma"
   MakeTemporaryStmt (exp, vard, & pre_stmt, & tmp_var, & assign, & post_stmt);
  }
   * yyP26 = mVAR_EXP (tmp_var);
   * yyP25 = CombineACF (pre_stmt, assign);
   * yyP24 = post_stmt;
   return;
 }

;
}

static bool AcceptedParameter
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kNO_PARAM) {
# line 726 "MakeCalls.puma"
   return true;

  }
  if (param->Kind == kFUNC_PARAM) {
# line 729 "MakeCalls.puma"
   return true;

  }
  if (param->Kind == kPROC_PARAM) {
# line 732 "MakeCalls.puma"
   return true;

  }
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
# line 735 "MakeCalls.puma"
  {
# line 737 "MakeCalls.puma"
   if (! ((IsF77 (param->VAR_PARAM.V->ADDR.E)))) goto yyL4;
  }
   return true;
yyL4:;

  }
# line 740 "MakeCalls.puma"
  {
# line 742 "MakeCalls.puma"
   if (! ((AcceptedVarParameter (param->VAR_PARAM.V)))) goto yyL5;
  }
   return true;
yyL5:;

  }
# line 745 "MakeCalls.puma"
  {
# line 747 "MakeCalls.puma"

#ifdef DEBUG
     FileUnparse (stdout, param); printf (" is not accepted parameter\n");
     WriteTree (stdout, param);
#endif
   
# line 753 "MakeCalls.puma"
   return false;
  }

}

static bool AcceptedVarParameter
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 771 "MakeCalls.puma"
  {
# line 773 "MakeCalls.puma"
   if (! ((TreeRank (var) > 0))) goto yyL1;
  {
# line 774 "MakeCalls.puma"
   if (! ((IsDescriptorVar (var)))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 779 "MakeCalls.puma"
  {
# line 781 "MakeCalls.puma"
   if (! ((TreeRank (var) == 0))) goto yyL2;
  {
# line 782 "MakeCalls.puma"
   if (! ((IsF77 (var)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  return false;
}

static void ExtractNewStatements
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, register tTree * yyP29, register tTree * yyP28, register tTree * yyP27)
# else
(stmts, yyP29, yyP28, yyP27)
 register tTree stmts;
 register tTree * yyP29;
 register tTree * yyP28;
 register tTree * yyP27;
# endif
{
  if (stmts->Kind == kACF_EMPTY) {
# line 796 "MakeCalls.puma"
   * yyP29 = stmts;
   * yyP28 = NoTree;
   * yyP27 = NoTree;
   return;

  }
  if (stmts->Kind == kACF_LIST) {
# line 799 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 801 "MakeCalls.puma"
   if (! ((IsPreStatement (stmts->ACF_LIST.Elem)))) goto yyL2;
  {
# line 803 "MakeCalls.puma"
   ExtractNewStatements (stmts->ACF_LIST.Next, & yyV1, & yyV2, & yyV3);
  }
  }
   * yyP29 = yyV1;
   * yyP28 = CombineACF (stmts->ACF_LIST.Elem, yyV2);
   * yyP27 = yyV3;
   return;
 }
yyL2:;

# line 806 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 808 "MakeCalls.puma"
   if (! ((IsPostStatement (stmts->ACF_LIST.Elem)))) goto yyL3;
  {
# line 810 "MakeCalls.puma"
   ExtractNewStatements (stmts->ACF_LIST.Next, & yyV1, & yyV2, & yyV3);
  }
  }
   * yyP29 = yyV1;
   * yyP28 = yyV2;
   * yyP27 = CombineACF (stmts->ACF_LIST.Elem, yyV3);
   return;
 }
yyL3:;

# line 813 "MakeCalls.puma"
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
# line 815 "MakeCalls.puma"
   ExtractNewStatements (stmts->ACF_LIST.Next, & yyV1, & yyV2, & yyV3);
# line 817 "MakeCalls.puma"
 stmts->ACF_LIST.Next = yyV1; 
  }
   * yyP29 = stmts;
   * yyP28 = yyV2;
   * yyP27 = yyV3;
   return;
 }

  }
;
}

static bool IsPreStatement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCREATE_DSP_STMT) {
# line 823 "MakeCalls.puma"
   return true;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
# line 826 "MakeCalls.puma"
   return true;

  }
  }
  return false;
}

static bool IsPostStatement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kFREE_DSP_STMT) {
# line 831 "MakeCalls.puma"
   return true;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
# line 834 "MakeCalls.puma"
   return true;

  }
  }
  return false;
}

void BeginMakeCalls ()
{
}

void CloseMakeCalls ()
{
}
