# include "MakeArguments.h"
# include "yyMakeArguments.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 34 "MakeArguments.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "Transform.h" 
# include "Traverse.h"
# include "FindHome.h"
# include "Temporary.h"

# include "Descriptor.h"
# include "MoveDescriptor.h"

# include "MakeSerial.h"            /* MakeSerial             */
# include "TempFunctions.h"         /* MakeTempFunctions      */
# include "MakeCalls.h"             /* MakeCalls              */
# include "MakeRemapping.h"         /* MakeRemapping          */
# include "MakeReductions.h"        /* MakeReductions         */
# include "MakeOvUpdates.h"         /* MakeOvUpdates          */

# include "Nesting.h"
# include "Objects.h"

# define MODULE "MakeArguments"



static void yyExit () { Exit (1); }

void (* MakeArguments_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module MakeArguments, routine %s failed\n", yyFunction);
 MakeArguments_Exit ();
}

void MakeArguments ARGS((tTree t));

void MakeArguments
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kCOMP_UNIT:
# line 76 "MakeArguments.puma"
  {
# line 78 "MakeArguments.puma"
   open_protocol ("adaptor.args");
# line 79 "MakeArguments.puma"
   MakeArguments (t->COMP_UNIT.COMP_ELEMENTS);
# line 80 "MakeArguments.puma"
   close_protocol ();
  }
   return;

  case kUNIT_LIST:
# line 85 "MakeArguments.puma"
  {
# line 87 "MakeArguments.puma"
   MakeArguments (t->UNIT_LIST.Elem);
# line 88 "MakeArguments.puma"
   MakeArguments (t->UNIT_LIST.Next);
  }
   return;

  case kUNIT_EMPTY:
# line 91 "MakeArguments.puma"
   return;

  case kPROGRAM_DECL:
# line 94 "MakeArguments.puma"
  {
# line 96 "MakeArguments.puma"
   NestOpenUnit (t);
# line 97 "MakeArguments.puma"
   MakeArguments (t->PROGRAM_DECL.PROGRAM_BODY);
# line 98 "MakeArguments.puma"
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
# line 101 "MakeArguments.puma"
  {
# line 103 "MakeArguments.puma"
   NestOpenUnit (t);
# line 104 "MakeArguments.puma"
   MakeArguments (t->PROC_DECL.PROC_BODY);
# line 105 "MakeArguments.puma"
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
# line 108 "MakeArguments.puma"
  {
# line 110 "MakeArguments.puma"
   NestOpenUnit (t);
# line 111 "MakeArguments.puma"
   MakeArguments (t->FUNC_DECL.FUNC_BODY);
# line 112 "MakeArguments.puma"
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
# line 115 "MakeArguments.puma"
  {
# line 117 "MakeArguments.puma"
   NestOpenUnit (t);
# line 118 "MakeArguments.puma"
   MakeArguments (t->BLOCK_DATA_DECL.DATA_BODY);
# line 119 "MakeArguments.puma"
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
# line 122 "MakeArguments.puma"
  {
# line 124 "MakeArguments.puma"
   NestOpenUnit (t);
# line 125 "MakeArguments.puma"
   MakeArguments (t->MODULE_DECL.MODULE_BODY);
# line 126 "MakeArguments.puma"
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
# line 129 "MakeArguments.puma"
  {
# line 131 "MakeArguments.puma"
   if (! ((IsPureUnit (GetCurrentUnit ())))) goto yyL9;
  }
   return;
yyL9:;

# line 136 "MakeArguments.puma"
  {
# line 138 "MakeArguments.puma"
   TemporaryInit (t);
# line 140 "MakeArguments.puma"
   print_protocol ("Step 1 : Serialization of FORALL/WHERE/Array-Assigments\n");
# line 143 "MakeArguments.puma"
   MakeSerial (t);
# line 145 "MakeArguments.puma"
   print_protocol ("Step 2 : determine the overlap updates \n");
# line 147 "MakeArguments.puma"
   MakeOvUpdates (t);
# line 149 "MakeArguments.puma"
   print_protocol ("Step 3 : Extract function calls to own statements\n");
# line 152 "MakeArguments.puma"
   MakeTempFunctions (t);
# line 154 "MakeArguments.puma"
   print_protocol ("Step 4 : make legal call arguments/results \n");
# line 156 "MakeArguments.puma"
   MakeCalls (t);
# line 158 "MakeArguments.puma"
   print_protocol ("Step 5 : remapping of arguments \n");
# line 160 "MakeArguments.puma"
   MakeRemapping (t);
# line 162 "MakeArguments.puma"
   print_protocol ("Step 6 : temporary for reductions \n");
# line 164 "MakeArguments.puma"
   MakeReductions (t);
# line 166 "MakeArguments.puma"
   TemporaryDone (t);
# line 168 "MakeArguments.puma"
   MakeArguments (t->BODY_NODE.INTERNALS);
  }
   return;

  }

;
}

void BeginMakeArguments ()
{
}

void CloseMakeArguments ()
{
}
