# include "Loops.h"
# include "yyLoops.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 30 "Loops.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"

# include "protocol.h"

# include "TreeOps.h"
# include "Expressions.h"
# include "Nesting.h"
# include "ParNest.h"

# include "Invariant.h"

# define MODULE "Loops"

# undef DEBUG



static void yyExit () { Exit (1); }

void (* Loops_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Loops, routine %s failed\n", yyFunction);
 Loops_Exit ();
}

bool IsFullParLoopVar ARGS((tTree var));
bool IsFullLoopVar ARGS((tTree var));
bool IsLinParLoopVar ARGS((tTree var));
static bool IsInParallelLoop ARGS((tTree var, tTree loop));
static bool LinearInParallelLoop ARGS((tTree var, tTree loop));
static bool LinearDependency ARGS((tTree var, tTree id));
static bool Dependency ARGS((tTree var, tTree id));
static bool IsLinearDependent ARGS((tTree exp, tTree id));
bool IsParallelLoop ARGS((tTree loop));
bool HasOuterParallelLoop ARGS(());
bool FreeLoopIndex ARGS((tTree index_exp, tTree var));
bool NoParallelLoopIndex ARGS((tTree index_exp));
void ForallVarCheck ARGS((tTree var));
static void ForallLoopVarCheck ARGS((tTree loop, tTree var));
bool IsLoopInvariant ARGS((tTree exp, tTree loop));
static bool IsUnchanged ARGS((tTree var, tTree stmt));

bool IsFullParLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 65 "Loops.puma"
 {
  bool okay;
  int i;
  {
# line 67 "Loops.puma"

# line 68 "Loops.puma"

# line 70 "Loops.puma"
 okay = true;
     for (i=1; i <= OuterLoops(); i++)
        okay = okay && IsInParallelLoop (var, GetOuterLoop(i));
   
# line 75 "Loops.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

# line 78 "Loops.puma"
  {
# line 80 "Loops.puma"
   return false;
  }

}

bool IsFullLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 97 "Loops.puma"
 {
  bool okay;
  int i;
  {
# line 99 "Loops.puma"

# line 100 "Loops.puma"

# line 102 "Loops.puma"
 okay = true;

     for (i=1; i <= GetParNestingDepth (); i++)
      
       { tTree loop;

         loop = GetParNestACF (i);

         if (IsCountLoop (loop))
            okay = okay && Dependency (var, GetLoopId (loop));
       }

   
# line 116 "Loops.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

# line 119 "Loops.puma"
  {
# line 121 "Loops.puma"
   return false;
  }

}

bool IsLinParLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 139 "Loops.puma"
 {
  bool okay;
  int i;
  {
# line 141 "Loops.puma"

# line 142 "Loops.puma"

# line 144 "Loops.puma"
 okay = true;
     for (i=1; i <= OuterLoops(); i++)
        okay = okay && LinearInParallelLoop (var, GetOuterLoop(i));
   
# line 149 "Loops.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

# line 152 "Loops.puma"
  {
# line 154 "Loops.puma"
   return false;
  }

}

static bool IsInParallelLoop
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree loop)
# else
(var, loop)
 register tTree var;
 register tTree loop;
# endif
{
# line 167 "Loops.puma"
  {
# line 169 "Loops.puma"
   if (! ((IsParallelLoop (loop)))) goto yyL1;
  {
# line 170 "Loops.puma"
   if (! ((Dependency (var, GetLoopId (loop))))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 173 "Loops.puma"
  {
# line 174 "Loops.puma"
   if (! ((! IsParallelLoop (loop)))) goto yyL2;
  }
   return true;
yyL2:;

  return false;
}

static bool LinearInParallelLoop
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree loop)
# else
(var, loop)
 register tTree var;
 register tTree loop;
# endif
{
# line 187 "Loops.puma"
  {
# line 189 "Loops.puma"
   if (! ((IsParallelLoop (loop)))) goto yyL1;
  {
# line 190 "Loops.puma"
   if (! ((LinearDependency (var, GetLoopId (loop))))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 193 "Loops.puma"
  {
# line 194 "Loops.puma"
   if (! ((! IsParallelLoop (loop)))) goto yyL2;
  }
   return true;
yyL2:;

  return false;
}

static bool LinearDependency
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree id)
# else
(var, id)
 register tTree var;
 register tTree id;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 207 "Loops.puma"
  {
# line 209 "Loops.puma"
   if (! ((LinearDependency (var->INDEXED_VAR.IND_EXPS, id)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (var->Kind == kBTE_LIST) {
# line 212 "Loops.puma"
  {
# line 214 "Loops.puma"
   if (! ((IsLinearDependent (var->BTE_LIST.Elem, id)))) goto yyL2;
  }
   return true;
yyL2:;

# line 217 "Loops.puma"
  {
# line 219 "Loops.puma"
   if (! ((LinearDependency (var->BTE_LIST.Next, id)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

static bool Dependency
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree id)
# else
(var, id)
 register tTree var;
 register tTree id;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
# line 232 "Loops.puma"
  {
# line 234 "Loops.puma"
   if (! ((Dependency (var->INDEXED_VAR.IND_EXPS, id)))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (var->Kind == kBTE_LIST) {
# line 237 "Loops.puma"
  {
# line 239 "Loops.puma"
   if (! ((IsVarInExp (TreeVarName (id), var->BTE_LIST.Elem)))) goto yyL2;
  }
   return true;
yyL2:;

# line 242 "Loops.puma"
  {
# line 244 "Loops.puma"
   if (! ((Dependency (var->BTE_LIST.Next, id)))) goto yyL3;
  }
   return true;
yyL3:;

  }
  return false;
}

static bool IsLinearDependent
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id)
# else
(exp, id)
 register tTree exp;
 register tTree id;
# endif
{
# line 257 "Loops.puma"
 {
  tTree var;
  int stride;
  int base;
  bool found;
  {
# line 259 "Loops.puma"

# line 260 "Loops.puma"

# line 261 "Loops.puma"

# line 262 "Loops.puma"

# line 264 "Loops.puma"
   ResolveExpression (exp, & found, & stride, & base, & var);
# line 265 "Loops.puma"
   if (! ((found))) goto yyL1;
  {
# line 266 "Loops.puma"
   if (! ((stride != 0))) goto yyL1;
  {
# line 267 "Loops.puma"
   if (! ((TreeVarName (var) == TreeVarName (id)))) goto yyL1;
  }
  }
  }
   return true;
 }
yyL1:;

  return false;
}

bool IsParallelLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_FORALL) {
# line 278 "Loops.puma"
   return true;

  }
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
# line 281 "Loops.puma"
   return true;

  }
  }
  if (loop->Kind == kDO_EXP) {
# line 284 "Loops.puma"
   return true;

  }
  if (loop->Kind == kDO_VAR) {
# line 287 "Loops.puma"
   return true;

  }
  return false;
}

bool HasOuterParallelLoop
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
# line 298 "Loops.puma"
 {
  bool parloop;
  {
# line 299 "Loops.puma"

# line 301 "Loops.puma"
 int i;
      parloop = false;
 
      for (i=1; i<= OuterLoops(); i++)
        parloop = parloop || IsParallelLoop (GetOuterLoop(i));
    
# line 307 "Loops.puma"
   if (! ((parloop))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

bool FreeLoopIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index_exp, register tTree var)
# else
(index_exp, var)
 register tTree index_exp;
 register tTree var;
# endif
{
# line 322 "Loops.puma"
 {
  int lnr;
  tTree loop;
  bool is_free;
  {
# line 324 "Loops.puma"

# line 325 "Loops.puma"

# line 326 "Loops.puma"

# line 328 "Loops.puma"
 is_free = false;

     for (lnr=1; lnr <= OuterLoops (); lnr++)

       { loop = GetOuterLoop (lnr);

         if (IsParallelLoop (loop) && 
             IsLinearDependent (index_exp, GetLoopId (loop)))

           { if (!Dependency (var, GetLoopId (loop)))
                is_free = true;
           }
       }
   
# line 342 "Loops.puma"
   if (! ((is_free))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

bool NoParallelLoopIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index_exp)
# else
(index_exp)
 register tTree index_exp;
# endif
{
# line 353 "Loops.puma"
 {
  bool okay;
  {
# line 355 "Loops.puma"

# line 357 "Loops.puma"
 int lnr;

     okay = true;

     for (lnr=1; lnr <= OuterLoops (); lnr++)

       { tTree loop;

         loop = GetOuterLoop (lnr);

         if (IsParallelLoop (loop))

           { if (IsVarInExp (TreeVarName (GetLoopId (loop)), index_exp))

               okay = false;
           }
       }
   
# line 376 "Loops.puma"
   if (! ((okay))) goto yyL1;
  }
   return true;
 }
yyL1:;

  return false;
}

void ForallVarCheck
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
# line 392 "Loops.puma"
  {
# line 394 "Loops.puma"
 int i;
     for (i=1; i <= OuterLoops(); i++)
        ForallLoopVarCheck (GetOuterLoop(i), var);
   
  }
   return;

;
}

static void ForallLoopVarCheck
# if defined __STDC__ | defined __cplusplus
(register tTree loop, register tTree var)
# else
(loop, var)
 register tTree loop;
 register tTree var;
# endif
{
  if (loop->Kind == kACF_FORALL) {
  if (var->Kind == kUSED_VAR) {
# line 402 "Loops.puma"
  {
# line 406 "Loops.puma"
   error_protocol ("Only indexed variable in lhs of FORALL assignments");
  }
   return;

  }
  if (loop->ACF_FORALL.FORALL_ID->Kind == kLOOP_VAR) {
# line 409 "Loops.puma"
  {
# line 413 "Loops.puma"
 if (IsVarInExp (loop->ACF_FORALL.FORALL_ID->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, var) == 0)
       { error_protocol ("loop index appears not in lhs in FORALL");
         tree_protocol  ("assignment variable is ", var);
         tree_protocol  ("loop variable is ", loop->ACF_FORALL.FORALL_ID);
       }
   
  }
   return;

  }
  }
;
}

bool IsLoopInvariant
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree loop)
# else
(exp, loop)
 register tTree exp;
 register tTree loop;
# endif
{

  switch (exp->Kind) {
  case kBTE_LIST:
# line 431 "Loops.puma"
  {
# line 433 "Loops.puma"
   if (! ((IsLoopInvariant (exp->BTE_LIST.Elem, loop)))) goto yyL1;
  {
# line 434 "Loops.puma"
   if (! ((IsLoopInvariant (exp->BTE_LIST.Next, loop)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  break;
  case kBTE_EMPTY:
# line 437 "Loops.puma"
   return true;

  case kOP_EXP:
# line 440 "Loops.puma"
  {
# line 442 "Loops.puma"
   if (! ((IsLoopInvariant (exp->OP_EXP.OPND1, loop)))) goto yyL3;
  {
# line 443 "Loops.puma"
   if (! ((IsLoopInvariant (exp->OP_EXP.OPND2, loop)))) goto yyL3;
  }
  }
   return true;
yyL3:;

  break;
  case kOP1_EXP:
# line 446 "Loops.puma"
  {
# line 448 "Loops.puma"
   if (! ((IsLoopInvariant (exp->OP1_EXP.OPND, loop)))) goto yyL4;
  }
   return true;
yyL4:;

  break;
  case kCONST_EXP:
# line 451 "Loops.puma"
   return true;

  case kVAR_EXP:
# line 454 "Loops.puma"
  {
# line 456 "Loops.puma"
   if (! ((IsLoopInvariant (exp->VAR_EXP.V, loop)))) goto yyL6;
  }
   return true;
yyL6:;

  break;
  case kINDEXED_VAR:
# line 459 "Loops.puma"
  {
# line 461 "Loops.puma"
   if (! ((IsLoopInvariant (exp->INDEXED_VAR.IND_EXPS, loop)))) goto yyL7;
  {
# line 462 "Loops.puma"
   if (! ((IsLoopInvariant (exp->INDEXED_VAR.IND_VAR, loop)))) goto yyL7;
  }
  }
   return true;
yyL7:;

  break;
  case kUSED_VAR:
# line 465 "Loops.puma"
  {
# line 467 "Loops.puma"
   if (! ((IsUnchanged (exp, loop)))) goto yyL8;
  }
   return true;
yyL8:;

  break;
  case kLOOP_VAR:
# line 470 "Loops.puma"
  {
# line 472 "Loops.puma"
   if (! ((IsUnchanged (exp, loop)))) goto yyL9;
  }
   return true;
yyL9:;

  break;
  case kSLICE_EXP:
# line 475 "Loops.puma"
  {
# line 477 "Loops.puma"
   if (! ((IsLoopInvariant (exp->SLICE_EXP.START, loop)))) goto yyL10;
  {
# line 478 "Loops.puma"
   if (! ((IsLoopInvariant (exp->SLICE_EXP.STOP, loop)))) goto yyL10;
  {
# line 479 "Loops.puma"
   if (! ((IsLoopInvariant (exp->SLICE_EXP.INC, loop)))) goto yyL10;
  }
  }
  }
   return true;
yyL10:;

  break;
  case kDUMMY_EXP:
# line 482 "Loops.puma"
   return true;

  case kFUNC_CALL_EXP:
# line 485 "Loops.puma"
   return true;

  }

  return false;
}

static bool IsUnchanged
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stmt)
# else
(var, stmt)
 register tTree var;
 register tTree stmt;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
# line 498 "Loops.puma"
  {
# line 500 "Loops.puma"
   if (! ((IsUnchanged (var, stmt->ACF_LIST.Elem)))) goto yyL1;
  {
# line 501 "Loops.puma"
   if (! ((IsUnchanged (var, stmt->ACF_LIST.Next)))) goto yyL1;
  }
  }
   return true;
yyL1:;

  break;
  case kACF_EMPTY:
# line 504 "Loops.puma"
   return true;

  case kACF_DO:
# line 507 "Loops.puma"
  {
# line 509 "Loops.puma"
   if (! ((TreeVarName (var) != TreeVarName (stmt->ACF_DO.DO_ID)))) goto yyL3;
  {
# line 511 "Loops.puma"
   if (! ((IsUnchanged (var, stmt->ACF_DO.DO_BODY)))) goto yyL3;
  }
  }
   return true;
yyL3:;

  break;
  case kACF_FORALL:
# line 514 "Loops.puma"
  {
# line 516 "Loops.puma"
   if (! ((TreeVarName (var) != TreeVarName (stmt->ACF_FORALL.FORALL_ID)))) goto yyL4;
  {
# line 518 "Loops.puma"
   if (! ((IsUnchanged (var, stmt->ACF_FORALL.FORALL_BODY)))) goto yyL4;
  }
  }
   return true;
yyL4:;

  break;
  case kACF_WHILE:
# line 522 "Loops.puma"
  {
# line 524 "Loops.puma"
   if (! ((IsUnchanged (var, stmt->ACF_WHILE.WHILE_BODY)))) goto yyL5;
  }
   return true;
yyL5:;

  break;
  case kACF_IF:
# line 527 "Loops.puma"
  {
# line 529 "Loops.puma"
   if (! ((IsUnchanged (var, stmt->ACF_IF.THEN_PART)))) goto yyL6;
  {
# line 530 "Loops.puma"
   if (! ((IsUnchanged (var, stmt->ACF_IF.ELSE_PART)))) goto yyL6;
  }
  }
   return true;
yyL6:;

  break;
  case kACF_HOME:
# line 533 "Loops.puma"
  {
# line 535 "Loops.puma"
   if (! ((IsUnchanged (var, stmt->ACF_HOME.HOME_BODY)))) goto yyL7;
  }
   return true;
yyL7:;

  break;
  case kACF_NEW:
# line 538 "Loops.puma"
  {
# line 540 "Loops.puma"
   if (! ((IsUnchanged (var, stmt->ACF_NEW.NEW_BODY)))) goto yyL8;
  }
   return true;
yyL8:;

  break;
  case kACF_RESIDENT:
# line 543 "Loops.puma"
  {
# line 545 "Loops.puma"
   if (! ((IsUnchanged (var, stmt->ACF_RESIDENT.RESIDENT_BODY)))) goto yyL9;
  }
   return true;
yyL9:;

  break;
  case kACF_REDUCTION:
# line 548 "Loops.puma"
  {
# line 550 "Loops.puma"
   if (! ((IsUnchanged (var, stmt->ACF_REDUCTION.REDUCTION_BODY)))) goto yyL10;
  }
   return true;
yyL10:;

  break;
  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 553 "Loops.puma"
  {
# line 555 "Loops.puma"
   if (! ((TreeVarName (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR) != TreeVarName (var)))) goto yyL11;
  }
   return true;
yyL11:;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
# line 558 "Loops.puma"
   return true;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
# line 561 "Loops.puma"
   return true;

  }
# line 564 "Loops.puma"
  {
# line 566 "Loops.puma"
   return false;
  }

  }

  return false;
}

void BeginLoops ()
{
}

void CloseLoops ()
{
}
