# include "Localization.h"
# include "yyLocalization.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 23 "Localization.puma"


# include <stdio.h>
# include "Idents.h"
# include "StringMem.h"
# include "Types.h"
# include "protocol.h"

# include "FArguments.h"
# include "Transform.h"         /* ReplaceDECL, ...    */
# include "Expressions.h"       /* MakeConstant, ...   */
# include "Dalib.h"             /* MakeVarDeclA, ...   */
# include "Shapes.h"            /* MakeFullShape, ...  */

# include "Traverse.h"          /* ReplaceAST, ...     */

# include "PseudoDynamic.h"     /* MakeVarDeclA, ...   */
# include "CodeMapping.h"       /* DalibArrayAllocate  */
# include "CodeGeneral.h"       /* DalibArrayAllocate  */
# include "Distributions.h"

# include "DefTable.h"

# include "VarDescriptor.h"

# define MODULE "Localization"



static void yyExit () { Exit (1); }

void (* Localization_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Localization, routine %s failed\n", yyFunction);
 Localization_Exit ();
}

static bool IsFullDynamic ARGS((tDefinitions obj));
static bool IsPseudoDynamic ARGS((tDefinitions obj));
static bool IsNoDynamic ARGS((tDefinitions obj));
void Localize ARGS((tTree t));
static bool localize_pred ARGS((tTree t));
static tTree localize_func ARGS((tTree t));
static tTree LocalizeVarDecl ARGS((tTree t, tDefinitions obj));
static tTree MakeAllocatableArray ARGS((tTree type));
static tTree TranslateAllocate ARGS((tTree stmt, tTree v));
static void CheckUpIndexedAccess ARGS((tTree var));
static void LocalizeIndexedAccess ARGS((tTree var));
static bool IsMappedDim ARGS((int dist_kind, tTree dist_size));
static bool IsCyclicOne ARGS((int dist_kind, tTree dist_size));
static void GlobalToLocalIndex ARGS((tTree indexes, int pos, int dim, tIdent id));
static bool IsLegalObject ARGS((tTree var_obj));

static bool IsFullDynamic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 82 "Localization.puma"
  {
# line 83 "Localization.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 84 "Localization.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
# line 87 "Localization.puma"
  {
# line 89 "Localization.puma"
   if (! ((obj->VarObject.Kind->VarLocal.dynamic != 0))) goto yyL2;
  {
# line 90 "Localization.puma"
   if (! ((! FortranNoDynamicArrays ()))) goto yyL2;
  }
  }
   return true;
yyL2:;

# line 93 "Localization.puma"
  {
# line 95 "Localization.puma"
   if (! ((obj->VarObject.Kind->VarLocal.dynamic == 0))) goto yyL3;
  {
# line 96 "Localization.puma"
   if (! (((VarDistribution (obj) == 1) || IsDynamic (obj)))) goto yyL3;
  {
# line 97 "Localization.puma"
   if (! ((! FortranNoDynamicArrays ()))) goto yyL3;
  }
  }
  }
   return true;
yyL3:;

  }
  }
  return false;
}

static bool IsPseudoDynamic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 108 "Localization.puma"
  {
# line 109 "Localization.puma"
   if (! ((obj == NoObject))) goto yyL1;
  {
# line 110 "Localization.puma"
   return false;
  }
  }
yyL1:;

  if (obj->Kind == kVarObject) {
# line 113 "Localization.puma"
  {
# line 114 "Localization.puma"
   if (! ((! FixedSizeArray (obj)))) goto yyL2;
  }
   return true;
yyL2:;

  }
  return false;
}

static bool IsNoDynamic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
# line 125 "Localization.puma"
  {
# line 126 "Localization.puma"
   if (! ((obj == NoObject))) goto yyL1;
  }
   return true;
yyL1:;

# line 129 "Localization.puma"
  {
# line 130 "Localization.puma"
   if (! ((FixedSizeArray (obj)))) goto yyL2;
  }
   return true;
yyL2:;

  return false;
}

void Localize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
# line 145 "Localization.puma"
  {
# line 147 "Localization.puma"
 t->BODY_NODE.DECLS = ReplaceAST (t->BODY_NODE.DECLS, localize_pred, localize_func); 
     t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, localize_pred, localize_func); 
   
  }
   return;

  }
# line 152 "Localization.puma"
  {
# line 153 "Localization.puma"
   failure_protocol (MODULE, "Localize", t);
  }
   return;

;
}

static bool localize_pred
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
# line 168 "Localization.puma"
   return true;

  }
  if (t->Kind == kCOMMON_DECL) {
# line 171 "Localization.puma"
   return true;

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
# line 174 "Localization.puma"
   return true;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
# line 177 "Localization.puma"
   return true;

  }
  }
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 180 "Localization.puma"
   return true;

  }
  }
  return false;
}

static tTree localize_func
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 193 "Localization.puma"
   return LocalizeVarDecl (t, GetLocalObject (t->VAR_DECL.Ident));

  }
  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS->Kind == kBTP_LIST) {
  if (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 202 "Localization.puma"
   return TranslateAllocate (t, t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS->BTP_LIST.Elem->VAR_PARAM.V);

  }
  }
  }
  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS->Kind == kBTP_LIST) {
  if (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 208 "Localization.puma"
   return NoTree;

  }
  }
  }
  }
  }
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 214 "Localization.puma"
  {
# line 216 "Localization.puma"
   if (! ((IsPseudoDynamic (t->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL4;
  {
# line 217 "Localization.puma"
 t->VAR_PARAM.V = FirstArrayElement (MakeFullShape (t->VAR_PARAM.V)); 
     LocalizeIndexedAccess (t->VAR_PARAM.V);
     CheckUpIndexedAccess (t->VAR_PARAM.V);
   
  }
  }
   return t;
yyL4:;

  }
  }
  if (t->Kind == kINDEXED_VAR) {
# line 224 "Localization.puma"
  {
# line 226 "Localization.puma"
   LocalizeIndexedAccess (t);
# line 227 "Localization.puma"
   CheckUpIndexedAccess (t);
  }
   return t;

  }
# line 231 "Localization.puma"
   return t;

}

static tTree LocalizeVarDecl
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions obj)
# else
(t, obj)
 register tTree t;
 register tDefinitions obj;
# endif
{
  if (t->Kind == kVAR_DECL) {
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 244 "Localization.puma"
  {
# line 246 "Localization.puma"
   if (! ((IsFullDynamic (obj)))) goto yyL1;
  {
# line 247 "Localization.puma"
 if (!IsVarAllocatable(obj))
       t->VAR_DECL.VAL = MakeAllocatableArray (t->VAR_DECL.VAL); 
   
  }
  }
   return t;
yyL1:;

# line 253 "Localization.puma"
  {
# line 255 "Localization.puma"
   if (! ((IsPseudoDynamic (obj)))) goto yyL2;
  }
   return MakePseudoDynamicArray (t);
yyL2:;

  }
  }
# line 259 "Localization.puma"
  {
# line 260 "Localization.puma"
   if (! ((IsNoDynamic (obj)))) goto yyL3;
  }
   return t;
yyL3:;

# line 264 "Localization.puma"
  {
# line 265 "Localization.puma"
   obj_error_protocol ("dynamic kind is unknown", obj);
# line 266 "Localization.puma"
   failure_protocol (MODULE, "LocalizeVarDecl", t);
  }
   return t;

}

static tTree MakeAllocatableArray
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
  if (type->Kind == kARRAY_TYPE) {
# line 280 "Localization.puma"
   return mARRAY_TYPE (MakeAllocatableArray (type->ARRAY_TYPE.ARRAY_INDEX_TYPES), type->ARRAY_TYPE.ARRAY_COMP_TYPE);

  }
  if (type->Kind == kSHAPE_LIST) {
  if (type->SHAPE_LIST.Elem->Kind == kEXPLICIT_SHAPE) {
# line 284 "Localization.puma"
 {
  tTree new;
  {
# line 285 "Localization.puma"

# line 286 "Localization.puma"
 new = mDEFERRED_SHAPE ();
     
     new->DEFERRED_SHAPE.Overlap = type->SHAPE_LIST.Elem->EXPLICIT_SHAPE.Overlap;
   
  }
  {
   return mSHAPE_LIST (new, MakeAllocatableArray (type->SHAPE_LIST.Next));
  }
 }

  }
  }
  if (type->Kind == kSHAPE_EMPTY) {
# line 293 "Localization.puma"
   return type;

  }
# line 297 "Localization.puma"
  {
# line 298 "Localization.puma"
   failure_protocol (MODULE, "MakeAllocatableArray", type);
  }
   return type;

}

static tTree TranslateAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree v)
# else
(stmt, v)
 register tTree stmt;
 register tTree v;
# endif
{
  if (v->Kind == kUSED_VAR) {
# line 317 "Localization.puma"
   return DalibArrayAllocate (v, kALLOCATE_DSP);

  }
  if (v->Kind == kINDEXED_VAR) {
# line 322 "Localization.puma"
   return DalibArrayAllocate (v->INDEXED_VAR.IND_VAR, kALLOCATE_DSP);

  }
# line 327 "Localization.puma"
  {
# line 329 "Localization.puma"
   failure_protocol (MODULE, "TranslateAllocate", v);
  }
   return NoTree;

}

static void CheckUpIndexedAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
  if (var->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 341 "Localization.puma"
  {
# line 342 "Localization.puma"
   if (! ((IsPseudoDynamic (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL1;
  {
# line 343 "Localization.puma"
   PseudoDynamicIndexing (var);
  }
  }
   return;
yyL1:;

  }
  if (var->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
# line 346 "Localization.puma"
  {
# line 347 "Localization.puma"
   if (! ((IsPseudoDynamic (var->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELECTOR->REC_COMP.Object)))) goto yyL2;
  }
   return;
yyL2:;

  }
  }
;
}

static void LocalizeIndexedAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
  if (var->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 359 "Localization.puma"
 {
  var_descriptor vard;
  int i;
  {
# line 361 "Localization.puma"
   if (! ((IsLegalObject (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME)))) goto yyL1;
  {
# line 363 "Localization.puma"

# line 364 "Localization.puma"

# line 366 "Localization.puma"
   SetVarDescriptor (var, & vard);
# line 368 "Localization.puma"
 for (i=0; i < vard.formal_rank; i++)

       { if (IsMappedDim (vard.distribution_kind[i],
                          vard.distribution_size[i]) )

            GlobalToLocalIndex (var->INDEXED_VAR.IND_EXPS, 1, i+1, var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
    
       }
  
  }
  }
   return;
 }
yyL1:;

  }
  }
;
}

static bool IsMappedDim
# if defined __STDC__ | defined __cplusplus
(register int dist_kind, register tTree dist_size)
# else
(dist_kind, dist_size)
 register int dist_kind;
 register tTree dist_size;
# endif
{
# line 390 "Localization.puma"
  {
# line 392 "Localization.puma"
   if (! ((dist_kind == kINDIRECT_DIM))) goto yyL1;
  }
   return true;
yyL1:;

# line 395 "Localization.puma"
  {
# line 397 "Localization.puma"
   if (! ((dist_kind == kARBITRARY_DIM))) goto yyL2;
  }
   return true;
yyL2:;

# line 400 "Localization.puma"
  {
# line 402 "Localization.puma"
   if (! ((dist_kind == kCYCLIC_DIM))) goto yyL3;
  {
# line 403 "Localization.puma"
   if (! ((! IsCyclicOne (dist_kind, dist_size)))) goto yyL3;
  }
  }
   return true;
yyL3:;

  return false;
}

static bool IsCyclicOne
# if defined __STDC__ | defined __cplusplus
(register int dist_kind, register tTree dist_size)
# else
(dist_kind, dist_size)
 register int dist_kind;
 register tTree dist_size;
# endif
{
# line 408 "Localization.puma"
  {
# line 410 "Localization.puma"
   if (! ((dist_kind == kCYCLIC_DIM))) goto yyL1;
  {
# line 411 "Localization.puma"
   if (! ((dist_size == NoTree))) goto yyL1;
  }
  }
   return true;
yyL1:;

# line 414 "Localization.puma"
 {
  bool found;
  int val;
  {
# line 416 "Localization.puma"

# line 417 "Localization.puma"

# line 419 "Localization.puma"
   if (! ((dist_kind == kCYCLIC_DIM))) goto yyL2;
  {
# line 420 "Localization.puma"
   if (! ((dist_size != NoTree))) goto yyL2;
  {
# line 422 "Localization.puma"
   GetIntConstValue (dist_size, & found, & val);
# line 424 "Localization.puma"
   if (! ((found))) goto yyL2;
  {
# line 425 "Localization.puma"
   if (! ((val == 1))) goto yyL2;
  }
  }
  }
  }
   return true;
 }
yyL2:;

  return false;
}

static void GlobalToLocalIndex
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int pos, register int dim, register tIdent id)
# else
(indexes, pos, dim, id)
 register tTree indexes;
 register int pos;
 register int dim;
 register tIdent id;
# endif
{
  if (indexes->Kind == kBTE_LIST) {
# line 430 "Localization.puma"
  {
# line 432 "Localization.puma"
   if (! ((pos < dim))) goto yyL1;
  {
# line 434 "Localization.puma"
   GlobalToLocalIndex (indexes->BTE_LIST.Next, pos + 1, dim, id);
  }
  }
   return;
yyL1:;

# line 437 "Localization.puma"
  {
# line 439 "Localization.puma"
   if (! ((pos == dim))) goto yyL2;
  {
# line 441 "Localization.puma"
 indexes->BTE_LIST.Elem = DalibGlobalToLocal (id, dim, indexes->BTE_LIST.Elem); 
  }
  }
   return;
yyL2:;

  }
;
}

static bool IsLegalObject
# if defined __STDC__ | defined __cplusplus
(register tTree var_obj)
# else
(var_obj)
 register tTree var_obj;
# endif
{
  if (var_obj->Kind == kVAR_OBJ) {
# line 447 "Localization.puma"
  {
# line 449 "Localization.puma"
   if (! ((var_obj->VAR_OBJ.Object == NoObject))) goto yyL1;
  {
# line 450 "Localization.puma"
   return false;
  }
  }
yyL1:;

# line 453 "Localization.puma"
  {
# line 455 "Localization.puma"
   if (! ((var_obj->VAR_OBJ.Reaching == NoTree))) goto yyL2;
  {
# line 456 "Localization.puma"
   return false;
  }
  }
yyL2:;

# line 459 "Localization.puma"
   return true;

  }
  return false;
}

void BeginLocalization ()
{
}

void CloseLocalization ()
{
}
