# include "Invariant.h"
# include "yyInvariant.w"
# include "System.h"
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 54 "Invariant.puma"


# define MODULE "Invariant"

# include "Idents.h"
# include "StringMem.h"

# include "Expressions.h"
# include "Nesting.h"
# include "Dependences.h"
# include "Loops.h"
# include "Intrinsics.h"
# include "Rank.h"
# include "TreeOps.h"
# include "Objects.h"

# include "protocol.h"

      /***********************************************************
      *  global data for Var Var Dependences                     *
      ***********************************************************/

static ptree loop_nest;           /* pointers to surrounding loops  */
static int   loop_depth;          /* number of surrounding loops    */

static PredVector loop_pv;        /* predicate used for dependences */



static void yyExit () { Exit (1); }

void (* Invariant_Exit) () = yyExit;

static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Invariant, routine %s failed\n", yyFunction);
 Invariant_Exit ();
}

int ForallVarExpDependences ARGS((tTree var, tTree exp));
static int VarExpDependences ARGS((tTree var, tTree exp));
static int VarScatterDependences ARGS((tTree var, tTree scatter_params));
static int VarVarDependences ARGS((tTree var1, tTree var2));
static bool NonOverlappingIndexes ARGS((tTree indexes1, tTree indexes2));
void ResolveLoopVar ARGS((tTree exp, tTree id, bool * yyP2, int * yyP1));
static void CombineTimes ARGS((tTree e1, int val1, tTree e2, int val2, bool * yyP4, int * yyP3));
void MakeVector ARGS((tTree exp, tTree id, int c, tTree slice, tTree * yyP7, tTree * yyP6, tTree * yyP5));
static tTree MakeNewIncrement ARGS((tTree inc, int cval));
static tTree Replace ARGS((tTree exp, tTree id, tTree newexp));

int ForallVarExpDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
# line 94 "Invariant.puma"
  {
# line 96 "Invariant.puma"
 bool stop;
     int  common_loops, const_loops;
     int  i;

     

     loop_depth = OuterLoops ();
     loop_nest  = GetAllOuterLoops ();

     

     stop = (loop_depth == 0);

     while (!stop)
 
       { stop = IsForallLoop (loop_nest[0]);
         if (!stop)
           { loop_nest++;
             loop_depth--;
             stop = (loop_depth == 0);
           }
       }
 
     

     common_loops = 0;
     const_loops  = 0;

     

     PVMakeForLoopNest (loop_depth, common_loops, const_loops, &loop_pv);

     

     for (i=0; i<loop_depth; i++)

        if (IsIndepLoop (loop_nest[i]))

            PVAndComponent (&loop_pv, i+1, 0, 0);

   
  }
   return VarExpDependences (var, exp);

}

static int VarExpDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
  if (var->Kind == kUSED_VAR) {
# line 149 "Invariant.puma"
  {
# line 151 "Invariant.puma"
   if (! ((TreeRank (var) == 0))) goto yyL1;
  }
   return 0;
yyL1:;

  }
# line 155 "Invariant.puma"
  {
# line 156 "Invariant.puma"
   if (! ((exp == NoTree))) goto yyL2;
  }
   return 0;
yyL2:;


  switch (exp->Kind) {
  case kUSED_VAR:
# line 160 "Invariant.puma"
   return 0;

  case kLOOP_VAR:
# line 164 "Invariant.puma"
   return 0;

  case kINDEXED_VAR:
# line 168 "Invariant.puma"
   return VarVarDependences (var, exp);

  case kSUBSTRING_VAR:
# line 172 "Invariant.puma"
   return VarVarDependences (var, exp);

  case kSELECTED_VAR:
# line 176 "Invariant.puma"
   return VarVarDependences (var, exp);

  case kVAR_EXP:
# line 180 "Invariant.puma"
   return VarExpDependences (var, exp->VAR_EXP.V);

  case kTYPE_EXP:
# line 184 "Invariant.puma"
   return VarExpDependences (var, exp->TYPE_EXP.ELEMENTS);

  case kBTE_LIST:
# line 188 "Invariant.puma"
   return (VarExpDependences (var, exp->BTE_LIST.Elem) + VarExpDependences (var, exp->BTE_LIST.Next));

  case kBTE_EMPTY:
# line 192 "Invariant.puma"
   return 0;

  case kSLICE_EXP:
# line 196 "Invariant.puma"
   return (VarExpDependences (var, exp->SLICE_EXP.START) + VarExpDependences (var, exp->SLICE_EXP.STOP) + VarExpDependences (var, exp->SLICE_EXP.INC));

  case kDUMMY_EXP:
# line 201 "Invariant.puma"
   return 0;

  case kCONST_EXP:
# line 205 "Invariant.puma"
   return 0;

  case kBOUND_EXP:
# line 209 "Invariant.puma"
   return 0;

  case kRANK_EXP:
# line 213 "Invariant.puma"
   return 0;

  case kADDR:
# line 217 "Invariant.puma"
   return (VarExpDependences (var, exp->ADDR.E));

  case kOP_EXP:
# line 221 "Invariant.puma"
   return (VarExpDependences (var, exp->OP_EXP.OPND1) + VarExpDependences (var, exp->OP_EXP.OPND2));

  case kOP1_EXP:
# line 225 "Invariant.puma"
   return (VarExpDependences (var, exp->OP1_EXP.OPND));

  case kPERM_EXP:
# line 229 "Invariant.puma"
  {
# line 230 "Invariant.puma"
   if (! ((IsVarInExp (TreeVarName (var), exp->PERM_EXP.VAL)))) goto yyL20;
  }
   return 1;
yyL20:;

# line 234 "Invariant.puma"
   return 0;

  case kARRAY_EXP:
# line 238 "Invariant.puma"
   return VarExpDependences (var, exp->ARRAY_EXP.ELEMENTS);

  case kDO_EXP:
# line 242 "Invariant.puma"
   return VarExpDependences (var, exp->DO_EXP.RANGE) + VarExpDependences (var, exp->DO_EXP.BODY);

  case kFUNC_CALL_EXP:
# line 246 "Invariant.puma"
  {
# line 248 "Invariant.puma"
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL24;
  {
# line 249 "Invariant.puma"
   if (! ((IntrFuncElemental (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL24;
  }
  }
   return VarExpDependences (var, exp->FUNC_CALL_EXP.FUNC_PARAMS);
yyL24:;

# line 254 "Invariant.puma"
  {
# line 256 "Invariant.puma"
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL25;
  {
# line 257 "Invariant.puma"
   if (! ((IntrFuncScatter (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL25;
  }
  }
   return VarScatterDependences (var, exp->FUNC_CALL_EXP.FUNC_PARAMS);
yyL25:;

# line 262 "Invariant.puma"
  {
# line 264 "Invariant.puma"
   if (! ((IsVarInExp (TreeVarName (var), exp->FUNC_CALL_EXP.FUNC_PARAMS)))) goto yyL26;
  }
   return 1;
yyL26:;

# line 268 "Invariant.puma"
   return 0;

  case kBTP_LIST:
# line 273 "Invariant.puma"
   return (VarExpDependences (var, exp->BTP_LIST.Elem) + VarExpDependences (var, exp->BTP_LIST.Next));

  case kBTP_EMPTY:
# line 277 "Invariant.puma"
   return 0;

  case kVAR_PARAM:
# line 281 "Invariant.puma"
   return (VarExpDependences (var, exp->VAR_PARAM.V));

  case kNO_PARAM:
# line 285 "Invariant.puma"
   return 0;

  }

# line 289 "Invariant.puma"
  {
# line 290 "Invariant.puma"
   failure2_protocol (MODULE, "VarExpDependences", var, exp);
  }
   return 0;

}

static int VarScatterDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree scatter_params)
# else
(var, scatter_params)
 register tTree var;
 register tTree scatter_params;
# endif
{
  if (scatter_params->Kind == kBTP_LIST) {
  if (scatter_params->BTP_LIST.Next->Kind == kBTP_LIST) {
# line 304 "Invariant.puma"
  {
# line 306 "Invariant.puma"
   if (! ((IsVarInExp (TreeVarName (var), scatter_params->BTP_LIST.Elem)))) goto yyL1;
  }
   return 1;
yyL1:;

# line 311 "Invariant.puma"
  {
# line 313 "Invariant.puma"
   if (! ((IsVarInExp (TreeVarName (var), scatter_params->BTP_LIST.Next->BTP_LIST.Next)))) goto yyL2;
  }
   return 1;
yyL2:;

# line 318 "Invariant.puma"
   return VarExpDependences (var, scatter_params->BTP_LIST.Next->BTP_LIST.Elem);

  }
  }
 yyAbort ("VarScatterDependences");
}

static int VarVarDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register tTree var2)
# else
(var1, var2)
 register tTree var1;
 register tTree var2;
# endif
{
# line 333 "Invariant.puma"
  {
# line 334 "Invariant.puma"
   if (! ((TreeVarName (var1) != TreeVarName (var2)))) goto yyL1;
  }
   return 0;
yyL1:;

  if (var2->Kind == kUSED_VAR) {
# line 338 "Invariant.puma"
   return 0;

  }
  if (var2->Kind == kLOOP_VAR) {
# line 342 "Invariant.puma"
   return 0;

  }
  if (var1->Kind == kSUBSTRING_VAR) {
  if (var2->Kind == kSUBSTRING_VAR) {
# line 346 "Invariant.puma"
  {
# line 347 "Invariant.puma"
   if (! ((EqualExpression (var1->SUBSTRING_VAR.IND_EXP, var2->SUBSTRING_VAR.IND_EXP)))) goto yyL4;
  }
   return 0;
yyL4:;

  }
  }
  if (var1->Kind == kINDEXED_VAR) {
  if (var2->Kind == kINDEXED_VAR) {
# line 354 "Invariant.puma"
  {
# line 368 "Invariant.puma"
   if (! ((loop_depth == 0))) goto yyL5;
  {
# line 369 "Invariant.puma"
   if (! ((NonOverlappingIndexes (var1->INDEXED_VAR.IND_EXPS, var2->INDEXED_VAR.IND_EXPS)))) goto yyL5;
  }
  }
   return 0;
yyL5:;

# line 374 "Invariant.puma"
  {
# line 376 "Invariant.puma"
   if (! ((EqualIndexes (var1->INDEXED_VAR.IND_EXPS, var2->INDEXED_VAR.IND_EXPS)))) goto yyL6;
  }
   return 0;
yyL6:;

# line 381 "Invariant.puma"
 {
  int deps;
  {
# line 383 "Invariant.puma"

# line 385 "Invariant.puma"
 PredVector pv;
 
     pv = loop_pv;    

     

     Dependences (var1, loop_nest, loop_depth, 
                  var2, loop_nest, loop_depth, loop_depth, 0, &pv);

     

     if (PVIsFalse (&pv))
        deps = 0;
      else if (PVIsZero (&pv))  
        { if (NonOverlappingIndexes (var1->INDEXED_VAR.IND_EXPS, var2->INDEXED_VAR.IND_EXPS))
            deps = 0;
           else
            deps = 1;
        }
      else
        deps = 1;
   
  }
  {
   return deps;
  }
 }

  }
  }
  if (var1->Kind == kSELECTED_VAR) {
  if (var2->Kind == kSELECTED_VAR) {
# line 416 "Invariant.puma"
   return 0;

  }
  }
# line 424 "Invariant.puma"
   return 1;

}

static bool NonOverlappingIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes1, register tTree indexes2)
# else
(indexes1, indexes2)
 register tTree indexes1;
 register tTree indexes2;
# endif
{
  if (indexes1->Kind == kBTE_LIST) {
  if (indexes2->Kind == kBTE_LIST) {
# line 439 "Invariant.puma"
  {
# line 441 "Invariant.puma"
   if (! ((TreeRank (indexes1->BTE_LIST.Elem) == 0))) goto yyL1;
  {
# line 442 "Invariant.puma"
   if (! ((TreeRank (indexes2->BTE_LIST.Elem) == 0))) goto yyL1;
  {
# line 444 "Invariant.puma"
   if (! ((NonOverlappingIndexes (indexes1->BTE_LIST.Next, indexes2->BTE_LIST.Next)))) goto yyL1;
  }
  }
  }
   return true;
yyL1:;

# line 447 "Invariant.puma"
  {
# line 449 "Invariant.puma"
   if (! ((EqualExpression (indexes1->BTE_LIST.Elem, indexes2->BTE_LIST.Elem)))) goto yyL2;
  {
# line 450 "Invariant.puma"
   if (! ((NonOverlappingIndexes (indexes1->BTE_LIST.Next, indexes2->BTE_LIST.Next)))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  }
  if (indexes1->Kind == kBTE_EMPTY) {
  if (indexes2->Kind == kBTE_EMPTY) {
# line 453 "Invariant.puma"
   return true;

  }
  }
  return false;
}

void ResolveLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id, register bool * yyP2, register int * yyP1)
# else
(exp, id, yyP2, yyP1)
 register tTree exp;
 register tTree id;
 register bool * yyP2;
 register int * yyP1;
# endif
{
# line 468 "Invariant.puma"
 {
  bool found;
  int val;
  {
# line 470 "Invariant.puma"

# line 470 "Invariant.puma"

# line 472 "Invariant.puma"
   GetIntConstValue (exp, & found, & val);
# line 473 "Invariant.puma"
   if (! ((found))) goto yyL1;
  }
   * yyP2 = true;
   * yyP1 = 0;
   return;
 }
yyL1:;


  switch (exp->Kind) {
  case kLOOP_VAR:
  if (id->Kind == kLOOP_VAR) {
# line 476 "Invariant.puma"
  {
# line 478 "Invariant.puma"
   if (! ((exp->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident == id->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident))) goto yyL2;
  }
   * yyP2 = true;
   * yyP1 = 1;
   return;
yyL2:;

# line 481 "Invariant.puma"
   * yyP2 = true;
   * yyP1 = 0;
   return;

  }
  break;
  case kUSED_VAR:
  if (id->Kind == kLOOP_VAR) {
# line 485 "Invariant.puma"
  {
# line 487 "Invariant.puma"
   if (! ((exp->USED_VAR.VARNAME->VAR_OBJ.Ident == id->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident))) goto yyL4;
  }
   * yyP2 = true;
   * yyP1 = 1;
   return;
yyL4:;

# line 490 "Invariant.puma"
   * yyP2 = true;
   * yyP1 = 0;
   return;

  }
  break;
  case kINDEXED_VAR:
# line 494 "Invariant.puma"
   * yyP2 = false;
   * yyP1 = 0;
   return;

  case kVAR_EXP:
# line 497 "Invariant.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 499 "Invariant.puma"
   ResolveLoopVar (exp->VAR_EXP.V, id, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  case kOP_EXP:
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
# line 502 "Invariant.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 504 "Invariant.puma"
   ResolveLoopVar (exp->OP_EXP.OPND1, id, & yyV1, & yyV2);
# line 505 "Invariant.puma"
   ResolveLoopVar (exp->OP_EXP.OPND2, id, & yyV3, & yyV4);
# line 507 "Invariant.puma"
 yyV1 = (yyV1 && yyV3);
     yyV2 += yyV4;
   
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
# line 512 "Invariant.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  {
# line 514 "Invariant.puma"
   ResolveLoopVar (exp->OP_EXP.OPND1, id, & yyV1, & yyV2);
# line 515 "Invariant.puma"
   ResolveLoopVar (exp->OP_EXP.OPND2, id, & yyV3, & yyV4);
# line 517 "Invariant.puma"
 yyV1 = (yyV1 && yyV3);
     yyV2 -= yyV4;
   
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
# line 522 "Invariant.puma"
 {
  bool yyV1;
  int yyV2;
  bool yyV3;
  int yyV4;
  bool yyV5;
  int yyV6;
  {
# line 524 "Invariant.puma"
   ResolveLoopVar (exp->OP_EXP.OPND1, id, & yyV1, & yyV2);
# line 525 "Invariant.puma"
   ResolveLoopVar (exp->OP_EXP.OPND2, id, & yyV3, & yyV4);
# line 527 "Invariant.puma"
   if (! ((yyV1 && yyV3))) goto yyL10;
  {
# line 529 "Invariant.puma"
   if (! (((yyV2 == 0) || (yyV4 == 0)))) goto yyL10;
  {
# line 531 "Invariant.puma"
   CombineTimes (exp->OP_EXP.OPND1, yyV2, exp->OP_EXP.OPND2, yyV4, & yyV5, & yyV6);
  }
  }
  }
   * yyP2 = yyV5;
   * yyP1 = yyV6;
   return;
 }
yyL10:;

# line 534 "Invariant.puma"
   * yyP2 = false;
   * yyP1 = 0;
   return;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_DIVIDE) {
# line 537 "Invariant.puma"
   * yyP2 = false;
   * yyP1 = 0;
   return;

  }
  break;
  case kOP1_EXP:
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
# line 540 "Invariant.puma"
 {
  bool yyV1;
  int yyV2;
  {
# line 542 "Invariant.puma"
   ResolveLoopVar (exp->OP1_EXP.OPND, id, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = - yyV2;
   return;
 }

  }
  break;
  case kFUNC_CALL_EXP:
# line 545 "Invariant.puma"
   * yyP2 = false;
   * yyP1 = 0;
   return;

  case kBOUND_EXP:
# line 548 "Invariant.puma"
   * yyP2 = true;
   * yyP1 = 0;
   return;

  case kRANK_EXP:
# line 551 "Invariant.puma"
   * yyP2 = true;
   * yyP1 = 0;
   return;

  case kSLICE_EXP:
# line 554 "Invariant.puma"
   * yyP2 = false;
   * yyP1 = 0;
   return;

  }

# line 557 "Invariant.puma"
  {
# line 558 "Invariant.puma"
   failure_protocol (MODULE, "ResolveLoopVar", exp);
  }
   * yyP2 = false;
   * yyP1 = 0;
   return;

;
}

static void CombineTimes
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register int val1, register tTree e2, register int val2, register bool * yyP4, register int * yyP3)
# else
(e1, val1, e2, val2, yyP4, yyP3)
 register tTree e1;
 register int val1;
 register tTree e2;
 register int val2;
 register bool * yyP4;
 register int * yyP3;
# endif
{
# line 575 "Invariant.puma"

bool found;
int c;

  if (equalint (val2, 0)) {
# line 583 "Invariant.puma"
  {
# line 585 "Invariant.puma"
   GetIntConstValue (e2, & found, & c);
# line 586 "Invariant.puma"
   if (! ((found))) goto yyL1;
  }
   * yyP4 = true;
   * yyP3 = c * val1;
   return;
yyL1:;

  }
  if (equalint (val1, 0)) {
# line 589 "Invariant.puma"
  {
# line 591 "Invariant.puma"
   GetIntConstValue (e1, & found, & c);
# line 592 "Invariant.puma"
   if (! ((found))) goto yyL2;
  }
   * yyP4 = true;
   * yyP3 = c * val2;
   return;
yyL2:;

  }
# line 595 "Invariant.puma"
   * yyP4 = false;
   * yyP3 = 0;
   return;

;
}

void MakeVector
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id, register int c, register tTree slice, register tTree * yyP7, register tTree * yyP6, register tTree * yyP5)
# else
(exp, id, c, slice, yyP7, yyP6, yyP5)
 register tTree exp;
 register tTree id;
 register int c;
 register tTree slice;
 register tTree * yyP7;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
  if (slice->Kind == kSLICE_EXP) {
# line 624 "Invariant.puma"
 {
  tTree start;
  tTree stop;
  tTree inc;
  {
# line 626 "Invariant.puma"

# line 627 "Invariant.puma"

# line 628 "Invariant.puma"

# line 630 "Invariant.puma"
   stop = CopyTree (exp);
# line 631 "Invariant.puma"
   start = Replace (exp, id, slice->SLICE_EXP.START);
# line 632 "Invariant.puma"
   stop = Replace (stop, id, slice->SLICE_EXP.STOP);
# line 634 "Invariant.puma"
   inc = MakeNewIncrement (slice->SLICE_EXP.INC, c);
  }
   * yyP7 = start;
   * yyP6 = stop;
   * yyP5 = inc;
   return;
 }

  }
;
}

static tTree MakeNewIncrement
# if defined __STDC__ | defined __cplusplus
(register tTree inc, register int cval)
# else
(inc, cval)
 register tTree inc;
 register int cval;
# endif
{
  if (equalint (cval, 1)) {
# line 649 "Invariant.puma"
  {
# line 650 "Invariant.puma"
   if (! ((inc == NoTree))) goto yyL1;
  }
   return mDUMMY_EXP ();
yyL1:;

  }
# line 654 "Invariant.puma"
  {
# line 655 "Invariant.puma"
   if (! ((inc == NoTree))) goto yyL2;
  }
   return MakeConstant (cval);
yyL2:;

  if (inc->Kind == kDUMMY_EXP) {
  if (equalint (cval, 1)) {
# line 659 "Invariant.puma"
   return mDUMMY_EXP ();

  }
# line 663 "Invariant.puma"
   return MakeConstant (cval);

  }
# line 667 "Invariant.puma"
   return MultConstant (CopyTree (inc), cval);

}

static tTree Replace
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id, register tTree newexp)
# else
(exp, id, newexp)
 register tTree exp;
 register tTree id;
 register tTree newexp;
# endif
{

  switch (exp->Kind) {
  case kVAR_EXP:
  if (exp->VAR_EXP.V->Kind == kLOOP_VAR) {
  if (id->Kind == kLOOP_VAR) {
# line 679 "Invariant.puma"
  {
# line 681 "Invariant.puma"
   if (! ((exp->VAR_EXP.V->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident == id->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident))) goto yyL1;
  }
   return CopyTree (newexp);
yyL1:;

  }
  }
  if (exp->VAR_EXP.V->Kind == kINDEXED_VAR) {
# line 686 "Invariant.puma"
   return Replace (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS, id, newexp);

  }
# line 690 "Invariant.puma"
   return exp;

  case kBOUND_EXP:
# line 694 "Invariant.puma"
   return exp;

  case kBTE_LIST:
# line 698 "Invariant.puma"
  {
# line 699 "Invariant.puma"
 exp->BTE_LIST.Elem = Replace (exp->BTE_LIST.Elem, id, newexp);
     exp->BTE_LIST.Next = Replace (exp->BTE_LIST.Next, id, newexp);
   
  }
   return exp;

  case kBTE_EMPTY:
# line 705 "Invariant.puma"
   return exp;

  case kOP_EXP:
# line 709 "Invariant.puma"
  {
# line 710 "Invariant.puma"
 exp->OP_EXP.OPND1 = Replace (exp->OP_EXP.OPND1, id, newexp);
     exp->OP_EXP.OPND2 = Replace (exp->OP_EXP.OPND2, id, newexp);
   
  }
   return exp;

  case kOP1_EXP:
# line 717 "Invariant.puma"
  {
# line 718 "Invariant.puma"
 exp->OP1_EXP.OPND = Replace (exp->OP1_EXP.OPND, id, newexp);
   
  }
   return exp;

  case kCONST_EXP:
# line 723 "Invariant.puma"
   return exp;

  }

# line 727 "Invariant.puma"
  {
# line 728 "Invariant.puma"
   failure_protocol (MODULE, "Replace", exp);
  }
   return exp;

}

void BeginInvariant ()
{
}

void CloseInvariant ()
{
}
